/*
 * Decompiled with CFR 0.152.
 */
package Nasca;

import Nasca.ProtonLabel;
import java.util.Comparator;
import java.util.Vector;
import rdcPanda.H1CS;
import rdcPanda.Noesy;
import rdcPanda.Peak;

public class GraphNode {
    private int id = 0;
    private double csProton = 0.0;
    private double csHeavy = 0.0;
    private boolean isAsigned = false;
    private int resNo = 0;
    private String resName = "";
    private String atomName = "";
    public int asgedId = -1;
    Vector<GraphNode> vecAdj = new Vector();
    public Vector<Noesy> vecAdjNOESY = new Vector();
    public Vector<GraphNode> vecSymSet = new Vector();
    private Vector<ProtonLabel> vecMappingSet = new Vector();
    public Vector<GraphNode> vecStereoSymSet = new Vector();
    public int stereoID = -99;
    public boolean isRestrained = false;
    double bestScore = -999.9;
    public int asgedIdTemp = -1;

    public void setIsAssigned(boolean tf) {
        this.isAsigned = tf;
    }

    public void setResName(String res) {
        this.resName = res;
    }

    public void setAtomName(String atom) {
        this.atomName = atom;
    }

    public void setProtonCS(double cs_h) {
        this.csProton = cs_h;
    }

    public void setHeavyCS(double cs_heavy) {
        this.csHeavy = cs_heavy;
    }

    public void setResNo(int no) {
        this.resNo = no;
    }

    public void setIsRestrained(boolean isRsd) {
        this.isRestrained = isRsd;
    }

    public int getResNo() {
        return this.resNo;
    }

    public String getResName() {
        return this.resName;
    }

    public String getAtomName() {
        return this.atomName;
    }

    public Vector<ProtonLabel> getMappingSet() {
        return this.vecMappingSet;
    }

    public Vector<GraphNode> getAdjVec() {
        return this.vecAdj;
    }

    public boolean getIsAssigned() {
        return this.isAsigned;
    }

    public int getID() {
        return this.id;
    }

    public double getCSProton() {
        return this.csProton;
    }

    public double getCSHeavy() {
        return this.csHeavy;
    }

    public GraphNode() {
    }

    public GraphNode(int idT, double cs_H, double cs_heavy, boolean isAsged) {
        this.id = idT;
        this.csProton = cs_H;
        this.csHeavy = cs_heavy;
        this.isAsigned = isAsged;
        this.vecAdj = new Vector();
        this.vecSymSet = new Vector();
        this.vecMappingSet = new Vector();
        this.vecStereoSymSet = new Vector();
    }

    public void AddAdj(GraphNode ndNeigh) {
        int IDT = ndNeigh.getID();
        boolean isInPres = false;
        int i = 0;
        while (i < this.vecAdj.size()) {
            GraphNode nd = this.vecAdj.elementAt(i);
            int IDPre = nd.getID();
            if (IDT == IDPre) {
                isInPres = true;
            }
            ++i;
        }
        if (!isInPres) {
            this.vecAdj.add(ndNeigh);
        }
    }

    public void AddAdjNOESY(Noesy noesy) {
        boolean isInPre = false;
        double csH1Cur = noesy.getH1();
        double csH2Cur = noesy.getH2();
        double csHeavyCur = noesy.getHeavy();
        int i = 0;
        while (i < this.vecAdjNOESY.size()) {
            Noesy noesyT = this.vecAdjNOESY.elementAt(i);
            double csH1 = noesyT.getH1();
            double csH2 = noesyT.getH2();
            double csHeavy = noesyT.getHeavy();
            if (Math.abs(csH1Cur - csH1) < 0.005 && Math.abs(csH2Cur - csH2) < 0.005 && Math.abs(csHeavyCur - csHeavy) < 0.005) {
                isInPre = true;
            }
            ++i;
        }
        if (!isInPre) {
            this.vecAdjNOESY.add(noesy);
        }
    }

    public void addMappingNode(ProtonLabel label) {
        this.vecMappingSet.add(label);
    }

    public void EmptyAdjSet() {
        this.vecAdj = new Vector();
    }

    public void EmptyMappingSet() {
        this.vecMappingSet = new Vector();
    }

    public Vector<GraphNode> AddResonanceNode(Vector<GraphNode> vecOldGraph, double csH, double csHeavy, double csErrH, double csErrC, double csErrN) {
        Vector<GraphNode> vecNewGraph = new Vector<GraphNode>();
        boolean isInPres = false;
        int i = 0;
        while (i < vecOldGraph.size()) {
            GraphNode node = vecOldGraph.elementAt(i);
            double cs_Proton = node.getCSProton();
            double cs_Heavy = node.getCSHeavy();
            double csMaxHeavy = Math.max(cs_Heavy, csHeavy);
            double csErrHeavy = 0.0;
            csErrHeavy = csMaxHeavy > 80.0 ? csErrN : csErrC;
            if (!(csHeavy < -100.0) && csHeavy > -100.0 && Math.abs(csH - cs_Proton) < csErrH && Math.abs(csHeavy - cs_Heavy) < csErrHeavy) {
                isInPres = true;
                node.getIsAssigned();
            }
            ++i;
        }
        if (!isInPres) {
            GraphNode node = new GraphNode(vecOldGraph.size(), csH, csHeavy, false);
            vecOldGraph.add(node);
        }
        vecNewGraph.addAll(vecOldGraph);
        return vecNewGraph;
    }

    public Vector<GraphNode> ConstructInitResonGraphFromAsgedList(Vector<H1CS> vecAsged, Vector<H1CS> vecUnAsged) {
        GraphNode node;
        int resNoT;
        String atomT;
        double cs_Temp;
        H1CS h1csHeavy;
        String heavyName;
        int resNo;
        String atom;
        String res;
        double cs_h;
        H1CS h1cs;
        double cs_heavy;
        Vector<GraphNode> vecGraph = new Vector<GraphNode>();
        Peak pk = new Peak();
        int curId = 0;
        int i = 0;
        while (i < vecAsged.size()) {
            cs_heavy = -999.9;
            h1cs = vecAsged.elementAt(i);
            cs_h = h1cs.getH1CS();
            res = h1cs.getResidueType();
            atom = h1cs.getAtomName();
            resNo = h1cs.getResidueNo();
            if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                heavyName = pk.GetHeavyAtomFromProton(res, atom);
                int j = 0;
                while (j < vecAsged.size()) {
                    h1csHeavy = vecAsged.elementAt(j);
                    cs_Temp = h1csHeavy.getH1CS();
                    atomT = h1csHeavy.getAtomName();
                    resNoT = h1csHeavy.getResidueNo();
                    if (resNoT == resNo && atomT.equalsIgnoreCase(heavyName)) {
                        cs_heavy = cs_Temp;
                    }
                    ++j;
                }
                node = new GraphNode(curId, cs_h, cs_heavy, true);
                node.setAtomName(atom);
                node.setResName(res);
                node.setResNo(resNo);
                vecGraph.add(node);
                ++curId;
            }
            ++i;
        }
        if (vecUnAsged == null) {
            return vecGraph;
        }
        i = 0;
        while (i < vecUnAsged.size()) {
            cs_heavy = -999.9;
            h1cs = vecUnAsged.elementAt(i);
            cs_h = h1cs.getH1CS();
            res = h1cs.getResidueType();
            atom = h1cs.getAtomName();
            resNo = h1cs.getResidueNo();
            if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                heavyName = pk.GetHeavyAtomFromProton(res, atom);
                int j = 0;
                while (j < vecUnAsged.size()) {
                    h1csHeavy = vecUnAsged.elementAt(j);
                    cs_Temp = h1csHeavy.getH1CS();
                    atomT = h1csHeavy.getAtomName();
                    resNoT = h1csHeavy.getResidueNo();
                    if (resNoT == resNo && atomT.equalsIgnoreCase(heavyName)) {
                        cs_heavy = cs_Temp;
                    }
                    ++j;
                }
                node = new GraphNode(curId, cs_h, cs_heavy, false);
                node.setAtomName(" ");
                node.setResName(" ");
                node.setResNo(0);
                vecGraph.add(node);
                ++curId;
            }
            ++i;
        }
        return vecGraph;
    }

    public Vector<GraphNode> ConstructResonGraph(Vector<GraphNode> vecNodeSet, Vector<Noesy> vecNoesy, double errH1, double errH3, double errC, double errN) {
        Vector<GraphNode> vecResonGraph = new Vector<GraphNode>();
        int i = 0;
        while (i < vecNoesy.size()) {
            Noesy noesy = vecNoesy.elementAt(i);
            double errHeavy = 0.0;
            double freH1 = noesy.getH1();
            double freHeavy = noesy.getHeavy();
            double freH2 = noesy.getH2();
            errHeavy = freHeavy > 80.0 ? errN : errC;
            int j = 0;
            while (j < vecNodeSet.size()) {
                GraphNode node = vecNodeSet.elementAt(j);
                double csH = node.getCSProton();
                double csHeavy = node.getCSHeavy();
                if (!(Math.abs(csH - freH1) > errH1) && !(Math.abs(csHeavy - freHeavy) > errHeavy)) {
                    int k = 0;
                    while (k < vecNodeSet.size()) {
                        GraphNode node2;
                        double csH2;
                        if (k != j && Math.abs((csH2 = (node2 = vecNodeSet.elementAt(k)).getCSProton()) - freH2) < errH3) {
                            node.AddAdj(node2);
                            node2.AddAdj(node);
                            node.AddAdjNOESY(noesy);
                            node2.AddAdjNOESY(noesy);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        vecResonGraph.addAll(vecNodeSet);
        return vecResonGraph;
    }

    public void ConstructResonGraphSymmetry(Vector<GraphNode> vecResonGraph, Vector<Noesy> vecNoesy, double errH1, double errH3, double errC, double errN) {
        int i = 0;
        while (i < vecNoesy.size()) {
            Noesy noesy = vecNoesy.elementAt(i);
            double errHeavy = 0.0;
            double freH1 = noesy.getH1();
            double freHeavy = noesy.getHeavy();
            double freH2 = noesy.getH2();
            errHeavy = freHeavy > 80.0 ? errN : errC;
            int j = 0;
            while (j < vecResonGraph.size()) {
                GraphNode node = vecResonGraph.elementAt(j);
                double csH = node.getCSProton();
                double csHeavy = node.getCSHeavy();
                if (!(Math.abs(csH - freH1) > errH1) && !(Math.abs(csHeavy - freHeavy) > errHeavy)) {
                    int k = 0;
                    while (k < vecResonGraph.size()) {
                        GraphNode node2;
                        double csH2;
                        if (k != j && Math.abs((csH2 = (node2 = vecResonGraph.elementAt(k)).getCSProton()) - freH2) < errH3) {
                            node.vecSymSet.add(node2);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < vecResonGraph.size()) {
            GraphNode node = vecResonGraph.elementAt(i);
            Vector<GraphNode> vec_sym = node.vecSymSet;
            int k = 0;
            while (k < vec_sym.size()) {
                GraphNode ndSym = vec_sym.elementAt(k);
                Vector<GraphNode> vec_sym2 = ndSym.vecSymSet;
                boolean isSymmetry = false;
                int w = 0;
                while (w < vec_sym2.size()) {
                    GraphNode nd = vec_sym2.elementAt(w);
                    int symID = nd.getID();
                    if (symID == i) {
                        isSymmetry = true;
                    }
                    ++w;
                }
                if (!isSymmetry) {
                    vec_sym.remove(k);
                    --k;
                }
                ++k;
            }
            ++i;
        }
    }

    public static class scoreComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            GraphNode n1 = (GraphNode)o1;
            GraphNode n2 = (GraphNode)o2;
            double d1 = n1.bestScore;
            double d2 = n2.bestScore;
            if (d1 > d2) {
                return -1;
            }
            if (d1 < d2) {
                return 1;
            }
            return 0;
        }
    }
}

