/*
 * Decompiled with CFR 0.152.
 */
package Nasca;

import Nasca.GraphNode;
import java.util.Vector;
import rdcPanda.Cartesian;
import rdcPanda.Pdb;
import rdcPanda.Peak;

public class ProtonLabel {
    private int id = -1;
    private int resNo = -1;
    private String resName = "";
    private String atomName = "";
    private Vector<Cartesian> vecRotCoords = new Vector();
    public boolean isAsigned = false;
    public int asgedId = -1;
    public boolean isRestrained = false;
    public Vector<ProtonLabel> vecAdj = new Vector();
    public Vector<ProtonLabel> vecCloseAdj = new Vector();
    public Vector<GraphNode> vecMappingSet = new Vector();
    public int stereoID = -99;

    public ProtonLabel() {
    }

    public ProtonLabel(int idT, int resIDT, String res, String atom, Vector<Cartesian> vecAtom) {
        this.id = idT;
        this.resNo = resIDT;
        this.resName = res;
        this.atomName = atom;
        this.vecRotCoords.addAll(vecAtom);
        this.isAsigned = atom.equalsIgnoreCase("CA") || atom.equalsIgnoreCase("N") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H") || atom.equalsIgnoreCase("HA") || atom.equalsIgnoreCase("HA1") || atom.equalsIgnoreCase("HA2") || atom.equalsIgnoreCase("HA3") || atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("CB");
        this.vecAdj = new Vector();
        this.vecCloseAdj = new Vector();
    }

    public Vector<ProtonLabel> getAdjVec() {
        return this.vecAdj;
    }

    public boolean getIsAssigned() {
        return this.isAsigned;
    }

    public int getID() {
        return this.id;
    }

    public int getResNo() {
        return this.resNo;
    }

    public String getResName() {
        return this.resName;
    }

    public String getAtomName() {
        return this.atomName;
    }

    public Vector<Cartesian> getRotCoords() {
        return this.vecRotCoords;
    }

    public Vector<GraphNode> getMappingSet() {
        return this.vecMappingSet;
    }

    public void setIsRestrained(boolean isRsd) {
        this.isRestrained = isRsd;
    }

    public void setID(int index) {
        this.id = index;
    }

    public void setIsAssigned(boolean tf) {
        this.isAsigned = tf;
    }

    public void AddCoord(Cartesian coord) {
        this.vecRotCoords.add(coord);
    }

    public void emptyCoord() {
        this.vecRotCoords = new Vector();
    }

    public void AddAdj(ProtonLabel ndNeigh) {
        int IDT = ndNeigh.getID();
        boolean isInPres = false;
        int i = 0;
        while (i < this.vecAdj.size()) {
            ProtonLabel nd = this.vecAdj.elementAt(i);
            int IDPre = nd.getID();
            if (IDT == IDPre) {
                isInPres = true;
            }
            ++i;
        }
        if (!isInPres) {
            this.vecAdj.add(ndNeigh);
        }
    }

    public void AddCloseAdj(ProtonLabel ndNeigh) {
        int IDT = ndNeigh.getID();
        boolean isInPres = false;
        int i = 0;
        while (i < this.vecCloseAdj.size()) {
            ProtonLabel nd = this.vecCloseAdj.elementAt(i);
            int IDPre = nd.getID();
            if (IDT == IDPre) {
                isInPres = true;
            }
            ++i;
        }
        if (!isInPres) {
            this.vecCloseAdj.add(ndNeigh);
        }
    }

    public void setStereoID(Vector<ProtonLabel> vecLabels) {
        Peak pk = new Peak();
        int j = 0;
        while (j < vecLabels.size()) {
            ProtonLabel ndProton = vecLabels.elementAt(j);
            String atom = ndProton.getAtomName();
            String res = ndProton.getResName();
            String heavy = pk.GetHeavyAtomFromProton(res, atom);
            int resNo = ndProton.getResNo();
            int k = 0;
            while (k < vecLabels.size()) {
                if (j != k) {
                    ProtonLabel ndProton2 = vecLabels.elementAt(k);
                    String atom2 = ndProton2.getAtomName();
                    String res2 = ndProton2.getResName();
                    String heavy2 = pk.GetHeavyAtomFromProton(res2, atom2);
                    int resNo2 = ndProton2.getResNo();
                    if (heavy.equalsIgnoreCase(heavy2) && resNo == resNo2) {
                        ndProton.stereoID = k;
                        ndProton2.stereoID = j;
                    }
                }
                ++k;
            }
            ++j;
        }
    }

    public Vector<ProtonLabel> ConstructProtonLabelSet(Vector<Pdb> pdbBBVec, String rotSrc, double noeUp) {
        double distUpClose = 2.8;
        Pdb pp = new Pdb();
        Vector<Pdb> vecPdbAllRots = pp.AllRotamersStructure(pdbBBVec, rotSrc);
        Vector<ProtonLabel> vecAllLabels = new Vector<ProtonLabel>();
        int i = 0;
        while (i < vecPdbAllRots.size()) {
            Pdb pdb = vecPdbAllRots.elementAt(i);
            int resNo = pdb.getResidueNo();
            String resName = pdb.getResidue();
            Vector<Cartesian> vecAtom = pdb.getAtomVec();
            int j = 0;
            while (j < vecAtom.size()) {
                String atomName;
                Cartesian cc = vecAtom.elementAt(j);
                String subAtomName = atomName = cc.getAtom();
                if (atomName.length() > 1) {
                    subAtomName = atomName.substring(0, atomName.length() - 1);
                }
                if (!(resName.equalsIgnoreCase("TYR") && atomName.equalsIgnoreCase("HH") || resName.equalsIgnoreCase("CYS") && atomName.equalsIgnoreCase("HG") || resName.equalsIgnoreCase("SER") && atomName.equalsIgnoreCase("HG") || resName.equalsIgnoreCase("LYS") && (atomName.equalsIgnoreCase("HZ1") || atomName.equalsIgnoreCase("HZ2") || atomName.equalsIgnoreCase("HZ3")) || resName.equalsIgnoreCase("ASP") && atomName.equalsIgnoreCase("HD2") || resName.equalsIgnoreCase("GLU") && atomName.equalsIgnoreCase("HE2") || resName.equalsIgnoreCase("ARG") && (atomName.equalsIgnoreCase("HE") || subAtomName.equalsIgnoreCase("HH1") || subAtomName.equalsIgnoreCase("HH2")) || resName.equalsIgnoreCase("THR") && atomName.equalsIgnoreCase("HG1"))) {
                    if (resName.equalsIgnoreCase("ALA") && (atomName.equalsIgnoreCase("HB1") || atomName.equalsIgnoreCase("HB2") || atomName.equalsIgnoreCase("HB3"))) {
                        atomName = "HB";
                    }
                    if (resName.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                        atomName = "HG2";
                    }
                    if (resName.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13"))) {
                        atomName = "HD1";
                    }
                    if (resName.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13"))) {
                        atomName = "HD1";
                    }
                    if (resName.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD21") || atomName.equalsIgnoreCase("HD22") || atomName.equalsIgnoreCase("HD23"))) {
                        atomName = "HD2";
                    }
                    if (resName.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG11") || atomName.equalsIgnoreCase("HG12") || atomName.equalsIgnoreCase("HG13"))) {
                        atomName = "HG1";
                    }
                    if (resName.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                        atomName = "HG2";
                    }
                    if (resName.equalsIgnoreCase("THR") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                        atomName = "HG2";
                    }
                    if (resName.equalsIgnoreCase("MET") && (atomName.equalsIgnoreCase("HE1") || atomName.equalsIgnoreCase("HE2") || atomName.equalsIgnoreCase("HE3"))) {
                        atomName = "HE";
                    }
                    if (atomName.substring(0, 1).equalsIgnoreCase("H")) {
                        this.AddProtonLabel(resNo, resName, atomName, cc, vecAllLabels);
                    }
                }
                ++j;
            }
            ++i;
        }
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        int i2 = 0;
        while (i2 < vecAllLabels.size()) {
            ProtonLabel labelA = vecAllLabels.elementAt(i2);
            Vector<Cartesian> vecAtomA = labelA.getRotCoords();
            int i1 = 0;
            while (i1 < vecAtomA.size()) {
                Cartesian ccA = vecAtomA.elementAt(i1);
                coordA = ccA.getXYZ();
                int j = 0;
                while (j < vecAllLabels.size()) {
                    ProtonLabel labelB = vecAllLabels.elementAt(j);
                    if (i2 != j) {
                        Vector<Cartesian> vecAtomB = labelB.getRotCoords();
                        boolean isAllIn = true;
                        boolean isAllInClose = true;
                        int j1 = 0;
                        while (j1 < vecAtomB.size()) {
                            Cartesian ccB = vecAtomB.elementAt(j1);
                            coordB = ccB.getXYZ();
                            double disTemp = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                            if (disTemp > noeUp) {
                                isAllIn = false;
                            }
                            if (disTemp > distUpClose) {
                                isAllInClose = false;
                            }
                            ++j1;
                        }
                        if (isAllIn) {
                            labelA.AddAdj(labelB);
                            labelB.AddAdj(labelA);
                        }
                        if (isAllInClose) {
                            labelA.AddCloseAdj(labelB);
                            labelB.AddCloseAdj(labelA);
                        }
                    }
                    ++j;
                }
                ++i1;
            }
            ++i2;
        }
        return vecAllLabels;
    }

    public void updateProtonLabelCloseNeighs(Vector<ProtonLabel> vecAllLabels, Vector<Pdb> pdbBBVec, String rotSrc, double distUpClose) {
        this.emptyCoordsInProtonLabel(vecAllLabels);
        Pdb pp = new Pdb();
        Vector<Pdb> vecPdbAllRots = pp.AllRotamersStructure(pdbBBVec, rotSrc);
        int i = 0;
        while (i < vecPdbAllRots.size()) {
            Pdb pdb = vecPdbAllRots.elementAt(i);
            int resNo = pdb.getResidueNo();
            String resName = pdb.getResidue();
            Vector<Cartesian> vecAtom = pdb.getAtomVec();
            if (vecAtom.size() != 0) {
                int j = 0;
                while (j < vecAtom.size()) {
                    String atomName;
                    Cartesian cc = vecAtom.elementAt(j);
                    String subAtomName = atomName = cc.getAtom();
                    if (atomName.length() > 1) {
                        subAtomName = atomName.substring(0, atomName.length() - 1);
                    }
                    if (!(resName.equalsIgnoreCase("TYR") && atomName.equalsIgnoreCase("HH") || resName.equalsIgnoreCase("CYS") && atomName.equalsIgnoreCase("HG") || resName.equalsIgnoreCase("SER") && atomName.equalsIgnoreCase("HG") || resName.equalsIgnoreCase("LYS") && (atomName.equalsIgnoreCase("HZ1") || atomName.equalsIgnoreCase("HZ2") || atomName.equalsIgnoreCase("HZ3")) || resName.equalsIgnoreCase("ASP") && atomName.equalsIgnoreCase("HD2") || resName.equalsIgnoreCase("GLU") && atomName.equalsIgnoreCase("HE2") || resName.equalsIgnoreCase("ARG") && (atomName.equalsIgnoreCase("HE") || subAtomName.equalsIgnoreCase("HH1") || subAtomName.equalsIgnoreCase("HH2")) || resName.equalsIgnoreCase("THR") && atomName.equalsIgnoreCase("HG1"))) {
                        if (resName.equalsIgnoreCase("ALA") && (atomName.equalsIgnoreCase("HB1") || atomName.equalsIgnoreCase("HB2") || atomName.equalsIgnoreCase("HB3"))) {
                            atomName = "HB";
                        }
                        if (resName.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                            atomName = "HG2";
                        }
                        if (resName.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13"))) {
                            atomName = "HD1";
                        }
                        if (resName.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13"))) {
                            atomName = "HD1";
                        }
                        if (resName.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD21") || atomName.equalsIgnoreCase("HD22") || atomName.equalsIgnoreCase("HD23"))) {
                            atomName = "HD2";
                        }
                        if (resName.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG11") || atomName.equalsIgnoreCase("HG12") || atomName.equalsIgnoreCase("HG13"))) {
                            atomName = "HG1";
                        }
                        if (resName.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                            atomName = "HG2";
                        }
                        if (resName.equalsIgnoreCase("THR") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                            atomName = "HG2";
                        }
                        if (resName.equalsIgnoreCase("MET") && (atomName.equalsIgnoreCase("HE1") || atomName.equalsIgnoreCase("HE2") || atomName.equalsIgnoreCase("HE3"))) {
                            atomName = "HE";
                        }
                        if (atomName.substring(0, 1).equalsIgnoreCase("H")) {
                            this.AddProtonLabel(resNo, resName, atomName, cc, vecAllLabels);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        double noeUp = 6.0;
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        int i2 = 0;
        while (i2 < vecAllLabels.size()) {
            ProtonLabel labelA = vecAllLabels.elementAt(i2);
            Vector<Cartesian> vecAtomA = labelA.getRotCoords();
            int i1 = 0;
            while (i1 < vecAtomA.size()) {
                Cartesian ccA = vecAtomA.elementAt(i1);
                coordA = ccA.getXYZ();
                int j = 0;
                while (j < vecAllLabels.size()) {
                    ProtonLabel labelB = vecAllLabels.elementAt(j);
                    if (i2 != j) {
                        Vector<Cartesian> vecAtomB = labelB.getRotCoords();
                        boolean isAllIn = true;
                        boolean isAllInClose = true;
                        if (vecAtomB.size() != 0) {
                            int j1 = 0;
                            while (j1 < vecAtomB.size()) {
                                Cartesian ccB = vecAtomB.elementAt(j1);
                                coordB = ccB.getXYZ();
                                double disTemp = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                                if (disTemp > noeUp) {
                                    isAllIn = false;
                                }
                                if (disTemp > distUpClose) {
                                    isAllInClose = false;
                                }
                                ++j1;
                            }
                            if (isAllIn) {
                                labelA.AddAdj(labelB);
                                labelB.AddAdj(labelA);
                            }
                            if (isAllInClose) {
                                labelA.AddCloseAdj(labelB);
                                labelB.AddCloseAdj(labelA);
                            }
                        }
                    }
                    ++j;
                }
                ++i1;
            }
            ++i2;
        }
    }

    public void addMappingNode(GraphNode node) {
        this.vecMappingSet.add(node);
    }

    public void EmptyMappingSet() {
        this.vecMappingSet = new Vector();
    }

    public void AddProtonLabel(int resID, String resName, String atomName, Cartesian coord, Vector<ProtonLabel> vecProtonLabel) {
        ProtonLabel label;
        boolean isInPres = false;
        int i = 0;
        while (i < vecProtonLabel.size()) {
            label = vecProtonLabel.elementAt(i);
            int preResID = label.getResNo();
            String preAtomName = label.getAtomName();
            if (resID == preResID && preAtomName.equalsIgnoreCase(atomName)) {
                label.AddCoord(coord);
                isInPres = true;
            }
            ++i;
        }
        if (!isInPres) {
            Vector<Cartesian> atomVecT = new Vector<Cartesian>();
            atomVecT.add(coord);
            label = new ProtonLabel(vecProtonLabel.size(), resID, resName, atomName, atomVecT);
            vecProtonLabel.add(label);
        }
    }

    public void emptyCoordsInProtonLabel(Vector<ProtonLabel> vecProtonLabel) {
        int i = 0;
        while (i < vecProtonLabel.size()) {
            ProtonLabel label = vecProtonLabel.elementAt(i);
            label.emptyCoord();
            ++i;
        }
    }
}

