/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;
import rdcPanda.IDof2aryStructure;
import rdcPanda.Model;
import rdcPanda.ModelRdc;

public class Dipolar
implements Cloneable {
    private int residueNo;
    private String residue;
    private double expRdc;
    private double expErr;

    public Dipolar() {
        this.residueNo = 0;
        this.residue = null;
        this.expErr = 0.0;
        this.expRdc = 0.0;
    }

    public Dipolar(int no) {
        this.residueNo = no;
        this.residue = null;
        this.expErr = 0.0;
        this.expRdc = 0.0;
    }

    public Dipolar(int no, String resid, double rdc, double err) {
        this.residueNo = no;
        this.residue = resid;
        this.expRdc = rdc;
        this.expErr = err;
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public String getResidue() {
        return this.residue;
    }

    public double getErr() {
        return this.expErr;
    }

    public double getRdc() {
        return this.expRdc;
    }

    public void setResidueNo(int R) {
        this.residueNo = R;
    }

    public void setErr(double err) {
        this.expErr = err;
    }

    public void setRdc(double rdc) {
        this.expRdc = rdc;
    }

    public String toString() {
        String desc = String.valueOf(String.valueOf(this.residueNo)) + "    " + String.valueOf(this.expRdc) + "  " + String.valueOf(this.expErr);
        return desc;
    }

    public void outPutRDCXplorFormat(Vector vecRDCs, String atom1, String atom2) {
    }

    public Vector<Vector<Dipolar>> rdcReader(String filename, Vector<IDof2aryStructure> idVec, String idType) {
        Vector<Dipolar> rdcVec = new Vector<Dipolar>();
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(filename));
            while (in.nextToken() != -1) {
                if (in.ttype == -3 || in.ttype != -2) continue;
                int no = (int)in.nval;
                in.nextToken();
                double rdc = in.nval;
                in.nextToken();
                double err = in.nval;
                in.nextToken();
                rdcVec.add(new Dipolar(no, "", rdc, err));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Collections.sort(rdcVec, new rdcComparator());
        IDof2aryStructure id2ary = new IDof2aryStructure();
        int index = -1;
        int beginNo = 0;
        int endNo = 0;
        int residueNo = 0;
        Vector<Vector<Dipolar>> allRdcVec = new Vector<Vector<Dipolar>>();
        Vector<Dipolar> oneElementRdc = new Vector<Dipolar>();
        int i = 0;
        while (i < idVec.size()) {
            id2ary = idVec.elementAt(i);
            beginNo = id2ary.getResidueNoA();
            endNo = id2ary.getResidueNoB();
            String type2ary = id2ary.getTypeAndID();
            String type = type2ary.substring(0, 1);
            if (type.equals(idType)) {
                int j = 0;
                while (j < endNo - beginNo + 1) {
                    residueNo = beginNo + j;
                    index = Collections.binarySearch(rdcVec, new Dipolar(residueNo), new rdcComparator());
                    if (index > -1) {
                        oneElementRdc.add((Dipolar)rdcVec.elementAt(index));
                    }
                    ++j;
                }
                allRdcVec.add(oneElementRdc);
                oneElementRdc = new Vector();
            }
            ++i;
        }
        return allRdcVec;
    }

    public Vector<Vector<Dipolar>> rdcReader(String filename, Vector<IDof2aryStructure> idVec, String idType, double dbSc) {
        Vector<Dipolar> rdcVec = new Vector<Dipolar>();
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(filename));
            while (in.nextToken() != -1) {
                if (in.ttype == -3 || in.ttype != -2) continue;
                int no = (int)in.nval;
                in.nextToken();
                double rdc = in.nval * dbSc;
                in.nextToken();
                double err = in.nval * dbSc;
                in.nextToken();
                rdcVec.add(new Dipolar(no, "", rdc, err));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Collections.sort(rdcVec, new rdcComparator());
        IDof2aryStructure id2ary = new IDof2aryStructure();
        int index = -1;
        int beginNo = 0;
        int endNo = 0;
        int residueNo = 0;
        Vector<Vector<Dipolar>> allRdcVec = new Vector<Vector<Dipolar>>();
        Vector<Dipolar> oneElementRdc = new Vector<Dipolar>();
        int i = 0;
        while (i < idVec.size()) {
            id2ary = idVec.elementAt(i);
            beginNo = id2ary.getResidueNoA();
            endNo = id2ary.getResidueNoB();
            String type2ary = id2ary.getTypeAndID();
            String type = type2ary.substring(0, 1);
            if (type.equals(idType)) {
                int j = 0;
                while (j < endNo - beginNo + 1) {
                    residueNo = beginNo + j;
                    index = Collections.binarySearch(rdcVec, new Dipolar(residueNo), new rdcComparator());
                    if (index > -1) {
                        oneElementRdc.add((Dipolar)rdcVec.elementAt(index));
                    }
                    ++j;
                }
                allRdcVec.add(oneElementRdc);
                oneElementRdc = new Vector();
            }
            ++i;
        }
        return allRdcVec;
    }

    public Vector rdcReader_old(String filename, Vector idVec, String idType) {
        Vector<Dipolar> rdcVec = new Vector<Dipolar>();
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(filename));
            while (in.nextToken() != -1) {
                if (in.ttype == -3 || in.ttype != -2) continue;
                int no = (int)in.nval;
                in.nextToken();
                double rdc = in.nval;
                in.nextToken();
                double err = in.nval;
                rdcVec.add(new Dipolar(no, "", rdc, err));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Collections.sort(rdcVec, new rdcComparator());
        IDof2aryStructure id2ary = new IDof2aryStructure();
        int index = -1;
        int beginNo = 0;
        int endNo = 0;
        int residueNo = 0;
        Vector allRdcVec = new Vector();
        Vector oneElementRdc = new Vector();
        int i = 0;
        while (i < idVec.size()) {
            id2ary = (IDof2aryStructure)idVec.elementAt(i);
            beginNo = id2ary.getResidueNoA();
            endNo = id2ary.getResidueNoB();
            String type2ary = id2ary.getTypeAndID();
            String type = type2ary.substring(0, 1);
            if (type.equals(idType)) {
                int j = 0;
                while (j < endNo - beginNo + 1) {
                    residueNo = beginNo + j;
                    index = Collections.binarySearch(rdcVec, new Dipolar(residueNo), new rdcComparator());
                    if (index > -1) {
                        oneElementRdc.add(rdcVec.elementAt(index));
                    }
                    ++j;
                }
                allRdcVec.add(oneElementRdc);
                oneElementRdc = new Vector();
            }
            ++i;
        }
        return allRdcVec;
    }

    public Vector rdcReader4CNS(String fileName, String id, double ratio) {
        Vector<Dipolar> inputs = new Vector<Dipolar>();
        int residueNo = 0;
        double rdc = 0.0;
        double err = 0.0;
        int ind1 = 0;
        int ind2 = 0;
        int ind3 = 0;
        try {
            String ss;
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            while ((ss = in.readLine()) != null) {
                String rdcValues;
                StringTokenizer tokens;
                if ((ss = ss.toUpperCase()).indexOf(id) <= -1) continue;
                ind1 = ss.indexOf("RESID");
                ind2 = ss.indexOf("AND");
                String str = ss.substring(ind1 + 5, ind2).trim();
                residueNo = Integer.parseInt(str);
                ind3 = ss.indexOf(")");
                String idTmp = ss.substring(ind2 + 8, ind3).trim();
                if (!idTmp.equals(id) || !(tokens = new StringTokenizer(rdcValues = ss.substring(ind3 + 1).trim())).hasMoreTokens()) continue;
                rdc = new Double(tokens.nextToken());
                err = tokens.hasMoreTokens() ? new Double(tokens.nextToken()) : 1.0;
                inputs.add(new Dipolar(residueNo, "", rdc / ratio, err));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Collections.sort(inputs, new rdcComparator());
        return inputs;
    }

    public Vector rdcRead(String filename) {
        Vector<Dipolar> inputs = new Vector<Dipolar>();
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(filename));
            while (in.nextToken() != -1) {
                if (in.ttype == -3 || in.ttype != -2) continue;
                int no = (int)in.nval;
                in.nextToken();
                double rdc = in.nval;
                in.nextToken();
                double err = in.nval;
                in.nextToken();
                inputs.add(new Dipolar(no, "", rdc, err));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Collections.sort(inputs, new rdcComparator());
        return inputs;
    }

    public Vector rdcRead(String filename, double dbScale) {
        Vector<Dipolar> inputs = new Vector<Dipolar>();
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(filename));
            while (in.nextToken() != -1) {
                if (in.ttype == -3 || in.ttype != -2) continue;
                int no = (int)in.nval;
                in.nextToken();
                double rdc = in.nval * dbScale;
                in.nextToken();
                double err = in.nval * dbScale;
                in.nextToken();
                inputs.add(new Dipolar(no, "", rdc, err));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        Collections.sort(inputs, new rdcComparator());
        return inputs;
    }

    public static void main(String[] argv) throws JampackException {
        double rdcErr;
        double rdcValue;
        int resNo;
        Dipolar dp;
        int i;
        PrintWriter out;
        long startTime = System.currentTimeMillis();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String strOut = String.valueOf(userDir) + "/outFiles/";
        ModelRdc mdc = new ModelRdc();
        Model mod = new Model();
        String rdcNhFile = String.valueOf(src) + "gb1nhrdc.txt";
        String rdcChFile = String.valueOf(src) + "gb1chrdc.txt";
        String rdcCaCoFile = String.valueOf(src) + "cacoRdc.txt";
        String rdcConFile = String.valueOf(src) + "conRdc.txt";
        Dipolar dd = new Dipolar();
        Vector nhRdc = dd.rdcRead(rdcNhFile, 1.0);
        Vector cahaRdc = dd.rdcRead(rdcChFile, 0.49800796812749004);
        Vector cacoRdc = dd.rdcRead(rdcCaCoFile, 1.0);
        Vector conRdc = dd.rdcRead(rdcConFile, 1.0);
        String stroutName = "";
        String fileName = "";
        stroutName = "gb1_nh_rdc.tbl";
        fileName = String.valueOf(strOut) + stroutName;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("! rdc has been scaled to NH rdc");
            i = 0;
            while (i < nhRdc.size()) {
                dp = (Dipolar)nhRdc.elementAt(i);
                resNo = dp.getResidueNo();
                rdcValue = dp.getRdc();
                rdcErr = 0.2;
                out.println("assign ( resid 500  and name OO  )");
                out.println("       ( resid 500  and name Z   )");
                out.println("       ( resid 500  and name X   )");
                out.println("       ( resid 500  and name Y   )");
                out.println("       ( resid " + resNo + "    and name N   )");
                out.println("       ( resid " + resNo + "    and name HN  )" + "   " + rdcValue + "   " + rdcErr);
                out.println("");
                out.println("");
                ++i;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        stroutName = "gb1_ch_rdc.tbl";
        fileName = String.valueOf(strOut) + stroutName;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("! rdc has been scaled to NH rdc");
            i = 0;
            while (i < cahaRdc.size()) {
                dp = (Dipolar)cahaRdc.elementAt(i);
                resNo = dp.getResidueNo();
                rdcValue = dp.getRdc();
                rdcErr = 0.2;
                out.println("assign ( resid 500  and name OO  )");
                out.println("       ( resid 500  and name Z   )");
                out.println("       ( resid 500  and name X   )");
                out.println("       ( resid 500  and name Y   )");
                out.println("       ( resid " + resNo + "    and name CA  )");
                out.println("       ( resid " + resNo + "    and name HA  )" + "   " + rdcValue + "   " + rdcErr);
                out.println("");
                out.println("");
                ++i;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        stroutName = "ff2_rdc_caco.tbl";
        fileName = String.valueOf(strOut) + stroutName;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("! rdc has not been scaled to NH rdc");
            i = 0;
            while (i < cacoRdc.size()) {
                dp = (Dipolar)cacoRdc.elementAt(i);
                resNo = dp.getResidueNo();
                rdcValue = dp.getRdc();
                rdcErr = 0.2;
                out.println("assign ( resid 500  and name OO  )");
                out.println("       ( resid 500  and name Z   )");
                out.println("       ( resid 500  and name X   )");
                out.println("       ( resid 500  and name Y   )");
                out.println("       ( resid " + resNo + "    and name CA  )");
                out.println("       ( resid " + resNo + "    and name C   )" + "   " + rdcValue + "   " + rdcErr);
                out.println("");
                out.println("");
                ++i;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        stroutName = "ff2_rdc_nco.tbl";
        fileName = String.valueOf(strOut) + stroutName;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            out.println("! rdc has not been scaled to NH rdc");
            i = 0;
            while (i < conRdc.size()) {
                dp = (Dipolar)conRdc.elementAt(i);
                resNo = dp.getResidueNo();
                int resNextNo = resNo + 1;
                double rdcValue2 = dp.getRdc();
                double rdcErr2 = 0.2;
                out.println("assign ( resid 500  and name OO  )");
                out.println("       ( resid 500  and name Z   )");
                out.println("       ( resid 500  and name X   )");
                out.println("       ( resid 500  and name Y   )");
                out.println("       ( resid " + resNo + "    and name C  )");
                out.println("       ( resid " + resNextNo + "    and name N   )" + "   " + rdcValue2 + "   " + rdcErr2);
                out.println("");
                out.println("");
                ++i;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    protected Object clone() {
        try {
            Object s = super.clone();
            return s;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static class rdcComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Dipolar n1 = (Dipolar)o1;
            Dipolar n2 = (Dipolar)o2;
            double d1 = n1.getResidueNo();
            if (d1 < (d2 = (double)n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

