/*
 * Decompiled with CFR 0.152.
 */
package Nasca;

import Jampack.JampackException;
import Nasca.SAS;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.H1CS;
import rdcPanda.Peak;

public class Evaluation {
    public static void main(String[] args) throws JampackException {
        H1CS h1CS = new H1CS();
        Assign asg = new Assign();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String strCSRef = "ubc_cyana_prot-convert.txt";
        String strResFormatRef = "CYANA";
        String strSeq = "UBQ.seq";
        String strCSNameFormat = "BMRB-NEW";
        String strCSNasca = "resonance_nasca.prot";
        String strSAS = "SAS.txt";
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        Vector<Object> vecChemShiftRef = new Vector();
        String assignFile = String.valueOf(src) + strCSRef;
        if (strResFormatRef.equalsIgnoreCase("CYANA")) {
            vecChemShiftRef = h1CS.h1CSReader(assignFile, vecSeq);
        } else if (strResFormatRef.equalsIgnoreCase("BMRB")) {
            vecChemShiftRef = h1CS.h1CSReader_BMRB(assignFile);
        } else {
            System.out.println("unknown format of the resonance file...");
            System.exit(0);
        }
        if (strCSNameFormat.equalsIgnoreCase("BMRB-NEW")) {
            Vector<Object> vecAsgNew = new Vector();
            vecAsgNew = h1CS.CSNameConvertFromBMRBNewToPDBNew(vecChemShiftRef);
            vecChemShiftRef = new Vector();
            vecChemShiftRef.addAll(vecAsgNew);
        }
        Vector<Object> vecChemShiftNasca = new Vector();
        assignFile = String.valueOf(src) + strCSNasca;
        vecChemShiftNasca = h1CS.h1CSReader(assignFile, vecSeq);
        Evaluation eva = new Evaluation();
        System.out.println("=============================================== ");
        System.out.println("Evaluation on different atom types: ");
        System.out.println("=============================================== ");
        eva.EvaluateCSAssignmentDiffAtoms(vecChemShiftNasca, vecChemShiftRef);
        System.out.println("=============================================== ");
        System.out.println("Evaluation on different residue types: ");
        System.out.println("=============================================== ");
        eva.EvaluateCSAssignmentDiffResidues(vecChemShiftNasca, vecChemShiftRef);
        System.out.println("=============================================== ");
        System.out.println("Evaluation on residues with different solvent accessible surfaces: ");
        System.out.println("=============================================== ");
        String strSASFile = String.valueOf(src) + strSAS;
        SAS sas = new SAS();
        Vector<SAS> vecSAS = sas.SASReader(strSASFile);
        eva.EvaluateCSAssignmentDiffSAS(vecChemShiftNasca, vecChemShiftRef, vecSAS);
    }

    public void EvaluateCSAssignmentDiffAtoms(Vector vecSrcAsg, Vector vecRefAsg) {
        double csErrH = 0.05;
        double csErrHeavy = 0.5;
        Peak pk = new Peak();
        int totalScH = 0;
        int missing = 0;
        double wrong = 0.0;
        double correct = 0.0;
        double correctI = 0.0;
        double correctII = 0.0;
        double nTotalClassII = 0.0;
        double nTotalClassI = 0.0;
        Assign asg = new Assign();
        double nTotalAsgs = 0.0;
        double nTotalHb = 0.0;
        double nTotalHg = 0.0;
        double nTotalHd = 0.0;
        double nTotalHe = 0.0;
        double nTotalR = 0.0;
        double correctHb = 0.0;
        double correctHg = 0.0;
        double correctHd = 0.0;
        double correctHe = 0.0;
        double correctR = 0.0;
        int k = 0;
        while (k < vecSrcAsg.size()) {
            H1CS h1cs = (H1CS)vecSrcAsg.elementAt(k);
            String res = h1cs.getResidueType();
            String atom = h1cs.getAtomName();
            if (atom.length() >= 2 && atom.substring(0, 1).equalsIgnoreCase("H")) {
                nTotalAsgs += 1.0;
                if (res.equalsIgnoreCase("VAL") || res.equalsIgnoreCase("ILE") || res.equalsIgnoreCase("LEU") || res.equalsIgnoreCase("MET") || res.equalsIgnoreCase("PHE") || res.equalsIgnoreCase("TRP") || res.equalsIgnoreCase("CYS")) {
                    nTotalClassI += 1.0;
                } else if (!res.equalsIgnoreCase("ALA") && !res.equalsIgnoreCase("GLY")) {
                    nTotalClassII += 1.0;
                }
                if ((res.equalsIgnoreCase("PHE") || res.equalsIgnoreCase("HIS") || res.equalsIgnoreCase("TRP") || res.equalsIgnoreCase("TYR")) && !atom.equalsIgnoreCase("HB")) {
                    nTotalR += 1.0;
                } else {
                    if ((atom = atom.substring(0, 2)).equalsIgnoreCase("HB")) {
                        nTotalHb += 1.0;
                    }
                    if (atom.equalsIgnoreCase("HG")) {
                        nTotalHg += 1.0;
                    }
                    if (atom.equalsIgnoreCase("HD")) {
                        nTotalHd += 1.0;
                    }
                    if (atom.equalsIgnoreCase("HE")) {
                        nTotalHe += 1.0;
                    }
                }
            }
            ++k;
        }
        int j = 0;
        while (j < vecSrcAsg.size()) {
            H1CS h1csA = (H1CS)vecSrcAsg.elementAt(j);
            int resNoA = h1csA.getResidueNo();
            String resA = h1csA.getResidueType();
            String atomA = h1csA.getAtomName();
            double cs_hA = h1csA.getH1CS();
            if (atomA.substring(0, 1).equalsIgnoreCase("H")) {
                boolean isFound = false;
                boolean isCorrect = false;
                int k2 = 0;
                while (k2 < vecRefAsg.size()) {
                    H1CS h1cs = (H1CS)vecRefAsg.elementAt(k2);
                    int resRefNo = h1cs.getResidueNo();
                    String resRef = h1cs.getResidueType();
                    String atomRef = h1cs.getAtomName();
                    double csRef = h1cs.getH1CS();
                    String subAtomTwo = "";
                    subAtomTwo = atomRef.length() > 2 ? atomRef.substring(0, 2) : atomRef;
                    String atomRefStereo = "";
                    if (subAtomTwo.equalsIgnoreCase("HB") && (resRef.equalsIgnoreCase("CYS") || resRef.equalsIgnoreCase("ASP") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("HIS") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("LEU") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("ASN") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("SER") || resRef.equalsIgnoreCase("TRP") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HB1")) {
                            atomRefStereo = "HB2";
                        } else if (atomRef.equalsIgnoreCase("HB2")) {
                            atomRefStereo = "HB1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HA") && resRef.equalsIgnoreCase("GLY")) {
                        if (atomRef.equalsIgnoreCase("HA1")) {
                            atomRefStereo = "HA2";
                        } else if (atomRef.equalsIgnoreCase("HA2")) {
                            atomRefStereo = "HA1";
                        }
                    }
                    if ((subAtomTwo.equalsIgnoreCase("HG") || subAtomTwo.equalsIgnoreCase("CG")) && resRef.equalsIgnoreCase("VAL")) {
                        if (atomRef.equalsIgnoreCase("HG1")) {
                            atomRefStereo = "HG2";
                        } else if (atomRef.equalsIgnoreCase("HG2")) {
                            atomRefStereo = "HG1";
                        } else if (atomRef.equalsIgnoreCase("CG1")) {
                            atomRefStereo = "CG2";
                        } else if (atomRef.equalsIgnoreCase("CG2")) {
                            atomRefStereo = "CG1";
                        }
                    }
                    if ((subAtomTwo.equalsIgnoreCase("HD") || subAtomTwo.equalsIgnoreCase("CD")) && resRef.equalsIgnoreCase("LEU")) {
                        if (atomRef.equalsIgnoreCase("HD1")) {
                            atomRefStereo = "HD2";
                        } else if (atomRef.equalsIgnoreCase("HD2")) {
                            atomRefStereo = "HD1";
                        } else if (atomRef.equalsIgnoreCase("CD1")) {
                            atomRefStereo = "CD2";
                        } else if (atomRef.equalsIgnoreCase("CD2")) {
                            atomRefStereo = "CD1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HG") && (resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG"))) {
                        if (atomRef.equalsIgnoreCase("HG1")) {
                            atomRefStereo = "HG2";
                        } else if (atomRef.equalsIgnoreCase("HG2")) {
                            atomRefStereo = "HG1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HD") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HD1")) {
                            atomRefStereo = "HD2";
                        } else if (atomRef.equalsIgnoreCase("HD2")) {
                            atomRefStereo = "HD1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HE") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HE1")) {
                            atomRefStereo = "HE2";
                        } else if (atomRef.equalsIgnoreCase("HE2")) {
                            atomRefStereo = "HE1";
                        }
                    }
                    if (atomRef.length() >= 3) {
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HG1") && resRef.equalsIgnoreCase("ILE")) {
                            if (atomRef.equalsIgnoreCase("HG11")) {
                                atomRefStereo = "HG12";
                            } else if (atomRef.equalsIgnoreCase("HG12")) {
                                atomRefStereo = "HG11";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HD2") && resRef.equalsIgnoreCase("ASN")) {
                            if (atomRef.equalsIgnoreCase("HD21")) {
                                atomRefStereo = "HD22";
                            } else if (atomRef.equalsIgnoreCase("HD22")) {
                                atomRefStereo = "HD21";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HE2") && resRef.equalsIgnoreCase("GLN")) {
                            if (atomRef.equalsIgnoreCase("HE21")) {
                                atomRefStereo = "HE22";
                            } else if (atomRef.equalsIgnoreCase("HE22")) {
                                atomRefStereo = "HE21";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HH1") && resRef.equalsIgnoreCase("ARG")) {
                            if (atomRef.equalsIgnoreCase("HH11")) {
                                atomRefStereo = "HH12";
                            } else if (atomRef.equalsIgnoreCase("HH12")) {
                                atomRefStereo = "HH11";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HH2") && resRef.equalsIgnoreCase("ARG")) {
                            if (atomRef.equalsIgnoreCase("HH21")) {
                                atomRefStereo = "HH22";
                            } else if (atomRef.equalsIgnoreCase("HH22")) {
                                atomRefStereo = "HH21";
                            }
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HH") && resRef.equalsIgnoreCase("ARG")) {
                        if (atomRef.equalsIgnoreCase("HH1")) {
                            atomRefStereo = "HH2";
                        } else if (atomRef.equalsIgnoreCase("HH2")) {
                            atomRefStereo = "HH1";
                        }
                    }
                    if (atomRef.substring(0, 1).equalsIgnoreCase("H") || atomRef.substring(0, 1).equalsIgnoreCase("C") || atomRef.substring(0, 1).equalsIgnoreCase("N")) {
                        String subAtom = atomA;
                        double csErr = 0.0;
                        csErr = atomRef.substring(0, 1).equalsIgnoreCase("H") ? csErrH : csErrHeavy;
                        if (atomA.length() > atomRef.length()) {
                            subAtom = atomA.substring(0, atomRef.length());
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef)) {
                            isFound = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRefStereo)) {
                            isFound = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRefStereo) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                    }
                    ++k2;
                }
                if (!isFound) {
                    ++missing;
                } else if (!isCorrect) {
                    wrong += 1.0;
                } else {
                    correct += 1.0;
                    if ((resA.equalsIgnoreCase("PHE") || resA.equalsIgnoreCase("HIS") || resA.equalsIgnoreCase("TRP") || resA.equalsIgnoreCase("TYR")) && !atomA.equalsIgnoreCase("HB")) {
                        correctR += 1.0;
                    } else {
                        if ((atomA = atomA.substring(0, 2)).equalsIgnoreCase("HB")) {
                            correctHb += 1.0;
                        }
                        if (atomA.equalsIgnoreCase("HG")) {
                            correctHg += 1.0;
                        }
                        if (atomA.equalsIgnoreCase("HD")) {
                            correctHd += 1.0;
                        }
                        if (atomA.equalsIgnoreCase("HE")) {
                            correctHe += 1.0;
                        }
                    }
                    if (resA.equalsIgnoreCase("VAL") || resA.equalsIgnoreCase("ILE") || resA.equalsIgnoreCase("LEU") || resA.equalsIgnoreCase("MET") || resA.equalsIgnoreCase("PHE") || resA.equalsIgnoreCase("TRP") || resA.equalsIgnoreCase("CYS")) {
                        correctI += 1.0;
                    } else if (!resA.equalsIgnoreCase("ALA") && !resA.equalsIgnoreCase("GLY")) {
                        correctII += 1.0;
                    }
                }
                ++totalScH;
            }
            ++j;
        }
        System.out.println("Total number of protons (including both bb and sc protons): " + totalScH);
        System.out.println("Total number of missing sidechain assignments: " + missing);
        System.out.println("Total number of wrong sidechain assignments: " + wrong);
        System.out.println("Total number of correct resonance assignments: " + correct);
        System.out.println("Percentage of correct proton resonance assignments (including both bb and sc resonances): " + correct / nTotalAsgs);
        System.out.println("Percentage of correct proton resonance assignments for class I residues: " + correctI / nTotalClassI);
        System.out.println("Percentage of correct proton resonance assignments for class II residues: " + correctII / nTotalClassII);
        System.out.println("Percentage of correct resonance assignments for Cb-Hb: " + correctHb / nTotalHb);
        System.out.println("Percentage of correct resonance assignments for Cg-Hg: " + correctHg / nTotalHg);
        System.out.println("Percentage of correct resonance assignments for Cd-Hd: " + correctHd / nTotalHd);
        System.out.println("Percentage of correct resonance assignments for Ce-He: " + correctHe / nTotalHe);
        System.out.println("Percentage of correct resonance assignments for aromatic protons: " + correctR / nTotalR);
    }

    public void EvaluateCSAssignmentDiffSAS(Vector vecSrcAsg, Vector vecRefAsg, Vector<SAS> vecSAS) {
        SAS sas = new SAS();
        double csErrH = 0.05;
        double csErrHeavy = 0.5;
        Peak pk = new Peak();
        int totalScH = 0;
        int missing = 0;
        double wrong = 0.0;
        double correct = 0.0;
        double correctI = 0.0;
        double correctII = 0.0;
        double nTotalClassII = 0.0;
        double nTotalClassI = 0.0;
        Assign asg = new Assign();
        double nTotalAsgs = 0.0;
        double nTotalSas0_10 = 0.0;
        double nTotalSas30_40 = 0.0;
        double nTotalSas10_20 = 0.0;
        double nTotalSas20_30 = 0.0;
        double nTotalSas40_100 = 0.0;
        double correctSas0_10 = 0.0;
        double correctSas30_40 = 0.0;
        double correctSas10_20 = 0.0;
        double correctSas20_30 = 0.0;
        double correctSas40_100 = 0.0;
        int k = 0;
        while (k < vecSrcAsg.size()) {
            H1CS h1cs = (H1CS)vecSrcAsg.elementAt(k);
            String res = h1cs.getResidueType();
            String atom = h1cs.getAtomName();
            int no = h1cs.getResidueNo();
            if (atom.length() >= 2 && atom.substring(0, 1).equalsIgnoreCase("H")) {
                nTotalAsgs += 1.0;
                if (res.equalsIgnoreCase("VAL") || res.equalsIgnoreCase("ILE") || res.equalsIgnoreCase("LEU") || res.equalsIgnoreCase("MET") || res.equalsIgnoreCase("PHE") || res.equalsIgnoreCase("TRP") || res.equalsIgnoreCase("CYS")) {
                    nTotalClassI += 1.0;
                } else if (!res.equalsIgnoreCase("ALA") && !res.equalsIgnoreCase("GLY")) {
                    nTotalClassII += 1.0;
                }
                double dbSASValue = sas.findSAS(vecSAS, no, atom);
                if (dbSASValue >= 0.0 && dbSASValue < 10.0) {
                    nTotalSas0_10 += 1.0;
                } else if (dbSASValue >= 10.0 && dbSASValue < 20.0) {
                    nTotalSas10_20 += 1.0;
                } else if (dbSASValue >= 20.0 && dbSASValue < 30.0) {
                    nTotalSas20_30 += 1.0;
                } else if (dbSASValue >= 30.0 && dbSASValue < 40.0) {
                    nTotalSas30_40 += 1.0;
                } else if (dbSASValue >= 40.0 && dbSASValue <= 100.0) {
                    nTotalSas40_100 += 1.0;
                }
            }
            ++k;
        }
        int j = 0;
        while (j < vecSrcAsg.size()) {
            H1CS h1csA = (H1CS)vecSrcAsg.elementAt(j);
            int resNoA = h1csA.getResidueNo();
            String resA = h1csA.getResidueType();
            String atomA = h1csA.getAtomName();
            double cs_hA = h1csA.getH1CS();
            if (atomA.substring(0, 1).equalsIgnoreCase("H")) {
                boolean isFound = false;
                boolean isCorrect = false;
                int k2 = 0;
                while (k2 < vecRefAsg.size()) {
                    H1CS h1cs = (H1CS)vecRefAsg.elementAt(k2);
                    int resRefNo = h1cs.getResidueNo();
                    String resRef = h1cs.getResidueType();
                    String atomRef = h1cs.getAtomName();
                    double csRef = h1cs.getH1CS();
                    String subAtomTwo = "";
                    subAtomTwo = atomRef.length() > 2 ? atomRef.substring(0, 2) : atomRef;
                    String atomRefStereo = "";
                    if (subAtomTwo.equalsIgnoreCase("HB") && (resRef.equalsIgnoreCase("CYS") || resRef.equalsIgnoreCase("ASP") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("HIS") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("LEU") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("ASN") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("SER") || resRef.equalsIgnoreCase("TRP") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HB1")) {
                            atomRefStereo = "HB2";
                        } else if (atomRef.equalsIgnoreCase("HB2")) {
                            atomRefStereo = "HB1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HA") && resRef.equalsIgnoreCase("GLY")) {
                        if (atomRef.equalsIgnoreCase("HA1")) {
                            atomRefStereo = "HA2";
                        } else if (atomRef.equalsIgnoreCase("HA2")) {
                            atomRefStereo = "HA1";
                        }
                    }
                    if ((subAtomTwo.equalsIgnoreCase("HG") || subAtomTwo.equalsIgnoreCase("CG")) && resRef.equalsIgnoreCase("VAL")) {
                        if (atomRef.equalsIgnoreCase("HG1")) {
                            atomRefStereo = "HG2";
                        } else if (atomRef.equalsIgnoreCase("HG2")) {
                            atomRefStereo = "HG1";
                        } else if (atomRef.equalsIgnoreCase("CG1")) {
                            atomRefStereo = "CG2";
                        } else if (atomRef.equalsIgnoreCase("CG2")) {
                            atomRefStereo = "CG1";
                        }
                    }
                    if ((subAtomTwo.equalsIgnoreCase("HD") || subAtomTwo.equalsIgnoreCase("CD")) && resRef.equalsIgnoreCase("LEU")) {
                        if (atomRef.equalsIgnoreCase("HD1")) {
                            atomRefStereo = "HD2";
                        } else if (atomRef.equalsIgnoreCase("HD2")) {
                            atomRefStereo = "HD1";
                        } else if (atomRef.equalsIgnoreCase("CD1")) {
                            atomRefStereo = "CD2";
                        } else if (atomRef.equalsIgnoreCase("CD2")) {
                            atomRefStereo = "CD1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HG") && (resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG"))) {
                        if (atomRef.equalsIgnoreCase("HG1")) {
                            atomRefStereo = "HG2";
                        } else if (atomRef.equalsIgnoreCase("HG2")) {
                            atomRefStereo = "HG1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HD") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HD1")) {
                            atomRefStereo = "HD2";
                        } else if (atomRef.equalsIgnoreCase("HD2")) {
                            atomRefStereo = "HD1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HE") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HE1")) {
                            atomRefStereo = "HE2";
                        } else if (atomRef.equalsIgnoreCase("HE2")) {
                            atomRefStereo = "HE1";
                        }
                    }
                    if (atomRef.length() >= 3) {
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HG1") && resRef.equalsIgnoreCase("ILE")) {
                            if (atomRef.equalsIgnoreCase("HG11")) {
                                atomRefStereo = "HG12";
                            } else if (atomRef.equalsIgnoreCase("HG12")) {
                                atomRefStereo = "HG11";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HD2") && resRef.equalsIgnoreCase("ASN")) {
                            if (atomRef.equalsIgnoreCase("HD21")) {
                                atomRefStereo = "HD22";
                            } else if (atomRef.equalsIgnoreCase("HD22")) {
                                atomRefStereo = "HD21";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HE2") && resRef.equalsIgnoreCase("GLN")) {
                            if (atomRef.equalsIgnoreCase("HE21")) {
                                atomRefStereo = "HE22";
                            } else if (atomRef.equalsIgnoreCase("HE22")) {
                                atomRefStereo = "HE21";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HH1") && resRef.equalsIgnoreCase("ARG")) {
                            if (atomRef.equalsIgnoreCase("HH11")) {
                                atomRefStereo = "HH12";
                            } else if (atomRef.equalsIgnoreCase("HH12")) {
                                atomRefStereo = "HH11";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HH2") && resRef.equalsIgnoreCase("ARG")) {
                            if (atomRef.equalsIgnoreCase("HH21")) {
                                atomRefStereo = "HH22";
                            } else if (atomRef.equalsIgnoreCase("HH22")) {
                                atomRefStereo = "HH21";
                            }
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HH") && resRef.equalsIgnoreCase("ARG")) {
                        if (atomRef.equalsIgnoreCase("HH1")) {
                            atomRefStereo = "HH2";
                        } else if (atomRef.equalsIgnoreCase("HH2")) {
                            atomRefStereo = "HH1";
                        }
                    }
                    if (atomRef.substring(0, 1).equalsIgnoreCase("H") || atomRef.substring(0, 1).equalsIgnoreCase("C") || atomRef.substring(0, 1).equalsIgnoreCase("N")) {
                        String subAtom = atomA;
                        double csErr = 0.0;
                        csErr = atomRef.substring(0, 1).equalsIgnoreCase("H") ? csErrH : csErrHeavy;
                        if (atomA.length() > atomRef.length()) {
                            subAtom = atomA.substring(0, atomRef.length());
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef)) {
                            isFound = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRefStereo)) {
                            isFound = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRefStereo) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                    }
                    ++k2;
                }
                if (!isFound) {
                    ++missing;
                } else if (!isCorrect) {
                    wrong += 1.0;
                } else {
                    correct += 1.0;
                    double dbSASValue = sas.findSAS(vecSAS, resNoA, atomA);
                    if (dbSASValue >= 0.0 && dbSASValue < 10.0) {
                        correctSas0_10 += 1.0;
                    } else if (dbSASValue >= 10.0 && dbSASValue < 20.0) {
                        correctSas10_20 += 1.0;
                    } else if (dbSASValue >= 20.0 && dbSASValue < 30.0) {
                        correctSas20_30 += 1.0;
                    } else if (dbSASValue >= 30.0 && dbSASValue < 40.0) {
                        correctSas30_40 += 1.0;
                    } else if (dbSASValue >= 40.0 && dbSASValue <= 100.0) {
                        correctSas40_100 += 1.0;
                    }
                    if (resA.equalsIgnoreCase("VAL") || resA.equalsIgnoreCase("ILE") || resA.equalsIgnoreCase("LEU") || resA.equalsIgnoreCase("MET") || resA.equalsIgnoreCase("PHE") || resA.equalsIgnoreCase("TRP") || resA.equalsIgnoreCase("CYS")) {
                        correctI += 1.0;
                    } else if (!resA.equalsIgnoreCase("ALA") && !resA.equalsIgnoreCase("GLY")) {
                        correctII += 1.0;
                    }
                }
                ++totalScH;
            }
            ++j;
        }
        System.out.println("Total number of protons (including both bb and sc protons): " + totalScH);
        System.out.println("Total number of missing sidechain assignments: " + missing);
        System.out.println("Total number of wrong sidechain assignments: " + wrong);
        System.out.println("Total number of correct resonance assignments: " + correct);
        System.out.println("Percentage of correct proton resonance assignments (including both bb and sc resonances): " + correct / nTotalAsgs);
        System.out.println("Percentage of correct proton resonance assignments for class I residues: " + correctI / nTotalClassI);
        System.out.println("Percentage of correct proton resonance assignments for class II residues: " + correctII / nTotalClassII);
        System.out.println("Percentage of correct resonance assignments for SAS 0-10%: " + correctSas0_10 / nTotalSas0_10);
        System.out.println("Percentage of correct resonance assignments for SAS 10-20%: " + correctSas10_20 / nTotalSas10_20);
        System.out.println("Percentage of correct resonance assignments for SAS 20-30%: " + correctSas20_30 / nTotalSas20_30);
        System.out.println("Percentage of correct resonance assignments for SAS 30-40%: " + correctSas30_40 / nTotalSas30_40);
        System.out.println("Percentage of correct resonance assignments for SAS >40%: " + correctSas40_100 / nTotalSas40_100);
    }

    public void EvaluateCSAssignmentDiffResidues(Vector vecSrcAsg, Vector vecRefAsg) {
        double csErrH = 0.05;
        double csErrHeavy = 0.5;
        Peak pk = new Peak();
        int totalScH = 0;
        int missing = 0;
        double wrong = 0.0;
        double correct = 0.0;
        double correctI = 0.0;
        double correctII = 0.0;
        double nTotalClassII = 0.0;
        double nTotalClassI = 0.0;
        Assign asg = new Assign();
        double nTotalAsgs = 0.0;
        double nTotalChi1 = 0.0;
        double nTotalChi2 = 0.0;
        double nTotalChi3 = 0.0;
        double nTotalChi4 = 0.0;
        double correctChi1 = 0.0;
        double correctChi2 = 0.0;
        double correctChi3 = 0.0;
        double correctChi4 = 0.0;
        int k = 0;
        while (k < vecSrcAsg.size()) {
            H1CS h1cs = (H1CS)vecSrcAsg.elementAt(k);
            String res = h1cs.getResidueType();
            String atom = h1cs.getAtomName();
            if (atom.length() >= 2 && atom.substring(0, 1).equalsIgnoreCase("H")) {
                nTotalAsgs += 1.0;
                if (res.equalsIgnoreCase("VAL") || res.equalsIgnoreCase("ILE") || res.equalsIgnoreCase("LEU") || res.equalsIgnoreCase("MET") || res.equalsIgnoreCase("PHE") || res.equalsIgnoreCase("TRP") || res.equalsIgnoreCase("CYS")) {
                    nTotalClassI += 1.0;
                } else if (!res.equalsIgnoreCase("ALA") && !res.equalsIgnoreCase("GLY")) {
                    nTotalClassII += 1.0;
                }
                if (res.equalsIgnoreCase("ARG") || res.equalsIgnoreCase("LYS")) {
                    nTotalChi4 += 1.0;
                } else if (res.equalsIgnoreCase("MET") || res.equalsIgnoreCase("GLU") || res.equalsIgnoreCase("GLN")) {
                    nTotalChi3 += 1.0;
                } else if (res.equalsIgnoreCase("ASP") || res.equalsIgnoreCase("ASN") || res.equalsIgnoreCase("ILE") || res.equalsIgnoreCase("LEU") || res.equalsIgnoreCase("HIS") || res.equalsIgnoreCase("TRP") || res.equalsIgnoreCase("TYR") || res.equalsIgnoreCase("PHE")) {
                    nTotalChi2 += 1.0;
                } else if (res.equalsIgnoreCase("PRO") || res.equalsIgnoreCase("THR") || res.equalsIgnoreCase("VAL") || res.equalsIgnoreCase("SER") || res.equalsIgnoreCase("CYS")) {
                    nTotalChi1 += 1.0;
                } else if (!res.equalsIgnoreCase("GLY") && !res.equalsIgnoreCase("ALA")) {
                    System.out.println("error: found some unknow residue type...");
                }
            }
            ++k;
        }
        int j = 0;
        while (j < vecSrcAsg.size()) {
            H1CS h1csA = (H1CS)vecSrcAsg.elementAt(j);
            int resNoA = h1csA.getResidueNo();
            String resA = h1csA.getResidueType();
            String atomA = h1csA.getAtomName();
            double cs_hA = h1csA.getH1CS();
            if (atomA.substring(0, 1).equalsIgnoreCase("H")) {
                boolean isFound = false;
                boolean isCorrect = false;
                int k2 = 0;
                while (k2 < vecRefAsg.size()) {
                    H1CS h1cs = (H1CS)vecRefAsg.elementAt(k2);
                    int resRefNo = h1cs.getResidueNo();
                    String resRef = h1cs.getResidueType();
                    String atomRef = h1cs.getAtomName();
                    double csRef = h1cs.getH1CS();
                    String subAtomTwo = "";
                    subAtomTwo = atomRef.length() > 2 ? atomRef.substring(0, 2) : atomRef;
                    String atomRefStereo = "";
                    if (subAtomTwo.equalsIgnoreCase("HB") && (resRef.equalsIgnoreCase("CYS") || resRef.equalsIgnoreCase("ASP") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("HIS") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("LEU") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("ASN") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("SER") || resRef.equalsIgnoreCase("TRP") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HB1")) {
                            atomRefStereo = "HB2";
                        } else if (atomRef.equalsIgnoreCase("HB2")) {
                            atomRefStereo = "HB1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HA") && resRef.equalsIgnoreCase("GLY")) {
                        if (atomRef.equalsIgnoreCase("HA1")) {
                            atomRefStereo = "HA2";
                        } else if (atomRef.equalsIgnoreCase("HA2")) {
                            atomRefStereo = "HA1";
                        }
                    }
                    if ((subAtomTwo.equalsIgnoreCase("HG") || subAtomTwo.equalsIgnoreCase("CG")) && resRef.equalsIgnoreCase("VAL")) {
                        if (atomRef.equalsIgnoreCase("HG1")) {
                            atomRefStereo = "HG2";
                        } else if (atomRef.equalsIgnoreCase("HG2")) {
                            atomRefStereo = "HG1";
                        } else if (atomRef.equalsIgnoreCase("CG1")) {
                            atomRefStereo = "CG2";
                        } else if (atomRef.equalsIgnoreCase("CG2")) {
                            atomRefStereo = "CG1";
                        }
                    }
                    if ((subAtomTwo.equalsIgnoreCase("HD") || subAtomTwo.equalsIgnoreCase("CD")) && resRef.equalsIgnoreCase("LEU")) {
                        if (atomRef.equalsIgnoreCase("HD1")) {
                            atomRefStereo = "HD2";
                        } else if (atomRef.equalsIgnoreCase("HD2")) {
                            atomRefStereo = "HD1";
                        } else if (atomRef.equalsIgnoreCase("CD1")) {
                            atomRefStereo = "CD2";
                        } else if (atomRef.equalsIgnoreCase("CD2")) {
                            atomRefStereo = "CD1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HG") && (resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("GLU") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG"))) {
                        if (atomRef.equalsIgnoreCase("HG1")) {
                            atomRefStereo = "HG2";
                        } else if (atomRef.equalsIgnoreCase("HG2")) {
                            atomRefStereo = "HG1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HD") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("PRO") || resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HD1")) {
                            atomRefStereo = "HD2";
                        } else if (atomRef.equalsIgnoreCase("HD2")) {
                            atomRefStereo = "HD1";
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HE") && (resRef.equalsIgnoreCase("PHE") || resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("TYR"))) {
                        if (atomRef.equalsIgnoreCase("HE1")) {
                            atomRefStereo = "HE2";
                        } else if (atomRef.equalsIgnoreCase("HE2")) {
                            atomRefStereo = "HE1";
                        }
                    }
                    if (atomRef.length() >= 3) {
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HG1") && resRef.equalsIgnoreCase("ILE")) {
                            if (atomRef.equalsIgnoreCase("HG11")) {
                                atomRefStereo = "HG12";
                            } else if (atomRef.equalsIgnoreCase("HG12")) {
                                atomRefStereo = "HG11";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HD2") && resRef.equalsIgnoreCase("ASN")) {
                            if (atomRef.equalsIgnoreCase("HD21")) {
                                atomRefStereo = "HD22";
                            } else if (atomRef.equalsIgnoreCase("HD22")) {
                                atomRefStereo = "HD21";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HE2") && resRef.equalsIgnoreCase("GLN")) {
                            if (atomRef.equalsIgnoreCase("HE21")) {
                                atomRefStereo = "HE22";
                            } else if (atomRef.equalsIgnoreCase("HE22")) {
                                atomRefStereo = "HE21";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HH1") && resRef.equalsIgnoreCase("ARG")) {
                            if (atomRef.equalsIgnoreCase("HH11")) {
                                atomRefStereo = "HH12";
                            } else if (atomRef.equalsIgnoreCase("HH12")) {
                                atomRefStereo = "HH11";
                            }
                        }
                        if (atomRef.substring(0, 3).equalsIgnoreCase("HH2") && resRef.equalsIgnoreCase("ARG")) {
                            if (atomRef.equalsIgnoreCase("HH21")) {
                                atomRefStereo = "HH22";
                            } else if (atomRef.equalsIgnoreCase("HH22")) {
                                atomRefStereo = "HH21";
                            }
                        }
                    }
                    if (subAtomTwo.equalsIgnoreCase("HH") && resRef.equalsIgnoreCase("ARG")) {
                        if (atomRef.equalsIgnoreCase("HH1")) {
                            atomRefStereo = "HH2";
                        } else if (atomRef.equalsIgnoreCase("HH2")) {
                            atomRefStereo = "HH1";
                        }
                    }
                    if (atomRef.substring(0, 1).equalsIgnoreCase("H") || atomRef.substring(0, 1).equalsIgnoreCase("C") || atomRef.substring(0, 1).equalsIgnoreCase("N")) {
                        String subAtom = atomA;
                        double csErr = 0.0;
                        csErr = atomRef.substring(0, 1).equalsIgnoreCase("H") ? csErrH : csErrHeavy;
                        if (atomA.length() > atomRef.length()) {
                            subAtom = atomA.substring(0, atomRef.length());
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef)) {
                            isFound = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRefStereo)) {
                            isFound = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRef) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                        if (resNoA == resRefNo && subAtom.equalsIgnoreCase(atomRefStereo) && Math.abs(csRef - cs_hA) < csErr) {
                            isCorrect = true;
                        }
                    }
                    ++k2;
                }
                if (!isFound) {
                    ++missing;
                } else if (!isCorrect) {
                    wrong += 1.0;
                } else {
                    correct += 1.0;
                    if (resA.equalsIgnoreCase("ARG") || resA.equalsIgnoreCase("LYS")) {
                        correctChi4 += 1.0;
                    } else if (resA.equalsIgnoreCase("MET") || resA.equalsIgnoreCase("GLU") || resA.equalsIgnoreCase("GLN")) {
                        correctChi3 += 1.0;
                    } else if (resA.equalsIgnoreCase("ASP") || resA.equalsIgnoreCase("ASN") || resA.equalsIgnoreCase("ILE") || resA.equalsIgnoreCase("LEU") || resA.equalsIgnoreCase("HIS") || resA.equalsIgnoreCase("TRP") || resA.equalsIgnoreCase("TYR") || resA.equalsIgnoreCase("PHE")) {
                        correctChi2 += 1.0;
                    } else if (resA.equalsIgnoreCase("PRO") || resA.equalsIgnoreCase("THR") || resA.equalsIgnoreCase("VAL") || resA.equalsIgnoreCase("SER") || resA.equalsIgnoreCase("CYS")) {
                        correctChi1 += 1.0;
                    }
                    if (resA.equalsIgnoreCase("VAL") || resA.equalsIgnoreCase("ILE") || resA.equalsIgnoreCase("LEU") || resA.equalsIgnoreCase("MET") || resA.equalsIgnoreCase("PHE") || resA.equalsIgnoreCase("TRP") || resA.equalsIgnoreCase("CYS")) {
                        correctI += 1.0;
                    } else if (!resA.equalsIgnoreCase("ALA") && !resA.equalsIgnoreCase("GLY")) {
                        correctII += 1.0;
                    }
                }
                ++totalScH;
            }
            ++j;
        }
        System.out.println("Total number of protons (including both bb and sc protons): " + totalScH);
        System.out.println("Total number of missing sidechain assignments: " + missing);
        System.out.println("Total number of wrong sidechain assignments: " + wrong);
        System.out.println("Total number of correct resonance assignments: " + correct);
        System.out.println("Percentage of correct proton resonance assignments (including both bb and sc resonances): " + correct / nTotalAsgs);
        System.out.println("Percentage of correct proton resonance assignments for class I residues: " + correctI / nTotalClassI);
        System.out.println("Percentage of correct proton resonance assignments for class II residues: " + correctII / nTotalClassII);
        System.out.println("Percentage of correct resonance assignments for one-chi angle residues : " + correctChi1 / nTotalChi1);
        System.out.println("Percentage of correct resonance assignments for two-chi angle residues : " + correctChi2 / nTotalChi2);
        System.out.println("Percentage of correct resonance assignments for three-chi angle residues : " + correctChi3 / nTotalChi3);
        System.out.println("Percentage of correct resonance assignments for four-chi angle residues : " + correctChi4 / nTotalChi4);
    }
}

