/*
 * Decompiled with CFR 0.152.
 */
package Nasca;

import Nasca.GraphNode;
import Nasca.NascaNew;
import Nasca.ProtonLabel;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.H1CS;
import rdcPanda.Noesy;
import rdcPanda.Peak;

public class PairwiseScoreMatrix {
    public void computBestScoreMatrix(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecLabels, Vector<H1CS> vecBMRBNew, double[][] bestScoreMatrix) {
        Peak pk = new Peak();
        NascaNew nasca = new NascaNew();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        int i = 0;
        while (i < vecResonGraph.size()) {
            GraphNode node = vecResonGraph.elementAt(i);
            if (!node.getIsAssigned()) {
                int nodeID = node.getID();
                Vector<Noesy> vecNoesy = node.vecAdjNOESY;
                double cs_proton = node.getCSProton();
                double cs_heavy = node.getCSHeavy();
                Vector<ProtonLabel> vecMapSet = node.getMappingSet();
                Vector<GraphNode> vecAdj = node.getAdjVec();
                double maxScore = 0.0;
                int j = 0;
                while (j < vecMapSet.size()) {
                    ProtonLabel label = vecMapSet.elementAt(j);
                    if (!label.getIsAssigned()) {
                        double bestScore;
                        int labelID = label.getID();
                        Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
                        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
                        String res = label.getResName();
                        String atom = label.getAtomName();
                        String heavName = pk.GetHeavyAtomFromProton(res, atom);
                        int resNo = label.getResNo();
                        Vector<Noesy> vecNoesyTwo = new Vector<Noesy>();
                        vecNoesyTwo.addAll(vecNoesy);
                        vecOneSCAsg.add(new H1CS(resNo, res, atom, cs_proton));
                        vecOneSCAsg.add(new H1CS(resNo, res, heavName, cs_heavy));
                        int t = 0;
                        while (t < vecAdj.size()) {
                            GraphNode nodeAdj = vecAdj.elementAt(t);
                            if (nodeAdj.getIsAssigned() && nodeAdj.asgedId >= 0) {
                                ProtonLabel nodeAdjLabel = vecLabels.elementAt(nodeAdj.asgedId);
                                vecNoesyTwo.addAll(nodeAdj.vecAdjNOESY);
                                int resNoSec = nodeAdjLabel.getResNo();
                                String resSec = nodeAdjLabel.getResName();
                                String atomSec = nodeAdjLabel.getAtomName();
                                String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                                double cs_protonSec = nodeAdj.getCSProton();
                                double cs_heavySec = nodeAdj.getCSHeavy();
                                vecOneSCAsg.add(new H1CS(resNoSec, resSec, atomSec, cs_protonSec));
                                vecOneSCAsg.add(new H1CS(resNoSec, resSec, heavyNameSec, cs_heavySec));
                                double distUp = 6.0;
                                if (nasca.isInCloseAdj(nodeAdjLabel, label)) {
                                    distUp = 2.7;
                                }
                                vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, distUp, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                                vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, distUp, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
                            }
                            ++t;
                        }
                        Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                        int[] numPeaks = new int[1];
                        double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                        Vector<H1CS> vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg);
                        double asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew, vecBMRBNew);
                        bestScoreMatrix[nodeID][labelID] = bestScore = (dbScore *= (double)vecBackNoeNew.size()) + asgScore;
                        if (bestScore > maxScore) {
                            maxScore = bestScore;
                        }
                    }
                    ++j;
                }
                node.bestScore = maxScore;
            }
            ++i;
        }
    }
}

