/*
 * Decompiled with CFR 0.152.
 */
package NascaGUI;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class Link
extends JLabel
implements MouseListener {
    private String url;

    public Link() {
        this.init("");
    }

    public Link(Icon image) {
        super(image);
        this.init("");
    }

    public Link(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
        this.init("");
    }

    public Link(String text) {
        super(text);
        this.init(text);
    }

    public Link(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
        this.init(text);
    }

    public void setURL(String url) {
        this.url = url;
        this.setToolTipText("Open " + url + " in your browser");
    }

    private void init(String url) {
        this.setURL(url);
        this.addMouseListener(this);
        this.setForeground(Color.BLUE);
    }

    public Link(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
        this.init(text);
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        this.browse();
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
        this.setCursor(new Cursor(12));
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private void browse() {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(this.url));
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + this.url);
            } else if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, this.url);
            } else {
                Map<String, String> env = System.getenv();
                if (env.get("BROWSER") != null) {
                    Runtime.getRuntime().exec(String.valueOf(env.get("BROWSER")) + " " + this.url);
                    return;
                }
                String[] browsers = new String[]{"firefox", "iceweasel", "chrome", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                int count = 0;
                while (count < browsers.length && browser == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                        browser = browsers[count];
                        break;
                    }
                    ++count;
                }
                if (browser == null) {
                    throw new RuntimeException("couldn't find any browser...");
                }
                Runtime.getRuntime().exec(new String[]{browser, this.url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "couldn't find a webbrowser to use...\nPlease browser for yourself:\n" + this.url);
        }
    }
}

