/*
 * Decompiled with CFR 0.152.
 */
package NascaGUI;

import Jampack.JampackException;
import Nasca.AStar;
import Nasca.GraphNode;
import Nasca.NascaNew;
import Nasca.ProtonLabel;
import NascaGUI.Assignment;
import NascaGUI.Global;
import NascaGUI.NascaGUI;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.H1CS;
import rdcPanda.Noe;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.Peak;

public class NascaCMD {
    public static void main(String[] args) throws JampackException {
        long startTime = System.currentTimeMillis();
        NascaCMD nascaCMD = new NascaCMD();
        nascaCMD.outputProgInfo();
        String userDir = System.getProperty("user.dir");
        String srcNascaSystem = String.valueOf(userDir) + "/system/nasca/nasca_system.input";
        NascaGUI.readSystemParameters(srcNascaSystem);
        NascaCMD.parse(args);
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Total time for running NASCA is: " + String.format("%.3f", totalTime) + " minutes");
    }

    public static void parse(String[] args) throws JampackException {
        if (args.length != 6) {
            System.out.println("Error: Incorrect command line. Please double check...");
            System.exit(0);
        }
        int indexInput = -1;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-i")) {
                indexInput = i;
                break;
            }
            ++i;
        }
        if (indexInput < 0 || indexInput == args.length - 1) {
            System.out.println("Error: Incorrect command line. The input file is missing. Please double check...");
            System.exit(0);
        }
        String strInputFileName = args[indexInput + 1];
        int indexSCAssignment = -1;
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].equalsIgnoreCase("-sc")) {
                indexSCAssignment = i2;
                break;
            }
            ++i2;
        }
        if (indexSCAssignment < 0 || indexSCAssignment == args.length - 1) {
            System.out.println("Error: Incorrect command line. The output file name for side-chain resonance assignments is missing. Please double check...");
            System.exit(0);
        }
        String strSCAssignment = args[indexSCAssignment + 1];
        int indexNOEAssignment = -1;
        int i3 = 0;
        while (i3 < args.length) {
            if (args[i3].equalsIgnoreCase("-noe")) {
                indexNOEAssignment = i3;
                break;
            }
            ++i3;
        }
        if (indexNOEAssignment < 0 || indexNOEAssignment == args.length - 1) {
            System.out.println("Error: Incorrect command line. The output file name for NOE assignments is missing. Please double check...");
            System.exit(0);
        }
        String strSNOEAssignment = args[indexNOEAssignment + 1];
        NascaCMD nascaCMD = new NascaCMD();
        Assignment assignment = nascaCMD.performNascaCMD(strInputFileName);
        String fileName = String.valueOf(Global.strOut) + strSCAssignment;
        H1CS h1cs = new H1CS();
        h1cs.PrintAllAssignmentToFileBMRB(assignment.getResonAsgs(), fileName);
        System.out.println("The computed resonance assignments have been written into " + fileName + ".");
        Noe noe = new Noe();
        fileName = String.valueOf(Global.strOut) + strSNOEAssignment;
        noe.printNoesToFileInXplor(assignment.getNoeAsgs(), fileName);
        System.out.println("The computed NOE assignments have been written into " + fileName + ".");
    }

    public void outputProgInfo() {
        System.out.println("*************************************************************************");
        System.out.println("**                        NASCA Version 1.0                            **");
        System.out.println("**                        Contact Info:                                **");
        System.out.println("**                               Bruce Donald                          **");
        System.out.println("**                               Duke University                       **");
        System.out.println("**                               Department of Computer Science        **");
        System.out.println("**                               Levine Science Research Center (LSRC) **");
        System.out.println("**                               Durham                                **");
        System.out.println("**                               NC 27708-0129, USA                    **");
        System.out.println("**                               nasca@cs.duke.edu                       **");
        System.out.println("**                                                                     **");
        System.out.println("**                                                                     **");
        System.out.println("**  J. Zeng, P. Zhou and B.R. Donald. Protein Side-Chain Resonance     **");
        System.out.println("** \tAssignment and NOE Assignment Using RDC-Defined Backbones      **");
        System.out.println("**  without TOCSY Data. J. Biom. NMR, Submitted. 2011                  **");
        System.out.println("*************************************************************************");
    }

    private Assignment performNascaCMD(String strInputFile) throws JampackException {
        String strIsCheckLongAA;
        String extName;
        Assignment assignment = new Assignment();
        Peak pk = new Peak();
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        double haErr = Global.haErr;
        double h1Err = Global.h1Err;
        double c13Err = Global.c13Err;
        double hnErr = Global.hnErr;
        double nErr = Global.nErr;
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(Global.strInput) + strInputFile);
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("BACKBONE")) {
                Global.strBBPdbFile = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("RESONANCE")) {
                Global.strBBCSFile = paraMap.get("RESONANCE");
            }
            if (paraMap.containsKey("3D-C13-NOESY")) {
                Global.strAliNoesyFile = paraMap.get("3D-C13-NOESY");
            }
            if (paraMap.containsKey("3D-C13-NOESY-ARO")) {
                Global.strAroNoesyFile = paraMap.get("3D-C13-NOESY-ARO");
            }
            if (paraMap.containsKey("3D-N15-NOESY")) {
                Global.strN15NoesyFile = paraMap.get("3D-N15-NOESY");
            }
            ++i;
        }
        String pdbFile = Global.strBBPdbFile;
        boolean fileExists = new File(pdbFile).exists();
        if (!fileExists) {
            String errMessage = "Error: Backbone PDB file not found...";
            Global.status = -1;
            System.out.println(errMessage);
            return null;
        }
        Vector<Pdb> pdbVecBB = pp.readPdb(pdbFile);
        if (pdbVecBB == null || pdbVecBB.size() == 0) {
            String errMessage = "Error: Backbone PDB file not found...";
            System.out.println(errMessage);
            Global.status = -1;
            return null;
        }
        System.out.println("Read backbone PDB coordinates successfully from: " + pdbFile);
        String strPdbNameScheme = pp.obtainPdbAtomNameScheme(pdbVecBB);
        Vector<Object> pdbVecNewSec = new Vector();
        if (strPdbNameScheme.equalsIgnoreCase("PDB-OLD")) {
            pdbVecNewSec = pp.nameConvertOrder(pdbVecBB);
        } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-NEW")) {
            pdbVecNewSec = pp.nameConvert2PDBNew(pdbVecBB);
        } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-OLD")) {
            Vector<Pdb> pdbVecSSE22 = pp.nameConvertOrder(pdbVecBB);
            pdbVecNewSec = pp.nameConvert2PDBNew(pdbVecSSE22);
        } else {
            pdbVecNewSec.addAll(pdbVecBB);
        }
        Vector<Object> vecStructureAll = new Vector<Object>();
        vecStructureAll.addAll(pdbVecNewSec);
        Vector<Pdb> vecBBTemp = pp.OutputBackbone(pdbVecNewSec);
        pdbVecNewSec = new Vector();
        pdbVecNewSec.addAll(vecBBTemp);
        Vector<Assign> vecSeq = pp.getSeqFromPdb(pdbVecBB);
        H1CS h1CS = new H1CS();
        String assignFile = Global.strBBCSFile;
        fileExists = new File(assignFile).exists();
        if (!fileExists) {
            String errMessage = "Error: Backbone chemical shift file not found...";
            System.out.println(errMessage);
            Global.status = -1;
            return null;
        }
        String strResFormat = h1CS.obtainChemicalShiftFileFormat(Global.strBBCSFile);
        Vector<Object> assignVec = new Vector();
        if (strResFormat.equalsIgnoreCase("CYANA")) {
            assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        } else if (strResFormat.equalsIgnoreCase("BMRB")) {
            assignVec = h1CS.h1CSReader_BMRB(assignFile);
        } else {
            System.out.println("Unknown format of the resonance file...");
            Global.status = -1;
            return null;
        }
        if (assignVec == null || assignVec.size() == 0) {
            String errMessage = "Error: Backbone chemical shift file not found...";
            Global.status = -1;
            System.out.println(errMessage);
            return null;
        }
        System.out.println("Read backbone chemical shifts successfully from: " + assignFile);
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        String strAliNoeFile = "";
        String strAroNoeFile = "";
        String strN15NoeFile = "";
        Vector<Noesy> hnNoeVec = new Vector();
        Vector<Object> aliNoeVec = new Vector();
        Vector<Object> aroNoeVec = new Vector();
        String strNoesyFormat = "XEASY";
        strAliNoeFile = Global.strAliNoesyFile;
        strAroNoeFile = Global.strAroNoesyFile;
        strN15NoeFile = Global.strN15NoesyFile;
        boolean aliFileExist = new File(strAliNoeFile).exists();
        boolean aroFileExist = new File(strAroNoeFile).exists();
        boolean n15FileExist = new File(strN15NoeFile).exists();
        if (!(aliFileExist || aroFileExist || n15FileExist)) {
            System.out.println("Error: NASCA requires at least one NOESY file as input...");
            Global.status = -1;
            return null;
        }
        int indexOfDot = (strAliNoeFile = strAliNoeFile.trim()).lastIndexOf(".");
        if (indexOfDot > -1) {
            extName = strAliNoeFile.substring(indexOfDot + 1, strAliNoeFile.length());
            strNoesyFormat = extName.equalsIgnoreCase("XPK") ? "NMRVIEW " : (extName.equalsIgnoreCase("PEAKS") ? "XEASY" : "UNKNOWN");
            aliNoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strAliNoeFile) : noesy.NoesyReaderNMRView(strAliNoeFile);
            vecNoesy.addAll(aliNoeVec);
        }
        if (aliFileExist) {
            System.out.println("Read C13 aliphatic NOESY cross peaks successfully from: " + strAliNoeFile);
        } else {
            System.out.println("C13 aliphatic NOESY cross peaks are not provided...");
        }
        strAroNoeFile = strAroNoeFile.trim();
        indexOfDot = strAroNoeFile.lastIndexOf(".");
        if (indexOfDot > -1) {
            extName = strAroNoeFile.substring(indexOfDot + 1, strAroNoeFile.length());
            strNoesyFormat = extName.equalsIgnoreCase("XPK") ? "NMRVIEW " : (extName.equalsIgnoreCase("PEAKS") ? "XEASY" : "UNKNOWN");
            aroNoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strAroNoeFile) : noesy.NoesyReaderNMRView(strAroNoeFile);
            vecNoesy.addAll(aroNoeVec);
        }
        if (aroFileExist) {
            System.out.println("Read C13 aromatic NOESY cross peaks successfully from: " + strAroNoeFile);
        } else {
            System.out.println("C13 aromatic NOESY cross peaks are not provided...");
        }
        strN15NoeFile = strN15NoeFile.trim();
        indexOfDot = strN15NoeFile.lastIndexOf(".");
        if (indexOfDot > -1) {
            extName = strN15NoeFile.substring(indexOfDot + 1, strN15NoeFile.length());
            strNoesyFormat = extName.equalsIgnoreCase("XPK") ? "NMRVIEW " : (extName.equalsIgnoreCase("PEAKS") ? "XEASY" : "UNKNOWN");
            hnNoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strN15NoeFile) : noesy.NoesyReaderNMRView(strN15NoeFile);
            vecNoesy.addAll(hnNoeVec);
        }
        if (n15FileExist) {
            System.out.println("Read C13 aromatic NOESY cross peaks successfully from: " + strN15NoeFile);
        } else {
            System.out.println("C13 aromatic NOESY cross peaks are not provided...");
        }
        if (vecNoesy == null || vecNoesy.size() == 0) {
            String errMessage = "Error: NOESY cross peaks are not provided...";
            System.out.println(errMessage);
            Global.status = -1;
            return null;
        }
        Vector<Object> vecNewNoesy = new Vector();
        if (vecNoesy.size() > 0) {
            vecNewNoesy = noesy.SetCalibration(vecNoesy);
        }
        double[] constant = new double[1];
        Vector<Pdb> vecSSE = new Vector<Pdb>();
        noesy.SetCalibrationN15(hnNoeVec, vecSSE, assignVec, constant);
        NascaNew nasca = new NascaNew();
        ProtonLabel protonLabel = new ProtonLabel();
        GraphNode graphNode = new GraphNode();
        String userDir = System.getProperty("user.dir");
        String srcRot = String.valueOf(userDir) + "/system/rot-lib/";
        Vector<ProtonLabel> vecLabels = protonLabel.ConstructProtonLabelSet(pdbVecNewSec, srcRot, Global.noeDistLimit);
        Vector<Object> vecAsgNew = new Vector();
        vecAsgNew = h1CS.CSNameConvertFromBMRBNewToPDBNew(assignVec);
        assignVec = new Vector();
        assignVec.addAll(vecAsgNew);
        Vector<H1CS> vecBBAsg = nasca.ExtractBackboneAsignment(assignVec);
        Vector<GraphNode> vecResonNodeSet = graphNode.ConstructInitResonGraphFromAsgedList(vecBBAsg, null);
        i = 0;
        while (i < vecNewNoesy.size()) {
            Noesy ne = (Noesy)vecNewNoesy.elementAt(i);
            double csH1 = ne.getH1();
            double csHeavy = ne.getHeavy();
            Vector<Object> vecResGraphTemp = new Vector();
            vecResGraphTemp = graphNode.AddResonanceNode(vecResonNodeSet, csH1, csHeavy, 0.02, 0.1, 0.1);
            vecResonNodeSet = new Vector();
            vecResonNodeSet.addAll(vecResGraphTemp);
            ++i;
        }
        i = 0;
        while (i < vecResonNodeSet.size()) {
            GraphNode node = vecResonNodeSet.elementAt(i);
            Vector<GraphNode> vecAdj = node.getAdjVec();
            int counter = 1;
            double csProtonSum = node.getCSProton();
            double csHeavySum = node.getCSHeavy();
            int k = 0;
            while (k < vecAdj.size()) {
                GraphNode ndAdj = vecAdj.elementAt(k);
                csProtonSum += ndAdj.getCSProton();
                csHeavySum += ndAdj.getCSHeavy();
                ++counter;
                ++k;
            }
            node.setProtonCS(csProtonSum /= (double)counter);
            node.setHeavyCS(csHeavySum /= (double)counter);
            node.EmptyAdjSet();
            ++i;
        }
        Vector<GraphNode> vecResonGraph = graphNode.ConstructResonGraph(vecResonNodeSet, vecNewNoesy, 0.04, 0.04, 0.1, 0.1);
        graphNode.ConstructResonGraphSymmetry(vecResonNodeSet, vecNewNoesy, 0.03, 0.03, 0.1, 0.1);
        String srcBMRB = String.valueOf(userDir) + "/system/BMRB_CS.txt";
        Vector<H1CS> vecBMRB = h1CS.ReadBMRBSatistics(srcBMRB);
        Vector<H1CS> vecBMRBNew = new Vector();
        vecBMRBNew = h1CS.CSNameConvertFromBMRBNewToPDBNew(vecBMRB);
        int[][] Map2 = new int[vecResonGraph.size()][vecLabels.size()];
        double[][] MapScore = new double[vecResonGraph.size()][vecLabels.size()];
        nasca.Initialization(vecResonGraph, vecLabels, Map2, MapScore, vecBBAsg);
        nasca.RefineMappingBasedBMRBOutliers(vecResonGraph, vecLabels, Map2, vecBMRBNew);
        nasca.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        nasca.UpdateIsRestrained(vecResonGraph, vecLabels, Map2);
        nasca.RefineMappingBasedRestrained(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        nasca.RefineMappingForHG(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        nasca.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        System.out.println("Now performing the DEE pruning...");
        int numDeePruning = this.RefineMappingDeeCutForCMD(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        if (numDeePruning == -1 && Global.status == 0) {
            return null;
        }
        System.out.println("DEE pruning completed. Total number of mappings pruned by DEE-CUT is: " + numDeePruning);
        nasca.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        nasca.PrintAllPossibleMappings(vecResonGraph, vecLabels, Map2);
        nasca.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        H1CS h1cs = new H1CS();
        AStar astar = new AStar();
        System.out.println("Now performing the A* search...");
        Vector<H1CS> vecAsgNewT0 = this.AStarSearchForSCAsgsForCMD(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        if (vecAsgNewT0 == null && Global.status == 0) {
            return null;
        }
        Vector<H1CS> vecAsgNewT = h1cs.DeleteRepeatAsg(vecAsgNewT0);
        System.out.println("A* search completed.");
        assignment.setResonAsgs(vecAsgNewT);
        Vector<Object> vecAmbgAsg = new Vector();
        allH1Vec = new Vector();
        allH1Vec = pk.allProtonSorted(vecAsgNewT);
        Collections.sort(allH1Vec, new Peak.csComparator());
        vecAmbgAsg = asg.InitAmbiAssignment(nErr, c13Err, hnErr, haErr, h1Err, vecAsgNewT, allH1Vec, vecNewNoesy);
        Vector<Noe> vecAmbgAsgTemp = noesy.SetCalibrationCyana(vecAmbgAsg, vecNewNoesy, constant[0]);
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecAmbgAsgTemp);
        Vector<Noe> vecNoeRefine2 = new Vector<Noe>();
        i = 0;
        while (i < vecAmbgAsg.size()) {
            Noe noe = (Noe)vecAmbgAsg.elementAt(i);
            int noA = noe.getResidueNoA();
            int noB = noe.getResidueNoB();
            String atomA = noe.getAtomA();
            String atomB = noe.getAtomB();
            if (noA != noB || !atomA.equalsIgnoreCase(atomB)) {
                boolean isIn = true;
                String strOutOrFormat = "0";
                if (strOutOrFormat.equalsIgnoreCase("0")) {
                    int j = 0;
                    while (j < vecNoeRefine2.size()) {
                        Noe noeT = (Noe)vecNoeRefine2.elementAt(j);
                        int noAT = noeT.getResidueNoA();
                        int noBT = noeT.getResidueNoB();
                        String atomAT = noeT.getAtomA();
                        String atomBT = noeT.getAtomB();
                        if (noA == noAT && atomA.equalsIgnoreCase(atomAT) && noB == noBT && atomB.equalsIgnoreCase(atomBT)) {
                            isIn = false;
                        }
                        if (noA == noBT && atomA.equalsIgnoreCase(atomBT) && noB == noAT && atomB.equalsIgnoreCase(atomAT)) {
                            isIn = false;
                        }
                        ++j;
                    }
                }
                if (isIn) {
                    vecNoeRefine2.add(noe);
                }
            }
            ++i;
        }
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecNoeRefine2);
        Vector<Pdb> vecRotStructure = pp.RotamSelectAndStructure(hnErr, nErr, c13Err, pdbVecNewSec, vecAsgNewT, srcRot, vecNewNoesy, 4.5, 1, constant[0]);
        Vector<Object> vecRefinedNoes = new Vector();
        int nIsoriginalUp = 0;
        double noeLimit = 5.0;
        vecRefinedNoes = asg.PrunAmbgNoeAsg(vecRotStructure, vecAmbgAsg, noeLimit, 0.0, nIsoriginalUp);
        Collections.sort(vecRefinedNoes, new Noe.NoeComparator());
        String strOutOrFormat = "0";
        if (!strOutOrFormat.equalsIgnoreCase("1")) {
            i = 0;
            while (i < vecAmbgAsg.size()) {
                Noe noe = (Noe)vecAmbgAsg.elementAt(i);
                int firstResNo = noe.getResidueNoA();
                int secondResNo = noe.getResidueNoB();
                String firstResName = noe.getResidueA();
                String secondResName = noe.getResidueB();
                String firstAtomName = noe.getAtomA();
                String secondAtomName = noe.getAtomB();
                if (secondResNo < firstResNo) {
                    noe.setResNoA(secondResNo);
                    noe.setResNoB(firstResNo);
                    noe.setAtom1Name(secondAtomName);
                    noe.setAtom2Name(firstAtomName);
                    noe.setResNameA(secondResName);
                    noe.setResNameB(firstResName);
                }
                ++i;
            }
            Collections.sort(vecAmbgAsg, new Noe.noeComparatorC());
        }
        if ((strIsCheckLongAA = "0").equalsIgnoreCase("1")) {
            Vector<Noe> vecTemp = new Vector<Noe>();
            i = 0;
            while (i < vecRefinedNoes.size()) {
                Noe noe = (Noe)vecRefinedNoes.elementAt(i);
                int firstResNo = noe.getResidueNoA();
                int secondResNo = noe.getResidueNoB();
                String firstResName = noe.getResidueA();
                String secondResName = noe.getResidueB();
                String atomA = noe.getAtomA();
                String atomB = noe.getAtomB();
                String subAtomA = atomA;
                String subAtomB = atomB;
                if (atomA.length() >= 2) {
                    subAtomA = atomA.substring(0, 2);
                }
                if (atomB.length() >= 2) {
                    subAtomB = atomB.substring(0, 2);
                }
                if (Math.abs(firstResNo - secondResNo) <= 4) {
                    vecTemp.add(noe);
                } else {
                    boolean isKeep = true;
                    if (pk.isCharged(firstResName) && pk.isHydrophobic(secondResName)) {
                        isKeep = false;
                    }
                    if (pk.isCharged(secondResName) && pk.isHydrophobic(firstResName)) {
                        isKeep = false;
                    }
                    if ((subAtomB.equalsIgnoreCase("HN") || subAtomB.equalsIgnoreCase("H") || subAtomB.equalsIgnoreCase("HA") || subAtomB.equalsIgnoreCase("HB")) && (subAtomA.equalsIgnoreCase("HN") || subAtomA.equalsIgnoreCase("H") || subAtomA.equalsIgnoreCase("HA") || subAtomA.equalsIgnoreCase("HB"))) {
                        isKeep = true;
                    }
                    if (isKeep) {
                        vecTemp.add(noe);
                    }
                }
                ++i;
            }
            vecRefinedNoes = new Vector();
            vecRefinedNoes.addAll(vecTemp);
        }
        Collections.sort(vecRefinedNoes, new Noe.NoeComparator());
        Noe ne = new Noe();
        Vector<Noe> vecNoeNewT = ne.NameConvertFromPDBNewToPDBNew(vecRefinedNoes);
        vecRefinedNoes = new Vector();
        vecRefinedNoes.addAll(vecNoeNewT);
        assignment.setNoeAsgs(vecRefinedNoes);
        return assignment;
    }

    public int RefineMappingDeeCutForCMD(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecHPositions, int[][] Map2, double[][] MapScore, Vector<Noesy> vecNewNoesy, Vector<H1CS> vecBMRBNew) {
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        int counter = 0;
        int j = 0;
        while (j < vecHPositions.size()) {
            String atom;
            String res;
            String heavyName;
            ProtonLabel nodeProton = vecHPositions.elementAt(j);
            if (!nodeProton.getIsAssigned() && !(heavyName = pk.GetHeavyAtomFromProton(res = nodeProton.getResName(), atom = nodeProton.getAtomName())).equalsIgnoreCase("CB")) {
                int resNo = nodeProton.getResNo();
                Vector<GraphNode> vecMapSet = nodeProton.getMappingSet();
                Vector<ProtonLabel> vecAdj = nodeProton.getAdjVec();
                if (vecMapSet.size() >= 1 && vecAdj.size() >= 1 && !nodeProton.getIsAssigned()) {
                    int k = 0;
                    while (k < vecMapSet.size()) {
                        double asgScore;
                        GraphNode ndMapCur = vecMapSet.elementAt(k);
                        boolean isPruned = false;
                        double csCur_proton = ndMapCur.getCSProton();
                        double csCur_heavy = ndMapCur.getCSHeavy();
                        Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
                        vecOneSCAsg.add(new H1CS(resNo, res, atom, csCur_proton));
                        vecOneSCAsg.add(new H1CS(resNo, res, heavyName, csCur_heavy));
                        double totalCurScore = asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsg, vecBMRBNew);
                        int t = 0;
                        while (t < vecAdj.size()) {
                            Vector<GraphNode> vecNdCurAdjMap;
                            ProtonLabel ndCurAdj = vecAdj.elementAt(t);
                            if (!ndCurAdj.getIsAssigned() && (vecNdCurAdjMap = ndCurAdj.getMappingSet()).size() >= 1) {
                                int resNoAdj = ndCurAdj.getResNo();
                                String resAdj = ndCurAdj.getResName();
                                String atomAdj = ndCurAdj.getAtomName();
                                String heavyNameAdj = pk.GetHeavyAtomFromProton(resAdj, atomAdj);
                                int maxAdjID = -1;
                                double maxScore = -9999.9;
                                Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
                                int a = 0;
                                while (a < vecNdCurAdjMap.size()) {
                                    GraphNode ndAdjMap = vecNdCurAdjMap.elementAt(a);
                                    Vector<Noesy> vecNoesyTwo = new Vector<Noesy>();
                                    vecNoesyTwo.addAll(ndMapCur.vecAdjNOESY);
                                    vecNoesyTwo.addAll(ndAdjMap.vecAdjNOESY);
                                    double csAdjMapProton = ndAdjMap.getCSProton();
                                    double csAdjMapHeavy = ndAdjMap.getCSHeavy();
                                    vecBackNoe.add(new BackNoe(csCur_proton, csCur_heavy, csAdjMapProton, 6.0, 0.0, resNo, resNoAdj, res, resAdj, atom, heavyName, atomAdj));
                                    vecBackNoe.add(new BackNoe(csAdjMapProton, csAdjMapHeavy, csCur_proton, 6.0, 0.0, resNoAdj, resNo, resAdj, res, atomAdj, heavyNameAdj, atom));
                                    Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                                    int[] numPeaks = new int[1];
                                    double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                                    dbScore *= (double)vecBackNoeNew.size();
                                    if (dbScore > maxScore) {
                                        maxScore = dbScore;
                                        maxAdjID = a;
                                    }
                                    ++a;
                                }
                                totalCurScore += maxScore;
                            }
                            ++t;
                        }
                        int h = 0;
                        while (h < vecMapSet.size()) {
                            if (h != k) {
                                double asgOtherScore;
                                GraphNode ndMapCurOther = vecMapSet.elementAt(h);
                                double csOther_proton = ndMapCurOther.getCSProton();
                                double csOther_heavy = ndMapCurOther.getCSHeavy();
                                Vector<H1CS> vecOneSCAsgOther = new Vector<H1CS>();
                                vecOneSCAsgOther.add(new H1CS(resNo, res, atom, csOther_proton));
                                vecOneSCAsgOther.add(new H1CS(resNo, res, heavyName, csOther_heavy));
                                double totalOtherScore = asgOtherScore = h1cs.BMRBSatisticsScore(vecOneSCAsgOther, vecBMRBNew);
                                int minAdjID = -1;
                                int t2 = 0;
                                while (t2 < vecAdj.size()) {
                                    Vector<GraphNode> vecNdCurAdjMap;
                                    ProtonLabel ndCurAdj = vecAdj.elementAt(t2);
                                    if (!ndCurAdj.getIsAssigned() && (vecNdCurAdjMap = ndCurAdj.getMappingSet()).size() >= 1) {
                                        int resNoAdj = ndCurAdj.getResNo();
                                        String resAdj = ndCurAdj.getResName();
                                        String atomAdj = ndCurAdj.getAtomName();
                                        String heavyNameAdj = pk.GetHeavyAtomFromProton(resAdj, atomAdj);
                                        minAdjID = -1;
                                        double minScore = 999999.9;
                                        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
                                        int a = 0;
                                        while (a < vecNdCurAdjMap.size()) {
                                            GraphNode ndAdjMap = vecNdCurAdjMap.elementAt(a);
                                            Vector<Noesy> vecNoesyTwo = new Vector<Noesy>();
                                            vecNoesyTwo.addAll(ndMapCurOther.vecAdjNOESY);
                                            vecNoesyTwo.addAll(ndAdjMap.vecAdjNOESY);
                                            double csAdjMapProton = ndAdjMap.getCSProton();
                                            double csAdjMapHeavy = ndAdjMap.getCSHeavy();
                                            vecBackNoe.add(new BackNoe(csCur_proton, csCur_heavy, csAdjMapProton, 6.0, 0.0, resNo, resNoAdj, res, resAdj, atom, heavyName, atomAdj));
                                            vecBackNoe.add(new BackNoe(csAdjMapProton, csAdjMapHeavy, csCur_proton, 6.0, 0.0, resNoAdj, resNo, resAdj, res, atomAdj, heavyNameAdj, atom));
                                            Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                                            int[] numPeaks = new int[1];
                                            double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                                            dbScore *= (double)vecBackNoeNew.size();
                                            if (dbScore < minScore) {
                                                minScore = dbScore;
                                                minAdjID = a;
                                            }
                                            ++a;
                                        }
                                        totalOtherScore += minScore;
                                    }
                                    ++t2;
                                }
                                if (totalCurScore < totalOtherScore) {
                                    isPruned = true;
                                    break;
                                }
                            }
                            ++h;
                        }
                        if (isPruned) {
                            Map2[ndMapCur.getID()][nodeProton.getID()] = 0;
                            ++counter;
                        }
                        ++k;
                    }
                }
            }
            ++j;
        }
        return counter;
    }

    public Vector<H1CS> AStarSearchForSCAsgsForCMD(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecHPositions, int[][] Map2, double[][] MapScore, Vector<Noesy> vecNewNoesy, Vector<H1CS> vecBMRBNew) {
        AStar astar = new AStar();
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        NascaNew nasca = new NascaNew();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        while (true) {
            boolean isAllAsg = true;
            double maxScore = -99999.9;
            int maxID = -1;
            int maxMapID = -1;
            int j = 0;
            while (j < vecHPositions.size()) {
                block13: {
                    ProtonLabel label = vecHPositions.elementAt(j);
                    String res = label.getResName();
                    String atom = label.getAtomName();
                    String heavName = pk.GetHeavyAtomFromProton(res, atom);
                    int resNo = label.getResNo();
                    Vector<GraphNode> vecMapSet = label.getMappingSet();
                    Vector<ProtonLabel> vecAdj = label.getAdjVec();
                    if (label.getIsAssigned()) break block13;
                    int k = 0;
                    while (k < vecMapSet.size()) {
                        block15: {
                            double hScore;
                            Vector<H1CS> vecOneSCAsgNew;
                            double asgScore;
                            double cs_heavy;
                            double cs_proton;
                            Vector<Noesy> vecNoesyTwo;
                            Vector<BackNoe> vecBackNoe;
                            Vector<H1CS> vecOneSCAsg;
                            block16: {
                                GraphNode ndStereoReson;
                                GraphNode nodeMap;
                                block14: {
                                    nodeMap = vecMapSet.elementAt(k);
                                    if (nodeMap.asgedId < 0) break block14;
                                    ProtonLabel nodeTemp = vecHPositions.elementAt(nodeMap.asgedId);
                                    if (nodeTemp.stereoID != label.getID() || nodeMap.vecStereoSymSet.size() > 0) break block15;
                                }
                                vecOneSCAsg = new Vector<H1CS>();
                                vecBackNoe = new Vector<BackNoe>();
                                vecNoesyTwo = new Vector<Noesy>();
                                Vector<Noesy> vecNoesy = nodeMap.vecAdjNOESY;
                                vecNoesyTwo.addAll(vecNoesy);
                                cs_proton = nodeMap.getCSProton();
                                cs_heavy = nodeMap.getCSHeavy();
                                if (label.stereoID < 0) break block16;
                                ProtonLabel nodeStereo = vecHPositions.elementAt(label.stereoID);
                                if (nodeStereo.asgedId >= 0 && Math.abs((ndStereoReson = vecResonGraph.elementAt(nodeStereo.asgedId)).getCSHeavy() - cs_heavy) > 0.15) break block15;
                            }
                            vecOneSCAsg.add(new H1CS(resNo, res, atom, cs_proton));
                            vecOneSCAsg.add(new H1CS(resNo, res, heavName, cs_heavy));
                            int t = 0;
                            while (t < vecAdj.size()) {
                                ProtonLabel nodeAdj = vecAdj.elementAt(t);
                                if (nodeAdj.getIsAssigned() && nodeAdj.asgedId >= 0) {
                                    GraphNode nodeAdjReson = vecResonGraph.elementAt(nodeAdj.asgedId);
                                    vecNoesyTwo.addAll(nodeAdjReson.vecAdjNOESY);
                                    int resNoSec = nodeAdj.getResNo();
                                    String resSec = nodeAdj.getResName();
                                    String atomSec = nodeAdj.getAtomName();
                                    String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                                    double cs_protonSec = nodeAdjReson.getCSProton();
                                    double cs_heavySec = nodeAdjReson.getCSHeavy();
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, atomSec, cs_protonSec));
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, heavyNameSec, cs_heavySec));
                                    double distUp = 6.0;
                                    if (nasca.isInCloseAdj(nodeAdj, label)) {
                                        distUp = 2.7;
                                    }
                                    vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, distUp, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                                    vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, distUp, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
                                }
                                ++t;
                            }
                            Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                            int[] numPeaks = new int[1];
                            double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                            double gScore = (dbScore *= (double)vecBackNoeNew.size()) + (asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg), vecBMRBNew));
                            double fScore = gScore + (hScore = astar.ComputeAStarEstimatedCost(vecResonGraph, vecHPositions, vecBMRBNew, j));
                            if (fScore > maxScore) {
                                maxScore = fScore;
                                maxID = j;
                                maxMapID = k;
                            }
                        }
                        ++k;
                    }
                    isAllAsg = false;
                }
                ++j;
            }
            if (isAllAsg || maxID <= 0) break;
            System.out.print("Current expansion node: ID=" + maxID + ", ");
            ProtonLabel label = vecHPositions.elementAt(maxID);
            Vector<GraphNode> vecMapSet = label.getMappingSet();
            GraphNode nodeMap = vecMapSet.elementAt(maxMapID);
            label.asgedId = nodeMap.getID();
            nodeMap.asgedId = label.getID();
            label.setIsAssigned(true);
            nodeMap.setIsAssigned(true);
            System.out.println(String.valueOf(label.getResNo()) + label.getResName() + " - " + label.getAtomName() + ": " + nodeMap.getCSProton() + " , " + nodeMap.getCSHeavy());
            if (label.stereoID <= 0) continue;
            ProtonLabel ndStereoProton = vecHPositions.elementAt(label.stereoID);
            Vector<GraphNode> vecStereoReson = nodeMap.vecStereoSymSet;
            if (vecStereoReson.size() <= 0) continue;
            if (vecStereoReson.size() == 1) {
                GraphNode ndStereoReson = vecStereoReson.elementAt(0);
                ndStereoProton.asgedId = ndStereoReson.getID();
                ndStereoReson.asgedId = ndStereoProton.getID();
                ndStereoProton.setIsAssigned(true);
                ndStereoReson.setIsAssigned(true);
                continue;
            }
            Vector<GraphNode> vecStereoProtonMap = ndStereoProton.getMappingSet();
            vecStereoProtonMap = new Vector();
            vecStereoProtonMap.addAll(vecMapSet);
        }
        Vector<H1CS> vecAsg = new Vector<H1CS>();
        int j = 0;
        while (j < vecHPositions.size()) {
            ProtonLabel node2 = vecHPositions.elementAt(j);
            String resName = node2.getResName();
            String atomName = node2.getAtomName();
            String heavName = pk.GetHeavyAtomFromProton(resName, atomName);
            int resNo = node2.getResNo();
            int resonID = node2.asgedId;
            if (resonID >= 0) {
                GraphNode nodeResonAsg = vecResonGraph.elementAt(resonID);
                double cs_proton = nodeResonAsg.getCSProton();
                double cs_heavy = nodeResonAsg.getCSHeavy();
                vecAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
                vecAsg.add(new H1CS(resNo, resName, heavName, cs_heavy));
            }
            ++j;
        }
        return vecAsg;
    }
}

