/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;

public class Hsqc {
    private int peakNo;
    private int residueNo;
    private String residue;
    private double csH1;
    private double csN15;
    private double intensity;

    public Hsqc() {
        this.peakNo = 0;
        this.residueNo = 0;
        this.residue = null;
        this.csH1 = 0.0;
        this.csN15 = 0.0;
        this.intensity = 0.0;
    }

    public Hsqc(int no) {
        this.peakNo = 0;
        this.residueNo = no;
        this.residue = null;
        this.csH1 = 0.0;
        this.csN15 = 0.0;
        this.intensity = 0.0;
    }

    public Hsqc(int pkNo, int no, String resid, double H1, double N15, double inten) {
        this.peakNo = pkNo;
        this.residueNo = no;
        this.residue = resid;
        this.csH1 = H1;
        this.csN15 = N15;
        this.intensity = inten;
    }

    public int getPeakNo() {
        return this.peakNo;
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public String getResidueType() {
        return this.residue;
    }

    public double getHN() {
        return this.csH1;
    }

    public double getN15() {
        return this.csN15;
    }

    public double getInt() {
        return this.intensity;
    }

    public void setResidueNo(int R) {
        this.residueNo = R;
    }

    public void setResidueType(String type) {
        this.residue = type;
    }

    public String toString() {
        String desc = String.valueOf(String.valueOf(this.peakNo)) + "     " + String.valueOf(this.residueNo) + "    " + this.residue + "      " + String.valueOf(this.csH1) + "     " + String.valueOf(this.csN15) + "     " + (96.0 - this.csN15) + "    " + String.valueOf(this.intensity);
        return desc;
    }

    public Vector hsqcRead(String filename) {
        double foldCorrect = 0.0;
        Vector<Hsqc> inputs = new Vector<Hsqc>();
        boolean resNo = false;
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(filename));
            while (in.nextToken() != -1) {
                if (in.ttype == -3 || in.ttype != -2) continue;
                int pkNo = (int)in.nval;
                in.nextToken();
                double csH1 = in.nval;
                in.nextToken();
                in.nextToken();
                in.nextToken();
                double csN15 = in.nval;
                in.nextToken();
                in.nextToken();
                in.nextToken();
                double intensity = in.nval;
                in.nextToken();
                in.nextToken();
                inputs.add(new Hsqc(pkNo, 0, "", csH1, csN15, intensity));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector hsqcReader2(String filename) {
        Vector<Hsqc> inputs = new Vector<Hsqc>();
        int resNo = 0;
        try {
            StreamTokenizer in = new StreamTokenizer(new FileReader(filename));
            while (in.nextToken() != -1) {
                if (in.ttype == -3 || in.ttype != -2) continue;
                resNo = (int)in.nval;
                in.nextToken();
                int pkNo = (int)in.nval;
                in.nextToken();
                in.nextToken();
                double csH1 = in.nval;
                in.nextToken();
                double csN15 = in.nval;
                in.nextToken();
                double intensity = in.nval;
                inputs.add(new Hsqc(pkNo, resNo, "", csH1, csN15, intensity));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector hsqcReader3(String filename) {
        double foldCorrect = 96.0;
        Vector<Hsqc> inputs = new Vector<Hsqc>();
        double csHA = 0.0;
        double csC13 = 0.0;
        double intensity = 0.0;
        Vector csVec = new Vector();
        StringTokenizer st = new StringTokenizer("");
        String str = "";
        boolean index1 = false;
        boolean index2 = false;
        String order = "";
        double value = 0.0;
        int pkNo = 0;
        int resNo = 0;
        String aaType = "";
        String ss = "";
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            do {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    pkNo = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    resNo = Integer.parseInt(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csHA = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csC13 = foldCorrect - new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    intensity = new Double(st.nextToken());
                }
                inputs.add(new Hsqc(pkNo, resNo, "", csHA, csC13, intensity));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector rangeSearch(String nucType, double a, double b, Vector pkVec) {
        Vector outVec = new Vector();
        double csValue = 0.0;
        int i = 0;
        while (i < pkVec.size()) {
            if (nucType.equals("H1")) {
                csValue = ((Hsqc)pkVec.elementAt(i)).getHN();
            } else if (nucType.equals("N15")) {
                csValue = ((Hsqc)pkVec.elementAt(i)).getN15();
            }
            if (csValue >= a && csValue <= b) {
                outVec.add(pkVec.elementAt(i));
            }
            ++i;
        }
        return outVec;
    }

    public static class hnComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Hsqc n1 = (Hsqc)o1;
            Hsqc n2 = (Hsqc)o2;
            double d1 = n1.getHN();
            if (d1 < (d2 = n2.getHN())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class n15Comparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Hsqc n1 = (Hsqc)o1;
            Hsqc n2 = (Hsqc)o2;
            double d1 = n1.getN15();
            if (d1 > (d2 = n2.getN15())) {
                return -1;
            }
            if (d1 < d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class peakNoComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Hsqc n1 = (Hsqc)o1;
            Hsqc n2 = (Hsqc)o2;
            double d1 = n1.getPeakNo();
            if (d1 < (d2 = (double)n2.getPeakNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class resNoComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Hsqc n1 = (Hsqc)o1;
            Hsqc n2 = (Hsqc)o2;
            double d1 = n1.getResidueNo();
            if (d1 < (d2 = (double)n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

