/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Random;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.Cartesian;
import rdcPanda.Hbond;
import rdcPanda.Matrix;
import rdcPanda.Noe;
import rdcPanda.Pdb;
import rdcPanda.RotaPattern;
import rdcPanda.SSEPacking;
import rdcPanda.vdw;

public class PdbRmsd {
    private Vector pdbVecA = new Vector();
    private Vector pdbVecB = new Vector();
    static final String[] atomNameArrA = new String[]{"N", "C"};
    static final String[] atomNameArrB = new String[]{"N", "C"};
    public boolean isSkipOutEnsembe = false;

    public PdbRmsd() {
        this.pdbVecA = new Vector();
        this.pdbVecB = new Vector();
    }

    public Vector getPdbVecA() {
        return this.pdbVecA;
    }

    public Vector getPdbVecB() {
        return this.pdbVecB;
    }

    public double interAngle(double[] v1, double[] v2) {
        double v1Len = Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]);
        double v2Len = Math.sqrt(v2[0] * v2[0] + v2[1] * v2[1] + v2[2] * v2[2]);
        return (v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2]) / (v1Len * v2Len);
    }

    public double[] dirCos(double[] vec) {
        double len = 0.0;
        double[] dirs = new double[vec.length];
        int i = 0;
        while (i < vec.length) {
            len += vec[i] * vec[i];
            ++i;
        }
        int j = 0;
        while (j < vec.length) {
            dirs[j] = vec[j] / Math.sqrt(len);
            ++j;
        }
        return dirs;
    }

    public double[] centerCal(Vector pdbVec) {
        Pdb pp = new Pdb();
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        int mm = pdbVec.size();
        int m = 0;
        String atom = "";
        int i = 0;
        while (i < pdbVec.size()) {
            pp = (Pdb)pdbVec.elementAt(i);
            atomVec = pp.getAtomVec();
            int j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                int k = 0;
                while (k < atomNameArrA.length) {
                    if (atom.equals(atomNameArrA[k])) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        xC1 += cc.getX();
                        yC1 += cc.getY();
                        zC1 += cc.getZ();
                        ++m;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (m > 0) {
            xC1 /= (double)m;
            yC1 /= (double)m;
            zC1 /= (double)m;
        }
        return new double[]{xC1, yC1, zC1};
    }

    public double[] centerCal(double[][] pdbVec) {
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        int mm = pdbVec.length;
        int i = 0;
        while (i < mm) {
            xC1 += pdbVec[i][0];
            yC1 += pdbVec[i][1];
            zC1 += pdbVec[i][2];
            ++i;
        }
        if (mm > 0) {
            xC1 /= (double)mm;
            yC1 /= (double)mm;
            zC1 /= (double)mm;
        }
        return new double[]{xC1, yC1, zC1};
    }

    public double[] centerCalNew(Vector vecCC) {
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        int mm = vecCC.size();
        int i = 0;
        while (i < vecCC.size()) {
            Cartesian ccTemp = (Cartesian)vecCC.elementAt(i);
            double[] coord = new double[]{0.0, 0.0, 0.0};
            coord = ccTemp.getXYZ();
            xC1 += coord[0];
            yC1 += coord[1];
            zC1 += coord[2];
            ++i;
        }
        if (mm > 0) {
            xC1 /= (double)mm;
            yC1 /= (double)mm;
            zC1 /= (double)mm;
        }
        return new double[]{xC1, yC1, zC1};
    }

    public double centerFit(Vector pdbVecA, Vector pdbVecB, Vector hbVec, boolean debug) {
        boolean debug2 = false;
        int noOfAtoms = hbVec.size();
        double[][] hPartnerOfA = new double[noOfAtoms][3];
        double[][] coordOfA = new double[noOfAtoms][3];
        double[][] dirsOfA = new double[noOfAtoms][3];
        double[][] hPartnerOfB = new double[noOfAtoms][3];
        double[][] coordOfB = new double[noOfAtoms][3];
        double[][] dirsOfB = new double[noOfAtoms][3];
        Pdb pp = new Pdb();
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        String atom = "";
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] n2NHVec = new double[3];
        double[] co = new double[3];
        double[] o = new double[3];
        double[] co2OVec = new double[3];
        int residueNo = 0;
        Hbond hb = new Hbond();
        boolean isN = false;
        int index = -1;
        int i = 0;
        while (i < noOfAtoms) {
            int j;
            hb = (Hbond)hbVec.elementAt(i);
            int residueNoA = hb.getResidueNoA();
            String atomA = hb.getAtomA();
            index = Collections.binarySearch(pdbVecA, new Pdb(residueNoA), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecA.elementAt(index);
                residueNo = pp.getResidueNo();
                atomVec = pp.getAtomVec();
                if (atomA.equals("O")) {
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("C")) {
                            co = cc.getXYZ();
                        } else if (atom.equals("O")) {
                            o = cc.getXYZ();
                            coordOfA[i] = new double[]{o[0], o[1], o[2]};
                        }
                        ++j;
                    }
                    hPartnerOfA[i] = new double[]{o[0] + (o[0] - co[0]) * 2.88 / 1.231, o[1] + (o[1] - co[1]) * 2.88 / 1.231, o[2] + (o[2] - co[2]) * 2.88 / 1.231};
                    dirsOfA[i] = new double[]{o[0] - co[0], o[1] - co[1], o[2] - co[2]};
                    if (debug2) {
                        System.out.println(residueNoA);
                        System.out.println("O: " + i + "  " + coordOfA[i][0] + "  " + coordOfA[i][1] + "   " + coordOfA[i][2]);
                        System.out.println("A: " + i + "  " + dirsOfA[i][0] + "  " + dirsOfA[i][1] + "   " + dirsOfA[i][2]);
                    }
                } else if (atomA.equals("N")) {
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("N")) {
                            amide = cc.getXYZ();
                            coordOfA[i] = new double[]{amide[0], amide[1], amide[2]};
                        } else if (atom.equals("H")) {
                            nh = cc.getXYZ();
                        }
                        ++j;
                    }
                    hPartnerOfA[i] = new double[]{amide[0] + (nh[0] - amide[0]) * 2.88 / 1.02, amide[1] + (nh[1] - amide[1]) * 2.88 / 1.02, amide[2] + (nh[2] - amide[2]) * 2.88 / 1.02};
                    dirsOfA[i] = new double[]{nh[0] - amide[0], nh[1] - amide[1], nh[2] - amide[2]};
                    if (debug2) {
                        System.out.println(residueNoA);
                        System.out.println("N: " + i + "  " + coordOfA[i][0] + "  " + coordOfA[i][1] + "   " + coordOfA[i][2]);
                        System.out.println("A: " + i + "  " + dirsOfA[i][0] + "  " + dirsOfA[i][1] + "   " + dirsOfA[i][2]);
                    }
                }
            }
            int residueNoB = hb.getResidueNoB();
            String atomB = hb.getAtomB();
            index = Collections.binarySearch(pdbVecB, new Pdb(residueNoB), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecB.elementAt(index);
                residueNo = pp.getResidueNo();
                atomVec = pp.getAtomVec();
                if (atomB.equals("O")) {
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("C")) {
                            co = cc.getXYZ();
                        } else if (atom.equals("O")) {
                            o = cc.getXYZ();
                            coordOfB[i] = new double[]{o[0], o[1], o[2]};
                        }
                        ++j;
                    }
                    dirsOfB[i] = new double[]{o[0] - co[0], o[1] - co[1], o[2] - co[2]};
                    if (debug2) {
                        System.out.println(residueNoB);
                        System.out.println("O: " + i + "  " + coordOfB[i][0] + " : " + coordOfB[i][1] + "   " + coordOfB[i][2]);
                    }
                } else if (atomB.equals("N")) {
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("N")) {
                            amide = cc.getXYZ();
                            coordOfB[i] = new double[]{amide[0], amide[1], amide[2]};
                        } else if (atom.equals("H")) {
                            nh = cc.getXYZ();
                        }
                        ++j;
                    }
                    hPartnerOfB[i] = new double[]{amide[0] + (nh[0] - amide[0]) * 2.88 / 1.02, amide[1] + (nh[1] - amide[1]) * 2.88 / 1.02, amide[2] + (nh[2] - amide[2]) * 2.88 / 1.02};
                    dirsOfB[i] = new double[]{nh[0] - amide[0], nh[1] - amide[1], nh[2] - amide[2]};
                    if (debug2) {
                        System.out.println(residueNoB);
                        System.out.println("N: " + i + "  " + coordOfB[i][0] + " : " + coordOfB[i][1] + "   " + coordOfB[i][2]);
                    }
                }
            }
            ++i;
        }
        double[] centerOfPartnersOfA = this.centerCal(hPartnerOfA);
        double[] centerOfB = this.centerCal(coordOfB);
        double[] cT = new double[]{centerOfPartnersOfA[0] - centerOfB[0], centerOfPartnersOfA[1] - centerOfB[1], centerOfPartnersOfA[2] - centerOfB[2]};
        Vector<Pdb> pdbVec2N = pp.newPdbByTranslation(pdbVecB, cT);
        double disRms = 0.0;
        double angleRms = 0.0;
        double[][] coordOfBN = new double[noOfAtoms][3];
        i = 0;
        while (i < coordOfB.length) {
            coordOfBN[i] = new double[]{coordOfB[i][0] + cT[0], coordOfB[i][1] + cT[1], coordOfB[i][2] + cT[2]};
            double x2 = coordOfBN[i][0];
            double y2 = coordOfBN[i][1];
            double z2 = coordOfBN[i][2];
            double x1 = coordOfA[i][0];
            double y1 = coordOfA[i][1];
            double z1 = coordOfA[i][2];
            double disHBond = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
            disRms += (disHBond - 2.88) * (disHBond - 2.88);
            double cosAngle = this.interAngle(dirsOfA[i], dirsOfB[i]);
            angleRms += (cosAngle + 1.0) * (cosAngle + 1.0);
            if (debug) {
                System.out.println("Distance = " + disHBond + "  Angle = " + cosAngle);
            }
            ++i;
        }
        if (noOfAtoms > 0) {
            angleRms = Math.sqrt(angleRms / (double)coordOfB.length);
            disRms = Math.sqrt(disRms / (double)coordOfB.length);
        }
        if (debug) {
            System.out.println(String.valueOf(disRms) + "  " + angleRms);
        }
        return angleRms + disRms;
    }

    public Vector centerFitVec(Vector pdbVecA, Vector pdbVecB, Vector hbVec, boolean debug) {
        double disHBond;
        double z1;
        double y1;
        double x1;
        double z2;
        double y2;
        double x2;
        boolean debug2 = false;
        int noOfAtoms = hbVec.size();
        double[][] hPartnerOfA = new double[noOfAtoms][3];
        double[][] coordOfA = new double[noOfAtoms][3];
        double[][] dirsOfA = new double[noOfAtoms][3];
        double[][] hPartnerOfB = new double[noOfAtoms][3];
        double[][] coordOfB = new double[noOfAtoms][3];
        double[][] dirsOfB = new double[noOfAtoms][3];
        Pdb pp = new Pdb();
        Cartesian cc = new Cartesian();
        Vector<Object> atomVec = new Vector();
        String atom = "";
        double[] amide = new double[3];
        double[] nh = new double[3];
        double[] n2NHVec = new double[3];
        double[] co = new double[3];
        double[] o = new double[3];
        double[] co2OVec = new double[3];
        int residueNo = 0;
        Hbond hb = new Hbond();
        boolean isN = false;
        int index = -1;
        int i = 0;
        while (i < noOfAtoms) {
            int j;
            hb = (Hbond)hbVec.elementAt(i);
            int residueNoA = hb.getResidueNoA();
            String atomA = hb.getAtomA();
            index = Collections.binarySearch(pdbVecA, new Pdb(residueNoA), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecA.elementAt(index);
                residueNo = pp.getResidueNo();
                atomVec = pp.getAtomVec();
                if (atomA.equals("O")) {
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("C")) {
                            co = cc.getXYZ();
                        } else if (atom.equals("O")) {
                            o = cc.getXYZ();
                            coordOfA[i] = new double[]{o[0], o[1], o[2]};
                        }
                        ++j;
                    }
                    hPartnerOfA[i] = new double[]{o[0] + (o[0] - co[0]) * 2.88 / 1.231, o[1] + (o[1] - co[1]) * 2.88 / 1.231, o[2] + (o[2] - co[2]) * 2.88 / 1.231};
                    dirsOfA[i] = new double[]{o[0] - co[0], o[1] - co[1], o[2] - co[2]};
                    if (debug2) {
                        System.out.println(residueNoA);
                        System.out.println("O: " + i + "  " + coordOfA[i][0] + "  " + coordOfA[i][1] + "   " + coordOfA[i][2]);
                        System.out.println("A: " + i + "  " + dirsOfA[i][0] + "  " + dirsOfA[i][1] + "   " + dirsOfA[i][2]);
                    }
                } else if (atomA.equals("N")) {
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("N")) {
                            amide = cc.getXYZ();
                            coordOfA[i] = new double[]{amide[0], amide[1], amide[2]};
                        } else if (atom.equals("H")) {
                            nh = cc.getXYZ();
                        }
                        ++j;
                    }
                    hPartnerOfA[i] = new double[]{amide[0] + (nh[0] - amide[0]) * 2.88 / 1.02, amide[1] + (nh[1] - amide[1]) * 2.88 / 1.02, amide[2] + (nh[2] - amide[2]) * 2.88 / 1.02};
                    dirsOfA[i] = new double[]{nh[0] - amide[0], nh[1] - amide[1], nh[2] - amide[2]};
                    if (debug2) {
                        System.out.println(residueNoA);
                        System.out.println("N: " + i + "  " + coordOfA[i][0] + "  " + coordOfA[i][1] + "   " + coordOfA[i][2]);
                        System.out.println("A: " + i + "  " + dirsOfA[i][0] + "  " + dirsOfA[i][1] + "   " + dirsOfA[i][2]);
                    }
                }
            }
            int residueNoB = hb.getResidueNoB();
            String atomB = hb.getAtomB();
            index = Collections.binarySearch(pdbVecB, new Pdb(residueNoB), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecB.elementAt(index);
                residueNo = pp.getResidueNo();
                atomVec = pp.getAtomVec();
                if (atomB.equals("O")) {
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("C")) {
                            co = cc.getXYZ();
                        } else if (atom.equals("O")) {
                            o = cc.getXYZ();
                            coordOfB[i] = new double[]{o[0], o[1], o[2]};
                        }
                        ++j;
                    }
                    dirsOfB[i] = new double[]{o[0] - co[0], o[1] - co[1], o[2] - co[2]};
                    if (debug2) {
                        System.out.println(residueNoB);
                        System.out.println("O: " + i + "  " + coordOfB[i][0] + " : " + coordOfB[i][1] + "   " + coordOfB[i][2]);
                    }
                } else if (atomB.equals("N")) {
                    j = 0;
                    while (j < atomVec.size()) {
                        cc = (Cartesian)atomVec.elementAt(j);
                        atom = cc.getAtom();
                        if (atom.equals("N")) {
                            amide = cc.getXYZ();
                            coordOfB[i] = new double[]{amide[0], amide[1], amide[2]};
                        } else if (atom.equals("H")) {
                            nh = cc.getXYZ();
                        }
                        ++j;
                    }
                    hPartnerOfB[i] = new double[]{amide[0] + (nh[0] - amide[0]) * 2.88 / 1.02, amide[1] + (nh[1] - amide[1]) * 2.88 / 1.02, amide[2] + (nh[2] - amide[2]) * 2.88 / 1.02};
                    dirsOfB[i] = new double[]{nh[0] - amide[0], nh[1] - amide[1], nh[2] - amide[2]};
                    if (debug2) {
                        System.out.println(residueNoB);
                        System.out.println("N: " + i + "  " + coordOfB[i][0] + " : " + coordOfB[i][1] + "   " + coordOfB[i][2]);
                    }
                }
            }
            ++i;
        }
        double[] centerOfPartnersOfA = this.centerCal(hPartnerOfA);
        double[] centerOfB = this.centerCal(coordOfB);
        double[] cT1 = new double[]{centerOfPartnersOfA[0] - centerOfB[0], centerOfPartnersOfA[1] - centerOfB[1], centerOfPartnersOfA[2] - centerOfB[2]};
        double cosAngle = 0.0;
        double disRms = 0.0;
        double angleRms = 0.0;
        double[][] coordOfBN = new double[noOfAtoms][3];
        double[] cT = new double[3];
        double[] cTSave = new double[3];
        long seed = 9752864L;
        Random rr = new Random(seed);
        int nCycle = 1;
        double rT = 0.0;
        double rTotal = 100.0;
        double disRmsS = 0.0;
        double angleRmsS = 0.0;
        double range = 0.0;
        int mm = 0;
        while (mm < nCycle) {
            disRms = 0.0;
            angleRms = 0.0;
            cT[0] = cT1[0] + range * (0.5 - rr.nextDouble());
            cT[1] = cT1[1] + range * (0.5 - rr.nextDouble());
            cT[2] = cT1[2] + range * (0.5 - rr.nextDouble());
            i = 0;
            while (i < coordOfB.length) {
                coordOfBN[i] = new double[]{coordOfB[i][0] + cT[0], coordOfB[i][1] + cT[1], coordOfB[i][2] + cT[2]};
                x2 = coordOfBN[i][0];
                y2 = coordOfBN[i][1];
                z2 = coordOfBN[i][2];
                x1 = coordOfA[i][0];
                y1 = coordOfA[i][1];
                z1 = coordOfA[i][2];
                disHBond = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
                disRms += (disHBond - 2.88) * (disHBond - 2.88);
                cosAngle = this.interAngle(dirsOfA[i], dirsOfB[i]);
                angleRms += (cosAngle + 1.0) * (cosAngle + 1.0);
                ++i;
            }
            rT = disRms;
            if (rT < rTotal) {
                if (debug) {
                    System.out.println("DisRms= " + Math.sqrt(disRms / (double)coordOfB.length) + "; AngleRms=" + Math.sqrt(angleRms / (double)coordOfB.length));
                }
                rTotal = rT;
                System.arraycopy(cT, 0, cTSave, 0, 3);
                disRmsS = disRms;
                angleRmsS = angleRms;
            }
            ++mm;
        }
        i = 0;
        while (i < coordOfB.length) {
            coordOfBN[i] = new double[]{coordOfB[i][0] + cTSave[0], coordOfB[i][1] + cTSave[1], coordOfB[i][2] + cTSave[2]};
            x2 = coordOfBN[i][0];
            y2 = coordOfBN[i][1];
            z2 = coordOfBN[i][2];
            x1 = coordOfA[i][0];
            y1 = coordOfA[i][1];
            z1 = coordOfA[i][2];
            disHBond = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
            disRms += (disHBond - 2.88) * (disHBond - 2.88);
            cosAngle = this.interAngle(dirsOfA[i], dirsOfB[i]);
            angleRms += (cosAngle + 1.0) * (cosAngle + 1.0);
            if (debug) {
                System.out.println("Dis= " + disHBond + "  Angle = " + cosAngle);
            }
            ++i;
        }
        if (noOfAtoms > 0) {
            angleRms = Math.sqrt(angleRmsS / (double)coordOfB.length);
            disRms = Math.sqrt(disRmsS / (double)coordOfB.length);
        }
        Vector<Pdb> pdbVec2N = pp.newPdbByTranslation(pdbVecB, cTSave);
        if (debug) {
            System.out.println(String.valueOf(disRms) + "  " + angleRms);
        }
        return pdbVec2N;
    }

    public Vector positionByNOENew(Vector noeVec, Vector pdbVecA, Vector pdbVecB, double[] noeRms, boolean debugNOE, Vector vecUpdateNOE) {
        int noB;
        int j;
        int noA;
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        String atom = "";
        Pdb pp = new Pdb();
        double[][] newArrB = new double[pdbVecB.size()][3];
        int index = -1;
        String atomA = "";
        String atomB = "";
        int sizeA = 0;
        int sizeB = 0;
        double[][] pdbA2 = new double[noeVec.size()][3];
        double[][] pdbB2 = new double[noeVec.size()][3];
        Vector<String> id4A = new Vector<String>();
        Vector<String> id4B = new Vector<String>();
        String id = "";
        double[][] noeDistance = new double[noeVec.size()][2];
        int i = 0;
        while (i < noeVec.size()) {
            noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
            id = String.valueOf(String.valueOf(noA)) + "CA";
            index = Collections.binarySearch(pdbVecA, new Pdb(noA), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecA.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("CA") && !id4A.contains(id)) {
                        pdbA2[sizeA] = cc.getXYZ();
                        id4A.add(id);
                        ++sizeA;
                    }
                    ++j;
                }
            }
            noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
            id = String.valueOf(String.valueOf(noB)) + "CA";
            index = Collections.binarySearch(pdbVecB, new Pdb(noB), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecB.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase("CA") && !id4B.contains(id)) {
                        pdbB2[sizeB] = cc.getXYZ();
                        id4B.add(id);
                        ++sizeB;
                    }
                    ++j;
                }
            }
            noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
            ++i;
        }
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        double xC2 = 0.0;
        double yC2 = 0.0;
        double zC2 = 0.0;
        i = 0;
        while (i < pdbA2.length) {
            xC1 += pdbA2[i][0];
            yC1 += pdbA2[i][1];
            zC1 += pdbA2[i][2];
            ++i;
        }
        if (pdbA2.length > 0) {
            xC1 /= (double)sizeA;
            yC1 /= (double)sizeA;
            zC1 /= (double)sizeA;
        }
        i = 0;
        while (i < pdbB2.length) {
            xC2 += pdbB2[i][0];
            yC2 += pdbB2[i][1];
            zC2 += pdbB2[i][2];
            ++i;
        }
        if (pdbB2.length > 0) {
            xC2 /= (double)sizeB;
            yC2 /= (double)sizeB;
            zC2 /= (double)sizeB;
        }
        double lengthR = 0.0;
        double[] trans_vecA = new double[3];
        double[] trans_vecB = new double[3];
        double[] centerA = new double[]{xC1, yC1, zC1};
        double[] centerB = new double[]{xC2, yC2, zC2};
        double[] centerO = new double[]{0.0, 0.0, 0.0};
        trans_vecA = pp.internuclearVec(centerA, centerO);
        trans_vecB = pp.internuclearVec(centerB, centerO);
        Vector<Pdb> pdbVecNewA = pp.newPdbByTranslation(pdbVecA, trans_vecA);
        Vector<Pdb> pdbVecNewB = pp.newPdbByTranslation(pdbVecB, trans_vecB);
        double ranThetaS = 0.0;
        double ranPhiS = 0.0;
        double low = 0.0;
        double upper = 0.0;
        int resolution = 2;
        int radiusBound = 40;
        double lenS = 0.0;
        double dbScore = 0.0;
        Assign asg = new Assign();
        double maxSc = -999999.9;
        Vector<SSEPacking> vecSSEPack = new Vector<SSEPacking>();
        double disRms = 0.0;
        int mm = noeVec.size();
        double disRmsd = 1000.0;
        double[] noeDis = new double[mm];
        int m = 0;
        while (m < 180 / resolution) {
            double ranTheta = (double)(m * resolution) * Math.PI / 180.0;
            j = 0;
            while (j < 360 / resolution) {
                double ranPhi = (double)(j * resolution) * Math.PI / 360.0;
                int k = radiusBound;
                while (k > 0) {
                    lengthR = 2.0 + (double)k * 0.2;
                    double[] centerBNew = new double[]{lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), lengthR * Math.cos(ranTheta)};
                    double[] trans_vec = new double[3];
                    trans_vec = pp.internuclearVec(centerO, centerBNew);
                    Vector<Pdb> pdbVecNewB2 = pp.newPdbByTranslation(pdbVecNewB, trans_vec);
                    disRms = 0.0;
                    i = 0;
                    while (i < noeVec.size()) {
                        noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
                        atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
                        noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
                        atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
                        noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
                        double[] dis = new double[1];
                        double[] distance = new double[1];
                        pp.measurePackDisAllRotamers(pdbVecNewA, pdbVecNewB2, noA, atomA, noB, atomB, noeDistance[i][0], noeDistance[i][1], dis, distance);
                        noeDis[i] = dis[0];
                        disRms += noeDis[i] * noeDis[i];
                        ++i;
                    }
                    if (Math.abs((disRms = Math.sqrt(disRms / (double)mm)) - 0.0) < 1.0E-4) {
                        System.out.println("here we have one packing satisfying noe constraints:");
                        System.out.println(String.valueOf(disRms) + " ... " + ranTheta + "  " + ranPhi + "  " + lengthR);
                        double[] centerBNewTemp = new double[3];
                        centerBNewTemp = new double[]{lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), lengthR * Math.cos(ranTheta)};
                        trans_vecB = pp.internuclearVec(centerO, centerBNewTemp);
                        Vector<Pdb> pdbVecNewBTemp = pp.newPdbByTranslation(pdbVecNewB, trans_vecB);
                        Vector<Pdb> ppVecT = new Vector<Pdb>();
                        ppVecT.addAll(pdbVecNewA);
                        ppVecT.addAll(pdbVecNewBTemp);
                        Collections.sort(ppVecT, new Pdb.PdbComparator());
                        pp.print(ppVecT);
                        System.out.println("TER");
                        System.out.println("END");
                    }
                    if (disRms < disRmsd) {
                        ranThetaS = ranTheta;
                        ranPhiS = ranPhi;
                        disRmsd = disRms;
                        lenS = lengthR;
                        System.out.println(String.valueOf(disRmsd) + " ... " + ranThetaS + "  " + ranPhiS + "  " + lenS);
                    }
                    --k;
                }
                ++j;
            }
            ++m;
        }
        vecSSEPack.add(new SSEPacking(ranThetaS, ranPhiS, lenS, disRmsd));
        Collections.sort(vecSSEPack, new SSEPacking.SSEPackingComparator());
        double[] centerBNew2 = new double[3];
        Vector vecPackEnsemble = new Vector();
        i = 0;
        while (i < vecSSEPack.size()) {
            SSEPacking ssePack = (SSEPacking)vecSSEPack.elementAt(i);
            ranThetaS = ssePack.getTheta();
            ranPhiS = ssePack.getPhi();
            lenS = ssePack.getLengthR();
            centerBNew2 = new double[]{lenS * Math.sin(ranThetaS) * Math.cos(ranPhiS), lenS * Math.sin(ranThetaS) * Math.sin(ranPhiS), lenS * Math.cos(ranThetaS)};
            trans_vecB = pp.internuclearVec(centerO, centerBNew2);
            Vector<Pdb> pdbVecNewBFinal = pp.newPdbByTranslation(pdbVecNewB, trans_vecB);
            Vector<Pdb> ppVecT = new Vector<Pdb>();
            ppVecT.addAll(pdbVecNewA);
            ppVecT.addAll(pdbVecNewBFinal);
            Collections.sort(ppVecT, new Pdb.PdbComparator());
            vecPackEnsemble.add(ppVecT);
            ++i;
        }
        noeRms[0] = ((SSEPacking)vecSSEPack.elementAt(0)).getScore();
        return vecPackEnsemble;
    }

    public Vector positionByNOE_old(Vector noeVec, Vector pdbVecA, Vector pdbVecB, double[] noeRms, boolean debugNOE, Vector vecUpdateNOE) {
        int j;
        int index = -1;
        String atom = "";
        String atomA = "";
        String atomB = "";
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Pdb pp = new Pdb();
        int sizeA = 0;
        int sizeB = 0;
        double[][] pdbA2 = new double[noeVec.size()][3];
        double[][] pdbB2 = new double[noeVec.size()][3];
        Vector<String> id4A = new Vector<String>();
        Vector<String> id4B = new Vector<String>();
        String id = "";
        double[][] pdbA = new double[noeVec.size()][3];
        double[][] pdbB = new double[noeVec.size()][3];
        double[][] noeDistance = new double[noeVec.size()][2];
        int i = 0;
        while (i < noeVec.size()) {
            int noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
            atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
            id = String.valueOf(String.valueOf(noA)) + atomA;
            index = Collections.binarySearch(pdbVecA, new Pdb(noA), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecA.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase(atomA)) {
                        pdbA[i] = cc.getXYZ();
                    }
                    if (atom.equalsIgnoreCase(atomA) && !id4A.contains(id)) {
                        pdbA2[sizeA] = cc.getXYZ();
                        id4A.add(id);
                        ++sizeA;
                    }
                    ++j;
                }
            }
            int noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
            atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
            id = String.valueOf(String.valueOf(noB)) + atomB;
            index = Collections.binarySearch(pdbVecB, new Pdb(noB), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecB.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.equalsIgnoreCase(atomB)) {
                        pdbB[i] = cc.getXYZ();
                    }
                    if (atom.equalsIgnoreCase(atomB) && !id4B.contains(id)) {
                        pdbB2[sizeB] = cc.getXYZ();
                        id4B.add(id);
                        ++sizeB;
                    }
                    ++j;
                }
            }
            noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
            ++i;
        }
        int n = 3;
        int mm = pdbA.length;
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        double xC2 = 0.0;
        double yC2 = 0.0;
        double zC2 = 0.0;
        double noeAve = 0.0;
        i = 0;
        while (i < sizeA) {
            xC1 += pdbA2[i][0];
            yC1 += pdbA2[i][1];
            zC1 += pdbA2[i][2];
            ++i;
        }
        if (sizeA > 0) {
            xC1 /= (double)sizeA;
            yC1 /= (double)sizeA;
            zC1 /= (double)sizeA;
        }
        i = 0;
        while (i < sizeB) {
            xC2 += pdbB2[i][0];
            yC2 += pdbB2[i][1];
            zC2 += pdbB2[i][2];
            ++i;
        }
        if (sizeB > 0) {
            xC2 /= (double)sizeB;
            yC2 /= (double)sizeB;
            zC2 /= (double)sizeB;
        }
        i = 0;
        while (i < noeVec.size()) {
            noeAve += (noeDistance[i][0] + noeDistance[i][1]) / 2.0;
            ++i;
        }
        double lengthR = noeAve /= (double)mm;
        double[][] arrA = new double[mm][3];
        double[][] arrB = new double[mm][3];
        double[][] newArrB = new double[mm][3];
        double[] centerA = new double[]{xC1, yC1, zC1};
        double diffCenter = Math.sqrt((xC1 - xC2) * (xC1 - xC2) + (yC1 - yC2) * (yC1 - yC2) + (zC1 - zC2) * (zC1 - zC2));
        double disRms = 0.0;
        double[] noeDis = new double[mm];
        i = 0;
        while (i < mm) {
            arrA[i][0] = pdbA[i][0] - xC1;
            arrA[i][1] = pdbA[i][1] - yC1;
            arrA[i][2] = pdbA[i][2] - zC1;
            arrB[i][0] = pdbB[i][0] - xC2;
            arrB[i][1] = pdbB[i][1] - yC2;
            arrB[i][2] = pdbB[i][2] - zC2;
            noeDis[i] = Math.sqrt((arrA[i][0] - arrB[i][0]) * (arrA[i][0] - arrB[i][0]) + (arrA[i][1] - arrB[i][1]) * (arrA[i][1] - arrB[i][1]) + (arrA[i][2] - arrB[i][2]) * (arrA[i][2] - arrB[i][2]));
            ++i;
        }
        double ranThetaS = 0.0;
        double ranPhiS = 0.0;
        double disRmsd = 1000.0;
        long seed = 9752864L;
        Random rr = new Random(seed);
        double low = 0.0;
        double upper = 0.0;
        int resolution = 5;
        int noeRangeRes = 100;
        double lenS = 0.0;
        double[] trans_vecA = new double[3];
        double[] trans_vecB = new double[3];
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String fileName = String.valueOf(src) + "packing.pdb";
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int m = 0;
            while (m < 180 / resolution) {
                double ranTheta = (double)(m * resolution) * Math.PI / 180.0;
                j = 0;
                while (j < 360 / resolution) {
                    double ranPhi = (double)(j * resolution) * Math.PI / 360.0;
                    int k = noeRangeRes;
                    while (k >= 0) {
                        lengthR = noeAve + 6.0 * (0.5 - rr.nextDouble());
                        disRms = 0.0;
                        i = 0;
                        while (i < mm) {
                            newArrB[i][0] = arrB[i][0] + lengthR * Math.sin(ranTheta) * Math.cos(ranPhi);
                            newArrB[i][1] = arrB[i][1] + lengthR * Math.sin(ranTheta) * Math.sin(ranPhi);
                            newArrB[i][2] = arrB[i][2] + lengthR * Math.cos(ranTheta);
                            noeDis[i] = Math.sqrt((arrA[i][0] - newArrB[i][0]) * (arrA[i][0] - newArrB[i][0]) + (arrA[i][1] - newArrB[i][1]) * (arrA[i][1] - newArrB[i][1]) + (arrA[i][2] - newArrB[i][2]) * (arrA[i][2] - newArrB[i][2]));
                            if (noeDis[i] > noeDistance[i][0] && noeDis[i] < noeDistance[i][1]) {
                                disRms += 0.0;
                            } else if (noeDis[i] <= noeDistance[i][0]) {
                                disRms += noeDistance[i][0] - noeDis[i];
                            } else if (noeDis[i] >= noeDistance[i][1]) {
                                disRms += noeDis[i] - noeDistance[i][1];
                            }
                            ++i;
                        }
                        if (Math.abs((disRms = Math.sqrt(disRms / (double)mm)) - 0.0) < 1.0E-4) {
                            System.out.println("here we have one packing satisfying noe constraints:");
                            System.out.println(String.valueOf(disRms) + " ... " + ranTheta + "  " + ranPhi + "  " + lengthR);
                            double[] centerBNewTemp = new double[3];
                            centerBNewTemp = new double[]{-xC2 + lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), -yC2 + lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), -zC2 + lengthR * Math.cos(ranTheta)};
                            Vector<Pdb> pdbVecNewBTemp = pp.newPdbByTranslation(pdbVecB, centerBNewTemp);
                            Vector<Pdb> ppVecT = new Vector<Pdb>();
                            double[] centerANewTemp = new double[]{-centerA[0], -centerA[1], -centerA[2]};
                            Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANewTemp);
                            ppVecT.addAll(pdbANew);
                            ppVecT.addAll(pdbVecNewBTemp);
                            Collections.sort(ppVecT, new Pdb.PdbComparator());
                            pp.print(ppVecT);
                            out.println("MODEL" + m + j + k);
                            pp.printToFile(ppVecT, fileName, out);
                            System.out.println("TER");
                            System.out.println("END");
                            out.println("TER");
                            out.println("ENDMDL");
                        }
                        if (disRms < disRmsd) {
                            ranThetaS = ranTheta;
                            ranPhiS = ranPhi;
                            disRmsd = disRms;
                            lenS = lengthR;
                        }
                        --k;
                    }
                    ++j;
                }
                ++m;
            }
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        noeRms[0] = disRmsd;
        if (debugNOE) {
            System.out.println("NOE rmsd = " + disRmsd);
            System.out.println("NOE distances difference for individual ones:");
        }
        double[] centerBNew = new double[]{-xC2 + lenS * Math.sin(ranThetaS) * Math.cos(ranPhiS), -yC2 + lenS * Math.sin(ranThetaS) * Math.sin(ranPhiS), -zC2 + lenS * Math.cos(ranThetaS)};
        i = 0;
        while (i < mm) {
            arrB[i][0] = pdbB[i][0] + centerBNew[0];
            arrB[i][1] = pdbB[i][1] + centerBNew[1];
            arrB[i][2] = pdbB[i][2] + centerBNew[2];
            noeDis[i] = Math.sqrt((arrA[i][0] - arrB[i][0]) * (arrA[i][0] - arrB[i][0]) + (arrA[i][1] - arrB[i][1]) * (arrA[i][1] - arrB[i][1]) + (arrA[i][2] - arrB[i][2]) * (arrA[i][2] - arrB[i][2]));
            if (debugNOE) {
                System.out.println(noeDis[i]);
            }
            ++i;
        }
        Vector<Pdb> pdbBNew = pp.newPdbByTranslation(pdbVecB, centerBNew);
        double[] centerANew = new double[]{-centerA[0], -centerA[1], -centerA[2]};
        Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANew);
        Vector<Pdb> ppVecT = new Vector<Pdb>();
        ppVecT.addAll(pdbANew);
        ppVecT.addAll(pdbBNew);
        Collections.sort(ppVecT, new Pdb.PdbComparator());
        return ppVecT;
    }

    public Vector positionByNOE(Vector noeVec, Vector pdbVecA, Vector pdbVecB, double[] noeRms, boolean debugNOE, Vector vecUpdateNOE) {
        int noB;
        int j;
        int noA;
        int index = -1;
        String atom = "";
        String atomA = "";
        String atomB = "";
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Pdb pp = new Pdb();
        int sizeA = 0;
        int sizeB = 0;
        double[][] pdbA2 = new double[noeVec.size() * 6][3];
        double[][] pdbB2 = new double[noeVec.size() * 6][3];
        Vector<String> id4A = new Vector<String>();
        Vector<String> id4B = new Vector<String>();
        String id = "";
        double[][] noeDistance = new double[noeVec.size()][2];
        boolean isQ = true;
        int i = 0;
        while (i < noeVec.size()) {
            String atom_temp;
            noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
            atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
            String tempA = "";
            isQ = true;
            if (atomA.length() >= 2) {
                if (atomA.substring(0, 1).equalsIgnoreCase("Q") && !atomA.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempA = "H" + atomA.substring(1, atomA.length());
                } else if (atomA.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempA = "H" + atomA.substring(2, atomA.length());
                } else {
                    tempA = atomA;
                    isQ = false;
                }
            } else {
                tempA = atomA;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecA, new Pdb(noA), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecA.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempA.length()) {
                        String debug_str = atom.substring(0, tempA.length());
                        id = String.valueOf(String.valueOf(noA)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempA.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempA) && !id4A.contains(id)) {
                            pdbA2[sizeA] = cc.getXYZ();
                            id4A.add(id);
                            ++sizeA;
                        }
                    }
                    ++j;
                }
            }
            noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
            atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
            String tempB = "";
            isQ = true;
            if (atomB.length() >= 2) {
                if (atomB.substring(0, 1).equalsIgnoreCase("Q") && !atomB.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempB = "H" + atomB.substring(1, atomB.length());
                } else if (atomB.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempB = "H" + atomB.substring(2, atomB.length());
                } else {
                    tempB = atomB;
                    isQ = false;
                }
            } else {
                tempB = atomB;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecB, new Pdb(noB), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecB.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempB.length()) {
                        id = String.valueOf(String.valueOf(noB)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempB.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempB) && !id4B.contains(id)) {
                            pdbB2[sizeB] = cc.getXYZ();
                            id4B.add(id);
                            ++sizeB;
                        }
                    }
                    ++j;
                }
            }
            noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
            ++i;
        }
        int n = 3;
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        double xC2 = 0.0;
        double yC2 = 0.0;
        double zC2 = 0.0;
        double noeAve = 0.0;
        i = 0;
        while (i < sizeA) {
            xC1 += pdbA2[i][0];
            yC1 += pdbA2[i][1];
            zC1 += pdbA2[i][2];
            ++i;
        }
        if (sizeA > 0) {
            xC1 /= (double)sizeA;
            yC1 /= (double)sizeA;
            zC1 /= (double)sizeA;
        }
        i = 0;
        while (i < sizeB) {
            xC2 += pdbB2[i][0];
            yC2 += pdbB2[i][1];
            zC2 += pdbB2[i][2];
            ++i;
        }
        if (sizeB > 0) {
            xC2 /= (double)sizeB;
            yC2 /= (double)sizeB;
            zC2 /= (double)sizeB;
        }
        i = 0;
        while (i < noeVec.size()) {
            noeAve += (noeDistance[i][0] + noeDistance[i][1]) / 2.0;
            ++i;
        }
        double lengthR = noeAve /= (double)noeVec.size();
        double diffCenter = Math.sqrt((xC1 - xC2) * (xC1 - xC2) + (yC1 - yC2) * (yC1 - yC2) + (zC1 - zC2) * (zC1 - zC2));
        double disRms = 0.0;
        double noeHarm = 0.0;
        double[] noeDis = new double[noeVec.size()];
        double[] noeBackDis = new double[noeVec.size()];
        double[] dis_save = new double[noeVec.size()];
        double[] trans_vecA = new double[3];
        double[] trans_vecB = new double[3];
        double[] centerA = new double[]{xC1, yC1, zC1};
        double[] centerB = new double[]{xC2, yC2, zC2};
        double[] centerO = new double[]{0.0, 0.0, 0.0};
        trans_vecA = pp.internuclearVec(centerA, centerO);
        trans_vecB = pp.internuclearVec(centerB, centerO);
        Vector<Pdb> pdbVecNewA = pp.newPdbByTranslation(pdbVecA, trans_vecA);
        Vector<Pdb> pdbVecNewB = pp.newPdbByTranslation(pdbVecB, trans_vecB);
        double ranThetaS = 0.0;
        double ranPhiS = 0.0;
        double disRmsd = 1000.0;
        long seed = 9754L;
        Random rr = new Random(seed);
        double low = 0.0;
        double upper = 0.0;
        int resolution = 5;
        int noeRangeRes = 20;
        double lenS = 0.0;
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String fileName = String.valueOf(src) + "packing0.pdb";
        int counter = 0;
        int nTemp = 0;
        Vector vecEnsemblePdbs = new Vector();
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int m = 0;
            while (m < 180 / resolution) {
                double ranTheta = (double)(m * resolution) * Math.PI / 180.0;
                j = 0;
                while (j < 360 / resolution) {
                    double ranPhi = (double)(j * resolution) * Math.PI / 360.0;
                    int k = noeRangeRes;
                    while (k >= 0) {
                        block43: {
                            block42: {
                                lengthR = 0.0 + 0.5 * (double)k;
                                double[] centerBNew = new double[]{lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), lengthR * Math.cos(ranTheta)};
                                double[] trans_vec = new double[3];
                                trans_vec = pp.internuclearVec(centerO, centerBNew);
                                Vector<Pdb> pdbVecNewB2 = pp.newPdbByTranslation(pdbVecNewB, trans_vec);
                                disRms = 0.0;
                                noeHarm = 0.0;
                                i = 0;
                                while (i < noeVec.size()) {
                                    noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
                                    atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
                                    noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
                                    atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
                                    noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
                                    double[] dis = new double[1];
                                    double[] distance = new double[1];
                                    pp.measurePackDisAllRotamers(pdbVecNewA, pdbVecNewB2, noA, atomA, noB, atomB, noeDistance[i][0], noeDistance[i][1], dis, distance);
                                    noeDis[i] = dis[0];
                                    noeBackDis[i] = distance[0];
                                    disRms += noeDis[i] * noeDis[i];
                                    noeHarm += noeDis[i] * noeDis[i];
                                    ++i;
                                }
                                noeHarm /= (double)noeVec.size();
                                if (!((disRms = Math.sqrt(disRms / (double)noeVec.size())) < 1.0)) break block42;
                                if (++counter / 40 > nTemp) {
                                    out.close();
                                    fileName = String.valueOf(src) + "packing" + counter / 40 + ".pdb";
                                    out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                                }
                                nTemp = counter / 40;
                                System.out.println("here we have one packing satisfying noe constraints:");
                                System.out.println(String.valueOf(disRms) + " ... " + ranTheta + "  " + ranPhi + "  " + lengthR);
                                double[] centerBNewTemp = new double[3];
                                centerBNewTemp = new double[]{-xC2 + lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), -yC2 + lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), -zC2 + lengthR * Math.cos(ranTheta)};
                                Vector<Pdb> pdbVecNewBTemp = pp.newPdbByTranslation(pdbVecB, centerBNewTemp);
                                Vector<Pdb> ppVecT = new Vector<Pdb>();
                                double[] centerANewTemp = new double[]{-centerA[0], -centerA[1], -centerA[2]};
                                Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANewTemp);
                                ppVecT.addAll(pdbANew);
                                ppVecT.addAll(pdbVecNewBTemp);
                                Collections.sort(ppVecT, new Pdb.PdbComparator());
                                System.out.println("MODEL" + m + " " + j + " " + k);
                                double[] vdwValue = new double[1];
                                boolean hasVDW = false;
                                double vdwLevel = 0.05;
                                boolean printVDWViolation = false;
                                vdwVec = vander.convert2VDW(ppVecT);
                                int numClashes = vander.countStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.8);
                                System.out.println("the number of steric clashes: " + numClashes);
                                if (numClashes > 60) break block43;
                                boolean isInPreClusters = pp.isInPdbClusters(vecEnsemblePdbs, ppVecT, 0.5);
                                if (!isInPreClusters) {
                                    out.println("MODEL" + m + " " + j + " " + k);
                                    out.println("REMARK :   NOE RMSD=:" + disRms);
                                    out.println("REMARK :   NOE HARM=:" + noeHarm);
                                    out.println("REMARK :   numClashes=:" + numClashes);
                                    pp.printToFile(ppVecT, fileName, out);
                                    System.out.println("TER");
                                    System.out.println("END");
                                    out.println("TER");
                                    out.println("ENDMDL");
                                    vecEnsemblePdbs.add(ppVecT);
                                }
                            }
                            if (disRms < disRmsd) {
                                ranThetaS = ranTheta;
                                ranPhiS = ranPhi;
                                disRmsd = disRms;
                                lenS = lengthR;
                                i = 0;
                                while (i < noeVec.size()) {
                                    dis_save[i] = noeBackDis[i];
                                    ++i;
                                }
                                System.out.println(String.valueOf(disRmsd) + " ... " + ranThetaS + "  " + ranPhiS + "  " + lenS);
                            }
                        }
                        --k;
                    }
                    ++j;
                }
                ++m;
            }
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        noeRms[0] = disRmsd;
        if (debugNOE) {
            System.out.println("NOE rmsd = " + disRmsd);
            System.out.println("NOE distances difference for individual ones:");
        }
        double[] centerBNew = new double[]{-xC2 + lenS * Math.sin(ranThetaS) * Math.cos(ranPhiS), -yC2 + lenS * Math.sin(ranThetaS) * Math.sin(ranPhiS), -zC2 + lenS * Math.cos(ranThetaS)};
        i = 0;
        while (i < noeVec.size()) {
            System.out.println(dis_save[i]);
            ++i;
        }
        Vector<Pdb> pdbBNew = pp.newPdbByTranslation(pdbVecB, centerBNew);
        double[] centerANew = new double[]{-centerA[0], -centerA[1], -centerA[2]};
        Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANew);
        Vector<Pdb> ppVecT = new Vector<Pdb>();
        ppVecT.addAll(pdbANew);
        ppVecT.addAll(pdbBNew);
        Collections.sort(ppVecT, new Pdb.PdbComparator());
        return ppVecT;
    }

    public Vector positionByNOEAllRotamers(Vector noeVec, Vector pdbVecA, Vector pdbVecB, double[] noeRms, boolean debugNOE, Vector vecUpdateNOE, String strPass, Vector vecSeq, double resol_cluster) throws JampackException {
        int noB;
        int j;
        int noA;
        int index = -1;
        String atom = "";
        String atomA = "";
        String atomB = "";
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Pdb pp = new Pdb();
        int sizeA = 0;
        int sizeB = 0;
        double[][] pdbA2 = new double[noeVec.size() * 6][3];
        double[][] pdbB2 = new double[noeVec.size() * 6][3];
        Vector<String> id4A = new Vector<String>();
        Vector<String> id4B = new Vector<String>();
        String id = "";
        double[][] noeDistance = new double[noeVec.size()][2];
        boolean isQ = true;
        int i = 0;
        while (i < noeVec.size()) {
            String atom_temp;
            noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
            atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
            String tempA = "";
            isQ = true;
            if (atomA.length() >= 2) {
                if (atomA.substring(0, 1).equalsIgnoreCase("Q") && !atomA.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempA = "H" + atomA.substring(1, atomA.length());
                } else if (atomA.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempA = "H" + atomA.substring(2, atomA.length());
                } else {
                    tempA = atomA;
                    isQ = false;
                }
            } else {
                tempA = atomA;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecA, new Pdb(noA), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecA.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempA.length()) {
                        String debug_str = atom.substring(0, tempA.length());
                        id = String.valueOf(String.valueOf(noA)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempA.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempA) && !id4A.contains(id)) {
                            pdbA2[sizeA] = cc.getXYZ();
                            id4A.add(id);
                            ++sizeA;
                        }
                    }
                    ++j;
                }
            }
            noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
            atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
            String tempB = "";
            isQ = true;
            if (atomB.length() >= 2) {
                if (atomB.substring(0, 1).equalsIgnoreCase("Q") && !atomB.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempB = "H" + atomB.substring(1, atomB.length());
                } else if (atomB.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempB = "H" + atomB.substring(2, atomB.length());
                } else {
                    tempB = atomB;
                    isQ = false;
                }
            } else {
                tempB = atomB;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecB, new Pdb(noB), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecB.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempB.length()) {
                        id = String.valueOf(String.valueOf(noB)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempB.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempB) && !id4B.contains(id)) {
                            pdbB2[sizeB] = cc.getXYZ();
                            id4B.add(id);
                            ++sizeB;
                        }
                    }
                    ++j;
                }
            }
            noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
            ++i;
        }
        int n = 3;
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        double xC2 = 0.0;
        double yC2 = 0.0;
        double zC2 = 0.0;
        double noeAve = 0.0;
        i = 0;
        while (i < sizeA) {
            xC1 += pdbA2[i][0];
            yC1 += pdbA2[i][1];
            zC1 += pdbA2[i][2];
            ++i;
        }
        if (sizeA > 0) {
            xC1 /= (double)sizeA;
            yC1 /= (double)sizeA;
            zC1 /= (double)sizeA;
        }
        i = 0;
        while (i < sizeB) {
            xC2 += pdbB2[i][0];
            yC2 += pdbB2[i][1];
            zC2 += pdbB2[i][2];
            ++i;
        }
        if (sizeB > 0) {
            xC2 /= (double)sizeB;
            yC2 /= (double)sizeB;
            zC2 /= (double)sizeB;
        }
        i = 0;
        while (i < noeVec.size()) {
            noeAve += (noeDistance[i][0] + noeDistance[i][1]) / 2.0;
            ++i;
        }
        double lengthR = noeAve /= (double)noeVec.size();
        double diffCenter = Math.sqrt((xC1 - xC2) * (xC1 - xC2) + (yC1 - yC2) * (yC1 - yC2) + (zC1 - zC2) * (zC1 - zC2));
        double disRms = 0.0;
        double noeHarm = 0.0;
        double[] noeDis = new double[noeVec.size()];
        double[] noeBackDis = new double[noeVec.size()];
        double[] dis_save = new double[noeVec.size()];
        double[] trans_vecA = new double[3];
        double[] trans_vecB = new double[3];
        double[] centerA = new double[]{xC1, yC1, zC1};
        double[] centerB = new double[]{xC2, yC2, zC2};
        double[] centerO = new double[]{0.0, 0.0, 0.0};
        trans_vecA = pp.internuclearVec(centerA, centerO);
        trans_vecB = pp.internuclearVec(centerB, centerO);
        Vector<Pdb> pdbVecNewA = pp.newPdbByTranslation(pdbVecA, trans_vecA);
        Vector<Pdb> pdbVecNewB = pp.newPdbByTranslation(pdbVecB, trans_vecB);
        double ranThetaS = 0.0;
        double ranPhiS = 0.0;
        double disRmsd = 1000.0;
        long seed = 9754L;
        Random rr = new Random(seed);
        double low = 0.0;
        double upper = 0.0;
        int resolution = 5;
        int noeRangeRes = 20;
        double lenS = 0.0;
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String fileName = String.valueOf(strPass) + "0.pdb";
        int counter = 0;
        boolean nTemp = false;
        Vector vecEnsemblePdbs = new Vector();
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        Vector vdwVecA = new Vector();
        Vector vdwVecB = new Vector();
        Cartesian ccCenterA = new Cartesian();
        Vector<Cartesian> vecCenterB = new Vector<Cartesian>();
        int m = 0;
        while (m < 180 / resolution) {
            double ranTheta = (double)(m * resolution) * Math.PI / 180.0;
            j = 0;
            while (j < 360 / resolution) {
                double ranPhi = (double)(j * resolution) * Math.PI / 180.0;
                int k = noeRangeRes;
                while (k >= 0) {
                    block43: {
                        block42: {
                            lengthR = 0.0 + 0.5 * (double)k;
                            double[] centerBNew = new double[]{lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), lengthR * Math.cos(ranTheta)};
                            double[] trans_vec = new double[3];
                            trans_vec = pp.internuclearVec(centerO, centerBNew);
                            Vector<Pdb> pdbVecNewB2 = pp.newPdbByTranslation(pdbVecNewB, trans_vec);
                            disRms = 0.0;
                            noeHarm = 0.0;
                            i = 0;
                            while (i < noeVec.size()) {
                                noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
                                atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
                                noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
                                atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
                                noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
                                double[] dis = new double[1];
                                double[] distance = new double[1];
                                pp.measurePackDisAllRotamers(pdbVecNewA, pdbVecNewB2, noA, atomA, noB, atomB, noeDistance[i][0], noeDistance[i][1], dis, distance);
                                noeDis[i] = dis[0];
                                noeBackDis[i] = distance[0];
                                disRms += noeDis[i] * noeDis[i];
                                noeHarm += noeDis[i] * noeDis[i];
                                ++i;
                            }
                            noeHarm /= (double)noeVec.size();
                            if (!(Math.abs((disRms = Math.sqrt(disRms / (double)noeVec.size())) - 0.0) < 1.0E-4)) break block42;
                            System.out.println("here we have one packing satisfying noe constraints:");
                            System.out.println(String.valueOf(disRms) + " ... " + ranTheta + "  " + ranPhi + "  " + lengthR);
                            double[] centerBNewTemp = new double[3];
                            centerBNewTemp = new double[]{-xC2 + lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), -yC2 + lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), -zC2 + lengthR * Math.cos(ranTheta)};
                            Vector<Pdb> pdbVecNewBTemp = pp.newPdbByTranslation(pdbVecB, centerBNewTemp);
                            Vector<Pdb> ppVecT = new Vector<Pdb>();
                            double[] centerANewTemp = new double[]{-centerA[0], -centerA[1], -centerA[2]};
                            Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANewTemp);
                            ppVecT.addAll(pdbANew);
                            ppVecT.addAll(pdbVecNewBTemp);
                            Collections.sort(ppVecT, new Pdb.PdbComparator());
                            System.out.println("MODEL" + m + " " + j + " " + k);
                            ccCenterA = new Cartesian("", -centerA[0], -centerA[1], -centerA[2]);
                            Cartesian ccCenterB = new Cartesian("", centerBNewTemp[0], centerBNewTemp[1], centerBNewTemp[2]);
                            double[] vdwValue = new double[1];
                            boolean hasVDW = false;
                            double vdwLevel = 0.05;
                            boolean printVDWViolation = false;
                            String rotSrc = String.valueOf(userDir) + "/system/rot-lib/";
                            boolean[] resIndex = new boolean[ppVecT.size()];
                            int kk = 0;
                            while (kk < resIndex.length) {
                                resIndex[kk] = false;
                                ++kk;
                            }
                            Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, ppVecT);
                            Vector ppVecTALA = pp.AlaninizeStructureResName(pdbVecSSE_temp2, rotSrc);
                            vdwVec = vander.convert2VDW(ppVecTALA);
                            Vector<Pdb> pdbVecSSE_tempA = pp.residueNameUpdate(vecSeq, pdbANew);
                            Vector ppVecTALA_A = pp.AlaninizeStructureResName(pdbVecSSE_tempA, rotSrc);
                            vdwVecA = vander.convert2VDW(ppVecTALA_A);
                            Vector<Pdb> pdbVecSSE_tempB = pp.residueNameUpdate(vecSeq, pdbVecNewBTemp);
                            Vector ppVecTALA_B = pp.AlaninizeStructureResName(pdbVecSSE_tempB, rotSrc);
                            vdwVecB = vander.convert2VDW(ppVecTALA_B);
                            int numClashes = vander.countStericClashBetweenTwo(vdwVecA, vdwVecB, vdwValue, vdwLevel, printVDWViolation, true, 0.5);
                            System.out.println("the number of steric clashes: " + numClashes);
                            if (numClashes > 0) break block43;
                            boolean isInPreClusters = pp.isInPointClusters(vecCenterB, ccCenterB, resol_cluster * 2.0);
                            if (!isInPreClusters) {
                                ++counter;
                                if (!this.isSkipOutEnsembe) {
                                    try {
                                        fileName = String.valueOf(strPass) + counter + ".pdb";
                                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                                        out.println("MODEL" + m + " " + j + " " + k);
                                        out.println("REMARK :   NOE RMSD=:" + disRms);
                                        out.println("REMARK :   NOE HARM=:" + noeHarm);
                                        out.println("REMARK :   numClashes in Alaninized strcuture=:" + numClashes);
                                        Vector<Pdb> vecFirstBB = pp.OutputBackbone(ppVecT);
                                        pp.printToFile(vecFirstBB, fileName, out);
                                        System.out.println("TER");
                                        System.out.println("END");
                                        out.println("TER");
                                        out.println("ENDMDL");
                                        out.println("END");
                                        out.close();
                                    }
                                    catch (FileNotFoundException e) {
                                        System.out.println("File not found: " + fileName);
                                    }
                                    catch (IOException e) {
                                        System.out.println("IOException: the stack trace is:");
                                        e.printStackTrace();
                                    }
                                }
                                vecCenterB.add(ccCenterB);
                            }
                        }
                        if (disRms < disRmsd) {
                            ranThetaS = ranTheta;
                            ranPhiS = ranPhi;
                            disRmsd = disRms;
                            lenS = lengthR;
                            i = 0;
                            while (i < noeVec.size()) {
                                dis_save[i] = noeBackDis[i];
                                ++i;
                            }
                            System.out.println(String.valueOf(disRmsd) + " ... " + ranThetaS + "  " + ranPhiS + "  " + lenS);
                        }
                    }
                    --k;
                }
                ++j;
            }
            ++m;
        }
        noeRms[0] = disRmsd;
        if (debugNOE) {
            System.out.println("NOE rmsd = " + disRmsd);
            System.out.println("NOE distances difference for individual ones:");
        }
        double[] centerBNew = this.centerCalNew(vecCenterB);
        i = 0;
        while (i < noeVec.size()) {
            System.out.println(dis_save[i]);
            ++i;
        }
        Vector<Pdb> pdbBNew = pp.newPdbByTranslation(pdbVecB, centerBNew);
        double[] centerANew = ccCenterA.getXYZ();
        Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANew);
        Vector<Pdb> ppVecT = new Vector<Pdb>();
        ppVecT.addAll(pdbANew);
        ppVecT.addAll(pdbBNew);
        Collections.sort(ppVecT, new Pdb.PdbComparator());
        return ppVecT;
    }

    public Vector positionByAmbiNOEAllRotamers(Vector noeVec, Vector pdbVecA, Vector pdbVecB, double[] noeRms, boolean debugNOE, Vector vecUpdateNOE, String strPass, Vector vecSeq, double resol_cluster) throws JampackException {
        int noB;
        int j;
        int noA;
        int index = -1;
        String atom = "";
        String atomA = "";
        String atomB = "";
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Pdb pp = new Pdb();
        int sizeA = 0;
        int sizeB = 0;
        double[][] pdbA2 = new double[noeVec.size() * 6][3];
        double[][] pdbB2 = new double[noeVec.size() * 6][3];
        Vector<String> id4A = new Vector<String>();
        Vector<String> id4B = new Vector<String>();
        String id = "";
        double[][] noeDistance = new double[noeVec.size()][2];
        boolean isQ = true;
        int i = 0;
        while (i < noeVec.size()) {
            String atom_temp;
            noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
            atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
            String tempA = "";
            isQ = true;
            if (atomA.length() >= 2) {
                if (atomA.substring(0, 1).equalsIgnoreCase("Q") && !atomA.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempA = "H" + atomA.substring(1, atomA.length());
                } else if (atomA.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempA = "H" + atomA.substring(2, atomA.length());
                } else {
                    tempA = atomA;
                    isQ = false;
                }
            } else {
                tempA = atomA;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecA, new Pdb(noA), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecA.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempA.length()) {
                        String debug_str = atom.substring(0, tempA.length());
                        id = String.valueOf(String.valueOf(noA)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempA.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempA) && !id4A.contains(id)) {
                            pdbA2[sizeA] = cc.getXYZ();
                            id4A.add(id);
                            ++sizeA;
                        }
                    }
                    ++j;
                }
            }
            noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
            atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
            String tempB = "";
            isQ = true;
            if (atomB.length() >= 2) {
                if (atomB.substring(0, 1).equalsIgnoreCase("Q") && !atomB.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempB = "H" + atomB.substring(1, atomB.length());
                } else if (atomB.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempB = "H" + atomB.substring(2, atomB.length());
                } else {
                    tempB = atomB;
                    isQ = false;
                }
            } else {
                tempB = atomB;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecB, new Pdb(noB), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecB.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempB.length()) {
                        id = String.valueOf(String.valueOf(noB)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempB.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempB) && !id4B.contains(id)) {
                            pdbB2[sizeB] = cc.getXYZ();
                            id4B.add(id);
                            ++sizeB;
                        }
                    }
                    ++j;
                }
            }
            noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
            ++i;
        }
        int n = 3;
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        double xC2 = 0.0;
        double yC2 = 0.0;
        double zC2 = 0.0;
        double noeAve = 0.0;
        i = 0;
        while (i < sizeA) {
            xC1 += pdbA2[i][0];
            yC1 += pdbA2[i][1];
            zC1 += pdbA2[i][2];
            ++i;
        }
        if (sizeA > 0) {
            xC1 /= (double)sizeA;
            yC1 /= (double)sizeA;
            zC1 /= (double)sizeA;
        }
        i = 0;
        while (i < sizeB) {
            xC2 += pdbB2[i][0];
            yC2 += pdbB2[i][1];
            zC2 += pdbB2[i][2];
            ++i;
        }
        if (sizeB > 0) {
            xC2 /= (double)sizeB;
            yC2 /= (double)sizeB;
            zC2 /= (double)sizeB;
        }
        i = 0;
        while (i < noeVec.size()) {
            noeAve += (noeDistance[i][0] + noeDistance[i][1]) / 2.0;
            ++i;
        }
        double lengthR = noeAve /= (double)noeVec.size();
        double diffCenter = Math.sqrt((xC1 - xC2) * (xC1 - xC2) + (yC1 - yC2) * (yC1 - yC2) + (zC1 - zC2) * (zC1 - zC2));
        double disRms = 0.0;
        double noeHarm = 0.0;
        double[] noeDis = new double[noeVec.size()];
        double[] noeBackDis = new double[noeVec.size()];
        double[] dis_save = new double[noeVec.size()];
        double[] trans_vecA = new double[3];
        double[] trans_vecB = new double[3];
        double[] centerA = new double[]{xC1, yC1, zC1};
        double[] centerB = new double[]{xC2, yC2, zC2};
        double[] centerO = new double[]{0.0, 0.0, 0.0};
        trans_vecA = pp.internuclearVec(centerA, centerO);
        trans_vecB = pp.internuclearVec(centerB, centerO);
        Vector<Pdb> pdbVecNewA = pp.newPdbByTranslation(pdbVecA, trans_vecA);
        Vector<Pdb> pdbVecNewB = pp.newPdbByTranslation(pdbVecB, trans_vecB);
        double ranThetaS = 0.0;
        double ranPhiS = 0.0;
        double disRmsd = 1000.0;
        long seed = 9754L;
        Random rr = new Random(seed);
        double low = 0.0;
        double upper = 0.0;
        int resolution = 5;
        int noeRangeRes = 20;
        double lenS = 0.0;
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String fileName = String.valueOf(strPass) + "0.pdb";
        int counter = 0;
        boolean nTemp = false;
        Vector vecEnsemblePdbs = new Vector();
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        Vector vdwVecA = new Vector();
        Vector vdwVecB = new Vector();
        Cartesian ccCenterA = new Cartesian();
        Vector<Cartesian> vecCenterB = new Vector<Cartesian>();
        int m = 0;
        while (m < 180 / resolution) {
            double ranTheta = (double)(m * resolution) * Math.PI / 180.0;
            j = 0;
            while (j < 360 / resolution) {
                double ranPhi = (double)(j * resolution) * Math.PI / 180.0;
                int k = noeRangeRes;
                while (k >= 0) {
                    block44: {
                        block43: {
                            lengthR = 0.0 + 0.5 * (double)k;
                            double[] centerBNew = new double[]{lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), lengthR * Math.cos(ranTheta)};
                            double[] trans_vec = new double[3];
                            trans_vec = pp.internuclearVec(centerO, centerBNew);
                            Vector<Pdb> pdbVecNewB2 = pp.newPdbByTranslation(pdbVecNewB, trans_vec);
                            disRms = 0.0;
                            noeHarm = 0.0;
                            int numSatisfiedNoes = 0;
                            i = 0;
                            while (i < noeVec.size()) {
                                noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
                                atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
                                noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
                                atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
                                noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
                                double[] dis = new double[1];
                                double[] distance = new double[1];
                                boolean isSatisfied = pp.measurePackDisAllRotamers(pdbVecNewA, pdbVecNewB2, noA, atomA, noB, atomB, noeDistance[i][0], noeDistance[i][1], dis, distance);
                                if (distance[0] < noeDistance[i][1]) {
                                    ++numSatisfiedNoes;
                                }
                                noeDis[i] = dis[0];
                                noeBackDis[i] = distance[0];
                                disRms += noeDis[i] * noeDis[i];
                                noeHarm += noeDis[i] * noeDis[i];
                                ++i;
                            }
                            noeHarm /= (double)noeVec.size();
                            disRms = Math.sqrt(disRms / (double)noeVec.size());
                            if (numSatisfiedNoes < true) break block43;
                            System.out.println("here we have one packing satisfying noe constraints:");
                            System.out.println(String.valueOf(disRms) + " ... " + ranTheta + "  " + ranPhi + "  " + lengthR);
                            double[] centerBNewTemp = new double[3];
                            centerBNewTemp = new double[]{-xC2 + lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), -yC2 + lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), -zC2 + lengthR * Math.cos(ranTheta)};
                            Vector<Pdb> pdbVecNewBTemp = pp.newPdbByTranslation(pdbVecB, centerBNewTemp);
                            Vector<Pdb> ppVecT = new Vector<Pdb>();
                            double[] centerANewTemp = new double[]{-centerA[0], -centerA[1], -centerA[2]};
                            Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANewTemp);
                            ppVecT.addAll(pdbANew);
                            ppVecT.addAll(pdbVecNewBTemp);
                            Collections.sort(ppVecT, new Pdb.PdbComparator());
                            System.out.println("MODEL" + m + " " + j + " " + k);
                            ccCenterA = new Cartesian("", -centerA[0], -centerA[1], -centerA[2]);
                            Cartesian ccCenterB = new Cartesian("", centerBNewTemp[0], centerBNewTemp[1], centerBNewTemp[2]);
                            double[] vdwValue = new double[1];
                            boolean hasVDW = false;
                            double vdwLevel = 0.05;
                            boolean printVDWViolation = false;
                            String rotSrc = String.valueOf(userDir) + "/system/rot-lib/";
                            boolean[] resIndex = new boolean[ppVecT.size()];
                            int kk = 0;
                            while (kk < resIndex.length) {
                                resIndex[kk] = false;
                                ++kk;
                            }
                            Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, ppVecT);
                            Vector ppVecTALA = pp.AlaninizeStructureResName(pdbVecSSE_temp2, rotSrc);
                            vdwVec = vander.convert2VDW(ppVecTALA);
                            Vector<Pdb> pdbVecSSE_tempA = pp.residueNameUpdate(vecSeq, pdbANew);
                            Vector ppVecTALA_A = pp.AlaninizeStructureResName(pdbVecSSE_tempA, rotSrc);
                            vdwVecA = vander.convert2VDW(ppVecTALA_A);
                            Vector<Pdb> pdbVecSSE_tempB = pp.residueNameUpdate(vecSeq, pdbVecNewBTemp);
                            Vector ppVecTALA_B = pp.AlaninizeStructureResName(pdbVecSSE_tempB, rotSrc);
                            vdwVecB = vander.convert2VDW(ppVecTALA_B);
                            int numClashes = vander.countStericClashBetweenTwo(vdwVecA, vdwVecB, vdwValue, vdwLevel, printVDWViolation, true, 0.5);
                            System.out.println("the number of steric clashes: " + numClashes);
                            if (numClashes > 0) break block44;
                            boolean isInPreClusters = pp.isInPointClusters(vecCenterB, ccCenterB, resol_cluster * 2.0);
                            if (!isInPreClusters) {
                                ++counter;
                                if (!this.isSkipOutEnsembe) {
                                    try {
                                        fileName = String.valueOf(strPass) + counter + ".pdb";
                                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                                        out.println("MODEL" + m + " " + j + " " + k);
                                        out.println("REMARK :   NOE RMSD=:" + disRms);
                                        out.println("REMARK :   NOE HARM=:" + noeHarm);
                                        out.println("REMARK :   numClashes in Alaninized strcuture=:" + numClashes);
                                        Vector<Pdb> vecFirstBB = pp.OutputBackbone(ppVecT);
                                        pp.printToFile(vecFirstBB, fileName, out);
                                        System.out.println("TER");
                                        System.out.println("END");
                                        out.println("TER");
                                        out.println("ENDMDL");
                                        out.println("END");
                                        out.close();
                                    }
                                    catch (FileNotFoundException e) {
                                        System.out.println("File not found: " + fileName);
                                    }
                                    catch (IOException e) {
                                        System.out.println("IOException: the stack trace is:");
                                        e.printStackTrace();
                                    }
                                }
                                vecCenterB.add(ccCenterB);
                            }
                        }
                        if (disRms < disRmsd) {
                            ranThetaS = ranTheta;
                            ranPhiS = ranPhi;
                            disRmsd = disRms;
                            lenS = lengthR;
                            i = 0;
                            while (i < noeVec.size()) {
                                dis_save[i] = noeBackDis[i];
                                ++i;
                            }
                            System.out.println(String.valueOf(disRmsd) + " ... " + ranThetaS + "  " + ranPhiS + "  " + lenS);
                        }
                    }
                    --k;
                }
                ++j;
            }
            ++m;
        }
        noeRms[0] = disRmsd;
        if (debugNOE) {
            System.out.println("NOE rmsd = " + disRmsd);
            System.out.println("NOE distances difference for individual ones:");
        }
        double[] centerBNew = this.centerCalNew(vecCenterB);
        i = 0;
        while (i < noeVec.size()) {
            System.out.println(dis_save[i]);
            ++i;
        }
        Vector<Pdb> pdbBNew = pp.newPdbByTranslation(pdbVecB, centerBNew);
        double[] centerANew = ccCenterA.getXYZ();
        Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANew);
        Vector<Pdb> ppVecT = new Vector<Pdb>();
        ppVecT.addAll(pdbANew);
        ppVecT.addAll(pdbBNew);
        Collections.sort(ppVecT, new Pdb.PdbComparator());
        return ppVecT;
    }

    public Vector positionByNOEAllRotamersSaved(Vector noeVec, Vector pdbVecA, Vector pdbVecB, double[] noeRms, boolean debugNOE, Vector vecUpdateNOE, String strPass, Vector vecSeq) throws JampackException {
        int noB;
        int j;
        int noA;
        int index = -1;
        String atom = "";
        String atomA = "";
        String atomB = "";
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Pdb pp = new Pdb();
        int sizeA = 0;
        int sizeB = 0;
        double[][] pdbA2 = new double[noeVec.size() * 6][3];
        double[][] pdbB2 = new double[noeVec.size() * 6][3];
        Vector<String> id4A = new Vector<String>();
        Vector<String> id4B = new Vector<String>();
        String id = "";
        double[][] noeDistance = new double[noeVec.size()][2];
        boolean isQ = true;
        int i = 0;
        while (i < noeVec.size()) {
            String atom_temp;
            noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
            atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
            String tempA = "";
            isQ = true;
            if (atomA.length() >= 2) {
                if (atomA.substring(0, 1).equalsIgnoreCase("Q") && !atomA.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempA = "H" + atomA.substring(1, atomA.length());
                } else if (atomA.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempA = "H" + atomA.substring(2, atomA.length());
                } else {
                    tempA = atomA;
                    isQ = false;
                }
            } else {
                tempA = atomA;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecA, new Pdb(noA), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecA.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempA.length()) {
                        String debug_str = atom.substring(0, tempA.length());
                        id = String.valueOf(String.valueOf(noA)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempA.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempA) && !id4A.contains(id)) {
                            pdbA2[sizeA] = cc.getXYZ();
                            id4A.add(id);
                            ++sizeA;
                        }
                    }
                    ++j;
                }
            }
            noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
            atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
            String tempB = "";
            isQ = true;
            if (atomB.length() >= 2) {
                if (atomB.substring(0, 1).equalsIgnoreCase("Q") && !atomB.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempB = "H" + atomB.substring(1, atomB.length());
                } else if (atomB.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempB = "H" + atomB.substring(2, atomB.length());
                } else {
                    tempB = atomB;
                    isQ = false;
                }
            } else {
                tempB = atomB;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecB, new Pdb(noB), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecB.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempB.length()) {
                        id = String.valueOf(String.valueOf(noB)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempB.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempB) && !id4B.contains(id)) {
                            pdbB2[sizeB] = cc.getXYZ();
                            id4B.add(id);
                            ++sizeB;
                        }
                    }
                    ++j;
                }
            }
            noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
            ++i;
        }
        int n = 3;
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        double xC2 = 0.0;
        double yC2 = 0.0;
        double zC2 = 0.0;
        double noeAve = 0.0;
        i = 0;
        while (i < sizeA) {
            xC1 += pdbA2[i][0];
            yC1 += pdbA2[i][1];
            zC1 += pdbA2[i][2];
            ++i;
        }
        if (sizeA > 0) {
            xC1 /= (double)sizeA;
            yC1 /= (double)sizeA;
            zC1 /= (double)sizeA;
        }
        i = 0;
        while (i < sizeB) {
            xC2 += pdbB2[i][0];
            yC2 += pdbB2[i][1];
            zC2 += pdbB2[i][2];
            ++i;
        }
        if (sizeB > 0) {
            xC2 /= (double)sizeB;
            yC2 /= (double)sizeB;
            zC2 /= (double)sizeB;
        }
        i = 0;
        while (i < noeVec.size()) {
            noeAve += (noeDistance[i][0] + noeDistance[i][1]) / 2.0;
            ++i;
        }
        double lengthR = noeAve /= (double)noeVec.size();
        double diffCenter = Math.sqrt((xC1 - xC2) * (xC1 - xC2) + (yC1 - yC2) * (yC1 - yC2) + (zC1 - zC2) * (zC1 - zC2));
        double disRms = 0.0;
        double noeHarm = 0.0;
        double[] noeDis = new double[noeVec.size()];
        double[] noeBackDis = new double[noeVec.size()];
        double[] dis_save = new double[noeVec.size()];
        double[] trans_vecA = new double[3];
        double[] trans_vecB = new double[3];
        double[] centerA = new double[]{xC1, yC1, zC1};
        double[] centerB = new double[]{xC2, yC2, zC2};
        double[] centerO = new double[]{0.0, 0.0, 0.0};
        trans_vecA = pp.internuclearVec(centerA, centerO);
        trans_vecB = pp.internuclearVec(centerB, centerO);
        Vector<Pdb> pdbVecNewA = pp.newPdbByTranslation(pdbVecA, trans_vecA);
        Vector<Pdb> pdbVecNewB = pp.newPdbByTranslation(pdbVecB, trans_vecB);
        double ranThetaS = 0.0;
        double ranPhiS = 0.0;
        double disRmsd = 1000.0;
        long seed = 9754L;
        Random rr = new Random(seed);
        double low = 0.0;
        double upper = 0.0;
        int resolution = 5;
        int noeRangeRes = 20;
        double lenS = 0.0;
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String fileName = String.valueOf(strPass) + "0.pdb";
        int counter = 0;
        int nTemp = 0;
        Vector<Vector<Pdb>> vecEnsemblePdbs = new Vector<Vector<Pdb>>();
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int m = 0;
            while (m < 180 / resolution) {
                double ranTheta = (double)(m * resolution) * Math.PI / 180.0;
                j = 0;
                while (j < 360 / resolution) {
                    double ranPhi = (double)(j * resolution) * Math.PI / 180.0;
                    int k = noeRangeRes;
                    while (k >= 0) {
                        block44: {
                            block43: {
                                lengthR = 0.0 + 0.5 * (double)k;
                                double[] centerBNew = new double[]{lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), lengthR * Math.cos(ranTheta)};
                                double[] trans_vec = new double[3];
                                trans_vec = pp.internuclearVec(centerO, centerBNew);
                                Vector<Pdb> pdbVecNewB2 = pp.newPdbByTranslation(pdbVecNewB, trans_vec);
                                disRms = 0.0;
                                noeHarm = 0.0;
                                i = 0;
                                while (i < noeVec.size()) {
                                    noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
                                    atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
                                    noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
                                    atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
                                    noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
                                    double[] dis = new double[1];
                                    double[] distance = new double[1];
                                    pp.measurePackDisAllRotamers(pdbVecNewA, pdbVecNewB2, noA, atomA, noB, atomB, noeDistance[i][0], noeDistance[i][1], dis, distance);
                                    noeDis[i] = dis[0];
                                    noeBackDis[i] = distance[0];
                                    disRms += noeDis[i] * noeDis[i];
                                    noeHarm += noeDis[i] * noeDis[i];
                                    ++i;
                                }
                                noeHarm /= (double)noeVec.size();
                                if (!(Math.abs((disRms = Math.sqrt(disRms / (double)noeVec.size())) - 0.0) < 1.0E-4)) break block43;
                                if (++counter / 40 > nTemp) {
                                    out.close();
                                    fileName = String.valueOf(strPass) + counter / 40 + ".pdb";
                                    out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                                }
                                nTemp = counter / 40;
                                System.out.println("here we have one packing satisfying noe constraints:");
                                System.out.println(String.valueOf(disRms) + " ... " + ranTheta + "  " + ranPhi + "  " + lengthR);
                                double[] centerBNewTemp = new double[3];
                                centerBNewTemp = new double[]{-xC2 + lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), -yC2 + lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), -zC2 + lengthR * Math.cos(ranTheta)};
                                Vector<Pdb> pdbVecNewBTemp = pp.newPdbByTranslation(pdbVecB, centerBNewTemp);
                                Vector<Pdb> ppVecT = new Vector<Pdb>();
                                double[] centerANewTemp = new double[]{-centerA[0], -centerA[1], -centerA[2]};
                                Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANewTemp);
                                ppVecT.addAll(pdbANew);
                                ppVecT.addAll(pdbVecNewBTemp);
                                Collections.sort(ppVecT, new Pdb.PdbComparator());
                                System.out.println("MODEL" + m + " " + j + " " + k);
                                double[] vdwValue = new double[1];
                                boolean hasVDW = false;
                                double vdwLevel = 0.05;
                                boolean printVDWViolation = false;
                                boolean[] resIndex = new boolean[ppVecT.size()];
                                int kk = 0;
                                while (kk < resIndex.length) {
                                    resIndex[kk] = false;
                                    ++kk;
                                }
                                String rotSrc = String.valueOf(src) + "rotasamp-small/";
                                Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, ppVecT);
                                Vector ppVecTALA = pp.AlaninizeStructureResName(pdbVecSSE_temp2, rotSrc);
                                vdwVec = vander.convert2VDW(ppVecTALA);
                                int numClashes = vander.countStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.5);
                                System.out.println("the number of steric clashes: " + numClashes);
                                if (numClashes > 0) break block44;
                                boolean isInPreClusters = pp.isInPdbClusters(vecEnsemblePdbs, ppVecT, 0.8);
                                if (!isInPreClusters) {
                                    out.println("MODEL" + m + " " + j + " " + k);
                                    out.println("REMARK :   NOE RMSD=:" + disRms);
                                    out.println("REMARK :   NOE HARM=:" + noeHarm);
                                    out.println("REMARK :   numClashes in Alaninized strcuture=:" + numClashes);
                                    Vector<Pdb> vecFirstBB = pp.OutputBackbone(ppVecT);
                                    pp.printToFile(vecFirstBB, fileName, out);
                                    System.out.println("TER");
                                    System.out.println("END");
                                    out.println("TER");
                                    out.println("ENDMDL");
                                    vecEnsemblePdbs.add(vecFirstBB);
                                }
                            }
                            if (disRms < disRmsd) {
                                ranThetaS = ranTheta;
                                ranPhiS = ranPhi;
                                disRmsd = disRms;
                                lenS = lengthR;
                                i = 0;
                                while (i < noeVec.size()) {
                                    dis_save[i] = noeBackDis[i];
                                    ++i;
                                }
                                System.out.println(String.valueOf(disRmsd) + " ... " + ranThetaS + "  " + ranPhiS + "  " + lenS);
                            }
                        }
                        --k;
                    }
                    ++j;
                }
                ++m;
            }
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        noeRms[0] = disRmsd;
        if (debugNOE) {
            System.out.println("NOE rmsd = " + disRmsd);
            System.out.println("NOE distances difference for individual ones:");
        }
        double[] centerBNew = new double[]{-xC2 + lenS * Math.sin(ranThetaS) * Math.cos(ranPhiS), -yC2 + lenS * Math.sin(ranThetaS) * Math.sin(ranPhiS), -zC2 + lenS * Math.cos(ranThetaS)};
        i = 0;
        while (i < noeVec.size()) {
            System.out.println(dis_save[i]);
            ++i;
        }
        Vector<Pdb> pdbBNew = pp.newPdbByTranslation(pdbVecB, centerBNew);
        double[] centerANew = new double[]{-centerA[0], -centerA[1], -centerA[2]};
        Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANew);
        Vector<Pdb> ppVecT = new Vector<Pdb>();
        ppVecT.addAll(pdbANew);
        ppVecT.addAll(pdbBNew);
        Collections.sort(ppVecT, new Pdb.PdbComparator());
        return ppVecT;
    }

    public Vector positionByNOEAllRotamersGrid(Vector noeVec, Vector pdbVecA, Vector pdbVecB, double[] noeRms, boolean debugNOE, Vector vecUpdateNOE) throws JampackException {
        int noB;
        int j;
        int noA;
        int index = -1;
        String atom = "";
        String atomA = "";
        String atomB = "";
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Pdb pp = new Pdb();
        int sizeA = 0;
        int sizeB = 0;
        double[][] pdbA2 = new double[noeVec.size() * 6][3];
        double[][] pdbB2 = new double[noeVec.size() * 6][3];
        Vector<String> id4A = new Vector<String>();
        Vector<String> id4B = new Vector<String>();
        String id = "";
        double[][] noeDistance = new double[noeVec.size()][2];
        boolean isQ = true;
        int i = 0;
        while (i < noeVec.size()) {
            String atom_temp;
            noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
            atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
            String tempA = "";
            isQ = true;
            if (atomA.length() >= 2) {
                if (atomA.substring(0, 1).equalsIgnoreCase("Q") && !atomA.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempA = "H" + atomA.substring(1, atomA.length());
                } else if (atomA.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempA = "H" + atomA.substring(2, atomA.length());
                } else {
                    tempA = atomA;
                    isQ = false;
                }
            } else {
                tempA = atomA;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecA, new Pdb(noA), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecA.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempA.length()) {
                        String debug_str = atom.substring(0, tempA.length());
                        id = String.valueOf(String.valueOf(noA)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempA.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempA) && !id4A.contains(id)) {
                            pdbA2[sizeA] = cc.getXYZ();
                            id4A.add(id);
                            ++sizeA;
                        }
                    }
                    ++j;
                }
            }
            noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
            atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
            String tempB = "";
            isQ = true;
            if (atomB.length() >= 2) {
                if (atomB.substring(0, 1).equalsIgnoreCase("Q") && !atomB.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempB = "H" + atomB.substring(1, atomB.length());
                } else if (atomB.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempB = "H" + atomB.substring(2, atomB.length());
                } else {
                    tempB = atomB;
                    isQ = false;
                }
            } else {
                tempB = atomB;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecB, new Pdb(noB), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecB.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempB.length()) {
                        id = String.valueOf(String.valueOf(noB)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempB.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempB) && !id4B.contains(id)) {
                            pdbB2[sizeB] = cc.getXYZ();
                            id4B.add(id);
                            ++sizeB;
                        }
                    }
                    ++j;
                }
            }
            noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
            ++i;
        }
        int n = 3;
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        double xC2 = 0.0;
        double yC2 = 0.0;
        double zC2 = 0.0;
        double noeAve = 0.0;
        i = 0;
        while (i < sizeA) {
            xC1 += pdbA2[i][0];
            yC1 += pdbA2[i][1];
            zC1 += pdbA2[i][2];
            ++i;
        }
        if (sizeA > 0) {
            xC1 /= (double)sizeA;
            yC1 /= (double)sizeA;
            zC1 /= (double)sizeA;
        }
        i = 0;
        while (i < sizeB) {
            xC2 += pdbB2[i][0];
            yC2 += pdbB2[i][1];
            zC2 += pdbB2[i][2];
            ++i;
        }
        if (sizeB > 0) {
            xC2 /= (double)sizeB;
            yC2 /= (double)sizeB;
            zC2 /= (double)sizeB;
        }
        i = 0;
        while (i < noeVec.size()) {
            noeAve += (noeDistance[i][0] + noeDistance[i][1]) / 2.0;
            ++i;
        }
        double lengthR = noeAve /= (double)noeVec.size();
        double diffCenter = Math.sqrt((xC1 - xC2) * (xC1 - xC2) + (yC1 - yC2) * (yC1 - yC2) + (zC1 - zC2) * (zC1 - zC2));
        double disRms = 0.0;
        double noeHarm = 0.0;
        double[] noeDis = new double[noeVec.size()];
        double[] noeBackDis = new double[noeVec.size()];
        double[] dis_save = new double[noeVec.size()];
        double[] trans_vecA = new double[3];
        double[] trans_vecB = new double[3];
        double[] centerA = new double[]{xC1, yC1, zC1};
        double[] centerB = new double[]{xC2, yC2, zC2};
        double[] centerO = new double[]{0.0, 0.0, 0.0};
        trans_vecA = pp.internuclearVec(centerA, centerO);
        trans_vecB = pp.internuclearVec(centerB, centerO);
        Vector<Pdb> pdbVecNewA = pp.newPdbByTranslation(pdbVecA, trans_vecA);
        Vector<Pdb> pdbVecNewB = pp.newPdbByTranslation(pdbVecB, trans_vecB);
        double ranThetaS = 0.0;
        double ranPhiS = 0.0;
        double disRmsd = 1000.0;
        long seed = 9754L;
        Random rr = new Random(seed);
        double low = 0.0;
        double upper = 0.0;
        int resolution = 5;
        int noeRangeRes = 80;
        double lenS = 0.0;
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String fileName = String.valueOf(src) + "packing0.pdb";
        int counter = 0;
        int nTemp = 0;
        Vector<Vector<Pdb>> vecEnsemblePdbs = new Vector<Vector<Pdb>>();
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int m = -noeRangeRes;
            while (m <= noeRangeRes) {
                double ranTheta = 0.0 + 0.3 * (double)m;
                j = -noeRangeRes;
                while (j <= noeRangeRes) {
                    double ranPhi = 0.0 + 0.3 * (double)j;
                    int k = -noeRangeRes;
                    while (k <= noeRangeRes) {
                        block44: {
                            block43: {
                                lengthR = 0.0 + 0.3 * (double)k;
                                double[] centerBNew = new double[]{ranTheta, ranPhi, lengthR};
                                double[] trans_vec = new double[3];
                                trans_vec = pp.internuclearVec(centerO, centerBNew);
                                Vector<Pdb> pdbVecNewB2 = pp.newPdbByTranslation(pdbVecNewB, trans_vec);
                                disRms = 0.0;
                                noeHarm = 0.0;
                                i = 0;
                                while (i < noeVec.size()) {
                                    noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
                                    atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
                                    noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
                                    atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
                                    noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
                                    double[] dis = new double[1];
                                    double[] distance = new double[1];
                                    pp.measurePackDisAllRotamers(pdbVecNewA, pdbVecNewB2, noA, atomA, noB, atomB, noeDistance[i][0], noeDistance[i][1], dis, distance);
                                    noeDis[i] = dis[0];
                                    noeBackDis[i] = distance[0];
                                    disRms += noeDis[i] * noeDis[i];
                                    noeHarm += noeDis[i] * noeDis[i];
                                    ++i;
                                }
                                noeHarm /= (double)noeVec.size();
                                if (!(Math.abs((disRms = Math.sqrt(disRms / (double)noeVec.size())) - 0.0) < 1.0E-4)) break block43;
                                if (++counter / 40 > nTemp) {
                                    out.close();
                                    fileName = String.valueOf(src) + "packing" + counter / 40 + ".pdb";
                                    out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                                }
                                nTemp = counter / 40;
                                System.out.println("here we have one packing satisfying noe constraints:");
                                System.out.println(String.valueOf(disRms) + " ... " + ranTheta + "  " + ranPhi + "  " + lengthR);
                                double[] centerBNewTemp = new double[3];
                                centerBNewTemp = new double[]{-xC2 + ranTheta, -yC2 + ranPhi, -zC2 + lengthR};
                                Vector<Pdb> pdbVecNewBTemp = pp.newPdbByTranslation(pdbVecB, centerBNewTemp);
                                Vector<Pdb> ppVecT = new Vector<Pdb>();
                                double[] centerANewTemp = new double[]{-centerA[0], -centerA[1], -centerA[2]};
                                Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANewTemp);
                                ppVecT.addAll(pdbANew);
                                ppVecT.addAll(pdbVecNewBTemp);
                                Collections.sort(ppVecT, new Pdb.PdbComparator());
                                System.out.println("MODEL" + m + " " + j + " " + k);
                                double[] vdwValue = new double[1];
                                boolean hasVDW = false;
                                double vdwLevel = 0.05;
                                boolean printVDWViolation = false;
                                boolean[] resIndex = new boolean[ppVecT.size()];
                                int kk = 0;
                                while (kk < resIndex.length) {
                                    resIndex[kk] = false;
                                    ++kk;
                                }
                                String rotSrc = String.valueOf(src) + "rotasamp-small/";
                                Vector ppVecTALA = pp.AlaninizeStructure(ppVecT, resIndex, rotSrc);
                                vdwVec = vander.convert2VDW(ppVecTALA);
                                int numClashes = vander.countStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.9);
                                System.out.println("the number of steric clashes: " + numClashes);
                                if (numClashes > 0) break block44;
                                boolean isInPreClusters = pp.isInPdbClusters(vecEnsemblePdbs, ppVecT, 0.6);
                                if (!isInPreClusters) {
                                    out.println("MODEL" + m + " " + j + " " + k);
                                    out.println("REMARK :   NOE RMSD=:" + disRms);
                                    out.println("REMARK :   NOE HARM=:" + noeHarm);
                                    out.println("REMARK :   numClashes in Alaninized strcuture=:" + numClashes);
                                    Vector<Pdb> vecFirstBB = pp.OutputBackbone(ppVecT);
                                    pp.printToFile(vecFirstBB, fileName, out);
                                    System.out.println("TER");
                                    System.out.println("END");
                                    out.println("TER");
                                    out.println("ENDMDL");
                                    vecEnsemblePdbs.add(vecFirstBB);
                                }
                            }
                            if (disRms < disRmsd) {
                                ranThetaS = ranTheta;
                                ranPhiS = ranPhi;
                                disRmsd = disRms;
                                lenS = lengthR;
                                i = 0;
                                while (i < noeVec.size()) {
                                    dis_save[i] = noeBackDis[i];
                                    ++i;
                                }
                                System.out.println(String.valueOf(disRmsd) + " ... " + ranThetaS + "  " + ranPhiS + "  " + lenS);
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++m;
            }
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        noeRms[0] = disRmsd;
        if (debugNOE) {
            System.out.println("NOE rmsd = " + disRmsd);
            System.out.println("NOE distances difference for individual ones:");
        }
        double[] centerBNew = new double[]{-xC2 + ranThetaS, -yC2 + ranPhiS, -zC2 + lenS};
        i = 0;
        while (i < noeVec.size()) {
            System.out.println(dis_save[i]);
            ++i;
        }
        Vector<Pdb> pdbBNew = pp.newPdbByTranslation(pdbVecB, centerBNew);
        double[] centerANew = new double[]{-centerA[0], -centerA[1], -centerA[2]};
        Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANew);
        Vector<Pdb> ppVecT = new Vector<Pdb>();
        ppVecT.addAll(pdbANew);
        ppVecT.addAll(pdbBNew);
        Collections.sort(ppVecT, new Pdb.PdbComparator());
        return ppVecT;
    }

    public Vector positionByNOEPatterns(Vector pdbVecA, Vector pdbVecB, Vector assignVec, Vector NoesyVec, double csErrH, double csErrN, double csErrCA, double distBound, int pickNum, double[] max_score) {
        int j;
        Pdb pdb;
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        String atom = "";
        Pdb pp = new Pdb();
        double[][] pdbA = new double[pdbVecA.size()][3];
        double[][] pdbB = new double[pdbVecB.size()][3];
        double[][] newArrB = new double[pdbVecB.size()][3];
        int i = 0;
        while (i < pdbVecA.size()) {
            pdb = (Pdb)pdbVecA.elementAt(i);
            atomVec = pdb.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("CA")) {
                    pdbA[i] = cc.getXYZ();
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < pdbVecB.size()) {
            pdb = (Pdb)pdbVecB.elementAt(i);
            atomVec = pdb.getAtomVec();
            j = 0;
            while (j < atomVec.size()) {
                cc = (Cartesian)atomVec.elementAt(j);
                atom = cc.getAtom();
                if (atom.equalsIgnoreCase("CA")) {
                    pdbB[i] = cc.getXYZ();
                }
                ++j;
            }
            ++i;
        }
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        double xC2 = 0.0;
        double yC2 = 0.0;
        double zC2 = 0.0;
        i = 0;
        while (i < pdbA.length) {
            xC1 += pdbA[i][0];
            yC1 += pdbA[i][1];
            zC1 += pdbA[i][2];
            ++i;
        }
        if (pdbA.length > 0) {
            xC1 /= (double)pdbA.length;
            yC1 /= (double)pdbA.length;
            zC1 /= (double)pdbA.length;
        }
        i = 0;
        while (i < pdbB.length) {
            xC2 += pdbB[i][0];
            yC2 += pdbB[i][1];
            zC2 += pdbB[i][2];
            ++i;
        }
        if (pdbB.length > 0) {
            xC2 /= (double)pdbB.length;
            yC2 /= (double)pdbB.length;
            zC2 /= (double)pdbB.length;
        }
        double lengthR = 0.0;
        double[] trans_vecA = new double[3];
        double[] trans_vecB = new double[3];
        double[] centerA = new double[]{xC1, yC1, zC1};
        double[] centerB = new double[]{xC2, yC2, zC2};
        double[] centerO = new double[]{0.0, 0.0, 0.0};
        trans_vecA = pp.internuclearVec(centerA, centerO);
        trans_vecB = pp.internuclearVec(centerB, centerO);
        Vector<Pdb> pdbVecNewA = pp.newPdbByTranslation(pdbVecA, trans_vecA);
        Vector<Pdb> pdbVecNewB = pp.newPdbByTranslation(pdbVecB, trans_vecB);
        double ranThetaS = 0.0;
        double ranPhiS = 0.0;
        double low = 0.0;
        double upper = 0.0;
        int resolution = 1;
        int radiusBound = 100;
        double len_resolution = 1.0;
        double lenS = 0.0;
        RotaPattern rotPattern = new RotaPattern();
        double dbScore = 0.0;
        Assign asg = new Assign();
        double maxSc = -999999.9;
        Vector<SSEPacking> vecSSEPack = new Vector<SSEPacking>();
        int m = 0;
        while (m < 180 / resolution) {
            double ranTheta = (double)(m * resolution) * Math.PI / 180.0;
            j = 0;
            while (j < 360 / resolution) {
                double ranPhi = (double)(j * resolution) * Math.PI / 360.0;
                int k = radiusBound;
                while (k > 0) {
                    lengthR = 2.0 + (double)k * 0.2;
                    double[] centerBNew = new double[]{lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), lengthR * Math.cos(ranTheta)};
                    double[] trans_vec = new double[3];
                    trans_vec = pp.internuclearVec(centerO, centerBNew);
                    Vector<Pdb> pdbVecNewB2 = pp.newPdbByTranslation(pdbVecNewB, trans_vec);
                    Vector vecHdist = pp.compDistPatternForSSEPacking(pdbVecNewA, pdbVecNewB2, distBound);
                    Vector vecBackNoe = rotPattern.BackCompNoePattern(assignVec, 0, "", vecHdist);
                    int[] numPeaks = new int[1];
                    dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoe, NoesyVec, numPeaks, false);
                    if (vecSSEPack.size() < pickNum) {
                        vecSSEPack.add(new SSEPacking(ranTheta, ranPhi, lengthR, dbScore));
                        System.out.println(" ranTheta = " + ranTheta + " ranPhi= " + ranPhi + "LengthR= " + lengthR + " maxSc=" + maxSc);
                    } else {
                        SSEPacking ssePack = (SSEPacking)vecSSEPack.elementAt(pickNum - 1);
                        maxSc = ssePack.getScore();
                        if (maxSc < dbScore) {
                            vecSSEPack.remove(pickNum - 1);
                            vecSSEPack.add(new SSEPacking(ranTheta, ranPhi, lengthR, dbScore));
                            System.out.println(" ranTheta = " + ranTheta + " ranPhi= " + ranPhi + "LengthR= " + lengthR + " maxSc=" + maxSc);
                        }
                    }
                    Collections.sort(vecSSEPack, new SSEPacking.SSEPackingComparator());
                    --k;
                }
                ++j;
            }
            ++m;
        }
        SSEPacking vecPackTemp = (SSEPacking)vecSSEPack.elementAt(0);
        max_score[0] = vecPackTemp.getScore();
        double[] centerBNew2 = new double[3];
        Vector vecPackEnsemble = new Vector();
        i = 0;
        while (i < vecSSEPack.size()) {
            SSEPacking ssePack = (SSEPacking)vecSSEPack.elementAt(i);
            ranThetaS = ssePack.getTheta();
            ranPhiS = ssePack.getPhi();
            lenS = ssePack.getLengthR();
            centerBNew2 = new double[]{lenS * Math.sin(ranThetaS) * Math.cos(ranPhiS), lenS * Math.sin(ranThetaS) * Math.sin(ranPhiS), lenS * Math.cos(ranThetaS)};
            trans_vecB = pp.internuclearVec(centerO, centerBNew2);
            Vector<Pdb> pdbVecNewBFinal = pp.newPdbByTranslation(pdbVecNewB, trans_vecB);
            Vector<Pdb> ppVecT = new Vector<Pdb>();
            ppVecT.addAll(pdbVecNewA);
            ppVecT.addAll(pdbVecNewBFinal);
            Collections.sort(ppVecT, new Pdb.PdbComparator());
            vecPackEnsemble.add(ppVecT);
            ++i;
        }
        return vecPackEnsemble;
    }

    public Vector calcMinPackingRms(Vector noeVec, Vector pdbVecA, Vector pdbVecB, double[] noeRms, boolean debugNOE) throws JampackException {
        int noB;
        int j;
        int noA;
        int index = -1;
        String atom = "";
        String atomA = "";
        String atomB = "";
        Vector<Object> atomVec = new Vector();
        Cartesian cc = new Cartesian();
        Pdb pp = new Pdb();
        int sizeA = 0;
        int sizeB = 0;
        double[][] pdbA2 = new double[noeVec.size() * 6][3];
        double[][] pdbB2 = new double[noeVec.size() * 6][3];
        Vector<String> id4A = new Vector<String>();
        Vector<String> id4B = new Vector<String>();
        String id = "";
        double[][] noeDistance = new double[noeVec.size()][2];
        boolean isQ = true;
        int i = 0;
        while (i < noeVec.size()) {
            String atom_temp;
            noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
            atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
            String tempA = "";
            isQ = true;
            if (atomA.length() >= 2) {
                if (atomA.substring(0, 1).equalsIgnoreCase("Q") && !atomA.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempA = "H" + atomA.substring(1, atomA.length());
                } else if (atomA.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempA = "H" + atomA.substring(2, atomA.length());
                } else {
                    tempA = atomA;
                    isQ = false;
                }
            } else {
                tempA = atomA;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecA, new Pdb(noA), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecA.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempA.length()) {
                        String debug_str = atom.substring(0, tempA.length());
                        id = String.valueOf(String.valueOf(noA)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempA.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempA) && !id4A.contains(id)) {
                            pdbA2[sizeA] = cc.getXYZ();
                            id4A.add(id);
                            ++sizeA;
                        }
                    }
                    ++j;
                }
            }
            noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
            atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
            String tempB = "";
            isQ = true;
            if (atomB.length() >= 2) {
                if (atomB.substring(0, 1).equalsIgnoreCase("Q") && !atomB.substring(1, 2).equalsIgnoreCase("Q")) {
                    tempB = "H" + atomB.substring(1, atomB.length());
                } else if (atomB.substring(0, 2).equalsIgnoreCase("QQ")) {
                    tempB = "H" + atomB.substring(2, atomB.length());
                } else {
                    tempB = atomB;
                    isQ = false;
                }
            } else {
                tempB = atomB;
                isQ = false;
            }
            index = Collections.binarySearch(pdbVecB, new Pdb(noB), new Pdb.PdbComparator());
            if (index > -1) {
                pp = (Pdb)pdbVecB.elementAt(index);
                atomVec = pp.getAtomVec();
                j = 0;
                while (j < atomVec.size()) {
                    cc = (Cartesian)atomVec.elementAt(j);
                    atom = cc.getAtom();
                    if (atom.length() >= tempB.length()) {
                        id = String.valueOf(String.valueOf(noB)) + atom;
                        atom_temp = "";
                        atom_temp = isQ ? atom.substring(0, tempB.length()) : atom;
                        if (atom_temp.equalsIgnoreCase(tempB) && !id4B.contains(id)) {
                            pdbB2[sizeB] = cc.getXYZ();
                            id4B.add(id);
                            ++sizeB;
                        }
                    }
                    ++j;
                }
            }
            noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
            ++i;
        }
        int n = 3;
        double xC1 = 0.0;
        double yC1 = 0.0;
        double zC1 = 0.0;
        double xC2 = 0.0;
        double yC2 = 0.0;
        double zC2 = 0.0;
        double noeAve = 0.0;
        i = 0;
        while (i < sizeA) {
            xC1 += pdbA2[i][0];
            yC1 += pdbA2[i][1];
            zC1 += pdbA2[i][2];
            ++i;
        }
        if (sizeA > 0) {
            xC1 /= (double)sizeA;
            yC1 /= (double)sizeA;
            zC1 /= (double)sizeA;
        }
        i = 0;
        while (i < sizeB) {
            xC2 += pdbB2[i][0];
            yC2 += pdbB2[i][1];
            zC2 += pdbB2[i][2];
            ++i;
        }
        if (sizeB > 0) {
            xC2 /= (double)sizeB;
            yC2 /= (double)sizeB;
            zC2 /= (double)sizeB;
        }
        i = 0;
        while (i < noeVec.size()) {
            noeAve += (noeDistance[i][0] + noeDistance[i][1]) / 2.0;
            ++i;
        }
        double lengthR = noeAve /= (double)noeVec.size();
        double diffCenter = Math.sqrt((xC1 - xC2) * (xC1 - xC2) + (yC1 - yC2) * (yC1 - yC2) + (zC1 - zC2) * (zC1 - zC2));
        double disRms = 0.0;
        double noeHarm = 0.0;
        double[] noeDis = new double[noeVec.size()];
        double[] noeBackDis = new double[noeVec.size()];
        double[] dis_save = new double[noeVec.size()];
        double[] trans_vecA = new double[3];
        double[] trans_vecB = new double[3];
        double[] centerA = new double[]{xC1, yC1, zC1};
        double[] centerB = new double[]{xC2, yC2, zC2};
        double[] centerO = new double[]{0.0, 0.0, 0.0};
        trans_vecA = pp.internuclearVec(centerA, centerO);
        trans_vecB = pp.internuclearVec(centerB, centerO);
        Vector<Pdb> pdbVecNewA = pp.newPdbByTranslation(pdbVecA, trans_vecA);
        Vector<Pdb> pdbVecNewB = pp.newPdbByTranslation(pdbVecB, trans_vecB);
        double ranThetaS = 0.0;
        double ranPhiS = 0.0;
        double disRmsd = 1000.0;
        long seed = 9754L;
        Random rr = new Random(seed);
        double low = 0.0;
        double upper = 0.0;
        int resolution = 4;
        int noeRangeRes = 20;
        double lenS = 0.0;
        int m = 0;
        while (m < 180 / resolution) {
            double ranTheta = (double)(m * resolution) * Math.PI / 180.0;
            j = 0;
            while (j < 360 / resolution) {
                double ranPhi = (double)(j * resolution) * Math.PI / 180.0;
                int k = noeRangeRes;
                while (k >= 0) {
                    lengthR = 0.0 + 0.5 * (double)k;
                    double[] centerBNew = new double[]{lengthR * Math.sin(ranTheta) * Math.cos(ranPhi), lengthR * Math.sin(ranTheta) * Math.sin(ranPhi), lengthR * Math.cos(ranTheta)};
                    double[] trans_vec = new double[3];
                    trans_vec = pp.internuclearVec(centerO, centerBNew);
                    Vector<Pdb> pdbVecNewB2 = pp.newPdbByTranslation(pdbVecNewB, trans_vec);
                    disRms = 0.0;
                    noeHarm = 0.0;
                    i = 0;
                    while (i < noeVec.size()) {
                        noA = ((Noe)noeVec.elementAt(i)).getResidueNoA();
                        atomA = ((Noe)noeVec.elementAt(i)).getAtomA();
                        noB = ((Noe)noeVec.elementAt(i)).getResidueNoB();
                        atomB = ((Noe)noeVec.elementAt(i)).getAtomB();
                        noeDistance[i] = ((Noe)noeVec.elementAt(i)).getRange();
                        double[] dis = new double[1];
                        double[] distance = new double[1];
                        pp.measurePackDisAllRotamers(pdbVecNewA, pdbVecNewB2, noA, atomA, noB, atomB, noeDistance[i][0], noeDistance[i][1], dis, distance);
                        noeDis[i] = dis[0];
                        noeBackDis[i] = distance[0];
                        disRms += noeDis[i] * noeDis[i];
                        noeHarm += noeDis[i] * noeDis[i];
                        ++i;
                    }
                    noeHarm /= (double)noeVec.size();
                    if ((disRms = Math.sqrt(disRms / (double)noeVec.size())) < disRmsd) {
                        ranThetaS = ranTheta;
                        ranPhiS = ranPhi;
                        disRmsd = disRms;
                        lenS = lengthR;
                        i = 0;
                        while (i < noeVec.size()) {
                            dis_save[i] = noeBackDis[i];
                            ++i;
                        }
                        System.out.println(String.valueOf(disRmsd) + " ... " + ranThetaS + "  " + ranPhiS + "  " + lenS);
                    }
                    --k;
                }
                ++j;
            }
            ++m;
        }
        noeRms[0] = disRmsd;
        if (debugNOE) {
            System.out.println("NOE rmsd = " + disRmsd);
            System.out.println("NOE distances difference for individual ones:");
        }
        double[] centerBNew = new double[]{-xC2 + lenS * Math.sin(ranThetaS) * Math.cos(ranPhiS), -yC2 + lenS * Math.sin(ranThetaS) * Math.sin(ranPhiS), -zC2 + lenS * Math.cos(ranThetaS)};
        i = 0;
        while (i < noeVec.size()) {
            System.out.println(dis_save[i]);
            ++i;
        }
        Vector<Pdb> pdbBNew = pp.newPdbByTranslation(pdbVecB, centerBNew);
        double[] centerANew = new double[]{-centerA[0], -centerA[1], -centerA[2]};
        Vector<Pdb> pdbANew = pp.newPdbByTranslation(pdbVecA, centerANew);
        Vector<Pdb> ppVecT = new Vector<Pdb>();
        ppVecT.addAll(pdbANew);
        ppVecT.addAll(pdbBNew);
        Collections.sort(ppVecT, new Pdb.PdbComparator());
        return ppVecT;
    }

    private static void check(double x, double y) {
        double eps = Math.pow(2.0, -52.0);
        if (x == 0.0 & Math.abs(y) < 10.0 * eps) {
            return;
        }
        if (y == 0.0 & Math.abs(x) < 10.0 * eps) {
            return;
        }
        if (Math.abs(x - y) > 10.0 * eps * Math.max(Math.abs(x), Math.abs(y))) {
            throw new RuntimeException("The difference x-y is too large: x = " + Double.toString(x) + "  y = " + Double.toString(y));
        }
    }

    private static void check(double[] x, double[] y) {
        if (x.length == y.length) {
            int i = 0;
            while (i < x.length) {
                PdbRmsd.check(x[i], y[i]);
                ++i;
            }
        } else {
            throw new RuntimeException("Attempt to compare vectors of different lengths");
        }
    }

    private static void check(double[][] x, double[][] y) {
        Matrix A = new Matrix(x);
        Matrix B = new Matrix(y);
        PdbRmsd.check(A, B);
    }

    private static void check(Matrix X, Matrix Y) {
        double eps = Math.pow(2.0, -52.0);
        if (X.norm1() == 0.0 & Y.norm1() < 10.0 * eps) {
            return;
        }
        if (Y.norm1() == 0.0 & X.norm1() < 10.0 * eps) {
            return;
        }
        if (X.minus(Y).norm1() > 1000.0 * eps * Math.max(X.norm1(), Y.norm1())) {
            throw new RuntimeException("The norm of (X-Y) is too large: " + Double.toString(X.minus(Y).norm1()));
        }
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static void try_success(String s, String e) {
        PdbRmsd.print(">    " + s + "success\n");
        if (e != "") {
            PdbRmsd.print(">      Message: " + e + "\n");
        }
    }

    private static int try_failure(int count, String s, String e) {
        PdbRmsd.print(">    " + s + "*** failure ***\n>      Message: " + e + "\n");
        return ++count;
    }
}

