/*
 * Decompiled with CFR 0.152.
 */
package Nasca;

import Nasca.GraphNode;
import Nasca.NascaNew;
import Nasca.PairwiseScoreMatrix;
import Nasca.ProtonLabel;
import Nasca.TreeNode;
import java.util.Collections;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.H1CS;
import rdcPanda.Noesy;
import rdcPanda.Peak;

public class AStar {
    public Vector<H1CS> AStarSearchForSCAsgs(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecHPositions, int[][] Map2, double[][] MapScore, Vector<Noesy> vecNewNoesy, Vector<H1CS> vecBMRBNew) {
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        NascaNew nasca = new NascaNew();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        while (true) {
            boolean isAllAsg = true;
            double maxScore = -99999.9;
            int maxID = -1;
            int maxMapID = -1;
            int j = 0;
            while (j < vecHPositions.size()) {
                block13: {
                    ProtonLabel label = vecHPositions.elementAt(j);
                    String res = label.getResName();
                    String atom = label.getAtomName();
                    String heavName = pk.GetHeavyAtomFromProton(res, atom);
                    int resNo = label.getResNo();
                    Vector<GraphNode> vecMapSet = label.getMappingSet();
                    Vector<ProtonLabel> vecAdj = label.getAdjVec();
                    if (label.getIsAssigned()) break block13;
                    int k = 0;
                    while (k < vecMapSet.size()) {
                        block15: {
                            double hScore;
                            Vector<H1CS> vecOneSCAsgNew;
                            double asgScore;
                            double cs_heavy;
                            double cs_proton;
                            Vector<Noesy> vecNoesyTwo;
                            Vector<BackNoe> vecBackNoe;
                            Vector<H1CS> vecOneSCAsg;
                            block16: {
                                GraphNode ndStereoReson;
                                GraphNode nodeMap;
                                block14: {
                                    nodeMap = vecMapSet.elementAt(k);
                                    if (nodeMap.asgedId < 0) break block14;
                                    ProtonLabel nodeTemp = vecHPositions.elementAt(nodeMap.asgedId);
                                    if (nodeTemp.stereoID != label.getID() || nodeMap.vecStereoSymSet.size() > 0) break block15;
                                }
                                vecOneSCAsg = new Vector<H1CS>();
                                vecBackNoe = new Vector<BackNoe>();
                                vecNoesyTwo = new Vector<Noesy>();
                                Vector<Noesy> vecNoesy = nodeMap.vecAdjNOESY;
                                vecNoesyTwo.addAll(vecNoesy);
                                cs_proton = nodeMap.getCSProton();
                                cs_heavy = nodeMap.getCSHeavy();
                                if (label.stereoID < 0) break block16;
                                ProtonLabel nodeStereo = vecHPositions.elementAt(label.stereoID);
                                if (nodeStereo.asgedId >= 0 && Math.abs((ndStereoReson = vecResonGraph.elementAt(nodeStereo.asgedId)).getCSHeavy() - cs_heavy) > 0.15) break block15;
                            }
                            vecOneSCAsg.add(new H1CS(resNo, res, atom, cs_proton));
                            vecOneSCAsg.add(new H1CS(resNo, res, heavName, cs_heavy));
                            int t = 0;
                            while (t < vecAdj.size()) {
                                ProtonLabel nodeAdj = vecAdj.elementAt(t);
                                if (nodeAdj.getIsAssigned() && nodeAdj.asgedId >= 0) {
                                    GraphNode nodeAdjReson = vecResonGraph.elementAt(nodeAdj.asgedId);
                                    vecNoesyTwo.addAll(nodeAdjReson.vecAdjNOESY);
                                    int resNoSec = nodeAdj.getResNo();
                                    String resSec = nodeAdj.getResName();
                                    String atomSec = nodeAdj.getAtomName();
                                    String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                                    double cs_protonSec = nodeAdjReson.getCSProton();
                                    double cs_heavySec = nodeAdjReson.getCSHeavy();
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, atomSec, cs_protonSec));
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, heavyNameSec, cs_heavySec));
                                    double distUp = 6.0;
                                    if (nasca.isInCloseAdj(nodeAdj, label)) {
                                        distUp = 2.7;
                                    }
                                    vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, distUp, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                                    vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, distUp, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
                                }
                                ++t;
                            }
                            Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                            int[] numPeaks = new int[1];
                            double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                            double gScore = (dbScore *= (double)vecBackNoeNew.size()) + (asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg), vecBMRBNew));
                            double fScore = gScore + (hScore = this.ComputeAStarEstimatedCost(vecResonGraph, vecHPositions, vecBMRBNew, j));
                            if (fScore > maxScore) {
                                maxScore = fScore;
                                maxID = j;
                                maxMapID = k;
                            }
                        }
                        ++k;
                    }
                    isAllAsg = false;
                }
                ++j;
            }
            if (isAllAsg || maxID <= 0) break;
            System.out.print("Current expansion node: ID=" + maxID + ", ");
            ProtonLabel label = vecHPositions.elementAt(maxID);
            Vector<GraphNode> vecMapSet = label.getMappingSet();
            GraphNode nodeMap = vecMapSet.elementAt(maxMapID);
            label.asgedId = nodeMap.getID();
            nodeMap.asgedId = label.getID();
            label.setIsAssigned(true);
            nodeMap.setIsAssigned(true);
            System.out.println(String.valueOf(label.getResNo()) + label.getResName() + " - " + label.getAtomName() + ": " + nodeMap.getCSProton() + " , " + nodeMap.getCSHeavy());
            if (label.stereoID <= 0) continue;
            ProtonLabel ndStereoProton = vecHPositions.elementAt(label.stereoID);
            Vector<GraphNode> vecStereoReson = nodeMap.vecStereoSymSet;
            if (vecStereoReson.size() <= 0) continue;
            if (vecStereoReson.size() == 1) {
                GraphNode ndStereoReson = vecStereoReson.elementAt(0);
                ndStereoProton.asgedId = ndStereoReson.getID();
                ndStereoReson.asgedId = ndStereoProton.getID();
                ndStereoProton.setIsAssigned(true);
                ndStereoReson.setIsAssigned(true);
                continue;
            }
            Vector<GraphNode> vecStereoProtonMap = ndStereoProton.getMappingSet();
            vecStereoProtonMap = new Vector();
            vecStereoProtonMap.addAll(vecMapSet);
        }
        Vector<H1CS> vecAsg = new Vector<H1CS>();
        int j = 0;
        while (j < vecHPositions.size()) {
            ProtonLabel node2 = vecHPositions.elementAt(j);
            String resName = node2.getResName();
            String atomName = node2.getAtomName();
            String heavName = pk.GetHeavyAtomFromProton(resName, atomName);
            int resNo = node2.getResNo();
            int resonID = node2.asgedId;
            if (resonID >= 0) {
                GraphNode nodeResonAsg = vecResonGraph.elementAt(resonID);
                double cs_proton = nodeResonAsg.getCSProton();
                double cs_heavy = nodeResonAsg.getCSHeavy();
                vecAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
                vecAsg.add(new H1CS(resNo, resName, heavName, cs_heavy));
            }
            ++j;
        }
        return vecAsg;
    }

    public double ComputeAStarEstimatedCost(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecLabels, Vector<H1CS> vecBMRBNew, int curIndex) {
        Peak pk = new Peak();
        H1CS h1cs = new H1CS();
        double est_cost = 0.0;
        int j = 0;
        while (j < vecLabels.size()) {
            block7: {
                ProtonLabel label = vecLabels.elementAt(j);
                String res = label.getResName();
                String atom = label.getAtomName();
                String heavName = pk.GetHeavyAtomFromProton(res, atom);
                int resNo = label.getResNo();
                Vector<GraphNode> vecMapSet = label.getMappingSet();
                if (label.getIsAssigned() || curIndex == j) break block7;
                double maxScore = -99999.9;
                int maxMapID = -1;
                int k = 0;
                while (k < vecMapSet.size()) {
                    block9: {
                        double asgScore;
                        double cs_heavy;
                        double cs_proton;
                        Vector<H1CS> vecOneSCAsg;
                        block10: {
                            GraphNode ndStereoReson;
                            GraphNode nodeMap;
                            block8: {
                                nodeMap = vecMapSet.elementAt(k);
                                if (nodeMap.asgedId < 0) break block8;
                                ProtonLabel nodeTemp = vecLabels.elementAt(nodeMap.asgedId);
                                if (nodeTemp.stereoID != label.getID() || nodeMap.vecStereoSymSet.size() > 0) break block9;
                            }
                            vecOneSCAsg = new Vector<H1CS>();
                            Vector<Noesy> vecNoesyTwo = new Vector<Noesy>();
                            Vector<Noesy> vecNoesy = nodeMap.vecAdjNOESY;
                            vecNoesyTwo.addAll(vecNoesy);
                            cs_proton = nodeMap.getCSProton();
                            cs_heavy = nodeMap.getCSHeavy();
                            if (label.stereoID < 0) break block10;
                            ProtonLabel nodeStereo = vecLabels.elementAt(label.stereoID);
                            if (nodeStereo.asgedId >= 0 && Math.abs((ndStereoReson = vecResonGraph.elementAt(nodeStereo.asgedId)).getCSHeavy() - cs_heavy) > 0.15) break block9;
                        }
                        vecOneSCAsg.add(new H1CS(resNo, res, atom, cs_proton));
                        vecOneSCAsg.add(new H1CS(resNo, res, heavName, cs_heavy));
                        Vector<H1CS> vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg);
                        double score = asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew, vecBMRBNew);
                        if (score > maxScore) {
                            maxScore = score;
                            maxMapID = k;
                        }
                    }
                    ++k;
                }
                if (maxMapID >= 0) {
                    est_cost += maxScore;
                }
            }
            ++j;
        }
        return est_cost;
    }

    public void AStarSearchForSCAsgsNew(Vector<GraphNode> vecResonGraph, Vector<ProtonLabel> vecHPositions, int[][] Map2, double[][] MapScore, Vector<Noesy> vecNewNoesy, Vector<H1CS> vecBMRBNew) {
        Vector<TreeNode> vecTNodeQueue = new Vector<TreeNode>();
        int MAX_ID = 2000;
        double[][] bestScoreMatrix = new double[MAX_ID][MAX_ID];
        int i = 0;
        while (i < MAX_ID) {
            int j = 0;
            while (j < MAX_ID) {
                bestScoreMatrix[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        PairwiseScoreMatrix pwScoreMatrix = new PairwiseScoreMatrix();
        pwScoreMatrix.computBestScoreMatrix(vecResonGraph, vecHPositions, vecBMRBNew, bestScoreMatrix);
        Vector<GraphNode> vecResonQueue = new Vector<GraphNode>();
        int i2 = 0;
        while (i2 < vecResonGraph.size()) {
            GraphNode node = vecResonGraph.elementAt(i2);
            if (!node.getIsAssigned() && node.getMappingSet().size() != 0) {
                vecResonQueue.add(node);
            }
            ++i2;
        }
        Collections.sort(vecResonQueue, new GraphNode.scoreComparator());
        GraphNode firstResonNode = (GraphNode)vecResonQueue.elementAt(0);
        Object treeRoot = null;
        Vector<ProtonLabel> vecMapSet = firstResonNode.getMappingSet();
        int i3 = 0;
        while (i3 < vecMapSet.size()) {
            ProtonLabel label = vecMapSet.elementAt(i3);
            TreeNode tree_node = new TreeNode();
            tree_node.pNode = treeRoot;
            tree_node.resonNode = firstResonNode;
            tree_node.labelNode = label;
            tree_node.level = 1;
            tree_node.vecUnsgedNodes = this.computUnassignedNodes(tree_node, vecResonQueue);
            double h_score = this.computEstimateScore(tree_node, vecResonQueue);
            double g_score = this.computActualScore(tree_node, vecHPositions, vecBMRBNew);
            tree_node.setActualScore(g_score);
            tree_node.setEstimateScore(h_score);
            tree_node.setTotalScore();
            vecTNodeQueue.add(tree_node);
            if (label.stereoID > 0) {
                ProtonLabel ndStereoProton = vecHPositions.elementAt(label.stereoID);
                Vector<GraphNode> vecStereoReson = firstResonNode.vecStereoSymSet;
                if (vecStereoReson.size() > 0) {
                    if (vecStereoReson.size() == 1) {
                        GraphNode ndStereoReson = vecStereoReson.elementAt(0);
                        TreeNode stereoUnasgTNode = this.locateOneFromRemainUnasgedNodes(ndStereoReson, tree_node.vecUnsgedNodes);
                        stereoUnasgTNode.labelNode = ndStereoProton;
                    } else {
                        int h = 0;
                        while (h < vecStereoReson.size()) {
                            GraphNode tempResonNode = vecStereoReson.elementAt(h);
                            Vector<ProtonLabel> vecStereoTemp = tempResonNode.getMappingSet();
                            vecStereoTemp = new Vector();
                            vecStereoTemp.addAll(vecMapSet);
                            ++h;
                        }
                    }
                }
            }
            ++i3;
        }
        TreeNode leafNode = new TreeNode();
        int curTreeLevel = 1;
        int maxTreeLevel = 1;
        while (maxTreeLevel < vecResonQueue.size()) {
            GraphNode currentResonNode;
            Collections.sort(vecTNodeQueue, new TreeNode.fscoreComparator());
            TreeNode expanTNode = (TreeNode)vecTNodeQueue.elementAt(0);
            curTreeLevel = expanTNode.level;
            if (curTreeLevel == maxTreeLevel) {
                ++maxTreeLevel;
            }
            if (Math.abs((currentResonNode = vecResonQueue.elementAt(curTreeLevel)).getCSHeavy() - 29.522) < 0.1 && Math.abs(currentResonNode.getCSProton() - 1.992) < 0.04) {
                System.out.println("debugging...here");
            }
            TreeNode curTNode = this.locateOneFromRemainUnasgedNodes(currentResonNode, expanTNode.vecUnsgedNodes);
            if (curTNode.labelNode != null) {
                TreeNode tree_node = new TreeNode();
                expanTNode.vecChildNode.add(tree_node);
                tree_node.pNode = expanTNode;
                tree_node.resonNode = currentResonNode;
                tree_node.labelNode = curTNode.labelNode;
                tree_node.level = curTreeLevel + 1;
                Vector<TreeNode> vecPreUnasgNodes = expanTNode.vecUnsgedNodes;
                tree_node.vecUnsgedNodes = this.computUnassignedNodesFromPre(tree_node, vecPreUnasgNodes);
                double h_score = this.computEstimateScore(tree_node, vecResonQueue);
                double g_score = this.computActualScore(tree_node, vecHPositions, vecBMRBNew);
                tree_node.setActualScore(g_score);
                tree_node.setEstimateScore(h_score);
                tree_node.setTotalScore();
                vecTNodeQueue.add(tree_node);
                if (maxTreeLevel == vecResonQueue.size() - 1) {
                    leafNode = tree_node;
                }
            } else {
                Vector<ProtonLabel> vecCurMapSet = currentResonNode.getMappingSet();
                double maxScore = -9999.9;
                boolean isStereoAsg = false;
                int i4 = 0;
                while (i4 < vecCurMapSet.size()) {
                    ProtonLabel label = vecCurMapSet.elementAt(i4);
                    TreeNode tree_node = new TreeNode();
                    expanTNode.vecChildNode.add(tree_node);
                    tree_node.pNode = expanTNode;
                    tree_node.resonNode = currentResonNode;
                    tree_node.labelNode = label;
                    tree_node.level = curTreeLevel + 1;
                    Vector<TreeNode> vecPreUnasgNodes = expanTNode.vecUnsgedNodes;
                    tree_node.vecUnsgedNodes = this.computUnassignedNodesFromPre(tree_node, vecPreUnasgNodes);
                    boolean isStereoPruned = this.isPruneMapByStereo(currentResonNode, label, vecResonGraph, vecHPositions, tree_node.vecUnsgedNodes);
                    if (!isStereoPruned) {
                        double h_score = this.computEstimateScore(tree_node, vecResonQueue);
                        double g_score = this.computActualScore(tree_node, vecHPositions, vecBMRBNew);
                        tree_node.setActualScore(g_score);
                        tree_node.setEstimateScore(h_score);
                        tree_node.setTotalScore();
                        vecTNodeQueue.add(tree_node);
                        if (h_score + g_score > maxScore) {
                            maxScore = h_score + g_score;
                            if (maxTreeLevel == vecResonQueue.size() - 1) {
                                leafNode = tree_node;
                            }
                        }
                        if (label.stereoID > 0) {
                            ProtonLabel ndStereoProton = vecHPositions.elementAt(label.stereoID);
                            Vector<GraphNode> vecStereoReson = currentResonNode.vecStereoSymSet;
                            if (vecStereoReson.size() > 0) {
                                if (vecStereoReson.size() == 1) {
                                    isStereoAsg = true;
                                    GraphNode ndStereoReson = vecStereoReson.elementAt(0);
                                    TreeNode stereoUnasgTNode = this.locateOneFromRemainUnasgedNodes(ndStereoReson, tree_node.vecUnsgedNodes);
                                    stereoUnasgTNode.labelNode = ndStereoProton;
                                } else {
                                    int h = 0;
                                    while (h < vecStereoReson.size()) {
                                        GraphNode tempResonNode = vecStereoReson.elementAt(h);
                                        Vector<ProtonLabel> vecStereoTemp = tempResonNode.getMappingSet();
                                        vecStereoTemp = new Vector();
                                        vecStereoTemp.addAll(vecCurMapSet);
                                        ++h;
                                    }
                                }
                            }
                        }
                    }
                    ++i4;
                }
                if (isStereoAsg) {
                    this.deleNonStereoBranches(expanTNode, vecTNodeQueue);
                }
            }
            vecTNodeQueue.remove(0);
        }
        int i5 = 0;
        while (i5 < vecResonGraph.size()) {
            int j = 0;
            while (j < vecHPositions.size()) {
                Map2[i5][j] = 0;
                ++j;
            }
            ++i5;
        }
        TreeNode tempTNode = leafNode;
        while (tempTNode != null) {
            GraphNode resonNode = tempTNode.resonNode;
            ProtonLabel labelNode = tempTNode.labelNode;
            Map2[resonNode.getID()][labelNode.getID()] = 1;
            tempTNode = tempTNode.pNode;
        }
    }

    public void deleNonStereoBranches(TreeNode parentNode, Vector<TreeNode> vecTNodeQueue) {
        Vector<TreeNode> vecChildTreeNodes = parentNode.vecChildNode;
        int i = 0;
        while (i < vecChildTreeNodes.size()) {
            TreeNode tempTNode = vecChildTreeNodes.elementAt(i);
            if (tempTNode.labelNode.stereoID < 0) {
                vecChildTreeNodes.remove(i);
                --i;
                int j = 0;
                while (j < vecTNodeQueue.size()) {
                    TreeNode qNode = vecTNodeQueue.elementAt(j);
                    if (qNode.resonNode.getID() == tempTNode.resonNode.getID() && qNode.labelNode.getID() == tempTNode.labelNode.getID()) {
                        vecTNodeQueue.remove(j);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public boolean isPruneMapByStereo(GraphNode resonNode, ProtonLabel label, Vector<GraphNode> vecResonNodes, Vector<ProtonLabel> vecLabels, Vector<TreeNode> vecUnasgNodes) {
        if (label.stereoID < 0) {
            return false;
        }
        if (resonNode.vecStereoSymSet.size() == 1) {
            GraphNode stereo_resonNode = vecResonNodes.elementAt(resonNode.stereoID);
            TreeNode stereo_tNode = this.locateOneFromRemainUnasgedNodes(stereo_resonNode, vecUnasgNodes);
            if (stereo_tNode.labelNode != null && stereo_tNode.labelNode.stereoID != label.getID()) {
                return true;
            }
        } else {
            int i = 0;
            while (i < vecUnasgNodes.size()) {
                TreeNode tNode = vecUnasgNodes.elementAt(i);
                if (tNode.labelNode != null && tNode.labelNode.getID() == label.getID()) {
                    return true;
                }
                ++i;
            }
        }
        ProtonLabel labelStereo = vecLabels.elementAt(label.stereoID);
        int i = 0;
        while (i < vecUnasgNodes.size()) {
            TreeNode tNode = vecUnasgNodes.elementAt(i);
            if (tNode.labelNode != null && labelStereo.getID() == tNode.labelNode.getID()) {
                double cs_heavy = resonNode.getCSHeavy();
                if (Math.abs(tNode.resonNode.getCSHeavy() - cs_heavy) > 0.15) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public TreeNode locateOneFromRemainUnasgedNodes(GraphNode resonNode, Vector<TreeNode> vecUnasgNodes) {
        int resonID = resonNode.getID();
        int i = 0;
        while (i < vecUnasgNodes.size()) {
            TreeNode tNode = vecUnasgNodes.elementAt(i);
            GraphNode tempResonNode = tNode.resonNode;
            if (resonID == tempResonNode.getID()) {
                return tNode;
            }
            ++i;
        }
        return null;
    }

    public Vector<TreeNode> computUnassignedNodesFromPre(TreeNode curTreeNode, Vector<TreeNode> vecPreUnasgNodes) {
        Vector<TreeNode> vecUnasgNodes = new Vector<TreeNode>();
        GraphNode curResonNode = curTreeNode.resonNode;
        int i = 0;
        while (i < vecPreUnasgNodes.size()) {
            TreeNode t_node = vecPreUnasgNodes.elementAt(i);
            GraphNode preResonNode = t_node.resonNode;
            if (preResonNode.getID() != curResonNode.getID()) {
                vecUnasgNodes.add(new TreeNode(t_node));
            }
            ++i;
        }
        return vecUnasgNodes;
    }

    public Vector<TreeNode> computUnassignedNodes(TreeNode curTreeNode, Vector<GraphNode> vecAllResonNodes) {
        Vector<TreeNode> vecUnasgNodes = new Vector<TreeNode>();
        int i = 0;
        while (i < vecAllResonNodes.size()) {
            GraphNode node = vecAllResonNodes.elementAt(i);
            if (!node.getIsAssigned()) {
                boolean isExplored = false;
                TreeNode tempTreeNode = curTreeNode;
                while (tempTreeNode != null) {
                    GraphNode nodeTemp = tempTreeNode.resonNode;
                    if (nodeTemp.getID() == node.getID()) {
                        isExplored = true;
                        break;
                    }
                    tempTreeNode = tempTreeNode.pNode;
                }
                if (!isExplored) {
                    TreeNode tree_node = new TreeNode();
                    tree_node.resonNode = node;
                    vecUnasgNodes.add(tree_node);
                }
            }
            ++i;
        }
        return vecUnasgNodes;
    }

    public double computEstimateScore(TreeNode curTreeNode, Vector<GraphNode> vecResonGraph) {
        double score = 0.0;
        int i = 0;
        while (i < vecResonGraph.size()) {
            GraphNode node = vecResonGraph.elementAt(i);
            if (!node.getIsAssigned()) {
                boolean isExplored = false;
                TreeNode tempTreeNode = curTreeNode;
                while (tempTreeNode != null) {
                    GraphNode nodeTemp = tempTreeNode.resonNode;
                    if (nodeTemp.getID() == node.getID()) {
                        isExplored = true;
                        break;
                    }
                    tempTreeNode = tempTreeNode.pNode;
                }
                if (!isExplored) {
                    score += node.bestScore;
                }
            }
            ++i;
        }
        return score;
    }

    public double computActualScore(TreeNode curTreeNode, Vector<ProtonLabel> vecLabels, Vector<H1CS> vecBMRBNew) {
        TreeNode pTreeNode = curTreeNode.pNode;
        GraphNode cur_node = curTreeNode.resonNode;
        ProtonLabel cur_label = curTreeNode.labelNode;
        TreeNode tnode = new TreeNode();
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        NascaNew nasca = new NascaNew();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        tnode.setAsgedIdTemp(curTreeNode);
        Vector<Noesy> vecNoesy = cur_node.vecAdjNOESY;
        double cs_proton = cur_node.getCSProton();
        double cs_heavy = cur_node.getCSHeavy();
        Vector<GraphNode> vecAdj = cur_node.getAdjVec();
        Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
        String res = cur_label.getResName();
        String atom = cur_label.getAtomName();
        String heavName = pk.GetHeavyAtomFromProton(res, atom);
        int resNo = cur_label.getResNo();
        Vector<Noesy> vecNoesyTwo = new Vector<Noesy>();
        vecNoesyTwo.addAll(vecNoesy);
        vecOneSCAsg.add(new H1CS(resNo, res, atom, cs_proton));
        vecOneSCAsg.add(new H1CS(resNo, res, heavName, cs_heavy));
        int t = 0;
        while (t < vecAdj.size()) {
            GraphNode nodeAdj = vecAdj.elementAt(t);
            if (nodeAdj.getIsAssigned() && nodeAdj.asgedId >= 0 || nodeAdj.asgedIdTemp >= 0) {
                ProtonLabel nodeAdjLabel = new ProtonLabel();
                if (nodeAdj.getIsAssigned() && nodeAdj.asgedId >= 0) {
                    nodeAdjLabel = vecLabels.elementAt(nodeAdj.asgedId);
                } else if (nodeAdj.asgedIdTemp >= 0) {
                    nodeAdjLabel = vecLabels.elementAt(nodeAdj.asgedIdTemp);
                }
                vecNoesyTwo.addAll(nodeAdj.vecAdjNOESY);
                int resNoSec = nodeAdjLabel.getResNo();
                String resSec = nodeAdjLabel.getResName();
                String atomSec = nodeAdjLabel.getAtomName();
                String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                double cs_protonSec = nodeAdj.getCSProton();
                double cs_heavySec = nodeAdj.getCSHeavy();
                vecOneSCAsg.add(new H1CS(resNoSec, resSec, atomSec, cs_protonSec));
                vecOneSCAsg.add(new H1CS(resNoSec, resSec, heavyNameSec, cs_heavySec));
                double distUp = 6.0;
                if (nasca.isInCloseAdj(nodeAdjLabel, cur_label)) {
                    distUp = 2.7;
                }
                vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, distUp, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, distUp, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
            }
            ++t;
        }
        Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
        int[] numPeaks = new int[1];
        double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
        Vector<H1CS> vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg);
        double asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew, vecBMRBNew);
        double score = (dbScore *= (double)vecBackNoeNew.size()) + asgScore;
        double preScore = 0.0;
        if (pTreeNode != null) {
            preScore = pTreeNode.gScore;
        }
        return score + preScore;
    }
}

