/*
 * Decompiled with CFR 0.152.
 */
package NascaGUI;

import Jampack.JampackException;
import NascaGUI.AboutFrame;
import NascaGUI.ExtFilter;
import NascaGUI.Global;
import NascaGUI.ParametersJFrame;
import NascaGUI.RunNascaForGUI;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import rdcPanda.Assign;
import rdcPanda.H1CS;
import rdcPanda.Noe;

public class NascaFrame
extends JFrame {
    private RunNascaForGUI runNasca;
    private JButton jButtonAliNoesyOpen;
    private JButton jButtonAroNoesyOpen;
    private JButton jButtonBBCSOpen;
    private JButton jButtonBBPdbOpen;
    private JButton jButtonClear;
    private JButton jButtonN15NoesyOpen;
    private JButton jButtonReadSession;
    private JButton jButtonRunNasca;
    private JButton jButtonSCResonanceAsg;
    private JButton jButtonSaveNoeAsg;
    private JButton jButtonSaveSession;
    private JButton jButtonStopNasca;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JMenuBar jMenuBar1;
    private JMenu jMenuFile;
    private JMenu jMenuHelp;
    private JMenuItem jMenuIManual;
    private JMenuItem jMenuIQuit;
    private JMenuItem jMenuItemSystemParameters;
    private JMenu jMenuOptions;
    private JMenuItem jMenuReadSession;
    private JMenu jMenuRun;
    private JMenuItem jMenuRunNasca;
    private JMenuItem jMenuSaveNoeAsg;
    private JMenuItem jMenuSaveResonanceAsg;
    private JMenuItem jMenuSaveSession;
    private JMenuItem jMenuStopNasca;
    private JMenuItem jMenulAbout;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaOutput;
    private JTextField jTextFieldAliNoesy;
    private JTextField jTextFieldAroNoesy;
    private JTextField jTextFieldBBCS;
    private JTextField jTextFieldBBPdb;
    private JTextField jTextFieldN15Noesy;

    public NascaFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldBBPdb = new JTextField();
        this.jButtonBBCSOpen = new JButton();
        this.jLabel2 = new JLabel();
        this.jTextFieldBBCS = new JTextField();
        this.jButtonBBPdbOpen = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextFieldAliNoesy = new JTextField();
        this.jButtonAliNoesyOpen = new JButton();
        this.jLabel4 = new JLabel();
        this.jTextFieldAroNoesy = new JTextField();
        this.jButtonAroNoesyOpen = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextFieldN15Noesy = new JTextField();
        this.jButtonN15NoesyOpen = new JButton();
        this.jButtonReadSession = new JButton();
        this.jButtonSaveSession = new JButton();
        this.jButtonClear = new JButton();
        this.jButtonRunNasca = new JButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaOutput = new JTextArea();
        this.jButtonSCResonanceAsg = new JButton();
        this.jButtonSaveNoeAsg = new JButton();
        this.jButtonStopNasca = new JButton();
        this.jLabel6 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuReadSession = new JMenuItem();
        this.jMenuSaveSession = new JMenuItem();
        this.jMenuSaveResonanceAsg = new JMenuItem();
        this.jMenuSaveNoeAsg = new JMenuItem();
        this.jMenuIQuit = new JMenuItem();
        this.jMenuRun = new JMenu();
        this.jMenuRunNasca = new JMenuItem();
        this.jMenuStopNasca = new JMenuItem();
        this.jMenuOptions = new JMenu();
        this.jMenuItemSystemParameters = new JMenuItem();
        this.jMenuHelp = new JMenu();
        this.jMenuIManual = new JMenuItem();
        this.jMenulAbout = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("NASCA - NOE Assignment and Side-Chain Assignment (from NOESY Data)");
        this.setName("jMainFrame");
        this.jPanel1.setBackground(new Color(135, 206, 235));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Input Files", 2, 0, new Font("Tahoma", 1, 11)));
        this.jPanel1.setForeground(new Color(153, 255, 204));
        this.jPanel1.setToolTipText("Input Files");
        this.jPanel1.setCursor(new Cursor(0));
        this.jPanel1.setDebugGraphicsOptions(-1);
        this.jLabel1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel1.setText("Backbone Coordinates (*.pdb):");
        this.jLabel1.setToolTipText("Backbone coordinate file");
        this.jTextFieldBBPdb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jTextFieldBBPdbActionPerformed(evt);
            }
        });
        this.jButtonBBCSOpen.setFont(new Font("Tahoma", 1, 11));
        this.jButtonBBCSOpen.setText("Browse...");
        this.jButtonBBCSOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jButtonBBCSOpenActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("Backbone Chemical Shifts (*.prot,*.txt):");
        this.jLabel2.setToolTipText("Backbone coordinate file");
        this.jTextFieldBBCS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jTextFieldBBCSActionPerformed(evt);
            }
        });
        this.jButtonBBPdbOpen.setFont(new Font("Tahoma", 1, 11));
        this.jButtonBBPdbOpen.setText("Browse...");
        this.jButtonBBPdbOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jButtonBBPdbOpenActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(new Font("Tahoma", 1, 11));
        this.jLabel3.setText("C13 Aliphatic NOESY Cross Peaks (*.peaks,*.xpk):");
        this.jLabel3.setToolTipText("Backbone coordinate file");
        this.jTextFieldAliNoesy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jTextFieldAliNoesyActionPerformed(evt);
            }
        });
        this.jButtonAliNoesyOpen.setFont(new Font("Tahoma", 1, 11));
        this.jButtonAliNoesyOpen.setText("Browse...");
        this.jButtonAliNoesyOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jButtonAliNoesyOpenActionPerformed(evt);
            }
        });
        this.jLabel4.setFont(new Font("Tahoma", 1, 11));
        this.jLabel4.setText("C13 Aromatic NOESY Cross Peaks (*.peaks,*.xpk):");
        this.jLabel4.setToolTipText("Backbone coordinate file");
        this.jTextFieldAroNoesy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jTextFieldAroNoesyActionPerformed(evt);
            }
        });
        this.jButtonAroNoesyOpen.setFont(new Font("Tahoma", 1, 11));
        this.jButtonAroNoesyOpen.setText("Browse...");
        this.jButtonAroNoesyOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jButtonAroNoesyOpenActionPerformed(evt);
            }
        });
        this.jLabel5.setFont(new Font("Tahoma", 1, 11));
        this.jLabel5.setText("N15 NOESY Cross Peaks (*.peaks,*.xpk):");
        this.jLabel5.setToolTipText("Backbone coordinate file");
        this.jTextFieldN15Noesy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jTextFieldN15NoesyActionPerformed(evt);
            }
        });
        this.jButtonN15NoesyOpen.setFont(new Font("Tahoma", 1, 11));
        this.jButtonN15NoesyOpen.setText("Browse...");
        this.jButtonN15NoesyOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jButtonN15NoesyOpenActionPerformed(evt);
            }
        });
        this.jButtonReadSession.setFont(new Font("Tahoma", 1, 11));
        this.jButtonReadSession.setText("Read Session from...");
        this.jButtonReadSession.setToolTipText("Read a session file");
        this.jButtonReadSession.setActionCommand("");
        this.jButtonReadSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jButtonReadSessionActionPerformed(evt);
            }
        });
        this.jButtonSaveSession.setFont(new Font("Tahoma", 1, 11));
        this.jButtonSaveSession.setText("Save Session as...");
        this.jButtonSaveSession.setToolTipText("Save the current session into a file");
        this.jButtonSaveSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jButtonSaveSessionActionPerformed(evt);
            }
        });
        this.jButtonClear.setFont(new Font("Tahoma", 1, 11));
        this.jButtonClear.setText("Clear");
        this.jButtonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jButtonClearActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldBBPdb, -1, 382, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBBPdbOpen)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldN15Noesy, -1, 382, Short.MAX_VALUE).addComponent(this.jTextFieldAroNoesy, -1, 382, Short.MAX_VALUE).addComponent(this.jTextFieldAliNoesy, GroupLayout.Alignment.TRAILING, -1, 382, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButtonN15NoesyOpen).addComponent(this.jButtonAroNoesyOpen).addComponent(this.jButtonAliNoesyOpen))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jTextFieldBBCS, -1, 382, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonBBCSOpen)))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButtonClear, -2, 146, -2).addGap(56, 56, 56).addComponent(this.jButtonReadSession).addGap(53, 53, 53).addComponent(this.jButtonSaveSession).addGap(120, 120, 120))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonBBPdbOpen).addComponent(this.jTextFieldBBPdb, -2, 22, -2).addComponent(this.jLabel1)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonBBCSOpen).addComponent(this.jTextFieldBBCS, -2, 22, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAliNoesy, -2, 22, -2).addComponent(this.jButtonAliNoesyOpen).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldAroNoesy, -2, 22, -2).addComponent(this.jButtonAroNoesyOpen).addComponent(this.jLabel4)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldN15Noesy, -2, 23, -2).addComponent(this.jButtonN15NoesyOpen).addComponent(this.jLabel5)).addGap(18, 18, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonClear).addComponent(this.jButtonReadSession).addComponent(this.jButtonSaveSession)).addContainerGap()));
        this.jButtonRunNasca.setFont(new Font("Tahoma", 1, 11));
        this.jButtonRunNasca.setIcon(new ImageIcon(this.getClass().getResource("/NascaGUI/image/129.gif")));
        this.jButtonRunNasca.setText("Run NASCA");
        this.jButtonRunNasca.setToolTipText("Run NASCA");
        this.jButtonRunNasca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    NascaFrame.this.jButtonRunNascaActionPerformed(evt);
                }
                catch (JampackException e) {
                    e.printStackTrace();
                }
            }
        });
        this.jPanel2.setBackground(new Color(135, 206, 235));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Output Texts", 2, 0, new Font("Tahoma", 1, 11)));
        this.jPanel2.setToolTipText("Output texts");
        this.jTextAreaOutput.setLineWrap(true);
        this.jTextAreaOutput.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaOutput);
        this.jButtonSCResonanceAsg.setFont(new Font("Tahoma", 1, 11));
        this.jButtonSCResonanceAsg.setText("Save Resonance Assignments");
        this.jButtonSCResonanceAsg.setToolTipText("Save Side-Chain Resonance Assginments into a file");
        this.jButtonSCResonanceAsg.setEnabled(false);
        this.jButtonSCResonanceAsg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jButtonSCResonanceAsgActionPerformed(evt);
            }
        });
        this.jButtonSaveNoeAsg.setFont(new Font("Tahoma", 1, 11));
        this.jButtonSaveNoeAsg.setText("Save NOE Assignments");
        this.jButtonSaveNoeAsg.setToolTipText("Save NOE Assignments into a file");
        this.jButtonSaveNoeAsg.setEnabled(false);
        this.jButtonSaveNoeAsg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jButtonSaveNoeAsgActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap(170, Short.MAX_VALUE).addComponent(this.jButtonSCResonanceAsg).addGap(50, 50, 50).addComponent(this.jButtonSaveNoeAsg, -2, 200, -2).addGap(159, 159, 159)).addComponent(this.jScrollPane1));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 137, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSaveNoeAsg).addComponent(this.jButtonSCResonanceAsg)).addContainerGap()));
        this.jButtonStopNasca.setFont(new Font("Tahoma", 1, 11));
        this.jButtonStopNasca.setIcon(new ImageIcon(this.getClass().getResource("/NascaGUI/image/176.gif")));
        this.jButtonStopNasca.setText("Stop NASCA");
        this.jButtonStopNasca.setToolTipText("Stop NASCA");
        this.jButtonStopNasca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jButtonStopNascaActionPerformed(evt);
            }
        });
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/NascaGUI/image/NASCA-smaller.jpg")));
        this.jMenuFile.setText("File");
        this.jMenuReadSession.setText("Read Session from...");
        this.jMenuReadSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jMenuReadSessionActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuReadSession);
        this.jMenuSaveSession.setText("Save Session as...");
        this.jMenuSaveSession.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jMenuSaveSessionActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveSession);
        this.jMenuSaveResonanceAsg.setText("Save Resonance Assignments");
        this.jMenuSaveResonanceAsg.setEnabled(false);
        this.jMenuSaveResonanceAsg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jMenuSaveResonanceAsgActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveResonanceAsg);
        this.jMenuSaveNoeAsg.setText("Save NOE Assignments");
        this.jMenuSaveNoeAsg.setEnabled(false);
        this.jMenuSaveNoeAsg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jMenuSaveNoeAsgActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuSaveNoeAsg);
        this.jMenuIQuit.setText("Quit");
        this.jMenuIQuit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jMenuIQuitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuIQuit);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuRun.setText("Run");
        this.jMenuRunNasca.setText("Run NASCA");
        this.jMenuRunNasca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jMenuRunNascaActionPerformed(evt);
            }
        });
        this.jMenuRun.add(this.jMenuRunNasca);
        this.jMenuStopNasca.setText("Stop NASCA");
        this.jMenuStopNasca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jMenuStopNascaActionPerformed(evt);
            }
        });
        this.jMenuRun.add(this.jMenuStopNasca);
        this.jMenuBar1.add(this.jMenuRun);
        this.jMenuOptions.setText("Options");
        this.jMenuItemSystemParameters.setText("Parameters");
        this.jMenuItemSystemParameters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jMenuItemSystemParametersActionPerformed(evt);
            }
        });
        this.jMenuOptions.add(this.jMenuItemSystemParameters);
        this.jMenuBar1.add(this.jMenuOptions);
        this.jMenuHelp.setText("Help");
        this.jMenuIManual.setText("User Manual");
        this.jMenuIManual.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jMenuIManualActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenuIManual);
        this.jMenulAbout.setText("About NASCA");
        this.jMenulAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NascaFrame.this.jMenulAboutActionPerformed(evt);
            }
        });
        this.jMenuHelp.add(this.jMenulAbout);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.jButtonRunNasca, -2, 152, -2).addComponent(this.jButtonStopNasca, -2, 152, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addGap(40, 40, 40).addComponent(this.jButtonRunNasca, -2, 46, -2).addGap(33, 33, 33).addComponent(this.jButtonStopNasca, -2, 44, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }

    private void jTextFieldBBPdbActionPerformed(ActionEvent evt) {
        Global.strBBPdbFile = this.jTextFieldBBPdb.getText();
    }

    private void jButtonBBCSOpenActionPerformed(ActionEvent evt) {
        String curDir = Global.getInputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser bbCSChooser = new JFileChooser(curDir);
        bbCSChooser.setMultiSelectionEnabled(false);
        bbCSChooser.setFileSelectionMode(0);
        bbCSChooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"prot", "txt"};
        bbCSChooser.addChoosableFileFilter(new ExtFilter(html, "Backbone chemical shift file (*.prot,*.txt)"));
        int option = bbCSChooser.showOpenDialog(this);
        if (option == 0) {
            sourceFile = bbCSChooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jTextFieldBBCS.setText(bbCSChooser.getCurrentDirectory() + File.separator + sourceFile.getName());
            Global.strBBCSFile = bbCSChooser.getCurrentDirectory() + File.separator + sourceFile.getName();
        }
    }

    private void jTextFieldBBCSActionPerformed(ActionEvent evt) {
    }

    private void jButtonBBPdbOpenActionPerformed(ActionEvent evt) {
        String curDir = Global.getInputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser bbPdbChooser = new JFileChooser(curDir);
        bbPdbChooser.setMultiSelectionEnabled(false);
        bbPdbChooser.setFileSelectionMode(0);
        bbPdbChooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"PDB", "pdb"};
        bbPdbChooser.addChoosableFileFilter(new ExtFilter(html, "PDB file (*.pdb)"));
        int option = bbPdbChooser.showOpenDialog(this);
        if (option == 0) {
            sourceFile = bbPdbChooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jTextFieldBBPdb.setText(bbPdbChooser.getCurrentDirectory() + File.separator + sourceFile.getName());
            Global.strBBPdbFile = bbPdbChooser.getCurrentDirectory() + File.separator + sourceFile.getName();
        }
    }

    private void jTextAreaOutputPropertyChange(PropertyChangeEvent evt) {
        this.jTextAreaOutput.selectAll();
        this.jTextAreaOutput.setCaretPosition(this.jTextAreaOutput.getDocument().getLength());
    }

    private void jTextFieldAliNoesyActionPerformed(ActionEvent evt) {
    }

    private void jButtonAliNoesyOpenActionPerformed(ActionEvent evt) {
        String curDir = Global.getInputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"peaks", "xpk"};
        chooser.addChoosableFileFilter(new ExtFilter(html, "NOESY cross peaks (*.peaks,*.xpk)"));
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jTextFieldAliNoesy.setText(chooser.getCurrentDirectory() + File.separator + sourceFile.getName());
            Global.strAliNoesyFile = chooser.getCurrentDirectory() + File.separator + sourceFile.getName();
        }
    }

    private void jTextFieldAroNoesyActionPerformed(ActionEvent evt) {
    }

    private void jButtonAroNoesyOpenActionPerformed(ActionEvent evt) {
        String curDir = Global.getInputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"peaks", "xpk"};
        chooser.addChoosableFileFilter(new ExtFilter(html, "NOESY cross peaks (*.peaks,*.xpk)"));
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jTextFieldAroNoesy.setText(chooser.getCurrentDirectory() + File.separator + sourceFile.getName());
            Global.strAroNoesyFile = chooser.getCurrentDirectory() + File.separator + sourceFile.getName();
        }
    }

    private void jTextFieldN15NoesyActionPerformed(ActionEvent evt) {
    }

    private void jButtonN15NoesyOpenActionPerformed(ActionEvent evt) {
        String curDir = Global.getInputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"peaks", "xpk"};
        chooser.addChoosableFileFilter(new ExtFilter(html, "NOESY cross peaks (*.peaks,*.xpk)"));
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jTextFieldN15Noesy.setText(chooser.getCurrentDirectory() + File.separator + sourceFile.getName());
            Global.strN15NoesyFile = chooser.getCurrentDirectory() + File.separator + sourceFile.getName();
        }
    }

    private void jButtonReadSessionActionPerformed(ActionEvent evt) {
        String curDir = Global.getInputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"input"};
        chooser.addChoosableFileFilter(new ExtFilter(html, "NOESY cross peaks (*.input)"));
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.readInputSessionFile(chooser.getCurrentDirectory() + File.separator + sourceFile.getName());
            this.jTextFieldBBPdb.setText(Global.strBBPdbFile);
            this.jTextFieldBBCS.setText(Global.strBBCSFile);
            this.jTextFieldAliNoesy.setText(Global.strAliNoesyFile);
            this.jTextFieldAroNoesy.setText(Global.strAroNoesyFile);
            this.jTextFieldN15Noesy.setText(Global.strN15NoesyFile);
        }
    }

    private void readInputSessionFile(String fileName) {
        Assign asg = new Assign();
        Vector<Map<String, String>> paraVec = asg.ParamReader(fileName);
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("BACKBONE")) {
                Global.strBBPdbFile = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("RESONANCE")) {
                Global.strBBCSFile = paraMap.get("RESONANCE");
            }
            if (paraMap.containsKey("3D-C13-NOESY")) {
                Global.strAliNoesyFile = paraMap.get("3D-C13-NOESY");
            }
            if (paraMap.containsKey("3D-C13-NOESY-ARO")) {
                Global.strAroNoesyFile = paraMap.get("3D-C13-NOESY-ARO");
            }
            if (paraMap.containsKey("3D-N15-NOESY")) {
                Global.strN15NoesyFile = paraMap.get("3D-N15-NOESY");
            }
            ++i;
        }
    }

    private void jButtonRunNascaActionPerformed(ActionEvent evt) throws JampackException {
        this.jTextAreaOutput.setText("");
        this.jButtonSCResonanceAsg.setEnabled(false);
        this.jButtonSaveNoeAsg.setEnabled(false);
        this.jMenuSaveResonanceAsg.setEnabled(false);
        this.jMenuSaveNoeAsg.setEnabled(false);
        this.jButtonRunNasca.setEnabled(false);
        this.runNasca = new RunNascaForGUI(this.jTextAreaOutput, this.jButtonSCResonanceAsg, this.jButtonSaveNoeAsg, this.jMenuSaveResonanceAsg, this.jMenuSaveNoeAsg, this.jButtonRunNasca, this.jButtonStopNasca);
        this.runNasca.execute();
    }

    private void jButtonSCResonanceAsgActionPerformed(ActionEvent evt) {
        String curDir = Global.getOutputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"prot"};
        chooser.addChoosableFileFilter(new ExtFilter(html, "Side-chain resonance assignments (*.prot)"));
        int option = chooser.showSaveDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            H1CS h1cs = new H1CS();
            String fileName = chooser.getCurrentDirectory() + File.separator + sourceFile.getName();
            h1cs.PrintAllAssignmentToFileBMRB(Global.finalAssignments.getResonAsgs(), fileName);
        }
    }

    private void jButtonStopNascaActionPerformed(ActionEvent evt) {
        if (this.runNasca != null) {
            this.runNasca.cancel(true);
            this.jButtonRunNasca.setEnabled(true);
        }
    }

    private void jMenuReadSessionActionPerformed(ActionEvent evt) {
        String curDir = Global.getInputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"input"};
        chooser.addChoosableFileFilter(new ExtFilter(html, "NOESY cross peaks (*.input)"));
        int option = chooser.showOpenDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.readInputSessionFile(chooser.getCurrentDirectory() + File.separator + sourceFile.getName());
            this.jTextFieldBBPdb.setText(Global.strBBPdbFile);
            this.jTextFieldBBCS.setText(Global.strBBCSFile);
            this.jTextFieldAliNoesy.setText(Global.strAliNoesyFile);
            this.jTextFieldAroNoesy.setText(Global.strAroNoesyFile);
            this.jTextFieldN15Noesy.setText(Global.strN15NoesyFile);
        }
    }

    private void jButtonSaveSessionActionPerformed(ActionEvent evt) {
        String curDir = Global.getOutputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"input"};
        chooser.addChoosableFileFilter(new ExtFilter(html, "Input session file (*.input)"));
        int option = chooser.showSaveDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String strOutputSessionFile = chooser.getCurrentDirectory() + File.separator + sourceFile.getName();
            this.writeInputSessionToFile(strOutputSessionFile);
        }
    }

    private void writeInputSessionToFile(String strOutputSessionFile) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(strOutputSessionFile)));
            out.println("// File name of backbone PDB coordinates:");
            out.println("backbone = " + Global.strBBPdbFile + ";");
            out.println();
            out.println();
            out.println("// File name of backbone chemical shifts:");
            out.println("resonance = " + Global.strBBCSFile + ";");
            out.println();
            out.println();
            out.println("// File name of C-13 aliphatic NOESY cross peaks:");
            out.println("3D-C13-NOESY = " + Global.strAliNoesyFile + ";");
            out.println();
            out.println();
            out.println("// File name of C-13 aromatic NOESY cross peaks:");
            out.println("3D-C13-NOESY-ARO = " + Global.strAroNoesyFile + ";");
            out.println();
            out.println();
            out.println("// File name of N-15 NOESY cross peaks:");
            out.println("3D-N15-NOESY = " + Global.strN15NoesyFile + ";");
            out.println();
            out.println();
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + strOutputSessionFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
    }

    private void jButtonSaveNoeAsgActionPerformed(ActionEvent evt) {
        String curDir = Global.getOutputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"tbl"};
        chooser.addChoosableFileFilter(new ExtFilter(html, "NOE assignments(*.tbl)"));
        int option = chooser.showSaveDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Noe noe = new Noe();
            String fileName = chooser.getCurrentDirectory() + File.separator + sourceFile.getName();
            noe.printNoesToFileInXplor(Global.finalAssignments.getNoeAsgs(), fileName);
        }
    }

    private void jButtonClearActionPerformed(ActionEvent evt) {
        this.jTextFieldBBPdb.setText("");
        this.jTextFieldBBCS.setText("");
        this.jTextFieldAliNoesy.setText("");
        this.jTextFieldAroNoesy.setText("");
        this.jTextFieldN15Noesy.setText("");
    }

    private void jMenuSaveSessionActionPerformed(ActionEvent evt) {
        String curDir = Global.getOutputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"input"};
        chooser.addChoosableFileFilter(new ExtFilter(html, "Input session file (*.input)"));
        int option = chooser.showSaveDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String strOutputSessionFile = chooser.getCurrentDirectory() + File.separator + sourceFile.getName();
            this.writeInputSessionToFile(strOutputSessionFile);
        }
    }

    private void jMenuSaveResonanceAsgActionPerformed(ActionEvent evt) {
        String curDir = Global.getOutputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"prot"};
        chooser.addChoosableFileFilter(new ExtFilter(html, "Side-chain resonance assignments (*.prot)"));
        int option = chooser.showSaveDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            H1CS h1cs = new H1CS();
            String fileName = chooser.getCurrentDirectory() + File.separator + sourceFile.getName();
            h1cs.PrintAllAssignmentToFileBMRB(Global.finalAssignments.getResonAsgs(), fileName);
        }
    }

    private void jMenuSaveNoeAsgActionPerformed(ActionEvent evt) {
        String curDir = Global.getOutputFilePath();
        String sourceName = "";
        File sourceFile = new File(sourceName);
        JFileChooser chooser = new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setSelectedFile(sourceFile);
        String[] html = new String[]{"tbl"};
        chooser.addChoosableFileFilter(new ExtFilter(html, "NOE assignments(*.tbl)"));
        int option = chooser.showSaveDialog(this);
        if (option == 0) {
            sourceFile = chooser.getSelectedFile();
            try {
                sourceName = sourceFile.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Noe noe = new Noe();
            String fileName = chooser.getCurrentDirectory() + File.separator + sourceFile.getName();
            noe.printNoesToFileInXplor(Global.finalAssignments.getNoeAsgs(), fileName);
        }
    }

    private void jMenuIQuitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void jMenuRunNascaActionPerformed(ActionEvent evt) {
        this.jTextAreaOutput.setText("");
        this.jButtonRunNasca.setEnabled(false);
        this.runNasca = new RunNascaForGUI(this.jTextAreaOutput, this.jButtonSCResonanceAsg, this.jButtonSaveNoeAsg, this.jMenuSaveResonanceAsg, this.jMenuSaveNoeAsg, this.jButtonRunNasca, this.jButtonStopNasca);
        this.runNasca.execute();
    }

    private void jMenuStopNascaActionPerformed(ActionEvent evt) {
        if (this.runNasca != null && !this.runNasca.isDone()) {
            this.runNasca.cancel(true);
            this.jButtonRunNasca.setEnabled(true);
        }
    }

    private void jMenuItemSystemParametersActionPerformed(ActionEvent evt) {
        ParametersJFrame paraFrame = new ParametersJFrame();
        paraFrame.setName("Parameter Setting");
        paraFrame.setTitle("Parameter Setting");
        paraFrame.setLocationRelativeTo(null);
        paraFrame.setDefaultCloseOperation(2);
        paraFrame.setVisible(true);
    }

    private void jMenuIManualActionPerformed(ActionEvent evt) {
        Desktop desktop;
        String url = "http://www.cs.duke.edu/donaldlab/nasca.php";
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(url));
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else {
                Map<String, String> env = System.getenv();
                if (env.get("BROWSER") != null) {
                    Runtime.getRuntime().exec(String.valueOf(env.get("BROWSER")) + " " + url);
                    return;
                }
                String[] browsers = new String[]{"firefox", "iceweasel", "chrome", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                int count = 0;
                while (count < browsers.length && browser == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                        browser = browsers[count];
                        break;
                    }
                    ++count;
                }
                if (browser == null) {
                    throw new RuntimeException("couldn't find any browser...");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "couldn't find a webbrowser to use...\nPlease browser for yourself:\n" + url);
        }
    }

    private void jMenulAboutActionPerformed(ActionEvent evt) {
        AboutFrame aboutFrame = new AboutFrame();
        aboutFrame.setLocationRelativeTo(null);
        aboutFrame.setDefaultCloseOperation(2);
        aboutFrame.setVisible(true);
    }

    private void jTextFieldBBPdbPropertyChange(PropertyChangeEvent evt) {
        this.jTextFieldBBPdb.setText(this.jTextFieldBBPdb.getText());
        Global.strBBPdbFile = this.jTextFieldBBPdb.getText();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new NascaFrame().setVisible(true);
            }
        });
    }
}

