/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.Cartesian;
import rdcPanda.Const;
import rdcPanda.Dipolar;
import rdcPanda.H1CS;
import rdcPanda.Hdist;
import rdcPanda.Hsqc;
import rdcPanda.Matrix;
import rdcPanda.ModelRdc;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.PdbRdc;
import rdcPanda.Peak;
import rdcPanda.PhiPsi;
import rdcPanda.RotaPattern;
import rdcPanda.ppGlobal;
import rdcPanda.vdw;

public class Loops {
    public Vector vecRamaAla = new Vector();
    public Vector vecRamaGeneral = new Vector();
    public Vector vecRamaPrePro = new Vector();
    public Vector vecRamaPro = new Vector();
    public Vector vecRamaGly = new Vector();
    public Random generator = new Random();
    public Vector vecSeq = new Vector();
    public Vector vecPdbSSE = new Vector();
    public double caliConstant = 0.0;

    public void doCalLoops(String src, String strOut, String strInput) throws JampackException {
        double cs_h2;
        double cs_h1;
        Noesy noesy2;
        boolean isDebug = true;
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        String userDir = System.getProperty("user.dir");
        String rotSrc = String.valueOf(userDir) + "/system/rot-lib/";
        String userDirTemp = System.getProperty("user.dir");
        String strRamaAla = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-ala-nosec.data";
        String strRamaGeneral = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-general-nosec.data";
        String strRamaGly = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-gly-sym-nosec.data";
        String strRamaPro = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-pro.data";
        String strRamaPrePro = String.valueOf(userDirTemp) + "/system/rama_data/pct/rama/rama500-prepro.data";
        this.vecRamaAla = this.ReadRamachandranFile(strRamaAla);
        this.vecRamaGeneral = this.ReadRamachandranFile(strRamaGeneral);
        this.vecRamaGly = this.ReadRamachandranFile(strRamaGly);
        this.vecRamaPro = this.ReadRamachandranFile(strRamaPro);
        this.vecRamaPrePro = this.ReadRamachandranFile(strRamaPrePro);
        Pdb pp = new Pdb();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        int nIs4DNoesy = 0;
        String strResNameScheme = "";
        String strIsCheckLongAA = "";
        String strBB = "";
        String stroutName = "";
        String strOutOrFormat = "";
        String strSSEBB = "";
        String strIsCheck = "";
        String strRefPdb = "";
        String strRefNameSchem = "";
        String strIsWholeStr = "";
        String strPdbNameScheme = "";
        int nIsoriginalUp = 0;
        double Syy = 0.0;
        double Szz = 0.0;
        double noeLimit = 0.0;
        double metCor = 0.0;
        String strReson = "";
        String strResFormat = "";
        String strSeq = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strHaNoesy3D = "";
        String str4DNoesy = "";
        String strNoesyFormat = "";
        String strSSEPDBFile = "";
        String strChFile = "";
        String strNhFile = "";
        String strOutPdb = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("RESFORMAT")) {
                strResFormat = paraMap.get("RESFORMAT");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            if (paraMap.containsKey("PDBNAMESCHEME")) {
                strPdbNameScheme = paraMap.get("PDBNAMESCHEME");
            }
            if (paraMap.containsKey("OUTNOENAME")) {
                stroutName = paraMap.get("OUTNOENAME");
            }
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("SSEBB")) {
                strSSEBB = paraMap.get("SSEBB");
            }
            if (paraMap.containsKey("NOELIMIT")) {
                noeLimit = Double.parseDouble(paraMap.get("NOELIMIT"));
            }
            if (paraMap.containsKey("IS4DNOESY")) {
                nIs4DNoesy = Integer.parseInt(paraMap.get("IS4DNOESY"));
            }
            if (paraMap.containsKey("4D-NOESY")) {
                str4DNoesy = paraMap.get("4D-NOESY");
            }
            if (paraMap.containsKey("ISORIGINALUP")) {
                nIsoriginalUp = Integer.parseInt(paraMap.get("ISORIGINALUP"));
            }
            if (paraMap.containsKey("RESNAMESCHEME")) {
                strResNameScheme = paraMap.get("RESNAMESCHEME");
            }
            if (paraMap.containsKey("NOESY-FORMAT")) {
                strNoesyFormat = paraMap.get("NOESY-FORMAT");
            }
            if (paraMap.containsKey("ISCHECKLONGAA")) {
                strIsCheckLongAA = paraMap.get("ISCHECKLONGAA");
            }
            if (paraMap.containsKey("ISCHECK")) {
                strIsCheck = paraMap.get("ISCHECK");
            }
            if (paraMap.containsKey("REFPDB")) {
                strRefPdb = paraMap.get("REFPDB");
            }
            if (paraMap.containsKey("METHYL-CORRECTION")) {
                metCor = Double.parseDouble(paraMap.get("METHYL-CORRECTION"));
            }
            if (paraMap.containsKey("REFNAMESCHEME")) {
                strRefNameSchem = paraMap.get("REFNAMESCHEME");
            }
            if (paraMap.containsKey("ISWHOLESTRUCTURE")) {
                strIsWholeStr = paraMap.get("ISWHOLESTRUCTURE");
            }
            if (paraMap.containsKey("ISOUTORFORMAT")) {
                strOutOrFormat = paraMap.get("ISOUTORFORMAT");
            }
            if (paraMap.containsKey("SSES")) {
                strSSEPDBFile = paraMap.get("SSES");
            }
            if (paraMap.containsKey("SYY")) {
                Syy = Double.parseDouble(paraMap.get("SYY"));
            }
            if (paraMap.containsKey("SZZ")) {
                Szz = Double.parseDouble(paraMap.get("SZZ"));
            }
            if (paraMap.containsKey("CHFILE")) {
                strChFile = paraMap.get("CHFILE");
            }
            if (paraMap.containsKey("NHFILE")) {
                strNhFile = paraMap.get("NHFILE");
            }
            if (paraMap.containsKey("OUTPDBNAME")) {
                strOutPdb = paraMap.get("OUTPDBNAME");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        this.vecSeq = asg.ReaderSeq(seqFile);
        String ssePdbFile = String.valueOf(userDirTemp) + strSSEPDBFile;
        Vector<Pdb> vecPdbSSETemp = pp.readPdb(ssePdbFile);
        Vector<Pdb> vecSSETemp2 = pp.residueNameUpdateNoStr(this.vecSeq, vecPdbSSETemp);
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<H1CS> assignVec = new Vector();
        if (strResFormat.equalsIgnoreCase("CYANA")) {
            assignVec = h1CS.h1CSReader(assignFile, this.vecSeq);
        } else if (strResFormat.equalsIgnoreCase("BMRB")) {
            assignVec = h1CS.h1CSReader_BMRB(assignFile);
        } else {
            System.out.println("unknown format of the resonance file...");
            System.exit(0);
        }
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Noesy> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        Vector<Object> Noe4DVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!str4DNoesy.equalsIgnoreCase("NULL") && !str4DNoesy.equalsIgnoreCase("")) {
            strNoeFile = String.valueOf(src) + str4DNoesy;
            Noe4DVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView4D(strNoeFile);
        }
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector vecNoesy4D = new Vector();
        vecNoesy4D.addAll(Noe4DVec);
        String pdbSSEFile = String.valueOf(userDirTemp) + strSSEPDBFile;
        Vector<Pdb> vecSSE = pp.readPdb(pdbSSEFile);
        double[] constant = new double[1];
        noesy.SetCalibrationN15(hnNoeVec, vecSSE, assignVec, constant);
        this.caliConstant = constant[0];
        Vector<Noesy> vecNoesyNoDia = new Vector<Noesy>();
        i = 0;
        while (i < vecNoesy.size()) {
            noesy2 = (Noesy)vecNoesy.elementAt(i);
            cs_h1 = noesy2.getH1();
            if (Math.abs(cs_h1 - (cs_h2 = noesy2.getH2())) > 0.01) {
                vecNoesyNoDia.add(noesy2);
            }
            ++i;
        }
        vecNoesy = new Vector();
        vecNoesy.addAll(vecNoesyNoDia);
        vecNoesyNoDia = new Vector();
        i = 0;
        while (i < vecNoesy4D.size()) {
            noesy2 = (Noesy)vecNoesy4D.elementAt(i);
            cs_h1 = noesy2.getH1();
            cs_h2 = noesy2.getH2();
            double cs_heavy1 = noesy2.getHeavy1();
            double cs_heavy2 = noesy2.getHeavy2();
            if (Math.abs(cs_h1 - cs_h2) > 0.04 && Math.abs(cs_heavy1 - cs_heavy2) > 0.06) {
                vecNoesyNoDia.add(noesy2);
            }
            ++i;
        }
        vecNoesy4D = new Vector();
        vecNoesy4D.addAll(vecNoesyNoDia);
        Vector<Noesy> vecNewNoesy = new Vector<Noesy>();
        Vector vecNewNoesy4D = new Vector();
        vecNewNoesy.addAll(vecNoesy);
        vecNewNoesy4D.addAll(vecNoesy4D);
        String strChRdcFile = String.valueOf(src) + strChFile;
        String strNhRdcFile = String.valueOf(src) + strNhFile;
        Dipolar dd = new Dipolar();
        Vector vecNhRdc = dd.rdcRead(strNhRdcFile, 1.0);
        Vector vecChRdc = dd.rdcRead(strChRdcFile, 1.0);
        int noStart = 7;
        int noEnd = 12;
        double csErrH = 0.04;
        double csErrHeavy = 0.2;
        double[] rdc1Cal = new double[vecSSETemp2.size()];
        double[] rdc2Cal = new double[vecSSETemp2.size()];
        double[] saupe = new double[4];
        PdbRdc pdr = new PdbRdc();
        Matrix mm = pdr.bestFit(vecSSETemp2, vecNhRdc, vecChRdc, rdc1Cal, rdc2Cal, saupe);
        Vector<Pdb> vecSSE2 = pp.newPdb(vecSSETemp2, mm);
        Syy = saupe[0];
        Szz = saupe[1];
        Vector<Pdb> vecSSE2Rot = pp.RotamSelectAndStructure(csErrH, csErrHeavy, csErrHeavy, vecSSE2, assignVec, rotSrc, vecNoesy, 4.5, 1, this.caliConstant);
        this.vecPdbSSE = new Vector();
        this.vecPdbSSE.addAll(vecSSE2Rot);
        double[] coordN = new double[3];
        double[] coordNH = new double[3];
        double[] coordCA = new double[3];
        int ind = Collections.binarySearch(this.vecPdbSSE, new Pdb(noStart), new Pdb.PdbComparator());
        if (ind < 0) {
            System.out.println("the starting residue not found...exist.");
            System.exit(0);
        }
        Pdb pdbStart = (Pdb)this.vecPdbSSE.elementAt(ind);
        Vector<Cartesian> atomVecStart = pdbStart.getAtomVec();
        int k = 0;
        while (k < atomVecStart.size()) {
            Cartesian cc = atomVecStart.elementAt(k);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH = cc.getXYZ();
            }
            ++k;
        }
        boolean isSkipNOE = false;
        String ssePdbFileDebugging = String.valueOf(userDirTemp) + "/inputFiles/test.pdb";
        Vector<Pdb> vecPdbdebug = pp.readPdb(ssePdbFileDebugging);
        Vector vecFinal = this.IterativeGradientSearch(vecPdbdebug, Syy, Szz, vecChRdc, vecNhRdc, noStart, noEnd, vecNoesy, assignVec, csErrH, csErrHeavy, isSkipNOE);
        String fileName = String.valueOf(strOut) + strOutPdb;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            pp.printToFile(vecFinal, fileName, out);
            out.println("END");
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("The total time for computing loop fragments is:  " + totalTime + " minutes");
    }

    public Vector IterativeGradientSearch(Vector vecPrePdb, double Syy, double Szz, Vector<Dipolar> vecChRdc, Vector<Dipolar> vecNhRdc, int noStart, int noEnd, Vector vecNoesy, Vector asgVec, double csErrH, double csErrHeavy, boolean isSkipNOE) {
        Vector vecPrePdbTemp = new Vector();
        vecPrePdbTemp.addAll(vecPrePdb);
        double[] endDist = new double[1];
        int counter = 0;
        while (true) {
            System.out.println("interation= " + counter);
            int i = noStart;
            while (i <= noEnd) {
                Vector vecPdbTemp = this.ResidueGradientSearch(vecPrePdbTemp, i, Syy, Szz, vecChRdc, vecNhRdc, noStart, noEnd, vecNoesy, asgVec, csErrH, csErrHeavy, endDist, isSkipNOE);
                vecPrePdbTemp = new Vector();
                vecPrePdbTemp.addAll(vecPdbTemp);
                System.out.println("res No= " + i + "     ending dist= " + endDist[0]);
                if (endDist[0] < 0.8) break;
                ++i;
            }
            if (endDist[0] < 0.8) break;
            ++counter;
        }
        return vecPrePdbTemp;
    }

    public Vector ResidueGradientSearch(Vector vecPrePdb, int curResNo, double Syy, double Szz, Vector<Dipolar> vecChRdc, Vector<Dipolar> vecNhRdc, int noStart, int noEnd, Vector vecNoesy, Vector asgVec, double csErrH, double csErrHeavy, double[] endDist, boolean isSkipNOE) {
        double resolution = 5.0;
        Pdb pp = new Pdb();
        ModelRdc mdc = new ModelRdc();
        int nTotalRes = Math.abs(noEnd - noStart) + 1;
        double[] phiS = new double[nTotalRes];
        double[] psiS = new double[nTotalRes];
        double[] phiSave = new double[nTotalRes];
        double[] psiSave = new double[nTotalRes];
        String userDir = System.getProperty("user.dir");
        String rotSrc = String.valueOf(userDir) + "/system/rot-lib/";
        int indEndOrg = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator());
        Pdb pdbEndOrg = (Pdb)this.vecPdbSSE.elementAt(indEndOrg);
        Vector<Cartesian> atomVecEndOrg = pdbEndOrg.getAtomVec();
        double[] caEndOrg = new double[3];
        double[] nEndOrg = new double[3];
        double[] hnEndOrg = new double[3];
        int j = 0;
        while (j < atomVecEndOrg.size()) {
            Cartesian cc = atomVecEndOrg.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equals("CA")) {
                caEndOrg = cc.getXYZ();
            }
            if (atom.equalsIgnoreCase("N")) {
                nEndOrg = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                hnEndOrg = cc.getXYZ();
            }
            ++j;
        }
        double[] coordN = new double[3];
        double[] coordNH = new double[3];
        double[] coordCA = new double[3];
        int ind = Collections.binarySearch(vecPrePdb, new Pdb(curResNo), new Pdb.PdbComparator());
        if (ind < 0) {
            System.out.println("the current residue number not found...exist.");
            System.exit(0);
        }
        Pdb pdbCur = (Pdb)vecPrePdb.elementAt(ind);
        Vector<Cartesian> atomVecCur = pdbCur.getAtomVec();
        int k = 0;
        while (k < atomVecCur.size()) {
            Cartesian cc = atomVecCur.elementAt(k);
            String atom = cc.getAtom();
            if (atom.equalsIgnoreCase("N")) {
                coordN = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("CA")) {
                coordCA = cc.getXYZ();
            } else if (atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H")) {
                coordNH = cc.getXYZ();
            }
            ++k;
        }
        Vector<Pdb> vecPdbFragment = new Vector<Pdb>();
        Vector<Pdb> vecPdbSSE = new Vector<Pdb>();
        int i = 0;
        while (i < vecPrePdb.size()) {
            Pdb pdb = (Pdb)vecPrePdb.elementAt(i);
            if (pdb.getResidueNo() >= noStart && pdb.getResidueNo() <= noEnd) {
                vecPdbFragment.add(pdb);
            } else {
                vecPdbSSE.add(pdb);
            }
            ++i;
        }
        Vector<PhiPsi> vecPhiPsi = new Vector<PhiPsi>();
        Vector vecPhiPsiTemp = pp.PhiPsiTotalPdb(vecPdbFragment);
        int i2 = 0;
        while (i2 < vecPhiPsiTemp.size()) {
            PhiPsi phipsi = (PhiPsi)vecPhiPsiTemp.elementAt(i2);
            phiS[i2] = phipsi.getPhi();
            psiS[i2] = phipsi.getPsi();
            if (phipsi.getResidueNo() != curResNo) {
                vecPhiPsi.add(phipsi);
            }
            ++i2;
        }
        double wtNoeScore = 10.0;
        double wtRamaScore = 1.0;
        double wtDist = 5.0;
        double wtClash = 0.0;
        boolean isFound = false;
        boolean numClashes = false;
        double rT = 100000.0;
        double rTotal = 100000.0;
        int k2 = 0;
        while ((double)k2 < 360.0 / resolution) {
            double phiValue = (double)k2 * resolution * Math.PI / 180.0;
            System.out.println("k=" + k2 + " phiValue=" + phiValue);
            int j2 = 0;
            while ((double)j2 < 360.0 / resolution) {
                double rama_score = 0.0;
                double psiValue = (double)j2 * resolution * Math.PI / 180.0;
                System.out.println("j=" + j2 + " psiPreValue=" + psiValue);
                phiS[curResNo - noStart] = phiValue;
                psiS[curResNo - noStart] = psiValue;
                String curResName = this.GetResNameFromSequence(this.vecSeq, curResNo);
                String nextResName = this.GetResNameFromSequence(this.vecSeq, curResNo + 1);
                boolean isPrePro = false;
                if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
                    isPrePro = true;
                }
                boolean isGeneral = false;
                if (curResName.equalsIgnoreCase("ALA")) {
                    rama_score = this.CompRamachandranScore(phiValue, psiValue, this.vecRamaAla);
                } else if (curResName.equalsIgnoreCase("GLY")) {
                    rama_score = this.CompRamachandranScore(phiValue, psiValue, this.vecRamaGly);
                } else if (curResName.equalsIgnoreCase("PRO")) {
                    rama_score = this.CompRamachandranScore(phiValue, psiValue, this.vecRamaPro);
                } else if (isPrePro) {
                    rama_score = this.CompRamachandranScore(phiValue, psiValue, this.vecRamaPrePro);
                } else {
                    rama_score = this.CompRamachandranScore(phiValue, psiValue, this.vecRamaGeneral);
                    isGeneral = true;
                }
                rama_score = -Math.log(rama_score);
                Vector pdbFragTemp0 = new Vector();
                pdbFragTemp0 = mdc.modelBuild(phiS, psiS, coordN, coordNH, coordCA, noStart, true);
                Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                Vector<Pdb> vecAllPdbTemp = new Vector<Pdb>();
                vecAllPdbTemp.addAll(this.vecPdbSSE);
                vecAllPdbTemp.addAll(pdbFragTemp);
                Collections.sort(vecAllPdbTemp, new Pdb.PdbComparator());
                double[] rdc1Cal = new double[vecAllPdbTemp.size()];
                double[] rdc2Cal = new double[vecAllPdbTemp.size()];
                double[] saupe = new double[4];
                PdbRdc pdr = new PdbRdc();
                Matrix mm = pdr.bestFit(vecAllPdbTemp, vecNhRdc, vecChRdc, rdc1Cal, rdc2Cal, saupe);
                double chRdcRmsd = saupe[2];
                double nhRdcRmsd = saupe[3];
                int indEndNew = Collections.binarySearch(pdbFragTemp, new Pdb(noEnd), new Pdb.PdbComparator());
                Pdb pdbEndNew = pdbFragTemp.elementAt(indEndNew);
                Vector<Cartesian> atomVecEndNew = pdbEndNew.getAtomVec();
                double[] caEndNew = new double[3];
                int t = 0;
                while (t < atomVecEndNew.size()) {
                    Cartesian cc = atomVecEndNew.elementAt(t);
                    String atom = cc.getAtom();
                    if (atom.equals("CA")) {
                        caEndNew = cc.getXYZ();
                    }
                    ++t;
                }
                double distance = Math.sqrt((caEndNew[0] - caEndOrg[0]) * (caEndNew[0] - caEndOrg[0]) + (caEndNew[1] - caEndOrg[1]) * (caEndNew[1] - caEndOrg[1]) + (caEndNew[2] - caEndOrg[2]) * (caEndNew[2] - caEndOrg[2]));
                Vector vecPdbTemp = this.CombineSSEandLoop(this.vecPdbSSE, pdbFragTemp);
                double noeScore = 0.0;
                if (!isSkipNOE) {
                    Vector<Pdb> vecRotStructure = pp.RotamSelectAndStructure(csErrH, csErrHeavy, csErrHeavy, vecPdbTemp, asgVec, rotSrc, vecNoesy, 4.5, 1, this.caliConstant);
                    noeScore = this.CompNoePatternScoreBetwSSEAndLoop(csErrH, csErrHeavy, vecRotStructure, 4.5, asgVec, vecNoesy);
                    noeScore = -Math.log(noeScore);
                } else {
                    noeScore = 0.0;
                }
                rT = chRdcRmsd + nhRdcRmsd + wtNoeScore * noeScore + wtRamaScore * rama_score + wtDist * distance + wtClash * (double)numClashes;
                if (rT < rTotal) {
                    isFound = true;
                    rTotal = rT;
                    System.out.println("Phi = " + (double)k2 * resolution + "psi= " + (double)j2 * resolution + ": " + chRdcRmsd + "  " + nhRdcRmsd + "  noe score: " + wtNoeScore * noeScore + "  rama score: " + wtRamaScore * rama_score + "  dist: " + wtDist * distance + " clash: " + wtClash * (double)numClashes + ";  " + ", RT = " + rTotal);
                    System.arraycopy(phiS, 0, phiSave, 0, nTotalRes);
                    System.arraycopy(psiS, 0, psiSave, 0, nTotalRes);
                    endDist[0] = distance;
                }
                ++j2;
            }
            ++k2;
        }
        if (isFound) {
            System.out.println("debugging...resNo=" + curResNo + "...yes...we at least found one...");
        }
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        int i3 = 0;
        while (i3 < nTotalRes) {
            phiPsiVec.add(new PhiPsi(i3, "ALA", phiSave[i3], psiSave[i3]));
            ++i3;
        }
        Vector pdbFragTemp = new Vector();
        pdbFragTemp = mdc.modelBuild(phiSave, psiSave, nEndOrg, hnEndOrg, caEndOrg, noStart, true);
        Vector vecPdbTemp = this.CombineSSEandLoop(this.vecPdbSSE, pdbFragTemp);
        Vector<Pdb> pdbFragTempNew = pp.residueNameUpdateNoStr(this.vecSeq, vecPdbTemp);
        return pdbFragTempNew;
    }

    public Vector calcFragment(double Syy, double Szz, Vector<Dipolar> vecChRdc, Vector<Dipolar> vecNhRdc, double[] n1, double[] nh1, double[] ca1, int noStart, int noEnd, Vector vecNoesy, Vector asgVec, double csErrH, double csErrHeavy, boolean isSkipNOE) throws JampackException {
        int nTotalRes = Math.abs(noEnd - noStart) + 1;
        int numChRDCs = 0;
        int numNhRDCs = 0;
        vdw vander = new vdw();
        Pdb pp = new Pdb();
        int indEndOrg = Collections.binarySearch(this.vecPdbSSE, new Pdb(noEnd), new Pdb.PdbComparator());
        Pdb pdbEndOrg = (Pdb)this.vecPdbSSE.elementAt(indEndOrg);
        Vector<Cartesian> atomVecEndOrg = pdbEndOrg.getAtomVec();
        double[] caEndOrg = new double[3];
        int j = 0;
        while (j < atomVecEndOrg.size()) {
            Cartesian cc = atomVecEndOrg.elementAt(j);
            String atom = cc.getAtom();
            if (atom.equals("CA")) {
                caEndOrg = cc.getXYZ();
            }
            ++j;
        }
        String userDir = System.getProperty("user.dir");
        String rotSrc = String.valueOf(userDir) + "/system/rot-lib/";
        double[] rdcChExp = new double[nTotalRes];
        double[] rdcNhExp = new double[nTotalRes];
        int[] seqNosCH = new int[nTotalRes];
        int[] seqNosNH = new int[nTotalRes];
        int j2 = 0;
        while (j2 < nTotalRes) {
            int no = noStart + j2;
            int index = Collections.binarySearch(vecChRdc, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcChExp[j2] = vecChRdc.elementAt(index).getRdc();
                seqNosCH[j2] = 1;
                ++numChRDCs;
            } else {
                rdcChExp[j2] = -99999.9;
                seqNosCH[j2] = 0;
            }
            index = Collections.binarySearch(vecNhRdc, new Dipolar(no), new Dipolar.rdcComparator());
            if (index > -1) {
                rdcNhExp[j2] = vecNhRdc.elementAt(index).getRdc();
                seqNosNH[j2] = 1;
                ++numNhRDCs;
            } else {
                rdcNhExp[j2] = -99999.9;
                seqNosNH[j2] = 0;
            }
            ++j2;
        }
        ModelRdc mdc = new ModelRdc();
        double[] nToNHVec = mdc.internuclearVec(n1, nh1);
        double[] nToCAVec = mdc.internuclearVec(n1, ca1);
        ppGlobal ppg = new ppGlobal();
        Matrix mat = ppg.RgCal(nToNHVec, nToCAVec);
        double[] vdwValue = new double[1];
        boolean hasVDW = false;
        double vdwLevel = 0.05;
        boolean printVDWViolation = false;
        int nCycles = 2;
        double deviation = 3.0;
        int depth0 = 0;
        long seed = 66668L;
        Random rr = new Random(seed);
        double[] rdcCHArr = new double[nTotalRes];
        double[] rdcNHArr = new double[nTotalRes];
        PhiPsi ff = new PhiPsi();
        Vector ppVec = new Vector();
        boolean depthFlag = true;
        boolean rightHand = true;
        double[] ppS = new double[2 * nTotalRes];
        int noOfSln = 0;
        double[] phiS = new double[nTotalRes];
        double[] psiS = new double[nTotalRes];
        double[] phiSave = new double[nTotalRes];
        double[] psiSave = new double[nTotalRes];
        double[] rdcCHSave = new double[nTotalRes];
        double[] rdcNHSave = new double[nTotalRes];
        double rT = 100000.0;
        double rTotal = 100000.0;
        double wtNoeScore = 10.0;
        double wtRamaScore = 5.0;
        double wtDist = 5.0;
        double wtClash = 0.0;
        boolean isFound = false;
        boolean numClashes = false;
        int mmm = 0;
        while (mmm < nCycles) {
            System.out.println("debugging...mmm=: " + mmm);
            double rRdc_ch = 0.0;
            double rRdc_nh = 0.0;
            int j3 = 0;
            while (j3 < nTotalRes) {
                rdcCHArr[j3] = rdcChExp[j3] + deviation * rr.nextGaussian();
                rdcNHArr[j3] = rdcNhExp[j3] + deviation * rr.nextGaussian();
                double rms_ch = Math.abs(rdcCHArr[j3] - rdcChExp[j3]);
                rRdc_ch += rms_ch * rms_ch * (double)seqNosCH[j3];
                double rms_nh = Math.abs(rdcNHArr[j3] - rdcNhExp[j3]);
                rRdc_nh += rms_nh * rms_nh * (double)seqNosNH[j3];
                ++j3;
            }
            ppVec = new Vector();
            depthFlag = false;
            depthFlag = this.phiPsiChainAll(rdcCHArr, rdcNHArr, seqNosCH, seqNosNH, mat, Syy, Szz, depth0, noStart, nTotalRes - 1, ppS, ppVec, rightHand, noStart);
            if (ppVec.size() > 0) {
                noOfSln = ppVec.size() / (2 * nTotalRes);
                int k = 0;
                while (k < noOfSln) {
                    double rama_score = 0.0;
                    double sum_rama_score = 0.0;
                    int n = k * 2 * nTotalRes;
                    while (n < (k + 1) * 2 * nTotalRes) {
                        double phi_value = (Double)ppVec.elementAt(n);
                        double psi_value = (Double)ppVec.elementAt(n + 1);
                        phiS[(n - k * 2 * nTotalRes) / 2] = phi_value;
                        psiS[(n - k * 2 * nTotalRes) / 2] = psi_value;
                        int cur_no = (n - k * 2 * nTotalRes) / 2;
                        String curResName = this.GetResNameFromSequence(this.vecSeq, noStart + cur_no);
                        String nextResName = this.GetResNameFromSequence(this.vecSeq, noStart + cur_no + 1);
                        boolean isPrePro = false;
                        if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
                            isPrePro = true;
                        }
                        boolean isGeneral = false;
                        if (curResName.equalsIgnoreCase("ALA")) {
                            rama_score = this.CompRamachandranScore(phi_value, psi_value, this.vecRamaAla);
                        } else if (curResName.equalsIgnoreCase("GLY")) {
                            rama_score = this.CompRamachandranScore(phi_value, psi_value, this.vecRamaGly);
                        } else if (curResName.equalsIgnoreCase("PRO")) {
                            rama_score = this.CompRamachandranScore(phi_value, psi_value, this.vecRamaPro);
                        } else if (isPrePro) {
                            rama_score = this.CompRamachandranScore(phi_value, psi_value, this.vecRamaPrePro);
                        } else {
                            rama_score = this.CompRamachandranScore(phi_value, psi_value, this.vecRamaGeneral);
                            isGeneral = true;
                        }
                        sum_rama_score += rama_score;
                        n += 2;
                    }
                    sum_rama_score /= (double)nTotalRes;
                    Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
                    int i = 0;
                    while (i < nTotalRes) {
                        phiPsiVec.add(new PhiPsi(i, "ALA", phiS[i], psiS[i]));
                        ++i;
                    }
                    Vector pdbFragTemp0 = new Vector();
                    pdbFragTemp0 = mdc.modelBuild(phiS, psiS, n1, nh1, ca1, noStart, true);
                    Vector<Pdb> pdbFragTemp = pp.residueNameUpdateNoStr(this.vecSeq, pdbFragTemp0);
                    int indEndNew = Collections.binarySearch(pdbFragTemp, new Pdb(noEnd), new Pdb.PdbComparator());
                    Pdb pdbEndNew = pdbFragTemp.elementAt(indEndNew);
                    Vector<Cartesian> atomVecEndNew = pdbEndNew.getAtomVec();
                    double[] caEndNew = new double[3];
                    int j4 = 0;
                    while (j4 < atomVecEndNew.size()) {
                        Cartesian cc = atomVecEndNew.elementAt(j4);
                        String atom = cc.getAtom();
                        if (atom.equals("CA")) {
                            caEndNew = cc.getXYZ();
                        }
                        ++j4;
                    }
                    double distance = Math.sqrt((caEndNew[0] - caEndOrg[0]) * (caEndNew[0] - caEndOrg[0]) + (caEndNew[1] - caEndOrg[1]) * (caEndNew[1] - caEndOrg[1]) + (caEndNew[2] - caEndOrg[2]) * (caEndNew[2] - caEndOrg[2]));
                    Vector vecPdbTemp = this.CombineSSEandLoop(this.vecPdbSSE, pdbFragTemp);
                    double noeScore = 0.0;
                    if (!isSkipNOE) {
                        Vector<Pdb> vecRotStructure = pp.RotamSelectAndStructure(csErrH, csErrHeavy, csErrHeavy, vecPdbTemp, asgVec, rotSrc, vecNoesy, 4.5, 1, this.caliConstant);
                        noeScore = this.CompNoePatternScoreBetwSSEAndLoop(csErrH, csErrHeavy, vecRotStructure, 4.5, asgVec, vecNoesy);
                        noeScore = -Math.log(noeScore);
                    } else {
                        noeScore = 0.0;
                    }
                    sum_rama_score = -Math.log(sum_rama_score);
                    rT = Math.sqrt(rRdc_ch / (double)numChRDCs) + Math.sqrt(rRdc_nh / (double)(numNhRDCs - 1)) + wtNoeScore * noeScore + wtRamaScore * sum_rama_score + wtDist * distance + wtClash * (double)numClashes;
                    if (rT < rTotal) {
                        isFound = true;
                        rTotal = rT;
                        System.out.println(String.valueOf(mmm) + ": " + Math.sqrt(rRdc_ch / (double)numChRDCs) + "  " + Math.sqrt(rRdc_nh / (double)(numNhRDCs - 1)) + "  noe score: " + wtNoeScore * noeScore + "  rama score: " + wtRamaScore * rama_score + "  dist: " + wtDist * distance + " clash: " + wtClash * (double)numClashes + ";  " + ", RT = " + rTotal);
                        System.arraycopy(phiS, 0, phiSave, 0, nTotalRes);
                        System.arraycopy(psiS, 0, psiSave, 0, nTotalRes);
                        System.arraycopy(rdcCHArr, 0, rdcCHSave, 0, nTotalRes);
                        System.arraycopy(rdcNHArr, 0, rdcNHSave, 0, nTotalRes);
                    }
                    ++k;
                }
            }
            ++mmm;
        }
        if (isFound) {
            System.out.println("debugging...yes...we at least found one...");
        }
        Vector<PhiPsi> phiPsiVec = new Vector<PhiPsi>();
        int i = 0;
        while (i < nTotalRes) {
            phiPsiVec.add(new PhiPsi(i, "ALA", phiSave[i], psiSave[i]));
            ++i;
        }
        Vector pdbFragTemp = new Vector();
        pdbFragTemp = mdc.modelBuild(phiSave, psiSave, n1, nh1, ca1, noStart, true);
        Vector vecPdbTemp = this.CombineSSEandLoop(this.vecPdbSSE, pdbFragTemp);
        Vector<Pdb> pdbFragTempNew = pp.residueNameUpdateNoStr(this.vecSeq, vecPdbTemp);
        Vector<Pdb> pdbFragTempNewRot = pp.RotamSelectAndStructure(csErrH, csErrHeavy, csErrHeavy, vecPdbTemp, asgVec, rotSrc, vecNoesy, 4.5, 1, this.caliConstant);
        return pdbFragTempNewRot;
    }

    public double CompNoePatternScoreBetwSSEAndLoop(double errH, double errHeavy, Vector vecPdbCombin, double distBound, Vector asgVec, Vector vecNOESY) {
        Vector<Pdb> vecPdbLoop = new Vector<Pdb>();
        Vector<Pdb> vecPdbSSETemp = new Vector<Pdb>();
        int i = 0;
        while (i < vecPdbCombin.size()) {
            Pdb pp = (Pdb)vecPdbCombin.elementAt(i);
            int resNo = pp.getResidueNo();
            boolean isInSSE = false;
            int j = 0;
            while (j < this.vecPdbSSE.size()) {
                Pdb ppSSE = (Pdb)this.vecPdbSSE.elementAt(j);
                int resNoSSE = ppSSE.getResidueNo();
                if (resNo == resNoSSE) {
                    isInSSE = true;
                }
                ++j;
            }
            if (isInSSE) {
                vecPdbSSETemp.add(pp);
            } else {
                vecPdbLoop.add(pp);
            }
            ++i;
        }
        double[] coordLoop = new double[]{0.0, 0.0, 0.0};
        double[] coordSSE = new double[]{0.0, 0.0, 0.0};
        Peak pk = new Peak();
        Vector<Hdist> vecHdist = new Vector<Hdist>();
        int i2 = 0;
        while (i2 < vecPdbLoop.size()) {
            Pdb pdbLoop = (Pdb)vecPdbLoop.elementAt(i2);
            String resLoop = pdbLoop.getResidue();
            Vector<Cartesian> vecAtomLoop = pdbLoop.getAtomVec();
            int resNoLoop = pdbLoop.getResidueNo();
            int j = 0;
            while (j < vecAtomLoop.size()) {
                String heavyAtom;
                Cartesian ccLoop = vecAtomLoop.elementAt(j);
                coordLoop = ccLoop.getXYZ();
                String atomLoop = ccLoop.getAtom();
                if (atomLoop.substring(0, 1).equalsIgnoreCase("H") && ((heavyAtom = pk.GetHeavyAtomFromProton(resLoop, atomLoop)).substring(0, 1).equalsIgnoreCase("C") || heavyAtom.substring(0, 1).equalsIgnoreCase("N"))) {
                    int k = 0;
                    while (k < vecPdbSSETemp.size()) {
                        Pdb pdbSSE = (Pdb)vecPdbSSETemp.elementAt(k);
                        String resSSE = pdbSSE.getResidue();
                        Vector<Cartesian> vecAtomSSE = pdbSSE.getAtomVec();
                        int resNoSSE = pdbSSE.getResidueNo();
                        int h = 0;
                        while (h < vecAtomSSE.size()) {
                            double distance;
                            String heavyAtomSSE;
                            Cartesian ccSSE = vecAtomSSE.elementAt(h);
                            coordSSE = ccSSE.getXYZ();
                            String atomSSE = ccSSE.getAtom();
                            if (atomSSE.substring(0, 1).equalsIgnoreCase("H") && ((heavyAtomSSE = pk.GetHeavyAtomFromProton(resSSE, atomSSE)).substring(0, 1).equalsIgnoreCase("C") || heavyAtomSSE.substring(0, 1).equalsIgnoreCase("N")) && (distance = Math.sqrt((coordLoop[0] - coordSSE[0]) * (coordLoop[0] - coordSSE[0]) + (coordLoop[1] - coordSSE[1]) * (coordLoop[1] - coordSSE[1]) + (coordLoop[2] - coordSSE[2]) * (coordLoop[2] - coordSSE[2]))) < distBound) {
                                vecHdist.add(new Hdist(ccLoop, resNoLoop, resLoop, atomLoop, ccSSE, resNoSSE, resSSE, atomSSE, distance));
                                vecHdist.add(new Hdist(ccSSE, resNoSSE, resSSE, atomSSE, ccLoop, resNoLoop, resLoop, atomLoop, distance));
                            }
                            ++h;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i2;
        }
        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
        RotaPattern rotPattern = new RotaPattern();
        BackNoe bn = new BackNoe();
        int i3 = 0;
        while (i3 < vecHdist.size()) {
            Hdist hdist = (Hdist)vecHdist.elementAt(i3);
            BackNoe backNoe = rotPattern.BackCompNOEPeak(asgVec, hdist);
            vecBackNoe.add(backNoe);
            ++i3;
        }
        Vector<BackNoe> vecBackNoeNoRepeat = bn.DeleteRepeat(vecBackNoe);
        Assign asg = new Assign();
        int[] numPeaks = new int[1];
        double dbScore = asg.NoePatternMatchScoreWCali(errH, errHeavy, errHeavy, vecBackNoeNoRepeat, vecNOESY, numPeaks, false, this.caliConstant);
        return dbScore;
    }

    public Vector CombineSSEandLoop(Vector vecSSEPdb, Vector vecLoopPdb) {
        Vector<Pdb> vecNewPdb = new Vector<Pdb>();
        vecNewPdb.addAll(vecSSEPdb);
        int i = 0;
        while (i < vecLoopPdb.size()) {
            boolean isInSSE = false;
            Pdb pp = (Pdb)vecLoopPdb.elementAt(i);
            int resNo = pp.getResidueNo();
            int j = 0;
            while (j < vecSSEPdb.size()) {
                Pdb ppSSE = (Pdb)vecSSEPdb.elementAt(j);
                int resNoSSE = ppSSE.getResidueNo();
                if (resNoSSE == resNo) {
                    isInSSE = true;
                }
                ++j;
            }
            if (!isInSSE) {
                vecNewPdb.add(pp);
            }
            ++i;
        }
        Collections.sort(vecNewPdb, new Pdb.PdbComparator());
        return vecNewPdb;
    }

    public PhiPsi PhiPsiRandomFromRamachandran(Vector vecSeq, int resNo) {
        long seed = 11111L;
        Random rand = new Random(seed);
        String curResName = this.GetResNameFromSequence(vecSeq, resNo);
        String nextResName = this.GetResNameFromSequence(vecSeq, resNo + 1);
        boolean isPrePro = false;
        if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
            isPrePro = true;
        }
        Vector vecRama = new Vector();
        if (curResName.equalsIgnoreCase("ALA")) {
            vecRama.addAll(this.vecRamaAla);
        } else if (curResName.equalsIgnoreCase("GLY")) {
            vecRama.addAll(this.vecRamaGly);
        } else if (curResName.equalsIgnoreCase("PRO")) {
            vecRama.addAll(this.vecRamaPro);
        } else if (isPrePro) {
            vecRama.addAll(this.vecRamaPrePro);
        } else {
            vecRama.addAll(this.vecRamaGeneral);
        }
        int[] circle = new int[10000];
        int sum = 0;
        int current = 0;
        int i = 0;
        while (i < vecRama.size()) {
            PhiPsi phipsi = (PhiPsi)vecRama.elementAt(i);
            double prob = phipsi.getRamaScore();
            int nProb = (int)Math.round(prob * 1000.0);
            int k = current;
            while (k < nProb) {
                circle[k] = i;
                ++sum;
                ++k;
            }
            current += nProb;
            ++i;
        }
        int randomN = rand.nextInt(sum);
        int index = circle[randomN];
        PhiPsi phipsi_out = (PhiPsi)vecRama.elementAt(index);
        return phipsi_out;
    }

    public boolean phiPsiChainAll(double[] rdcArrCH, double[] rdcArrNH, int[] isChRDC, int[] isNhRDC, Matrix rg, double Syy, double Szz, int i, int resNo, int N, double[] ppS, Vector ppVec, boolean rightHand, int resNoStart) {
        String curResName = this.GetResNameFromSequence(this.vecSeq, resNo);
        String nextResName = this.GetResNameFromSequence(this.vecSeq, resNo + 1);
        boolean isPrePro = false;
        if (nextResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("PRO") && !curResName.equalsIgnoreCase("GLY")) {
            isPrePro = true;
        }
        PhiPsi ff = new PhiPsi();
        Vector phiVec = new Vector();
        Vector psiVec = new Vector();
        double phi = 0.0;
        double psi = 0.0;
        Matrix mat = new Matrix(3, 3);
        double ratio = 1.0;
        if (i > N - 1) {
            if (isChRDC[i] == 0) {
                double phiTemp = this.generator.nextDouble() * Math.PI * 2.0 - Math.PI;
                phiVec.add(new Double(phiTemp));
            } else {
                double u = rdcArrCH[i];
                phiVec = this.phiCalAll(Syy, Szz, u, rg);
            }
            if (!phiVec.isEmpty()) {
                int m = 0;
                while (m < phiVec.size()) {
                    int j = 0;
                    while (j < 2 * N) {
                        ppVec.addElement(new Double(ppS[j]));
                        ++j;
                    }
                    ppVec.addElement(phiVec.elementAt(m));
                    PhiPsi phipsi = this.PhiPsiRandomFromRamachandran(this.vecSeq, resNoStart + i);
                    double psiTemp = phipsi.getPsi();
                    ppVec.addElement(new Double(psiTemp));
                    ++m;
                }
                return true;
            }
            return false;
        }
        if (isChRDC[i] == 0) {
            PhiPsi phipsi = this.PhiPsiRandomFromRamachandran(this.vecSeq, resNoStart + i);
            double phiTemp = phipsi.getPhi();
            phiVec.add(new Double(phiTemp));
        } else {
            double u = rdcArrCH[i];
            phiVec = this.phiCalAll(Syy, Szz, u, rg);
        }
        if (!phiVec.isEmpty()) {
            Vector<PhiPsi> vecPhiPsiTemp = new Vector<PhiPsi>();
            int j = 0;
            while (j < phiVec.size()) {
                phi = (Double)phiVec.elementAt(j);
                if (isNhRDC[i + 1] == 0) {
                    double psiTemp = this.generator.nextDouble() * Math.PI * 2.0 - Math.PI;
                    psiVec.add(new Double(psiTemp));
                } else {
                    double v = rdcArrNH[i + 1] / 1.0;
                    psiVec = this.psiCalAll(Syy, Szz, v, phi, rg);
                }
                if (!psiVec.isEmpty()) {
                    int k = 0;
                    while (k < psiVec.size()) {
                        PhiPsi ffTemp;
                        psi = (Double)psiVec.elementAt(k);
                        double rama_score = 0.0;
                        boolean isGeneral = false;
                        if (curResName.equalsIgnoreCase("ALA")) {
                            rama_score = this.CompRamachandranScore(phi, psi, this.vecRamaAla);
                        } else if (curResName.equalsIgnoreCase("GLY")) {
                            rama_score = this.CompRamachandranScore(phi, psi, this.vecRamaGly);
                        } else if (curResName.equalsIgnoreCase("PRO")) {
                            rama_score = this.CompRamachandranScore(phi, psi, this.vecRamaPro);
                        } else if (isPrePro) {
                            rama_score = this.CompRamachandranScore(phi, psi, this.vecRamaPrePro);
                        } else {
                            rama_score = this.CompRamachandranScore(phi, psi, this.vecRamaGeneral);
                            isGeneral = true;
                        }
                        double cutoff = 0.002;
                        if (isGeneral) {
                            cutoff = 5.0E-4;
                        }
                        if (!(rama_score < cutoff) && !this.isInPhiPsiClusters(vecPhiPsiTemp, ffTemp = new PhiPsi(phi, psi, 0.0), 5.0)) {
                            vecPhiPsiTemp.add(ffTemp);
                            ppS[2 * i] = phi;
                            ppS[2 * i + 1] = psi;
                            mat = ff.newRG(phi, psi, rg, rightHand);
                            this.phiPsiChainAll(rdcArrCH, rdcArrNH, isChRDC, isNhRDC, mat, Syy, Szz, i + 1, resNo + 1, N, ppS, ppVec, rightHand, resNoStart);
                        }
                        ++k;
                    }
                }
                ++j;
            }
        }
        return false;
    }

    public Vector<PhiPsi> ReadRamachandranFile(String ssePdbFile) {
        String ss = "";
        StringTokenizer st = new StringTokenizer("");
        String firstStr = "";
        String secStr = "";
        String thirdStr = "";
        double phiT = 0.0;
        double psiT = 0.0;
        double score = 0.0;
        Vector<PhiPsi> vecPhiPsi = new Vector<PhiPsi>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(ssePdbFile));
            ss = in.readLine();
            do {
                if ((st = new StringTokenizer(ss)).hasMoreTokens()) {
                    firstStr = st.nextToken().trim();
                }
                if (st.hasMoreTokens()) {
                    secStr = st.nextToken().trim();
                }
                if (st.hasMoreTokens()) {
                    thirdStr = st.nextToken().trim();
                }
                if (firstStr.substring(0, 1).equalsIgnoreCase("#")) continue;
                phiT = new Double(firstStr);
                psiT = new Double(secStr);
                score = new Double(thirdStr);
                vecPhiPsi.add(new PhiPsi(phiT *= Math.PI / 180, psiT *= Math.PI / 180, score));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + ssePdbFile);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return vecPhiPsi;
    }

    public double CompRamachandranScore(double phi, double psi, Vector vecRamachandran) {
        double Threshold = Math.PI / 90;
        if (phi >= Math.PI) {
            phi -= Math.PI * 2;
        }
        if (psi >= Math.PI) {
            psi -= Math.PI * 2;
        }
        int i = 0;
        while (i < vecRamachandran.size()) {
            PhiPsi phipsi = (PhiPsi)vecRamachandran.elementAt(i);
            double phiT = phipsi.getPhi();
            double psiT = phipsi.getPsi();
            double score = phipsi.getRamaScore();
            if (Math.abs(phi - phiT) < Threshold && Math.abs(psi - psiT) < Threshold) {
                return score;
            }
            ++i;
        }
        return 0.0;
    }

    public Vector phiCalAll(double Syy, double Szz, double rdc, Matrix Rg) {
        PhiPsi ff = new PhiPsi();
        Matrix M = Const.r9y1x.times(Rg);
        double[][] mat = M.getArray();
        Matrix r2y = new Matrix(3, 3);
        Vector<Double> phiVec = new Vector<Double>();
        double phiHigh = 0.0;
        double phiLow = 0.0;
        phiHigh = 999.9;
        phiLow = -9999.9;
        double[] coefs = new double[14];
        boolean coefFlag = ff.quarticCoefPhi(Syy, Szz, rdc, mat, coefs);
        if (!coefFlag) {
            return phiVec;
        }
        Vector rootVec = ff.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return phiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPhi = 0.0;
        double cosPhi = 0.0;
        double phi = 0.0;
        double cSquare = PhiPsi.dirCosCH[0] * PhiPsi.dirCosCH[0] + PhiPsi.dirCosCH[2] * PhiPsi.dirCosCH[2];
        double[] bondDir = new double[3];
        double eps = 1.0E-7;
        int i = 0;
        while (i < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = PhiPsi.dirCosCH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) + PhiPsi.dirCosCH[2] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
            tmp2 = PhiPsi.dirCosCH[2] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) - PhiPsi.dirCosCH[0] * (mat[2][0] * x + mat[2][1] * y + mat[2][2] * z);
            if (cSquare != 0.0) {
                cosPhi = tmp1 / cSquare;
                sinPhi = tmp2 / cSquare;
                if (cosPhi >= 0.0) {
                    phi = Math.asin(sinPhi);
                } else if (cosPhi < 0.0) {
                    phi = Math.PI - Math.asin(sinPhi);
                }
            } else {
                System.out.println("both Cx and Cz are zero");
                System.exit(1);
            }
            if (phi > Math.PI) {
                phi -= Math.PI * 2;
            }
            if (phi < phiHigh && phi > phiLow && Math.abs((bondDir = Const.rHA2HA1.times((r2y = M.rotationMat(phi, "+y")).times(M.times(bondVector))))[0] - 0.0) < 1.0E-7 && Math.abs(bondDir[1] - 0.0) < 1.0E-7 && Math.abs(bondDir[2] - 1.0) < 1.0E-7) {
                phiVec.add(new Double(phi));
            }
            ++i;
        }
        return phiVec;
    }

    public String GetResNameFromSequence(Vector vecSequence, int res_no) {
        int i = 0;
        while (i < vecSequence.size()) {
            Assign asg = (Assign)vecSequence.elementAt(i);
            int no = asg.getResidueNo();
            String resName = asg.getResidueType();
            if (res_no == no) {
                return resName;
            }
            ++i;
        }
        return "";
    }

    public Vector psiCalAll(double Syy, double Szz, double rdc, double phi, Matrix rg) {
        PhiPsi ff = new PhiPsi();
        Matrix r2y = rg.rotationMat(phi, "+y");
        Matrix M = Const.r3x.times(r2y.times(Const.r9y1x.times(rg)));
        double[][] mat = M.getArray();
        double[] coefs = new double[14];
        Vector<Double> psiVec = new Vector<Double>();
        double eps = 1.0E-7;
        double psiHigh = 0.0;
        double psiLow = 0.0;
        psiHigh = 9999.9;
        psiLow = -9999.9;
        boolean coefFlag = ff.quarticCoefPsi(Syy, Szz, rdc, mat, coefs);
        if (!coefFlag) {
            System.out.println("can not compute coefficients for the quartic equation");
            return psiVec;
        }
        Vector rootVec = ff.quarticSolve(coefs);
        if (rootVec.isEmpty()) {
            return psiVec;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double[] bondVector = new double[3];
        double tmp1 = 0.0;
        double tmp2 = 0.0;
        double sinPsi = 0.0;
        double cosPsi = 0.0;
        double psi = 0.0;
        double cSquare = PhiPsi.dirCosNH[0] * PhiPsi.dirCosNH[0] + PhiPsi.dirCosNH[1] * PhiPsi.dirCosNH[1];
        Matrix rPsiz = new Matrix(3, 3);
        double[] bondDir = new double[3];
        int i = 0;
        while (i < rootVec.size()) {
            bondVector = (double[])rootVec.elementAt(i);
            x = bondVector[0];
            y = bondVector[1];
            z = bondVector[2];
            tmp1 = PhiPsi.dirCosNH[0] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) + PhiPsi.dirCosNH[1] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            tmp2 = PhiPsi.dirCosNH[1] * (mat[0][0] * x + mat[0][1] * y + mat[0][2] * z) - PhiPsi.dirCosNH[0] * (mat[1][0] * x + mat[1][1] * y + mat[1][2] * z);
            if (cSquare != 0.0) {
                sinPsi = tmp2 / cSquare;
                cosPsi = -tmp1 / cSquare;
                if (cosPsi >= 0.0) {
                    psi = Math.asin(sinPsi);
                } else if (cosPsi < 0.0) {
                    psi = Math.PI - Math.asin(sinPsi);
                }
            } else {
                System.out.println("Both Cx or Cz are zero");
                System.exit(1);
            }
            if (psi < -Math.PI) {
                psi += Math.PI * 2;
            }
            if (psi < psiHigh && psi > psiLow && Math.abs((bondDir = Const.r7x6y5x.times((rPsiz = M.rotationMat(psi + Math.PI, "+z")).times(M.times(bondVector))))[0] - 0.0) < 1.0E-7 && Math.abs(bondDir[1] - 0.0) < 1.0E-7 && Math.abs(bondDir[2] + 1.0) < 1.0E-7) {
                psiVec.add(new Double(psi));
            }
            ++i;
        }
        return psiVec;
    }

    public boolean isInPhiPsiClusters(Vector vecPhiPsi, PhiPsi ff, double resolution) {
        boolean isInClusters = false;
        int i = 0;
        while (i < vecPhiPsi.size()) {
            double psiB;
            PhiPsi ffTemp = (PhiPsi)vecPhiPsi.elementAt(i);
            double phiA = ffTemp.getPhi();
            double psiA = ffTemp.getPsi();
            double phiB = ff.getPhi();
            double dist = Math.sqrt((phiA - phiB) * (phiA - phiB) + (psiA - (psiB = ff.getPsi())) * (psiA - psiB));
            if (dist < resolution) {
                isInClusters = true;
            }
            ++i;
        }
        return isInClusters;
    }
}

