/*
 * Decompiled with CFR 0.152.
 */
package Jampack;

import Jampack.JampackException;
import Jampack.Schur;
import Jampack.Zdiagmat;
import Jampack.Zmat;

public class Zspec {
    public Zmat U;
    public Zdiagmat D;

    public Zspec(Zmat AA) throws JampackException {
        if (AA.nrow != AA.ncol) {
            throw new RuntimeException("Matrix not square.");
        }
        Zmat A = new Zmat(AA);
        int i = 0;
        while (i < A.nrow) {
            if (A.im[i][i] != 0.0) {
                throw new JampackException("Matrix not Hermitian");
            }
            int j = 0;
            while (j < i) {
                if (A.re[i][j] != A.re[j][i] || A.im[i][j] != -A.im[j][i]) {
                    throw new JampackException("Matrix not Hermitian");
                }
                ++j;
            }
            ++i;
        }
        Schur S = new Schur(A);
        this.D = new Zdiagmat(S.T);
        i = 0;
        while (i < this.D.n) {
            this.D.im[i] = 0.0;
            ++i;
        }
        this.U = S.U;
    }
}

