/*
 * Decompiled with CFR 0.152.
 */
package NascaGUI;

import NascaGUI.Global;
import NascaGUI.NascaFrame;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import rdcPanda.Assign;

public class NascaGUI {
    public static void main(String[] args) {
        String userDir = System.getProperty("user.dir");
        String srcNascaSystem = String.valueOf(userDir) + "/system/nasca/nasca_system.input";
        NascaGUI.readSystemParameters(srcNascaSystem);
        NascaFrame frame = new NascaFrame();
        URL imgURL = NascaGUI.class.getResource("/NascaGUI/image/logo.jpg");
        frame.setIconImage(new ImageIcon(imgURL).getImage());
        frame.setVisible(true);
    }

    public static void readSystemParameters(String srcNascaSystem) {
        Assign asg = new Assign();
        Vector<Map<String, String>> paraVec = asg.ParamReader(srcNascaSystem);
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                Global.haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                Global.h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                Global.c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                Global.hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                Global.nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("NOELIMIT")) {
                Global.noeDistLimit = Double.parseDouble(paraMap.get("NOELIMIT"));
            }
            if (paraMap.containsKey("INPUT_DIRECTORY")) {
                Global.updateInputFilePath(paraMap.get("INPUT_DIRECTORY"));
            }
            if (paraMap.containsKey("OUTPUT_DIRECTORY")) {
                Global.updateOutputFilePath(paraMap.get("OUTPUT_DIRECTORY"));
            }
            if (paraMap.containsKey("INPUT_SESSION_FILE")) {
                Global.updateDefaultInputSessionName(paraMap.get("INPUT_SESSION_FILE"));
            }
            ++i;
        }
    }
}

