/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.H1CS;
import rdcPanda.HnNoe;
import rdcPanda.Noe;
import rdcPanda.Pdb;
import rdcPanda.Peak;

public class Noesy {
    private int ID;
    private int residueNo;
    private String residue;
    private double dbCSH1;
    private double dbCSHeavy;
    private double dbCSH2;
    private double dbCSHeavy1;
    private double dbCSHeavy2;
    private double intensity;
    private double uncertainty = 0.0;
    private double upperDist = 0.0;
    private int binIndex = 0;

    public Noesy() {
        this.residueNo = 0;
        this.residue = null;
        this.dbCSH1 = 0.0;
        this.dbCSHeavy = 0.0;
        this.dbCSH2 = 0.0;
        this.intensity = 0.0;
        this.binIndex = 0;
    }

    public Noesy(int no) {
        this.residueNo = no;
        this.residue = null;
        this.dbCSH1 = 0.0;
        this.dbCSHeavy = 0.0;
        this.dbCSH2 = 0.0;
        this.intensity = 0.0;
        this.binIndex = 0;
    }

    public Noesy(int no, String resid, double H1, double Heavy, double H2, double inten) {
        this.residueNo = no;
        this.residue = resid;
        this.dbCSH1 = H1;
        this.dbCSHeavy = Heavy;
        this.dbCSH2 = H2;
        this.intensity = inten;
        this.binIndex = 0;
    }

    public Noesy(int no, String resid, double H1, double Heavy, double H2, double inten, double uncn) {
        this.residueNo = no;
        this.residue = resid;
        this.dbCSH1 = H1;
        this.dbCSHeavy = Heavy;
        this.dbCSH2 = H2;
        this.intensity = inten;
        this.uncertainty = uncn;
        this.binIndex = 0;
    }

    public Noesy(int no, String resid, double H1, double Heavy1, double H2, double Heavy2, double inten, double uncn) {
        this.residueNo = no;
        this.residue = resid;
        this.dbCSH1 = H1;
        this.dbCSHeavy1 = Heavy1;
        this.dbCSH2 = H2;
        this.dbCSHeavy2 = Heavy2;
        this.intensity = inten;
        this.uncertainty = uncn;
        this.binIndex = 0;
    }

    public Noesy(int id, int no, String resid, double H1, double Heavy1, double H2, double Heavy2, double inten, double uncn) {
        this.ID = id;
        this.residueNo = no;
        this.residue = resid;
        this.dbCSH1 = H1;
        this.dbCSHeavy1 = Heavy1;
        this.dbCSH2 = H2;
        this.dbCSHeavy2 = Heavy2;
        this.intensity = inten;
        this.uncertainty = uncn;
        this.binIndex = 0;
    }

    public Noesy(int id, double H1, double Heavy, double H2, double inten, double uncn) {
        this.ID = id;
        this.dbCSH1 = H1;
        this.dbCSHeavy = Heavy;
        this.dbCSH2 = H2;
        this.intensity = inten;
        this.uncertainty = uncn;
        this.binIndex = 0;
    }

    public int getResidueNo() {
        return this.residueNo;
    }

    public String getResidueType() {
        return this.residue;
    }

    public double getH1() {
        return this.dbCSH1;
    }

    public int getID() {
        return this.ID;
    }

    public double getHeavy() {
        return this.dbCSHeavy;
    }

    public double getHeavy1() {
        return this.dbCSHeavy1;
    }

    public double getHeavy2() {
        return this.dbCSHeavy2;
    }

    public double getH2() {
        return this.dbCSH2;
    }

    public double getIntensity() {
        return this.intensity;
    }

    public double getUncertainty() {
        return this.uncertainty;
    }

    public double getUpperDist() {
        return this.upperDist;
    }

    public int getBinIndex() {
        return this.binIndex;
    }

    public void setID(int id) {
        this.ID = id;
    }

    public void setResidueNo(int R) {
        this.residueNo = R;
    }

    public void setResidueType(String R) {
        this.residue = R;
    }

    public void setUpperDist(double dist) {
        this.upperDist = dist;
    }

    public void setBinIndex(int i) {
        this.binIndex = i;
    }

    public Vector<Noesy> SetCalibration(Vector<Noesy> vecNoesy) {
        double volume = 0.0;
        double maxInten = 0.0;
        Collections.sort(vecNoesy, new IntensityComparator());
        Vector<Noesy> vecNoesyN = new Vector<Noesy>();
        int i = 0;
        while (i < vecNoesy.size()) {
            double cs_h2;
            Noesy noesy2 = vecNoesy.elementAt(i);
            double cs_h1 = noesy2.getH1();
            if (Math.abs(cs_h1 - (cs_h2 = noesy2.getH2())) > 0.02) {
                vecNoesyN.add(noesy2);
            }
            ++i;
        }
        int totalNum = vecNoesyN.size();
        int index1 = (int)Math.floor((double)totalNum * 0.2);
        int index2 = (int)Math.floor((double)totalNum * 0.5);
        int index3 = (int)Math.floor((double)totalNum * 0.8);
        Noesy noesy1 = vecNoesy.elementAt(index1);
        Noesy noesy2 = vecNoesy.elementAt(index2);
        Noesy noesy3 = vecNoesy.elementAt(index3);
        double bin1 = noesy1.getIntensity();
        double bin2 = noesy2.getIntensity();
        double bin3 = noesy3.getIntensity();
        Vector<Noesy> vecNewNoesy = new Vector<Noesy>();
        i = 0;
        while (i < vecNoesy.size()) {
            Noesy noesy = vecNoesy.elementAt(i);
            double inten = noesy.getIntensity();
            if (inten >= bin3) {
                noesy.setUpperDist(2.7);
                noesy.setBinIndex(1);
            }
            if (inten < bin3 && inten >= bin2) {
                noesy.setUpperDist(3.3);
                noesy.setBinIndex(2);
            }
            if (inten < bin2 && inten >= bin1) {
                noesy.setUpperDist(5.0);
                noesy.setBinIndex(3);
            }
            if (inten < bin1) {
                noesy.setUpperDist(6.0);
                noesy.setBinIndex(4);
            }
            vecNewNoesy.add(noesy);
            ++i;
        }
        return vecNewNoesy;
    }

    public Vector SetCalibration2(Vector vecNoesy) {
        double volume = 0.0;
        double maxInten = 0.0;
        double exponent = 0.3333333333333333;
        Collections.sort(vecNoesy, new IntensityComparator());
        Vector<Noesy> vecNoesyN = new Vector<Noesy>();
        int i = 0;
        while (i < vecNoesy.size()) {
            Noesy noesy2 = (Noesy)vecNoesy.elementAt(i);
            double cs_h1 = noesy2.getH1();
            double cs_h2 = noesy2.getH2();
            if (maxInten < noesy2.getIntensity()) {
                maxInten = noesy2.getIntensity();
            }
            if (Math.abs(cs_h1 - cs_h2) > 0.02) {
                vecNoesyN.add(noesy2);
            }
            ++i;
        }
        Collections.sort(vecNoesy, new IntensityComparator());
        int totalNum = vecNoesyN.size();
        int index1 = (int)Math.floor((double)totalNum * 0.2);
        int index2 = (int)Math.floor((double)totalNum * 0.5);
        int index3 = (int)Math.floor((double)totalNum * 0.8);
        Noesy noesy1 = (Noesy)vecNoesy.elementAt(index1);
        Noesy noesy2 = (Noesy)vecNoesy.elementAt(index2);
        Noesy noesy3 = (Noesy)vecNoesy.elementAt(index3);
        Noesy noesy0 = (Noesy)vecNoesy.elementAt(vecNoesy.size() - 1);
        double constant = noesy3.getIntensity() * Math.pow(2.7, 3.0);
        exponent = 0.0 - exponent;
        Vector<Noesy> vecNewNoesy = new Vector<Noesy>();
        i = 0;
        while (i < vecNoesy.size()) {
            Noesy noesy = (Noesy)vecNoesy.elementAt(i);
            double inten = noesy.getIntensity();
            double up_dist = Math.pow(inten /= constant, exponent);
            if ((up_dist += 0.3 * up_dist) > 6.0) {
                up_dist = 6.0;
            }
            if (up_dist < 2.7) {
                up_dist = 2.7;
            }
            noesy.setUpperDist(up_dist);
            vecNewNoesy.add(noesy);
            ++i;
        }
        return vecNewNoesy;
    }

    public Vector SetCalibrationC13(Vector vecNoesy, Vector vecAsg) {
        Peak pk = new Peak();
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        Collections.sort(vecNoesy, new IntensityComparator());
        Vector<Peak> allH1Vec = pk.allProtonSorted(vecAsg);
        Collections.sort(allH1Vec, new Peak.csComparator());
        String userDir = System.getProperty("user.dir");
        String srcRot = String.valueOf(userDir) + "/system/rot-lib/";
        Vector<Noe> vecUniqueAsg = asg.InitAmbiAssignmentUnique(0.2, 0.2, 0.04, 0.04, 0.03, vecAsg, allH1Vec, vecNoesy);
        Vector<Noe> vecNewNoe = new Vector<Noe>();
        int i = 0;
        while (i < vecUniqueAsg.size()) {
            int secondNo;
            Noe noe = vecUniqueAsg.elementAt(i);
            int firstNo = noe.getResidueNoA();
            if (firstNo == (secondNo = noe.getResidueNoB())) {
                double csH2;
                String atom1 = noe.getAtomA();
                String atom2 = noe.getAtomB();
                double csH1 = pk.getCSFromList(vecAsg, firstNo, atom1);
                if (!(Math.abs(csH1 - (csH2 = pk.getCSFromList(vecAsg, secondNo, atom2))) < 0.06)) {
                    String res = noe.getResidueA();
                    String rotamFile = String.valueOf(srcRot) + res.toLowerCase() + ".pdb";
                    Vector<Pdb> vecPdbRotam = pp.readRotamerPdb(rotamFile);
                    double maxDist = -999.9;
                    double minDist = 999.9;
                    boolean isLargeDist = false;
                    int j = 0;
                    while (j < vecPdbRotam.size()) {
                        Pdb pdb = vecPdbRotam.elementAt(j);
                        pdb.setResidueNo(firstNo);
                        double[] dist = new double[2];
                        Vector<Pdb> vecPdb = new Vector<Pdb>();
                        vecPdb.add(pdb);
                        pk.checkNoeNew(vecPdb, firstNo, atom1, secondNo, atom2, 6.0, 0.0, dist);
                        if (maxDist > 0.0 && Math.abs(maxDist - dist[0]) > 1.0) {
                            isLargeDist = true;
                        }
                        if (maxDist < dist[0]) {
                            maxDist = dist[0];
                        }
                        if (minDist < dist[0]) {
                            minDist = dist[0];
                        }
                        ++j;
                    }
                    if (!isLargeDist && !(minDist > 100.0)) {
                        noe.setDistUpper(minDist);
                        vecNewNoe.add(noe);
                    }
                }
            }
            ++i;
        }
        double counter = 0.0;
        double k_sum = 0.0;
        int i2 = 0;
        while (i2 < vecNewNoe.size()) {
            Noe noe = (Noe)vecNewNoe.elementAt(i2);
            int pkID = noe.getPeakID();
            Noesy noesy = (Noesy)vecNoesy.elementAt(pkID);
            String res1 = noe.getResidueA();
            String atom1 = noe.getAtomA();
            String res2 = noe.getResidueB();
            String atom2 = noe.getAtomB();
            double intensity = noesy.getIntensity();
            double distance = noe.getUpper();
            double divMethyl = 1.0;
            if (res1.equalsIgnoreCase("ALA") && atom1.equalsIgnoreCase("HB")) {
                divMethyl *= 3.0;
            }
            if (res1.equalsIgnoreCase("ILE") && (atom1.equalsIgnoreCase("HG2") || atom1.equalsIgnoreCase("HD1"))) {
                divMethyl *= 3.0;
            }
            if (res1.equalsIgnoreCase("LEU") && (atom1.equalsIgnoreCase("HD1") || atom1.equalsIgnoreCase("HD2"))) {
                divMethyl *= 3.0;
            }
            if (res1.equalsIgnoreCase("LEU") && atom1.equalsIgnoreCase("HD")) {
                divMethyl *= 9.0;
            }
            if (res1.equalsIgnoreCase("VAL") && (atom1.equalsIgnoreCase("HG1") || atom1.equalsIgnoreCase("HG2"))) {
                divMethyl *= 3.0;
            }
            if (res1.equalsIgnoreCase("VAL") && atom1.equalsIgnoreCase("HG")) {
                divMethyl *= 9.0;
            }
            if (res1.equalsIgnoreCase("THR") && atom1.equalsIgnoreCase("HG2")) {
                divMethyl *= 3.0;
            }
            if (res1.equalsIgnoreCase("MET") && atom1.equalsIgnoreCase("HE")) {
                divMethyl *= 3.0;
            }
            if (res1.equalsIgnoreCase("PHE") && (atom1.equalsIgnoreCase("HE") || atom1.equalsIgnoreCase("HE1") || atom1.equalsIgnoreCase("HD") || atom1.equalsIgnoreCase("HD1"))) {
                divMethyl *= 2.0;
            }
            if (res2.equalsIgnoreCase("ALA") && atom2.equalsIgnoreCase("HB")) {
                divMethyl *= 3.0;
            }
            if (res2.equalsIgnoreCase("ILE") && (atom2.equalsIgnoreCase("HG2") || atom2.equalsIgnoreCase("HD1"))) {
                divMethyl *= 3.0;
            }
            if (res2.equalsIgnoreCase("LEU") && (atom2.equalsIgnoreCase("HD1") || atom2.equalsIgnoreCase("HD2"))) {
                divMethyl *= 3.0;
            }
            if (res2.equalsIgnoreCase("LEU") && atom2.equalsIgnoreCase("HD")) {
                divMethyl *= 9.0;
            }
            if (res2.equalsIgnoreCase("VAL") && (atom2.equalsIgnoreCase("HG1") || atom2.equalsIgnoreCase("HG2"))) {
                divMethyl *= 3.0;
            }
            if (res2.equalsIgnoreCase("VAL") && atom2.equalsIgnoreCase("HG")) {
                divMethyl *= 9.0;
            }
            if (res2.equalsIgnoreCase("THR") && atom2.equalsIgnoreCase("HG2")) {
                divMethyl *= 3.0;
            }
            if (res2.equalsIgnoreCase("MET") && atom2.equalsIgnoreCase("HE")) {
                divMethyl *= 3.0;
            }
            if (res2.equalsIgnoreCase("PHE") && (atom2.equalsIgnoreCase("HE") || atom2.equalsIgnoreCase("HE1") || atom2.equalsIgnoreCase("HD") || atom2.equalsIgnoreCase("HD1"))) {
                divMethyl *= 2.0;
            }
            counter += 1.0;
            k_sum += intensity / Math.pow(distance, -6.0);
            ++i2;
        }
        double constant = k_sum / counter;
        Vector<Noesy> vecNewNoesy = new Vector<Noesy>();
        int i3 = 0;
        while (i3 < vecNoesy.size()) {
            Noesy noesy = (Noesy)vecNoesy.elementAt(i3);
            double intensity = noesy.getIntensity();
            double temp = constant / intensity;
            double distance = Math.pow(temp, 0.16666666666666666);
            noesy.setUpperDist(distance);
            vecNewNoesy.add(noesy);
            ++i3;
        }
        return vecNewNoesy;
    }

    public Vector<Noe> SetCalibrationCyana(Vector<Noe> vecNoe, Vector<Noesy> vecNoesy, double constant) {
        double constB = constant / 5.76;
        double constC = constB / 3.0;
        int i = 0;
        while (i < vecNoe.size()) {
            double exponent = 0.0;
            double constK = constant;
            Noe noe = vecNoe.elementAt(i);
            int no1 = noe.getResidueNoA();
            int no2 = noe.getResidueNoB();
            String res1 = noe.getResidueA();
            String res2 = noe.getResidueB();
            String atom1 = noe.getAtomA();
            String atom2 = noe.getAtomB();
            int pkID = noe.getPeakID();
            Noesy noesy = vecNoesy.elementAt(pkID);
            double intensity = noesy.getIntensity();
            int nType = 0;
            String subAtom1 = atom1;
            String subAtom2 = atom2;
            if (atom1.length() >= 2) {
                subAtom1 = atom1.substring(0, 2);
            }
            if (atom2.length() >= 2) {
                subAtom2 = atom2.substring(0, 2);
            }
            if ((subAtom1.equalsIgnoreCase("H") || subAtom1.equalsIgnoreCase("HN") || subAtom1.equalsIgnoreCase("HA") || subAtom1.equalsIgnoreCase("HB")) && (subAtom2.equalsIgnoreCase("H") || subAtom2.equalsIgnoreCase("HN") || subAtom2.equalsIgnoreCase("HB"))) {
                nType = 1;
                if (subAtom1.equalsIgnoreCase("HB") && subAtom2.equalsIgnoreCase("HB")) {
                    nType = 0;
                }
                if (res1.equalsIgnoreCase("ALA") && subAtom1.equalsIgnoreCase("HB")) {
                    nType = 0;
                }
                if (res2.equalsIgnoreCase("ALA") && subAtom2.equalsIgnoreCase("HB")) {
                    nType = 0;
                }
                if (Math.abs(no1 - no2) > 4) {
                    nType = 0;
                }
            }
            if (res1.equalsIgnoreCase("ALA") && subAtom1.equalsIgnoreCase("HB")) {
                nType = 3;
            }
            if (res1.equalsIgnoreCase("LEU") && subAtom1.equalsIgnoreCase("HD")) {
                nType = 3;
            }
            if (res1.equalsIgnoreCase("LEU") && subAtom1.equalsIgnoreCase("HD")) {
                nType = 3;
            }
            if (res1.equalsIgnoreCase("MET") && subAtom1.equalsIgnoreCase("HE")) {
                nType = 3;
            }
            if (res1.equalsIgnoreCase("VAL") && subAtom1.equalsIgnoreCase("HG")) {
                nType = 3;
            }
            if (res1.equalsIgnoreCase("THR") && atom1.equalsIgnoreCase("HG2")) {
                nType = 3;
            }
            if (res1.equalsIgnoreCase("ILE") && (atom1.equalsIgnoreCase("HD1") || atom1.equalsIgnoreCase("HG2"))) {
                nType = 3;
            }
            if (res2.equalsIgnoreCase("ALA") && subAtom2.equalsIgnoreCase("HB")) {
                nType = 3;
            }
            if (res2.equalsIgnoreCase("LEU") && subAtom2.equalsIgnoreCase("HD")) {
                nType = 3;
            }
            if (res2.equalsIgnoreCase("LEU") && subAtom2.equalsIgnoreCase("HD")) {
                nType = 3;
            }
            if (res2.equalsIgnoreCase("MET") && subAtom2.equalsIgnoreCase("HE")) {
                nType = 3;
            }
            if (res2.equalsIgnoreCase("VAL") && subAtom2.equalsIgnoreCase("HG")) {
                nType = 3;
            }
            if (res2.equalsIgnoreCase("THR") && atom2.equalsIgnoreCase("HG2")) {
                nType = 3;
            }
            if (res2.equalsIgnoreCase("ILE") && (atom2.equalsIgnoreCase("HD1") || atom2.equalsIgnoreCase("HG2"))) {
                nType = 3;
            }
            if (nType == 0) {
                nType = 2;
            }
            if (nType == 1) {
                exponent = 6.0;
                constK = constant;
            } else if (nType == 2) {
                exponent = 4.0;
                constK = constB;
            } else if (nType == 3) {
                exponent = 4.0;
                constK = constC;
            }
            double temp = constK / intensity;
            double distance = Math.pow(temp, 1.0 / exponent);
            if (distance < 2.4) {
                distance = 2.4;
            }
            if (distance > 6.0) {
                distance = 6.0;
            }
            noe.setDistUpper(distance);
            ++i;
        }
        Vector<Noe> vecNoeNew = new Vector<Noe>();
        vecNoeNew.addAll(vecNoe);
        return vecNoeNew;
    }

    public double SetCalibrationOneCyana(BackNoe bkNoe, Noesy noesy, double constant) {
        double constB = constant / 5.76;
        double constC = constB / 3.0;
        double exponent = 0.0;
        double constK = constant;
        int no1 = bkNoe.getFirstResNo();
        int no2 = bkNoe.getSecondResNo();
        String res1 = bkNoe.getFirstResName();
        String res2 = bkNoe.getSecondResName();
        String atom1 = bkNoe.getH1Name();
        String atom2 = bkNoe.getH2Name();
        double intensity = noesy.getIntensity();
        double dividNum = 1.0;
        int nType = 0;
        String subAtom1 = atom1;
        String subAtom2 = atom2;
        if (atom1.length() >= 2) {
            subAtom1 = atom1.substring(0, 2);
        }
        if (atom2.length() >= 2) {
            subAtom2 = atom2.substring(0, 2);
        }
        if ((subAtom1.equalsIgnoreCase("H") || subAtom1.equalsIgnoreCase("HN") || subAtom1.equalsIgnoreCase("HA") || subAtom1.equalsIgnoreCase("HB")) && (subAtom2.equalsIgnoreCase("H") || subAtom2.equalsIgnoreCase("HN") || subAtom2.equalsIgnoreCase("HB"))) {
            nType = 1;
            if (subAtom1.equalsIgnoreCase("HB") && subAtom2.equalsIgnoreCase("HB")) {
                nType = 0;
            }
            if (res1.equalsIgnoreCase("ALA") && subAtom1.equalsIgnoreCase("HB")) {
                nType = 0;
            }
            if (res2.equalsIgnoreCase("ALA") && subAtom2.equalsIgnoreCase("HB")) {
                nType = 0;
            }
            if (Math.abs(no1 - no2) > 4) {
                nType = 0;
            }
        }
        if (res1.equalsIgnoreCase("ALA") && subAtom1.equalsIgnoreCase("HB")) {
            nType = 3;
            dividNum *= 3.0;
        } else if (res1.equalsIgnoreCase("LEU") && atom1.equalsIgnoreCase("HD")) {
            nType = 3;
            dividNum *= 9.0;
        } else if (res1.equalsIgnoreCase("LEU") && (atom1.equalsIgnoreCase("HD1") || atom1.equalsIgnoreCase("HD2"))) {
            nType = 3;
            dividNum *= 9.0;
        } else if (res1.equalsIgnoreCase("MET") && subAtom1.equalsIgnoreCase("HE")) {
            nType = 3;
            dividNum *= 3.0;
        } else if (res1.equalsIgnoreCase("VAL") && atom1.equalsIgnoreCase("HG")) {
            nType = 3;
            dividNum *= 9.0;
        } else if (res1.equalsIgnoreCase("VAL") && (atom1.equalsIgnoreCase("HG1") || atom1.equalsIgnoreCase("HG2"))) {
            nType = 3;
            dividNum *= 9.0;
        } else if (res1.equalsIgnoreCase("THR") && atom1.equalsIgnoreCase("HG2")) {
            nType = 3;
            dividNum *= 3.0;
        } else if (res1.equalsIgnoreCase("ILE") && (atom1.equalsIgnoreCase("HD1") || atom1.equalsIgnoreCase("HG2"))) {
            nType = 3;
            dividNum *= 3.0;
        } else if ((res1.equalsIgnoreCase("CYS") || res1.equalsIgnoreCase("ASP") || res1.equalsIgnoreCase("GLU") || res1.equalsIgnoreCase("PHE") || res1.equalsIgnoreCase("HIS") || res1.equalsIgnoreCase("LYS") || res1.equalsIgnoreCase("LEU") || res1.equalsIgnoreCase("MET") || res1.equalsIgnoreCase("ASN") || res1.equalsIgnoreCase("PRO") || res1.equalsIgnoreCase("GLN") || res1.equalsIgnoreCase("ARG") || res1.equalsIgnoreCase("SER") || res1.equalsIgnoreCase("TRP") || res1.equalsIgnoreCase("TYR")) && subAtom1.equalsIgnoreCase("HB")) {
            dividNum *= 2.0;
        } else if (res1.equalsIgnoreCase("TYR") && (subAtom1.equalsIgnoreCase("HD") || subAtom1.equalsIgnoreCase("HE"))) {
            dividNum *= 2.0;
        }
        if (res2.equalsIgnoreCase("ALA") && subAtom2.equalsIgnoreCase("HB")) {
            nType = 3;
            dividNum *= 3.0;
        } else if (res2.equalsIgnoreCase("LEU") && atom2.equalsIgnoreCase("HD")) {
            nType = 3;
            dividNum *= 9.0;
        } else if (res2.equalsIgnoreCase("LEU") && (atom2.equalsIgnoreCase("HD1") || atom2.equalsIgnoreCase("HD2"))) {
            nType = 3;
            dividNum *= 9.0;
        } else if (res2.equalsIgnoreCase("MET") && subAtom2.equalsIgnoreCase("HE")) {
            nType = 3;
            dividNum *= 3.0;
        } else if (res2.equalsIgnoreCase("VAL") && atom2.equalsIgnoreCase("HG")) {
            nType = 3;
            dividNum *= 9.0;
        } else if (res2.equalsIgnoreCase("VAL") && (atom2.equalsIgnoreCase("HG1") || atom2.equalsIgnoreCase("HG2"))) {
            nType = 3;
            dividNum *= 9.0;
        } else if (res2.equalsIgnoreCase("THR") && atom2.equalsIgnoreCase("HG2")) {
            nType = 3;
            dividNum *= 3.0;
        } else if (res2.equalsIgnoreCase("ILE") && (atom2.equalsIgnoreCase("HD1") || atom2.equalsIgnoreCase("HG2"))) {
            nType = 3;
            dividNum *= 3.0;
        } else if ((res2.equalsIgnoreCase("CYS") || res2.equalsIgnoreCase("ASP") || res2.equalsIgnoreCase("GLU") || res2.equalsIgnoreCase("PHE") || res2.equalsIgnoreCase("HIS") || res2.equalsIgnoreCase("LYS") || res2.equalsIgnoreCase("LEU") || res2.equalsIgnoreCase("MET") || res2.equalsIgnoreCase("ASN") || res2.equalsIgnoreCase("PRO") || res2.equalsIgnoreCase("GLN") || res2.equalsIgnoreCase("ARG") || res2.equalsIgnoreCase("SER") || res2.equalsIgnoreCase("TRP") || res2.equalsIgnoreCase("TYR")) && subAtom2.equalsIgnoreCase("HB")) {
            dividNum *= 2.0;
        } else if (res2.equalsIgnoreCase("TYR") && (subAtom2.equalsIgnoreCase("HD") || subAtom2.equalsIgnoreCase("HE"))) {
            dividNum *= 2.0;
        }
        if (nType == 0) {
            nType = 2;
        }
        if (nType == 1) {
            exponent = 6.0;
            constK = constant;
        } else if (nType == 2) {
            exponent = 4.0;
            constK = constB;
        } else if (nType == 3) {
            exponent = 4.0;
            constK = constC;
            intensity /= dividNum;
        }
        double temp = constK / intensity;
        double distance = Math.pow(temp, 1.0 / exponent);
        if (distance < 2.4) {
            distance = 2.4;
        }
        if (distance > 6.0) {
            distance = 6.0;
        }
        return distance;
    }

    public Vector SetCalibrationC13Sec(Vector vecNoesy, Vector vecSeq, Vector vecAsg) {
        double errH1 = 0.02;
        double errHeavy = 0.1;
        double errH2 = 0.02;
        Peak pk = new Peak();
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        Collections.sort(vecNoesy, new IntensityComparator());
        double counter = 0.0;
        double k_sum = 0.0;
        int i = 0;
        while (i < vecSeq.size()) {
            block16: {
                int no;
                String res;
                block15: {
                    Assign asign = (Assign)vecSeq.elementAt(i);
                    res = asign.getResidueType();
                    no = asign.getResidueNo();
                    if (!res.equalsIgnoreCase("ALA")) break block15;
                    double csHB = pk.getCSFromList(vecAsg, no, "HB");
                    double csCB = pk.getCSFromList(vecAsg, no, "CB");
                    double csHA = pk.getCSFromList(vecAsg, no, "HA");
                    double maxInten = -999.9;
                    double noeH1Save = -999.9;
                    double noeH2Save = -999.9;
                    double noeHeavySave = -999.9;
                    boolean isFound = false;
                    int j = 0;
                    while (j < vecNoesy.size()) {
                        Noesy noesy = (Noesy)vecNoesy.elementAt(j);
                        double noeH1 = noesy.getH1();
                        double noeH2 = noesy.getH2();
                        double noeHeavy = noesy.getHeavy();
                        double csInten = noesy.getIntensity();
                        if (Math.abs(csHB - noeH1) < errH1 && Math.abs(noeHeavy - csCB) < errHeavy && Math.abs(csHA - noeH2) < errH2) {
                            isFound = true;
                            if (maxInten < csInten) {
                                maxInten = csInten;
                                noeH1Save = noeH1;
                                noeH2Save = noeH2;
                                noeHeavySave = noeHeavy;
                            }
                        }
                        ++j;
                    }
                    if (!isFound) break block16;
                    counter += 1.0;
                    k_sum += (maxInten /= 3.0) / Math.pow(2.7, -6.0);
                }
                if (res.equalsIgnoreCase("LEU")) {
                    double csHG = pk.getCSFromList(vecAsg, no, "HG");
                    double csCG = pk.getCSFromList(vecAsg, no, "CG");
                    double csHD1 = pk.getCSFromList(vecAsg, no, "HD1");
                    double csHD2 = pk.getCSFromList(vecAsg, no, "HD2");
                    double maxInten = -999.9;
                    double noeH1Save = -999.9;
                    double noeH2Save = -999.9;
                    double noeHeavySave = -999.9;
                    boolean isFound = false;
                    int j = 0;
                    while (j < vecNoesy.size()) {
                        Noesy noesy = (Noesy)vecNoesy.elementAt(j);
                        double noeH1 = noesy.getH1();
                        double noeH2 = noesy.getH2();
                        double noeHeavy = noesy.getHeavy();
                        double csInten = noesy.getIntensity();
                        if (Math.abs(csHG - noeH1) < errH1 && Math.abs(noeHeavy - csCG) < errHeavy && Math.abs(csHD1 - noeH2) < errH2) {
                            isFound = true;
                            if (maxInten < csInten) {
                                maxInten = csInten;
                                noeH1Save = noeH1;
                                noeH2Save = noeH2;
                                noeHeavySave = noeHeavy;
                            }
                        }
                        ++j;
                    }
                    if (isFound) {
                        counter += 1.0;
                        k_sum += (maxInten /= 3.0) / Math.pow(2.7, -6.0);
                    }
                }
            }
            ++i;
        }
        double constant = k_sum / counter;
        Vector<Noesy> vecNewNoesy = new Vector<Noesy>();
        int i2 = 0;
        while (i2 < vecNoesy.size()) {
            Noesy noesy = (Noesy)vecNoesy.elementAt(i2);
            double intensity = noesy.getIntensity();
            double temp = constant / intensity;
            double distance = Math.pow(temp, 0.16666666666666666);
            if (distance < 2.4) {
                distance = 2.4;
            }
            if (distance > 6.0) {
                distance = 6.0;
            }
            noesy.setUpperDist(distance);
            vecNewNoesy.add(noesy);
            ++i2;
        }
        return vecNewNoesy;
    }

    public Vector<Noesy> SetCalibrationN15(Vector<Noesy> vecNoesy, Vector<Pdb> vecSSEBB, Vector<H1CS> vecAsg, double[] constantK) {
        Vector<Noesy> vecNewNoesy = new Vector<Noesy>();
        double errH1 = 0.03;
        double errHeavy = 0.1;
        double errH2 = 0.015;
        double volume = 0.0;
        Collections.sort(vecNoesy, new IntensityComparator());
        Peak pk = new Peak();
        double counter = 0.0;
        double k_sum = 0.0;
        int i = 0;
        while (i < vecSSEBB.size()) {
            double csPreHA;
            Pdb pdb = vecSSEBB.elementAt(i);
            int resNo = pdb.getResidueNo();
            double csHN = pk.getCSFromList(vecAsg, resNo, "H");
            double csN = pk.getCSFromList(vecAsg, resNo, "N");
            boolean isPreHA = false;
            int j = 0;
            while (j < vecSSEBB.size()) {
                Pdb pdbPre;
                int resNoPre;
                if (i != j && (resNoPre = (pdbPre = vecSSEBB.elementAt(j)).getResidueNo()) == resNo - 1) {
                    isPreHA = true;
                }
                ++j;
            }
            if (isPreHA && !(Math.abs((csPreHA = pk.getCSFromList(vecAsg, resNo - 1, "HA")) - 4.78) < 0.04) && !(Math.abs(csHN - 4.78) < 0.04)) {
                double maxInten = -999.9;
                double noeH1Save = -999.9;
                double noeH2Save = -999.9;
                double noeHeavySave = -999.9;
                int j2 = 0;
                while (j2 < vecNoesy.size()) {
                    Noesy noesy = vecNoesy.elementAt(j2);
                    double noeH1 = noesy.getH1();
                    double noeH2 = noesy.getH2();
                    double noeHeavy = noesy.getHeavy();
                    double csInten = noesy.getIntensity();
                    if (Math.abs(csHN - noeH1) < errH1 && Math.abs(noeHeavy - csN) < errHeavy && maxInten < csInten) {
                        maxInten = csInten;
                        noeH1Save = noeH1;
                        noeH2Save = noeH2;
                        noeHeavySave = noeHeavy;
                    }
                    ++j2;
                }
                if (Math.abs(noeH2Save - csPreHA) < errH2) {
                    counter += 1.0;
                    k_sum += maxInten / Math.pow(2.7, -6.0);
                }
            }
            ++i;
        }
        double constant = 0.0;
        double count = 0.0;
        double average = 0.0;
        int i2 = 0;
        while (i2 < vecNoesy.size()) {
            Noesy noesy = vecNoesy.elementAt(i2);
            double intensity = noesy.getIntensity();
            count += 1.0;
            average += intensity;
            double temp = constant / intensity;
            double distance = Math.pow(temp, 0.16666666666666666);
            if (distance < 2.4) {
                distance = 2.4;
            }
            if (distance > 6.0) {
                distance = 6.0;
            }
            noesy.setUpperDist(distance);
            vecNewNoesy.add(noesy);
            ++i2;
        }
        constantK[0] = (average /= count) / Math.pow(3.4, -6.0);
        return vecNewNoesy;
    }

    public Vector<Noesy> DeleteRepeatedNoesy3D(Vector<Noesy> vecOldNoesy) {
        Vector<Noesy> vecNoesyNew = new Vector<Noesy>();
        int i = 0;
        while (i < vecOldNoesy.size()) {
            Noesy noesy = vecOldNoesy.elementAt(i);
            double csH1 = noesy.getH1();
            double csH2 = noesy.getH2();
            double csHeavy = noesy.getHeavy();
            boolean isInPre = false;
            int j = 0;
            while (j < vecNoesyNew.size()) {
                Noesy noesyNew = vecNoesyNew.elementAt(j);
                double csH1New = noesyNew.getH1();
                double csH2New = noesyNew.getH2();
                double csHeavyNew = noesyNew.getHeavy();
                if (Math.abs(csH1 - csH1New) < 0.001 && Math.abs(csH2 - csH2New) < 0.001 && Math.abs(csHeavy - csHeavyNew) < 0.001) {
                    isInPre = true;
                }
                ++j;
            }
            if (!isInPre) {
                vecNoesyNew.add(noesy);
            }
            ++i;
        }
        return vecNoesyNew;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<Noesy> NoesyReaderNMRView(String filename) {
        inputs = new Vector<Noesy>();
        csH1 = 0.0;
        csHeavy = 0.0;
        csH2 = 0.0;
        intensity = 0.0;
        uncertainty = 0.0;
        csVec = new Vector<E>();
        st = new StringTokenizer("");
        str = "";
        strTemp = "";
        csID = 0.0;
        index1 = false;
        index2 = false;
        order = "";
        value = 0.0;
        no = false;
        aaType = "";
        ss = "";
        counter = 0;
        index = -1;
        try {
            in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            do lbl-1000:
            // 4 sources

            {
                block47: {
                    block46: {
                        if ((index = ss.trim().indexOf("#")) != 0) break block46;
                        ss = in.readLine();
                        if (ss != null) ** GOTO lbl-1000
                        break;
                    }
                    st = new StringTokenizer(ss);
                    if (st.hasMoreTokens()) break block47;
                    ss = in.readLine();
                    if (ss != null) ** GOTO lbl-1000
                    break;
                }
                csID = new Double(st.nextToken());
                isRead = true;
                block4: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block4;
                        }
                        ++k;
                    }
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                isRead = true;
                block6: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block6;
                        }
                        ++k;
                    }
                }
                isRead = true;
                block8: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block8;
                        }
                        ++k;
                    }
                }
                if (st.hasMoreTokens()) {
                    csH2 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                isRead = true;
                block10: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block10;
                        }
                        ++k;
                    }
                }
                isRead = true;
                block12: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block12;
                        }
                        ++k;
                    }
                }
                if (st.hasMoreTokens()) {
                    csHeavy = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                isRead = true;
                block14: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block14;
                        }
                        ++k;
                    }
                }
                if (st.hasMoreTokens()) {
                    intensity = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    uncertainty = new Double(st.nextToken());
                }
                ++counter;
                inputs.add(new Noesy(0, "", csH1, csHeavy, csH2, intensity, uncertainty));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<Noesy> NoesyReaderNMRView4D(String filename) {
        inputs = new Vector<Noesy>();
        csH1 = 0.0;
        csHeavy = 0.0;
        csH2 = 0.0;
        intensity = 0.0;
        uncertainty = 0.0;
        csHeavy1 = 0.0;
        csHeavy2 = 0.0;
        csVec = new Vector<E>();
        st = new StringTokenizer("");
        str = "";
        strTemp = "";
        csID = 0.0;
        index1 = false;
        index2 = false;
        order = "";
        value = 0.0;
        no = false;
        aaType = "";
        ss = "";
        counter = 0;
        index = -1;
        try {
            in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            do lbl-1000:
            // 4 sources

            {
                block60: {
                    block59: {
                        if ((index = ss.trim().indexOf("#")) != 0) break block59;
                        ss = in.readLine();
                        if (ss != null) ** GOTO lbl-1000
                        break;
                    }
                    st = new StringTokenizer(ss);
                    if (st.hasMoreTokens()) break block60;
                    ss = in.readLine();
                    if (ss != null) ** GOTO lbl-1000
                    break;
                }
                csID = new Double(st.nextToken());
                isRead = true;
                block4: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block4;
                        }
                        ++k;
                    }
                }
                if (st.hasMoreTokens()) {
                    csHeavy2 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                isRead = true;
                block6: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block6;
                        }
                        ++k;
                    }
                }
                isRead = true;
                block8: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block8;
                        }
                        ++k;
                    }
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                isRead = true;
                block10: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block10;
                        }
                        ++k;
                    }
                }
                isRead = true;
                block12: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block12;
                        }
                        ++k;
                    }
                }
                if (st.hasMoreTokens()) {
                    csHeavy1 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                isRead = true;
                block14: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block14;
                        }
                        ++k;
                    }
                }
                isRead = true;
                block16: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block16;
                        }
                        ++k;
                    }
                }
                if (st.hasMoreTokens()) {
                    csH2 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                isRead = true;
                block18: while (isRead) {
                    if (st.hasMoreTokens()) {
                        strTemp = new String(st.nextToken());
                    }
                    k = 0;
                    while (k < strTemp.length()) {
                        strOne = strTemp.substring(k, k + 1);
                        if (strOne.equalsIgnoreCase("}")) {
                            isRead = false;
                            continue block18;
                        }
                        ++k;
                    }
                }
                if (st.hasMoreTokens()) {
                    intensity = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    uncertainty = new Double(st.nextToken());
                }
                ++counter;
                inputs.add(new Noesy(0, "", csH1, csHeavy1, csH2, csHeavy2, intensity, uncertainty));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        System.out.println("The total number of HN-NOE frequency triples is: " + counter);
        return inputs;
    }

    /*
     * Unable to fully structure code
     */
    public Vector<Noesy> NoesyReader(String filename) {
        inputs = new Vector<Noesy>();
        csH1 = 0.0;
        csHeavy = 0.0;
        csH2 = 0.0;
        intensity = 0.0;
        uncertainty = 0.0;
        csVec = new Vector<E>();
        st = new StringTokenizer("");
        str = "";
        strTemp = "";
        csID = 0.0;
        index1 = false;
        index2 = false;
        order = "";
        value = 0.0;
        no = false;
        aaType = "";
        ss = "";
        counter = 0;
        index = -1;
        try {
            in = new BufferedReader(new FileReader(filename));
            ss = in.readLine();
            do lbl-1000:
            // 3 sources

            {
                block13: {
                    if ((index = ss.trim().indexOf("#")) != 0) break block13;
                    ss = in.readLine();
                    if (ss != null) ** GOTO lbl-1000
                    break;
                }
                st = new StringTokenizer(ss);
                if (st.hasMoreTokens()) {
                    csID = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csHeavy = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csH2 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    csH1 = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    strTemp = new String(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    intensity = new Double(st.nextToken());
                }
                if (st.hasMoreTokens()) {
                    uncertainty = new Double(st.nextToken());
                }
                ++counter;
                inputs.add(new Noesy(0, "", csH1, csHeavy, csH2, intensity, uncertainty));
            } while ((ss = in.readLine()) != null);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + filename);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

    public Vector rangeSearch(String nucType, double a, double b, Vector pkVec) {
        Vector outVec = new Vector();
        double csValue = 0.0;
        int i = 0;
        while (i < pkVec.size()) {
            if (nucType.equals("H1")) {
                csValue = ((HnNoe)pkVec.elementAt(i)).getHN();
            } else if (nucType.equals("N15")) {
                csValue = ((HnNoe)pkVec.elementAt(i)).getN15();
            }
            if (csValue >= a && csValue <= b) {
                outVec.add(pkVec.elementAt(i));
            }
            ++i;
        }
        return outVec;
    }

    public Vector mergeHnNoe(Vector pkVec, double epsH, double epsN) {
        double csHN = 0.0;
        double csN15 = 0.0;
        double csHNTmp = 0.0;
        double csN15Tmp = 0.0;
        Vector<HnNoe> outVec = new Vector<HnNoe>();
        Vector<Vector<HnNoe>> allVec = new Vector<Vector<HnNoe>>();
        double csValue = 0.0;
        HnNoe hncc = new HnNoe();
        int i = 0;
        int j = 0;
        Collections.sort(pkVec, new HnNoe.n15Comparator());
        boolean count = false;
        int cnt1 = 0;
        int cnt2 = 0;
        int N = pkVec.size();
        while (!pkVec.isEmpty()) {
            hncc = (HnNoe)pkVec.elementAt(0);
            csHN = hncc.getHN();
            csN15 = hncc.getN15();
            outVec.add(hncc);
            cnt1 = 0;
            i = 1;
            while (i < pkVec.size()) {
                hncc = (HnNoe)pkVec.elementAt(i);
                csHNTmp = hncc.getHN();
                csN15Tmp = hncc.getN15();
                if (Math.abs(csHNTmp - csHN) < epsH && Math.abs(csN15Tmp - csN15) < epsN) {
                    outVec.add(hncc);
                    ++cnt1;
                }
                ++i;
            }
            allVec.add(outVec);
            outVec = new Vector();
            cnt2 = 0;
            j = 0;
            while (j < pkVec.size()) {
                hncc = (HnNoe)pkVec.elementAt(j);
                csHNTmp = hncc.getHN();
                csN15Tmp = hncc.getN15();
                if (Math.abs(csHNTmp - csHN) < epsH && Math.abs(csN15Tmp - csN15) < epsN) {
                    pkVec.removeElementAt(j);
                    ++cnt2;
                    continue;
                }
                ++j;
            }
            pkVec.trimToSize();
            N = pkVec.size();
        }
        return allVec;
    }

    public void PrintAllNoesyToFileXEASY(Vector<Noesy> vecNoesy, PrintWriter out) {
        int preNo = -99;
        int i = 0;
        while (i < vecNoesy.size()) {
            Noesy noesy = vecNoesy.elementAt(i);
            double csHeavy = noesy.getHeavy();
            double csH2 = noesy.getH2();
            double csH1 = noesy.getH1();
            double csIntensity = noesy.getIntensity();
            double csUncertain = noesy.getUncertainty();
            String strCSHeavy = String.format("%.3f", csHeavy);
            String strCSH2 = String.format("%.3f", csH2);
            String strCSH1 = String.format("%.3f", csH1);
            String strIntensity = String.format("%.3f", csIntensity);
            String strUncertain = String.format("%.3f", csUncertain);
            out.println(String.valueOf(i) + "  " + strCSHeavy + "   " + strCSH2 + "   " + strCSH1 + "  " + "1   U" + "      " + strIntensity + "   " + strUncertain + "\t\t" + "a   0    0 0 0   0");
            ++i;
        }
    }

    public void PrintAllNoesyToFileNMRView(Vector<Noesy> vecNoesy, PrintWriter out) {
        int preNo = -99;
        int i = 0;
        while (i < vecNoesy.size()) {
            Noesy noesy = vecNoesy.elementAt(i);
            double csHeavy = noesy.getHeavy();
            double csH2 = noesy.getH2();
            double csH1 = noesy.getH1();
            double csIntensity = noesy.getIntensity();
            double csUncertain = noesy.getUncertainty();
            String strCSHeavy = String.format("%.3f", csHeavy);
            String strCSH2 = String.format("%.3f", csH2);
            String strCSH1 = String.format("%.3f", csH1);
            String strIntensity = String.format("%.3f", csIntensity);
            String strUncertain = String.format("%.3f", csUncertain);
            out.println(String.valueOf(i) + "  " + "{}" + strCSH1 + "  0.00  0.00  ++  0.0  {}  {}  " + strCSH2 + "  0.00  0.00  ++  0.0  {}  {}  " + strCSHeavy + "  0.00  0.00  ++  0.0  {}  " + strIntensity + "   " + strUncertain + "  0 {} 0 ");
            ++i;
        }
    }

    public static class IntensityComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Noesy n1 = (Noesy)o1;
            Noesy n2 = (Noesy)o2;
            double d1 = n1.getIntensity();
            if (d1 < (d2 = n2.getIntensity())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class h1Comparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Noesy n1 = (Noesy)o1;
            Noesy n2 = (Noesy)o2;
            double d1 = n1.getH1();
            if (d1 < (d2 = n2.getH1())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class h2Comparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Noesy n1 = (Noesy)o1;
            Noesy n2 = (Noesy)o2;
            double d1 = n1.getH2();
            if (d1 < (d2 = n2.getH2())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class heavyComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Noesy n1 = (Noesy)o1;
            Noesy n2 = (Noesy)o2;
            double d1 = n1.getHeavy();
            if (d1 < (d2 = n2.getHeavy())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class resNoComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            Noesy n1 = (Noesy)o1;
            Noesy n2 = (Noesy)o2;
            double d1 = n1.getResidueNo();
            if (d1 < (d2 = (double)n2.getResidueNo())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

