/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.Cartesian;
import rdcPanda.H1CS;
import rdcPanda.Hdist;
import rdcPanda.Hsqc;
import rdcPanda.ModelRdc;
import rdcPanda.Noe;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.Peak;
import rdcPanda.RotaPattern;

public class Nasca {
    public Vector RefineRotLibWOSCAsg(double csErrH, double csErrN, double csErrCA, Vector vecRot, Vector vecBB, Vector assignBBVec, Vector NoesyVec, int resNo, double distBound, int pickNum, Vector vecRotStr, Vector vecResonGraph, Vector vecStructGraph, int[][] Map2, Vector vecAsgBMRB) {
        int i;
        Vector<Pdb> vecNewRot = new Vector<Pdb>();
        Pdb pp = new Pdb();
        H1CS h1cs = new H1CS();
        String rotamResName = "";
        RotaPattern rotPattern = new RotaPattern();
        Assign asg = new Assign();
        double dbScore = 0.0;
        Vector<RotaPattern> vecRotTemp = new Vector<RotaPattern>();
        boolean noeCounter = false;
        double maxSc = -999999.9;
        int sumPeaks = 0;
        Pdb pdbRotamer = (Pdb)vecRot.elementAt(0);
        Vector<Cartesian> vecAtom = pdbRotamer.getAtomVec();
        Vector<Node> vecSCProtons = new Vector<Node>();
        int k = 0;
        while (k < vecStructGraph.size()) {
            Node nodeStruct = (Node)vecStructGraph.elementAt(k);
            int res_no = nodeStruct.getResNo();
            String atom_name = nodeStruct.getAtomName();
            boolean isAssigned = nodeStruct.getIsAssigned();
            boolean isRestrained = nodeStruct.getIsRestrained();
            String subAtomT = atom_name;
            if (atom_name.length() >= 2) {
                subAtomT = atom_name.substring(0, 2);
            }
            if (!isAssigned) {
                boolean isIn = false;
                i = 0;
                while (i < vecAtom.size()) {
                    String atom;
                    Cartesian cc = vecAtom.elementAt(i);
                    String subAtom = atom = cc.getAtom();
                    if (atom.length() > atom_name.length()) {
                        subAtom = atom.substring(0, atom_name.length());
                    }
                    if (resNo == res_no && subAtom.equalsIgnoreCase(atom_name)) {
                        isIn = true;
                        break;
                    }
                    ++i;
                }
                if (isIn) {
                    vecSCProtons.add(nodeStruct);
                }
            }
            ++k;
        }
        Vector vecAllSCAsgs = this.EnumAllScAsgSaveIntoFile(vecSCProtons, vecResonGraph, vecStructGraph);
        int scAsgId = 0;
        int rotId = 0;
        int k2 = 0;
        while (k2 < vecAllSCAsgs.size()) {
            Vector vecOneSCAsg = (Vector)vecAllSCAsgs.elementAt(k2);
            double asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsg, vecAsgBMRB);
            Vector vecOneBBSCAsg = new Vector();
            vecOneBBSCAsg.addAll(vecOneSCAsg);
            vecOneBBSCAsg.addAll(assignBBVec);
            i = 0;
            while (i < vecRot.size()) {
                Vector<Pdb> vecRotamer = new Vector<Pdb>();
                pdbRotamer = (Pdb)vecRot.elementAt(i);
                Pdb pdbRotamerStr = (Pdb)vecRotStr.elementAt(i);
                vecRotamer.add(pdbRotamer);
                Vector<Hdist> vecHdist = pp.compDistPatternForRotam(vecRotamer, resNo, vecBB, distBound);
                rotamResName = pdbRotamer.getResidue();
                Vector vecBackNoe = rotPattern.BackCompNoePattern(vecOneBBSCAsg, resNo, rotamResName, vecHdist);
                BackNoe bk = new BackNoe();
                Vector<BackNoe> vecBackNoeNew = bk.DeleteRepeat(vecBackNoe);
                int[] numPeaks = new int[1];
                dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, NoesyVec, numPeaks, false);
                double asg_log = Math.log(asgScore);
                double noe_log = Math.log(dbScore);
                dbScore = 1.0 * asg_log + noe_log;
                sumPeaks += numPeaks[0];
                if (maxSc < dbScore) {
                    maxSc = dbScore;
                    scAsgId = k2;
                    rotId = i;
                }
                vecRotTemp.add(new RotaPattern(pdbRotamerStr, dbScore));
                ++i;
            }
            ++k2;
        }
        Pdb pd = (Pdb)vecRot.elementAt(rotId);
        vecNewRot.add(pd);
        if (vecAllSCAsgs.size() >= 1) {
            Vector vecScAsgT = (Vector)vecAllSCAsgs.elementAt(scAsgId);
            Vector vecTemp = new Vector();
            int k3 = 0;
            while (k3 < vecScAsgT.size()) {
                H1CS h1csT = (H1CS)vecScAsgT.elementAt(k3);
                String atom = h1csT.getAtomName();
                if (!atom.equalsIgnoreCase("CB")) {
                    assignBBVec.add(h1csT);
                }
                ++k3;
            }
            Collections.sort(assignBBVec, new H1CS.resNoComparator());
        }
        return vecNewRot;
    }

    public Vector RotamSelectWOSCAsg(Vector pdbBBVec, Vector asgBBVec, Vector NoesyVec, Vector vecResonGraph, Vector vecStructGraph, int[][] Map2, Vector vecAsgBMRB) {
        double csErrH = 0.04;
        double csErrN = 0.4;
        double csErrCA = 0.4;
        int pickNum = 1;
        double distBound = 6.0;
        String userDir = System.getProperty("user.dir");
        String rotSrc = String.valueOf(userDir) + "/system/rot-lib/";
        Vector<Object> pdbRotam = new Vector();
        Vector pdbRotamNewStr = new Vector();
        Vector pdbRotamNewCS = new Vector();
        Vector pdbRotamNewRef = new Vector();
        Pdb pp = new Pdb();
        RotaPattern rp = new RotaPattern();
        Vector<Pdb> vecGrowPdb = new Vector<Pdb>();
        vecGrowPdb = pdbBBVec;
        int j = 0;
        while (j < pdbBBVec.size()) {
            Vector<Pdb> vecTemp;
            Pdb pdb = (Pdb)vecGrowPdb.elementAt(j);
            String resName = pdb.getResidue();
            int resNo = pdb.getResidueNo();
            Vector pdbRotVec = new Vector();
            System.out.println("debugging resNo=" + resNo);
            String rotamFile = String.valueOf(rotSrc) + resName.toLowerCase() + ".pdb";
            pdbRotam = pp.readRotamerPdb(rotamFile);
            pdbRotamNewStr = pp.nameConvert4SmallRotLibStr(pdbRotam);
            pdbRotVec = pdbRotam;
            int indRef = Collections.binarySearch(vecGrowPdb, new Pdb(resNo), new Pdb.PdbComparator());
            int[] index = new int[2];
            if (indRef >= 0) {
                pdbRotamNewRef = this.RefineRotLibWOSCAsg(csErrH, csErrN, csErrCA, pdbRotVec, vecGrowPdb, asgBBVec, NoesyVec, resNo, distBound, pickNum, pdbRotVec, vecResonGraph, vecStructGraph, Map2, vecAsgBMRB);
            }
            if (resName.equalsIgnoreCase("GLY")) {
                pdbRotamNewRef = new Vector();
                pdbRotamNewRef.addAll(pdbRotVec);
            }
            if ((double)index[0] < 0.0) {
                index[0] = 0;
            }
            Vector<Pdb> vecSelectedRot = new Vector<Pdb>();
            Pdb pdb_temp = (Pdb)pdbRotamNewStr.elementAt(index[0]);
            vecSelectedRot.add(pdb_temp);
            vecGrowPdb = vecTemp = pp.CombinRotBB(pdbRotamNewRef, vecGrowPdb, resNo);
            ++j;
        }
        return vecGrowPdb;
    }

    public void PrintAllPossibleMappings(Vector vecResonGraph, Vector vecGraph, int[][] Map2) {
        int j = 0;
        while (j < vecGraph.size()) {
            String atomName;
            Node node2 = (Node)vecGraph.elementAt(j);
            int resNo = node2.getResNo();
            String resName = node2.getResName();
            String subAtomName = atomName = node2.getAtomName();
            if (atomName.length() > 2) {
                subAtomName = atomName.substring(0, 2);
            }
            if (!(atomName.equalsIgnoreCase("H") || subAtomName.equalsIgnoreCase("HA") || subAtomName.equalsIgnoreCase("HN"))) {
                System.out.println(String.valueOf(resName) + resNo + "-" + atomName + ":");
                int i = 0;
                while (i < vecResonGraph.size()) {
                    Node node = (Node)vecResonGraph.elementAt(i);
                    double cs_h = node.getProtonCS();
                    double cs_heavy = node.getHeavyCS();
                    if (Map2[i][j] == 1) {
                        System.out.format("        %.3f ,  %.3f%n", cs_h, cs_heavy);
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    public void UpdateStereoSymSet(Vector vecResonGraph, Vector vecGraph, int[][] Map2) {
        Node nodeReson;
        double errHeavy = 0.1;
        Peak pk = new Peak();
        int i = 0;
        while (i < vecResonGraph.size()) {
            nodeReson = (Node)vecResonGraph.elementAt(i);
            nodeReson.vecStereoSymSet = new Vector();
            ++i;
        }
        this.UpdateMappingSet(vecResonGraph, vecGraph, Map2);
        i = 0;
        while (i < vecResonGraph.size()) {
            nodeReson = (Node)vecResonGraph.elementAt(i);
            double cs_proton = nodeReson.getProtonCS();
            double cs_heavy = nodeReson.getHeavyCS();
            Vector vec_sym = nodeReson.vecSymSet;
            Vector vec_map = nodeReson.getMappingSet();
            int t = 0;
            while (t < vec_sym.size()) {
                Node nodeReson2 = (Node)vec_sym.elementAt(t);
                double cs_heavy2 = nodeReson2.getHeavyCS();
                Vector vec_map2 = nodeReson2.getMappingSet();
                boolean isMap = false;
                int k = 0;
                while (k < vec_map.size()) {
                    Node ndProton1 = (Node)vec_map.elementAt(k);
                    String atom1 = ndProton1.getAtomName();
                    String res1 = ndProton1.getResName();
                    String heavyName1 = pk.GetHeavyAtomFromProton(res1, atom1);
                    int w = 0;
                    while (w < vec_map2.size()) {
                        Node ndProton2 = (Node)vec_map2.elementAt(w);
                        String atom2 = ndProton2.getAtomName();
                        String res2 = ndProton2.getResName();
                        String heavyName2 = pk.GetHeavyAtomFromProton(res2, atom2);
                        if (heavyName1.equalsIgnoreCase(heavyName2)) {
                            isMap = true;
                        }
                        ++w;
                    }
                    ++k;
                }
                if (isMap && Math.abs(cs_heavy - cs_heavy2) < errHeavy) {
                    nodeReson.vecStereoSymSet.add(nodeReson2);
                    nodeReson2.vecStereoSymSet.add(nodeReson);
                    nodeReson.stereoID = nodeReson2.getID();
                    nodeReson2.stereoID = nodeReson.getID();
                }
                ++t;
            }
            ++i;
        }
        i = 0;
        while (i < vecResonGraph.size()) {
            nodeReson = (Node)vecResonGraph.elementAt(i);
            Vector vecStereoSet = nodeReson.vecStereoSymSet;
            int k = 0;
            while (k < vecStereoSet.size()) {
                Node nodeStereo = (Node)vecStereoSet.elementAt(k);
                int curID = nodeStereo.getID();
                boolean isInPre = false;
                int t = 0;
                while (t < vecStereoSet.size()) {
                    Node nodeTemp = (Node)vecStereoSet.elementAt(t);
                    if (t != k && nodeTemp.getID() == curID) {
                        isInPre = true;
                    }
                    ++t;
                }
                if (isInPre) {
                    vecStereoSet.remove(k);
                    --k;
                }
                ++k;
            }
            ++i;
        }
    }

    public void UpdateIsRestrained(Vector vecResonGraph, Vector vecGraph, int[][] Map2) {
        int i = 0;
        while (i < vecResonGraph.size()) {
            Node nodeReson = (Node)vecResonGraph.elementAt(i);
            if (nodeReson.getMappingSet().size() < 5) {
                nodeReson.setIsRestrained(true);
            }
            ++i;
        }
    }

    public void UpdateMappingSet(Vector vecResonGraph, Vector vecGraph, int[][] Map2) {
        Node nodeReson;
        int i = 0;
        while (i < vecResonGraph.size()) {
            nodeReson = (Node)vecResonGraph.elementAt(i);
            nodeReson.EmptyMappingSet();
            ++i;
        }
        int j = 0;
        while (j < vecGraph.size()) {
            Node nodeStruct = (Node)vecGraph.elementAt(j);
            nodeStruct.EmptyMappingSet();
            ++j;
        }
        i = 0;
        while (i < vecResonGraph.size()) {
            nodeReson = (Node)vecResonGraph.elementAt(i);
            int resonId = nodeReson.getID();
            j = 0;
            while (j < vecGraph.size()) {
                Node nodeStruct = (Node)vecGraph.elementAt(j);
                if (Map2[i][j] == 1) {
                    nodeReson.addMappingNode(nodeStruct);
                    nodeStruct.addMappingNode(nodeReson);
                }
                ++j;
            }
            ++i;
        }
    }

    public void RefineMappingBasedNeighbor(Vector vecResonGraph, Vector vecGraph, int[][] Map2) {
        Nasca isoGraph = new Nasca();
        int i = 0;
        while (i < vecResonGraph.size()) {
            Node node = (Node)vecResonGraph.elementAt(i);
            Vector vecAdj = node.getAdjVec();
            boolean isAssigned = node.getIsAssigned();
            if (!isAssigned) {
                Vector vecNeighborSC = new Vector();
                int j = 0;
                while (j < vecGraph.size()) {
                    String atomName;
                    if (i == 218 && j == 3) {
                        System.out.println("stop here...");
                    }
                    Node node2 = (Node)vecGraph.elementAt(j);
                    String resName = node2.getResName();
                    String subAtom = atomName = node2.getAtomName();
                    if (atomName.length() > 2) {
                        subAtom = atomName.substring(0, 2);
                    }
                    int threshold = 0;
                    threshold = resName.equalsIgnoreCase("GLN") && subAtom.equalsIgnoreCase("HG") ? 16 : (resName.equalsIgnoreCase("GLN") && subAtom.equalsIgnoreCase("HE") ? 2 : (resName.equalsIgnoreCase("GLU") && subAtom.equalsIgnoreCase("HG") ? 11 : (resName.equalsIgnoreCase("TRP") ? 6 : (resName.equalsIgnoreCase("PHE") && subAtom.equalsIgnoreCase("HE") ? 4 : 1))));
                    if (resName.equalsIgnoreCase("LEU") && atomName.equalsIgnoreCase("HG")) {
                        threshold = 1;
                    }
                    Vector vecAdj2 = node2.getAdjVec();
                    boolean isMapped = false;
                    if (subAtom.equalsIgnoreCase("HB")) {
                        threshold = 1;
                    }
                    if (subAtom.equalsIgnoreCase("HG")) {
                        if (resName.equalsIgnoreCase("GLU")) {
                            threshold = 15;
                        }
                        if (resName.equalsIgnoreCase("LYS")) {
                            threshold = 15;
                        }
                        if (resName.equalsIgnoreCase("LEU")) {
                            threshold = 9;
                        }
                        if (resName.equalsIgnoreCase("MET")) {
                            threshold = 15;
                        }
                        if (resName.equalsIgnoreCase("PRO")) {
                            threshold = 15;
                        }
                        if (resName.equalsIgnoreCase("GLN")) {
                            threshold = 11;
                        }
                        if (resName.equalsIgnoreCase("VAL")) {
                            threshold = 15;
                        }
                        if (resName.equalsIgnoreCase("ARG")) {
                            threshold = 5;
                        }
                        if (resName.equalsIgnoreCase("THR")) {
                            threshold = 5;
                        }
                        if (resName.equalsIgnoreCase("ILE")) {
                            threshold = 5;
                        }
                    }
                    threshold = 0;
                    if (vecAdj.size() < 1 || vecAdj2.size() < 1) {
                        System.out.println("debugging...we found an empty neiborhood...");
                    } else {
                        double[] neighborSC = new double[1];
                        isMapped = isoGraph.isMappedBetwTwoSets(vecAdj, vecAdj2, Map2, false, threshold, neighborSC);
                        if (!isMapped) {
                            Map2[i][j] = 0;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void Initialization(Vector vecResonGraph, Vector vecGraph, int[][] Map2, double[][] MapScore, Vector vecBBAsg) {
        Node node;
        int j;
        double errCB = 0.25;
        Peak pk = new Peak();
        int i = 0;
        while (i < vecResonGraph.size()) {
            j = 0;
            while (j < vecGraph.size()) {
                Map2[i][j] = 1;
                MapScore[i][j] = -9999.9;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < vecResonGraph.size()) {
            node = (Node)vecResonGraph.elementAt(i);
            boolean isAsged = node.getIsAssigned();
            if (isAsged) {
                int resNo = node.getResNo();
                String atomName = node.getAtomName();
                j = 0;
                while (j < vecGraph.size()) {
                    Node nodeStruct = (Node)vecGraph.elementAt(j);
                    int resNoStruct = nodeStruct.getResNo();
                    String atomNameStuct = nodeStruct.getAtomName();
                    String resNameStruct = nodeStruct.getResName();
                    String subAtomNameStruct = atomNameStuct;
                    if (atomNameStuct.length() > 2) {
                        subAtomNameStruct = atomNameStuct.substring(0, 2);
                    }
                    if (resNoStruct == resNo && atomNameStuct.equalsIgnoreCase(atomName) || resNoStruct == resNo && resNameStruct.equalsIgnoreCase("GLY") && subAtomNameStruct.equalsIgnoreCase(atomName)) {
                        if (nodeStruct.id == 56) {
                            System.out.println("debugging..");
                        }
                        if (node.getIsAssigned()) {
                            nodeStruct.setIsAssigned(true);
                        }
                        Map2[i][j] = 1;
                        node.asgedId = j;
                        nodeStruct.asgedId = i;
                        int k = 0;
                        while (k < vecResonGraph.size()) {
                            if (k != i) {
                                Map2[k][j] = 0;
                            }
                            ++k;
                        }
                    } else {
                        Map2[i][j] = 0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < vecResonGraph.size()) {
            node = (Node)vecResonGraph.elementAt(i);
            double cs_heavy = node.getHeavyCS();
            boolean isAsged = node.getIsAssigned();
            if (!isAsged) {
                int resNo = node.getResNo();
                String atomName = node.getAtomName();
                j = 0;
                while (j < vecGraph.size()) {
                    Node nodeStruct = (Node)vecGraph.elementAt(j);
                    double csHeavyStruct = 0.0;
                    int resNoStruct = nodeStruct.getResNo();
                    String atomNameStuct = nodeStruct.getAtomName();
                    String resNameStruct = nodeStruct.getResName();
                    String subAtomNameStruct = atomNameStuct;
                    String heavyNameStruct = pk.GetHeavyAtomFromProton(resNameStruct, atomNameStuct);
                    if (atomNameStuct.length() > 2) {
                        subAtomNameStruct = atomNameStuct.substring(0, 2);
                    }
                    if (subAtomNameStruct.equalsIgnoreCase("HB") && heavyNameStruct.equalsIgnoreCase("CB")) {
                        int k = 0;
                        while (k < vecBBAsg.size()) {
                            H1CS h1cs = (H1CS)vecBBAsg.elementAt(k);
                            String CB_atom = h1cs.getAtomName();
                            int CB_resNo = h1cs.getResidueNo();
                            if (CB_atom.equalsIgnoreCase("CB") && CB_resNo == resNoStruct && CB_atom.equalsIgnoreCase("CB")) {
                                csHeavyStruct = h1cs.getH1CS();
                            }
                            ++k;
                        }
                        Map2[i][j] = Math.abs(csHeavyStruct - cs_heavy) < errCB ? 1 : 0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        j = 0;
        while (j < vecGraph.size()) {
            Node ndProton = (Node)vecGraph.elementAt(j);
            String atom = ndProton.getAtomName();
            String res = ndProton.getResName();
            String heavy = pk.GetHeavyAtomFromProton(res, atom);
            int resNo = ndProton.getResNo();
            int k = 0;
            while (k < vecGraph.size()) {
                if (j != k) {
                    Node ndProton2 = (Node)vecGraph.elementAt(k);
                    String atom2 = ndProton2.getAtomName();
                    String res2 = ndProton2.getResName();
                    String heavy2 = pk.GetHeavyAtomFromProton(res2, atom2);
                    int resNo2 = ndProton2.getResNo();
                    if (heavy.equalsIgnoreCase(heavy2) && resNo == resNo2) {
                        ndProton.stereoID = k;
                        ndProton2.stereoID = j;
                    }
                }
                ++k;
            }
            ++j;
        }
    }

    public void RefineMappingBasedBMRBOutliers(Vector vecResonGraph, Vector vecGraph, int[][] Map2, Vector vecBMRBNew) {
        Peak pk = new Peak();
        int i = 0;
        while (i < vecResonGraph.size()) {
            Node node = (Node)vecResonGraph.elementAt(i);
            double csH = node.getProtonCS();
            double csHeavy = node.getHeavyCS();
            boolean isAsged = node.getIsAssigned();
            if (!isAsged) {
                int j = 0;
                while (j < vecGraph.size()) {
                    String atomName;
                    Node node2 = (Node)vecGraph.elementAt(j);
                    String resName = node2.getResName();
                    String subAtomName = atomName = node2.getAtomName();
                    if (Math.abs(csH - 7.173) < 0.04 && Math.abs(csHeavy - 133.407) < 0.4 && node2.getResNo() == 3 && atomName.equalsIgnoreCase("HD1")) {
                        System.out.println("stop here...");
                    }
                    String heavyName = pk.GetHeavyAtomFromProton(resName, atomName);
                    int k = 0;
                    while (k < vecBMRBNew.size()) {
                        H1CS h1csB = (H1CS)vecBMRBNew.elementAt(k);
                        String resB = h1csB.getResidueType();
                        String atomB = h1csB.getAtomName();
                        double cs_L = h1csB.getCSLower();
                        double cs_U = h1csB.getCSUpper();
                        subAtomName = atomName;
                        if (subAtomName.length() > atomB.length()) {
                            subAtomName = atomName.substring(0, atomB.length());
                        }
                        if (resB.equalsIgnoreCase(resName) && atomB.equalsIgnoreCase(subAtomName) && atomB.substring(0, 1).equalsIgnoreCase("H") && (csH < cs_L || csH > cs_U)) {
                            Map2[i][j] = 0;
                        }
                        if (resB.equalsIgnoreCase(resName) && atomB.equalsIgnoreCase(heavyName) && (csHeavy < cs_L || csHeavy > cs_U)) {
                            Map2[i][j] = 0;
                        }
                        ++k;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void RefineMappingBasedRotPattern(Vector vecResonGraph, Vector vecGraph, int[][] Map2) {
        String heavy;
        String res;
        String atom;
        Node ndProton;
        Peak pk = new Peak();
        this.UpdateStereoSymSet(vecResonGraph, vecGraph, Map2);
        int j = 0;
        while (j < vecGraph.size()) {
            ndProton = (Node)vecGraph.elementAt(j);
            atom = ndProton.getAtomName();
            res = ndProton.getResName();
            heavy = pk.GetHeavyAtomFromProton(res, atom);
            int resNo = ndProton.getResNo();
            int k = 0;
            while (k < vecGraph.size()) {
                if (j != k) {
                    Node ndProton2 = (Node)vecGraph.elementAt(k);
                    String atom2 = ndProton2.getAtomName();
                    String res2 = ndProton2.getResName();
                    String heavy2 = pk.GetHeavyAtomFromProton(res2, atom2);
                    int resNo2 = ndProton2.getResNo();
                    if (heavy.equalsIgnoreCase(heavy2) && resNo == resNo2) {
                        ndProton.stereoID = k;
                        ndProton2.stereoID = j;
                    }
                }
                ++k;
            }
            ++j;
        }
        j = 0;
        while (j < vecGraph.size()) {
            ndProton = (Node)vecGraph.elementAt(j);
            atom = ndProton.getAtomName();
            res = ndProton.getResName();
            heavy = pk.GetHeavyAtomFromProton(res, atom);
            Vector vecMapSet = ndProton.getMappingSet();
            if (heavy.equalsIgnoreCase("CB")) {
                boolean isStereoSym = false;
                Vector vecStereoSym = new Vector();
                int k = 0;
                while (k < vecMapSet.size()) {
                    Node ndMapReson = (Node)vecMapSet.elementAt(k);
                    if (ndMapReson.vecStereoSymSet.size() > 1) {
                        isStereoSym = true;
                    }
                    vecStereoSym.addAll(ndMapReson.vecStereoSymSet);
                    ++k;
                }
                if (isStereoSym) {
                    int id;
                    int i;
                    if (ndProton.stereoID >= 0) {
                        i = 0;
                        while (i < vecResonGraph.size()) {
                            if (Map2[i][j] != 0) {
                                boolean isInStereoSym = false;
                                int k2 = 0;
                                while (k2 < vecStereoSym.size()) {
                                    Node ndStereoSym = (Node)vecStereoSym.elementAt(k2);
                                    id = ndStereoSym.getID();
                                    if (id == i) {
                                        isInStereoSym = true;
                                    }
                                    ++k2;
                                }
                                if (!isInStereoSym) {
                                    Map2[i][j] = 0;
                                    Map2[i][ndProton.stereoID] = 0;
                                }
                            }
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < vecResonGraph.size()) {
                            if (Map2[i][j] != 0) {
                                boolean isInStereoSym = false;
                                int k3 = 0;
                                while (k3 < vecStereoSym.size()) {
                                    Node ndStereoSym = (Node)vecStereoSym.elementAt(k3);
                                    id = ndStereoSym.getID();
                                    if (id == i) {
                                        isInStereoSym = true;
                                    }
                                    ++k3;
                                }
                                if (isInStereoSym) {
                                    Map2[i][j] = 0;
                                }
                            }
                            ++i;
                        }
                    }
                }
            }
            ++j;
        }
    }

    public void RefineMappingBasedAsg(Vector vecResonGraph, Vector vecGraph, int[][] Map2, double[][] MapScore, Vector vecNewNoesy, Vector vecBMRBNew) {
        int j;
        int sizeReson = 5;
        int sizeStruct = 5;
        Nasca isoGraph = new Nasca();
        Peak pk = new Peak();
        int i = 0;
        while (i < vecResonGraph.size()) {
            Node node = (Node)vecResonGraph.elementAt(i);
            double cs_proton = node.getProtonCS();
            double cs_heavy = node.getHeavyCS();
            Vector vecAdj = node.getAdjVec();
            boolean isAssigned = node.getIsAssigned();
            if (!isAssigned) {
                double maxMapping = 0.0;
                Vector<RotaPattern> vecNeighborSC = new Vector<RotaPattern>();
                j = 0;
                while (j < vecGraph.size()) {
                    if (i == 284 && j == 24) {
                        System.out.println("stop here...");
                    }
                    if (Map2[i][j] != 0) {
                        String heavyName;
                        String atomName;
                        Node node2 = (Node)vecGraph.elementAt(j);
                        String resName = node2.getResName();
                        String subAtom = atomName = node2.getAtomName();
                        if (atomName.length() > 2) {
                            subAtom = atomName.substring(0, 2);
                        }
                        if (Math.abs(cs_proton - 2.016) < 0.05 && Math.abs(cs_heavy - 34.446) < 0.5 && node2.getResNo() == 10 && atomName.equalsIgnoreCase("HB")) {
                            System.out.println("stop here...");
                        }
                        if ((heavyName = pk.GetHeavyAtomFromProton(resName, atomName)).substring(0, 1).equalsIgnoreCase("N") || heavyName.substring(0, 1).equalsIgnoreCase("C")) {
                            int threshold = 0;
                            Vector vecAdj2 = node2.getAdjVec();
                            boolean isMapped = false;
                            if (vecAdj.size() < 1 || vecAdj2.size() < 1) {
                                System.out.println("debugging...we found an empty neiborhood...");
                            } else {
                                double[] neighborSC = new double[1];
                                isMapped = isoGraph.isMappedBetwTwoSetsCalScore(node, node2, vecAdj, vecAdj2, Map2, true, threshold, neighborSC, vecNewNoesy);
                                RotaPattern rp = new RotaPattern(j, neighborSC[0]);
                                vecNeighborSC.add(rp);
                            }
                        }
                    }
                    ++j;
                }
                int h = 0;
                while (h < vecNeighborSC.size()) {
                    RotaPattern rotPatn = (RotaPattern)vecNeighborSC.elementAt(h);
                    Node node2 = (Node)vecGraph.elementAt(rotPatn.getResNo());
                    String resName = node2.getResName();
                    String atomName = node2.getAtomName();
                    int resNo = node2.getResNo();
                    Vector<H1CS> vecOneAsg = new Vector<H1CS>();
                    String heavyName = pk.GetHeavyAtomFromProton(resName, atomName);
                    vecOneAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
                    vecOneAsg.add(new H1CS(resNo, resName, heavyName, cs_heavy));
                    int graph_ID = rotPatn.getResNo();
                    double sc = rotPatn.getScore();
                    H1CS h1cs = new H1CS();
                    double asgScore = h1cs.BMRBSatisticsScore(vecOneAsg, vecBMRBNew);
                    double asg_log = Math.log(asgScore);
                    double noe_log = Math.log(sc);
                    if (asg_log < -10000.0) {
                        asg_log = -1000.0;
                    }
                    if (noe_log < -10000.0) {
                        noe_log = -10000.0;
                    }
                    double Score = 0.2 * asg_log + noe_log;
                    rotPatn.setScore(Score);
                    MapScore[i][graph_ID] = Score;
                    ++h;
                }
                Collections.sort(vecNeighborSC, new RotaPattern.scoreComparator());
                j = 0;
                while (j < vecGraph.size()) {
                    boolean isIn = false;
                    int h2 = 0;
                    while (h2 < Math.min(sizeReson, vecNeighborSC.size())) {
                        RotaPattern rotPatn = (RotaPattern)vecNeighborSC.elementAt(h2);
                        int graph_ID = rotPatn.getResNo();
                        if (j == graph_ID) {
                            isIn = true;
                        }
                        ++h2;
                    }
                    if (!isIn) {
                        Map2[i][j] = 0;
                    }
                    ++j;
                }
            }
            ++i;
        }
        j = 0;
        while (j < vecGraph.size()) {
            Node nodeStruct = (Node)vecGraph.elementAt(j);
            Vector<RotaPattern> vecNeighborSC = new Vector<RotaPattern>();
            i = 0;
            while (i < vecResonGraph.size()) {
                if (Map2[i][j] != 0) {
                    RotaPattern rp = new RotaPattern(i, MapScore[i][j]);
                    vecNeighborSC.add(rp);
                }
                ++i;
            }
            Collections.sort(vecNeighborSC, new RotaPattern.scoreComparator());
            i = 0;
            while (i < vecResonGraph.size()) {
                boolean isIn = false;
                int h = 0;
                while (h < Math.min(sizeStruct, vecNeighborSC.size())) {
                    RotaPattern rotPatn = (RotaPattern)vecNeighborSC.elementAt(h);
                    int graph_ID = rotPatn.getResNo();
                    if (i == graph_ID) {
                        isIn = true;
                    }
                    ++h;
                }
                if (!isIn) {
                    Map2[i][j] = 0;
                }
                ++i;
            }
            ++j;
        }
    }

    public void RefineMappingBasedRestrained(Vector vecResonGraph, Vector vecGraph, int[][] Map2, double[][] MapScore, Vector vecNewNoesy, Vector vecBMRBNew) {
        int sizeReson = 2;
        int sizeStruct = 2;
        int restrainThreshold = 5;
        Nasca isoGraph = new Nasca();
        Peak pk = new Peak();
        H1CS h1cs = new H1CS();
        this.UpdateStereoSymSet(vecResonGraph, vecGraph, Map2);
        int j = 0;
        while (j < vecGraph.size()) {
            Node node2 = (Node)vecGraph.elementAt(j);
            String resName = node2.getResName();
            String atomName = node2.getAtomName();
            int resNo = node2.getResNo();
            boolean isRestrained = false;
            if (!node2.getIsAssigned()) {
                if (resNo == 3 && atomName.equalsIgnoreCase("HB2")) {
                    System.out.println("debugging...");
                }
                String subAtom = atomName;
                if (atomName.length() >= 2) {
                    subAtom = atomName.substring(0, 2);
                }
                if (subAtom.equalsIgnoreCase("HB")) {
                    sizeReson = node2.stereoID >= 0 ? 1 : 1;
                    Vector<RotaPattern> vecNeighborSC = new Vector<RotaPattern>();
                    int i = 0;
                    while (i < vecResonGraph.size()) {
                        if (Map2[i][j] != 0) {
                            Node node = (Node)vecResonGraph.elementAt(i);
                            double cs_proton = node.getProtonCS();
                            double cs_heavy = node.getHeavyCS();
                            Vector vecAdj = node.getAdjVec();
                            boolean isAssigned = node.getIsAssigned();
                            if (!isAssigned) {
                                String heavyName;
                                if (Math.abs(cs_proton - 0.884) < 0.04 && Math.abs(cs_heavy - 27.019) < 0.4 && node2.getResNo() == 5 && atomName.equalsIgnoreCase("HG")) {
                                    System.out.println("stop here...");
                                }
                                if (j == 2 && i == 305) {
                                    System.out.println("stop here...");
                                }
                                if ((heavyName = pk.GetHeavyAtomFromProton(resName, atomName)).substring(0, 1).equalsIgnoreCase("N") || heavyName.substring(0, 1).equalsIgnoreCase("C")) {
                                    Vector vecAdj2 = node2.getAdjVec();
                                    if (vecAdj.size() < 1 || vecAdj2.size() < 1) {
                                        System.out.println("debugging...we found an empty neiborhood...");
                                    } else {
                                        double[] neighborSC = new double[1];
                                        boolean isRestrainTemp = false;
                                        isRestrainTemp = isoGraph.isMappedBetwTwoSetsCalScore(node, node2, vecAdj, vecAdj2, Map2, true, restrainThreshold, neighborSC, vecNewNoesy);
                                        Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
                                        vecOneSCAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
                                        vecOneSCAsg.add(new H1CS(resNo, resName, heavyName, cs_heavy));
                                        double asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsg, vecBMRBNew);
                                        neighborSC[0] = neighborSC[0] + asgScore;
                                        MapScore[i][j] = neighborSC[0];
                                        if (isRestrainTemp) {
                                            isRestrained = true;
                                        }
                                        RotaPattern rp = new RotaPattern(i, neighborSC[0]);
                                        vecNeighborSC.add(rp);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    node2.setIsRestrained(true);
                    Collections.sort(vecNeighborSC, new RotaPattern.scoreComparator());
                    i = 0;
                    while (i < vecResonGraph.size()) {
                        boolean isIn = false;
                        int h = 0;
                        while (h < Math.min(8, vecNeighborSC.size())) {
                            RotaPattern rotPatn = (RotaPattern)vecNeighborSC.elementAt(h);
                            int graph_ID = rotPatn.getResNo();
                            Node nodeTemp = (Node)vecResonGraph.elementAt(graph_ID);
                            int stereoIDTemp = nodeTemp.stereoID;
                            if (i == graph_ID || i == stereoIDTemp) {
                                isIn = true;
                            }
                            ++h;
                        }
                        if (!isIn) {
                            Map2[i][j] = 0;
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
    }

    public Vector RandomGraphMatching(Vector vecResonGraph, Vector vecGraph, int[][] Map2, double[][] MapScore, Vector vecNewNoesy, Vector vecBMRBNew) {
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        this.UpdateMappingSet(vecResonGraph, vecGraph, Map2);
        Random generator = new Random(198221L);
        int j = 0;
        while (j < vecGraph.size()) {
            Node node2 = (Node)vecGraph.elementAt(j);
            String resName = node2.getResName();
            String atomName = node2.getAtomName();
            int resNo = node2.getResNo();
            boolean isRestrained = false;
            Vector vecMapSet = node2.getMappingSet();
            if (!node2.getIsAssigned()) {
                Node nodeMap;
                boolean isMapAllAsg = true;
                int k = 0;
                while (k < vecMapSet.size()) {
                    nodeMap = (Node)vecMapSet.elementAt(k);
                    if (nodeMap.asgedId < 0) {
                        isMapAllAsg = false;
                    }
                    if (nodeMap.asgedId == node2.stereoID) {
                        isMapAllAsg = false;
                    }
                    ++k;
                }
                if (isMapAllAsg) {
                    System.out.println("Here we found one unassigned proton node...");
                }
                int rdmInt = generator.nextInt(vecMapSet.size());
                nodeMap = (Node)vecMapSet.elementAt(rdmInt);
                node2.asgedId = nodeMap.getID();
                nodeMap.asgedId = node2.getID();
            }
            ++j;
        }
        int nSteps = 200000;
        int count = 0;
        System.out.println("nSteps=" + nSteps);
        while (count < nSteps) {
            int rdmID;
            Node nodeChosen;
            if (count % 1000 == 0) {
                System.out.println("current count=" + count);
            }
            if ((nodeChosen = (Node)vecGraph.elementAt(rdmID = generator.nextInt(vecGraph.size()))).getIsAssigned()) continue;
            Vector vecNoesyTwo = new Vector();
            Node nodeReson = new Node();
            nodeReson = (Node)vecResonGraph.elementAt(nodeChosen.asgedId);
            Vector vecNoesy = nodeReson.vecAdjNOESY;
            vecNoesyTwo.addAll(vecNoesy);
            Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
            Vector vecAdj = nodeChosen.getAdjVec();
            int resNo = -1;
            String res = "";
            String atom = "";
            String heavName = "";
            double cs_proton = -999.9;
            double cs_heavy = -999.9;
            Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
            resNo = nodeChosen.getResNo();
            res = nodeChosen.getResName();
            atom = nodeChosen.getAtomName();
            heavName = pk.GetHeavyAtomFromProton(res, atom);
            cs_proton = nodeReson.getProtonCS();
            cs_heavy = nodeReson.getHeavyCS();
            vecOneSCAsg.add(new H1CS(resNo, res, atom, cs_proton));
            vecOneSCAsg.add(new H1CS(resNo, res, heavName, cs_heavy));
            int k = 0;
            while (k < vecAdj.size()) {
                Node nodeAdj = (Node)vecAdj.elementAt(k);
                Node nodeAdjReson = (Node)vecResonGraph.elementAt(nodeAdj.asgedId);
                int resNoSec = nodeAdj.getResNo();
                String resSec = nodeAdj.getResName();
                String atomSec = nodeAdj.getAtomName();
                String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                double cs_protonSec = nodeAdjReson.getProtonCS();
                double cs_heavySec = nodeAdjReson.getHeavyCS();
                vecOneSCAsg.add(new H1CS(resNoSec, resSec, atomSec, cs_protonSec));
                vecOneSCAsg.add(new H1CS(resNoSec, resSec, heavyNameSec, cs_heavySec));
                vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, 6.0, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, 6.0, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
                ++k;
            }
            Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
            int[] numPeaks = new int[1];
            double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
            Vector<H1CS> vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg);
            double asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew, vecBMRBNew);
            double score_old = dbScore + asgScore;
            vecOneSCAsg = new Vector();
            Vector vecMapSet = nodeChosen.getMappingSet();
            int rdmInt = generator.nextInt(vecMapSet.size());
            Node nodeResonMap = (Node)vecMapSet.elementAt(rdmInt);
            resNo = nodeChosen.getResNo();
            res = nodeChosen.getResName();
            atom = nodeChosen.getAtomName();
            heavName = pk.GetHeavyAtomFromProton(res, atom);
            cs_proton = nodeResonMap.getProtonCS();
            cs_heavy = nodeResonMap.getHeavyCS();
            vecOneSCAsg.add(new H1CS(resNo, res, atom, cs_proton));
            vecOneSCAsg.add(new H1CS(resNo, res, heavName, cs_heavy));
            int k2 = 0;
            while (k2 < vecAdj.size()) {
                Node nodeAdj = (Node)vecAdj.elementAt(k2);
                Node nodeAdjReson = (Node)vecResonGraph.elementAt(nodeAdj.asgedId);
                int resNoSec = nodeAdj.getResNo();
                String resSec = nodeAdj.getResName();
                String atomSec = nodeAdj.getAtomName();
                String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                double cs_protonSec = nodeAdjReson.getProtonCS();
                double cs_heavySec = nodeAdjReson.getHeavyCS();
                vecOneSCAsg.add(new H1CS(resNoSec, resSec, atomSec, cs_protonSec));
                vecOneSCAsg.add(new H1CS(resNoSec, resSec, heavyNameSec, cs_heavySec));
                vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, 6.0, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, 6.0, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
                ++k2;
            }
            vecBackNoeNew = new Vector();
            vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
            dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
            vecOneSCAsgNew = new Vector();
            vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg);
            asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew, vecBMRBNew);
            double score_new = dbScore + asgScore;
            if (score_new > score_old) {
                nodeChosen.asgedId = nodeResonMap.getID();
                nodeResonMap.asgedId = nodeChosen.getID();
            }
            ++count;
        }
        Vector<H1CS> vecAsg = new Vector<H1CS>();
        int j2 = 0;
        while (j2 < vecGraph.size()) {
            Node node2 = (Node)vecGraph.elementAt(j2);
            String resName = node2.getResName();
            String atomName = node2.getAtomName();
            String heavName = pk.GetHeavyAtomFromProton(resName, atomName);
            int resNo = node2.getResNo();
            int resonID = node2.asgedId;
            Node nodeResonAsg = (Node)vecResonGraph.elementAt(resonID);
            double cs_proton = nodeResonAsg.getProtonCS();
            double cs_heavy = nodeResonAsg.getHeavyCS();
            vecAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
            vecAsg.add(new H1CS(resNo, resName, heavName, cs_heavy));
            ++j2;
        }
        return vecAsg;
    }

    public Vector GreedyGraphMatchingResidue(Vector vecResonGraph, Vector vecGraph, int[][] Map2, double[][] MapScore, Vector vecNewNoesy, Vector vecBMRBNew) {
        int maxResID;
        boolean isAllAsg;
        int maxResNo = 300;
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Noesy noesy = new Noesy();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        boolean[] isResidueAsg = new boolean[maxResNo];
        Vector vecResidueGraph = new Vector();
        int k = 0;
        while (k < maxResNo) {
            isResidueAsg[k] = false;
            Vector<Node> vecCurRes = new Vector<Node>();
            int j = 0;
            while (j < vecGraph.size()) {
                Node node2 = (Node)vecGraph.elementAt(j);
                int resNo = node2.getResNo();
                if (resNo == k) {
                    vecCurRes.add(node2);
                }
                ++j;
            }
            if (vecCurRes.size() > 0) {
                vecResidueGraph.add(vecCurRes);
            }
            ++k;
        }
        do {
            this.UpdateMappingSet(vecResonGraph, vecGraph, Map2);
            isAllAsg = true;
            double maxScore = -99999.9;
            maxResID = -1;
            int maxMapID = -1;
            int w = 0;
            while (w < vecResidueGraph.size()) {
                if (!isResidueAsg[w]) {
                    isAllAsg = false;
                    Vector vecCurResidue = (Vector)vecResidueGraph.elementAt(w);
                    Vector vecAllSCAsgs = this.EnumAllScAsgSaveIntoFile(vecCurResidue, vecResonGraph, vecGraph);
                    int x = 0;
                    while (x < vecAllSCAsgs.size()) {
                        Vector<H1CS> vecOneSCAsgNew;
                        double asgScore;
                        Vector vecOneAsg = (Vector)vecAllSCAsgs.elementAt(x);
                        Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
                        vecOneSCAsg.addAll(vecOneAsg);
                        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
                        Vector<Noesy> vecNoesyTwo = new Vector<Noesy>();
                        int a = 0;
                        while (a < vecOneAsg.size()) {
                            H1CS h1csCur = (H1CS)vecOneAsg.elementAt(a);
                            Node nodeProton = (Node)vecGraph.elementAt(h1csCur.protonID);
                            Node nodeReson = (Node)vecResonGraph.elementAt(h1csCur.resonID);
                            Vector vecAdj = nodeProton.getAdjVec();
                            int resNo = nodeProton.getResNo();
                            String res = nodeProton.getResName();
                            String atom = nodeProton.getAtomName();
                            String heavName = pk.GetHeavyAtomFromProton(res, atom);
                            double cs_proton = nodeReson.getProtonCS();
                            double cs_heavy = nodeReson.getHeavyCS();
                            Vector vecNoesy = nodeReson.vecAdjNOESY;
                            vecNoesyTwo.addAll(vecNoesy);
                            int t = 0;
                            while (t < vecAdj.size()) {
                                Node nodeAdj = (Node)vecAdj.elementAt(t);
                                if (nodeAdj.getIsAssigned()) {
                                    Node nodeAdjReson = (Node)vecResonGraph.elementAt(nodeAdj.asgedId);
                                    Vector vecNoesy2 = nodeAdjReson.vecAdjNOESY;
                                    int resNoSec = nodeAdj.getResNo();
                                    String resSec = nodeAdj.getResName();
                                    String atomSec = nodeAdj.getAtomName();
                                    String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                                    double cs_protonSec = nodeAdjReson.getProtonCS();
                                    double cs_heavySec = nodeAdjReson.getHeavyCS();
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, atomSec, cs_protonSec));
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, heavyNameSec, cs_heavySec));
                                    vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, 6.0, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                                    vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, 6.0, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
                                }
                                ++t;
                            }
                            ++a;
                        }
                        Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                        Vector<Noesy> vecNoesyTwoNew = noesy.DeleteRepeatedNoesy3D(vecNoesyTwo);
                        int[] numPeaks = new int[1];
                        double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwoNew, numPeaks, true);
                        double score = (dbScore *= (double)vecBackNoeNew.size()) + (asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg), vecBMRBNew));
                        if (score > maxScore) {
                            maxScore = score;
                            maxResID = w;
                            maxMapID = x;
                        }
                        ++x;
                    }
                }
                ++w;
            }
            Vector vecCurResidue = (Vector)vecResidueGraph.elementAt(maxResID);
            Vector vecAllSCAsgs = this.EnumAllScAsgSaveIntoFile(vecCurResidue, vecResonGraph, vecGraph);
            Vector vecOneAsg = (Vector)vecAllSCAsgs.elementAt(maxMapID);
            int a = 0;
            while (a < vecOneAsg.size()) {
                H1CS h1csCur = (H1CS)vecOneAsg.elementAt(a);
                Node nodeProton = (Node)vecGraph.elementAt(h1csCur.protonID);
                Node nodeReson = (Node)vecResonGraph.elementAt(h1csCur.resonID);
                nodeProton.asgedId = nodeReson.getID();
                nodeReson.asgedId = nodeProton.getID();
                int i = 0;
                while (i < vecResonGraph.size()) {
                    Map2[i][nodeProton.getID()] = i == nodeProton.asgedId ? 1 : 0;
                    ++i;
                }
                int j = 0;
                while (j < vecGraph.size()) {
                    Map2[nodeReson.getID()][j] = j == nodeReson.asgedId ? 1 : 0;
                    ++j;
                }
                nodeProton.setIsAssigned(true);
                nodeReson.setIsAssigned(true);
                System.out.println(String.valueOf(nodeProton.getResNo()) + nodeProton.getResName() + " - " + nodeProton.getAtomName() + ": " + nodeReson.getProtonCS() + " , " + nodeReson.getHeavyCS());
                ++a;
            }
            System.out.println("---------------------");
        } while (!isAllAsg && maxResID >= 0);
        Vector<H1CS> vecAsg = new Vector<H1CS>();
        int j = 0;
        while (j < vecGraph.size()) {
            Node node2 = (Node)vecGraph.elementAt(j);
            String resName = node2.getResName();
            String atomName = node2.getAtomName();
            String heavName = pk.GetHeavyAtomFromProton(resName, atomName);
            int resNo = node2.getResNo();
            int resonID = node2.asgedId;
            if (resonID >= 0) {
                Node nodeResonAsg = (Node)vecResonGraph.elementAt(resonID);
                double cs_proton = nodeResonAsg.getProtonCS();
                double cs_heavy = nodeResonAsg.getHeavyCS();
                vecAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
                vecAsg.add(new H1CS(resNo, resName, heavName, cs_heavy));
            }
            ++j;
        }
        return vecAsg;
    }

    public void RefineMappingDeeCut(Vector vecResonGraph, Vector vecHPositions, int[][] Map2, double[][] MapScore, Vector vecNewNoesy, Vector vecBMRBNew) {
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        Noesy noesy = new Noesy();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        int counter = 0;
        int j = 0;
        while (j < vecHPositions.size()) {
            Node nodeProton = (Node)vecHPositions.elementAt(j);
            if (!nodeProton.getIsAssigned()) {
                String res = nodeProton.getResName();
                String atom = nodeProton.getAtomName();
                String heavyName = pk.GetHeavyAtomFromProton(res, atom);
                int resNo = nodeProton.getResNo();
                Vector vecMapSet = nodeProton.getMappingSet();
                Vector vecAdj = nodeProton.getAdjVec();
                if (vecMapSet.size() >= 1 && vecAdj.size() >= 1 && !nodeProton.getIsAssigned()) {
                    int k = 0;
                    while (k < vecMapSet.size()) {
                        double asgScore;
                        Node ndMapCur = (Node)vecMapSet.elementAt(k);
                        boolean isPruned = false;
                        double csCur_proton = ndMapCur.getProtonCS();
                        double csCur_heavy = ndMapCur.getHeavyCS();
                        Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
                        vecOneSCAsg.add(new H1CS(resNo, res, atom, csCur_proton));
                        vecOneSCAsg.add(new H1CS(resNo, res, heavyName, csCur_heavy));
                        double totalCurScore = asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsg, vecBMRBNew);
                        int t = 0;
                        while (t < vecAdj.size()) {
                            Vector vecNdCurAdjMap;
                            Node ndCurAdj = (Node)vecAdj.elementAt(t);
                            if (!ndCurAdj.getIsAssigned() && (vecNdCurAdjMap = ndCurAdj.getMappingSet()).size() >= 1) {
                                int resNoAdj = ndCurAdj.getResNo();
                                String resAdj = ndCurAdj.getResName();
                                String atomAdj = ndCurAdj.getAtomName();
                                String heavyNameAdj = pk.GetHeavyAtomFromProton(resAdj, atomAdj);
                                int maxAdjID = -1;
                                double maxScore = -9999.9;
                                Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
                                int a = 0;
                                while (a < vecNdCurAdjMap.size()) {
                                    Node ndAdjMap = (Node)vecNdCurAdjMap.elementAt(a);
                                    Vector vecNoesyTwo = new Vector();
                                    vecNoesyTwo.addAll(ndMapCur.vecAdjNOESY);
                                    vecNoesyTwo.addAll(ndAdjMap.vecAdjNOESY);
                                    double csAdjMapProton = ndAdjMap.getProtonCS();
                                    double csAdjMapHeavy = ndAdjMap.getHeavyCS();
                                    vecBackNoe.add(new BackNoe(csCur_proton, csCur_heavy, csAdjMapProton, 6.0, 0.0, resNo, resNoAdj, res, resAdj, atom, heavyName, atomAdj));
                                    vecBackNoe.add(new BackNoe(csAdjMapProton, csAdjMapHeavy, csCur_proton, 6.0, 0.0, resNoAdj, resNo, resAdj, res, atomAdj, heavyNameAdj, atom));
                                    Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                                    int[] numPeaks = new int[1];
                                    double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                                    dbScore *= (double)vecBackNoeNew.size();
                                    if (dbScore > maxScore) {
                                        maxScore = dbScore;
                                        maxAdjID = a;
                                    }
                                    ++a;
                                }
                                totalCurScore += maxScore;
                            }
                            ++t;
                        }
                        int h = 0;
                        while (h < vecMapSet.size()) {
                            if (h != k) {
                                double asgOtherScore;
                                Node ndMapCurOther = (Node)vecMapSet.elementAt(h);
                                double csOther_proton = ndMapCurOther.getProtonCS();
                                double csOther_heavy = ndMapCurOther.getHeavyCS();
                                Vector<H1CS> vecOneSCAsgOther = new Vector<H1CS>();
                                vecOneSCAsgOther.add(new H1CS(resNo, res, atom, csOther_proton));
                                vecOneSCAsgOther.add(new H1CS(resNo, res, heavyName, csOther_heavy));
                                double totalOtherScore = asgOtherScore = h1cs.BMRBSatisticsScore(vecOneSCAsgOther, vecBMRBNew);
                                int t2 = 0;
                                while (t2 < vecAdj.size()) {
                                    Vector vecNdCurAdjMap;
                                    Node ndCurAdj = (Node)vecAdj.elementAt(t2);
                                    if (!ndCurAdj.getIsAssigned() && (vecNdCurAdjMap = ndCurAdj.getMappingSet()).size() >= 1) {
                                        int resNoAdj = ndCurAdj.getResNo();
                                        String resAdj = ndCurAdj.getResName();
                                        String atomAdj = ndCurAdj.getAtomName();
                                        String heavyNameAdj = pk.GetHeavyAtomFromProton(resAdj, atomAdj);
                                        int minAdjID = -1;
                                        double minScore = 999999.9;
                                        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
                                        int a = 0;
                                        while (a < vecNdCurAdjMap.size()) {
                                            Node ndAdjMap = (Node)vecNdCurAdjMap.elementAt(a);
                                            Vector vecNoesyTwo = new Vector();
                                            vecNoesyTwo.addAll(ndMapCurOther.vecAdjNOESY);
                                            vecNoesyTwo.addAll(ndAdjMap.vecAdjNOESY);
                                            double csAdjMapProton = ndAdjMap.getProtonCS();
                                            double csAdjMapHeavy = ndAdjMap.getHeavyCS();
                                            vecBackNoe.add(new BackNoe(csCur_proton, csCur_heavy, csAdjMapProton, 6.0, 0.0, resNo, resNoAdj, res, resAdj, atom, heavyName, atomAdj));
                                            vecBackNoe.add(new BackNoe(csAdjMapProton, csAdjMapHeavy, csCur_proton, 6.0, 0.0, resNoAdj, resNo, resAdj, res, atomAdj, heavyNameAdj, atom));
                                            Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                                            int[] numPeaks = new int[1];
                                            double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                                            dbScore *= (double)vecBackNoeNew.size();
                                            if (dbScore < minScore) {
                                                minScore = dbScore;
                                                minAdjID = a;
                                            }
                                            ++a;
                                        }
                                        totalOtherScore += minScore;
                                    }
                                    ++t2;
                                }
                                if (totalCurScore < totalOtherScore) {
                                    isPruned = true;
                                    break;
                                }
                            }
                            ++h;
                        }
                        if (isPruned) {
                            Map2[ndMapCur.getID()][nodeProton.getID()] = 0;
                            ++counter;
                        }
                        ++k;
                    }
                }
            }
            ++j;
        }
        System.out.println("Total number of mappings pruned by DEE-CUT is: " + counter);
    }

    public void RefineMappingDeeCutGoldstein(Vector vecResonGraph, Vector vecGraph, int[][] Map2, double[][] MapScore, Vector vecNewNoesy, Vector vecBMRBNew) {
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        Noesy noesy = new Noesy();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        int counter = 0;
        int j = 0;
        while (j < vecGraph.size()) {
            Node nodeProton = (Node)vecGraph.elementAt(j);
            if (!nodeProton.getIsAssigned()) {
                String res = nodeProton.getResName();
                String atom = nodeProton.getAtomName();
                String heavyName = pk.GetHeavyAtomFromProton(res, atom);
                int resNo = nodeProton.getResNo();
                Vector vecMapSet = nodeProton.getMappingSet();
                Vector vecAdj = nodeProton.getAdjVec();
                if (vecMapSet.size() >= 1 && vecAdj.size() >= 1 && !nodeProton.getIsAssigned()) {
                    int k = 0;
                    while (k < vecMapSet.size()) {
                        double asgScore;
                        Node ndMapCur = (Node)vecMapSet.elementAt(k);
                        boolean isPruned = false;
                        double csCur_proton = ndMapCur.getProtonCS();
                        double csCur_heavy = ndMapCur.getHeavyCS();
                        Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
                        vecOneSCAsg.add(new H1CS(resNo, res, atom, csCur_proton));
                        vecOneSCAsg.add(new H1CS(resNo, res, heavyName, csCur_heavy));
                        double totalCurScore = asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsg, vecBMRBNew);
                        int h = 0;
                        while (h < vecMapSet.size()) {
                            if (h != k) {
                                double asgOtherScore;
                                Node ndMapCurOther = (Node)vecMapSet.elementAt(h);
                                double csOther_proton = ndMapCurOther.getProtonCS();
                                double csOther_heavy = ndMapCurOther.getHeavyCS();
                                Vector<H1CS> vecOneSCAsgOther = new Vector<H1CS>();
                                vecOneSCAsgOther.add(new H1CS(resNo, res, atom, csOther_proton));
                                vecOneSCAsgOther.add(new H1CS(resNo, res, heavyName, csOther_heavy));
                                double totalOtherScore = asgOtherScore = h1cs.BMRBSatisticsScore(vecOneSCAsgOther, vecBMRBNew);
                                double sumPairScore = 0.0;
                                int t = 0;
                                while (t < vecAdj.size()) {
                                    Vector vecNdCurAdjMap;
                                    Node ndCurAdj = (Node)vecAdj.elementAt(t);
                                    if (!ndCurAdj.getIsAssigned() && (vecNdCurAdjMap = ndCurAdj.getMappingSet()).size() >= 1) {
                                        int resNoAdj = ndCurAdj.getResNo();
                                        String resAdj = ndCurAdj.getResName();
                                        String atomAdj = ndCurAdj.getAtomName();
                                        String heavyNameAdj = pk.GetHeavyAtomFromProton(resAdj, atomAdj);
                                        int maxAdjID = -1;
                                        double maxScore = -9999.9;
                                        double pairMaxScore = -999999.9;
                                        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
                                        int a = 0;
                                        while (a < vecNdCurAdjMap.size()) {
                                            Node ndAdjMap = (Node)vecNdCurAdjMap.elementAt(a);
                                            Vector vecNoesyTwo = new Vector();
                                            vecNoesyTwo.addAll(ndMapCur.vecAdjNOESY);
                                            vecNoesyTwo.addAll(ndAdjMap.vecAdjNOESY);
                                            double csAdjMapProton = ndAdjMap.getProtonCS();
                                            double csAdjMapHeavy = ndAdjMap.getHeavyCS();
                                            vecBackNoe.add(new BackNoe(csCur_proton, csCur_heavy, csAdjMapProton, 6.0, 0.0, resNo, resNoAdj, res, resAdj, atom, heavyName, atomAdj));
                                            vecBackNoe.add(new BackNoe(csAdjMapProton, csAdjMapHeavy, csCur_proton, 6.0, 0.0, resNoAdj, resNo, resAdj, res, atomAdj, heavyNameAdj, atom));
                                            Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                                            int[] numPeaks = new int[1];
                                            double dbCurScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                                            dbCurScore *= (double)vecBackNoeNew.size();
                                            vecBackNoe.add(new BackNoe(csOther_proton, csOther_heavy, csAdjMapProton, 6.0, 0.0, resNo, resNoAdj, res, resAdj, atom, heavyName, atomAdj));
                                            vecBackNoe.add(new BackNoe(csAdjMapProton, csAdjMapHeavy, csOther_proton, 6.0, 0.0, resNoAdj, resNo, resAdj, res, atomAdj, heavyNameAdj, atom));
                                            double dbOtherScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                                            double pairScore = (dbOtherScore *= (double)vecBackNoeNew.size()) - dbCurScore;
                                            if (pairScore > pairMaxScore) {
                                                pairMaxScore = pairScore;
                                                maxAdjID = a;
                                            }
                                            ++a;
                                        }
                                        sumPairScore += pairMaxScore;
                                    }
                                    ++t;
                                }
                                if (totalOtherScore - asgScore + sumPairScore > 0.0) {
                                    isPruned = true;
                                }
                            }
                            ++h;
                        }
                        if (isPruned) {
                            Map2[ndMapCur.getID()][nodeProton.getID()] = 0;
                            ++counter;
                        }
                        ++k;
                    }
                }
            }
            ++j;
        }
        System.out.println("Total number of mappings pruned by DEE-CUT (Goldstein) is: " + counter);
    }

    public Vector GreedyGraphMatchingAstar(Vector vecResonGraph, Vector vecGraphOld, int[][] Map2, double[][] MapScore, Vector vecNewNoesy, Vector vecBMRBNew, Vector vecBBAsg, Vector vecBBPdb, String strRot, double caliConstant) {
        int MAX_NODE_NUM = 2000;
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Pdb pp = new Pdb();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        Noesy noesy = new Noesy();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        Vector<Pdb> vecRotStructure = pp.RotamSelectAndStructure(csErrH, csErrN, csErrCA, vecBBPdb, vecBBAsg, strRot, vecNewNoesy, 4.5, 1, caliConstant);
        double[][] distMatrix = new double[MAX_NODE_NUM][MAX_NODE_NUM];
        Vector vecGraph = this.UpdateStructGraphAdj(vecRotStructure, vecGraphOld, 5.0, distMatrix);
        this.UpdateMappingSet(vecResonGraph, vecGraph, Map2);
        this.UpdateIsRestrained(vecResonGraph, vecGraph, Map2);
        while (true) {
            boolean isAllAsg = true;
            double maxScore = -99999.9;
            int maxID = -1;
            int maxMapID = -1;
            int j = 0;
            while (j < vecGraph.size()) {
                block14: {
                    Node node2 = (Node)vecGraph.elementAt(j);
                    String res = node2.getResName();
                    String atom = node2.getAtomName();
                    String heavName = pk.GetHeavyAtomFromProton(res, atom);
                    int resNo = node2.getResNo();
                    Vector vecMapSet = node2.getMappingSet();
                    Vector vecAdj = node2.getAdjVec();
                    if (node2.getIsAssigned()) break block14;
                    int k = 0;
                    while (k < vecMapSet.size()) {
                        block16: {
                            Vector<H1CS> vecOneSCAsgNew;
                            double asgScore;
                            double cs_heavy;
                            double cs_proton;
                            Vector vecNoesyTwo;
                            Vector<BackNoe> vecBackNoe;
                            Vector<H1CS> vecOneSCAsg;
                            block17: {
                                Node ndStereoReson;
                                Node nodeMap;
                                block15: {
                                    nodeMap = (Node)vecMapSet.elementAt(k);
                                    if (nodeMap.asgedId < 0) break block15;
                                    Node nodeTemp = (Node)vecGraph.elementAt(nodeMap.asgedId);
                                    if (nodeTemp.stereoID != node2.getID() || nodeMap.vecStereoSymSet.size() > 0) break block16;
                                }
                                vecOneSCAsg = new Vector<H1CS>();
                                vecBackNoe = new Vector<BackNoe>();
                                vecNoesyTwo = new Vector();
                                Vector vecNoesy = nodeMap.vecAdjNOESY;
                                vecNoesyTwo.addAll(vecNoesy);
                                cs_proton = nodeMap.getProtonCS();
                                cs_heavy = nodeMap.getHeavyCS();
                                if (node2.stereoID < 0) break block17;
                                Node nodeStereo = (Node)vecGraph.elementAt(node2.stereoID);
                                if (nodeStereo.asgedId >= 0 && Math.abs((ndStereoReson = (Node)vecResonGraph.elementAt(nodeStereo.asgedId)).getHeavyCS() - cs_heavy) > 0.15) break block16;
                            }
                            vecOneSCAsg.add(new H1CS(resNo, res, atom, cs_proton));
                            vecOneSCAsg.add(new H1CS(resNo, res, heavName, cs_heavy));
                            int t = 0;
                            while (t < vecAdj.size()) {
                                Node nodeAdj = (Node)vecAdj.elementAt(t);
                                if (nodeAdj.getIsAssigned()) {
                                    Node nodeAdjReson = (Node)vecResonGraph.elementAt(nodeAdj.asgedId);
                                    vecNoesyTwo.addAll(nodeAdjReson.vecAdjNOESY);
                                    int resNoSec = nodeAdj.getResNo();
                                    String resSec = nodeAdj.getResName();
                                    String atomSec = nodeAdj.getAtomName();
                                    String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                                    double cs_protonSec = nodeAdjReson.getProtonCS();
                                    double cs_heavySec = nodeAdjReson.getHeavyCS();
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, atomSec, cs_protonSec));
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, heavyNameSec, cs_heavySec));
                                    double distUp = 6.0;
                                    if (this.isInCloseAdj(nodeAdj, node2)) {
                                        distUp = 2.7;
                                    }
                                    distUp = distMatrix[node2.getID()][nodeAdj.getID()];
                                    vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, distUp, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                                    vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, distUp, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
                                }
                                ++t;
                            }
                            Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                            int[] numPeaks = new int[1];
                            double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, false);
                            double score = (dbScore *= (double)vecBackNoeNew.size()) + (asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg), vecBMRBNew));
                            if (score > maxScore) {
                                maxScore = score;
                                maxID = j;
                                maxMapID = k;
                            }
                        }
                        ++k;
                    }
                    isAllAsg = false;
                }
                ++j;
            }
            if (isAllAsg || maxID <= 0) break;
            if (maxID == 10) {
                System.out.println("maxID=" + maxID);
            }
            System.out.println("maxID=" + maxID);
            Node node2 = (Node)vecGraph.elementAt(maxID);
            Vector vecMapSet = node2.getMappingSet();
            Node nodeMap = (Node)vecMapSet.elementAt(maxMapID);
            node2.asgedId = nodeMap.getID();
            nodeMap.asgedId = node2.getID();
            node2.setIsAssigned(true);
            nodeMap.setIsAssigned(true);
            System.out.println(String.valueOf(node2.getResNo()) + node2.getResName() + " - " + node2.getAtomName() + ": " + nodeMap.getProtonCS() + " , " + nodeMap.getHeavyCS());
            int stereoProtonID = node2.stereoID;
            if (node2.stereoID <= 0) continue;
            Node ndStereoProton = (Node)vecGraph.elementAt(node2.stereoID);
            Vector vecStereoReson = nodeMap.vecStereoSymSet;
            if (vecStereoReson.size() <= 0) continue;
            if (vecStereoReson.size() == 1) {
                Node ndStereoReson = (Node)vecStereoReson.elementAt(0);
                ndStereoProton.asgedId = ndStereoReson.getID();
                ndStereoReson.asgedId = ndStereoProton.getID();
                ndStereoProton.setIsAssigned(true);
                ndStereoReson.setIsAssigned(true);
                continue;
            }
            Vector vecStereoProtonMap = ndStereoProton.getMappingSet();
            vecStereoProtonMap = new Vector();
            vecStereoProtonMap.addAll(vecMapSet);
        }
        Vector<H1CS> vecAsg = new Vector<H1CS>();
        int j = 0;
        while (j < vecGraph.size()) {
            Node node2 = (Node)vecGraph.elementAt(j);
            String resName = node2.getResName();
            String atomName = node2.getAtomName();
            String heavName = pk.GetHeavyAtomFromProton(resName, atomName);
            int resNo = node2.getResNo();
            int resonID = node2.asgedId;
            if (resonID >= 0) {
                Node nodeResonAsg = (Node)vecResonGraph.elementAt(resonID);
                double cs_proton = nodeResonAsg.getProtonCS();
                double cs_heavy = nodeResonAsg.getHeavyCS();
                vecAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
                vecAsg.add(new H1CS(resNo, resName, heavName, cs_heavy));
            }
            ++j;
        }
        return vecAsg;
    }

    public Vector GreedyGraphMatching(Vector vecResonGraph, Vector vecGraph, int[][] Map2, double[][] MapScore, Vector vecNewNoesy, Vector vecBMRBNew) {
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        Noesy noesy = new Noesy();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        while (true) {
            boolean isAllAsg = true;
            double maxScore = -99999.9;
            int maxID = -1;
            int maxMapID = -1;
            int j = 0;
            while (j < vecGraph.size()) {
                block14: {
                    Node node2 = (Node)vecGraph.elementAt(j);
                    String res = node2.getResName();
                    String atom = node2.getAtomName();
                    String heavName = pk.GetHeavyAtomFromProton(res, atom);
                    int resNo = node2.getResNo();
                    Vector vecMapSet = node2.getMappingSet();
                    Vector vecAdj = node2.getAdjVec();
                    if (node2.getIsAssigned()) break block14;
                    int k = 0;
                    while (k < vecMapSet.size()) {
                        block16: {
                            Vector<H1CS> vecOneSCAsgNew;
                            double asgScore;
                            double cs_heavy;
                            double cs_proton;
                            Vector vecNoesyTwo;
                            Vector<BackNoe> vecBackNoe;
                            Vector<H1CS> vecOneSCAsg;
                            block17: {
                                Node ndStereoReson;
                                Node nodeMap;
                                block15: {
                                    nodeMap = (Node)vecMapSet.elementAt(k);
                                    if (nodeMap.asgedId < 0) break block15;
                                    Node nodeTemp = (Node)vecGraph.elementAt(nodeMap.asgedId);
                                    if (nodeTemp.stereoID != node2.getID() || nodeMap.vecStereoSymSet.size() > 0) break block16;
                                }
                                vecOneSCAsg = new Vector<H1CS>();
                                vecBackNoe = new Vector<BackNoe>();
                                vecNoesyTwo = new Vector();
                                Vector vecNoesy = nodeMap.vecAdjNOESY;
                                vecNoesyTwo.addAll(vecNoesy);
                                cs_proton = nodeMap.getProtonCS();
                                cs_heavy = nodeMap.getHeavyCS();
                                if (node2.stereoID < 0) break block17;
                                Node nodeStereo = (Node)vecGraph.elementAt(node2.stereoID);
                                if (nodeStereo.asgedId >= 0 && Math.abs((ndStereoReson = (Node)vecResonGraph.elementAt(nodeStereo.asgedId)).getHeavyCS() - cs_heavy) > 0.15) break block16;
                            }
                            vecOneSCAsg.add(new H1CS(resNo, res, atom, cs_proton));
                            vecOneSCAsg.add(new H1CS(resNo, res, heavName, cs_heavy));
                            int t = 0;
                            while (t < vecAdj.size()) {
                                Node nodeAdj = (Node)vecAdj.elementAt(t);
                                if (nodeAdj.getIsAssigned()) {
                                    Node nodeAdjReson = (Node)vecResonGraph.elementAt(nodeAdj.asgedId);
                                    vecNoesyTwo.addAll(nodeAdjReson.vecAdjNOESY);
                                    int resNoSec = nodeAdj.getResNo();
                                    String resSec = nodeAdj.getResName();
                                    String atomSec = nodeAdj.getAtomName();
                                    String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                                    double cs_protonSec = nodeAdjReson.getProtonCS();
                                    double cs_heavySec = nodeAdjReson.getHeavyCS();
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, atomSec, cs_protonSec));
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, heavyNameSec, cs_heavySec));
                                    double distUp = 6.0;
                                    if (this.isInCloseAdj(nodeAdj, node2)) {
                                        distUp = 2.7;
                                    }
                                    vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, distUp, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                                    vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, distUp, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
                                }
                                ++t;
                            }
                            Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                            int[] numPeaks = new int[1];
                            double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                            double score = (dbScore *= (double)vecBackNoeNew.size()) + (asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg), vecBMRBNew));
                            if (score > maxScore) {
                                maxScore = score;
                                maxID = j;
                                maxMapID = k;
                            }
                        }
                        ++k;
                    }
                    isAllAsg = false;
                }
                ++j;
            }
            if (isAllAsg || maxID <= 0) break;
            if (maxID == 10) {
                System.out.println("maxID=" + maxID);
            }
            System.out.println("maxID=" + maxID);
            Node node2 = (Node)vecGraph.elementAt(maxID);
            Vector vecMapSet = node2.getMappingSet();
            Node nodeMap = (Node)vecMapSet.elementAt(maxMapID);
            node2.asgedId = nodeMap.getID();
            nodeMap.asgedId = node2.getID();
            node2.setIsAssigned(true);
            nodeMap.setIsAssigned(true);
            System.out.println(String.valueOf(node2.getResNo()) + node2.getResName() + " - " + node2.getAtomName() + ": " + nodeMap.getProtonCS() + " , " + nodeMap.getHeavyCS());
            int stereoProtonID = node2.stereoID;
            if (node2.stereoID <= 0) continue;
            Node ndStereoProton = (Node)vecGraph.elementAt(node2.stereoID);
            Vector vecStereoReson = nodeMap.vecStereoSymSet;
            if (vecStereoReson.size() <= 0) continue;
            if (vecStereoReson.size() == 1) {
                Node ndStereoReson = (Node)vecStereoReson.elementAt(0);
                ndStereoProton.asgedId = ndStereoReson.getID();
                ndStereoReson.asgedId = ndStereoProton.getID();
                ndStereoProton.setIsAssigned(true);
                ndStereoReson.setIsAssigned(true);
                continue;
            }
            Vector vecStereoProtonMap = ndStereoProton.getMappingSet();
            vecStereoProtonMap = new Vector();
            vecStereoProtonMap.addAll(vecMapSet);
        }
        Vector<H1CS> vecAsg = new Vector<H1CS>();
        int j = 0;
        while (j < vecGraph.size()) {
            Node node2 = (Node)vecGraph.elementAt(j);
            String resName = node2.getResName();
            String atomName = node2.getAtomName();
            String heavName = pk.GetHeavyAtomFromProton(resName, atomName);
            int resNo = node2.getResNo();
            int resonID = node2.asgedId;
            if (resonID >= 0) {
                Node nodeResonAsg = (Node)vecResonGraph.elementAt(resonID);
                double cs_proton = nodeResonAsg.getProtonCS();
                double cs_heavy = nodeResonAsg.getHeavyCS();
                vecAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
                vecAsg.add(new H1CS(resNo, resName, heavName, cs_heavy));
            }
            ++j;
        }
        return vecAsg;
    }

    public double ComputeAStarEstimatedCost(Vector vecResonGraph, Vector vecGraph, Vector vecBMRBNew, int curIndex) {
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        double est_cost = 0.0;
        int j = 0;
        while (j < vecGraph.size()) {
            block7: {
                Node node2 = (Node)vecGraph.elementAt(j);
                String res = node2.getResName();
                String atom = node2.getAtomName();
                String heavName = pk.GetHeavyAtomFromProton(res, atom);
                int resNo = node2.getResNo();
                Vector vecMapSet = node2.getMappingSet();
                Vector vecAdj = node2.getAdjVec();
                if (node2.getIsAssigned() || curIndex == j) break block7;
                double maxScore = -99999.9;
                int maxMapID = -1;
                int k = 0;
                while (k < vecMapSet.size()) {
                    block9: {
                        double asgScore;
                        double cs_heavy;
                        double cs_proton;
                        Vector<H1CS> vecOneSCAsg;
                        block10: {
                            Node ndStereoReson;
                            Node nodeMap;
                            block8: {
                                nodeMap = (Node)vecMapSet.elementAt(k);
                                if (nodeMap.asgedId < 0) break block8;
                                Node nodeTemp = (Node)vecGraph.elementAt(nodeMap.asgedId);
                                if (nodeTemp.stereoID != node2.getID() || nodeMap.vecStereoSymSet.size() > 0) break block9;
                            }
                            vecOneSCAsg = new Vector<H1CS>();
                            Vector vecBackNoe = new Vector();
                            Vector vecNoesyTwo = new Vector();
                            Vector vecNoesy = nodeMap.vecAdjNOESY;
                            vecNoesyTwo.addAll(vecNoesy);
                            cs_proton = nodeMap.getProtonCS();
                            cs_heavy = nodeMap.getHeavyCS();
                            if (node2.stereoID < 0) break block10;
                            Node nodeStereo = (Node)vecGraph.elementAt(node2.stereoID);
                            if (nodeStereo.asgedId >= 0 && Math.abs((ndStereoReson = (Node)vecResonGraph.elementAt(nodeStereo.asgedId)).getHeavyCS() - cs_heavy) > 0.15) break block9;
                        }
                        vecOneSCAsg.add(new H1CS(resNo, res, atom, cs_proton));
                        vecOneSCAsg.add(new H1CS(resNo, res, heavName, cs_heavy));
                        int[] numPeaks = new int[1];
                        Vector<H1CS> vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg);
                        double score = asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew, vecBMRBNew);
                        if (score > maxScore) {
                            maxScore = score;
                            maxMapID = k;
                        }
                    }
                    ++k;
                }
                if (maxMapID >= 0) {
                    est_cost += maxScore;
                }
            }
            ++j;
        }
        return est_cost;
    }

    public Vector AStarSearchForSCAsgs(Vector vecResonGraph, Vector vecHPositions, int[][] Map2, double[][] MapScore, Vector vecNewNoesy, Vector vecBMRBNew) {
        Peak pk = new Peak();
        BackNoe bkNoe = new BackNoe();
        Assign asg = new Assign();
        H1CS h1cs = new H1CS();
        Noesy noesy = new Noesy();
        double csErrH = 0.04;
        double csErrN = 0.3;
        double csErrCA = 0.3;
        while (true) {
            boolean isAllAsg = true;
            double maxScore = -99999.9;
            int maxID = -1;
            int maxMapID = -1;
            int j = 0;
            while (j < vecHPositions.size()) {
                block13: {
                    Node node2 = (Node)vecHPositions.elementAt(j);
                    String res = node2.getResName();
                    String atom = node2.getAtomName();
                    String heavName = pk.GetHeavyAtomFromProton(res, atom);
                    int resNo = node2.getResNo();
                    Vector vecMapSet = node2.getMappingSet();
                    Vector vecAdj = node2.getAdjVec();
                    if (node2.getIsAssigned()) break block13;
                    int k = 0;
                    while (k < vecMapSet.size()) {
                        block15: {
                            double hScore;
                            Vector<H1CS> vecOneSCAsgNew;
                            double asgScore;
                            double cs_heavy;
                            double cs_proton;
                            Vector vecNoesyTwo;
                            Vector<BackNoe> vecBackNoe;
                            Vector<H1CS> vecOneSCAsg;
                            block16: {
                                Node ndStereoReson;
                                Node nodeMap;
                                block14: {
                                    nodeMap = (Node)vecMapSet.elementAt(k);
                                    if (nodeMap.asgedId < 0) break block14;
                                    Node nodeTemp = (Node)vecHPositions.elementAt(nodeMap.asgedId);
                                    if (nodeTemp.stereoID != node2.getID() || nodeMap.vecStereoSymSet.size() > 0) break block15;
                                }
                                vecOneSCAsg = new Vector<H1CS>();
                                vecBackNoe = new Vector<BackNoe>();
                                vecNoesyTwo = new Vector();
                                Vector vecNoesy = nodeMap.vecAdjNOESY;
                                vecNoesyTwo.addAll(vecNoesy);
                                cs_proton = nodeMap.getProtonCS();
                                cs_heavy = nodeMap.getHeavyCS();
                                if (node2.stereoID < 0) break block16;
                                Node nodeStereo = (Node)vecHPositions.elementAt(node2.stereoID);
                                if (nodeStereo.asgedId >= 0 && Math.abs((ndStereoReson = (Node)vecResonGraph.elementAt(nodeStereo.asgedId)).getHeavyCS() - cs_heavy) > 0.15) break block15;
                            }
                            vecOneSCAsg.add(new H1CS(resNo, res, atom, cs_proton));
                            vecOneSCAsg.add(new H1CS(resNo, res, heavName, cs_heavy));
                            int t = 0;
                            while (t < vecAdj.size()) {
                                Node nodeAdj = (Node)vecAdj.elementAt(t);
                                if (nodeAdj.getIsAssigned() && nodeAdj.asgedId >= 0) {
                                    Node nodeAdjReson = (Node)vecResonGraph.elementAt(nodeAdj.asgedId);
                                    vecNoesyTwo.addAll(nodeAdjReson.vecAdjNOESY);
                                    int resNoSec = nodeAdj.getResNo();
                                    String resSec = nodeAdj.getResName();
                                    String atomSec = nodeAdj.getAtomName();
                                    String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                                    double cs_protonSec = nodeAdjReson.getProtonCS();
                                    double cs_heavySec = nodeAdjReson.getHeavyCS();
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, atomSec, cs_protonSec));
                                    vecOneSCAsg.add(new H1CS(resNoSec, resSec, heavyNameSec, cs_heavySec));
                                    double distUp = 6.0;
                                    if (this.isInCloseAdj(nodeAdj, node2)) {
                                        distUp = 2.7;
                                    }
                                    vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, distUp, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                                    vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, distUp, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
                                }
                                ++t;
                            }
                            Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
                            int[] numPeaks = new int[1];
                            double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesyTwo, numPeaks, true);
                            double gScore = (dbScore *= (double)vecBackNoeNew.size()) + (asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsgNew = h1cs.DeleteRepeatAsg(vecOneSCAsg), vecBMRBNew));
                            double fScore = gScore + (hScore = this.ComputeAStarEstimatedCost(vecResonGraph, vecHPositions, vecBMRBNew, j));
                            if (fScore > maxScore) {
                                maxScore = fScore;
                                maxID = j;
                                maxMapID = k;
                            }
                        }
                        ++k;
                    }
                    isAllAsg = false;
                }
                ++j;
            }
            if (isAllAsg || maxID <= 0) break;
            System.out.println("maxID=" + maxID);
            Node node2 = (Node)vecHPositions.elementAt(maxID);
            Vector vecMapSet = node2.getMappingSet();
            Node nodeMap = (Node)vecMapSet.elementAt(maxMapID);
            node2.asgedId = nodeMap.getID();
            nodeMap.asgedId = node2.getID();
            node2.setIsAssigned(true);
            nodeMap.setIsAssigned(true);
            System.out.println(String.valueOf(node2.getResNo()) + node2.getResName() + " - " + node2.getAtomName() + ": " + nodeMap.getProtonCS() + " , " + nodeMap.getHeavyCS());
            int stereoProtonID = node2.stereoID;
            if (node2.stereoID <= 0) continue;
            Node ndStereoProton = (Node)vecHPositions.elementAt(node2.stereoID);
            Vector vecStereoReson = nodeMap.vecStereoSymSet;
            if (vecStereoReson.size() <= 0) continue;
            if (vecStereoReson.size() == 1) {
                Node ndStereoReson = (Node)vecStereoReson.elementAt(0);
                ndStereoProton.asgedId = ndStereoReson.getID();
                ndStereoReson.asgedId = ndStereoProton.getID();
                ndStereoProton.setIsAssigned(true);
                ndStereoReson.setIsAssigned(true);
                continue;
            }
            Vector vecStereoProtonMap = ndStereoProton.getMappingSet();
            vecStereoProtonMap = new Vector();
            vecStereoProtonMap.addAll(vecMapSet);
        }
        Vector<H1CS> vecAsg = new Vector<H1CS>();
        int j = 0;
        while (j < vecHPositions.size()) {
            Node node2 = (Node)vecHPositions.elementAt(j);
            String resName = node2.getResName();
            String atomName = node2.getAtomName();
            String heavName = pk.GetHeavyAtomFromProton(resName, atomName);
            int resNo = node2.getResNo();
            int resonID = node2.asgedId;
            if (resonID >= 0) {
                Node nodeResonAsg = (Node)vecResonGraph.elementAt(resonID);
                double cs_proton = nodeResonAsg.getProtonCS();
                double cs_heavy = nodeResonAsg.getHeavyCS();
                vecAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
                vecAsg.add(new H1CS(resNo, resName, heavName, cs_heavy));
            }
            ++j;
        }
        return vecAsg;
    }

    public void RefineMappingForHG(Vector vecResonGraph, Vector vecGraph, int[][] Map2, double[][] MapScore, Vector vecNewNoesy, Vector vecBMRBNew) {
        Nasca isoGraph = new Nasca();
        Peak pk = new Peak();
        H1CS h1cs = new H1CS();
        int restrainThreshold = 15;
        this.UpdateStereoSymSet(vecResonGraph, vecGraph, Map2);
        int j = 0;
        while (j < vecGraph.size()) {
            Node node2 = (Node)vecGraph.elementAt(j);
            String resName = node2.getResName();
            String atomName = node2.getAtomName();
            int resNo = node2.getResNo();
            boolean isRestrained = false;
            if (!node2.getIsAssigned()) {
                if (resNo == 3 && atomName.equalsIgnoreCase("HB2")) {
                    System.out.println("debugging...");
                }
                String subAtom = atomName;
                if (atomName.length() >= 2) {
                    subAtom = atomName.substring(0, 2);
                }
                if (subAtom.equalsIgnoreCase("HG") || subAtom.equalsIgnoreCase("HD") || subAtom.equalsIgnoreCase("HE") || subAtom.equalsIgnoreCase("HH") || subAtom.equalsIgnoreCase("HZ")) {
                    Vector<RotaPattern> vecNeighborSC = new Vector<RotaPattern>();
                    int i = 0;
                    while (i < vecResonGraph.size()) {
                        if (Map2[i][j] != 0) {
                            Node node = (Node)vecResonGraph.elementAt(i);
                            double cs_proton = node.getProtonCS();
                            double cs_heavy = node.getHeavyCS();
                            Vector vecAdj = node.getAdjVec();
                            boolean isAssigned = node.getIsAssigned();
                            if (!isAssigned) {
                                String heavyName;
                                if (Math.abs(cs_proton - 7.309) < 0.04 && Math.abs(cs_heavy - 129.458) < 0.4 && node2.getResNo() == 32 && atomName.equalsIgnoreCase("HE1")) {
                                    System.out.println("stop here...");
                                }
                                if (j == 2 && i == 305) {
                                    System.out.println("stop here...");
                                }
                                if ((heavyName = pk.GetHeavyAtomFromProton(resName, atomName)).substring(0, 1).equalsIgnoreCase("N") || heavyName.substring(0, 1).equalsIgnoreCase("C")) {
                                    Vector vecAdj2 = node2.getAdjVec();
                                    if (vecAdj.size() < 1 || vecAdj2.size() < 1) {
                                        System.out.println("debugging...we found an empty neiborhood...");
                                    } else {
                                        double[] neighborSC = new double[1];
                                        boolean isRestrainTemp = false;
                                        isRestrainTemp = isoGraph.isMappedBetwTwoSetsCalScore(node, node2, vecAdj, vecAdj2, Map2, false, restrainThreshold, neighborSC, vecNewNoesy);
                                        Vector<H1CS> vecOneSCAsg = new Vector<H1CS>();
                                        vecOneSCAsg.add(new H1CS(resNo, resName, atomName, cs_proton));
                                        vecOneSCAsg.add(new H1CS(resNo, resName, heavyName, cs_heavy));
                                        double asgScore = h1cs.BMRBSatisticsScore(vecOneSCAsg, vecBMRBNew);
                                        neighborSC[0] = neighborSC[0] + asgScore;
                                        MapScore[i][j] = neighborSC[0];
                                        if (isRestrainTemp) {
                                            isRestrained = true;
                                        }
                                        RotaPattern rp = new RotaPattern(i, neighborSC[0]);
                                        vecNeighborSC.add(rp);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                    node2.setIsRestrained(true);
                    Collections.sort(vecNeighborSC, new RotaPattern.scoreComparator());
                    i = 0;
                    while (i < vecResonGraph.size()) {
                        boolean isIn = false;
                        int h = 0;
                        while (h < Math.min(20, vecNeighborSC.size())) {
                            RotaPattern rotPatn = (RotaPattern)vecNeighborSC.elementAt(h);
                            int graph_ID = rotPatn.getResNo();
                            Node nodeTemp = (Node)vecResonGraph.elementAt(graph_ID);
                            int stereoIDTemp = nodeTemp.stereoID;
                            if (i == graph_ID || i == stereoIDTemp) {
                                isIn = true;
                            }
                            ++h;
                        }
                        if (!isIn) {
                            Map2[i][j] = 0;
                        }
                        ++i;
                    }
                }
            }
            ++j;
        }
    }

    public void RefineResonGraph(Vector vecResonGraph, Vector vecStructGraph, int[][] Map2) {
        int counter = 0;
        int i = 0;
        while (i < vecResonGraph.size()) {
            Node nodeReson = (Node)vecResonGraph.elementAt(i);
            Vector vecAdj = nodeReson.getAdjVec();
            Vector vecMap = nodeReson.getMappingSet();
            Vector vecAdjCopy = this.myVectorCopyOneLayer(vecAdj);
            int k = 0;
            while (k < vecAdj.size()) {
                Node node_adj = (Node)vecAdj.elementAt(k);
                Vector vecMap_adj = node_adj.getMappingSet();
                boolean isExist = false;
                int h = 0;
                while (h < vecMap.size()) {
                    Node nodeTemp = (Node)vecMap.elementAt(h);
                    Vector vecAdjTemp = nodeTemp.getAdjVec();
                    int t = 0;
                    while (t < vecAdjTemp.size()) {
                        Node nodeTemp2 = (Node)vecAdjTemp.elementAt(t);
                        int IdTemp2 = nodeTemp2.getID();
                        int w = 0;
                        while (w < vecMap_adj.size()) {
                            Node nodeTemp3 = (Node)vecMap_adj.elementAt(w);
                            if (nodeTemp3.getID() == IdTemp2) {
                                isExist = true;
                            }
                            ++w;
                        }
                        ++t;
                    }
                    ++h;
                }
                if (!isExist) {
                    ++counter;
                    vecAdj.remove(k);
                    --k;
                }
                ++k;
            }
            ++i;
        }
        System.out.println("Total number of edges has been removed: " + counter);
    }

    public void ExactSubgraphIsomorphism(Vector vecResonGraph, Vector vecStructGraph, int[][] Map2) {
        boolean isDebug = true;
        double maxInterval = 0.0;
        int j = 0;
        while (j < vecStructGraph.size()) {
            Node nodeStruct = (Node)vecStructGraph.elementAt(j);
            int resNo = nodeStruct.getResNo();
            String res = nodeStruct.getResName();
            String atom = nodeStruct.getAtomName();
            double cs_lower = 999.9;
            double cs_upper = -999.9;
            int i = 0;
            while (i < vecResonGraph.size()) {
                Node nodeReson = (Node)vecResonGraph.elementAt(i);
                double cs_h = nodeReson.getProtonCS();
                if (Map2[i][j] != 0) {
                    if (cs_h > cs_upper) {
                        cs_upper = cs_h;
                    }
                    if (cs_h < cs_lower) {
                        cs_lower = cs_h;
                    }
                }
                ++i;
            }
            if (isDebug) {
                System.out.println("The interval for " + resNo + res + "-" + atom + " is: [" + cs_lower + ", " + cs_upper + "] = " + Math.abs(cs_upper - cs_lower));
            }
            if (maxInterval < Math.abs(cs_upper - cs_lower)) {
                maxInterval = Math.abs(cs_upper - cs_lower);
            }
            ++j;
        }
        if (isDebug) {
            System.out.println("The maximum interval is:" + maxInterval);
        }
        this.CompOneToOneMapBtwInterval(vecResonGraph, vecStructGraph, Map2, 3.0, 4.5);
        System.out.println("we finish one interval here:");
    }

    public Vector myVectorCopy(Vector vecSrc) {
        Vector vecFinal = new Vector();
        int i = 0;
        while (i < vecSrc.size()) {
            Vector<Node> vecFianlOne = new Vector<Node>();
            Vector vecSrcOne = (Vector)vecSrc.elementAt(i);
            int j = 0;
            while (j < vecSrcOne.size()) {
                Node node = (Node)vecSrcOne.elementAt(j);
                Node nodeCopy = new Node(node);
                vecFianlOne.add(nodeCopy);
                ++j;
            }
            vecFinal.add(vecFianlOne);
            ++i;
        }
        return vecFinal;
    }

    public Vector myVectorCopyOneLayer(Vector vecSrc) {
        Vector<Node> vecFianlOne = new Vector<Node>();
        int j = 0;
        while (j < vecSrc.size()) {
            Node node = (Node)vecSrc.elementAt(j);
            Node nodeCopy = new Node(node);
            vecFianlOne.add(nodeCopy);
            ++j;
        }
        return vecFianlOne;
    }

    public Vector EnumAllScAsg(Vector vecStructGraph) {
        Vector<Vector> vecConfig = new Vector<Vector>();
        int i = 0;
        while (i < vecStructGraph.size()) {
            Node nodeStruct = (Node)vecStructGraph.elementAt(i);
            Vector vecMapSet = nodeStruct.getMappingSet();
            Vector vecConfigCopy = new Vector();
            vecConfigCopy = this.myVectorCopy(vecConfig);
            vecConfig = new Vector();
            int j = 0;
            while (j < vecMapSet.size()) {
                Node nodeMap = (Node)vecMapSet.elementAt(j);
                double cs_h = nodeMap.getProtonCS();
                double cs_heavy = nodeMap.getHeavyCS();
                int mapId = nodeMap.getID();
                Node ndStructCopy = new Node(nodeStruct);
                ndStructCopy.setProtonCS(cs_h);
                ndStructCopy.setHeavyCS(cs_heavy);
                ndStructCopy.setAssignedID(mapId);
                if (vecConfigCopy.size() < 1) {
                    Vector<Node> vecOneMap = new Vector<Node>();
                    vecOneMap.add(ndStructCopy);
                    vecConfig.add(vecOneMap);
                } else {
                    Vector vecPreCopy = new Vector();
                    vecPreCopy = this.myVectorCopy(vecConfigCopy);
                    int k = 0;
                    while (k < vecPreCopy.size()) {
                        Vector vecPreCopyOne = (Vector)vecPreCopy.elementAt(k);
                        vecPreCopyOne.add(ndStructCopy);
                        vecConfig.add(vecPreCopyOne);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        Peak pk = new Peak();
        Vector vecAllH1CS = new Vector();
        int i2 = 0;
        while (i2 < vecConfig.size()) {
            Vector<H1CS> vecOneH1CS = new Vector<H1CS>();
            Vector vecOneConfig = (Vector)vecConfig.elementAt(i2);
            int j = 0;
            while (j < vecOneConfig.size()) {
                Node node = (Node)vecOneConfig.elementAt(j);
                String resName = node.getResName();
                String atom = node.getAtomName();
                int res_no = node.getResNo();
                double cs_h = node.getProtonCS();
                if (atom.equalsIgnoreCase("H")) {
                    atom = "HN";
                }
                if (resName.equalsIgnoreCase("ALA") && (atom.equalsIgnoreCase("HB1") || atom.equalsIgnoreCase("HB2") || atom.equalsIgnoreCase("HB3"))) {
                    atom = "HB";
                }
                if (resName.equalsIgnoreCase("ILE") && (atom.equalsIgnoreCase("HG21") || atom.equalsIgnoreCase("HG22") || atom.equalsIgnoreCase("HG23"))) {
                    atom = "HG2";
                }
                if (resName.equalsIgnoreCase("ILE") && (atom.equalsIgnoreCase("HD11") || atom.equalsIgnoreCase("HD12") || atom.equalsIgnoreCase("HD13"))) {
                    atom = "HD1";
                }
                if (resName.equalsIgnoreCase("LEU") && (atom.equalsIgnoreCase("HD11") || atom.equalsIgnoreCase("HD12") || atom.equalsIgnoreCase("HD13"))) {
                    atom = "HD1";
                }
                if (resName.equalsIgnoreCase("LEU") && (atom.equalsIgnoreCase("HD21") || atom.equalsIgnoreCase("HD22") || atom.equalsIgnoreCase("HD23"))) {
                    atom = "HD2";
                }
                if (resName.equalsIgnoreCase("VAL") && (atom.equalsIgnoreCase("HG11") || atom.equalsIgnoreCase("HG12") || atom.equalsIgnoreCase("HG13"))) {
                    atom = "HG1";
                }
                if (resName.equalsIgnoreCase("VAL") && (atom.equalsIgnoreCase("HG21") || atom.equalsIgnoreCase("HG22") || atom.equalsIgnoreCase("HG23"))) {
                    atom = "HG2";
                }
                if (resName.equalsIgnoreCase("THR") && (atom.equalsIgnoreCase("HG21") || atom.equalsIgnoreCase("HG22") || atom.equalsIgnoreCase("HG23"))) {
                    atom = "HG2";
                }
                if (resName.equalsIgnoreCase("MET") && (atom.equalsIgnoreCase("HE1") || atom.equalsIgnoreCase("HE2") || atom.equalsIgnoreCase("HE3"))) {
                    atom = "HE";
                }
                double cs_heavy = node.getHeavyCS();
                String atomHeavy = pk.GetHeavyAtomFromProton(resName, atom);
                vecOneH1CS.add(new H1CS(res_no, resName, atom, cs_h));
                vecOneH1CS.add(new H1CS(res_no, resName, atomHeavy, cs_heavy));
                ++j;
            }
            vecAllH1CS.add(vecOneH1CS);
            ++i2;
        }
        return vecAllH1CS;
    }

    public void CompOneToOneMapBtwInterval(Vector vecResonGraph, Vector vecStructGraph, int[][] Map2, double intvLower, double intvUpper) {
        Vector vecMapSet;
        String ss = "";
        Vector<Node> vecResonIntvGraph = new Vector<Node>();
        int maxMaps = -999;
        int i = 0;
        while (i < vecResonGraph.size()) {
            double cs_h;
            Node nodeReson = (Node)vecResonGraph.elementAt(i);
            if (!(nodeReson.getIsAssigned() || (cs_h = nodeReson.getProtonCS()) < intvLower || cs_h > intvUpper)) {
                vecMapSet = nodeReson.getMappingSet();
                if (maxMaps < vecMapSet.size()) {
                    maxMaps = vecMapSet.size();
                }
                vecResonIntvGraph.add(nodeReson);
            }
            ++i;
        }
        String userDir = System.getProperty("user.dir");
        String srcTemp = String.valueOf(userDir) + "/system/config_temp.txt";
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(srcTemp)));
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + srcTemp);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        int i2 = 0;
        while (i2 < vecResonIntvGraph.size()) {
            Node nodeReson = (Node)vecResonIntvGraph.elementAt(i2);
            vecMapSet = nodeReson.getMappingSet();
            String srcTempCopy = String.valueOf(userDir) + "/system/config_temp_copy.txt";
            Nasca.copyfile(srcTemp, srcTempCopy);
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(srcTemp)));
                int j = 0;
                while (j < vecMapSet.size()) {
                    Node nodeMap = (Node)vecMapSet.elementAt(j);
                    int mapId = nodeMap.getID();
                    if (i2 == 0) {
                        String str = String.valueOf(nodeReson.getID()) + "-" + nodeMap.getID();
                        out.println(str);
                    } else {
                        String srcTempPreCopy = String.valueOf(userDir) + "/system/config_temp_pre_copy.txt";
                        Nasca.copyfile(srcTempCopy, srcTempPreCopy);
                        try {
                            BufferedReader in = new BufferedReader(new FileReader(srcTempPreCopy));
                            while ((ss = in.readLine()) != null) {
                                String str = String.valueOf(ss) + " , " + nodeReson.getID() + "-" + nodeMap.getID();
                                out.println(str);
                            }
                            in.close();
                        }
                        catch (FileNotFoundException e) {
                            System.out.println("File not found: " + srcTempPreCopy);
                        }
                        catch (IOException e) {
                            System.out.println("IOException: the stack trace is:");
                            e.printStackTrace();
                        }
                    }
                    ++j;
                }
                out.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + srcTemp);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
            ++i2;
        }
    }

    public Vector EnumAllScAsgSaveIntoFile(Vector vecSCProtons, Vector vecResonGraph, Vector vecStructGraph) {
        String ss = "";
        int maxMaps = -999;
        Vector vecConfig = new Vector();
        String userDir = System.getProperty("user.dir");
        String srcTemp = String.valueOf(userDir) + "/system/config_temp.txt";
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(srcTemp)));
            out.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + srcTemp);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        int i = 0;
        while (i < vecSCProtons.size()) {
            Node nodeProton = (Node)vecSCProtons.elementAt(i);
            Vector vecMapSet = nodeProton.getMappingSet();
            String srcTempCopy = String.valueOf(userDir) + "/system/config_temp_copy.txt";
            Nasca.copyfile(srcTemp, srcTempCopy);
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(srcTemp)));
                int j = 0;
                while (j < vecMapSet.size()) {
                    Node nodeMap = (Node)vecMapSet.elementAt(j);
                    int mapId = nodeMap.getID();
                    if (i == 0) {
                        String str = String.valueOf(nodeProton.getID()) + "-" + nodeMap.getID();
                        out.println(str);
                    } else {
                        String srcTempPreCopy = String.valueOf(userDir) + "/system/config_temp_pre_copy.txt";
                        Nasca.copyfile(srcTempCopy, srcTempPreCopy);
                        try {
                            BufferedReader in = new BufferedReader(new FileReader(srcTempPreCopy));
                            while ((ss = in.readLine()) != null) {
                                String str = String.valueOf(ss) + "," + nodeProton.getID() + "-" + nodeMap.getID();
                                out.println(str);
                            }
                            in.close();
                        }
                        catch (FileNotFoundException e) {
                            System.out.println("File not found: " + srcTempPreCopy);
                        }
                        catch (IOException e) {
                            System.out.println("IOException: the stack trace is:");
                            e.printStackTrace();
                        }
                    }
                    ++j;
                }
                if (vecMapSet.size() < 1) {
                    if (i == 0) {
                        String str = "9999999-9999999";
                        out.println(str);
                    } else {
                        String srcTempPreCopy = String.valueOf(userDir) + "/system/config_temp_pre_copy.txt";
                        Nasca.copyfile(srcTempCopy, srcTempPreCopy);
                        try {
                            BufferedReader in = new BufferedReader(new FileReader(srcTempPreCopy));
                            while ((ss = in.readLine()) != null) {
                                String str = String.valueOf(ss) + ",9999999-9999999";
                                out.println(str);
                            }
                            in.close();
                        }
                        catch (FileNotFoundException e) {
                            System.out.println("File not found: " + srcTempPreCopy);
                        }
                        catch (IOException e) {
                            System.out.println("IOException: the stack trace is:");
                            e.printStackTrace();
                        }
                    }
                }
                out.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + srcTemp);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
            ++i;
        }
        int index = 0;
        Assign asg = new Assign();
        Peak pk = new Peak();
        H1CS h1cs = new H1CS();
        try {
            BufferedReader in = new BufferedReader(new FileReader(srcTemp));
            while ((ss = in.readLine()) != null) {
                boolean isSuccess;
                Vector<H1CS> vecConfigOne = new Vector<H1CS>();
                String ssTemp = ss;
                boolean isBreak = false;
                while (true) {
                    index = ssTemp.indexOf(",");
                    String ssTemp2 = "";
                    boolean isExisting = false;
                    ssTemp2 = index == -1 ? ssTemp : ssTemp.substring(0, index);
                    Vector vecOder = asg.getOrder(ssTemp2);
                    int ProtonID = Integer.parseInt((String)vecOder.elementAt(0));
                    int ResonID = Integer.parseInt((String)vecOder.elementAt(1));
                    if (ProtonID <= 99999 && ResonID <= 99999) {
                        Node nodeStruct = (Node)vecStructGraph.elementAt(ProtonID);
                        Node nodeReson = (Node)vecResonGraph.elementAt(ResonID);
                        String res = nodeStruct.getResName();
                        int resNo = nodeStruct.getResNo();
                        String atom = nodeStruct.getAtomName();
                        String heavyAtom = pk.GetHeavyAtomFromProton(res, atom);
                        double cs_h = nodeReson.getProtonCS();
                        double cs_heavy = nodeReson.getHeavyCS();
                        double cs_heavyTemp = 0.0;
                        int saveId = 0;
                        int w = 0;
                        while (w < vecConfigOne.size()) {
                            H1CS h1csTemp = (H1CS)vecConfigOne.elementAt(w);
                            cs_heavyTemp = h1csTemp.getH1CS();
                            String heavyTemp = h1csTemp.getAtomName();
                            if (heavyAtom.equalsIgnoreCase(heavyTemp)) {
                                isExisting = true;
                                saveId = w;
                                break;
                            }
                            ++w;
                        }
                        if (!isExisting) {
                            vecConfigOne.add(new H1CS(resNo, res, heavyAtom, cs_heavy, ProtonID, ResonID));
                        } else if (Math.abs(cs_heavyTemp - cs_heavy) > 0.2) {
                            isBreak = true;
                            vecConfigOne.remove(saveId);
                            break;
                        }
                        vecConfigOne.add(new H1CS(resNo, res, atom, cs_h, ProtonID, ResonID));
                    }
                    if (index == -1) break;
                    ssTemp = ssTemp.substring(index + 1, ssTemp.length());
                }
                if (isBreak || !(isSuccess = h1cs.checkCSBMRBOrder(vecConfigOne))) continue;
                vecConfig.add(vecConfigOne);
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + srcTemp);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return vecConfig;
    }

    public static void copyfile(String srFile, String dtFile) {
        try {
            int len;
            File f1 = new File(srFile);
            File f2 = new File(dtFile);
            FileInputStream in = new FileInputStream(f1);
            FileOutputStream out = new FileOutputStream(f2);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
        catch (FileNotFoundException ex) {
            System.out.println(String.valueOf(ex.getMessage()) + " in the specified directory.");
            System.exit(0);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void StatisticsAllSCAssignment(Vector vecResonGraph, Vector vecStructGraph, int[][] Map2, Vector vecRefAsg) {
        Peak pk = new Peak();
        int totalScH = 0;
        int missing = 0;
        boolean averSize = false;
        boolean sum = false;
        boolean maxSize = false;
        String maxStr = "";
        int[] counter = new int[200];
        Assign asg = new Assign();
        boolean notInRef = false;
        boolean[] isProtonFound = new boolean[vecStructGraph.size()];
        int j = 0;
        while (j < vecStructGraph.size()) {
            isProtonFound[j] = false;
            ++j;
        }
        this.UpdateMappingSet(vecResonGraph, vecStructGraph, Map2);
        int k = 0;
        while (k < vecRefAsg.size()) {
            H1CS h1cs = (H1CS)vecRefAsg.elementAt(k);
            int resRefNo = h1cs.getResidueNo();
            String resRef = h1cs.getResidueType();
            String atomRef = h1cs.getAtomName();
            double csRef = h1cs.getH1CS();
            double csHeavyRef = -999.9;
            if (!(atomRef.equalsIgnoreCase("CA") || atomRef.equalsIgnoreCase("N") || atomRef.equalsIgnoreCase("HN") || atomRef.equalsIgnoreCase("H") || atomRef.equalsIgnoreCase("HA") || atomRef.equalsIgnoreCase("HA1") || atomRef.equalsIgnoreCase("HA2") || atomRef.equalsIgnoreCase("HA3") || atomRef.equalsIgnoreCase("C") || atomRef.equalsIgnoreCase("CO") || atomRef.equalsIgnoreCase("CB") || !atomRef.substring(0, 1).equalsIgnoreCase("H"))) {
                String heavyRef = pk.GetHeavyAtomFromProton(resRef, atomRef);
                ++totalScH;
                int t = 0;
                while (t < vecRefAsg.size()) {
                    H1CS h1csTemp = (H1CS)vecRefAsg.elementAt(t);
                    int resNoTemp = h1csTemp.getResidueNo();
                    String atomTemp = h1csTemp.getAtomName();
                    if (atomTemp.equalsIgnoreCase(heavyRef) && resNoTemp == resRefNo) {
                        csHeavyRef = h1csTemp.getH1CS();
                    }
                    ++t;
                }
                boolean isRefInCur = false;
                int j2 = 0;
                while (j2 < vecStructGraph.size()) {
                    int resNo;
                    String atom;
                    Node nodeStr = (Node)vecStructGraph.elementAt(j2);
                    String subAtom = atom = nodeStr.getAtomName();
                    if (atom.length() > atomRef.length()) {
                        subAtom = atom.substring(0, atomRef.length());
                    }
                    if ((resNo = nodeStr.getResNo()) == resRefNo && subAtom.equalsIgnoreCase(atomRef)) {
                        Vector vecMapSet = nodeStr.getMappingSet();
                        int w = 0;
                        while (w < vecMapSet.size()) {
                            Node resonNode = (Node)vecMapSet.elementAt(w);
                            double csProton = resonNode.getProtonCS();
                            double csHeavy = resonNode.getHeavyCS();
                            if (Math.abs(csProton - csRef) < 0.05 && Math.abs(csHeavy - csHeavyRef) < 0.5) {
                                isRefInCur = true;
                            }
                            ++w;
                        }
                    }
                    ++j2;
                }
                if (!isRefInCur) {
                    ++missing;
                    System.out.println("Missing proton assignment: " + resRef + " " + resRefNo + " - " + atomRef);
                }
            }
            ++k;
        }
        System.out.println("Total number of sidechain protons in ref table: " + totalScH);
        System.out.println("Total number of missing sidechain assignments: " + missing);
    }

    public void StatisticsAllSCAssignmentOld(Vector vecResonGraph, Vector vecStructGraph, int[][] Map2, Vector vecRefAsg) {
        Peak pk = new Peak();
        int totalScH = 0;
        int missing = 0;
        boolean averSize = false;
        int sum = 0;
        int maxSize = 0;
        String maxStr = "";
        int[] counter = new int[200];
        Assign asg = new Assign();
        int notInRef = 0;
        int j = 0;
        while (j < vecStructGraph.size()) {
            Node nodeStr = (Node)vecStructGraph.elementAt(j);
            String res = nodeStr.getResName();
            String atom = nodeStr.getAtomName();
            boolean isAtomInRefAsg = false;
            boolean isHeavyInRefAsg = false;
            String atomHeavy = pk.GetHeavyAtomFromProton(res, atom);
            int resNo = nodeStr.getResNo();
            if (!(atom.equalsIgnoreCase("CA") || atom.equalsIgnoreCase("N") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H") || atom.equalsIgnoreCase("HA") || atom.equalsIgnoreCase("HA1") || atom.equalsIgnoreCase("HA2") || atom.equalsIgnoreCase("HA3") || atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("CB") || res.equalsIgnoreCase("CYS") && atom.equalsIgnoreCase("HG"))) {
                String atomRef;
                int resRefNo;
                H1CS h1cs;
                boolean isProtonFound = false;
                boolean isHeavyFound = false;
                boolean isFound = false;
                int mappingSize = 0;
                Vector vecRefAsgStereo = asg.SwapStereoAsg(vecRefAsg, resNo);
                int k = 0;
                while (k < vecRefAsg.size()) {
                    h1cs = (H1CS)vecRefAsg.elementAt(k);
                    resRefNo = h1cs.getResidueNo();
                    atomRef = h1cs.getAtomName();
                    String subAtom = atom;
                    if (atom.length() > atomRef.length()) {
                        subAtom = atom.substring(0, atomRef.length());
                    }
                    if (resNo == resRefNo && subAtom.equalsIgnoreCase(atomRef)) {
                        isAtomInRefAsg = true;
                    }
                    ++k;
                }
                if (!isAtomInRefAsg) {
                    ++notInRef;
                } else {
                    k = 0;
                    while (k < vecRefAsg.size()) {
                        h1cs = (H1CS)vecRefAsg.elementAt(k);
                        resRefNo = h1cs.getResidueNo();
                        atomRef = h1cs.getAtomName();
                        if (resNo == resRefNo && atomHeavy.equalsIgnoreCase(atomRef)) {
                            isHeavyInRefAsg = true;
                        }
                        ++k;
                    }
                    int i = 0;
                    while (i < vecResonGraph.size()) {
                        Node nodeReson = (Node)vecResonGraph.elementAt(i);
                        double cs_h = nodeReson.getProtonCS();
                        double cs_heavy = nodeReson.getHeavyCS();
                        if (Map2[i][j] != 0) {
                            double csRef;
                            String subAtom;
                            String atomRef2;
                            int resRefNo2;
                            H1CS h1cs2;
                            int k2 = 0;
                            while (k2 < vecRefAsg.size()) {
                                h1cs2 = (H1CS)vecRefAsg.elementAt(k2);
                                resRefNo2 = h1cs2.getResidueNo();
                                atomRef2 = h1cs2.getAtomName();
                                subAtom = atom;
                                if (atom.length() > atomRef2.length()) {
                                    subAtom = atom.substring(0, atomRef2.length());
                                }
                                if (resNo == resRefNo2 && subAtom.equalsIgnoreCase(atomRef2)) {
                                    isAtomInRefAsg = true;
                                }
                                csRef = h1cs2.getH1CS();
                                if (resNo == resRefNo2 && subAtom.equalsIgnoreCase(atomRef2) && Math.abs(csRef - cs_h) < 0.05) {
                                    isProtonFound = true;
                                }
                                ++k2;
                            }
                            k2 = 0;
                            while (k2 < vecRefAsgStereo.size()) {
                                h1cs2 = (H1CS)vecRefAsgStereo.elementAt(k2);
                                resRefNo2 = h1cs2.getResidueNo();
                                atomRef2 = h1cs2.getAtomName();
                                subAtom = atom;
                                if (atom.length() > atomRef2.length()) {
                                    subAtom = atom.substring(0, atomRef2.length());
                                }
                                if (resNo == resRefNo2 && subAtom.equalsIgnoreCase(atomRef2)) {
                                    isAtomInRefAsg = true;
                                }
                                csRef = h1cs2.getH1CS();
                                if (resNo == resRefNo2 && subAtom.equalsIgnoreCase(atomRef2) && Math.abs(csRef - cs_h) < 0.05) {
                                    isProtonFound = true;
                                }
                                ++k2;
                            }
                            if (!isHeavyInRefAsg) {
                                isHeavyFound = true;
                            }
                            k2 = 0;
                            while (k2 < vecRefAsg.size()) {
                                h1cs2 = (H1CS)vecRefAsg.elementAt(k2);
                                resRefNo2 = h1cs2.getResidueNo();
                                atomRef2 = h1cs2.getAtomName();
                                double csRef2 = h1cs2.getH1CS();
                                if (resNo == resRefNo2 && atomHeavy.equalsIgnoreCase(atomRef2) && Math.abs(csRef2 - cs_heavy) < 0.5) {
                                    isHeavyFound = true;
                                }
                                ++k2;
                            }
                            ++mappingSize;
                        }
                        ++i;
                    }
                    int n = mappingSize;
                    counter[n] = counter[n] + 1;
                    if (isHeavyFound && isProtonFound) {
                        isFound = true;
                    }
                    if (!isFound) {
                        ++missing;
                        System.out.println("Missing sidechain assignment: " + resNo + " " + res + " - " + atom);
                    }
                    ++totalScH;
                    if (mappingSize > maxSize) {
                        maxSize = mappingSize;
                        maxStr = String.valueOf(resNo) + " " + res + " - " + atom;
                    }
                    sum += mappingSize;
                }
            }
            ++j;
        }
        System.out.println("Total number of protons not in the reference table: " + notInRef);
        System.out.println("Total number of sidechain protons: " + totalScH);
        System.out.println("Total number of missing sidechain assignments: " + missing);
        System.out.println("Average size of mappings: " + sum / totalScH);
        System.out.println("Maximum size of mappings: " + maxSize + "  happened in " + maxStr);
        int i = 0;
        while (i <= 20) {
            System.out.println("Total number of mapping sets with size " + i + " is : " + counter[i]);
            ++i;
        }
    }

    public void AddProtonCoordinates(int resID, String resName, String atomName, Cartesian coord, Vector vecOldGraph) {
        Node node;
        boolean isInPres = false;
        int i = 0;
        while (i < vecOldGraph.size()) {
            node = (Node)vecOldGraph.elementAt(i);
            int preResID = node.getResNo();
            String preAtomName = node.getAtomName();
            if (resID == preResID && preAtomName.equalsIgnoreCase(atomName)) {
                node.AddCoord(coord);
                isInPres = true;
            }
            ++i;
        }
        if (!isInPres) {
            Vector<Cartesian> atomVecT = new Vector<Cartesian>();
            atomVecT.add(coord);
            node = new Node(vecOldGraph.size(), resID, resName, atomName, atomVecT);
            vecOldGraph.add(node);
        }
    }

    public Vector ConstructProtonPositions(Vector pdbBBVec, String rotSrc, double noeUp) {
        double distUpClose = 2.8;
        Pdb pp = new Pdb();
        Vector<Pdb> vecPdbAllRots = pp.AllRotamersStructure(pdbBBVec, rotSrc);
        boolean curID = true;
        Vector vecAllNodes = new Vector();
        int i = 0;
        while (i < vecPdbAllRots.size()) {
            Pdb pdb = vecPdbAllRots.elementAt(i);
            int resNo = pdb.getResidueNo();
            String resName = pdb.getResidue();
            Vector<Cartesian> vecAtom = pdb.getAtomVec();
            int j = 0;
            while (j < vecAtom.size()) {
                String atomName;
                boolean isMethyl = false;
                Cartesian cc = vecAtom.elementAt(j);
                String subAtomName = atomName = cc.getAtom();
                if (atomName.length() > 1) {
                    subAtomName = atomName.substring(0, atomName.length() - 1);
                }
                if (!(resName.equalsIgnoreCase("TYR") && atomName.equalsIgnoreCase("HH") || resName.equalsIgnoreCase("CYS") && atomName.equalsIgnoreCase("HG") || resName.equalsIgnoreCase("SER") && atomName.equalsIgnoreCase("HG") || resName.equalsIgnoreCase("LYS") && (atomName.equalsIgnoreCase("HZ1") || atomName.equalsIgnoreCase("HZ2") || atomName.equalsIgnoreCase("HZ3")) || resName.equalsIgnoreCase("ASP") && atomName.equalsIgnoreCase("HD2") || resName.equalsIgnoreCase("GLU") && atomName.equalsIgnoreCase("HE2") || resName.equalsIgnoreCase("ARG") && (atomName.equalsIgnoreCase("HE") || subAtomName.equalsIgnoreCase("HH1") || subAtomName.equalsIgnoreCase("HH2")) || resName.equalsIgnoreCase("THR") && atomName.equalsIgnoreCase("HG1"))) {
                    if (resName.equalsIgnoreCase("ALA") && (atomName.equalsIgnoreCase("HB1") || atomName.equalsIgnoreCase("HB2") || atomName.equalsIgnoreCase("HB3"))) {
                        atomName = "HB";
                    }
                    if (resName.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                        atomName = "HG2";
                    }
                    if (resName.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13"))) {
                        atomName = "HD1";
                    }
                    if (resName.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13"))) {
                        atomName = "HD1";
                    }
                    if (resName.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD21") || atomName.equalsIgnoreCase("HD22") || atomName.equalsIgnoreCase("HD23"))) {
                        atomName = "HD2";
                    }
                    if (resName.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG11") || atomName.equalsIgnoreCase("HG12") || atomName.equalsIgnoreCase("HG13"))) {
                        atomName = "HG1";
                    }
                    if (resName.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                        atomName = "HG2";
                    }
                    if (resName.equalsIgnoreCase("THR") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                        atomName = "HG2";
                    }
                    if (resName.equalsIgnoreCase("MET") && (atomName.equalsIgnoreCase("HE1") || atomName.equalsIgnoreCase("HE2") || atomName.equalsIgnoreCase("HE3"))) {
                        atomName = "HE";
                    }
                    if (atomName.substring(0, 1).equalsIgnoreCase("H")) {
                        this.AddProtonCoordinates(resNo, resName, atomName, cc, vecAllNodes);
                    }
                }
                ++j;
            }
            ++i;
        }
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        int i2 = 0;
        while (i2 < vecAllNodes.size()) {
            Node nodeA = (Node)vecAllNodes.elementAt(i2);
            Vector vecAtomA = nodeA.getAtomVec();
            int i1 = 0;
            while (i1 < vecAtomA.size()) {
                Cartesian ccA = (Cartesian)vecAtomA.elementAt(i1);
                coordA = ccA.getXYZ();
                int j = 0;
                while (j < vecAllNodes.size()) {
                    Node nodeB = (Node)vecAllNodes.elementAt(j);
                    if (i2 != j) {
                        Vector vecAtomB = nodeB.getAtomVec();
                        boolean isAllIn = true;
                        boolean isAllInClose = true;
                        int j1 = 0;
                        while (j1 < vecAtomB.size()) {
                            Cartesian ccB = (Cartesian)vecAtomB.elementAt(j1);
                            coordB = ccB.getXYZ();
                            double disTemp = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                            if (disTemp > noeUp) {
                                isAllIn = false;
                            }
                            if (disTemp > distUpClose) {
                                isAllInClose = false;
                            }
                            ++j1;
                        }
                        if (isAllIn) {
                            nodeA.AddAdj(nodeB);
                            nodeB.AddAdj(nodeA);
                        }
                        if (isAllInClose) {
                            nodeA.AddCloseAdj(nodeB);
                            nodeB.AddCloseAdj(nodeA);
                        }
                    }
                    ++j;
                }
                ++i1;
            }
            ++i2;
        }
        return vecAllNodes;
    }

    public Vector UpdateStructGraphAdj(Vector pdbVec, Vector vecGraphOld, double noeUp, double[][] distMatrix) {
        Node node;
        double distUpClose = 2.8;
        Pdb pp = new Pdb();
        boolean curID = true;
        double[] coordA = new double[]{0.0, 0.0, 0.0};
        double[] coordB = new double[]{0.0, 0.0, 0.0};
        int i = 0;
        while (i < vecGraphOld.size()) {
            node = (Node)vecGraphOld.elementAt(i);
            node.atomVec = new Vector();
            ++i;
        }
        i = 0;
        while (i < vecGraphOld.size()) {
            node = (Node)vecGraphOld.elementAt(i);
            int resNo = node.getResNo();
            String atom = node.getAtomName();
            int j = 0;
            while (j < pdbVec.size()) {
                Pdb pdb = (Pdb)pdbVec.elementAt(j);
                int resNoPdb = pdb.getResidueNo();
                String resName = pdb.getResidue();
                Vector<Cartesian> vecAtom = pdb.getAtomVec();
                int k = 0;
                while (k < vecAtom.size()) {
                    String atomName;
                    boolean isMethyl = false;
                    Cartesian cc = vecAtom.elementAt(k);
                    String subAtomName = atomName = cc.getAtom();
                    if (atomName.length() > 1) {
                        subAtomName = atomName.substring(0, atomName.length() - 1);
                    }
                    if (!(resName.equalsIgnoreCase("TYR") && atomName.equalsIgnoreCase("HH") || resName.equalsIgnoreCase("CYS") && atomName.equalsIgnoreCase("HG") || resName.equalsIgnoreCase("SER") && atomName.equalsIgnoreCase("HG") || resName.equalsIgnoreCase("LYS") && (atomName.equalsIgnoreCase("HZ1") || atomName.equalsIgnoreCase("HZ2") || atomName.equalsIgnoreCase("HZ3")) || resName.equalsIgnoreCase("ASP") && atomName.equalsIgnoreCase("HD2") || resName.equalsIgnoreCase("GLU") && atomName.equalsIgnoreCase("HE2") || resName.equalsIgnoreCase("ARG") && (atomName.equalsIgnoreCase("HE") || subAtomName.equalsIgnoreCase("HH1") || subAtomName.equalsIgnoreCase("HH2")) || resName.equalsIgnoreCase("THR") && atomName.equalsIgnoreCase("HG1"))) {
                        if (resName.equalsIgnoreCase("ALA") && (atomName.equalsIgnoreCase("HB1") || atomName.equalsIgnoreCase("HB2") || atomName.equalsIgnoreCase("HB3"))) {
                            atomName = "HB";
                        }
                        if (resName.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                            atomName = "HG2";
                        }
                        if (resName.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13"))) {
                            atomName = "HD1";
                        }
                        if (resName.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD11") || atomName.equalsIgnoreCase("HD12") || atomName.equalsIgnoreCase("HD13"))) {
                            atomName = "HD1";
                        }
                        if (resName.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD21") || atomName.equalsIgnoreCase("HD22") || atomName.equalsIgnoreCase("HD23"))) {
                            atomName = "HD2";
                        }
                        if (resName.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG11") || atomName.equalsIgnoreCase("HG12") || atomName.equalsIgnoreCase("HG13"))) {
                            atomName = "HG1";
                        }
                        if (resName.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                            atomName = "HG2";
                        }
                        if (resName.equalsIgnoreCase("THR") && (atomName.equalsIgnoreCase("HG21") || atomName.equalsIgnoreCase("HG22") || atomName.equalsIgnoreCase("HG23"))) {
                            atomName = "HG2";
                        }
                        if (resName.equalsIgnoreCase("MET") && (atomName.equalsIgnoreCase("HE1") || atomName.equalsIgnoreCase("HE2") || atomName.equalsIgnoreCase("HE3"))) {
                            atomName = "HE";
                        }
                        if (resNo == resNoPdb && atomName.equalsIgnoreCase(atom)) {
                            node.AddCoord(cc);
                        }
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < vecGraphOld.size()) {
            Node nodeA = (Node)vecGraphOld.elementAt(i);
            Vector vecAtomA = nodeA.getAtomVec();
            int i1 = 0;
            while (i1 < vecAtomA.size()) {
                Cartesian ccA = (Cartesian)vecAtomA.elementAt(i1);
                coordA = ccA.getXYZ();
                int j = 0;
                while (j < vecGraphOld.size()) {
                    Node nodeB = (Node)vecGraphOld.elementAt(j);
                    if (i != j) {
                        Vector vecAtomB = nodeB.getAtomVec();
                        boolean isAllIn = true;
                        boolean isAllInClose = true;
                        int j1 = 0;
                        while (j1 < vecAtomB.size()) {
                            Cartesian ccB = (Cartesian)vecAtomB.elementAt(j1);
                            coordB = ccB.getXYZ();
                            double disTemp = Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
                            if (disTemp <= noeUp) {
                                nodeA.AddAdj(nodeB);
                                nodeB.AddAdj(nodeA);
                                distMatrix[nodeA.getID()][nodeB.getID()] = disTemp;
                                distMatrix[nodeB.getID()][nodeA.getID()] = disTemp;
                            }
                            if (disTemp > distUpClose) {
                                isAllInClose = false;
                            }
                            ++j1;
                        }
                        if (isAllInClose) {
                            nodeA.AddCloseAdj(nodeB);
                            nodeB.AddCloseAdj(nodeA);
                        }
                    }
                    ++j;
                }
                ++i1;
            }
            ++i;
        }
        Vector vecNewGraph = new Vector();
        vecNewGraph.addAll(vecGraphOld);
        return vecNewGraph;
    }

    public boolean isInStereoSet(Node nodeSrc, Node nodeObj) {
        boolean isIn = false;
        int i = 0;
        while (i < nodeSrc.vecStereoSymSet.size()) {
            Node ndTemp = (Node)nodeSrc.vecStereoSymSet.elementAt(i);
            if (ndTemp.getID() == nodeObj.getID()) {
                isIn = true;
            }
            ++i;
        }
        return isIn;
    }

    public boolean isInCloseAdj(Node nodeSrc, Node nodeObj) {
        boolean isIn = false;
        int i = 0;
        while (i < nodeSrc.vecCloseAdj.size()) {
            Node ndTemp = (Node)nodeSrc.vecCloseAdj.elementAt(i);
            if (ndTemp.getID() == nodeObj.getID()) {
                isIn = true;
            }
            ++i;
        }
        return isIn;
    }

    public Vector ExtractBackboneAsignment(Vector vecAsg) {
        Vector<H1CS> vecBBAsg = new Vector<H1CS>();
        int i = 0;
        while (i < vecAsg.size()) {
            H1CS h1cs = (H1CS)vecAsg.elementAt(i);
            String atom = h1cs.getAtomName();
            if (atom.equalsIgnoreCase("CA") || atom.equalsIgnoreCase("N") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H") || atom.equalsIgnoreCase("HA") || atom.equalsIgnoreCase("HA1") || atom.equalsIgnoreCase("HA2") || atom.equalsIgnoreCase("HA3") || atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("CB")) {
                vecBBAsg.add(h1cs);
            }
            ++i;
        }
        return vecBBAsg;
    }

    public Vector ExtractSideChainAsignment(Vector vecAsg) {
        Vector<H1CS> vecBBAsg = new Vector<H1CS>();
        int i = 0;
        while (i < vecAsg.size()) {
            H1CS h1cs = (H1CS)vecAsg.elementAt(i);
            String atom = h1cs.getAtomName();
            if (!(atom.equalsIgnoreCase("CA") || atom.equalsIgnoreCase("N") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H") || atom.equalsIgnoreCase("HA") || atom.equalsIgnoreCase("HA1") || atom.equalsIgnoreCase("HA2") || atom.equalsIgnoreCase("HA3") || atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("CB"))) {
                vecBBAsg.add(h1cs);
            }
            ++i;
        }
        return vecBBAsg;
    }

    public Vector ConstructResonGraph(Vector vecNodeSet, Vector vecNoesy, double errH1, double errH3, double errC, double errN) {
        Vector vecResonGraph = new Vector();
        int i = 0;
        while (i < vecNoesy.size()) {
            Noesy noesy = (Noesy)vecNoesy.elementAt(i);
            double errHeavy = 0.0;
            double freH1 = noesy.getH1();
            double freHeavy = noesy.getHeavy();
            double freH2 = noesy.getH2();
            errHeavy = freHeavy > 80.0 ? errN : errC;
            int j = 0;
            while (j < vecNodeSet.size()) {
                Node node = (Node)vecNodeSet.elementAt(j);
                double csH = node.getProtonCS();
                double csHeavy = node.getHeavyCS();
                if (!(Math.abs(csH - freH1) > errH1) && !(Math.abs(csHeavy - freHeavy) > errHeavy)) {
                    int k = 0;
                    while (k < vecNodeSet.size()) {
                        Node node2;
                        double csH2;
                        if (k != j && Math.abs((csH2 = (node2 = (Node)vecNodeSet.elementAt(k)).getProtonCS()) - freH2) < errH3) {
                            node.AddAdj(node2);
                            node2.AddAdj(node);
                            node.AddAdjNOESY(noesy);
                            node2.AddAdjNOESY(noesy);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        vecResonGraph.addAll(vecNodeSet);
        return vecResonGraph;
    }

    public void ConstructResonGraphSymmetry(Vector vecResonGraph, Vector vecNoesy, double errH1, double errH3, double errC, double errN) {
        int i = 0;
        while (i < vecNoesy.size()) {
            Noesy noesy = (Noesy)vecNoesy.elementAt(i);
            double errHeavy = 0.0;
            double freH1 = noesy.getH1();
            double freHeavy = noesy.getHeavy();
            double freH2 = noesy.getH2();
            errHeavy = freHeavy > 80.0 ? errN : errC;
            int j = 0;
            while (j < vecResonGraph.size()) {
                Node node = (Node)vecResonGraph.elementAt(j);
                double csH = node.getProtonCS();
                double csHeavy = node.getHeavyCS();
                if (!(Math.abs(csH - freH1) > errH1) && !(Math.abs(csHeavy - freHeavy) > errHeavy)) {
                    int k = 0;
                    while (k < vecResonGraph.size()) {
                        if (k != j) {
                            Node node2 = (Node)vecResonGraph.elementAt(k);
                            double csH2 = node2.getProtonCS();
                            double csHeavy2 = node2.getHeavyCS();
                            if (Math.abs(csH2 - freH2) < errH3) {
                                node.vecSymSet.add(node2);
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < vecResonGraph.size()) {
            Node node = (Node)vecResonGraph.elementAt(i);
            Vector vec_sym = node.vecSymSet;
            int k = 0;
            while (k < vec_sym.size()) {
                Node ndSym = (Node)vec_sym.elementAt(k);
                Vector vec_sym2 = ndSym.vecSymSet;
                boolean isSymmetry = false;
                int w = 0;
                while (w < vec_sym2.size()) {
                    Node nd = (Node)vec_sym2.elementAt(w);
                    int symID = nd.getID();
                    if (symID == i) {
                        isSymmetry = true;
                    }
                    ++w;
                }
                if (!isSymmetry) {
                    vec_sym.remove(k);
                    --k;
                }
                ++k;
            }
            ++i;
        }
    }

    public Vector ConstructResonGraphFromAsgedList(Vector vecAsged, Vector vecUnAsged) {
        Node node;
        int resNoT;
        String atomT;
        String resT;
        double cs_Temp;
        H1CS h1csHeavy;
        String heavyName;
        int resNo;
        String atom;
        String res;
        double cs_h;
        H1CS h1cs;
        double cs_heavy;
        Vector<Node> vecGraph = new Vector<Node>();
        Peak pk = new Peak();
        int curId = 0;
        int i = 0;
        while (i < vecAsged.size()) {
            cs_heavy = -999.9;
            h1cs = (H1CS)vecAsged.elementAt(i);
            cs_h = h1cs.getH1CS();
            res = h1cs.getResidueType();
            atom = h1cs.getAtomName();
            resNo = h1cs.getResidueNo();
            if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                heavyName = pk.GetHeavyAtomFromProton(res, atom);
                int j = 0;
                while (j < vecAsged.size()) {
                    h1csHeavy = (H1CS)vecAsged.elementAt(j);
                    cs_Temp = h1csHeavy.getH1CS();
                    resT = h1csHeavy.getResidueType();
                    atomT = h1csHeavy.getAtomName();
                    resNoT = h1csHeavy.getResidueNo();
                    if (resNoT == resNo && atomT.equalsIgnoreCase(heavyName)) {
                        cs_heavy = cs_Temp;
                    }
                    ++j;
                }
                node = new Node(curId, cs_h, cs_heavy, true);
                node.setAtomName(atom);
                node.setResName(res);
                node.setResNo(resNo);
                vecGraph.add(node);
                ++curId;
            }
            ++i;
        }
        if (vecUnAsged == null) {
            return vecGraph;
        }
        i = 0;
        while (i < vecUnAsged.size()) {
            cs_heavy = -999.9;
            h1cs = (H1CS)vecUnAsged.elementAt(i);
            cs_h = h1cs.getH1CS();
            res = h1cs.getResidueType();
            atom = h1cs.getAtomName();
            resNo = h1cs.getResidueNo();
            if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                heavyName = pk.GetHeavyAtomFromProton(res, atom);
                int j = 0;
                while (j < vecUnAsged.size()) {
                    h1csHeavy = (H1CS)vecUnAsged.elementAt(j);
                    cs_Temp = h1csHeavy.getH1CS();
                    resT = h1csHeavy.getResidueType();
                    atomT = h1csHeavy.getAtomName();
                    resNoT = h1csHeavy.getResidueNo();
                    if (resNoT == resNo && atomT.equalsIgnoreCase(heavyName)) {
                        cs_heavy = cs_Temp;
                    }
                    ++j;
                }
                node = new Node(curId, cs_h, cs_heavy, false);
                node.setAtomName(" ");
                node.setResName(" ");
                node.setResNo(0);
                vecGraph.add(node);
                ++curId;
            }
            ++i;
        }
        return vecGraph;
    }

    public Vector AddResonanceNode(Vector vecOldGraph, double csH, double csHeavy, double csErrH, double csErrC, double csErrN) {
        Vector vecNewGraph = new Vector();
        boolean isInPres = false;
        int i = 0;
        while (i < vecOldGraph.size()) {
            Node node = (Node)vecOldGraph.elementAt(i);
            double cs_Proton = node.getProtonCS();
            double cs_Heavy = node.getHeavyCS();
            double csMaxHeavy = Math.max(cs_Heavy, csHeavy);
            double csErrHeavy = 0.0;
            csErrHeavy = csMaxHeavy > 80.0 ? csErrN : csErrC;
            if (!(csHeavy < -100.0) && csHeavy > -100.0 && Math.abs(csH - cs_Proton) < csErrH && Math.abs(csHeavy - cs_Heavy) < csErrHeavy) {
                isInPres = true;
                if (!node.getIsAssigned()) {
                    Node node2 = new Node(node.getID(), csH, csHeavy, false);
                }
            }
            ++i;
        }
        if (!isInPres) {
            Node node = new Node(vecOldGraph.size(), csH, csHeavy, false);
            vecOldGraph.add(node);
        }
        vecNewGraph.addAll(vecOldGraph);
        return vecNewGraph;
    }

    public boolean isMappedBetwTwoSetsCalScore(Node nodeReson, Node nodeStruct, Vector vecNodeSetA, Vector vecNodeSetB, int[][] M, boolean isConsiderAssigned, int threshold, double[] Score, Vector vecNoesy) {
        boolean isMapped = false;
        int counter = 0;
        Peak pk = new Peak();
        double cs_proton = nodeReson.getProtonCS();
        double cs_heavy = nodeReson.getHeavyCS();
        String res = nodeStruct.getResName();
        String atom = nodeStruct.getAtomName();
        int resNo = nodeStruct.getResNo();
        String heavName = pk.GetHeavyAtomFromProton(res, atom);
        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
        int i = 0;
        while (i < vecNodeSetA.size()) {
            Node nodeA = (Node)vecNodeSetA.elementAt(i);
            boolean isAsgedA = nodeA.getIsAssigned();
            int idA = nodeA.getID();
            if (!isConsiderAssigned || isAsgedA) {
                int j = 0;
                while (j < vecNodeSetB.size()) {
                    String atomName;
                    Node nodeB = (Node)vecNodeSetB.elementAt(j);
                    boolean isAsgedB = nodeB.getIsAssigned();
                    String subAtom = atomName = nodeB.getAtomName();
                    if (atomName.length() >= 2) {
                        subAtom = atomName.substring(0, 2);
                    }
                    int idB = nodeB.getID();
                    if (!(!isConsiderAssigned ? !isAsgedB && !subAtom.equalsIgnoreCase("HB") : !isAsgedB)) {
                        if (M[idA][idB] == 1) {
                            double cs_protonSec = nodeA.getProtonCS();
                            double cs_heavySec = nodeA.getHeavyCS();
                            String resSec = nodeB.getResName();
                            String atomSec = nodeB.getAtomName();
                            String heavyNameSec = pk.GetHeavyAtomFromProton(resSec, atomSec);
                            int resNoSec = nodeB.getResNo();
                            double distUp = 6.0;
                            if (this.isInCloseAdj(nodeB, nodeStruct)) {
                                distUp = 2.7;
                            }
                            vecBackNoe.add(new BackNoe(cs_proton, cs_heavy, cs_protonSec, distUp, 0.0, resNo, resNoSec, res, resSec, atom, heavName, atomSec));
                            vecBackNoe.add(new BackNoe(cs_protonSec, cs_heavySec, cs_proton, distUp, 0.0, resNoSec, resNo, resSec, res, atomSec, heavyNameSec, atom));
                            ++counter;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (counter >= threshold) {
            isMapped = true;
        }
        Assign asg = new Assign();
        int[] numPeaks = new int[1];
        double csErrH = 0.04;
        double csErrN = 0.4;
        double csErrCA = 0.4;
        BackNoe bkNoe = new BackNoe();
        Vector<BackNoe> vecBackNoeNew = bkNoe.DeleteRepeat(vecBackNoe);
        double dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNew, vecNoesy, numPeaks, true);
        Score[0] = vecBackNoe.size() > 1 ? (dbScore *= (double)vecBackNoeNew.size()) : 0.0;
        return isMapped;
    }

    public boolean isMappedBetwTwoSets(Vector vecNodeSetA, Vector vecNodeSetB, int[][] M, boolean isConsiderAssigned, int threshold, double[] Score) {
        boolean isMapped = false;
        int counter = 0;
        Peak pk = new Peak();
        Vector vecBackNoe = new Vector();
        int i = 0;
        while (i < vecNodeSetA.size()) {
            Node nodeA = (Node)vecNodeSetA.elementAt(i);
            boolean isAsgedA = nodeA.getIsAssigned();
            int idA = nodeA.getID();
            if (!isConsiderAssigned || isAsgedA) {
                int j = 0;
                while (j < vecNodeSetB.size()) {
                    Node nodeB = (Node)vecNodeSetB.elementAt(j);
                    boolean isAsgedB = nodeB.getIsAssigned();
                    int idB = nodeB.getID();
                    if ((!isConsiderAssigned || isAsgedB) && M[idA][idB] == 1) {
                        double cs_protonSec = nodeA.getProtonCS();
                        double cs_heavySec = nodeA.getHeavyCS();
                        int resNoSec = nodeB.getResNo();
                        ++counter;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (counter >= threshold) {
            isMapped = true;
        }
        Assign asg = new Assign();
        int[] numPeaks = new int[1];
        double csErrH = 0.05;
        double csErrN = 0.4;
        double csErrCA = 0.4;
        Score[0] = counter;
        return isMapped;
    }

    public Vector ExtractAllResonFromNOESY(Vector vecNOESY, double csErrH, double csErrC, double csErrN) {
        Nasca isoGraph = new Nasca();
        Vector vecAllResonances = new Vector();
        int i = 0;
        while (i < vecNOESY.size()) {
            Noesy noesy = (Noesy)vecNOESY.elementAt(i);
            double csHeavy = noesy.getHeavy();
            double csH1 = noesy.getH1();
            double csH2 = noesy.getH2();
            double d = noesy.getUpperDist();
            ++i;
        }
        return vecAllResonances;
    }

    public void doNasca(String src, String strOut, String strInput) throws JampackException {
        int j;
        boolean isDebug = false;
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        long startTime = System.currentTimeMillis();
        Pdb pp = new Pdb();
        Vector<Map<String, String>> paraVec = asg.ParamReader(String.valueOf(src) + strInput);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        int nIs4DNoesy = 0;
        String strReson = "";
        String strSeq = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strResNameScheme = "";
        String strIsCheckLongAA = "";
        String strHaNoesy3D = "";
        String strResFormat = "";
        String strBB = "";
        String stroutName = "";
        String strNoesyFormat = "";
        String strOutOrFormat = "";
        String strIsCheck = "";
        String strRefPdb = "";
        String strRefNameSchem = "";
        String strIsWholeStr = "";
        String strPdbNameScheme = "";
        String str4DNoesy = "";
        String stroutResonName = "";
        String strOutResonFormat = "";
        int nIsoriginalUp = 0;
        double noeLimit = 0.0;
        double metCor = 0.0;
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            if (paraMap.containsKey("RESFORMAT")) {
                strResFormat = paraMap.get("RESFORMAT");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            if (paraMap.containsKey("PDBNAMESCHEME")) {
                strPdbNameScheme = paraMap.get("PDBNAMESCHEME");
            }
            if (paraMap.containsKey("OUTNOENAME")) {
                stroutName = paraMap.get("OUTNOENAME");
            }
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("NOELIMIT")) {
                noeLimit = Double.parseDouble(paraMap.get("NOELIMIT"));
            }
            if (paraMap.containsKey("IS4DNOESY")) {
                nIs4DNoesy = Integer.parseInt(paraMap.get("IS4DNOESY"));
            }
            if (paraMap.containsKey("4D-NOESY")) {
                str4DNoesy = paraMap.get("4D-NOESY");
            }
            if (paraMap.containsKey("ISORIGINALUP")) {
                nIsoriginalUp = Integer.parseInt(paraMap.get("ISORIGINALUP"));
            }
            if (paraMap.containsKey("RESNAMESCHEME")) {
                strResNameScheme = paraMap.get("RESNAMESCHEME");
            }
            if (paraMap.containsKey("NOESY-FORMAT")) {
                strNoesyFormat = paraMap.get("NOESY-FORMAT");
            }
            if (paraMap.containsKey("ISCHECKLONGAA")) {
                strIsCheckLongAA = paraMap.get("ISCHECKLONGAA");
            }
            if (paraMap.containsKey("ISCHECK")) {
                strIsCheck = paraMap.get("ISCHECK");
            }
            if (paraMap.containsKey("REFPDB")) {
                strRefPdb = paraMap.get("REFPDB");
            }
            if (paraMap.containsKey("METHYL-CORRECTION")) {
                metCor = Double.parseDouble(paraMap.get("METHYL-CORRECTION"));
            }
            if (paraMap.containsKey("REFNAMESCHEME")) {
                strRefNameSchem = paraMap.get("REFNAMESCHEME");
            }
            if (paraMap.containsKey("ISWHOLESTRUCTURE")) {
                strIsWholeStr = paraMap.get("ISWHOLESTRUCTURE");
            }
            if (paraMap.containsKey("ISOUTORFORMAT")) {
                strOutOrFormat = paraMap.get("ISOUTORFORMAT");
            }
            if (paraMap.containsKey("OUTRESONANCENAME")) {
                stroutResonName = paraMap.get("OUTRESONANCENAME");
            }
            if (paraMap.containsKey("OUTRESONANCEFORMAT")) {
                strOutResonFormat = paraMap.get("OUTRESONANCEFORMAT");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<Object> assignVec = new Vector();
        if (strResFormat.equalsIgnoreCase("CYANA")) {
            assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        } else if (strResFormat.equalsIgnoreCase("BMRB")) {
            assignVec = h1CS.h1CSReader_BMRB(assignFile);
        } else {
            System.out.println("unknown format of the resonance file...");
            System.exit(0);
        }
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Noesy> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        Vector<Object> Noe4DVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!str4DNoesy.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + str4DNoesy;
            Noe4DVec = strNoesyFormat.equalsIgnoreCase("XEASY") ? noesy.NoesyReader(strNoeFile) : noesy.NoesyReaderNMRView4D(strNoeFile);
        }
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector<Noesy> vecNoesy4D = new Vector<Noesy>();
        vecNoesy4D.addAll(Noe4DVec);
        Vector<Object> vecNewNoesy = new Vector();
        if (vecNoesy.size() > 0) {
            vecNewNoesy = noesy.SetCalibration(vecNoesy);
        }
        Vector<Object> vecNewNoesy4D = new Vector();
        if (vecNoesy4D.size() > 0) {
            vecNewNoesy4D = noesy.SetCalibration(vecNoesy4D);
        }
        double[] constant = new double[1];
        Vector<Pdb> vecSSE = new Vector<Pdb>();
        noesy.SetCalibrationN15(hnNoeVec, vecSSE, assignVec, constant);
        String pdbFile = String.valueOf(src) + strBB;
        Vector<Pdb> pdbVecBB = pp.readPdb(pdbFile);
        Vector<Pdb> pdbVecNew = new Vector();
        pdbVecNew = strIsWholeStr.equalsIgnoreCase("1") ? pp.residueNameUpdateNoStr(vecSeq, pdbVecBB) : pp.residueNameUpdate(vecSeq, pdbVecBB);
        Vector<Object> pdbVecNewSec = new Vector();
        if (strPdbNameScheme.equalsIgnoreCase("PDB-OLD")) {
            pdbVecNewSec = pp.nameConvertOrder(pdbVecNew);
        } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-NEW")) {
            pdbVecNewSec = pp.nameConvert2PDBNew(pdbVecNew);
        } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-OLD")) {
            Vector<Pdb> pdbVecSSE22 = pp.nameConvertOrder(pdbVecNew);
            pdbVecNewSec = pp.nameConvert2PDBNew(pdbVecSSE22);
        } else {
            pdbVecNewSec.addAll(pdbVecNew);
        }
        Vector<Object> vecStructureAll = new Vector<Object>();
        vecStructureAll.addAll(pdbVecNewSec);
        Vector<Pdb> vecBBTemp = pp.OutputBackbone(pdbVecNewSec);
        pdbVecNewSec = new Vector();
        pdbVecNewSec.addAll(vecBBTemp);
        Nasca nasca = new Nasca();
        String userDir = System.getProperty("user.dir");
        String srcRot = String.valueOf(userDir) + "/system/rot-lib/";
        Vector vecLabels = nasca.ConstructProtonPositions(pdbVecNewSec, srcRot, 5.0);
        Vector<Object> vecAsgNew = new Vector();
        vecAsgNew = h1CS.CSNameConvertFromBMRBNewToPDBNew(assignVec);
        assignVec = new Vector();
        assignVec.addAll(vecAsgNew);
        Vector vecBBAsg = nasca.ExtractBackboneAsignment(assignVec);
        Vector vecResonNodeSet = nasca.ConstructResonGraphFromAsgedList(vecBBAsg, null);
        i = 0;
        while (i < vecNewNoesy.size()) {
            Noesy ne = (Noesy)vecNewNoesy.elementAt(i);
            double csH1 = ne.getH1();
            double csHeavy = ne.getHeavy();
            double csH2 = ne.getH2();
            Vector vecResGraphTemp = new Vector();
            vecResGraphTemp = nasca.AddResonanceNode(vecResonNodeSet, csH1, csHeavy, 0.02, 0.1, 0.1);
            vecResonNodeSet = new Vector();
            vecResonNodeSet.addAll(vecResGraphTemp);
            ++i;
        }
        i = 0;
        while (i < vecResonNodeSet.size()) {
            Node node = (Node)vecResonNodeSet.elementAt(i);
            Vector vecAdj = node.getAdjVec();
            int counter = 1;
            double csProtonSum = node.getProtonCS();
            double csHeavySum = node.getHeavyCS();
            int k = 0;
            while (k < vecAdj.size()) {
                Node ndAdj = (Node)vecAdj.elementAt(k);
                csProtonSum += ndAdj.getProtonCS();
                csHeavySum += ndAdj.getHeavyCS();
                ++counter;
                ++k;
            }
            node.setProtonCS(csProtonSum /= (double)counter);
            node.setHeavyCS(csHeavySum /= (double)counter);
            node.EmptyAdjSet();
            ++i;
        }
        Vector vecResonGraph = nasca.ConstructResonGraph(vecResonNodeSet, vecNewNoesy, 0.04, 0.04, 0.1, 0.1);
        this.ConstructResonGraphSymmetry(vecResonNodeSet, vecNewNoesy, 0.03, 0.03, 0.1, 0.1);
        String srcBMRB = String.valueOf(userDir) + "/system/BMRB_CS.txt";
        Vector<H1CS> vecBMRB = h1CS.ReadBMRBSatistics(srcBMRB);
        Vector<Object> vecBMRBNew = new Vector();
        vecBMRBNew = h1CS.CSNameConvertFromBMRBNewToPDBNew(vecBMRB);
        int[][] Map2 = new int[vecResonGraph.size()][vecLabels.size()];
        double[][] MapScore = new double[vecResonGraph.size()][vecLabels.size()];
        this.Initialization(vecResonGraph, vecLabels, Map2, MapScore, vecBBAsg);
        this.RefineMappingBasedBMRBOutliers(vecResonGraph, vecLabels, Map2, vecBMRBNew);
        this.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        this.UpdateIsRestrained(vecResonGraph, vecLabels, Map2);
        this.RefineMappingBasedRestrained(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        this.RefineMappingForHG(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        this.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        this.RefineMappingDeeCut(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        this.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        this.PrintAllPossibleMappings(vecResonGraph, vecLabels, Map2);
        nasca.StatisticsAllSCAssignment(vecResonGraph, vecLabels, Map2, assignVec);
        this.UpdateMappingSet(vecResonGraph, vecLabels, Map2);
        H1CS h1cs = new H1CS();
        Vector vecAsgNewT0 = this.AStarSearchForSCAsgs(vecResonGraph, vecLabels, Map2, MapScore, vecNewNoesy, vecBMRBNew);
        Vector<H1CS> vecAsgNewT = h1cs.DeleteRepeatAsg(vecAsgNewT0);
        h1cs.PrintAllAssignment(vecAsgNewT);
        h1cs.PrintAllAssignmentCyana(vecAsgNewT);
        String outResFileName = String.valueOf(userDir) + stroutName;
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outResFileName)));
            if (strOutResonFormat.equalsIgnoreCase("CYANA")) {
                h1cs.PrintAllAssignmentToFileCyana(vecAsgNewT, out);
            } else {
                h1cs.PrintAllAssignmentToFileBMRB(vecAsgNewT, out);
            }
            out.close();
            System.out.println("The NOE assignment table has been generated in " + outResFileName);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + outResFileName);
        }
        catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        h1cs.CompareSCAsgsWRefAsgs(vecAsgNewT, assignVec, vecBBAsg);
        double counter = 0.0;
        int t = 0;
        while (t < vecLabels.size()) {
            Node node = (Node)vecLabels.elementAt(t);
            String ndAtom = node.getAtomName();
            int ndNo = node.getResNo();
            int k = 0;
            while (k < assignVec.size()) {
                H1CS h1csT = (H1CS)assignVec.elementAt(k);
                int refNo = h1csT.getResidueNo();
                String atom = h1csT.getAtomName();
                String subNdAtom = ndAtom;
                if (ndAtom.length() > atom.length()) {
                    subNdAtom = ndAtom.substring(0, atom.length());
                }
                if (atom.substring(0, 1).equalsIgnoreCase("H") && ndNo == refNo && subNdAtom.equalsIgnoreCase(atom)) {
                    counter += 1.0;
                    break;
                }
                ++k;
            }
            ++t;
        }
        System.out.println("Completeness of reference assignment table is: " + counter / (double)vecLabels.size());
        counter = 0.0;
        int k = 0;
        while (k < vecAsgNewT.size()) {
            H1CS h1csT = vecAsgNewT.elementAt(k);
            String atom = h1csT.getAtomName();
            if (atom.substring(0, 1).equalsIgnoreCase("H")) {
                counter += 1.0;
            }
            ++k;
        }
        System.out.println("Completeness of our assignment table is: " + counter / (double)vecLabels.size());
        Vector<Object> vecAmbgAsg = new Vector();
        allH1Vec = new Vector();
        allH1Vec = pk.allProtonSorted(vecAsgNewT);
        Collections.sort(allH1Vec, new Peak.csComparator());
        vecAmbgAsg = asg.InitAmbiAssignment(nErr, c13Err, hnErr, haErr, h1Err, vecAsgNewT, allH1Vec, vecNewNoesy);
        Vector<Noe> vecAmbgAsgTemp = noesy.SetCalibrationCyana(vecAmbgAsg, vecNewNoesy, constant[0]);
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecAmbgAsgTemp);
        Vector<Noe> vecNoeRefine2 = new Vector<Noe>();
        i = 0;
        while (i < vecAmbgAsg.size()) {
            Noe noe = (Noe)vecAmbgAsg.elementAt(i);
            int noA = noe.getResidueNoA();
            int noB = noe.getResidueNoB();
            String atomA = noe.getAtomA();
            String atomB = noe.getAtomB();
            if (noA != noB || !atomA.equalsIgnoreCase(atomB)) {
                boolean isIn = true;
                if (strOutOrFormat.equalsIgnoreCase("0")) {
                    j = 0;
                    while (j < vecNoeRefine2.size()) {
                        Noe noeT = (Noe)vecNoeRefine2.elementAt(j);
                        int noAT = noeT.getResidueNoA();
                        int noBT = noeT.getResidueNoB();
                        String atomAT = noeT.getAtomA();
                        String atomBT = noeT.getAtomB();
                        if (noA == noAT && atomA.equalsIgnoreCase(atomAT) && noB == noBT && atomB.equalsIgnoreCase(atomBT)) {
                            isIn = false;
                        }
                        if (noA == noBT && atomA.equalsIgnoreCase(atomBT) && noB == noAT && atomB.equalsIgnoreCase(atomAT)) {
                            isIn = false;
                        }
                        ++j;
                    }
                }
                if (isIn) {
                    vecNoeRefine2.add(noe);
                }
            }
            ++i;
        }
        vecAmbgAsg = new Vector();
        vecAmbgAsg.addAll(vecNoeRefine2);
        Vector<Pdb> vecRotStructure = pp.RotamSelectAndStructure(hnErr, nErr, c13Err, pdbVecNewSec, vecAsgNewT, srcRot, vecNewNoesy, 4.5, 1, constant[0]);
        Vector<Object> vecRefinedNoes = new Vector();
        vecRefinedNoes = asg.PrunAmbgNoeAsg(vecRotStructure, vecAmbgAsg, noeLimit, 0.0, nIsoriginalUp);
        Collections.sort(vecRefinedNoes, new Noe.NoeComparator());
        if (!strOutOrFormat.equalsIgnoreCase("1")) {
            i = 0;
            while (i < vecAmbgAsg.size()) {
                Noe noe = (Noe)vecAmbgAsg.elementAt(i);
                int firstResNo = noe.getResidueNoA();
                int secondResNo = noe.getResidueNoB();
                String firstResName = noe.getResidueA();
                String secondResName = noe.getResidueB();
                String firstAtomName = noe.getAtomA();
                String secondAtomName = noe.getAtomB();
                if (secondResNo < firstResNo) {
                    noe.setResNoA(secondResNo);
                    noe.setResNoB(firstResNo);
                    noe.setAtom1Name(secondAtomName);
                    noe.setAtom2Name(firstAtomName);
                    noe.setResNameA(secondResName);
                    noe.setResNameB(firstResName);
                }
                ++i;
            }
            Collections.sort(vecAmbgAsg, new Noe.noeComparatorC());
        }
        if (strIsCheckLongAA.equalsIgnoreCase("1")) {
            Vector<Noe> vecTemp = new Vector<Noe>();
            i = 0;
            while (i < vecRefinedNoes.size()) {
                Noe noe = (Noe)vecRefinedNoes.elementAt(i);
                int firstResNo = noe.getResidueNoA();
                int secondResNo = noe.getResidueNoB();
                String firstResName = noe.getResidueA();
                String secondResName = noe.getResidueB();
                String atomA = noe.getAtomA();
                String atomB = noe.getAtomB();
                String subAtomA = atomA;
                String subAtomB = atomB;
                if (atomA.length() >= 2) {
                    subAtomA = atomA.substring(0, 2);
                }
                if (atomB.length() >= 2) {
                    subAtomB = atomB.substring(0, 2);
                }
                if (Math.abs(firstResNo - secondResNo) <= 4) {
                    vecTemp.add(noe);
                } else {
                    boolean isKeep = true;
                    if (pk.isCharged(firstResName) && pk.isHydrophobic(secondResName)) {
                        isKeep = false;
                    }
                    if (pk.isCharged(secondResName) && pk.isHydrophobic(firstResName)) {
                        isKeep = false;
                    }
                    if ((subAtomB.equalsIgnoreCase("HN") || subAtomB.equalsIgnoreCase("H") || subAtomB.equalsIgnoreCase("HA") || subAtomB.equalsIgnoreCase("HB")) && (subAtomA.equalsIgnoreCase("HN") || subAtomA.equalsIgnoreCase("H") || subAtomA.equalsIgnoreCase("HA") || subAtomA.equalsIgnoreCase("HB"))) {
                        isKeep = true;
                    }
                    if (isKeep) {
                        vecTemp.add(noe);
                    }
                }
                ++i;
            }
            vecRefinedNoes = new Vector();
            vecRefinedNoes.addAll(vecTemp);
        }
        Collections.sort(vecRefinedNoes, new Noe.NoeComparator());
        Noe ne = new Noe();
        Vector<Noe> vecNoeNewT = ne.NameConvertFromPDBNewToPDBNew(vecRefinedNoes);
        vecRefinedNoes = new Vector();
        vecRefinedNoes.addAll(vecNoeNewT);
        vecNoeRefine2 = new Vector();
        Vector<Noe> vecNoeUniq = new Vector<Noe>();
        i = 0;
        while (i < vecRefinedNoes.size()) {
            Noe noe = (Noe)vecRefinedNoes.elementAt(i);
            int pkID = noe.getPeakID();
            boolean isUniq = true;
            j = 0;
            while (j < vecRefinedNoes.size()) {
                Noe noeT;
                int pkIDT;
                if (i != j && pkID == (pkIDT = (noeT = (Noe)vecRefinedNoes.elementAt(j)).getPeakID())) {
                    isUniq = false;
                }
                ++j;
            }
            if (isUniq) {
                vecNoeUniq.add(noe);
            }
            ++i;
        }
        double[] number = new double[4];
        if (strIsCheck.equalsIgnoreCase("1")) {
            Noe noe_temp = new Noe();
            String pdbFileXray = String.valueOf(src) + strRefPdb;
            Vector<Pdb> vecTempPdbBB = pp.readPdb(pdbFileXray);
            Vector<Object> vecTempPdbBB2 = new Vector();
            if (strRefNameSchem.equalsIgnoreCase("PDB-OLD")) {
                vecTempPdbBB2 = pp.nameConvertOrder(vecTempPdbBB);
            } else if (strRefNameSchem.equalsIgnoreCase("BMRB-NEW")) {
                vecTempPdbBB2 = pp.nameConvert2PDBNew(vecTempPdbBB);
            } else if (strPdbNameScheme.equalsIgnoreCase("BMRB-OLD")) {
                Vector<Pdb> pdbVecSSE22 = pp.nameConvertOrder(vecTempPdbBB);
                vecTempPdbBB2 = pp.nameConvert2PDBNew(pdbVecSSE22);
            } else {
                vecTempPdbBB2.addAll(vecTempPdbBB);
            }
            System.out.println("============================================ ");
            System.out.println("====Comparisons with reference structure===== ");
            noe_temp.CompareAsgToRefStr(vecRefinedNoes, vecTempPdbBB2, 6.0, 0.0, number);
            System.out.println("Number of correct NOE assignments in reference structure=  " + number[0]);
            System.out.println("Number of wrong NOE assignments in reference structure=  " + number[1]);
            System.out.println("Number of correct Long-Rang NOE assignments in reference structure=  " + number[2]);
            System.out.println("Number of wrong Long-Rang NOE assignments in reference structure=  " + number[3]);
            System.out.println("============================================ ");
        }
        String userDirTemp = System.getProperty("user.dir");
        if (strOutOrFormat.equalsIgnoreCase("0")) {
            String fileName = String.valueOf(userDirTemp) + stroutName;
            String xplorNoeStr = "";
            double[] disUpper = new double[1];
            try {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
                out.println("!REMARK: Total number of NOESY cross peaks is " + (vecNoesy.size() + vecNoesy4D.size()));
                out.println("!REMARK: Total number of NOEs is " + vecRefinedNoes.size());
                out.println("!REMARK: the number of unique NOE assignments is " + vecNoeUniq.size());
                out.println("!REMARK: the number of multiple NOE assignments is " + (vecRefinedNoes.size() - vecNoeUniq.size()));
                out.println("!REMARK: Number of correct assignments in reference structure=  " + number[0]);
                out.println("!REMARK: Number of wrong assignments in reference structure=  " + number[1]);
                out.println("!REMARK: Number of correct Long-Rang NOE assignments in reference structure=  " + number[2]);
                out.println("!REMARK: Number of wrong Long-Rang NOE assignments in reference structure=  " + number[3]);
                out.println("");
                out.println("");
                i = 0;
                while (i < vecRefinedNoes.size()) {
                    Noe noe = (Noe)vecRefinedNoes.elementAt(i);
                    int resNo1 = noe.getResidueNoA();
                    int resNo2 = noe.getResidueNoB();
                    String res1 = noe.getResidueA();
                    String res2 = noe.getResidueB();
                    String atom1 = noe.getAtomA();
                    String atom2 = noe.getAtomB();
                    double distUpper = noe.getUpper();
                    xplorNoeStr = pk.xplorNoeStatementNew(resNo1, res1, atom1, resNo2, res2, atom2, distUpper);
                    if (isDebug) {
                        System.out.println(xplorNoeStr);
                    }
                    out.println(xplorNoeStr);
                    ++i;
                }
                out.close();
                System.out.println("The NOE assignment table has been generated in " + fileName);
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found: " + fileName);
            }
            catch (IOException e) {
                System.out.println("IOException: the stack trace is:");
                e.printStackTrace();
            }
        } else if (strOutOrFormat.equalsIgnoreCase("1")) {
            Noe noeTemp = new Noe();
            Vector<Noe> vecMultiAsg = noeTemp.ConvertSingleToMultiAsg(vecRefinedNoes);
            String fileName = String.valueOf(userDirTemp) + stroutName;
            noeTemp.OutputMultiNOEAsg(vecMultiAsg, fileName);
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public class Node {
        private int id = 0;
        Vector vecAdj = new Vector();
        Vector vecAdjNOESY = new Vector();
        private int resNo = 0;
        private String resName = "";
        private String atomName = "";
        Vector atomVec = new Vector();
        private double csLower = 0.0;
        private double csUpper = 0.0;
        public int stereoID = -99;
        public double maxMapScore = -999.9;
        public int maxMappedID = -99;
        private double CSProton = 0.0;
        private double CSHeavy = 0.0;
        private boolean isAsigned = false;
        private boolean isRestrained = false;
        public int asgedId = -1;
        private Vector vecMappingSet = new Vector();
        public Vector vecStereoSymSet = new Vector();
        public Vector vecSymSet = new Vector();
        public Vector vecCloseAdj = new Vector();

        public Node(Node nd) {
            this.id = nd.getID();
            this.vecAdj = nd.getAdjVec();
            this.resNo = nd.getResNo();
            this.resName = nd.getResName();
            this.atomName = nd.getAtomName();
            this.atomVec = nd.getAtomVec();
            this.csLower = nd.csLower;
            this.csUpper = nd.csUpper;
            this.CSProton = nd.getProtonCS();
            this.CSHeavy = nd.getHeavyCS();
            this.isAsigned = nd.getIsAssigned();
            this.asgedId = nd.getAssignProtonID();
            this.vecMappingSet = nd.getMappingSet();
            this.isRestrained = false;
        }

        public Node() {
            this.id = 0;
            this.resNo = 0;
            this.vecAdj = new Vector();
        }

        public Node(int idT) {
            this.id = idT;
            this.resNo = 0;
            this.vecAdj = new Vector();
        }

        public Node(int idT, int resIDT, String res, String atom, Vector vecAtom) {
            this.id = idT;
            this.resNo = resIDT;
            this.resName = res;
            this.atomName = atom;
            this.atomVec.addAll(vecAtom);
            this.isAsigned = atom.equalsIgnoreCase("CA") || atom.equalsIgnoreCase("N") || atom.equalsIgnoreCase("HN") || atom.equalsIgnoreCase("H") || atom.equalsIgnoreCase("HA") || atom.equalsIgnoreCase("HA1") || atom.equalsIgnoreCase("HA2") || atom.equalsIgnoreCase("HA3") || atom.equalsIgnoreCase("C") || atom.equalsIgnoreCase("CO") || atom.equalsIgnoreCase("CB");
            this.isRestrained = false;
            this.vecAdj = new Vector();
        }

        public Node(int idT, double cs_H, double cs_heavy, boolean isAsged) {
            this.id = idT;
            this.CSProton = cs_H;
            this.CSHeavy = cs_heavy;
            this.isAsigned = isAsged;
            this.vecAdj = new Vector();
            this.isRestrained = false;
        }

        public int getID() {
            return this.id;
        }

        public int getResNo() {
            return this.resNo;
        }

        public String getResName() {
            return this.resName;
        }

        public String getAtomName() {
            return this.atomName;
        }

        public Vector getAtomVec() {
            return this.atomVec;
        }

        public Vector getAdjVec() {
            return this.vecAdj;
        }

        public double getProtonCS() {
            return this.CSProton;
        }

        public double getHeavyCS() {
            return this.CSHeavy;
        }

        public void setProtonCS(double cs_h) {
            this.CSProton = cs_h;
        }

        public void setIsAssigned(boolean tf) {
            this.isAsigned = tf;
        }

        public void setHeavyCS(double cs_heavy) {
            this.CSHeavy = cs_heavy;
        }

        public void setResNo(int no) {
            this.resNo = no;
        }

        public void setNodeID(int no) {
            this.id = no;
        }

        public void setResName(String res) {
            this.resName = res;
        }

        public void setAtomName(String atom) {
            this.atomName = atom;
        }

        public boolean getIsAssigned() {
            return this.isAsigned;
        }

        public void setCSLower(double cs_L) {
            this.csLower = cs_L;
        }

        public void setCSUpper(double cs_U) {
            this.csUpper = cs_U;
        }

        public void setAssignedID(int IDno) {
            this.asgedId = IDno;
        }

        public void addMappingNode(Node node) {
            this.vecMappingSet.add(node);
        }

        public Vector getMappingSet() {
            return this.vecMappingSet;
        }

        public int getAssignProtonID() {
            return this.asgedId;
        }

        public boolean getIsRestrained() {
            return this.isRestrained;
        }

        public void setIsRestrained(boolean isRsd) {
            this.isRestrained = isRsd;
        }

        public void EmptyMappingSet() {
            this.vecMappingSet = new Vector();
        }

        public void EmptyAdjSet() {
            this.vecAdj = new Vector();
        }

        public void AddCoord(Cartesian coord) {
            this.atomVec.add(coord);
        }

        public void DelAdj(int idNeigh) {
            Vector<Node> vecAdjTemp = new Vector<Node>();
            int i = 0;
            while (i < this.vecAdj.size()) {
                Node nd = (Node)this.vecAdj.elementAt(i);
                int idT = nd.getID();
                if (idT != idNeigh) {
                    vecAdjTemp.add(nd);
                }
                ++i;
            }
            this.vecAdj = new Vector();
            this.vecAdj.addAll(vecAdjTemp);
        }

        public void AddAdjNOESY(Noesy noesy) {
            boolean isInPre = false;
            double csH1Cur = noesy.getH1();
            double csH2Cur = noesy.getH2();
            double csHeavyCur = noesy.getHeavy();
            int i = 0;
            while (i < this.vecAdjNOESY.size()) {
                Noesy noesyT = (Noesy)this.vecAdjNOESY.elementAt(i);
                double csH1 = noesyT.getH1();
                double csH2 = noesyT.getH2();
                double csHeavy = noesyT.getHeavy();
                if (Math.abs(csH1Cur - csH1) < 0.005 && Math.abs(csH2Cur - csH2) < 0.005 && Math.abs(csHeavyCur - csHeavy) < 0.005) {
                    isInPre = true;
                }
                ++i;
            }
            if (!isInPre) {
                this.vecAdjNOESY.add(noesy);
            }
        }

        public void AddCloseAdj(Node ndNeigh) {
            int IDT = ndNeigh.getID();
            boolean isInPres = false;
            int i = 0;
            while (i < this.vecCloseAdj.size()) {
                Node nd = (Node)this.vecCloseAdj.elementAt(i);
                int IDPre = nd.getID();
                if (IDT == IDPre) {
                    isInPres = true;
                }
                ++i;
            }
            if (!isInPres) {
                this.vecCloseAdj.add(ndNeigh);
            }
        }

        public void AddAdj(Node ndNeigh) {
            int IDT = ndNeigh.getID();
            boolean isInPres = false;
            int i = 0;
            while (i < this.vecAdj.size()) {
                Node nd = (Node)this.vecAdj.elementAt(i);
                int IDPre = nd.getID();
                if (IDT == IDPre) {
                    isInPres = true;
                }
                ++i;
            }
            if (!isInPres) {
                this.vecAdj.add(ndNeigh);
            }
        }
    }
}

