/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.H1CS;
import rdcPanda.Hdist;
import rdcPanda.Pdb;
import rdcPanda.Peak;

public class RotaPattern {
    private int resNo;
    private String residueType = null;
    private Vector HdistVec = new Vector();
    private Vector backNoeVec = new Vector();
    private Vector pdbVec = new Vector();
    private Pdb pdbRotamer = new Pdb();
    private double score = 0.0;
    private double[] coord = new double[3];

    public RotaPattern(double[] coordTemp, double dbSc) {
        this.coord[0] = coordTemp[0];
        this.coord[1] = coordTemp[1];
        this.coord[2] = coordTemp[2];
        this.score = dbSc;
        this.resNo = 0;
        this.residueType = null;
    }

    public RotaPattern(Pdb pdbRot, double dbSc) {
        this.pdbRotamer = pdbRot;
        this.score = dbSc;
        this.resNo = 0;
        this.residueType = null;
    }

    public RotaPattern(int res_no, double dbSc) {
        this.score = dbSc;
        this.resNo = res_no;
        this.residueType = null;
    }

    public RotaPattern() {
        this.resNo = 0;
        this.residueType = null;
    }

    public RotaPattern(int no, String resName, Vector hdistVec, Vector NoeVec) {
        this.resNo = no;
        this.residueType = resName;
        this.HdistVec = hdistVec;
        this.backNoeVec = NoeVec;
    }

    public RotaPattern(int no, String resName, Vector hdistVec, Vector NoeVec, Vector pVec) {
        this.resNo = no;
        this.residueType = resName;
        this.HdistVec = hdistVec;
        this.backNoeVec = NoeVec;
        this.pdbVec = pVec;
    }

    public int getResNo() {
        return this.resNo;
    }

    public String getResType() {
        return this.residueType;
    }

    public Vector getHdistVec() {
        return this.HdistVec;
    }

    public Vector getBackNoeVec() {
        return this.backNoeVec;
    }

    public Pdb getPdb() {
        return this.pdbRotamer;
    }

    public double[] getCoord() {
        return this.coord;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double sc) {
        this.score = sc;
    }

    public Vector RefineRotLib(Vector vecRot, Vector vecBB, Vector assignVec, Vector hnNoeVec, Vector cnoeVec, int resNo, double distBound, int pickNum, int[] maxInd, Vector vecXrayBB) {
        Vector<Pdb> vecNewRot = new Vector<Pdb>();
        Pdb pp = new Pdb();
        String rotamResName = "";
        RotaPattern rotPattern = new RotaPattern();
        Assign asg = new Assign();
        double dbScore = 0.0;
        Vector<RotaPattern> vecRotTemp = new Vector<RotaPattern>();
        boolean noeCounter = false;
        int index = -1;
        double maxSc = -999999.9;
        int sumPeaks = 0;
        int i = 0;
        while (i < vecRot.size()) {
            Vector<Pdb> vecRotamer = new Vector<Pdb>();
            Pdb pdbRotamer = (Pdb)vecRot.elementAt(i);
            vecRotamer.add(pdbRotamer);
            Vector<Hdist> vecHdist = pp.compDistPatternForRotam(vecRotamer, resNo, vecBB, distBound);
            pp.compDistPatternForRotam(vecRotamer, resNo, vecXrayBB, distBound);
            rotamResName = pdbRotamer.getResidue();
            Vector vecBackNoe = rotPattern.BackCompNoePattern(assignVec, resNo, rotamResName, vecHdist);
            int[] numPeaks = new int[1];
            dbScore = asg.NoePatternMatchScore(vecBackNoe, hnNoeVec, cnoeVec, numPeaks);
            sumPeaks += numPeaks[0];
            if (maxSc < dbScore) {
                maxSc = dbScore;
                index = i;
            }
            vecRotTemp.add(new RotaPattern(pdbRotamer, dbScore));
            ++i;
        }
        Collections.sort(vecRotTemp, new scoreComparator());
        double chosenNum = pickNum;
        chosenNum = rotamResName.equalsIgnoreCase("ASN") ? 1.0 : (rotamResName.equalsIgnoreCase("ARG") ? 1.0 : (rotamResName.equalsIgnoreCase("LYS") ? 1.0 : (rotamResName.equalsIgnoreCase("GLN") ? 1.0 : (rotamResName.equalsIgnoreCase("GLU") ? 1.0 : (rotamResName.equalsIgnoreCase("MET") ? 1.0 : 1.0)))));
        i = 0;
        while ((double)i < Math.min(chosenNum, (double)vecRotTemp.size())) {
            RotaPattern rotPatn = (RotaPattern)vecRotTemp.elementAt(i);
            vecNewRot.add(rotPatn.getPdb());
            ++i;
        }
        maxInd[0] = index;
        maxInd[1] = (int)Math.floor(sumPeaks / vecRot.size());
        return vecNewRot;
    }

    public Vector RefineRotLib(double csErrH, double csErrN, double csErrCA, Vector vecRot, Vector vecBB, Vector assignVec, Vector NoesyVec, int resNo, double distBound, int pickNum, int[] maxInd) {
        RotaPattern rotPatn;
        Vector<Pdb> vecNewRot = new Vector<Pdb>();
        Pdb pp = new Pdb();
        String rotamResName = "";
        RotaPattern rotPattern = new RotaPattern();
        Assign asg = new Assign();
        double dbScore = 0.0;
        Vector<RotaPattern> vecRotTemp = new Vector<RotaPattern>();
        boolean noeCounter = false;
        int index = -1;
        double maxSc = -999999.9;
        int sumPeaks = 0;
        int i = 0;
        while (i < vecRot.size()) {
            Vector<Pdb> vecRotamer = new Vector<Pdb>();
            Pdb pdbRotamer = (Pdb)vecRot.elementAt(i);
            vecRotamer.add(pdbRotamer);
            Vector<Hdist> vecHdist = pp.compDistPatternForRotam(vecRotamer, resNo, vecBB, distBound);
            rotamResName = pdbRotamer.getResidue();
            Vector vecBackNoe = rotPattern.BackCompNoePattern(assignVec, resNo, rotamResName, vecHdist);
            int[] numPeaks = new int[1];
            dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoe, NoesyVec, numPeaks, false);
            sumPeaks += numPeaks[0];
            if (maxSc < dbScore) {
                maxSc = dbScore;
                index = i;
            }
            vecRotTemp.add(new RotaPattern(pdbRotamer, dbScore));
            ++i;
        }
        Collections.sort(vecRotTemp, new scoreComparator());
        i = 0;
        while (i < vecRotTemp.size()) {
            rotPatn = (RotaPattern)vecRotTemp.elementAt(i);
            double numPeaks = rotPatn.getScore();
            ++i;
        }
        double chosenNum = pickNum;
        i = 0;
        while ((double)i < Math.min(chosenNum, (double)vecRotTemp.size())) {
            rotPatn = (RotaPattern)vecRotTemp.elementAt(i);
            vecNewRot.add(rotPatn.getPdb());
            ++i;
        }
        maxInd[0] = index;
        maxInd[1] = (int)Math.floor(sumPeaks / vecRot.size());
        return vecNewRot;
    }

    public Vector RefineRotLibNew(double csErrH, double csErrN, double csErrCA, Vector vecRot, Vector vecBB, Vector assignVec, Vector NoesyVec, int resNo, double distBound, int pickNum, Vector vecRotStr, double constant) {
        RotaPattern rotPatn;
        Vector vecBackNoe;
        Vector<Hdist> vecHdist;
        Pdb pdbRotamerStr;
        Pdb pdbRotamer;
        Vector<Pdb> vecNewRot = new Vector<Pdb>();
        Pdb pp = new Pdb();
        BackNoe bn = new BackNoe();
        String rotamResName = "";
        RotaPattern rotPattern = new RotaPattern();
        Assign asg = new Assign();
        double dbScore = 0.0;
        Vector<RotaPattern> vecRotTemp = new Vector<RotaPattern>();
        boolean noeCounter = false;
        double maxSc = -999999.9;
        int sumPeaks = 0;
        double minScore = 9999.99;
        Pdb pdbTemp = (Pdb)vecRot.elementAt(0);
        String res = pdbTemp.getResidue();
        boolean isHydrophili = false;
        if (res.equalsIgnoreCase("HIS") || res.equalsIgnoreCase("TYR") || res.equalsIgnoreCase("THR") || res.equalsIgnoreCase("SER") || res.equalsIgnoreCase("ASP") || res.equalsIgnoreCase("ASN") || res.equalsIgnoreCase("LYS") || res.equalsIgnoreCase("ARG") || res.equalsIgnoreCase("GLU") || res.equalsIgnoreCase("GLN")) {
            isHydrophili = true;
        }
        distBound = isHydrophili ? 4.0 : 4.5;
        int i = 0;
        while (i < vecRot.size()) {
            Vector<Pdb> vecRotamer = new Vector<Pdb>();
            pdbRotamer = (Pdb)vecRot.elementAt(i);
            pdbRotamerStr = (Pdb)vecRotStr.elementAt(i);
            vecRotamer.add(pdbRotamer);
            vecHdist = pp.compDistPatternForRotam(vecRotamer, resNo, vecBB, distBound);
            rotamResName = pdbRotamer.getResidue();
            vecBackNoe = rotPattern.BackCompNoePattern(assignVec, resNo, rotamResName, vecHdist);
            Vector<BackNoe> vecBackNoeNoRepeat = bn.DeleteRepeat(vecBackNoe);
            int[] numPeaks = new int[1];
            dbScore = asg.NoePatternMatchScoreWCali(csErrH, csErrN, csErrCA, vecBackNoeNoRepeat, NoesyVec, numPeaks, false, constant);
            if (minScore > dbScore) {
                minScore = dbScore;
            }
            sumPeaks += numPeaks[0];
            if (maxSc < dbScore) {
                maxSc = dbScore;
            }
            vecRotTemp.add(new RotaPattern(pdbRotamerStr, dbScore));
            ++i;
        }
        double maxScSec = -999999.9;
        Vector<RotaPattern> vecRotTempSec = new Vector<RotaPattern>();
        Vector vecAsgSec = asg.SwapStereoAsg(assignVec, resNo);
        i = 0;
        while (i < vecRot.size()) {
            Vector<Pdb> vecRotamer = new Vector<Pdb>();
            pdbRotamer = (Pdb)vecRot.elementAt(i);
            pdbRotamerStr = (Pdb)vecRotStr.elementAt(i);
            vecRotamer.add(pdbRotamer);
            vecHdist = pp.compDistPatternForRotam(vecRotamer, resNo, vecBB, distBound);
            rotamResName = pdbRotamer.getResidue();
            vecBackNoe = rotPattern.BackCompNoePattern(vecAsgSec, resNo, rotamResName, vecHdist);
            Vector<BackNoe> vecBackNoeNoRepeat = bn.DeleteRepeat(vecBackNoe);
            int[] numPeaks = new int[1];
            dbScore = asg.NoePatternMatchScoreWCali(csErrH, csErrN, csErrCA, vecBackNoeNoRepeat, NoesyVec, numPeaks, false, constant);
            sumPeaks += numPeaks[0];
            if (maxScSec < dbScore) {
                maxScSec = dbScore;
            }
            vecRotTempSec.add(new RotaPattern(pdbRotamerStr, dbScore));
            ++i;
        }
        if (maxScSec > maxSc) {
            vecRotTemp = new Vector();
            vecRotTemp.addAll(vecRotTempSec);
            assignVec = new Vector();
            assignVec.addAll(vecAsgSec);
        }
        i = 0;
        while (i < vecRotTemp.size()) {
            RotaPattern rp = (RotaPattern)vecRotTemp.elementAt(i);
            double sc = rp.getScore();
            Pdb pdb = (Pdb)vecRot.elementAt(i);
            double ratioRota = pdb.getRotamerRatio();
            String resName = pdb.getResidue();
            double scoreNew = 0.0;
            scoreNew = Math.log(sc) + 0.3 * Math.log(ratioRota);
            if (resName.equalsIgnoreCase("GLU") || resName.equalsIgnoreCase("GLN") || resName.equalsIgnoreCase("ARG") || resName.equalsIgnoreCase("LYS")) {
                scoreNew = Math.log(sc) + 0.5 * Math.log(ratioRota);
            }
            rp.setScore(scoreNew);
            ++i;
        }
        Collections.sort(vecRotTemp, new scoreComparator());
        i = 0;
        while (i < vecRotTemp.size()) {
            rotPatn = (RotaPattern)vecRotTemp.elementAt(i);
            double sc = rotPatn.getScore();
            ++i;
        }
        double chosenNum = pickNum;
        i = 0;
        while ((double)i < Math.min(chosenNum, (double)vecRotTemp.size())) {
            rotPatn = (RotaPattern)vecRotTemp.elementAt(i);
            vecNewRot.add(rotPatn.getPdb());
            ++i;
        }
        return vecNewRot;
    }

    public Vector RefineRotLibNewUsingBins(double csErrH, double csErrN, double csErrCA, Vector vecRot, Vector vecBB, Vector assignVec, Vector NoesyVec, int resNo, double distBound, int pickNum, Vector vecRotStr) {
        RotaPattern rotPatn;
        Vector vecBackNoe;
        Vector<Hdist> vecHdist;
        Pdb pdbRotamerStr;
        Pdb pdbRotamer;
        Vector<Pdb> vecNewRot = new Vector<Pdb>();
        Pdb pp = new Pdb();
        BackNoe bn = new BackNoe();
        String rotamResName = "";
        RotaPattern rotPattern = new RotaPattern();
        Assign asg = new Assign();
        double dbScore = 0.0;
        Vector<RotaPattern> vecRotTemp = new Vector<RotaPattern>();
        boolean noeCounter = false;
        double maxSc = -999999.9;
        int sumPeaks = 0;
        double minScore = 9999.99;
        Pdb pdbTemp = (Pdb)vecRot.elementAt(0);
        String res = pdbTemp.getResidue();
        int i = 0;
        while (i < vecRot.size()) {
            Vector<Pdb> vecRotamer = new Vector<Pdb>();
            pdbRotamer = (Pdb)vecRot.elementAt(i);
            pdbRotamerStr = (Pdb)vecRotStr.elementAt(i);
            vecRotamer.add(pdbRotamer);
            vecHdist = pp.compDistPatternForRotam(vecRotamer, resNo, vecBB, distBound);
            rotamResName = pdbRotamer.getResidue();
            vecBackNoe = rotPattern.BackCompNoePattern(assignVec, resNo, rotamResName, vecHdist);
            Vector<BackNoe> vecBackNoeNoRepeat = bn.DeleteRepeat(vecBackNoe);
            int[] numPeaks = new int[1];
            dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNoRepeat, NoesyVec, numPeaks, false);
            if (minScore > dbScore) {
                minScore = dbScore;
            }
            sumPeaks += numPeaks[0];
            if (maxSc < dbScore) {
                maxSc = dbScore;
            }
            vecRotTemp.add(new RotaPattern(pdbRotamerStr, dbScore));
            ++i;
        }
        double maxScSec = -999999.9;
        Vector<RotaPattern> vecRotTempSec = new Vector<RotaPattern>();
        Vector vecAsgSec = asg.SwapStereoAsg(assignVec, resNo);
        i = 0;
        while (i < vecRot.size()) {
            Vector<Pdb> vecRotamer = new Vector<Pdb>();
            pdbRotamer = (Pdb)vecRot.elementAt(i);
            pdbRotamerStr = (Pdb)vecRotStr.elementAt(i);
            vecRotamer.add(pdbRotamer);
            vecHdist = pp.compDistPatternForRotam(vecRotamer, resNo, vecBB, distBound);
            rotamResName = pdbRotamer.getResidue();
            vecBackNoe = rotPattern.BackCompNoePattern(vecAsgSec, resNo, rotamResName, vecHdist);
            Vector<BackNoe> vecBackNoeNoRepeat = bn.DeleteRepeat(vecBackNoe);
            int[] numPeaks = new int[1];
            dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoeNoRepeat, NoesyVec, numPeaks, false);
            sumPeaks += numPeaks[0];
            if (maxScSec < dbScore) {
                maxScSec = dbScore;
            }
            vecRotTempSec.add(new RotaPattern(pdbRotamerStr, dbScore));
            ++i;
        }
        if (maxScSec > maxSc) {
            vecRotTemp = new Vector();
            vecRotTemp.addAll(vecRotTempSec);
            assignVec = new Vector();
            assignVec.addAll(vecAsgSec);
        }
        i = 0;
        while (i < vecRotTemp.size()) {
            RotaPattern rp = (RotaPattern)vecRotTemp.elementAt(i);
            double sc = rp.getScore();
            Pdb pdb = (Pdb)vecRot.elementAt(i);
            double ratioRota = pdb.getRotamerRatio();
            String resName = pdb.getResidue();
            double scoreNew = 0.0;
            scoreNew = resName.equalsIgnoreCase("LYS") ? Math.log(sc) + 0.3 * Math.log(ratioRota) : (resName.equalsIgnoreCase("ARG") ? Math.log(sc) + 0.3 * Math.log(ratioRota) : (resName.equalsIgnoreCase("GLN") ? Math.log(sc) + 0.3 * Math.log(ratioRota) : (resName.equalsIgnoreCase("GLU") ? Math.log(sc) + 0.3 * Math.log(ratioRota) : (resName.equalsIgnoreCase("ASN") ? Math.log(sc) + 0.3 * Math.log(ratioRota) : (resName.equalsIgnoreCase("THR") ? Math.log(sc) + 0.0 * Math.log(ratioRota) : (resName.equalsIgnoreCase("SER") ? Math.log(sc) + 0.0 * Math.log(ratioRota) : (resName.equalsIgnoreCase("TYR") ? Math.log(sc) + 0.0 * Math.log(ratioRota) : (resName.equalsIgnoreCase("ASP") ? Math.log(sc) + 0.3 * Math.log(ratioRota) : Math.log(sc) + 0.0 * Math.log(ratioRota)))))))));
            scoreNew = Math.log(sc) + 0.0 * Math.log(ratioRota);
            rp.setScore(scoreNew);
            ++i;
        }
        Collections.sort(vecRotTemp, new scoreComparator());
        i = 0;
        while (i < vecRotTemp.size()) {
            rotPatn = (RotaPattern)vecRotTemp.elementAt(i);
            double sc = rotPatn.getScore();
            ++i;
        }
        double chosenNum = pickNum;
        i = 0;
        while ((double)i < Math.min(chosenNum, (double)vecRotTemp.size())) {
            rotPatn = (RotaPattern)vecRotTemp.elementAt(i);
            vecNewRot.add(rotPatn.getPdb());
            ++i;
        }
        return vecNewRot;
    }

    public Vector RefineRotLib(double csErrH, double csErrN, double csErrCA, Vector vecRot, Vector vecBB, Vector assignVec, Vector NoesyVec, int resNo, double distBound, int pickNum, double[] maxScore) {
        Vector<Pdb> vecNewRot = new Vector<Pdb>();
        Pdb pp = new Pdb();
        String rotamResName = "";
        RotaPattern rotPattern = new RotaPattern();
        Assign asg = new Assign();
        double dbScore = 0.0;
        Vector<RotaPattern> vecRotTemp = new Vector<RotaPattern>();
        boolean noeCounter = false;
        int index = -1;
        double maxSc = -999999.9;
        int sumPeaks = 0;
        int i = 0;
        while (i < vecRot.size()) {
            Vector<Pdb> vecRotamer = new Vector<Pdb>();
            Pdb pdbRotamer = (Pdb)vecRot.elementAt(i);
            vecRotamer.add(pdbRotamer);
            Vector<Hdist> vecHdist = pp.compDistPatternForRotam(vecRotamer, resNo, vecBB, distBound);
            rotamResName = pdbRotamer.getResidue();
            Vector vecBackNoe = rotPattern.BackCompNoePattern(assignVec, resNo, rotamResName, vecHdist);
            int[] numPeaks = new int[1];
            dbScore = asg.NoePatternMatchScore(csErrH, csErrN, csErrCA, vecBackNoe, NoesyVec, numPeaks, false);
            sumPeaks += numPeaks[0];
            if (maxSc < dbScore) {
                maxSc = dbScore;
                index = i;
            }
            vecRotTemp.add(new RotaPattern(pdbRotamer, dbScore));
            ++i;
        }
        Collections.sort(vecRotTemp, new scoreComparator());
        double chosenNum = pickNum;
        chosenNum = rotamResName.equalsIgnoreCase("ASN") ? 1.0 : (rotamResName.equalsIgnoreCase("ARG") ? 1.0 : (rotamResName.equalsIgnoreCase("LYS") ? 1.0 : (rotamResName.equalsIgnoreCase("GLN") ? 1.0 : (rotamResName.equalsIgnoreCase("GLU") ? 1.0 : (rotamResName.equalsIgnoreCase("MET") ? 1.0 : 1.0)))));
        i = 0;
        while ((double)i < Math.min(chosenNum, (double)vecRotTemp.size())) {
            RotaPattern rotPatn = (RotaPattern)vecRotTemp.elementAt(i);
            vecNewRot.add(rotPatn.getPdb());
            ++i;
        }
        maxScore[0] = index;
        maxScore[1] = maxSc;
        return vecNewRot;
    }

    public BackNoe SimulateBackCompNOEPeak(Vector asgVec, Hdist hdist) {
        long seed = 951179L;
        Random rr = new Random(seed);
        String atomName1 = hdist.getFirstCart().getAtom();
        String atomName2 = hdist.getSecondCart().getAtom();
        Peak pk = new Peak();
        Map aMap = new TreeMap();
        int no = 0;
        String aaType = "";
        Assign assign = new Assign();
        int firstResNo = hdist.getFirstResNo();
        int secondResNo = hdist.getSecondResNo();
        String firstAtomName = hdist.getFirstAtomName();
        String secondAtomName = hdist.getSecondAtomName();
        String firstResName = hdist.getFirstResName();
        String secondResName = hdist.getSecondResName();
        String heavyName = pk.GetHeavyAtomFromProton(secondResName, secondAtomName);
        if (heavyName.equals("CA")) {
            heavyName = "ca";
        }
        if (firstAtomName.equalsIgnoreCase("H")) {
            firstAtomName = "HN";
        }
        if (secondAtomName.equalsIgnoreCase("H")) {
            secondAtomName = "HN";
        }
        if (firstResName.equalsIgnoreCase("ALA") && (firstAtomName.equalsIgnoreCase("HB1") || firstAtomName.equalsIgnoreCase("HB2") || firstAtomName.equalsIgnoreCase("HB3"))) {
            firstAtomName = "HB";
        }
        if (firstResName.equalsIgnoreCase("ILE") && (firstAtomName.equalsIgnoreCase("HG21") || firstAtomName.equalsIgnoreCase("HG22") || firstAtomName.equalsIgnoreCase("HG23"))) {
            firstAtomName = "HG2";
        }
        if (firstResName.equalsIgnoreCase("ILE") && (firstAtomName.equalsIgnoreCase("HD11") || firstAtomName.equalsIgnoreCase("HD12") || firstAtomName.equalsIgnoreCase("HD13"))) {
            firstAtomName = "HD1";
        }
        if (firstResName.equalsIgnoreCase("LEU") && (firstAtomName.equalsIgnoreCase("HD11") || firstAtomName.equalsIgnoreCase("HD12") || firstAtomName.equalsIgnoreCase("HD13"))) {
            firstAtomName = "HD1";
        }
        if (firstResName.equalsIgnoreCase("LEU") && (firstAtomName.equalsIgnoreCase("HD21") || firstAtomName.equalsIgnoreCase("HD22") || firstAtomName.equalsIgnoreCase("HD23"))) {
            firstAtomName = "HD2";
        }
        if (firstResName.equalsIgnoreCase("VAL") && (firstAtomName.equalsIgnoreCase("HG11") || firstAtomName.equalsIgnoreCase("HG12") || firstAtomName.equalsIgnoreCase("HG13"))) {
            firstAtomName = "HG1";
        }
        if (firstResName.equalsIgnoreCase("VAL") && (firstAtomName.equalsIgnoreCase("HG21") || firstAtomName.equalsIgnoreCase("HG22") || firstAtomName.equalsIgnoreCase("HG23"))) {
            firstAtomName = "HG2";
        }
        if (firstResName.equalsIgnoreCase("THR") && (firstAtomName.equalsIgnoreCase("HG21") || firstAtomName.equalsIgnoreCase("HG22") || firstAtomName.equalsIgnoreCase("HG23"))) {
            firstAtomName = "HG2";
        }
        double dist = hdist.getDistance();
        double csH1 = -999.9;
        double csHeavy = -999.9;
        double csH2 = -999.9;
        double csValue = 0.0;
        String nucleus = "";
        double csSigmaH = 0.03;
        double csSigmaN = 0.08;
        double csSigmaC = 0.05;
        double csSigmaHeavy = 0.0;
        int j = 0;
        while (j < asgVec.size()) {
            assign = (Assign)asgVec.elementAt(j);
            no = assign.getResidueNo();
            aaType = assign.getResidueType();
            aMap = assign.getMap();
            for (Map.Entry e : aMap.entrySet()) {
                csValue = (Double)e.getValue();
                nucleus = (String)e.getKey();
                if (firstResNo == no && firstAtomName.equals(nucleus)) {
                    csH2 = csValue + csSigmaH * rr.nextGaussian();
                }
                if (secondResNo == no && heavyName.equals(nucleus)) {
                    csSigmaHeavy = nucleus.substring(0, 1).equalsIgnoreCase("N") ? csSigmaN : csSigmaC;
                    csHeavy = csValue + csSigmaHeavy * rr.nextGaussian();
                }
                if (secondResNo != no || !secondAtomName.equals(nucleus)) continue;
                csH1 = csValue + csSigmaH * rr.nextGaussian();
            }
            ++j;
        }
        BackNoe backNoe = new BackNoe(csH1, csHeavy, csH2, dist, 0.0, secondResNo, firstResNo, secondResName, firstResName, secondAtomName, heavyName, firstAtomName);
        return backNoe;
    }

    public BackNoe BackCompNOEPeakNew(Vector asgVec, Hdist hdist) {
        String atomName1 = hdist.getFirstCart().getAtom();
        String atomName2 = hdist.getSecondCart().getAtom();
        Peak pk = new Peak();
        TreeMap aMap = new TreeMap();
        int no = 0;
        String aaType = "";
        H1CS assign = new H1CS();
        int firstResNo = hdist.getFirstResNo();
        int secondResNo = hdist.getSecondResNo();
        String firstAtomName = hdist.getFirstAtomName();
        String secondAtomName = hdist.getSecondAtomName();
        String firstResName = hdist.getFirstResName();
        String secondResName = hdist.getSecondResName();
        String heavyName = pk.GetHeavyAtomFromProton(firstResName, firstAtomName);
        if (firstAtomName.equalsIgnoreCase("H")) {
            firstAtomName = "HN";
        }
        if (secondAtomName.equalsIgnoreCase("H")) {
            secondAtomName = "HN";
        }
        if (secondResName.equalsIgnoreCase("ALA") && (secondAtomName.equalsIgnoreCase("HB1") || secondAtomName.equalsIgnoreCase("HB2") || secondAtomName.equalsIgnoreCase("HB3"))) {
            secondAtomName = "HB";
        }
        if (secondResName.equalsIgnoreCase("ILE") && (secondAtomName.equalsIgnoreCase("HG21") || secondAtomName.equalsIgnoreCase("HG22") || secondAtomName.equalsIgnoreCase("HG23"))) {
            secondAtomName = "HG2";
        }
        if (secondResName.equalsIgnoreCase("ILE") && (secondAtomName.equalsIgnoreCase("HD11") || secondAtomName.equalsIgnoreCase("HD12") || secondAtomName.equalsIgnoreCase("HD13"))) {
            secondAtomName = "HD1";
        }
        if (secondResName.equalsIgnoreCase("LEU") && (secondAtomName.equalsIgnoreCase("HD11") || secondAtomName.equalsIgnoreCase("HD12") || secondAtomName.equalsIgnoreCase("HD13"))) {
            secondAtomName = "HD1";
        }
        if (secondResName.equalsIgnoreCase("LEU") && (secondAtomName.equalsIgnoreCase("HD21") || secondAtomName.equalsIgnoreCase("HD22") || secondAtomName.equalsIgnoreCase("HD23"))) {
            secondAtomName = "HD2";
        }
        if (secondResName.equalsIgnoreCase("VAL") && (secondAtomName.equalsIgnoreCase("HG11") || secondAtomName.equalsIgnoreCase("HG12") || secondAtomName.equalsIgnoreCase("HG13"))) {
            secondAtomName = "HG1";
        }
        if (secondResName.equalsIgnoreCase("VAL") && (secondAtomName.equalsIgnoreCase("HG21") || secondAtomName.equalsIgnoreCase("HG22") || secondAtomName.equalsIgnoreCase("HG23"))) {
            secondAtomName = "HG2";
        }
        if (secondResName.equalsIgnoreCase("THR") && (secondAtomName.equalsIgnoreCase("HG21") || secondAtomName.equalsIgnoreCase("HG22") || secondAtomName.equalsIgnoreCase("HG23"))) {
            secondAtomName = "HG2";
        }
        if (secondResName.equalsIgnoreCase("MET") && (secondAtomName.equalsIgnoreCase("HE1") || secondAtomName.equalsIgnoreCase("HE2") || secondAtomName.equalsIgnoreCase("HE3"))) {
            secondAtomName = "HE";
        }
        if (secondResName.equalsIgnoreCase("PHE")) {
            if (secondAtomName.equalsIgnoreCase("HE1") || secondAtomName.equalsIgnoreCase("HE2")) {
                secondAtomName = "HE";
            }
            if (secondAtomName.equalsIgnoreCase("HD1") || secondAtomName.equalsIgnoreCase("HD2")) {
                secondAtomName = "HD";
            }
        }
        if (secondResName.equalsIgnoreCase("TYR")) {
            if (secondAtomName.equalsIgnoreCase("HE1") || secondAtomName.equalsIgnoreCase("HE2")) {
                secondAtomName = "HE";
            }
            if (secondAtomName.equalsIgnoreCase("HD1") || secondAtomName.equalsIgnoreCase("HD2")) {
                secondAtomName = "HD";
            }
        }
        if (firstResName.equalsIgnoreCase("ALA") && (firstAtomName.equalsIgnoreCase("HB1") || firstAtomName.equalsIgnoreCase("HB2") || firstAtomName.equalsIgnoreCase("HB3"))) {
            firstAtomName = "HB";
        }
        if (firstResName.equalsIgnoreCase("ILE") && (firstAtomName.equalsIgnoreCase("HG21") || firstAtomName.equalsIgnoreCase("HG22") || firstAtomName.equalsIgnoreCase("HG23"))) {
            firstAtomName = "HG2";
        }
        if (firstResName.equalsIgnoreCase("ILE") && (firstAtomName.equalsIgnoreCase("HD11") || firstAtomName.equalsIgnoreCase("HD12") || firstAtomName.equalsIgnoreCase("HD13"))) {
            firstAtomName = "HD1";
        }
        if (firstResName.equalsIgnoreCase("LEU") && (firstAtomName.equalsIgnoreCase("HD11") || firstAtomName.equalsIgnoreCase("HD12") || firstAtomName.equalsIgnoreCase("HD13"))) {
            firstAtomName = "HD1";
        }
        if (firstResName.equalsIgnoreCase("LEU") && (firstAtomName.equalsIgnoreCase("HD21") || firstAtomName.equalsIgnoreCase("HD22") || firstAtomName.equalsIgnoreCase("HD23"))) {
            firstAtomName = "HD2";
        }
        if (firstResName.equalsIgnoreCase("VAL") && (firstAtomName.equalsIgnoreCase("HG11") || firstAtomName.equalsIgnoreCase("HG12") || firstAtomName.equalsIgnoreCase("HG13"))) {
            firstAtomName = "HG1";
        }
        if (firstResName.equalsIgnoreCase("VAL") && (firstAtomName.equalsIgnoreCase("HG21") || firstAtomName.equalsIgnoreCase("HG22") || firstAtomName.equalsIgnoreCase("HG23"))) {
            firstAtomName = "HG2";
        }
        if (firstResName.equalsIgnoreCase("THR") && (firstAtomName.equalsIgnoreCase("HG21") || firstAtomName.equalsIgnoreCase("HG22") || firstAtomName.equalsIgnoreCase("HG23"))) {
            firstAtomName = "HG2";
        }
        if (firstResName.equalsIgnoreCase("MET") && (firstAtomName.equalsIgnoreCase("HE1") || firstAtomName.equalsIgnoreCase("HE2") || firstAtomName.equalsIgnoreCase("HE3"))) {
            firstAtomName = "HE";
        }
        if (firstResName.equalsIgnoreCase("PHE")) {
            if (firstAtomName.equalsIgnoreCase("HE1") || firstAtomName.equalsIgnoreCase("HE2")) {
                firstAtomName = "HE";
            }
            if (firstAtomName.equalsIgnoreCase("HD1") || firstAtomName.equalsIgnoreCase("HD2")) {
                firstAtomName = "HD";
            }
        }
        if (firstResName.equalsIgnoreCase("TYR")) {
            if (firstAtomName.equalsIgnoreCase("HE1") || firstAtomName.equalsIgnoreCase("HE2")) {
                firstAtomName = "HE";
            }
            if (firstAtomName.equalsIgnoreCase("HD1") || firstAtomName.equalsIgnoreCase("HD2")) {
                firstAtomName = "HD";
            }
        }
        double dist = hdist.getDistance();
        double csH1 = -999.9;
        double csHeavy = -999.9;
        double csH2 = -999.9;
        double csValue = 0.0;
        String nucleus = "";
        double csSigmaH = 0.0;
        double csSigmaN = 0.0;
        double csSigmaC = 0.0;
        double csSigmaHeavy = 0.0;
        int j = 0;
        while (j < asgVec.size()) {
            String secondAtomName_temp;
            String heavyName_temp;
            String firstAtomName_temp;
            assign = (H1CS)asgVec.elementAt(j);
            no = assign.getResidueNo();
            aaType = assign.getResidueType();
            csValue = assign.getH1CS();
            nucleus = assign.getAtomName();
            int id = nucleus.indexOf("#");
            if (id > 0) {
                nucleus = nucleus.substring(0, id);
            }
            if ((firstAtomName_temp = firstAtomName).length() > nucleus.length()) {
                firstAtomName_temp = firstAtomName_temp.substring(0, nucleus.length());
            }
            if ((heavyName_temp = heavyName).length() > nucleus.length()) {
                heavyName_temp = heavyName_temp.substring(0, nucleus.length());
            }
            if ((secondAtomName_temp = secondAtomName).length() > nucleus.length()) {
                secondAtomName_temp = secondAtomName_temp.substring(0, nucleus.length());
            }
            if (nucleus.equalsIgnoreCase("H")) {
                nucleus = "HN";
            }
            if (firstResNo == no && firstAtomName.equals(nucleus)) {
                csH1 = csValue;
            }
            if (firstResNo == no && heavyName.equals(nucleus)) {
                csSigmaHeavy = nucleus.substring(0, 1).equalsIgnoreCase("N") ? csSigmaN : csSigmaC;
                csHeavy = csValue;
            }
            if (secondResNo == no && secondAtomName.equals(nucleus)) {
                csH2 = csValue;
            }
            ++j;
        }
        BackNoe backNoe = new BackNoe(csH1, csHeavy, csH2, dist, 0.0, firstResNo, secondResNo, firstResName, secondResName, firstAtomName, heavyName, secondAtomName);
        return backNoe;
    }

    public BackNoe BackCompNOEPeak(Vector asgVec, Hdist hdist) {
        long seed = 951179L;
        Random rr = new Random(seed);
        String atomName1 = hdist.getFirstCart().getAtom();
        String atomName2 = hdist.getSecondCart().getAtom();
        Peak pk = new Peak();
        TreeMap aMap = new TreeMap();
        int no = 0;
        String aaType = "";
        H1CS assign = new H1CS();
        int firstResNo = hdist.getFirstResNo();
        int secondResNo = hdist.getSecondResNo();
        String firstAtomName = hdist.getFirstAtomName();
        String secondAtomName = hdist.getSecondAtomName();
        String firstResName = hdist.getFirstResName();
        String secondResName = hdist.getSecondResName();
        String heavyName = pk.GetHeavyAtomFromProton(secondResName, secondAtomName);
        if (firstAtomName.equalsIgnoreCase("H")) {
            firstAtomName = "HN";
        }
        if (secondAtomName.equalsIgnoreCase("H")) {
            secondAtomName = "HN";
        }
        if (secondResName.equalsIgnoreCase("ALA") && (secondAtomName.equalsIgnoreCase("HB1") || secondAtomName.equalsIgnoreCase("HB2") || secondAtomName.equalsIgnoreCase("HB3"))) {
            secondAtomName = "HB";
        }
        if (secondResName.equalsIgnoreCase("ILE") && (secondAtomName.equalsIgnoreCase("HG21") || secondAtomName.equalsIgnoreCase("HG22") || secondAtomName.equalsIgnoreCase("HG23"))) {
            secondAtomName = "HG2";
        }
        if (secondResName.equalsIgnoreCase("ILE") && (secondAtomName.equalsIgnoreCase("HD11") || secondAtomName.equalsIgnoreCase("HD12") || secondAtomName.equalsIgnoreCase("HD13"))) {
            secondAtomName = "HD1";
        }
        if (secondResName.equalsIgnoreCase("LEU") && (secondAtomName.equalsIgnoreCase("HD11") || secondAtomName.equalsIgnoreCase("HD12") || secondAtomName.equalsIgnoreCase("HD13"))) {
            secondAtomName = "HD1";
        }
        if (secondResName.equalsIgnoreCase("LEU") && (secondAtomName.equalsIgnoreCase("HD21") || secondAtomName.equalsIgnoreCase("HD22") || secondAtomName.equalsIgnoreCase("HD23"))) {
            secondAtomName = "HD2";
        }
        if (secondResName.equalsIgnoreCase("VAL") && (secondAtomName.equalsIgnoreCase("HG11") || secondAtomName.equalsIgnoreCase("HG12") || secondAtomName.equalsIgnoreCase("HG13"))) {
            secondAtomName = "HG1";
        }
        if (secondResName.equalsIgnoreCase("VAL") && (secondAtomName.equalsIgnoreCase("HG21") || secondAtomName.equalsIgnoreCase("HG22") || secondAtomName.equalsIgnoreCase("HG23"))) {
            secondAtomName = "HG2";
        }
        if (secondResName.equalsIgnoreCase("THR") && (secondAtomName.equalsIgnoreCase("HG21") || secondAtomName.equalsIgnoreCase("HG22") || secondAtomName.equalsIgnoreCase("HG23"))) {
            secondAtomName = "HG2";
        }
        if (secondResName.equalsIgnoreCase("MET") && (secondAtomName.equalsIgnoreCase("HE1") || secondAtomName.equalsIgnoreCase("HE2") || secondAtomName.equalsIgnoreCase("HE3"))) {
            secondAtomName = "HE";
        }
        if (secondResName.equalsIgnoreCase("PHE")) {
            if (secondAtomName.equalsIgnoreCase("HE1") || secondAtomName.equalsIgnoreCase("HE2")) {
                secondAtomName = "HE";
            }
            if (secondAtomName.equalsIgnoreCase("HD1") || secondAtomName.equalsIgnoreCase("HD2")) {
                secondAtomName = "HD";
            }
        }
        if (secondResName.equalsIgnoreCase("TYR")) {
            if (secondAtomName.equalsIgnoreCase("HE1") || secondAtomName.equalsIgnoreCase("HE2")) {
                secondAtomName = "HE";
            }
            if (secondAtomName.equalsIgnoreCase("HD1") || secondAtomName.equalsIgnoreCase("HD2")) {
                secondAtomName = "HD";
            }
        }
        if (firstResName.equalsIgnoreCase("ALA") && (firstAtomName.equalsIgnoreCase("HB1") || firstAtomName.equalsIgnoreCase("HB2") || firstAtomName.equalsIgnoreCase("HB3"))) {
            firstAtomName = "HB";
        }
        if (firstResName.equalsIgnoreCase("ILE") && (firstAtomName.equalsIgnoreCase("HG21") || firstAtomName.equalsIgnoreCase("HG22") || firstAtomName.equalsIgnoreCase("HG23"))) {
            firstAtomName = "HG2";
        }
        if (firstResName.equalsIgnoreCase("ILE") && (firstAtomName.equalsIgnoreCase("HD11") || firstAtomName.equalsIgnoreCase("HD12") || firstAtomName.equalsIgnoreCase("HD13"))) {
            firstAtomName = "HD1";
        }
        if (firstResName.equalsIgnoreCase("LEU") && (firstAtomName.equalsIgnoreCase("HD11") || firstAtomName.equalsIgnoreCase("HD12") || firstAtomName.equalsIgnoreCase("HD13"))) {
            firstAtomName = "HD1";
        }
        if (firstResName.equalsIgnoreCase("LEU") && (firstAtomName.equalsIgnoreCase("HD21") || firstAtomName.equalsIgnoreCase("HD22") || firstAtomName.equalsIgnoreCase("HD23"))) {
            firstAtomName = "HD2";
        }
        if (firstResName.equalsIgnoreCase("VAL") && (firstAtomName.equalsIgnoreCase("HG11") || firstAtomName.equalsIgnoreCase("HG12") || firstAtomName.equalsIgnoreCase("HG13"))) {
            firstAtomName = "HG1";
        }
        if (firstResName.equalsIgnoreCase("VAL") && (firstAtomName.equalsIgnoreCase("HG21") || firstAtomName.equalsIgnoreCase("HG22") || firstAtomName.equalsIgnoreCase("HG23"))) {
            firstAtomName = "HG2";
        }
        if (firstResName.equalsIgnoreCase("THR") && (firstAtomName.equalsIgnoreCase("HG21") || firstAtomName.equalsIgnoreCase("HG22") || firstAtomName.equalsIgnoreCase("HG23"))) {
            firstAtomName = "HG2";
        }
        if (firstResName.equalsIgnoreCase("MET") && (firstAtomName.equalsIgnoreCase("HE1") || firstAtomName.equalsIgnoreCase("HE2") || firstAtomName.equalsIgnoreCase("HE3"))) {
            firstAtomName = "HE";
        }
        if (firstResName.equalsIgnoreCase("PHE")) {
            if (firstAtomName.equalsIgnoreCase("HE1") || firstAtomName.equalsIgnoreCase("HE2")) {
                firstAtomName = "HE";
            }
            if (firstAtomName.equalsIgnoreCase("HD1") || firstAtomName.equalsIgnoreCase("HD2")) {
                firstAtomName = "HD";
            }
        }
        if (firstResName.equalsIgnoreCase("TYR")) {
            if (firstAtomName.equalsIgnoreCase("HE1") || firstAtomName.equalsIgnoreCase("HE2")) {
                firstAtomName = "HE";
            }
            if (firstAtomName.equalsIgnoreCase("HD1") || firstAtomName.equalsIgnoreCase("HD2")) {
                firstAtomName = "HD";
            }
        }
        double dist = hdist.getDistance();
        double csH1 = -999.9;
        double csHeavy = -999.9;
        double csH2 = -999.9;
        double csValue = 0.0;
        String nucleus = "";
        double csSigmaH = 0.0;
        double csSigmaN = 0.0;
        double csSigmaC = 0.0;
        double csSigmaHeavy = 0.0;
        int j = 0;
        while (j < asgVec.size()) {
            assign = (H1CS)asgVec.elementAt(j);
            no = assign.getResidueNo();
            aaType = assign.getResidueType();
            csValue = assign.getH1CS();
            nucleus = assign.getAtomName();
            if (nucleus.equalsIgnoreCase("H")) {
                nucleus = "HN";
            }
            if (firstResNo == no && firstAtomName.equals(nucleus)) {
                csH2 = csValue + csSigmaH * rr.nextGaussian();
            }
            if (secondResNo == no && heavyName.equals(nucleus)) {
                csSigmaHeavy = nucleus.substring(0, 1).equalsIgnoreCase("N") ? csSigmaN : csSigmaC;
                csHeavy = csValue + csSigmaHeavy * rr.nextGaussian();
            }
            if (secondResNo == no && secondAtomName.equals(nucleus)) {
                csH1 = csValue + csSigmaH * rr.nextGaussian();
            }
            ++j;
        }
        BackNoe backNoe = new BackNoe(csH1, csHeavy, csH2, dist, 0.0, secondResNo, firstResNo, secondResName, firstResName, secondAtomName, heavyName, firstAtomName);
        return backNoe;
    }

    public Vector BackCompNoePattern(Vector asgVec, int resNo, String resName, Vector vecHDist) {
        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
        int i = 0;
        while (i < vecHDist.size()) {
            Hdist hdist = (Hdist)vecHDist.elementAt(i);
            double distance = hdist.getDistance();
            BackNoe backNoe = this.BackCompNOEPeak(asgVec, hdist);
            vecBackNoe.add(backNoe);
            ++i;
        }
        return vecBackNoe;
    }

    public Vector<BackNoe> BackCompNoePatternNew(Vector<H1CS> asgVec, Vector<Hdist> vecHDist) {
        Vector<BackNoe> vecBackNoe = new Vector<BackNoe>();
        int i = 0;
        while (i < vecHDist.size()) {
            Hdist hdist = vecHDist.elementAt(i);
            double distance = hdist.getDistance();
            BackNoe backNoe = this.BackCompNOEPeakNew(asgVec, hdist);
            vecBackNoe.add(backNoe);
            ++i;
        }
        return vecBackNoe;
    }

    public static class scoreComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            RotaPattern n1 = (RotaPattern)o1;
            RotaPattern n2 = (RotaPattern)o2;
            double d1 = n1.getScore();
            if (d1 > (d2 = n2.getScore())) {
                return -1;
            }
            if (d1 < d2) {
                return 1;
            }
            return 0;
        }
    }
}

