/*
 * Decompiled with CFR 0.152.
 */
package rdcPanda;

import Jampack.JampackException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Vector;
import rdcPanda.Assign;
import rdcPanda.Const;
import rdcPanda.H1CS;
import rdcPanda.Hsqc;
import rdcPanda.Model;
import rdcPanda.ModelRdc;
import rdcPanda.Noe;
import rdcPanda.Noesy;
import rdcPanda.Pdb;
import rdcPanda.PdbRmsd;
import rdcPanda.Peak;
import rdcPanda.vdw;

public class SSEPacking {
    private double ranTheta = 0.0;
    private double ranPhi = 0.0;
    private double lengthR = 0.0;
    private double score = 0.0;

    public SSEPacking() {
        this.ranTheta = 0.0;
        this.ranPhi = 0.0;
        this.lengthR = 0.0;
        this.score = 0.0;
    }

    public SSEPacking(double dbT, double dbP, double dbR, double dbS) {
        this.ranTheta = dbT;
        this.ranPhi = dbP;
        this.lengthR = dbR;
        this.score = dbS;
    }

    public double getTheta() {
        return this.ranTheta;
    }

    public double getPhi() {
        return this.ranPhi;
    }

    public double getLengthR() {
        return this.lengthR;
    }

    public double getScore() {
        return this.score;
    }

    public static void SSEsOneToOnePacking(String[] argv) throws JampackException {
        long startTime = System.currentTimeMillis();
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String paramFile = String.valueOf(src) + "parameters.input";
        Vector<Map<String, String>> paraVec = asg.ParamReader(paramFile);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        double noeBound = 0.0;
        String strSeq = "";
        String strBB = "";
        String strReson = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strHaNoesy3D = "";
        String strManualAsg = "";
        String strSSES = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("NOEBOUND")) {
                noeBound = Double.parseDouble(paraMap.get("NOEBOUND"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            strSeq = strSeq.toLowerCase();
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            strNoesy2D = strNoesy2D.toLowerCase();
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            strHnNoesy3D = strHnNoesy3D.toLowerCase();
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            strHaNoesy3D = strHaNoesy3D.toLowerCase();
            if (paraMap.containsKey("MANUAL-ASSIGNMENT")) {
                strManualAsg = paraMap.get("MANUAL-ASSIGNMENT");
            }
            strManualAsg = strManualAsg.toLowerCase();
            if (paraMap.containsKey("SSES")) {
                strSSES = paraMap.get("SSES");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String pdbFile = String.valueOf(src) + strBB;
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<H1CS> assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Object> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = noesy.NoesyReaderNMRView(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = noesy.NoesyReaderNMRView(strNoeFile);
        }
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector<Noesy> vecNewNoesy = noesy.SetCalibration(vecNoesy);
        String rotSrc = String.valueOf(src) + "rotasamp-small/";
        String pdbFileXray = String.valueOf(src) + "1d3z.pdb";
        Vector<Pdb> vecTempPdbBB = pp.readPdb(pdbFileXray);
        Vector<Pdb> vecTempPdbBB2 = pp.nameConvert2PDBNew(vecTempPdbBB);
        pp.print(vecTempPdbBB2);
        Vector<Pdb> vecBB = pp.OutputBackbone(vecTempPdbBB);
        double[] vdwValue = new double[1];
        boolean hasVDW = false;
        double vdwLevel = 0.05;
        boolean printVDWViolation = false;
        vdw vander = new vdw();
        Vector vdwVec = new Vector();
        boolean[] resIndex = new boolean[vecTempPdbBB.size()];
        int kk = 0;
        while (kk < resIndex.length) {
            resIndex[kk] = false;
            ++kk;
        }
        Vector<Pdb> vecPdbSseRot0 = pp.AllRotamersStructure(vecTempPdbBB, rotSrc);
        Vector ppVecTALA = pp.AlaninizeStructure(vecTempPdbBB, resIndex, rotSrc);
        Vector ppVecTALA_all = pp.AlaninizeStructure(vecPdbSseRot0, resIndex, rotSrc);
        System.out.println("jhere is pdb after all rotamers:");
        vdwVec = vander.convert2VDW(vecTempPdbBB2);
        boolean[] resClash = new boolean[140];
        int numClashes = vander.countStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true, 0.5);
        int firstClash = 0;
        i = 0;
        while (i < resClash.length) {
            if (resClash[i]) {
                firstClash = i;
                break;
            }
            ++i;
        }
        System.out.println("the number of steric clashes: " + numClashes);
        pp.print(vecBB);
        System.out.println("TER");
        Vector<Pdb> temp1vec = pp.newPdb(vecBB, Const.mat4ThreeDirs[0]);
        pp.print(temp1vec);
        System.out.println("TER");
        temp1vec = pp.newPdb(vecBB, Const.mat4ThreeDirs[1]);
        pp.print(temp1vec);
        System.out.println("TER");
        temp1vec = pp.newPdb(vecBB, Const.mat4ThreeDirs[2]);
        pp.print(temp1vec);
        System.out.println("TER");
        String manualAsgFile = String.valueOf(src) + strManualAsg;
        Noe noe_temp = new Noe();
        Vector vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, -3.0, "PDB-NEW");
        Vector vecManAsgNew = new Vector();
        vecManAsgNew.addAll(vecManAsg);
        Vector vecOrderSSES = asg.getOrder(strSSES);
        Vector<Vector<Pdb>> vecPdbSSE = new Vector<Vector<Pdb>>();
        i = 0;
        while (i < vecOrderSSES.size()) {
            String strPdbFile = (String)vecOrderSSES.elementAt(i);
            strPdbFile = String.valueOf(src) + strPdbFile + ".pdb";
            Vector<Pdb> pdbVecSSE_temp = pp.readPdb(strPdbFile);
            Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, pdbVecSSE_temp);
            Collections.sort(pdbVecSSE_temp2, new Pdb.PdbComparator());
            vecPdbSSE.add(pdbVecSSE_temp);
            ++i;
        }
        Vector<Vector> vecPdbRotSSE = new Vector<Vector>();
        Model md = new Model();
        i = 0;
        while (i < vecPdbSSE.size()) {
            Vector vecPdbSseBb = (Vector)vecPdbSSE.elementAt(i);
            Vector<Pdb> vecPdbSseRot = pp.AllRotamersStructure(vecPdbSseBb, rotSrc);
            Vector vecPdbSseRotNew = md.BackonbeRotation(vecPdbSseRot, vecPdbSseBb);
            Collections.sort(vecPdbSseRotNew, new Pdb.PdbComparator());
            vecPdbRotSSE.add(vecPdbSseRotNew);
            ++i;
        }
        System.out.println("====================================");
        Vector vecPdbA = new Vector();
        Vector vecPdbB = new Vector();
        vecPdbA.addAll((Vector)vecPdbRotSSE.elementAt(0));
        Collections.sort(vecPdbA, new Pdb.PdbComparator());
        PdbRmsd pdr = new PdbRmsd();
        double[] max_score = new double[4];
        Vector[] vecEnsembPack = new Vector[4];
        PdbRmsd psd = new PdbRmsd();
        double[] noeRmsd = new double[1];
        double[] noeRms = new double[4];
        boolean debugNOE = true;
        Vector[] ubqByRdcVec = new Vector[4];
        Vector[] vecNewNOE = new Vector[4];
        Vector vecNoeUpdateOrder = noe_temp.UpdateNOE(vecManAsgNew, vecPdbSSE);
        Vector vecTemp = new Vector();
        Vector vecPdbTempA = new Vector();
        vecPdbTempA.addAll((Vector)vecPdbRotSSE.elementAt(0));
        int k = 1;
        while (k < vecPdbRotSSE.size()) {
            Vector noeVec = new Vector();
            noeVec = (Vector)vecNoeUpdateOrder.elementAt(k - 1);
            vecPdbB = new Vector();
            vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k));
            vecPdbTempA.addAll(vecPdbB);
            Collections.sort(vecPdbTempA, new Pdb.PdbComparator());
            boolean bl = noe_temp.CheckNoeHInPdb(noeVec, vecPdbTempA);
            ++k;
        }
        i = 0;
        while (i < 4) {
            ubqByRdcVec[i] = new Vector();
            vecNewNOE[i] = new Vector();
            ++i;
        }
        Vector vecVecNewNOE = new Vector();
        Vector<Object> vecTempBB = new Vector();
        int t = 70;
        while (t <= 90) {
            vecPdbA = new Vector();
            String strEnsemPdb = String.valueOf(src) + "FF2H1H3Final" + t + ".pdb";
            String strPass = "FF2H13H2New" + t + "00";
            System.out.println("**********************input: " + strEnsemPdb);
            Vector<Pdb> vecPdbABB = pp.readPdb(strEnsemPdb);
            Vector<Pdb> vecPdbATEmp = pp.AllRotamersStructure(vecPdbABB, rotSrc);
            vecPdbA = md.BackonbeRotation(vecPdbATEmp, vecPdbABB);
            int k2 = 1;
            while (k2 < vecPdbRotSSE.size()) {
                double[] dbTemp = new double[1];
                vecPdbB = new Vector();
                vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k2));
                Vector<Object> helixVecN = new Vector();
                Vector noeVec = new Vector();
                noeVec.addAll((Vector)vecNoeUpdateOrder.elementAt(k2 - 1));
                noe_temp.PrintNOE(noeVec);
                i = 2;
                helixVecN = pp.newPdb(vecPdbA, Const.mat4ThreeDirs[i - 1]);
                ubqByRdcVec[i] = psd.positionByNOEAllRotamers(noeVec, helixVecN, vecPdbB, noeRmsd, debugNOE, vecNewNOE[i], strPass, vecSeq, 0.8);
                noeRms[i] = noeRmsd[0];
                vecTempBB = pp.OutputBackbone(ubqByRdcVec[i]);
                pp.print(vecTempBB);
                System.out.println("TER");
                System.out.println("END");
                ++k2;
            }
            ++t;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public static void PackingHelicesBasedOnNOEPatterns(String[] argv) throws JampackException {
        long startTime = System.currentTimeMillis();
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String paramFile = String.valueOf(src) + "parameters.input";
        Vector<Map<String, String>> paraVec = asg.ParamReader(paramFile);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        double noeBound = 0.0;
        String strSeq = "";
        String strBB = "";
        String strReson = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strHaNoesy3D = "";
        String strManualAsg = "";
        String strSSES = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("NOEBOUND")) {
                noeBound = Double.parseDouble(paraMap.get("NOEBOUND"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            strSeq = strSeq.toLowerCase();
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            strNoesy2D = strNoesy2D.toLowerCase();
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            strHnNoesy3D = strHnNoesy3D.toLowerCase();
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            strHaNoesy3D = strHaNoesy3D.toLowerCase();
            if (paraMap.containsKey("MANUAL-ASSIGNMENT")) {
                strManualAsg = paraMap.get("MANUAL-ASSIGNMENT");
            }
            strManualAsg = strManualAsg.toLowerCase();
            if (paraMap.containsKey("SSES")) {
                strSSES = paraMap.get("SSES");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String pdbFile = String.valueOf(src) + strBB;
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<H1CS> assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Object> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = noesy.NoesyReader(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = noesy.NoesyReader(strNoeFile);
        }
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector<Noesy> vecNewNoesy = noesy.SetCalibration(vecNoesy);
        String rotSrc = String.valueOf(src) + "rotasamp-small/";
        String pdbFileXray = String.valueOf(src) + "H3.pdb";
        Vector<Pdb> vecTempPdbBB = pp.readPdb(pdbFileXray);
        Vector vecTempPdbBB2 = pp.nameConvert(vecTempPdbBB);
        Vector<Pdb> vecBB = pp.OutputBackbone(vecTempPdbBB2);
        String manualAsgFile = String.valueOf(src) + strManualAsg;
        Noe noe_temp = new Noe();
        Vector vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, "PDB-NEW");
        Vector vecOrderSSES = asg.getOrder(strSSES);
        Vector<Vector> vecPdbSSE = new Vector<Vector>();
        i = 0;
        while (i < vecOrderSSES.size()) {
            String strPdbFile = (String)vecOrderSSES.elementAt(i);
            strPdbFile = String.valueOf(src) + strPdbFile + ".pdb";
            Vector<Pdb> pdbVecSSE_temp = pp.readPdb(strPdbFile);
            Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, pdbVecSSE_temp);
            Vector pdbVecSSE = pp.nameConvert(pdbVecSSE_temp2);
            Collections.sort(pdbVecSSE, new Pdb.PdbComparator());
            vecPdbSSE.add(pdbVecSSE);
            ++i;
        }
        Vector<Vector> vecPdbRotSSE = new Vector<Vector>();
        Model md = new Model();
        i = 0;
        while (i < vecPdbSSE.size()) {
            Vector vecPdbSseBb = (Vector)vecPdbSSE.elementAt(i);
            Vector<Object> vecPdbSseRot = new Vector();
            vecPdbSseRot = pp.RotamSelectAndStructure(2.0 * h1Err, 2.0 * nErr, 2.0 * c13Err, vecPdbSseBb, assignVec, rotSrc, vecNewNoesy, noeBound, 1, 0.0);
            Vector vecPdbSseRotNew = md.BackonbeRotation(vecPdbSseRot, vecPdbSseBb);
            Collections.sort(vecPdbSseRotNew, new Pdb.PdbComparator());
            vecPdbRotSSE.add(vecPdbSseRotNew);
            ++i;
        }
        System.out.println("====================================");
        Vector<Pdb> vecPdbA = new Vector<Pdb>();
        Vector vecPdbB = new Vector();
        vecPdbA.addAll((Vector)vecPdbRotSSE.elementAt(0));
        Collections.sort(vecPdbA, new Pdb.PdbComparator());
        PdbRmsd pdr = new PdbRmsd();
        double[] max_score = new double[4];
        Vector[] vecEnsembPack = new Vector[4];
        PdbRmsd psd = new PdbRmsd();
        double[] noeRmsd = new double[1];
        double[] noeRms = new double[4];
        boolean debugNOE = true;
        Vector[] ubqByRdcVec = new Vector[4];
        Vector[] vecNewNOE = new Vector[4];
        Vector vecNoeUpdateOrder = noe_temp.UpdateNOE(vecManAsg, vecPdbSSE);
        Vector vecTemp = new Vector();
        Vector vecPdbTempA = new Vector();
        vecPdbTempA.addAll((Vector)vecPdbRotSSE.elementAt(0));
        int k = 1;
        while (k < vecPdbRotSSE.size()) {
            Vector noeVec = new Vector();
            noeVec = (Vector)vecNoeUpdateOrder.elementAt(k - 1);
            vecPdbB = new Vector();
            vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k));
            vecPdbTempA.addAll(vecPdbB);
            Collections.sort(vecPdbTempA, new Pdb.PdbComparator());
            boolean bl = noe_temp.CheckNoeHInPdb(noeVec, vecPdbTempA);
            ++k;
        }
        i = 0;
        while (i < 4) {
            ubqByRdcVec[i] = new Vector();
            vecNewNOE[i] = new Vector();
            ++i;
        }
        Vector vecVecNewNOE = new Vector();
        Vector vecTempBB = new Vector();
        int k2 = 1;
        while (k2 < vecPdbRotSSE.size()) {
            double[] dbTemp = new double[1];
            vecPdbB = new Vector();
            vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k2));
            Vector<Object> helixVecN = new Vector();
            Vector noeVec = new Vector();
            noeVec.addAll((Vector)vecNoeUpdateOrder.elementAt(k2 - 1));
            noe_temp.PrintNOE(noeVec);
            noeRms[0] = noeRmsd[0];
            i = 1;
            helixVecN = pp.newPdb(vecPdbA, Const.mat4ThreeDirs[i - 1]);
            ubqByRdcVec[i] = psd.positionByNOE(noeVec, helixVecN, vecPdbB, noeRmsd, debugNOE, vecNewNOE[i]);
            noeRms[i] = noeRmsd[0];
            vecTempBB = pp.OutputBackboneNoCB(ubqByRdcVec[i]);
            pp.print(vecTempBB);
            System.out.println("TER");
            System.out.println("END");
            ++k2;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public static void main1(String[] argv) throws JampackException {
        long startTime = System.currentTimeMillis();
        Hsqc hqc = new Hsqc();
        Peak pk = new Peak();
        ModelRdc mdc = new ModelRdc();
        Assign asg = new Assign();
        Pdb pp = new Pdb();
        String userDir = System.getProperty("user.dir");
        String src = String.valueOf(userDir) + "/inputFiles/";
        String paramFile = String.valueOf(src) + "parameters.input";
        Vector<Map<String, String>> paraVec = asg.ParamReader(paramFile);
        double haErr = 0.0;
        double h1Err = 0.0;
        double c13Err = 0.0;
        double hnErr = 0.0;
        double nErr = 0.0;
        double noeBound = 0.0;
        String strSeq = "";
        String strBB = "";
        String strReson = "";
        String strNoesy2D = "";
        String strHnNoesy3D = "";
        String strHaNoesy3D = "";
        String strManualAsg = "";
        String strSSES = "";
        int i = 0;
        while (i < paraVec.size()) {
            Map<String, String> paraMap = paraVec.elementAt(i);
            if (paraMap.containsKey("HAERR")) {
                haErr = Double.parseDouble(paraMap.get("HAERR"));
            }
            if (paraMap.containsKey("H1ERR")) {
                h1Err = Double.parseDouble(paraMap.get("H1ERR"));
            }
            if (paraMap.containsKey("C13ERR")) {
                c13Err = Double.parseDouble(paraMap.get("C13ERR"));
            }
            if (paraMap.containsKey("HNERR")) {
                hnErr = Double.parseDouble(paraMap.get("HNERR"));
            }
            if (paraMap.containsKey("NERR")) {
                nErr = Double.parseDouble(paraMap.get("NERR"));
            }
            if (paraMap.containsKey("NOEBOUND")) {
                noeBound = Double.parseDouble(paraMap.get("NOEBOUND"));
            }
            if (paraMap.containsKey("SEQUENCE")) {
                strSeq = paraMap.get("SEQUENCE");
            }
            strSeq = strSeq.toLowerCase();
            if (paraMap.containsKey("BACKBONE")) {
                strBB = paraMap.get("BACKBONE");
            }
            strBB = strBB.toLowerCase();
            if (paraMap.containsKey("RESONANCE")) {
                strReson = paraMap.get("RESONANCE");
            }
            strReson = strReson.toLowerCase();
            if (paraMap.containsKey("2D-NOESY")) {
                strNoesy2D = paraMap.get("2D-NOESY");
            }
            strNoesy2D = strNoesy2D.toLowerCase();
            if (paraMap.containsKey("3D-N15-NOESY")) {
                strHnNoesy3D = paraMap.get("3D-N15-NOESY");
            }
            strHnNoesy3D = strHnNoesy3D.toLowerCase();
            if (paraMap.containsKey("3D-C13-NOESY")) {
                strHaNoesy3D = paraMap.get("3D-C13-NOESY");
            }
            strHaNoesy3D = strHaNoesy3D.toLowerCase();
            if (paraMap.containsKey("MANUAL-ASSIGNMENT")) {
                strManualAsg = paraMap.get("MANUAL-ASSIGNMENT");
            }
            strManualAsg = strManualAsg.toLowerCase();
            if (paraMap.containsKey("SSES")) {
                strSSES = paraMap.get("SSES");
            }
            ++i;
        }
        String seqFile = String.valueOf(src) + strSeq;
        Vector<Assign> vecSeq = asg.ReaderSeq(seqFile);
        String pdbFile = String.valueOf(src) + strBB;
        Vector<Pdb> pdbVecBB = pp.readPdb(pdbFile);
        Vector<Pdb> pdbVec3 = pp.residueNameUpdate(vecSeq, pdbVecBB);
        Vector pdbVecBBN = pp.nameConvert(pdbVec3);
        Collections.sort(pdbVecBBN, new Pdb.PdbComparator());
        H1CS h1CS = new H1CS();
        String assignFile = String.valueOf(src) + strReson;
        Vector<H1CS> assignVec = h1CS.h1CSReader(assignFile, vecSeq);
        Vector<Peak> allH1Vec = pk.allProtonSorted(assignVec);
        Collections.sort(allH1Vec, new Peak.csComparator());
        Noesy noesy = new Noesy();
        String strNoeFile = "";
        Vector<Object> hnNoeVec = new Vector();
        Vector<Object> cnoeVec = new Vector();
        strNoesy2D.equalsIgnoreCase("NULL");
        if (!strHnNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHnNoesy3D;
            hnNoeVec = noesy.NoesyReader(strNoeFile);
        }
        if (!strHaNoesy3D.equalsIgnoreCase("NULL")) {
            strNoeFile = String.valueOf(src) + strHaNoesy3D;
            cnoeVec = noesy.NoesyReader(strNoeFile);
        }
        Vector<Noesy> vecNoesy = new Vector<Noesy>();
        vecNoesy.addAll(hnNoeVec);
        vecNoesy.addAll(cnoeVec);
        Vector<Noesy> vecNewNoesy = noesy.SetCalibration(vecNoesy);
        String rotSrc = String.valueOf(src) + "rotasamp-small/";
        String pdbFileXray = String.valueOf(src) + "2A7O.pdb";
        Vector<Pdb> vecTempPdbBB = pp.readPdb(pdbFileXray);
        Vector vecTempPdbBB2 = pp.nameConvert(vecTempPdbBB);
        Vector<Pdb> vecBB = pp.OutputBackbone(vecTempPdbBB2);
        String manualAsgFile = String.valueOf(src) + strManualAsg;
        Noe noe_temp = new Noe();
        Vector vecManAsg = noe_temp.LongRangeNoeReader(manualAsgFile, 0.0, "PDB-NEW");
        Vector vecOrderSSES = asg.getOrder(strSSES);
        Vector<Vector> vecPdbSSE = new Vector<Vector>();
        i = 0;
        while (i < vecOrderSSES.size()) {
            String strPdbFile = (String)vecOrderSSES.elementAt(i);
            strPdbFile = String.valueOf(src) + strPdbFile + ".pdb";
            Vector<Pdb> pdbVecSSE_temp = pp.readPdb(strPdbFile);
            Vector<Pdb> pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, pdbVecSSE_temp);
            Vector pdbVecSSE = pp.nameConvert(pdbVecSSE_temp2);
            Collections.sort(pdbVecSSE, new Pdb.PdbComparator());
            vecPdbSSE.add(pdbVecSSE);
            ++i;
        }
        Vector<Vector> vecPdbRotSSE = new Vector<Vector>();
        Model md = new Model();
        i = 0;
        while (i < vecPdbSSE.size()) {
            Vector vecPdbSseBb = (Vector)vecPdbSSE.elementAt(i);
            Vector<Pdb> vecPdbSseRot = pp.AllRotamersStructure(vecPdbSseBb, rotSrc);
            Vector vecPdbSseRotNew = md.BackonbeRotation(vecPdbSseRot, vecPdbSseBb);
            Collections.sort(vecPdbSseRotNew, new Pdb.PdbComparator());
            vecPdbRotSSE.add(vecPdbSseRotNew);
            ++i;
        }
        System.out.println("====================================");
        Vector<Pdb> vecPdbA = new Vector<Pdb>();
        Vector vecPdbB = new Vector();
        vecPdbA.addAll((Vector)vecPdbRotSSE.elementAt(0));
        Collections.sort(vecPdbA, new Pdb.PdbComparator());
        PdbRmsd pdr = new PdbRmsd();
        double[] max_score = new double[4];
        Vector[] vecEnsembPack = new Vector[4];
        PdbRmsd psd = new PdbRmsd();
        double[] noeRmsd = new double[1];
        double[] noeRms = new double[4];
        boolean debugNOE = true;
        Vector[] ubqByRdcVec = new Vector[4];
        Vector[] vecNewNOE = new Vector[4];
        Vector vecNoeUpdateOrder = noe_temp.UpdateNOE(vecManAsg, vecPdbSSE);
        Vector vecTemp = new Vector();
        Vector vecPdbTempA = new Vector();
        vecPdbTempA.addAll((Vector)vecPdbRotSSE.elementAt(0));
        int k = 1;
        while (k < vecPdbRotSSE.size()) {
            Vector noeVec = new Vector();
            noeVec = (Vector)vecNoeUpdateOrder.elementAt(k - 1);
            vecPdbB = new Vector();
            vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k));
            vecPdbTempA.addAll(vecPdbB);
            Collections.sort(vecPdbTempA, new Pdb.PdbComparator());
            boolean bl = noe_temp.CheckNoeHInPdb(noeVec, vecPdbTempA);
            ++k;
        }
        i = 0;
        while (i < 4) {
            ubqByRdcVec[i] = new Vector();
            vecNewNOE[i] = new Vector();
            ++i;
        }
        Vector vecVecNewNOE = new Vector();
        Vector vecEnsembPackNew = new Vector();
        int k2 = 1;
        while (k2 < vecPdbRotSSE.size()) {
            double[] dbTemp = new double[1];
            vecPdbB = new Vector();
            vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k2));
            Vector<Object> helixVecN = new Vector();
            Vector noeVec = new Vector();
            noeVec.addAll((Vector)vecNoeUpdateOrder.elementAt(k2 - 1));
            noe_temp.PrintNOE(noeVec);
            Vector vecTempPackEnsem = new Vector();
            vecTempPackEnsem = psd.positionByNOENew(noeVec, vecPdbA, vecPdbB, noeRmsd, debugNOE, vecNewNOE[0]);
            vecEnsembPackNew.addAll(vecTempPackEnsem);
            noeRms[0] = noeRmsd[0];
            i = 1;
            while (i < 4) {
                vecTempPackEnsem = new Vector();
                helixVecN = pp.newPdb(vecPdbA, Const.mat4ThreeDirs[i - 1]);
                vecTempPackEnsem = psd.positionByNOENew(noeVec, helixVecN, vecPdbB, noeRmsd, debugNOE, vecNewNOE[i]);
                noeRms[i] = noeRmsd[0];
                vecEnsembPackNew.addAll(vecTempPackEnsem);
                ++i;
            }
            vecTemp = (Vector)vecEnsembPackNew.elementAt(0);
            vecPdbA = new Vector();
            vecPdbA.addAll(vecTemp);
            Collections.sort(vecPdbA, new Pdb.PdbComparator());
            System.out.println("the i-th iteration packing" + k2);
            i = 0;
            while (i < vecEnsembPackNew.size()) {
                Vector vecTempOne = (Vector)vecEnsembPackNew.elementAt(i);
                System.out.println("the ith structure in the ensemble:" + i);
                pp.print(vecTempOne);
                System.out.println("TER");
                System.out.println("END");
                ++i;
            }
            ++k2;
        }
        System.out.println("Here we have the final stucture...");
        i = 0;
        while (i < vecEnsembPackNew.size()) {
            Vector vecTempOne = (Vector)vecEnsembPackNew.elementAt(i);
            System.out.println("the ith structure in the ensemble:" + i);
            pp.print(vecTempOne);
            System.out.println("TER");
            System.out.println("END");
            Vector<Pdb> vecFirstBB = pp.OutputBackbone(vecTempOne);
            System.out.println("here we have the  Backbone:");
            pp.print(vecFirstBB);
            System.out.println("TER");
            System.out.println("END");
            ++i;
        }
        long endTime = System.currentTimeMillis();
        double totalTime = (double)(endTime - startTime) / 60000.0;
        System.out.println("Time= " + totalTime + " minutes");
    }

    public static class SSEPackingComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            double d2;
            SSEPacking n1 = (SSEPacking)o1;
            SSEPacking n2 = (SSEPacking)o2;
            double d1 = n1.getScore();
            if (d1 < (d2 = n2.getScore())) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
    }
}

