package Nasca;
/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/
import java.util.Comparator;
import java.util.Vector;

import rdcPanda.H1CS;
import rdcPanda.Noesy;
import rdcPanda.Peak;
import rdcPanda.RotaPattern;


public class GraphNode {
	private int id=0;
	private double csProton=0.0;//chemical shift of proton
	private double csHeavy=0.0;//cs of heavy atom attached to proton
	private boolean isAsigned=false;
	
	private int resNo=0;
	private String resName="";
	private String atomName="";
	
	public int asgedId=-1;//the one-to-one assignment
	Vector<GraphNode> vecAdj=new Vector<GraphNode>();//for storing the adjacent nodes;
	public Vector<Noesy> vecAdjNOESY=new Vector<Noesy>();// for storing interacting NOESY peaks for a resonance node.
	public Vector<GraphNode> vecSymSet=new Vector<GraphNode>(); //for storing symmetry resonance nodes
	private Vector<ProtonLabel> vecMappingSet=new Vector<ProtonLabel>();//store all possible mapping set
	public Vector<GraphNode> vecStereoSymSet=new Vector<GraphNode>();//store all stereo symmetry resonance nodes
	public int stereoID=-99;//id of the other stereo proton
	public boolean isRestrained=false;
	
	double bestScore=-999.9;//best NOE pattern matching score given previous bb chemical shifts
	
	public int asgedIdTemp=-1;//Temp assigned ID, used in the A* search.
	
	
	
   /**
     * The Class scoreComparator.
     */
    public static class scoreComparator implements Comparator<Object>{
    	
	    /* (non-Javadoc)
	     * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	     */
	    public int compare(Object o1, Object o2){
	    	GraphNode n1 = (GraphNode)o1;
	    	GraphNode n2 = (GraphNode)o2;
    	    double d1 = n1.bestScore;
    	    double d2 = n2.bestScore;
    	    if (d1 >d2)
    		return -1;
    	    else if (d1 < d2)
    		return 1;
    	    else return 0;
    	}
        }
    
    public void setIsAssigned(boolean tf){ isAsigned=tf;}
	public void setResName(String res){ resName=res;}
	public void setAtomName(String atom){ atomName=atom;}
	public void setProtonCS(double cs_h){ csProton=cs_h;}
	public void setHeavyCS(double cs_heavy){ csHeavy=cs_heavy;}
	public void setResNo(int no){ resNo=no;}
	public void setIsRestrained(boolean isRsd){ isRestrained=isRsd;}
	public int getResNo(){return resNo;}
	public String getResName(){return resName;}
	public String getAtomName(){return atomName;}
	public Vector<ProtonLabel> getMappingSet(){return vecMappingSet;}
	
	public Vector<GraphNode> getAdjVec(){return vecAdj;}
	public boolean getIsAssigned(){return isAsigned;}
	public int getID(){
		return id;
	}
	public double getCSProton(){
		return csProton;
	}
	public double getCSHeavy(){
		return csHeavy;
	}
	//initialization for resonanance node
	public GraphNode(){		
	}
	
	public GraphNode(int idT, double cs_H, double cs_heavy, boolean isAsged)
	{
		id=idT;
		csProton=cs_H;
		csHeavy=cs_heavy;
		isAsigned=isAsged;			
		vecAdj=new Vector<GraphNode>();
		vecSymSet=new Vector<GraphNode>();
		vecMappingSet=new Vector<ProtonLabel>();
		vecStereoSymSet=new Vector<GraphNode>();
		//isRestrained=false;
	}
	public void AddAdj(GraphNode ndNeigh)
	{
		int IDT=ndNeigh.getID();
		boolean isInPres=false;
		for(int i=0;i<vecAdj.size();i++)
		{
			GraphNode nd=(GraphNode)vecAdj.elementAt(i);
			int IDPre=nd.getID();
			if(IDT==IDPre)
				isInPres=true;
		}
		if(!isInPres)
			vecAdj.add(ndNeigh);
	}
	
	public void AddAdjNOESY(Noesy noesy){
		boolean isInPre=false;
		double csH1Cur=noesy.getH1();
		double csH2Cur=noesy.getH2();
		double csHeavyCur=noesy.getHeavy();
		for(int i=0;i<vecAdjNOESY.size();i++){
			Noesy noesyT=(Noesy)vecAdjNOESY.elementAt(i);
			double csH1=noesyT.getH1();
			double csH2=noesyT.getH2();
			double csHeavy=noesyT.getHeavy();
			if(Math.abs(csH1Cur-csH1)<0.005 && Math.abs(csH2Cur-csH2)<0.005 && Math.abs(csHeavyCur-csHeavy)<0.005 )
				isInPre=true;
		}
		if(!isInPre)
			vecAdjNOESY.add(noesy);
	}
	public void addMappingNode(ProtonLabel label){ vecMappingSet.add(label);}
	
	public void EmptyAdjSet(){ 
		vecAdj=new Vector<GraphNode>();
	}
	public void EmptyMappingSet(){ 
		vecMappingSet=new Vector<ProtonLabel>();
	}
	/**
     * add the resonance node into the NOESY graph
     @param csH,csHeavy: chemical shifts of proton and heavy atom attached to it, -999.9 if it is unknown
     @param csErrH,csErrC,csErrN: error windows.
     @param  
     @param 
     @param vecOldGraph old graph 
     @return new graph
     */
	public Vector<GraphNode> AddResonanceNode(Vector<GraphNode> vecOldGraph,double csH, double csHeavy, double csErrH, double csErrC, double csErrN )
	{
		Vector<GraphNode> vecNewGraph=new Vector<GraphNode>();
		boolean isInPres=false;
		for(int i=0;i<vecOldGraph.size();i++)
		{
			GraphNode node=(GraphNode)vecOldGraph.elementAt(i);
			double cs_Proton=node.getCSProton();
			double cs_Heavy=node.getCSHeavy();
			double csMaxHeavy=Math.max(cs_Heavy,csHeavy);
			double csErrHeavy=0.0;
			if(csMaxHeavy>80.0)
				csErrHeavy=csErrN;
			else
				csErrHeavy=csErrC;
			
			if(csHeavy<-100.0)
				continue;
			
			if(csHeavy>-100.0)
			{
				//if((Math.abs(csH-cs_Proton)<0.000001) && (Math.abs(csHeavy-cs_Heavy)<0.0000001) )
				if((Math.abs(csH-cs_Proton)<csErrH) && (Math.abs(csHeavy-cs_Heavy)<csErrHeavy) )						
				{
					isInPres=true;
					if (node.getIsAssigned()==false)
					{
						////GraphNode nodeNear=new GraphNode(node.getID(),csH,csHeavy,false);
						//node.setProtonCS((csH+cs_Proton)/2 );
						//node.setHeavyCS((csHeavy+cs_Heavy)/2 );
					}
				}
			}//if(csHeavy>-100.0)
			else
			{
				
			}
			
		}//for(int i=0;i<vecOldGraph.size();i++)
		if(!isInPres)
		{					
			GraphNode node =new GraphNode(vecOldGraph.size(),csH,csHeavy,false);
			vecOldGraph.add(node);
		}
		vecNewGraph.addAll(vecOldGraph);
		return vecNewGraph;
	}

	/**
     * construct initial NOESY graph from given assigned resonance list
     @param csH,csHeavy: chemical shifts of proton and heavy atom attached to it, -999.9 if it is unkown
     @param csErrH,csErrC,csErrN: eror windows.
     @param  vecUnAsged unassigned resonance list
     @param    
     @return initial NOESY graph
     */
	public Vector<GraphNode> ConstructInitResonGraphFromAsgedList(Vector<H1CS> vecAsged, Vector<H1CS> vecUnAsged )
	{
		Vector<GraphNode> vecGraph=new Vector<GraphNode>();
		Peak pk=new Peak();
		int curId=0;
		for (int i=0;i<vecAsged.size();i++)
		{
			double cs_heavy=-999.9;
			H1CS h1cs=(H1CS)vecAsged.elementAt(i);
			double cs_h=h1cs.getH1CS();
			String res=h1cs.getResidueType();
			String atom=h1cs.getAtomName();
			int resNo=h1cs.getResidueNo();
			if(!atom.substring(0,1).equalsIgnoreCase("H") )
				continue;
			String heavyName=pk.GetHeavyAtomFromProton(res,atom);
			for(int j=0;j<vecAsged.size();j++)
			{
				H1CS h1csHeavy=(H1CS)vecAsged.elementAt(j);
				double cs_Temp=h1csHeavy.getH1CS();
				//String resT=h1csHeavy.getResidueType();
				String atomT=h1csHeavy.getAtomName();
				int resNoT=h1csHeavy.getResidueNo();
				if( (resNoT==resNo) && (atomT.equalsIgnoreCase(heavyName)) )
					cs_heavy=cs_Temp;
			}//for(int j=0;j<vecAsg.size();j++)
			
			GraphNode node=new GraphNode(curId,cs_h,cs_heavy,true);
			node.setAtomName(atom);
			node.setResName(res);
			node.setResNo(resNo);
			vecGraph.add(node);
			curId++;
			
		}//for (int i=0;i<vecAsg.size();i++)
		
		if(vecUnAsged==null)
			return vecGraph;
		
		///////////////
		for (int i=0;i<vecUnAsged.size();i++)
		{
			double cs_heavy=-999.9;
			H1CS h1cs=(H1CS)vecUnAsged.elementAt(i);
			double cs_h=h1cs.getH1CS();
			String res=h1cs.getResidueType();
			String atom=h1cs.getAtomName();
			int resNo=h1cs.getResidueNo();
			if(!atom.substring(0,1).equalsIgnoreCase("H") )
				continue;
			String heavyName=pk.GetHeavyAtomFromProton(res,atom);
			for(int j=0;j<vecUnAsged.size();j++)
			{
				H1CS h1csHeavy=(H1CS)vecUnAsged.elementAt(j);
				double cs_Temp=h1csHeavy.getH1CS();
				//String resT=h1csHeavy.getResidueType();
				String atomT=h1csHeavy.getAtomName();
				int resNoT=h1csHeavy.getResidueNo();
				if( (resNoT==resNo) && (atomT.equalsIgnoreCase(heavyName)) )
					cs_heavy=cs_Temp;
			}//for(int j=0;j<vecAsg.size();j++)
			
			GraphNode node=new GraphNode(curId,cs_h,cs_heavy,false);
			node.setAtomName(" ");
			node.setResName(" ");
			node.setResNo(0);
			vecGraph.add(node);
			curId++;
			
		}//for (int i=0;i<vecAsg.size();i++)
		/////////////////
		return vecGraph;
	}
	
	/**
     * construct the NOESY graph by connecting the edges.
     @param vecNodeSet all resonance nodes
     @param vecNoesy Noesy peak list
     @param  
     @param 
     @param  
     @return the resonance graph after setting connection
     */
	public Vector<GraphNode> ConstructResonGraph(Vector<GraphNode> vecNodeSet, Vector<Noesy> vecNoesy,double errH1, double errH3, double errC, double errN )
	{	
		Vector<GraphNode> vecResonGraph=new Vector<GraphNode>();
		for(int i=0;i<vecNoesy.size();i++)
		{
			Noesy noesy=(Noesy)vecNoesy.elementAt(i);
			double errHeavy=0.0;
			double freH1=noesy.getH1();
			double freHeavy=noesy.getHeavy();
			double freH2=noesy.getH2();
			
			if(freHeavy>80)
				errHeavy=errN;
			else
				errHeavy=errC;
			
			for(int j=0;j<vecNodeSet.size();j++)
			{
				GraphNode node=(GraphNode)vecNodeSet.elementAt(j);
				double csH=node.getCSProton();
				double csHeavy=node.getCSHeavy();
				if(Math.abs(csH-freH1)>errH1)
					continue;				
				if(Math.abs(csHeavy-freHeavy)>errHeavy)
					continue;
				
				
				for(int k=0;k<vecNodeSet.size();k++)
				{
					if(k==j)
						continue;
					GraphNode node2=(GraphNode)vecNodeSet.elementAt(k);
					double csH2=node2.getCSProton();
					if(Math.abs(csH2-freH2)<errH3)
					{
						node.AddAdj(node2);//directed here
						node2.AddAdj(node);//will be considered in another loop
						
						node.AddAdjNOESY(noesy);
						node2.AddAdjNOESY(noesy);
					}
					
				}//for(int k=0;k<vecNodeSet.size();k++)
				
				
			}//for(int j=0;j<vecNodeSet.size();j++)
		}//for(int i=0;i<vecNoesy.size();i++)
		vecResonGraph.addAll(vecNodeSet);
		
		//remove isolated nodes
		/*for(int i=0;i<vecResonGraph.size();i++)
		{
			Node node=(Node)vecResonGraph.elementAt(i);
			Vector vecAdjT=node.getAdjVec();
			if(vecAdjT.size()<1)
			{
				vecResonGraph.remove(i);				
				i--;		
			}
		}//for(int i=0;i<vecResonGraph.size();i++)
		
		//reset the id
		for(int i=0;i<vecResonGraph.size();i++)
		{
			Node node=(Node)vecResonGraph.elementAt(i);
			node.setNodeID(i);		
		}//for(int i=0;i<vecResonGraph.size();i++)
		*/
		return vecResonGraph;		
	}
	
	/**
     * identify the symmetric resonance node based on the error windows of chemical shifts.
     @param vecNodeSet all resonance nodes
     @param vecNoesy Noesy peak list
     @param  
     @param 
     @param  
     @return the resonance graph after setting connection
     */
	public void ConstructResonGraphSymmetry(Vector<GraphNode> vecResonGraph, Vector<Noesy> vecNoesy,double errH1, double errH3, double errC, double errN ){			
		
		for(int i=0;i<vecNoesy.size();i++){				
			Noesy noesy=(Noesy)vecNoesy.elementAt(i);
			double errHeavy=0.0;
			double freH1=noesy.getH1();
			double freHeavy=noesy.getHeavy();
			double freH2=noesy.getH2();
			
			if(freHeavy>80)
				errHeavy=errN;
			else
				errHeavy=errC;
			
			for(int j=0;j<vecResonGraph.size();j++)	{
				GraphNode node=(GraphNode)vecResonGraph.elementAt(j);
				double csH=node.getCSProton();
				double csHeavy=node.getCSHeavy();
				if(Math.abs(csH-freH1)>errH1)
					continue;				
				if(Math.abs(csHeavy-freHeavy)>errHeavy)
					continue;
					
				for(int k=0;k<vecResonGraph.size();k++){
					if(k==j)
						continue;
					GraphNode node2=(GraphNode)vecResonGraph.elementAt(k);
					double csH2=node2.getCSProton();
					//double csHeavy2=node2.getCSHeavy();
														
					if(Math.abs(csH2-freH2)<errH3)
						node.vecSymSet.add(node2);		
					
				}//for(int k=0;k<vecAdj.size();k++)				
			}//for(int j=0;j<vecNodeSet.size();j++)
		}//for(int i=0;i<vecNoesy.size();i++)
		
		//delete non symmetric nodes
		for(int i=0;i<vecResonGraph.size();i++)	{
			GraphNode node=(GraphNode)vecResonGraph.elementAt(i);
			Vector<GraphNode> vec_sym=node.vecSymSet;
			
			for(int k=0;k<vec_sym.size();k++){
				GraphNode ndSym=(GraphNode)vec_sym.elementAt(k);
				Vector<GraphNode> vec_sym2=ndSym.vecSymSet;
				boolean isSymmetry=false;
				for(int w=0;w<vec_sym2.size();w++){
					GraphNode nd=(GraphNode)vec_sym2.elementAt(w);
					int symID=nd.getID();
					if(symID==i)
						isSymmetry=true;						
				}//for(int w=0;w<vec_sym2.size();w++)
				if(!isSymmetry)	{
					vec_sym.remove(k);
					k--;
				}//if(!isSymmetry)
				
			}//for(int k=0;k<vec_sym.size();k++)		
			
		}//for(int i=0;i<vecResonGraph.size();i++)
	}
	
	
	
}
