package rdcPanda;

/********************************************************************
 *  Compilation:  javac Gaussian.java
 *  Execution:    java Gaussian x mu sigma
 *
 *  Function to compute the Gaussian pdf (probability density function)
 *  and the Gaussian cdf (cumulative density function)
 *
 *  % java Gaussian 820 1019 209
 *  0.17050966869132111
 *
 *  % java Gaussian 1500 1019 209
 *  0.9893164837383883
 *
 *  % java Gaussian 1500 1025 231
 *  0.9801220907365489
 *
 *  The approximation is accurate to absolute error less than 8 * 10^(-16).
 *  Reference: http://www.jstatsoft.org/v11/i04/v11i04.pdf
 *
 *************************************************************************/

public class Gaussian {

    // return phi(x) = standard Gaussian pdf
    public static double phi(double x) {
        return Math.exp(-x*x / 2) / Math.sqrt(2 * Math.PI);
    }

    // return phi(x, mu, signma) = Gaussian pdf with mean mu and stddev sigma
    public static double phi(double x, double mu, double sigma) {
        return phi((x - mu) / sigma) / sigma;
    }
    //  added by zeng for specificalized use
    public static double phiExtend(double x, double mu, double sigma) {
        return Math.exp(-0.5*(x-mu)*(x-mu) / (sigma * sigma )); 
    }

    // return Phi(z) = standard Gaussian cdf using Taylor approximation
    public static double Phi(double z) {
        if (z < -8.0) return 0.0;
        if (z >  8.0) return 1.0;
        double sum = 0.0, term = z;
        for (int i = 3; sum + term != sum; i += 2) {
            sum  = sum + term;
            term = term * z * z / i;
        }
        return 0.5 + sum * phi(z);
    }



    // return Phi(z, mu, sigma) = Gaussian cdf with mean mu and stddev sigma
    public static double Phi(double z, double mu, double sigma) {
        return Phi((z - mu) / sigma);
    } 


    // test client
    public static void main(String[] args) {
        double z     =1.01;// Double.parseDouble(args[0]);
        double mu    = 0.0;//Double.parseDouble(args[1]);
        double sigma = 1.0;//Double.parseDouble(args[2]);
        System.out.print(phiExtend(z,mu,sigma));
        //.println(Phi(z, mu, sigma));
    }

}
