package rdcPanda;

// TODO: Auto-generated Javadoc
///////////////////////////////////////////////////////////////////////////////////////////////
//	Maths.java
//
//	  Version:           0.1
//
//
//	  authors:
// 	  initials            name                      organization               email
//	 ---------   -----------------------        ------------------------    ------------------
//	  LW            Lincong Wang                  Dartmouth College       wlincong@cs.dartmouth.edu
//
///////////////////////////////////////////////////////////////////////////////////////////////



/*
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
	USA
	
	Contact Info:
		Bruce Donald
		Duke University
		Department of Computer Science
		Levine Science Research Center (LSRC)
		Durham
		NC 27708-0129 
		USA
		brd@cs.duke.edu
	
	If you use or publish any results derived from the use of this program please cite:
	J. Zeng, J. Boyles, C. Tripathy, L. Wang, A. Yan, P. Zhou and B.R. Donald. 
	"High-Resolution Protein Structure Determination Starting with a Global Fold 
	Calculated from Exact Solutions to the RDC Equations." Submitted For Review.

	Copyright (C) 2009 Jianyang (Michael) Zeng, Lincong Wang and Bruce R. Donald		
	<signature of Bruce Donald>, June 2008 and January 2009
	Bruce Donald, Professor of Computer Science
 */


/**
 * *
 * 
 * This class is modified from the Jama numeric package. Written by Lincong Wang (2001-2005).
 */
public class Maths {

   /**
    * sqrt(a^2 + b^2) without under/overflow. *
    * 
    * @param a the a
    * @param b the b
    * 
    * @return the double
    */

    public static double hypot(double a, double b) {
	double r;
	if (Math.abs(a) > Math.abs(b)) {
	    r = b/a;
	    r = Math.abs(a)*Math.sqrt(1+r*r);
	} else if (b != 0) {
	    r = a/b;
	    r = Math.abs(b)*Math.sqrt(1+r*r);
	} else {
	    r = 0.0;
	}
	return r;
    }
    
    /**
     * solve the sin equation:
     * a * sin(theta) + b * cos(theta) = c;.
     * 
     * @param a the a
     * @param b the b
     * @param c the c
     * @param solutions the solutions
     * 
     * @return true, if sin angles
     */
    public static boolean sinAngles(double a, double b, double c, double[] solutions){
	double r = hypot(a, b);
	if (r == 0.0)
	    return false;
	else if (Math.abs( c / r) > 1.0)
	    return false;
	double theta0 = Math.asin(c / r);
	double sinCnt = b / r;
	double cosCnt = a / r;
	double cnt = 0.0;
	double theta = 0.0;
	if ( cosCnt >= 0 )
	    cnt = Math.asin(sinCnt);
	else cnt = Math.PI - Math.asin(sinCnt);
	solutions[0] = theta0 - cnt;
	solutions[1] = Math.PI - theta0 - cnt;
	return true;
    }
}
