package rdcPanda;

///////////////////////////////////////////////////////////////////////////////////////////////
//	IDof2aryStructure.java
//
//	  Version:           0.1
//
//
//	  authors:
// 	  initials            name                      organization               email
//	 ---------   -----------------------        ------------------------    ------------------
//	  LW            Lincong Wang                  Dartmouth College       wlincong@cs.dartmouth.edu
//
///////////////////////////////////////////////////////////////////////////////////////////////



/*
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
	USA
	
	Contact Info:
		Bruce Donald
		Duke University
		Department of Computer Science
		Levine Science Research Center (LSRC)
		Durham
		NC 27708-0129 
		USA
		brd@cs.duke.edu
	
	If you use or publish any results derived from the use of this program please cite:
	J. Zeng, J. Boyles, C. Tripathy, L. Wang, A. Yan, P. Zhou and B.R. Donald. 
	"High-Resolution Protein Structure Determination Starting with a Global Fold 
	Calculated from Exact Solutions to the RDC Equations." Submitted For Review.

	Copyright (C) 2009 Jianyang (Michael) Zeng, Lincong Wang and Bruce R. Donald		
	<signature of Bruce Donald>, June 2008 and January 2009
	Bruce Donald, Professor of Computer Science
 */


import java.io. *;
import java.util. *;
 
// TODO: Auto-generated Javadoc
/** * 
 *  
*   This class provides functions for processing files with secondary structure element information. Written by Lincong Wang (2001-2005).
*/
public class IDof2aryStructure implements Cloneable{
    
    /** The residue no a. */
    private int residueNoA;     //The number of the starting residue 
    
    /** The residue no b. */
    private int residueNoB;     //The number of the ending residue 
    
    /** The type and id. */
    private String typeAndID;   //The type of the secondary structure element (H or E)

    /**
     * Constructors.
     */
    public IDof2aryStructure(){
        residueNoA = 0;
        residueNoB = 0;
        typeAndID = null;
    }

   /**
    * Instantiates a new i dof2ary structure.
    * 
    * @param Ano the ano
    * @param Bno the bno
    * @param id the id
    */
   public IDof2aryStructure(int Ano, int Bno, String id){
        residueNoA = Ano;
        residueNoB = Bno;
        this.typeAndID = id;
    }
 
    /**
     * Gets the residue no a.
     * 
     * @return the residue no a
     */
    public int getResidueNoA(){
        return residueNoA;
    }
    
    /**
     * Gets the residue no b.
     * 
     * @return the residue no b
     */
    public int getResidueNoB(){
        return residueNoB;
    }
    
    /**
     * Gets the type and id.
     * 
     * @return the type and id
     */
    public String getTypeAndID(){
        return typeAndID;
    }
  
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString() {
        String desc = residueNoA + "  "+residueNoB+"  "+typeAndID;
        return desc;
    }
  
    /**
     * A very simple reader for secondary structure identification file.
     * 
     * @param idFile the name of the file
     * 
     * @return a vector of IDof2aryStructure objects
     */
    public Vector IDof2aryStructureReader(String idFile){
        Vector inputs = new Vector();
        int noA, noB;
        String typeID = "";
	String ss = "";
        try{
            StreamTokenizer in =
                new StreamTokenizer(
                                    new FileReader(idFile));
            while( in.nextToken() != StreamTokenizer.TT_EOF ){ //ignore the comments
                if (in.ttype == StreamTokenizer.TT_WORD)
                    ;
                else if (in.ttype == StreamTokenizer.TT_NUMBER){
                    noA = (int)in.nval;
                    in.nextToken();
                    noB = (int)in.nval;
                    in.nextToken();
		    typeID = in.sval;
		    if  (typeID != null){
			ss = typeID.toUpperCase();
			if (ss.indexOf("H") > -1  ||  ss.indexOf("E") > -1 ){
			    inputs.add(new IDof2aryStructure(noA, noB, ss));
			}
		    }
                }
            }
        }catch (FileNotFoundException e) {
            System.out.println("File not found: " + idFile);
        }catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
        return inputs;
    }

   /**
    * A very simple reader for secondary structure identification file.
    * 
    * @param fileName the file name
    * 
    * @return a vector of IDof2aryStructure objects
    */
    public Vector[] getOrder(String fileName){
	String ss ="", str ="";
        Vector inputs = new Vector();
	int index = -1;
        try{
	    BufferedReader in = new BufferedReader(new FileReader(fileName));	
	    ss = in.readLine();
	    while( ss != null ) {
		ss = ss.toUpperCase();
		if ( ss.indexOf("ORDER") > -1 ){

		    while ((ss = in.readLine()) != null &&  (index = ss.indexOf("-")) > -1 ){
			inputs.add(ss.trim());
		    }
		}
		if ( ss == null)
		    break;
		ss = in.readLine();
	    }	
	    in.close();
	}catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }catch (IOException e) {
            System.out.println("IOException: the stack trace is:");
            e.printStackTrace();
        }
	Vector[]  orderVec = new Vector[inputs.size()];
	for (int m=0; m<orderVec.length; m++)
	    orderVec[m] = new Vector();

	String idNum1 = "";
	String idNum2 = "";
	String id ="";
	int ind2 = -1;
	for (int i =0; i< inputs.size(); i++){
	    str = (String)inputs.elementAt(i);

	    StringTokenizer st = new StringTokenizer(str, "-");
	    int n = st.countTokens();
	    idNum1 = "E"+st.nextToken();
	    for(int j=0; j<n-1; j++){
		idNum2 = "E"+st.nextToken();
		id = idNum1+"-"+idNum2;

 		orderVec[i].add(id);
		idNum1 = idNum2;
	    }
	}
	return orderVec;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#clone()
     */
    protected Object clone(){
        try{
            Object s = super.clone();     
            return s;                     
        } catch (CloneNotSupportedException e)  {
            throw new InternalError();
        }
    }
}
