package NascaGUI;

/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import java.util.Map;
import java.util.Vector;

import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

import Jampack.JampackException;

import rdcPanda.Assign;
import rdcPanda.H1CS;
import rdcPanda.Noe;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * testFrame.java
 *
 * Created on May 6, 2011, 11:50:28 AM
 */
/**
 *
 * @author zjy
 */
public class NascaFrame extends javax.swing.JFrame {

    /** Creates new form testFrame */
    public NascaFrame() {
        initComponents();
        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jTextFieldBBPdb = new javax.swing.JTextField();
        jButtonBBCSOpen = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jTextFieldBBCS = new javax.swing.JTextField();
        jButtonBBPdbOpen = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        jTextFieldAliNoesy = new javax.swing.JTextField();
        jButtonAliNoesyOpen = new javax.swing.JButton();
        jLabel4 = new javax.swing.JLabel();
        jTextFieldAroNoesy = new javax.swing.JTextField();
        jButtonAroNoesyOpen = new javax.swing.JButton();
        jLabel5 = new javax.swing.JLabel();
        jTextFieldN15Noesy = new javax.swing.JTextField();
        jButtonN15NoesyOpen = new javax.swing.JButton();
        jButtonReadSession = new javax.swing.JButton();
        jButtonSaveSession = new javax.swing.JButton();
        jButtonClear = new javax.swing.JButton();
        jButtonRunNasca = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaOutput = new javax.swing.JTextArea();
        jButtonSCResonanceAsg = new javax.swing.JButton();
        jButtonSaveNoeAsg = new javax.swing.JButton();
        jButtonStopNasca = new javax.swing.JButton();
        jLabel6 = new javax.swing.JLabel();
        jMenuBar1 = new javax.swing.JMenuBar();
        jMenuFile = new javax.swing.JMenu();
        jMenuReadSession = new javax.swing.JMenuItem();
        jMenuSaveSession = new javax.swing.JMenuItem();
        jMenuSaveResonanceAsg = new javax.swing.JMenuItem();
        jMenuSaveNoeAsg = new javax.swing.JMenuItem();
        jMenuIQuit = new javax.swing.JMenuItem();
        jMenuRun = new javax.swing.JMenu();
        jMenuRunNasca = new javax.swing.JMenuItem();
        jMenuStopNasca = new javax.swing.JMenuItem();
        jMenuOptions = new javax.swing.JMenu();
        jMenuItemSystemParameters = new javax.swing.JMenuItem();
        jMenuHelp = new javax.swing.JMenu();
        jMenuIManual = new javax.swing.JMenuItem();
        jMenulAbout = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("NASCA - NOE Assignment and Side-Chain Assignment (from NOESY Data)");
        setName("jMainFrame"); // NOI18N

        jPanel1.setBackground(new java.awt.Color(135, 206, 235));
        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Input Files", javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 1, 11))); // NOI18N
        jPanel1.setForeground(new java.awt.Color(153, 255, 204));
        jPanel1.setToolTipText("Input Files");
        jPanel1.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        jPanel1.setDebugGraphicsOptions(javax.swing.DebugGraphics.NONE_OPTION);

        jLabel1.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLabel1.setText("Backbone Coordinates (*.pdb):");
        jLabel1.setToolTipText("Backbone coordinate file");

        jTextFieldBBPdb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldBBPdbActionPerformed(evt);
            }
        });

        jButtonBBCSOpen.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonBBCSOpen.setText("Browse...");
        jButtonBBCSOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBBCSOpenActionPerformed(evt);
            }
        });

        jLabel2.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLabel2.setText("Backbone Chemical Shifts (*.prot,*.txt):");
        jLabel2.setToolTipText("Backbone coordinate file");

        jTextFieldBBCS.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldBBCSActionPerformed(evt);
            }
        });

        jButtonBBPdbOpen.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonBBPdbOpen.setText("Browse...");
        jButtonBBPdbOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBBPdbOpenActionPerformed(evt);
            }
        });

        jLabel3.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLabel3.setText("C13 Aliphatic NOESY Cross Peaks (*.peaks,*.xpk):");
        jLabel3.setToolTipText("Backbone coordinate file");

        jTextFieldAliNoesy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldAliNoesyActionPerformed(evt);
            }
        });

        jButtonAliNoesyOpen.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonAliNoesyOpen.setText("Browse...");
        jButtonAliNoesyOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAliNoesyOpenActionPerformed(evt);
            }
        });

        jLabel4.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel4.setText("C13 Aromatic NOESY Cross Peaks (*.peaks,*.xpk):");
        jLabel4.setToolTipText("Backbone coordinate file");

        jTextFieldAroNoesy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldAroNoesyActionPerformed(evt);
            }
        });

        jButtonAroNoesyOpen.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonAroNoesyOpen.setText("Browse...");
        jButtonAroNoesyOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAroNoesyOpenActionPerformed(evt);
            }
        });

        jLabel5.setFont(new java.awt.Font("Tahoma", 1, 11));
        jLabel5.setText("N15 NOESY Cross Peaks (*.peaks,*.xpk):");
        jLabel5.setToolTipText("Backbone coordinate file");

        jTextFieldN15Noesy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldN15NoesyActionPerformed(evt);
            }
        });

        jButtonN15NoesyOpen.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonN15NoesyOpen.setText("Browse...");
        jButtonN15NoesyOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonN15NoesyOpenActionPerformed(evt);
            }
        });

        jButtonReadSession.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonReadSession.setText("Read Session from...");
        jButtonReadSession.setToolTipText("Read a session file");
        jButtonReadSession.setActionCommand("");
        jButtonReadSession.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonReadSessionActionPerformed(evt);
            }
        });

        jButtonSaveSession.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonSaveSession.setText("Save Session as...");
        jButtonSaveSession.setToolTipText("Save the current session into a file");
        jButtonSaveSession.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSaveSessionActionPerformed(evt);
            }
        });

        jButtonClear.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonClear.setText("Clear");
        jButtonClear.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonClearActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(jLabel2)
                                    .addComponent(jLabel3)
                                    .addComponent(jLabel1))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED))
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                    .addComponent(jLabel4)
                                    .addComponent(jLabel5))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)))
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                                .addComponent(jTextFieldBBPdb, javax.swing.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonBBPdbOpen))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jTextFieldN15Noesy, javax.swing.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE)
                                    .addComponent(jTextFieldAroNoesy, javax.swing.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE)
                                    .addComponent(jTextFieldAliNoesy, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jButtonN15NoesyOpen)
                                    .addComponent(jButtonAroNoesyOpen)
                                    .addComponent(jButtonAliNoesyOpen)))
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                                .addComponent(jTextFieldBBCS, javax.swing.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButtonBBCSOpen))))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jButtonClear, javax.swing.GroupLayout.PREFERRED_SIZE, 146, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(56, 56, 56)
                        .addComponent(jButtonReadSession)
                        .addGap(53, 53, 53)
                        .addComponent(jButtonSaveSession)
                        .addGap(120, 120, 120)))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonBBPdbOpen)
                    .addComponent(jTextFieldBBPdb, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonBBCSOpen)
                    .addComponent(jTextFieldBBCS, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldAliNoesy, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonAliNoesyOpen)
                    .addComponent(jLabel3))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldAroNoesy, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonAroNoesyOpen)
                    .addComponent(jLabel4))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextFieldN15Noesy, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonN15NoesyOpen)
                    .addComponent(jLabel5))
                .addGap(18, 18, Short.MAX_VALUE)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonClear)
                    .addComponent(jButtonReadSession)
                    .addComponent(jButtonSaveSession))
                .addContainerGap())
        );

        jButtonRunNasca.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonRunNasca.setIcon(new javax.swing.ImageIcon(getClass().getResource("/NascaGUI/image/129.gif"))); // NOI18N
        jButtonRunNasca.setText("Run NASCA");
        jButtonRunNasca.setToolTipText("Run NASCA");
        jButtonRunNasca.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                try {
					jButtonRunNascaActionPerformed(evt);
				} catch (JampackException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
            }
        });

        jPanel2.setBackground(new java.awt.Color(135, 206, 235));
        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(null, "Output Texts", javax.swing.border.TitledBorder.CENTER, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Tahoma", 1, 11))); // NOI18N
        jPanel2.setToolTipText("Output texts");

        jTextAreaOutput.setLineWrap(true);
        jTextAreaOutput.setRows(5);
        jScrollPane1.setViewportView(jTextAreaOutput);

        jButtonSCResonanceAsg.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonSCResonanceAsg.setText("Save Resonance Assignments");
        jButtonSCResonanceAsg.setToolTipText("Save Side-Chain Resonance Assginments into a file");
        jButtonSCResonanceAsg.setEnabled(false);
        jButtonSCResonanceAsg.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSCResonanceAsgActionPerformed(evt);
            }
        });

        jButtonSaveNoeAsg.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonSaveNoeAsg.setText("Save NOE Assignments");
        jButtonSaveNoeAsg.setToolTipText("Save NOE Assignments into a file");
        jButtonSaveNoeAsg.setEnabled(false);
        jButtonSaveNoeAsg.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSaveNoeAsgActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap(170, Short.MAX_VALUE)
                .addComponent(jButtonSCResonanceAsg)
                .addGap(50, 50, 50)
                .addComponent(jButtonSaveNoeAsg, javax.swing.GroupLayout.PREFERRED_SIZE, 200, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(159, 159, 159))
            .addComponent(jScrollPane1)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 137, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButtonSaveNoeAsg)
                    .addComponent(jButtonSCResonanceAsg))
                .addContainerGap())
        );

        jButtonStopNasca.setFont(new java.awt.Font("Tahoma", 1, 11));
        jButtonStopNasca.setIcon(new javax.swing.ImageIcon(getClass().getResource("/NascaGUI/image/176.gif"))); // NOI18N
        jButtonStopNasca.setText("Stop NASCA");
        jButtonStopNasca.setToolTipText("Stop NASCA");
        jButtonStopNasca.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonStopNascaActionPerformed(evt);
            }
        });

        jLabel6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/NascaGUI/image/NASCA-smaller.jpg"))); // NOI18N

        jMenuFile.setText("File");

        jMenuReadSession.setText("Read Session from...");
        jMenuReadSession.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuReadSessionActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuReadSession);

        jMenuSaveSession.setText("Save Session as...");
        jMenuSaveSession.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSaveSessionActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuSaveSession);

        jMenuSaveResonanceAsg.setText("Save Resonance Assignments");
        jMenuSaveResonanceAsg.setEnabled(false);
        jMenuSaveResonanceAsg.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSaveResonanceAsgActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuSaveResonanceAsg);

        jMenuSaveNoeAsg.setText("Save NOE Assignments");
        jMenuSaveNoeAsg.setEnabled(false);
        jMenuSaveNoeAsg.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuSaveNoeAsgActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuSaveNoeAsg);

        jMenuIQuit.setText("Quit");
        jMenuIQuit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuIQuitActionPerformed(evt);
            }
        });
        jMenuFile.add(jMenuIQuit);

        jMenuBar1.add(jMenuFile);

        jMenuRun.setText("Run");

        jMenuRunNasca.setText("Run NASCA");
        jMenuRunNasca.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuRunNascaActionPerformed(evt);
            }
        });
        jMenuRun.add(jMenuRunNasca);

        jMenuStopNasca.setText("Stop NASCA");
        jMenuStopNasca.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuStopNascaActionPerformed(evt);
            }
        });
        jMenuRun.add(jMenuStopNasca);

        jMenuBar1.add(jMenuRun);

        jMenuOptions.setText("Options");

        jMenuItemSystemParameters.setText("Parameters");
        jMenuItemSystemParameters.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemSystemParametersActionPerformed(evt);
            }
        });
        jMenuOptions.add(jMenuItemSystemParameters);

        jMenuBar1.add(jMenuOptions);

        jMenuHelp.setText("Help");

        jMenuIManual.setText("User Manual");
        jMenuIManual.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuIManualActionPerformed(evt);
            }
        });
        jMenuHelp.add(jMenuIManual);

        jMenulAbout.setText("About NASCA");
        jMenulAbout.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenulAboutActionPerformed(evt);
            }
        });
        jMenuHelp.add(jMenulAbout);

        jMenuBar1.add(jMenuHelp);

        setJMenuBar(jMenuBar1);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel6)
                    .addComponent(jButtonRunNasca, javax.swing.GroupLayout.PREFERRED_SIZE, 152, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButtonStopNasca, javax.swing.GroupLayout.PREFERRED_SIZE, 152, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel6)
                        .addGap(40, 40, 40)
                        .addComponent(jButtonRunNasca, javax.swing.GroupLayout.PREFERRED_SIZE, 46, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(33, 33, 33)
                        .addComponent(jButtonStopNasca, javax.swing.GroupLayout.PREFERRED_SIZE, 44, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jTextFieldBBPdbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldBBPdbActionPerformed
    	Global.strBBPdbFile=this.jTextFieldBBPdb.getText();
    	//this.jTextFieldBBPdb.setText(this.jTextFieldBBPdb.getText()); 
    	//this.jTextFieldBBPdb.updateUI();
    }//GEN-LAST:event_jTextFieldBBPdbActionPerformed

    private void jButtonBBCSOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBBCSOpenActionPerformed
        
        //String curDir=System.getProperty("user.dir")+File.separator;
        String curDir=Global.getInputFilePath();
        String sourceName="";
        File sourceFile=new File (sourceName);

        JFileChooser bbCSChooser=new JFileChooser(curDir);
        bbCSChooser.setMultiSelectionEnabled(false);
        //chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        bbCSChooser.setFileSelectionMode(JFileChooser.FILES_ONLY); 
        bbCSChooser.setSelectedFile(sourceFile);  // set default for output
        
        String[] html=new String[] {"prot","txt"};
        bbCSChooser.addChoosableFileFilter(new ExtFilter(html,
           "Backbone chemical shift file (*.prot,*.txt)"));
        int option=bbCSChooser.showOpenDialog(this);
        if (option==JFileChooser.APPROVE_OPTION)
        {
            sourceFile=bbCSChooser.getSelectedFile();
            try {sourceName=sourceFile.getCanonicalPath();}
            catch (IOException e) {};
            jTextFieldBBCS.setText(bbCSChooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
            Global.strBBCSFile=bbCSChooser.getCurrentDirectory()+File.separator+sourceFile.getName();
        }
        else {
                    /*add cancelled message here*/
        }
             
        
        
    }//GEN-LAST:event_jButtonBBCSOpenActionPerformed

    private void jTextFieldBBCSActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldBBCSActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldBBCSActionPerformed

    private void jButtonBBPdbOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBBPdbOpenActionPerformed
        
         //String curDir=System.getProperty("user.dir")+File.separator;
         String curDir=Global.getInputFilePath();
         String sourceName="";
    	 File sourceFile=new File (sourceName);            
          
         javax.swing.JFileChooser bbPdbChooser=new javax.swing.JFileChooser(curDir);         
                  
         bbPdbChooser.setMultiSelectionEnabled(false);
    	  //chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
    	 bbPdbChooser.setFileSelectionMode(JFileChooser.FILES_ONLY); 
    	 bbPdbChooser.setSelectedFile(sourceFile);  // set default for output
		 
    	 String[] html=new String[] {"PDB","pdb"};
    	 bbPdbChooser.addChoosableFileFilter(new ExtFilter(html,
               "PDB file (*.pdb)"));
    	 int option=bbPdbChooser.showOpenDialog(this);////////////
         if (option==JFileChooser.APPROVE_OPTION)
         {
             sourceFile=bbPdbChooser.getSelectedFile();
             try {sourceName=sourceFile.getCanonicalPath();}
             catch (IOException e) {};
             jTextFieldBBPdb.setText(bbPdbChooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
             Global.strBBPdbFile=bbPdbChooser.getCurrentDirectory()+File.separator+sourceFile.getName();
          }
          else {
                    /*add cancelled message here*/
        	  
          }
    }//GEN-LAST:event_jButtonBBPdbOpenActionPerformed
    
    private void jTextAreaOutputPropertyChange(java.beans.PropertyChangeEvent evt) {        
    	jTextAreaOutput.selectAll();        	
    	jTextAreaOutput.setCaretPosition(jTextAreaOutput.getDocument().getLength());
    	//jTextAreaOutput.setCaretPosition(0);
    }
    private void jTextFieldAliNoesyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldAliNoesyActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldAliNoesyActionPerformed

    private void jButtonAliNoesyOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAliNoesyOpenActionPerformed
    	String curDir=Global.getInputFilePath();
        //String curDir=System.getProperty("user.dir")+File.separator;
    	String sourceName="";
    	File sourceFile=new File (sourceName);
    	  
    	JFileChooser chooser=new JFileChooser(curDir);
    	chooser.setMultiSelectionEnabled(false);
    	  //chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
    	chooser.setFileSelectionMode(JFileChooser.FILES_ONLY); 
    	chooser.setSelectedFile(sourceFile);  // set default for output
		  
    	String[] html=new String[] {"peaks","xpk"};
    	chooser.addChoosableFileFilter(new ExtFilter(html,
               "NOESY cross peaks (*.peaks,*.xpk)"));
    	int option=chooser.showOpenDialog(this);
	if (option==JFileChooser.APPROVE_OPTION)
	{
          sourceFile=chooser.getSelectedFile();
          try {sourceName=sourceFile.getCanonicalPath();}
          catch (IOException e) {};
          jTextFieldAliNoesy.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
          Global.strAliNoesyFile=chooser.getCurrentDirectory()+File.separator+sourceFile.getName();
        }
        else {
                /*add cancelled message here*/
        }        
    }//GEN-LAST:event_jButtonAliNoesyOpenActionPerformed

    private void jTextFieldAroNoesyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldAroNoesyActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldAroNoesyActionPerformed

    private void jButtonAroNoesyOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAroNoesyOpenActionPerformed
       
      //String curDir=System.getProperty("user.dir")+File.separator;
      String curDir=Global.getInputFilePath();
      String sourceName="";
      File sourceFile=new File (sourceName);

      JFileChooser chooser=new JFileChooser(curDir);
      chooser.setMultiSelectionEnabled(false);
      //chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
      chooser.setFileSelectionMode(JFileChooser.FILES_ONLY); 
      chooser.setSelectedFile(sourceFile);  // set default for output

      String[] html=new String[] {"peaks","xpk"};
      chooser.addChoosableFileFilter(new ExtFilter(html,
           "NOESY cross peaks (*.peaks,*.xpk)"));
      int option=chooser.showOpenDialog(this);
      if (option==JFileChooser.APPROVE_OPTION)
      {
          sourceFile=chooser.getSelectedFile();
          try {sourceName=sourceFile.getCanonicalPath();}
          catch (IOException e) {};
          jTextFieldAroNoesy.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
          Global.strAroNoesyFile=chooser.getCurrentDirectory()+File.separator+sourceFile.getName();
       }
       else {
                /*add cancelled message here*/
       }
        
        
    }//GEN-LAST:event_jButtonAroNoesyOpenActionPerformed

    private void jTextFieldN15NoesyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldN15NoesyActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_jTextFieldN15NoesyActionPerformed

    private void jButtonN15NoesyOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonN15NoesyOpenActionPerformed
        
         // String curDir=System.getProperty("user.dir")+File.separator;
    	  String curDir=Global.getInputFilePath();
    	  String sourceName="";
    	  File sourceFile=new File (sourceName);
    	  
    	  JFileChooser chooser=new JFileChooser(curDir);
    	  chooser.setMultiSelectionEnabled(false);
    	  //chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
    	  chooser.setFileSelectionMode(JFileChooser.FILES_ONLY); 
    	  chooser.setSelectedFile(sourceFile);  // set default for output
		  
    	  String[] html=new String[] {"peaks","xpk"};
    	  chooser.addChoosableFileFilter(new ExtFilter(html,
               "NOESY cross peaks (*.peaks,*.xpk)"));
    	  int option=chooser.showOpenDialog(this);
          if (option==JFileChooser.APPROVE_OPTION)
          {
              sourceFile=chooser.getSelectedFile();
              try {sourceName=sourceFile.getCanonicalPath();}
              catch (IOException e) {};
              jTextFieldN15Noesy.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
              Global.strN15NoesyFile=chooser.getCurrentDirectory()+File.separator+sourceFile.getName();
           }
           else {
                    /*add cancelled message here*/
           }
        
        
    }//GEN-LAST:event_jButtonN15NoesyOpenActionPerformed

    private void jButtonReadSessionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonReadSessionActionPerformed
      
      //String curDir=System.getProperty("user.dir")+File.separator;
      String curDir=Global.getInputFilePath();
      String sourceName="";
      File sourceFile=new File (sourceName);

      JFileChooser chooser=new JFileChooser(curDir);
      chooser.setMultiSelectionEnabled(false);
      chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
      //chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES); 
      chooser.setSelectedFile(sourceFile);  // set default for output

      String[] html=new String[] {"input"};
      chooser.addChoosableFileFilter(new ExtFilter(html,
           "NOESY cross peaks (*.input)"));
      int option=chooser.showOpenDialog(this);
      if (option==JFileChooser.APPROVE_OPTION)
      {
          sourceFile=chooser.getSelectedFile();
          try {sourceName=sourceFile.getCanonicalPath();}
          catch (IOException e) {};
          //jTextFieldAroNoesy.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
          readInputSessionFile(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());
          jTextFieldBBPdb.setText(Global.strBBPdbFile);  // show on GUI
          jTextFieldBBCS.setText(Global.strBBCSFile);
          jTextFieldAliNoesy.setText(Global.strAliNoesyFile);
          jTextFieldAroNoesy.setText(Global.strAroNoesyFile);
          jTextFieldN15Noesy.setText(Global.strN15NoesyFile);      
          
       }
       else {
                /*add cancelled message here*/
       }       
    }//GEN-LAST:event_jButtonReadSessionActionPerformed

    private void readInputSessionFile(String fileName){
    	Assign asg = new Assign();
    	Vector<Map<String, String>> paraVec = asg.ParamReader(fileName);
       	
    	for (int i=0;i<paraVec.size();i++)
    	{
    		
    		Map<String, String> paraMap = paraVec.elementAt(i);    	
    		if(paraMap.containsKey("BACKBONE"))
    			Global.strBBPdbFile=   (String)paraMap.get("BACKBONE") ;
    		if(paraMap.containsKey("RESONANCE"))
    			Global.strBBCSFile=   (String)paraMap.get("RESONANCE") ;    		
    		if(paraMap.containsKey("3D-C13-NOESY"))
    			Global.strAliNoesyFile=   (String)paraMap.get("3D-C13-NOESY") ;
    		if(paraMap.containsKey("3D-C13-NOESY-ARO"))
    			Global.strAroNoesyFile= (String)paraMap.get("3D-C13-NOESY-ARO");
    		if(paraMap.containsKey("3D-N15-NOESY"))
    			Global.strN15NoesyFile= (String)paraMap.get("3D-N15-NOESY");    		
    	}       	     	   	
    }
    private void jButtonRunNascaActionPerformed(java.awt.event.ActionEvent evt) throws JampackException {//GEN-FIRST:event_jButtonRunNascaActionPerformed
    	jTextAreaOutput.setText("");
    	//runNasca();
    	this.jButtonSCResonanceAsg.setEnabled(false);
    	this.jButtonSaveNoeAsg.setEnabled(false);
    	this.jMenuSaveResonanceAsg.setEnabled(false);
    	this.jMenuSaveNoeAsg.setEnabled(false);
    	this.jButtonRunNasca.setEnabled(false);
    	
    	//this.jButtonStopNasca.setEnabled(true);
    	
    	runNasca=new RunNascaForGUI(this.jTextAreaOutput,this.jButtonSCResonanceAsg, this.jButtonSaveNoeAsg,
    			this.jMenuSaveResonanceAsg,this.jMenuSaveNoeAsg,this.jButtonRunNasca,this.jButtonStopNasca);
    	runNasca.execute();
    }//GEN-LAST:event_jButtonRunNascaActionPerformed

    private void jButtonSCResonanceAsgActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSCResonanceAsgActionPerformed
      
      //String curDir=System.getProperty("user.dir")+File.separator;
      String curDir=Global.getOutputFilePath();
      String sourceName="";
      File sourceFile=new File (sourceName);

      JFileChooser chooser=new JFileChooser(curDir);
      chooser.setMultiSelectionEnabled(false);
      chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
      //chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES); 
      chooser.setSelectedFile(sourceFile);  // set default for output

      String[] html=new String[] {"prot"};
      chooser.addChoosableFileFilter(new ExtFilter(html,
           "Side-chain resonance assignments (*.prot)"));
      int option=chooser.showSaveDialog(this);
      if (option==JFileChooser.APPROVE_OPTION)
      {
          sourceFile=chooser.getSelectedFile();
          try {sourceName=sourceFile.getCanonicalPath();}
          catch (IOException e) {};          
          //jTextFieldAroNoesy.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
          H1CS h1cs =new H1CS();
          String fileName=chooser.getCurrentDirectory()+File.separator+sourceFile.getName();
          h1cs.PrintAllAssignmentToFileBMRB(Global.finalAssignments.getResonAsgs(), fileName);
          
       }
       else {
                /*add cancelled message here*/
       }       
    }//GEN-LAST:event_jButtonSCResonanceAsgActionPerformed

    private void jButtonStopNascaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonStopNascaActionPerformed
        if(runNasca!=null){        	
        	runNasca.cancel(true);
        	this.jButtonRunNasca.setEnabled(true);
        	//runNasca=null;
        }
    	
    	
    }//GEN-LAST:event_jButtonStopNascaActionPerformed

    private void jMenuReadSessionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuReadSessionActionPerformed
        //String curDir=System.getProperty("user.dir")+File.separator;
        String curDir=Global.getInputFilePath();
        String sourceName="";
        File sourceFile=new File (sourceName);

        JFileChooser chooser=new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        //chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES); 
        chooser.setSelectedFile(sourceFile);  // set default for output

        String[] html=new String[] {"input"};
        chooser.addChoosableFileFilter(new ExtFilter(html,
             "NOESY cross peaks (*.input)"));
        int option=chooser.showOpenDialog(this);
        if (option==JFileChooser.APPROVE_OPTION)
        {
            sourceFile=chooser.getSelectedFile();
            try {sourceName=sourceFile.getCanonicalPath();}
            catch (IOException e) {};
            //jTextFieldAroNoesy.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
            readInputSessionFile(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());
            jTextFieldBBPdb.setText(Global.strBBPdbFile);  // show on GUI
            jTextFieldBBCS.setText(Global.strBBCSFile);
            jTextFieldAliNoesy.setText(Global.strAliNoesyFile);
            jTextFieldAroNoesy.setText(Global.strAroNoesyFile);
            jTextFieldN15Noesy.setText(Global.strN15NoesyFile);      
            
         }
         else {
                  /*add cancelled message here*/
         }       
    }//GEN-LAST:event_jMenuReadSessionActionPerformed

    private void jButtonSaveSessionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveSessionActionPerformed
    	String curDir=Global.getOutputFilePath();
    	//String curDir=System.getProperty("user.dir")+File.separator;
    	String sourceName="";
    	File sourceFile=new File (sourceName);

    	JFileChooser chooser=new JFileChooser(curDir);
    	chooser.setMultiSelectionEnabled(false);
    	chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
    	//chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES); 
    	chooser.setSelectedFile(sourceFile);  // set default for output

    	String[] html=new String[] {"input"};
    	chooser.addChoosableFileFilter(new ExtFilter(html,
           "Input session file (*.input)"));
    	int option=chooser.showSaveDialog(this);
    	if (option==JFileChooser.APPROVE_OPTION)
    	{
    		sourceFile=chooser.getSelectedFile();
    		try {sourceName=sourceFile.getCanonicalPath();}
    		catch (IOException e) {};
    		//jTextFieldAroNoesy.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
    		
    		//save to the file;
    		String strOutputSessionFile=chooser.getCurrentDirectory()+File.separator+sourceFile.getName();//+".input";
    		writeInputSessionToFile(strOutputSessionFile);
    	}
    	else {
    		/*add cancelled message here*/
    	}       
    }//GEN-LAST:event_jButtonSaveSessionActionPerformed
    
    private void writeInputSessionToFile(String strOutputSessionFile){
    	try
    	{
    		PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(strOutputSessionFile)));
    		out.println("// File name of backbone PDB coordinates:");
    		out.println("backbone = "+ Global.strBBPdbFile+";");    		
    		out.println();out.println();
    		
    		out.println("// File name of backbone chemical shifts:");
    		out.println("resonance = "+ Global.strBBCSFile+";");     		
    		out.println();out.println();
    		
    		out.println("// File name of C-13 aliphatic NOESY cross peaks:");
    		out.println("3D-C13-NOESY = "+ Global.strAliNoesyFile+";"); 
    		out.println();out.println();
    		
    		out.println("// File name of C-13 aromatic NOESY cross peaks:");
    		out.println("3D-C13-NOESY-ARO = "+ Global.strAroNoesyFile+";"); 
    		out.println();out.println();
    		
    		out.println("// File name of N-15 NOESY cross peaks:");
    		out.println("3D-N15-NOESY = "+ Global.strN15NoesyFile+";"); 
    		out.println();out.println();;
    		
	    	out.close();
	    	
		}catch (FileNotFoundException e)
		{
			System.out.println("File not found: " + strOutputSessionFile);
		}catch (IOException e)
		{
			System.out.println("IOException: the stack trace is:");
			e.printStackTrace();
		}
		 			
    	
    }

    private void jButtonSaveNoeAsgActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveNoeAsgActionPerformed
        
      //String curDir=System.getProperty("user.dir")+File.separator;
      String curDir=Global.getOutputFilePath();
      String sourceName="";
      File sourceFile=new File (sourceName);

      JFileChooser chooser=new JFileChooser(curDir);
      chooser.setMultiSelectionEnabled(false);
      chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
      //chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES); 
      chooser.setSelectedFile(sourceFile);  // set default for output

      String[] html=new String[] {"tbl"};
      chooser.addChoosableFileFilter(new ExtFilter(html,
           "NOE assignments(*.tbl)"));
      int option=chooser.showSaveDialog(this);
      if (option==JFileChooser.APPROVE_OPTION)
      {
          sourceFile=chooser.getSelectedFile();
          try {sourceName=sourceFile.getCanonicalPath();}
          catch (IOException e) {};
          //jTextFieldAroNoesy.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
          Noe noe=new Noe();
          String fileName=chooser.getCurrentDirectory()+File.separator+sourceFile.getName();
          noe.printNoesToFileInXplor(Global.finalAssignments.getNoeAsgs(),fileName);
          
       }
       else {
                /*add cancelled message here*/
       }       
    }//GEN-LAST:event_jButtonSaveNoeAsgActionPerformed

    private void jButtonClearActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonClearActionPerformed
    	this.jTextFieldBBPdb.setText("");
    	this.jTextFieldBBCS.setText("");
    	this.jTextFieldAliNoesy.setText("");
    	this.jTextFieldAroNoesy.setText("");
    	this.jTextFieldN15Noesy.setText("");
    }//GEN-LAST:event_jButtonClearActionPerformed

    private void jMenuSaveSessionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuSaveSessionActionPerformed
    	String curDir=Global.getOutputFilePath();
    	//String curDir=System.getProperty("user.dir")+File.separator;
    	String sourceName="";
    	File sourceFile=new File (sourceName);

    	JFileChooser chooser=new JFileChooser(curDir);
    	chooser.setMultiSelectionEnabled(false);
    	chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
    	//chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES); 
    	chooser.setSelectedFile(sourceFile);  // set default for output

    	String[] html=new String[] {"input"};
    	chooser.addChoosableFileFilter(new ExtFilter(html,
           "Input session file (*.input)"));
    	int option=chooser.showSaveDialog(this);
    	if (option==JFileChooser.APPROVE_OPTION)
    	{
    		sourceFile=chooser.getSelectedFile();
    		try {sourceName=sourceFile.getCanonicalPath();}
    		catch (IOException e) {};
    		//jTextFieldAroNoesy.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
    		
    		//save to the file;
    		String strOutputSessionFile=chooser.getCurrentDirectory()+File.separator+sourceFile.getName();//+".input";
    		writeInputSessionToFile(strOutputSessionFile);
    	}
    	else {
    		/*add cancelled message here*/
    	}       
    }//GEN-LAST:event_jMenuSaveSessionActionPerformed

    private void jMenuSaveResonanceAsgActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuSaveResonanceAsgActionPerformed
        //String curDir=System.getProperty("user.dir")+File.separator;
        String curDir=Global.getOutputFilePath();
        String sourceName="";
        File sourceFile=new File (sourceName);

        JFileChooser chooser=new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        //chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES); 
        chooser.setSelectedFile(sourceFile);  // set default for output

        String[] html=new String[] {"prot"};
        chooser.addChoosableFileFilter(new ExtFilter(html,
             "Side-chain resonance assignments (*.prot)"));
        int option=chooser.showSaveDialog(this);
        if (option==JFileChooser.APPROVE_OPTION)
        {
            sourceFile=chooser.getSelectedFile();
            try {sourceName=sourceFile.getCanonicalPath();}
            catch (IOException e) {};          
            //jTextFieldAroNoesy.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
            H1CS h1cs =new H1CS();
            String fileName=chooser.getCurrentDirectory()+File.separator+sourceFile.getName();
            h1cs.PrintAllAssignmentToFileBMRB(Global.finalAssignments.getResonAsgs(), fileName);
            
         }
         else {
                  /*add cancelled message here*/
         }       
    }//GEN-LAST:event_jMenuSaveResonanceAsgActionPerformed

    private void jMenuSaveNoeAsgActionPerformed(java.awt.event.ActionEvent evt) {                                                        
        //String curDir=System.getProperty("user.dir")+File.separator;
        String curDir=Global.getOutputFilePath();
        String sourceName="";
        File sourceFile=new File (sourceName);

        JFileChooser chooser=new JFileChooser(curDir);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
        //chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES); 
        chooser.setSelectedFile(sourceFile);  // set default for output

        String[] html=new String[] {"tbl"};
        chooser.addChoosableFileFilter(new ExtFilter(html,
             "NOE assignments(*.tbl)"));
        int option=chooser.showSaveDialog(this);
        if (option==JFileChooser.APPROVE_OPTION)
        {
            sourceFile=chooser.getSelectedFile();
            try {sourceName=sourceFile.getCanonicalPath();}
            catch (IOException e) {};
            //jTextFieldAroNoesy.setText(chooser.getCurrentDirectory()+File.separator+sourceFile.getName());  // show on GUI
            Noe noe=new Noe();
            String fileName=chooser.getCurrentDirectory()+File.separator+sourceFile.getName();
            noe.printNoesToFileInXplor(Global.finalAssignments.getNoeAsgs(),fileName);
            
         }
         else {
                  /*add cancelled message here*/
         }       
    }                                               

    private void jMenuIQuitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuIQuitActionPerformed
    	 System.exit(0);
    	//this.jMenuIQuit.addActionListener(new ListenMenuQuit());
    }//GEN-LAST:event_jMenuIQuitActionPerformed

    private void jMenuRunNascaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuRunNascaActionPerformed
    	jTextAreaOutput.setText("");
    	//runNasca();
    	this.jButtonRunNasca.setEnabled(false);
    	//this.jButtonStopNasca.setEnabled(true);
    	
    	runNasca=new RunNascaForGUI(this.jTextAreaOutput,this.jButtonSCResonanceAsg, this.jButtonSaveNoeAsg,
    			this.jMenuSaveResonanceAsg,this.jMenuSaveNoeAsg,this.jButtonRunNasca,this.jButtonStopNasca);
    	runNasca.execute();
    }//GEN-LAST:event_jMenuRunNascaActionPerformed

    private void jMenuStopNascaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuStopNascaActionPerformed
    	 if(runNasca!=null&& !runNasca.isDone()){        	
         	runNasca.cancel(true);
         	this.jButtonRunNasca.setEnabled(true);
         	//runNasca=null;
         }
    }//GEN-LAST:event_jMenuStopNascaActionPerformed

    private void jMenuItemSystemParametersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSystemParametersActionPerformed
    	ParametersJFrame paraFrame=new ParametersJFrame();
    	paraFrame.setName("Parameter Setting");
    	paraFrame.setTitle("Parameter Setting");
    	paraFrame.setLocationRelativeTo(null); 
    	paraFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
    	paraFrame.setVisible(true);    	
    }//GEN-LAST:event_jMenuItemSystemParametersActionPerformed

    private void jMenuIManualActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuIManualActionPerformed
		String url="http://www.cs.duke.edu/donaldlab/nasca.php";
    	if (java.awt.Desktop.isDesktopSupported ())
		{
			java.awt.Desktop desktop = java.awt.Desktop.getDesktop ();
			if (desktop.isSupported (java.awt.Desktop.Action.BROWSE))
			{
				try
				{
					desktop.browse (new java.net.URI (url));
					return;
				}
				catch (java.io.IOException e)
				{
					e.printStackTrace ();
				}
				catch (java.net.URISyntaxException e)
				{
					e.printStackTrace ();
				}
			}
		}
		
		
		String osName = System.getProperty("os.name");
		try
		{
			if (osName.startsWith ("Windows"))
			{
				Runtime.getRuntime ().exec ("rundll32 url.dll,FileProtocolHandler " + url);
			}
			else if (osName.startsWith ("Mac OS"))
			{
				Class fileMgr = Class.forName ("com.apple.eio.FileManager");
				java.lang.reflect.Method openURL = fileMgr.getDeclaredMethod ("openURL", new Class[] {String.class});
				openURL.invoke (null, new Object[] {url});
			} 
			else
			{
				//check for $BROWSER
				java.util.Map<String, String> env = System.getenv ();
				if (env.get ("BROWSER") != null)
				{
					Runtime.getRuntime ().exec (env.get ("BROWSER") + " " + url);
					return;
				}
				
				//check for common browsers
				String[] browsers = { "firefox", "iceweasel", "chrome", "opera", "konqueror", "epiphany", "mozilla", "netscape" };
				String browser = null;
				for (int count = 0; count < browsers.length && browser == null; count++)
					if (Runtime.getRuntime ().exec (new String[] {"which", browsers[count]}).waitFor () == 0)
					{
						browser = browsers[count];
						break;
					}
					if (browser == null)
						throw new RuntimeException ("couldn't find any browser...");
					else
						Runtime.getRuntime ().exec (new String[] {browser, url});
			}
		}
		catch (Exception e)
		{
			javax.swing.JOptionPane.showMessageDialog (null, "couldn't find a webbrowser to use...\nPlease browser for yourself:\n" + url);
		}
	
    }//GEN-LAST:event_jMenuIManualActionPerformed

    private void jMenulAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenulAboutActionPerformed
       
    	AboutFrame aboutFrame=new AboutFrame();    	
    	aboutFrame.setLocationRelativeTo(null); 
    	aboutFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
    	aboutFrame.setVisible(true);
    }//GEN-LAST:event_jMenulAboutActionPerformed

       
    private void jTextFieldBBPdbPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_jTextFieldBBPdbPropertyChange
        this.jTextFieldBBPdb.setText(this.jTextFieldBBPdb.getText()); 
        Global.strBBPdbFile=this.jTextFieldBBPdb.getText();
    }//GEN-LAST:event_jTextFieldBBPdbPropertyChange

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
            	
                new NascaFrame().setVisible(true);
            }
        });
    }
    
    private RunNascaForGUI runNasca;;
	
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonAliNoesyOpen;
    private javax.swing.JButton jButtonAroNoesyOpen;
    private javax.swing.JButton jButtonBBCSOpen;
    private javax.swing.JButton jButtonBBPdbOpen;
    private javax.swing.JButton jButtonClear;
    private javax.swing.JButton jButtonN15NoesyOpen;
    private javax.swing.JButton jButtonReadSession;
    private javax.swing.JButton jButtonRunNasca;
    private javax.swing.JButton jButtonSCResonanceAsg;
    private javax.swing.JButton jButtonSaveNoeAsg;
    private javax.swing.JButton jButtonSaveSession;
    private javax.swing.JButton jButtonStopNasca;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JMenuBar jMenuBar1;
    private javax.swing.JMenu jMenuFile;
    private javax.swing.JMenu jMenuHelp;
    private javax.swing.JMenuItem jMenuIManual;
    private javax.swing.JMenuItem jMenuIQuit;
    private javax.swing.JMenuItem jMenuItemSystemParameters;
    private javax.swing.JMenu jMenuOptions;
    private javax.swing.JMenuItem jMenuReadSession;
    private javax.swing.JMenu jMenuRun;
    private javax.swing.JMenuItem jMenuRunNasca;
    private javax.swing.JMenuItem jMenuSaveNoeAsg;
    private javax.swing.JMenuItem jMenuSaveResonanceAsg;
    private javax.swing.JMenuItem jMenuSaveSession;
    private javax.swing.JMenuItem jMenuStopNasca;
    private javax.swing.JMenuItem jMenulAbout;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextAreaOutput;
    private javax.swing.JTextField jTextFieldAliNoesy;
    private javax.swing.JTextField jTextFieldAroNoesy;
    private javax.swing.JTextField jTextFieldBBCS;
    private javax.swing.JTextField jTextFieldBBPdb;
    private javax.swing.JTextField jTextFieldN15Noesy;
    // End of variables declaration//GEN-END:variables
}
