package rdcPanda;

///////////////////////////////////////////////////////////////////////////////////////////////
//	Peak.java
//
//	  Version:           0.1
//
//
//	  authors:
// 	  initials            name                      organization               email
//	 ---------   -----------------------        ------------------------    ------------------
//	  LW            Lincong Wang                  Dartmouth College       wlincong@cs.dartmouth.edu
//    JMZ		 Jianyang (Michael) Zeng	       Duke University			zengjy@cs.duke.edu
//
///////////////////////////////////////////////////////////////////////////////////////////////



/*
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
	USA
	
	Contact Info:
		Bruce Donald
		Duke University
		Department of Computer Science
		Levine Science Research Center (LSRC)
		Durham
		NC 27708-0129 
		USA
		brd@cs.duke.edu
	
	If you use or publish any results derived from the use of this program please cite:
	J. Zeng, J. Boyles, C. Tripathy, L. Wang, A. Yan, P. Zhou and B.R. Donald. 
	"High-Resolution Protein Structure Determination Starting with a Global Fold 
	Calculated from Exact Solutions to the RDC Equations." Submitted For Review.

	Copyright (C) 2009 Jianyang (Michael) Zeng, Lincong Wang and Bruce R. Donald		
	<signature of Bruce Donald>, June 2008 and January 2009
	Bruce Donald, Professor of Computer Science
 */

       
import java.io. *;
import java.util. *;



// TODO: Auto-generated Javadoc
/** * 
 *  
*   This class is modified from LW's original one, and some functions might be redundant 
*   with other classes. This class hasn't been completely cleaned.
*   Written by Lincong Wang (2001-2005) and Jianyang (Michael) Zeng (2005-2009).
*   
*   */
public class Peak{
    
    /** The nucleus name. */
    private String nucleus = null; //the content of nucleus can be different. 
    
    /** The chemical shift for assignment. */
    private double cs;             //For assignment, the formula for nucleu is like "V15-HA"
    
    /** The peak intensity. */
    private double intensity;
    
    /**whether the peak is assigned. */
    private boolean isAssg=true;

    /**
     * Instantiates a new peak.
     */
    public  Peak() {
	nucleus = null;
	cs = 0;
	intensity =0.0;
	isAssg=true;
    }
    
    /**
     * A constructor designed specifically for the Comparator class
     * used for the Sort and BinarySearch.
     * 
     * @param csV the cs v
     */
    public Peak(double csV) {
	nucleus = null;
	cs = csV;
	intensity = 0.0;
	isAssg=true;
    }
    
    /**
     * Instantiates a new peak.
     * 
     * @param type the type
     * @param no the no
     */
    public  Peak(String type, double no) {
	nucleus = type;
	cs  = no;
	intensity = 0.0;
	isAssg=true;
    }
    
    /**
     * Instantiates a new peak.
     * 
     * @param type the type
     * @param no the no
     * @param isAsg the is asg
     */
    public  Peak(String type, double no, boolean isAsg) {
    	nucleus = type;
    	cs  = no;
    	intensity = 0.0;
    	isAssg=isAsg;
        }
    
    /**
     * Instantiates a new peak.
     * 
     * @param type the type
     * @param no the no
     * @param inten the inten
     */
    public  Peak(String type, double no, double inten) {
	nucleus = type;
	cs  = no;
	intensity = inten;
	isAssg=true;
    }
    
    /**
     * Instantiates a new peak.
     * 
     * @param type the type
     * @param no the no
     * @param inten the inten
     * @param isAsg the is asg
     */
    public  Peak(String type, double no, double inten, boolean isAsg) {
    	nucleus = type;
    	cs  = no;
    	intensity = inten;
    	isAssg=isAsg;
        }
    
    //get the values	
    /**
     * Gets the cS.
     * 
     * @return the cS
     */
    public double getCS() {
	return cs;
    }
    
    /**
     * Gets the checks if is assg.
     * 
     * @return the checks if is assg
     */
    public boolean getIsAssg() {
    	return isAssg;
        }
    
    /**
     * Gets the nucleus.
     * 
     * @return the nucleus
     */
    public String getNucleus() {
	return nucleus;
    }
    //set the values	
    /**
     * Sets the cS.
     * 
     * @param R the new cS
     */
    public void setCS(double R){
	cs = R;
    }	
    
    /**
     * Sets the nucleus.
     * 
     * @param R the new nucleus
     */
    public void setNucleus(String R){
	nucleus = R;
    }	
    
    /**
     * The Class csComparator.
     */
    public static class csComparator implements Comparator<Object>{
        
        /* (non-Javadoc)
         * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
         */
        public int compare(Object o1, Object o2){
            Peak n1 = (Peak)o1;
            Peak n2 = (Peak)o2;
	    double d1 = n1.getCS();
	    double d2 = n2.getCS();
            if (d1 < d2)
                return -1;
            else if (d1 > d2)
                return 1;
            else return 0;
        }
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString(){
	String desc = nucleus+"  "+cs+"   "+intensity;
	return desc;
    }
    
    //by Zeng. 
    /**
     * Gets the heavy atom from proton.
     * 
     * @param resName the res name
     * @param protonName the proton name
     * 
     * @return the string
     */
    public String GetHeavyAtomFromProton(String resName,String protonName)
    {
    	String desc="";
    	String temp="";
    	if(!protonName.substring(0,1).equalsIgnoreCase("H"))
    	{
    		desc=" ";
    		return desc;
    	}
    	if (protonName.equalsIgnoreCase("H")||protonName.equalsIgnoreCase("HN"))
    	{
    		desc="N";
    		return desc;
    	}
    	if (resName.equalsIgnoreCase("ARG"))
    	{
    		if (protonName.length()>=3)
    		{
	    		if (protonName.substring(0,2).equalsIgnoreCase("HH"))
	    		{
	    			desc="N"+protonName.substring(1,3);
	    			return desc;
	    		}
	    		
    		}//if (protonName.length()>=2)
    		if (protonName.length()>=2)
    		{
	    		if (protonName.substring(0,2).equalsIgnoreCase("HE"))
	    		{
	    			desc="NE";   
	    			return desc;
	    		}
	    		if (protonName.substring(0,2).equalsIgnoreCase("HH"))
	    		{
	    			desc="NH";
	    			return desc;
	    		}
    		}
    		
    	}//if (resName.equalsIgnoreCase("ARG"))
    	if (resName.equalsIgnoreCase("GLU"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if (protonName.length()>=2)
    		{
	    		if (protonName.equalsIgnoreCase("HE2"))
	    		{
	    			desc="OE2";   
	    			return desc;
	    		}
	    		if (protonName.equalsIgnoreCase("HE1"))
	    		{
	    			desc="OE1";   
	    			return desc;
	    		}
    		}
    	}//if (resName.equalsIgnoreCase("ASP"))
    	if (resName.equalsIgnoreCase("GLU"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if (protonName.length()>=2)
    		{
	    		if (protonName.equalsIgnoreCase("HD2"))
	    		{
	    			desc="OD2";   
	    			return desc;
	    		}
	    		if (protonName.equalsIgnoreCase("HD1"))
	    		{
	    			desc="OD1";   
	    			return desc;
	    		}
    		}
    	}//if (resName.equalsIgnoreCase("ASP"))
    	
    	if (resName.equalsIgnoreCase("CYS"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if (protonName.length()>=2)
    		{  			
	    		if (protonName.substring(0,2).equalsIgnoreCase("HG"))
	    		{
	    			desc="SG";   
	    			return desc;
	    		}
    		}
    	}//if (resName.equalsIgnoreCase("CYS"))
    	if (resName.equalsIgnoreCase("SER"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if (protonName.length()>=2)
    		{  			
	    		if (protonName.substring(0,2).equalsIgnoreCase("HG"))
	    		{
	    			desc="OG";   
	    			return desc;
	    		}
    		}
    	}//if (resName.equalsIgnoreCase("SER"))
    	
    	if (resName.equalsIgnoreCase("THR"))
    	{
    		if(protonName.equalsIgnoreCase("HB"))
    		{
    			desc="CB";   
    			return desc;
    		}
    		if(protonName.length()>4)
    			protonName=protonName.substring(0,4);
    		if (protonName.length()>=3)
    		{  			
	    		if (protonName.substring(0,3).equalsIgnoreCase("HG2"))
	    		{
	    			desc="CG2";   
	    			return desc;
	    		}
    		}
    	}//if (resName.equalsIgnoreCase("THR"))
    	if (resName.equalsIgnoreCase("TRP"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if (protonName.equalsIgnoreCase("HE1"))
    		{
    			desc="NE1"; 
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HD1"))
    		{
    			desc="CD1";  
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HE3"))
    		{
    			desc="CE3";
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HZ2"))
    		{
    			desc="CZ2";
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HZ3"))
    		{
    			desc="CZ3";
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HH2"))
    		{
    			desc="CH2";
    			return desc;
    		}
    	}
    	if (resName.equalsIgnoreCase("TYR"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if (protonName.equalsIgnoreCase("HD1"))
    		{
    			desc="CD1";
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HD2"))
    		{
    			desc="CD2";
    			desc="CD1";//change here according to bmrb
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HD"))
    		{
    			desc="CD1";
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HE1"))
    		{
    			desc="CE1";   
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HE"))
    		{
    			desc="CE1";   
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HE2"))
    		{
    			desc="CE2"; 
    			desc="CE1";//change here according to bmrb
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HH"))
    		{
    			desc="OH"; 
    			return desc;
    		}
    		
    	}
    	if (resName.equalsIgnoreCase("GLN"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if(protonName.length()>=2)
    		if (protonName.substring(0,2).equalsIgnoreCase("HE") )
    		{
    			desc="NE2";  
    			return desc;
   			}    		
    	}   	
    	if (resName.equalsIgnoreCase("ASN"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if(protonName.length()>=2)
    		if (protonName.substring(0,2).equalsIgnoreCase("HD") )
    		{
    			desc="ND2";   
    			return desc;
    		}
    	}//if (resName.equalsIgnoreCase("ASN"))    	
    	if (resName.equalsIgnoreCase("HIS"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if (protonName.equalsIgnoreCase("HD1") )
    		{
    			desc="ND1";   
    			desc="CD2";//changed for bmrb...  
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HD2"))
    		{
    			desc="CD2";   
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HD"))
    		{
    			desc="CD2";   
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HE2"))
    		{
    			desc="NE2";   
    			desc="CE1";   //changed for bmrb
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HE1") )
    		{
    			desc="CE1";   
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HE") )
    		{
    			desc="CE1";   
    			return desc;
    		}
    		
    	}
    	
    	if (resName.equalsIgnoreCase("LYS"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if(protonName.length()>=2)
    		if (protonName.substring(0,2).equalsIgnoreCase("HZ"))
    		{
    			desc="NZ";   
    			return desc;
    		}
    	}
    	
    	if (resName.equalsIgnoreCase("MET"))
    	{
    		if(protonName.length()>=2)
    		if (protonName.substring(0,2).equalsIgnoreCase("HE"))
    		{
    			desc="CE";   
    			return desc;
    		}
    	}
    	if (resName.equalsIgnoreCase("ILE"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if (protonName.equalsIgnoreCase("HD1"))
    		{
    			desc="CD1";   
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HG2"))
    		{	
    			desc="CG2"; 
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HG1") )
    		{	
    			desc="CG1"; 
    			return desc;
    		}
    	}
    	
    	if (resName.equalsIgnoreCase("LEU"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if (protonName.equalsIgnoreCase("HD1"))
    		{
    			desc="CD1";
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HD2"))
    		{
    			desc="CD2"; 
    			return desc;
    		}
    		
    	}
    	
    	if (resName.equalsIgnoreCase("PHE"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if (protonName.equalsIgnoreCase("HD1"))
    		{
    			desc="CD1";
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HD2"))
    		{
    			desc="CD2";
    			desc="CD1";//changed for bmrb
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HD"))
    		{
    			desc="CD1";
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HE1"))
    		{
    			desc="CE1";
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HE2"))
    		{
    			desc="CE2"; 
    			desc="CE1";//changed for bmrb
    			return desc;
    		}    	
    		if (protonName.equalsIgnoreCase("HE"))
    		{
    			desc="CE1";
    			return desc;
    		}
    	}    
    	if (resName.equalsIgnoreCase("VAL"))
    	{
    		if(protonName.length()>3)
    			protonName=protonName.substring(0,3);
    		if (protonName.equalsIgnoreCase("HG2"))
    		{
    			desc="CG2";
    			return desc;
    		}
    		if (protonName.equalsIgnoreCase("HG1"))
    		{
    			desc="CG1"; 
    			return desc;
    		}
    		
    	}
    	
    	//for other regular, like CB, CD, CE,etc.
    	temp=protonName.substring(1,2);
    	desc="C"+temp;
    	return desc;
    }
    
    
    /**
     * Xplor noe statement.
     * 
     * @param no1 the no1
     * @param nucleus1 the nucleus1
     * @param no2 the no2
     * @param nucleus2 the nucleus2
     * @param dis the dis
     * 
     * @return the string
     */
    public String xplorNoeStatement(int no1, String nucleus1, int no2, String nucleus2, double dis){
	String str = "assign ((resid     "+String.valueOf(no1)+"  and name      "+nucleus1
	    +"))   ((resid     "+String.valueOf(no2)+" and name    "+nucleus2+"))      "+String.valueOf(dis); 
	return str;
    }

    /**
     * Noe limit.
     * 
     * @param dis the dis
     * 
     * @return the double[]
     */
    public double[]  noeLimit (double dis)
    {
    	double [] noeLimits = new double[3];
    	double lowerLimit = 1.80;
    	double middle   = 0.0;
    	double upLimit = 5.50;
    	double methylCorrection = 2.50;
    	double strongBound = 2.70;
    	double middleBound = 3.50;
    	double methylBound = 6.50;
    	double methylMin = 4.00;
    	if (dis <= lowerLimit)
    	{
    		upLimit =  methylCorrection + dis;
    		if (upLimit < methylMin)
    			upLimit = methylMin;
    	}
    	else if(dis >  lowerLimit && dis <= middleBound)
    		upLimit =  methylCorrection + dis;
    	else if(dis >   middleBound && dis <= upLimit)
    		upLimit =  methylCorrection + dis;
    	else if (dis > upLimit && dis <= methylBound)
    		upLimit = dis + 0.5 * lowerLimit;
    	else upLimit = methylBound + 1.00;
    	noeLimits[0] = lowerLimit;
    	noeLimits[1] = middle;
    	noeLimits[2] = upLimit;
    	return noeLimits;
    }
    
    
    /**
     * Xplor noe statement new.
     * 
     * @param no1 the no1
     * @param resid1 the resid1
     * @param nucleus1 the nucleus1
     * @param no2 the no2
     * @param resid the resid
     * @param nucleus2 the nucleus2
     * @param dis the dis
     * 
     * @return the string
     */
    public String xplorNoeStatementNew(int no1,String resid1,String nucleus1, int no2, String resid, 
    		String nucleus2, double dis)
    {
    	double lowerLimit = 1.80;
    	double middle   = 0.0;
    	double upLimit = 5.50;
    	double methylCorrection = 3.00;
    	double strongBound = 2.70;
    	double middleBound = 3.50;
    	double methylBound = 7.00;
    	double methylMin = 4.00;
    	double [] noeLimits = new double[3];
    	boolean isMethyl=false;
    	
    	/////////////////////////////////////////
    	if(resid1.equalsIgnoreCase("ALA") && nucleus1.equalsIgnoreCase("HB"))
    	{
    		nucleus1 = "HB#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid1.equalsIgnoreCase("ILE") && nucleus1.equalsIgnoreCase("HG2"))
    	{
    		nucleus1 = "HG2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid1.equalsIgnoreCase("ILE") && nucleus1.equalsIgnoreCase("HD1"))
    	{
    		nucleus1 = "HD1#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid1.equalsIgnoreCase("LEU") && nucleus1.equalsIgnoreCase("HD1"))
    	{
    		nucleus1 = "HD1#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid1.equalsIgnoreCase("LEU") && nucleus1.equalsIgnoreCase("HD2"))
    	{
    		nucleus1 = "HD2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid1.equalsIgnoreCase("VAL") && nucleus1.equalsIgnoreCase("HG1"))
    	{
    		nucleus1 = "HG1#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}else if(resid1.equalsIgnoreCase("VAL") && nucleus1.equalsIgnoreCase("HG2"))
    	{
    		nucleus1 = "HG2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}else if(resid1.equalsIgnoreCase("THR") && nucleus1.equalsIgnoreCase("HG2"))
    	{
    		nucleus1 = "HG2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}else
    	{ 		
    		//change back to old naming scheme for xplor
    		if (resid1.equalsIgnoreCase("ARG")||resid1.equalsIgnoreCase("PRO")) 
    		{
    			/*if(nucleus1.equalsIgnoreCase("HB2"))
    				nucleus1="HB1";
    			if(nucleus1.equalsIgnoreCase("HB3"))
    				nucleus1="HB2";
    			if(nucleus1.equalsIgnoreCase("HG2"))
    				nucleus1="HG1";
    			if(nucleus1.equalsIgnoreCase("HG3"))
    				nucleus1="HG2";
    			if(nucleus1.equalsIgnoreCase("HD2"))
    				nucleus1="HD1";
    			if(nucleus1.equalsIgnoreCase("HD3"))
    				nucleus1="HD2";*/
    		}
    		if (resid1.equalsIgnoreCase("ASP")||resid1.equalsIgnoreCase("CYS")||
	    		resid1.equalsIgnoreCase("HIS")||resid1.equalsIgnoreCase("SER")||
	    		resid1.equalsIgnoreCase("TRP")||resid1.equalsIgnoreCase("ASN")||
	    		resid1.equalsIgnoreCase("LEU")||resid1.equalsIgnoreCase("VAL")||
	    		resid1.equalsIgnoreCase("TYR")||resid1.equalsIgnoreCase("PHE")) 
    		{
    			/*if(nucleus1.equalsIgnoreCase("HB2"))
    				nucleus1="HB1";
    			if(nucleus1.equalsIgnoreCase("HB3"))
    				nucleus1="HB2";*/
    		}
    		if (resid1.equalsIgnoreCase("GLU")||resid1.equalsIgnoreCase("MET")||resid1.equalsIgnoreCase("GLN")) 
    		{
    			/*if(nucleus1.equalsIgnoreCase("HB2"))
    				nucleus1="HB1";
    			if(nucleus1.equalsIgnoreCase("HB3"))
    				nucleus1="HB2";
    			if(nucleus1.equalsIgnoreCase("HG2"))
    				nucleus1="HG1";
    			if(nucleus1.equalsIgnoreCase("HG3"))
    				nucleus1="HG2";	 */   	
    		}
    		if (resid1.equalsIgnoreCase("GLY")) 
    		{
    			/*if(nucleus1.equalsIgnoreCase("HA2"))
    				nucleus1="HA1";
    			if(nucleus1.equalsIgnoreCase("HA3"))
    				nucleus1="HA2";  */ 	
    		}
    		if (resid1.equalsIgnoreCase("ILE")) 
    		{
    			/*if(nucleus1.equalsIgnoreCase("HG12"))
    				nucleus1="HG11";
    			if(nucleus1.equalsIgnoreCase("HG13"))
    				nucleus1="HG12";*/   	
    		}
    		if (resid1.equalsIgnoreCase("LYS")||resid1.equalsIgnoreCase("PRO")) 
    		{
    			/*if(nucleus1.equalsIgnoreCase("HB2"))
    				nucleus1="HB1";
    			if(nucleus1.equalsIgnoreCase("HB3"))
    				nucleus1="HB2";
    			if(nucleus1.equalsIgnoreCase("HG2"))
    				nucleus1="HG1";
    			if(nucleus1.equalsIgnoreCase("HG3"))
    				nucleus1="HG2";
    			if(nucleus1.equalsIgnoreCase("HD2"))
    				nucleus1="HD1";
    			if(nucleus1.equalsIgnoreCase("HD3"))
    				nucleus1="HD2";
    			if(nucleus1.equalsIgnoreCase("HE2"))
    				nucleus1="HE1";
    			if(nucleus1.equalsIgnoreCase("HE3"))
    				nucleus1="HE2";    	*/
    		}	        
    		if (nucleus1.equalsIgnoreCase("H"))
    			nucleus1="HN";    	
	    
    		if (dis < strongBound)
    			upLimit =  strongBound;
    		else 
    			upLimit = dis;
    		noeLimits[0] = lowerLimit;
    		noeLimits[1] = middle;
    		noeLimits[2] = upLimit;
    	}
    	
    	/////////////////////because we consider noe from side-chains to side-chains
    	if(resid.equalsIgnoreCase("ALA") && nucleus2.equalsIgnoreCase("HB"))
    	{
    		nucleus2 = "HB#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HG2"))
    	{
    		nucleus2 = "HG2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HD1"))
    	{
    		nucleus2 = "HD1#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD1"))
    	{
    		nucleus2 = "HD1#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD2"))
    	{
    		nucleus2 = "HD2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG1"))
    	{
    		nucleus2 = "HG1#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}else if(resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG2"))
    	{
    		nucleus2 = "HG2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}else if(resid.equalsIgnoreCase("THR") && nucleus2.equalsIgnoreCase("HG2"))
    	{
    		nucleus2 = "HG2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}else
    	{
		
    		//change back to old naming scheme for xplor
    		if (resid.equalsIgnoreCase("ARG")||resid.equalsIgnoreCase("PRO")) 
    		{
    			/*if(nucleus2.equalsIgnoreCase("HB2"))
    				nucleus2="HB1";
    			if(nucleus2.equalsIgnoreCase("HB3"))
    				nucleus2="HB2";
    			if(nucleus2.equalsIgnoreCase("HG2"))
    				nucleus2="HG1";
    			if(nucleus2.equalsIgnoreCase("HG3"))
    				nucleus2="HG2";
    			if(nucleus2.equalsIgnoreCase("HD2"))
    				nucleus2="HD1";
    			if(nucleus2.equalsIgnoreCase("HD3"))
    				nucleus2="HD2";*/
    		}
    		if (resid.equalsIgnoreCase("ASP")||resid.equalsIgnoreCase("CYS")||
	    		resid.equalsIgnoreCase("HIS")||resid.equalsIgnoreCase("SER")||
	    		resid.equalsIgnoreCase("TRP")||resid.equalsIgnoreCase("ASN")||
	    		resid.equalsIgnoreCase("LEU")||resid.equalsIgnoreCase("VAL")||
	    		resid.equalsIgnoreCase("TYR")||resid.equalsIgnoreCase("PHE")) 
    		{
    			/*if(nucleus2.equalsIgnoreCase("HB2"))
    				nucleus2="HB1";
    			if(nucleus2.equalsIgnoreCase("HB3"))
    				nucleus2="HB2";*/
    		}
    		if (resid.equalsIgnoreCase("GLU")||resid.equalsIgnoreCase("MET")||resid.equalsIgnoreCase("GLN")) 
    		{
    			/*if(nucleus2.equalsIgnoreCase("HB2"))
    				nucleus2="HB1";
    			if(nucleus2.equalsIgnoreCase("HB3"))
    				nucleus2="HB2";
    			if(nucleus2.equalsIgnoreCase("HG2"))
    				nucleus2="HG1";
    			if(nucleus2.equalsIgnoreCase("HG3"))
    				nucleus2="HG2";	   */ 	
    		}
    		if (resid.equalsIgnoreCase("GLY")) 
    		{
    			/*if(nucleus2.equalsIgnoreCase("HA2"))
    				nucleus2="HA1";
    			if(nucleus2.equalsIgnoreCase("HA3"))
    				nucleus2="HA2";  */ 	
    		}
    		if (resid.equalsIgnoreCase("ILE")) 
    		{
    			/*if(nucleus2.equalsIgnoreCase("HG12"))
    				nucleus2="HG11";
    			if(nucleus2.equalsIgnoreCase("HG13"))
    				nucleus2="HG12"; */  	
    		}
    		if (resid.equalsIgnoreCase("LYS")||resid.equalsIgnoreCase("PRO")) 
    		{
    			/*if(nucleus2.equalsIgnoreCase("HB2"))
    				nucleus2="HB1";
    			if(nucleus2.equalsIgnoreCase("HB3"))
    				nucleus2="HB2";
    			if(nucleus2.equalsIgnoreCase("HG2"))
    				nucleus2="HG1";
    			if(nucleus2.equalsIgnoreCase("HG3"))
    				nucleus2="HG2";
    			if(nucleus2.equalsIgnoreCase("HD2"))
    				nucleus2="HD1";
    			if(nucleus2.equalsIgnoreCase("HD3"))
    				nucleus2="HD2";
    			if(nucleus2.equalsIgnoreCase("HE2"))
    				nucleus2="HE1";
    			if(nucleus2.equalsIgnoreCase("HE3"))
    				nucleus2="HE2";   */ 	
    		}	        
    		if (nucleus2.equalsIgnoreCase("H"))
    			nucleus2="HN";    	
	    
    		if (dis < strongBound)
    			upLimit =  strongBound;
    		else 
    			upLimit = dis;
    		if (isMethyl==false)
    		{
    			noeLimits[0] = lowerLimit;
    			noeLimits[1] = middle;
    			noeLimits[2] = upLimit;
    		}
    	}
    	
    	//////////////////////////////////////////////////
    	lowerLimit = noeLimits[0];
    	middle = noeLimits[1];
    	upLimit = noeLimits[2];//+ noeLimits[2]*0.3;//we scale the upper bound by 30%    	    	
    
    	//String str = "assign ( resid     "+String.valueOf(no1)+"  and name       "+nucleus1
    	//	+" )   ( resid     "+String.valueOf(no2)+" and name     "+nucleus2+" )      "
    	//	+String.valueOf(upLimit) +"   "+String.valueOf(upLimit-lowerLimit)+"  "+String.valueOf(0.0); 
    	
    	String strDis1= String.format("%.3f", dis);
    	String strDis2= String.format("%.3f", dis-1.80);
    	//String strDis3= String.format("%.3f", dis);
    	
    	String str = "assign ( resid     "+String.valueOf(no1)+"  and name       "+nucleus1
		+" )   ( resid     "+String.valueOf(no2)+" and name     "+nucleus2+" )      "
		+strDis1 +"   "+strDis2+"  "+String.valueOf(0.0); 
	
    	//String str = "assign ( resid     "+String.valueOf(no1)+"  and name       "+nucleus1
		//+" )   ( resid     "+String.valueOf(no2)+" and name     "+nucleus2+" )      "
		//+String.valueOf(dis) +"   "+String.valueOf(dis-1.80)+"  "+String.valueOf(0.0); 
	
    	
    	//String str = "assign (resid     "+String.valueOf(no1)+"  and name       "+nucleus1
		//	+")   (resid     "+String.valueOf(no2)+" and name     "+nucleus2+")      "
		//	+String.valueOf(lowerLimit) +"   "+String.valueOf(middle)+"  "+String.valueOf(upLimit); 
	
	
    	return str;
    }
    
    
    /**
     * Xplor noe statement.
     * 
     * @param no1 the no1
     * @param resid1 the resid1
     * @param nucleus1 the nucleus1
     * @param no2 the no2
     * @param resid the resid
     * @param nucleus2 the nucleus2
     * @param dis the dis
     * @param disUp the dis up
     * 
     * @return the string
     */
    public String xplorNoeStatement(int no1,String resid1,String nucleus1, int no2, String resid, 
    		String nucleus2, double dis, double[] disUp)
    {
    	double lowerLimit = 1.80;
    	double middle   = 0.0;
    	double upLimit = 5.50;
    	double methylCorrection = 3.00;
    	double strongBound = 2.70;
    	double middleBound = 3.50;
    	double methylBound = 7.00;
    	double methylMin = 4.00;
    	double [] noeLimits = new double[3];
    	boolean isMethyl=false;
    	
    	/////////////////////////////////////////
    	if(resid1.equalsIgnoreCase("ALA") && nucleus1.equalsIgnoreCase("HB"))
    	{
    		nucleus1 = "HB#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid1.equalsIgnoreCase("ILE") && nucleus1.equalsIgnoreCase("HG2"))
    	{
    		nucleus1 = "HG2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid1.equalsIgnoreCase("ILE") && nucleus1.equalsIgnoreCase("HD1"))
    	{
    		nucleus1 = "HD1#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid1.equalsIgnoreCase("LEU") && nucleus1.equalsIgnoreCase("HD1"))
    	{
    		nucleus1 = "HD1#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid1.equalsIgnoreCase("LEU") && nucleus1.equalsIgnoreCase("HD2"))
    	{
    		nucleus1 = "HD2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}
    	else if(resid1.equalsIgnoreCase("VAL") && nucleus1.equalsIgnoreCase("HG1"))
    	{
    		nucleus1 = "HG1#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}else if(resid1.equalsIgnoreCase("VAL") && nucleus1.equalsIgnoreCase("HG2"))
    	{
    		nucleus1 = "HG2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}else if(resid1.equalsIgnoreCase("THR") && nucleus1.equalsIgnoreCase("HG2"))
    	{
    		nucleus1 = "HG2#";
    		noeLimits = noeLimit (dis);
    		isMethyl=true;
    	}else
    	{  /*
    		if (nucleus1.equalsIgnoreCase("HA3"))
    			nucleus1= "HA1";
    		else if (nucleus1.equalsIgnoreCase("HB3"))
    			nucleus1= "HB1";
    		else if (nucleus1.equalsIgnoreCase("HG3"))
    			nucleus1= "HG1";
    		else if (nucleus1.equalsIgnoreCase("HD3"))
    			nucleus1= "HD1";
    		else if (nucleus1.equalsIgnoreCase("HE3"))
    			nucleus1= "HE1";
    		else if (nucleus1.equalsIgnoreCase("HD21"))
    			nucleus1= "HD22";
    		else if (nucleus1.equalsIgnoreCase("HD22"))
    			nucleus1= "HD21";
    		else if (nucleus1.equalsIgnoreCase("HE21"))
    			nucleus1= "HE22";
    		else if (nucleus1.equalsIgnoreCase("HE22"))
    			nucleus1= "HE21";*/
		
    		//change back to old naming scheme for xplor
    		if (resid1.equalsIgnoreCase("ARG")||resid1.equalsIgnoreCase("PRO")) 
    		{
    			if(nucleus1.equalsIgnoreCase("HB2"))
    				nucleus1="HB1";
    			if(nucleus1.equalsIgnoreCase("HB3"))
    				nucleus1="HB2";
    			if(nucleus1.equalsIgnoreCase("HG2"))
    				nucleus1="HG1";
    			if(nucleus1.equalsIgnoreCase("HG3"))
    				nucleus1="HG2";
    			if(nucleus1.equalsIgnoreCase("HD2"))
    				nucleus1="HD1";
    			if(nucleus1.equalsIgnoreCase("HD3"))
    				nucleus1="HD2";
    		}
    		if (resid1.equalsIgnoreCase("ASP")||resid1.equalsIgnoreCase("CYS")||
	    		resid1.equalsIgnoreCase("HIS")||resid1.equalsIgnoreCase("SER")||
	    		resid1.equalsIgnoreCase("TRP")||resid1.equalsIgnoreCase("ASN")||
	    		resid1.equalsIgnoreCase("LEU")||resid1.equalsIgnoreCase("VAL")||
	    		resid1.equalsIgnoreCase("TYR")||resid1.equalsIgnoreCase("PHE")) 
    		{
    			if(nucleus1.equalsIgnoreCase("HB2"))
    				nucleus1="HB1";
    			if(nucleus1.equalsIgnoreCase("HB3"))
    				nucleus1="HB2";
    		}
    		if (resid1.equalsIgnoreCase("GLU")||resid1.equalsIgnoreCase("MET")||resid1.equalsIgnoreCase("GLN")) 
    		{
    			if(nucleus1.equalsIgnoreCase("HB2"))
    				nucleus1="HB1";
    			if(nucleus1.equalsIgnoreCase("HB3"))
    				nucleus1="HB2";
    			if(nucleus1.equalsIgnoreCase("HG2"))
    				nucleus1="HG1";
    			if(nucleus1.equalsIgnoreCase("HG3"))
    				nucleus1="HG2";	    	
    		}
    		if (resid1.equalsIgnoreCase("GLY")) 
    		{
    			if(nucleus1.equalsIgnoreCase("HA2"))
    				nucleus1="HA1";
    			if(nucleus1.equalsIgnoreCase("HA3"))
    				nucleus1="HA2";   	
    		}
    		if (resid1.equalsIgnoreCase("ILE")) 
    		{
    			if(nucleus1.equalsIgnoreCase("HG12"))
    				nucleus1="HG11";
    			if(nucleus1.equalsIgnoreCase("HG13"))
    				nucleus1="HG12";   	
    		}
    		if (resid1.equalsIgnoreCase("LYS")||resid1.equalsIgnoreCase("PRO")) 
    		{
    			if(nucleus1.equalsIgnoreCase("HB2"))
    				nucleus1="HB1";
    			if(nucleus1.equalsIgnoreCase("HB3"))
    				nucleus1="HB2";
    			if(nucleus1.equalsIgnoreCase("HG2"))
    				nucleus1="HG1";
    			if(nucleus1.equalsIgnoreCase("HG3"))
    				nucleus1="HG2";
    			if(nucleus1.equalsIgnoreCase("HD2"))
    				nucleus1="HD1";
    			if(nucleus1.equalsIgnoreCase("HD3"))
    				nucleus1="HD2";
    			if(nucleus1.equalsIgnoreCase("HE2"))
    				nucleus1="HE1";
    			if(nucleus1.equalsIgnoreCase("HE3"))
    				nucleus1="HE2";    	
    		}	        
    		if (nucleus1.equalsIgnoreCase("H"))
    			nucleus1="HN";    	
	    
    		if (dis < strongBound)
    			upLimit =  strongBound;
    		else 
    			upLimit = dis;
    		noeLimits[0] = lowerLimit;
    		noeLimits[1] = middle;
    		noeLimits[2] = upLimit;
    	}
    	
    	/////////////////////because we consider noe from side-chains to side-chains
    	if(resid.equalsIgnoreCase("ALA") && nucleus2.equalsIgnoreCase("HB"))
    	{
    		nucleus2 = "HB#";
    		noeLimits = noeLimit (dis);
    	}
    	else if(resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HG2"))
    	{
    		nucleus2 = "HG2#";
    		noeLimits = noeLimit (dis);
    	}
    	else if(resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HD1"))
    	{
    		nucleus2 = "HD1#";
    		noeLimits = noeLimit (dis);
    	}
    	else if(resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD1"))
    	{
    		nucleus2 = "HD1#";
    		noeLimits = noeLimit (dis);
    	}
    	else if(resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD2"))
    	{
    		nucleus2 = "HD2#";
    		noeLimits = noeLimit (dis);
    	}
    	else if(resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG1"))
    	{
    		nucleus2 = "HG1#";
    		noeLimits = noeLimit (dis);
    	}else if(resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG2"))
    	{
    		nucleus2 = "HG2#";
    		noeLimits = noeLimit (dis);
    	}else if(resid.equalsIgnoreCase("THR") && nucleus2.equalsIgnoreCase("HG2"))
    	{
    		nucleus2 = "HG2#";
    		noeLimits = noeLimit (dis);
    	}else
    	{/*
    		if (nucleus2.equalsIgnoreCase("HA3"))
    			nucleus2= "HA1";
    		else if (nucleus2.equalsIgnoreCase("HB3"))
    			nucleus2= "HB1";
    		else if (nucleus2.equalsIgnoreCase("HG3"))
    			nucleus2= "HG1";
    		else if (nucleus2.equalsIgnoreCase("HD3"))
    			nucleus2= "HD1";
    		else if (nucleus2.equalsIgnoreCase("HE3"))
    			nucleus2= "HE1";
    		else if (nucleus2.equalsIgnoreCase("HD21"))
    			nucleus2= "HD22";
    		else if (nucleus2.equalsIgnoreCase("HD22"))
    			nucleus2= "HD21";
    		else if (nucleus2.equalsIgnoreCase("HE21"))
    			nucleus2= "HE22";
    		else if (nucleus2.equalsIgnoreCase("HE22"))
    			nucleus2= "HE21";*/
		
    		//change back to old naming scheme for xplor
    		if (resid.equalsIgnoreCase("ARG")||resid.equalsIgnoreCase("PRO")) 
    		{
    			if(nucleus2.equalsIgnoreCase("HB2"))
    				nucleus2="HB1";
    			if(nucleus2.equalsIgnoreCase("HB3"))
    				nucleus2="HB2";
    			if(nucleus2.equalsIgnoreCase("HG2"))
    				nucleus2="HG1";
    			if(nucleus2.equalsIgnoreCase("HG3"))
    				nucleus2="HG2";
    			if(nucleus2.equalsIgnoreCase("HD2"))
    				nucleus2="HD1";
    			if(nucleus2.equalsIgnoreCase("HD3"))
    				nucleus2="HD2";
    		}
    		if (resid.equalsIgnoreCase("ASP")||resid.equalsIgnoreCase("CYS")||
	    		resid.equalsIgnoreCase("HIS")||resid.equalsIgnoreCase("SER")||
	    		resid.equalsIgnoreCase("TRP")||resid.equalsIgnoreCase("ASN")||
	    		resid.equalsIgnoreCase("LEU")||resid.equalsIgnoreCase("VAL")||
	    		resid.equalsIgnoreCase("TYR")||resid.equalsIgnoreCase("PHE")) 
    		{
    			if(nucleus2.equalsIgnoreCase("HB2"))
    				nucleus2="HB1";
    			if(nucleus2.equalsIgnoreCase("HB3"))
    				nucleus2="HB2";
    		}
    		if (resid.equalsIgnoreCase("GLU")||resid.equalsIgnoreCase("MET")||resid.equalsIgnoreCase("GLN")) 
    		{
    			if(nucleus2.equalsIgnoreCase("HB2"))
    				nucleus2="HB1";
    			if(nucleus2.equalsIgnoreCase("HB3"))
    				nucleus2="HB2";
    			if(nucleus2.equalsIgnoreCase("HG2"))
    				nucleus2="HG1";
    			if(nucleus2.equalsIgnoreCase("HG3"))
    				nucleus2="HG2";	    	
    		}
    		if (resid.equalsIgnoreCase("GLY")) 
    		{
    			if(nucleus2.equalsIgnoreCase("HA2"))
    				nucleus2="HA1";
    			if(nucleus2.equalsIgnoreCase("HA3"))
    				nucleus2="HA2";   	
    		}
    		if (resid.equalsIgnoreCase("ILE")) 
    		{
    			if(nucleus2.equalsIgnoreCase("HG12"))
    				nucleus2="HG11";
    			if(nucleus2.equalsIgnoreCase("HG13"))
    				nucleus2="HG12";   	
    		}
    		if (resid.equalsIgnoreCase("LYS")||resid.equalsIgnoreCase("PRO")) 
    		{
    			if(nucleus2.equalsIgnoreCase("HB2"))
    				nucleus2="HB1";
    			if(nucleus2.equalsIgnoreCase("HB3"))
    				nucleus2="HB2";
    			if(nucleus2.equalsIgnoreCase("HG2"))
    				nucleus2="HG1";
    			if(nucleus2.equalsIgnoreCase("HG3"))
    				nucleus2="HG2";
    			if(nucleus2.equalsIgnoreCase("HD2"))
    				nucleus2="HD1";
    			if(nucleus2.equalsIgnoreCase("HD3"))
    				nucleus2="HD2";
    			if(nucleus2.equalsIgnoreCase("HE2"))
    				nucleus2="HE1";
    			if(nucleus2.equalsIgnoreCase("HE3"))
    				nucleus2="HE2";    	
    		}	        
    		if (nucleus2.equalsIgnoreCase("H"))
    			nucleus2="HN";    	
	    
    		if (dis < strongBound)
    			upLimit =  strongBound;
    		else 
    			upLimit = dis;
    		if (isMethyl==false)
    		{
    			noeLimits[0] = lowerLimit;
    			noeLimits[1] = middle;
    			noeLimits[2] = upLimit;
    		}
    	}
    	
    	//////////////////////////////////////////////////
    	lowerLimit = noeLimits[0];
    	middle = noeLimits[1];
    	upLimit = noeLimits[2];//+ noeLimits[2]*0.3;//we scale the upper bound by 30%
    	String str = "assign (resid     "+String.valueOf(no1)+"  and name       "+nucleus1
    		+")   (resid     "+String.valueOf(no2)+" and name     "+nucleus2+")      "
    		+String.valueOf(lowerLimit) +"   "+String.valueOf(middle)+"  "+String.valueOf(upLimit); 
    	disUp[0]=upLimit;
	
    	return str;
    }

 /////////////////////////////////////

    /**
  * Xplor noe statement_old.
  * 
  * @param no1 the no1
  * @param nucleus1 the nucleus1
  * @param no2 the no2
  * @param resid the resid
  * @param nucleus2 the nucleus2
  * @param dis the dis
  * @param disUp the dis up
  * 
  * @return the string
  */
 public String xplorNoeStatement_old(int no1, String nucleus1, int no2, String resid, String nucleus2, double dis, double[] disUp){
    	double lowerLimit = 1.80;
    	double middle   = 0.0;
    	double upLimit = 5.50;
    	double methylCorrection = 3.00;
    	double strongBound = 2.70;
    	double middleBound = 3.50;
    	double methylBound = 7.00;
    	double methylMin = 4.00;
    	double [] noeLimits = new double[3];
    	if(resid.equalsIgnoreCase("ALA") && nucleus2.equals("HB")){
    	    nucleus2 = "HB#";
    	    noeLimits = noeLimit (dis);
    	}else if(resid.equalsIgnoreCase("ILE") && nucleus2.equals("HG2")){
    	    nucleus2 = "HG2#";
    	    noeLimits = noeLimit (dis);
    	}else if(resid.equalsIgnoreCase("ILE") && nucleus2.equals("HD1")){
    	    nucleus2 = "HD1#";
    	    noeLimits = noeLimit (dis);
    	}else if(resid.equalsIgnoreCase("LEU") && nucleus2.equals("HD1")){
    	    nucleus2 = "HD1#";
    	    noeLimits = noeLimit (dis);
    	}else if(resid.equalsIgnoreCase("LEU") && nucleus2.equals("HD2")){
    	    nucleus2 = "HD2#";
    	    noeLimits = noeLimit (dis);
    	}else if(resid.equalsIgnoreCase("VAL") && nucleus2.equals("HG1")){
    	    nucleus2 = "HG1#";
    	    noeLimits = noeLimit (dis);
    	}else if(resid.equalsIgnoreCase("VAL") && nucleus2.equals("HG2")){
    	    nucleus2 = "HG2#";
    	    noeLimits = noeLimit (dis);
    	}else if(resid.equalsIgnoreCase("THR") && nucleus2.equals("HG2")){
    	    nucleus2 = "HG2#";
    	    noeLimits = noeLimit (dis);
    	}else{
    	    if (nucleus2.equals("HA3"))
    		nucleus2= "HA1";
    	    else if (nucleus2.equals("HB3"))
    		nucleus2= "HB1";
    	    else if (nucleus2.equals("HG3"))
    		nucleus2= "HG1";
    	    else if (nucleus2.equals("HD3"))
    		nucleus2= "HD1";
    	    else if (nucleus2.equals("HE3"))
    		nucleus2= "HE1";
    	    else if (nucleus2.equals("HD21"))
    		nucleus2= "HD22";
    	    else if (nucleus2.equals("HD22"))
    		nucleus2= "HD21";
    	    else if (nucleus2.equals("HE21"))
    		nucleus2= "HE22";
    	    else if (nucleus2.equals("HE22"))
    		nucleus2= "HE21";
    		
    	    if (dis < strongBound)
    		upLimit =  strongBound;
    	    else 
    		upLimit = dis;
    	    noeLimits[0] = lowerLimit;
    	    noeLimits[1] = middle;
    	    noeLimits[2] = upLimit;
    	}
    	lowerLimit = noeLimits[0];
    	middle = noeLimits[1];
    	upLimit = noeLimits[2];
    	String str = "assign (resid     "+String.valueOf(no1)+"  and name       "+nucleus1
    	    +")   (resid     "+String.valueOf(no2)+" and name     "+nucleus2+")      "
    	    +String.valueOf(lowerLimit) +"   "+String.valueOf(middle)+"  "+String.valueOf(upLimit); 
    	disUp[0]=upLimit;
    	
    	return str;
        }


    /**
     * Length.
     * 
     * @param v1 the v1
     * 
     * @return the double
     */
    public double length(double[] v1){
	double v1Len = Math.sqrt(v1[0]*v1[0] + v1[1]*v1[1] + v1[2]*v1[2]);
	return v1Len;
    }
    
    /**
     * Compute the internuclear vector between two atoms.
     * 
     * @param n1 the coordinate for atom 1
     * @param n2 the coordinate for atom 2
     * 
     * @return a vector from n1->n2
     */
    public double[] internuclearVec(double[] n1, double[] n2){
        return new double[]{n2[0]-n1[0], n2[1]-n1[1], n2[2]-n1[2]};
    }
    
    /**
     * A method to extract all the protons and convert the Assign
     * object to Peak object
     * Please note that the returned Peak has special
     * identification for the nucleus element.
     * 
     * @param asgVec the asg vec
     * 
     * @return the vector
     */
    public Vector<Peak> allProtonSorted_old(Vector<Assign> asgVec){
	Assign assign = new Assign();
	Map aMap = new TreeMap();
	int no = 0;
	String aaType ="";
	double csValue = 0.0;
	Vector pkVec = new Vector();
	String ss = "";
	String nucleus = "";
	for (int j=0; j<asgVec.size(); j++){
	    assign =  (Assign)asgVec.elementAt(j);
	    no = assign.getResidueNo();
	    aaType = assign.getResidueType();
	    aMap = assign.getMap();
	    for (Iterator i = aMap.entrySet().iterator(); i.hasNext(); ){
		Map.Entry e = (Map.Entry) i.next();
		csValue =  ((Double)e.getValue()).doubleValue();
		nucleus =  (String)e.getKey();
		//Here we also the amide proton named by "H", which is
		//the amide proton CS  downloaded from BMRB and have errors. 
		if (! nucleus.equalsIgnoreCase("CA") && ! nucleus.equalsIgnoreCase("CB") &&
		    ! nucleus.equalsIgnoreCase("N") && ! nucleus.equalsIgnoreCase("H") && 
		    ! nucleus.equalsIgnoreCase("ND") && ! nucleus.equalsIgnoreCase("NE") ){
		    ss = aaType+no+"-"+nucleus;
		    pkVec.add(new Peak(ss, csValue) );
		}
	    }
	}
	return pkVec;
    }
    
    /**
     * A method to extract all the protons and convert the Assign
     * object to Peak object
     * Please note that the returned Peak has special
     * identification for the nucleus element.
     * 
     * @param asgVec the asg vec
     * 
     * @return the vector
     */
    public Vector<Peak> allProtonSorted(Vector<H1CS> asgVec)
    {
    	H1CS assign = new H1CS();
    	Map aMap = new TreeMap();
    	int no = 0;
    	String aaType ="";
    	double csValue = 0.0;
    	Vector pkVec = new Vector();
    	String ss = "";
    	String nucleus = "";
    	for (int j=0; j<asgVec.size(); j++)
    	{
    		assign =  (H1CS)asgVec.elementAt(j);
    		no = assign.getResidueNo();
    		aaType = assign.getResidueType();
    		nucleus=assign.getAtomName();
    		csValue=assign.getH1CS();
    		if (nucleus.substring(0,1).equalsIgnoreCase("H")||nucleus.substring(0,1).equalsIgnoreCase("Q"))
    		{
    			ss = aaType+no+"-"+nucleus;
    		    pkVec.add(new Peak(ss, csValue) );    			
    		}
    		
    	}
    	return pkVec;
    }
    
    /**
     * ringResonaceAsg: search all the protons with in the range [CS-Err, CS + Err]
     * and assign the H resonance.
     * 
     * @param csValue the middle value of cs value
     * @param hErr error range for the csValue
     * 
     * @return a vector of Peak objects
     */
    public Vector ringResonanceAsg(double csValue,  double hErr){
	Vector pkVec = new Vector();
	String ss="";
	
	//Phe:
	/*
	if ( (csValue > Const.PheCSHD1Min-hErr) && (csValue < Const.PheCSHD1Max+hErr) )
	{	
		ss = "PHE"+4+"-"+"HD1";
        pkVec.add(new Peak(ss, csValue,false) );
        
        ss = "PHE"+45+"-"+"HD1";
        pkVec.add(new Peak(ss, csValue,false) );
	}
	
	if ( (csValue > Const.PheCSHD2Min-hErr) && (csValue < Const.PheCSHD2Max+hErr) )
	{	
		ss = "PHE"+4+"-"+"HD2";
        pkVec.add(new Peak(ss, csValue,false) );
        
        ss = "PHE"+45+"-"+"HD2";
        pkVec.add(new Peak(ss, csValue,false) );
	}
	*/
	if ( (csValue > Const.PheCSHE1Min-hErr) && (csValue < Const.PheCSHE1Max+hErr) )
	{	
		ss = "PHE"+4+"-"+"HE1";
        pkVec.add(new Peak(ss, csValue,false) );
        
        ss = "PHE"+45+"-"+"HE1";
        pkVec.add(new Peak(ss, csValue,false) );
	}
	
	if ( (csValue > Const.PheCSHE2Min-hErr) && (csValue < Const.PheCSHE2Max+hErr) )
	{	
		ss = "PHE"+4+"-"+"HE2";
        pkVec.add(new Peak(ss, csValue,false) );
        
        ss = "PHE"+45+"-"+"HE2";
        pkVec.add(new Peak(ss, csValue,false) );
	}
	
	if ( (csValue > Const.PheCSHZMin-hErr) && (csValue < Const.PheCSHZMax+hErr) )
	{	
		ss = "PHE"+4+"-"+"HZ";
        pkVec.add(new Peak(ss, csValue,false) );
        
        ss = "PHE"+45+"-"+"HZ";
        pkVec.add(new Peak(ss, csValue,false) );
	}
	
	
	//His:
	/*
	if ( (csValue > Const.HisCSHD1Min-hErr) && (csValue < Const.HisCSHD1Max+hErr) )
	{	
		ss = "HIS"+68+"-"+"HD1";
        pkVec.add(new Peak(ss, csValue,false) );      
	}
	
	if ( (csValue > Const.HisCSHD2Min-hErr) && (csValue < Const.HisCSHD2Max+hErr) )
	{	
		ss = "HIS"+68+"-"+"HD2";
        pkVec.add(new Peak(ss, csValue,false) );      
	}
	if ( (csValue > Const.HisCSHE1Min-hErr) && (csValue < Const.HisCSHE1Max+hErr) )
	{	
		ss = "HIS"+68+"-"+"HE1";
        pkVec.add(new Peak(ss, csValue,false) );      
	}
	
	if ( (csValue > Const.HisCSHE2Min-hErr) && (csValue < Const.HisCSHE2Max+hErr) )
	{	
		ss = "HIS"+68+"-"+"HE2";
        pkVec.add(new Peak(ss, csValue,false) );      
	}
	*/
	
	//Tyr:
	/*
	if ( (csValue > Const.TyrCSHD1Min-hErr) && (csValue < Const.TyrCSHD1Max+hErr) )
	{	
		ss = "TYR"+59+"-"+"HD1";
        pkVec.add(new Peak(ss, csValue,false) );      
	}
	if ( (csValue > Const.TyrCSHD2Min-hErr) && (csValue < Const.TyrCSHD2Max+hErr) )
	{	
		ss = "TYR"+59+"-"+"HD2";
        pkVec.add(new Peak(ss, csValue,false) );      
	}
	*/
	if ( (csValue > Const.TyrCSHE1Min-hErr) && (csValue < Const.TyrCSHE1Max+hErr) )
	{	
		ss = "TYR"+59+"-"+"HE1";
        pkVec.add(new Peak(ss, csValue,false) );      
	}
	if ( (csValue > Const.TyrCSHE2Min-hErr) && (csValue < Const.TyrCSHE2Max+hErr) )
	{	
		ss = "TYR"+59+"-"+"HE2";
        pkVec.add(new Peak(ss, csValue,false) );      
	}
	
	/*if ( (csValue > Const.TyrCSHHMin-hErr) && (csValue < Const.TyrCSHHMax+hErr) )
	{	
		ss = "TYR"+59+"-"+"HH";
        pkVec.add(new Peak(ss, csValue) );      
	}*/
	
	////////////////////////////////////////////////////////
	//for simulating more 12C from aliphatic sidechains
	
	//Ile 13, 23, 36,61
	if ( (csValue > Const.IleCSHG12Min-hErr) && (csValue < Const.IleCSHG12Max+hErr) )
	{	
		ss = "ILE"+13+"-"+"HG12";
        pkVec.add(new Peak(ss, csValue,false) );
        
        ss = "ILE"+23+"-"+"HG12";
        pkVec.add(new Peak(ss, csValue,false) );
        
        ss = "ILE"+36+"-"+"HG12";
        pkVec.add(new Peak(ss, csValue,false) );
        
        ss = "ILE"+61+"-"+"HG12";
        pkVec.add(new Peak(ss, csValue,false) );
        
	}
	
	if ( (csValue > Const.IleCSHG13Min-hErr) && (csValue < Const.IleCSHG13Max+hErr) )
	{	
		ss = "ILE"+13+"-"+"HG13";
        pkVec.add(new Peak(ss, csValue,false) );
        
        ss = "ILE"+23+"-"+"HG13";
        pkVec.add(new Peak(ss, csValue,false) );
        
        ss = "ILE"+36+"-"+"HG13";
        pkVec.add(new Peak(ss, csValue,false) );
        
        ss = "ILE"+61+"-"+"HG13";
        pkVec.add(new Peak(ss, csValue,false) );
        
	}
	
	//Gln41
	if ( (csValue > Const.GlnCSHG2Min-hErr) && (csValue < Const.GlnCSHG2Max+hErr) )
	{	
		ss = "GLN"+41+"-"+"HG2";
        pkVec.add(new Peak(ss, csValue,false) );
               
	}
	
	if ( (csValue > Const.GlnCSHG3Min-hErr) && (csValue < Const.GlnCSHG3Max+hErr) )
	{	
		ss = "GLN"+41+"-"+"HG3";
        pkVec.add(new Peak(ss, csValue,false) );
               
	}
	
	//Lys27
	if ( (csValue > Const.LysCSHG2Min-hErr) && (csValue < Const.LysCSHG2Max+hErr) )
	{	
		ss = "LYS"+27+"-"+"HG2";
        pkVec.add(new Peak(ss, csValue,false) );
               
	}
	
	if ( (csValue > Const.LysCSHG3Min-hErr) && (csValue < Const.LysCSHG3Max+hErr) )
	{	
		ss = "LYS"+27+"-"+"HG3";
        pkVec.add(new Peak(ss, csValue,false) );
               
	}
	if ( (csValue > Const.LysCSHE2Min-hErr) && (csValue < Const.LysCSHE2Max+hErr) )
	{	
		ss = "LYS"+27+"-"+"HE2";
        pkVec.add(new Peak(ss, csValue,false) );
               
	}
	if ( (csValue > Const.LysCSHE3Min-hErr) && (csValue < Const.LysCSHE3Max+hErr) )
	{	
		ss = "LYS"+27+"-"+"HE3";
        pkVec.add(new Peak(ss, csValue,false) );
               
	}
	
		return pkVec;
    }

    /**
     * A function to generate NOEs from side-chains to HN or HA,  //no longer used.
     * 
     * @param csH1Err the cs h1 err
     * @param pdbVecXray the x-ray Pdb file
     * @param h1CSVec the h1 cs vec
     * @param resNo1 the res no1
     * @param nucleus1 the nucleus1
     * 
     * @return the vector
     */
    public Vector scNoeGenerate(Vector h1CSVec, int resNo1, String nucleus1, double csH1Err, Vector pdbVecXray)
    {
    	int i,j,k;
    	Pdb pp2; 
    	Vector atomVec2; 
    	int resNo2;
    	String atomName2="";
    	Cartesian cc1,cc2;
    	double[] coordA = new double[3];
    	double[] coordB = new double[3];
    	boolean found=false;
    	double noeLimits=5.5;
    	double [] noeXray = new double[1];
    	
    	double csH1=0.0;
    	double csH2=0.0;
    	double cs1=0.0;
    	double cs2=0.0;
    	String strTemp="";
    	
    	/*
    	int index = Collections.binarySearch(pdbVecXray, new Pdb(resNo1), new Pdb.PdbComparator());
    	if (index < 0)
    	{
    		System.out.println(resNo1+ " is not in the pdb structure.");
    		return null;
    	}
    	    
    	Pdb pp1 = (Pdb)pdbVecXray.elementAt(index);
    	Vector atomVec1 = pp1.getAtomVec();
    	String atomName1="";
    	for (i=0; i<atomVec1.size(); i++)
    	{
    	    cc1 = (Cartesian) atomVec1.elementAt(i);
    	    atomName1 = cc1.getAtom();
    	    if (atomName1.equals(nucleus1))
    		coordA = cc1.getXYZ();
    	}*/
    	Vector scNoe = new Vector();
    	
    	long seed = 951179;
    	Random rr = new Random(seed);
    	
    	//read all H1 chemical shifts
    	H1CS h1CS = new H1CS();
    	
    	
    	
    	for (i=0; i<pdbVecXray.size(); i++)
    	{
    		pp2=(Pdb)pdbVecXray.elementAt(i);
    		atomVec2=pp2.getAtomVec();
    		//atomName2=pp.getResidue();
    		resNo2=pp2.getResidueNo();
    		
    		for (j=0; j<atomVec2.size();j++)
    		{
    			cc2 = (Cartesian) atomVec2.elementAt(j);
    			atomName2 = cc2.getAtom();
    			found = checkNoe2(pdbVecXray,resNo1,nucleus1, resNo2, atomName2, noeLimits, Const.methylCorrection, noeXray); 
    			strTemp=atomName2.substring(0,1);
    			
    			if (strTemp.equalsIgnoreCase("H") && found)
    			{
    				for (k=0;k<h1CSVec.size();k++)
    				{
    					h1CS=(H1CS)h1CSVec.elementAt(k);
    					if ((h1CS.getResidueNo()==resNo1) && (nucleus1.equalsIgnoreCase(h1CS.getAtomName()) ))
    						cs1=h1CS.getH1CS();
    					if ((h1CS.getResidueNo()==resNo2) && (atomName2.equalsIgnoreCase(h1CS.getAtomName()) ))
    						cs2=h1CS.getH1CS();
    				}
    				csH1=cs1+csH1Err * rr.nextGaussian(); 
    				csH2=cs2+csH1Err * rr.nextGaussian();
    				scNoe.add(new ScNoe(csH1, csH2, 0.0));
    				
    			}
    		
    			
    		}//end of for (j=0; j<atomVec.size();j++)
    		
    	}//end of for (i=0; i<pdbVecXray.size(); i++)
    		
    	return scNoe ;
    	
    }
    
    /**
     * A function to generate and check back NOE chemical shifts.
     * 
     * @param allCSVec the all cs vec
     * @param resNo1 the res no1
     * @param resName1 the res name1
     * @param atomName1 the atom name1
     * @param resNo2 the res no2
     * @param resName2 the res name2
     * @param atomName2 the atom name2
     * @param heavyName2 the heavy name2
     * @param csSigma the cs sigma
     * 
     * @return the vector
     */
    public Vector BackCSGenerate(Vector allCSVec,  int resNo1, String resName1, String atomName1,
    		int resNo2, String resName2, String atomName2, String heavyName2, double csSigma)
    {
    	long seed = 951179;
    	Random rr = new Random(seed);
    	int i,j,k;
    	H1CS cs=null;
    	int res_no;
    	String res_name, atom_name;
    	double db_cs=0.0;
    	double db_csH1=0.0;
    	double db_csH2=0.0;
    	double db_csHeavy2=0.0;
    	
    	Vector inputs = new Vector();
    	//HcchTocsy inputsC=new HcchTocsy();
    	//HnNoe inputsN=new HnNoe();
    	
    	for (i=0; i<allCSVec.size(); i++)
    	{
    		cs=(H1CS)allCSVec.elementAt(i);
    		res_no=cs.getResidueNo();
    		res_name=cs.getResidueType();
    		atom_name=cs.getAtomName();
    		db_cs=cs.getH1CS();
    		
    		if (res_no==resNo1 && res_name.equalsIgnoreCase(resName1)  && atom_name.equalsIgnoreCase(atomName1))
    			db_csH1=db_cs+ csSigma* rr.nextGaussian(); 
    		
    		if (res_no==resNo2 && res_name.equalsIgnoreCase(resName2) && atom_name.equalsIgnoreCase(atomName2))
    			db_csH2=db_cs+csSigma* rr.nextGaussian();
    		
    		if (res_no==resNo2 && res_name.equalsIgnoreCase(resName2) && atom_name.equalsIgnoreCase(heavyName2))
    			db_csHeavy2=db_cs+csSigma* rr.nextGaussian();   		
    	}//for (i=0; i<allCSVec.size(); i++)
    	
    	if (heavyName2.substring(0,1).equalsIgnoreCase("C"))  
    	{
    		inputs.add(new HcchTocsy(resNo2, resName2, db_csH2, db_csHeavy2, db_csH1, 0.0));
    		//return inputsC;
    	}
    
    	if (heavyName2.substring(0,1).equalsIgnoreCase("N"))    		
    		inputs.add(new HnNoe(resNo2, resName2, db_csH2, db_csHeavy2, db_csH1, 0.0));
    
    	return inputs;
    	
    }
    
    
    /**
     * A function to generate ubq NOEs from side-chains to HN or HA,.
     * 
     * @param csH1Err the cs h1 err
     * @param pdbVecXray the x-ray Pdb file
     * @param h1CSVec the h1 cs vec
     * 
     * @return the vector
     */
    public Vector ubqNoeGenerate(Vector h1CSVec, double csH1Err, Vector pdbVecXray)
    {
    	Vector ubqNoe= new Vector();
    	Vector scNoe;// = new Vector();
		//double hSigma=0.01;
    	
    	//from Phe4
    	scNoe=scNoeGenerate(h1CSVec,4,"HD1", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,4,"HD2", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	
    	scNoe=scNoeGenerate(h1CSVec,4,"HE1", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,4,"HE2", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	
    	
    	scNoe=scNoeGenerate(h1CSVec,4,"H", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,4,"HA", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,4,"HB2", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,4,"HB3", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	
    	
//    	from Phe45
    	scNoe=scNoeGenerate(h1CSVec,45,"HD1", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,45,"HD2", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	
    	scNoe=scNoeGenerate(h1CSVec,45,"HE1", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,45,"HE2", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	
    	scNoe=scNoeGenerate(h1CSVec,45,"H", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,45,"HA", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,45,"HB2", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,45,"HB3", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	
    	//from His 68
    	scNoe=scNoeGenerate(h1CSVec,68,"HD2", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,68,"HE1", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	
    	scNoe=scNoeGenerate(h1CSVec,68,"H", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,68,"HA", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,68,"HB2", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,68,"HB3", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	
    	//from Tyr59
    	scNoe=scNoeGenerate(h1CSVec,59,"HD1", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,59,"HD2", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	
    	scNoe=scNoeGenerate(h1CSVec,59,"HE1", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,59,"HE2", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	
    	scNoe=scNoeGenerate(h1CSVec,59,"H", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,59,"HA", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,59,"HB2", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	scNoe=scNoeGenerate(h1CSVec,59,"HB3", csH1Err,pdbVecXray);
    	ubqNoe.addAll(scNoe);
    	
    	return ubqNoe ;
    	
    }
    
    /**
     * Range Search: search all the protons with in the range [CS-h1Err, CS + h1Err].
     * 
     * @param sortedH1Vec is a sorted resonance assignment vector with
     * monotone increasing sequence number.
     * @param csValue the middle value of cs value
     * @param h1Err error range for the csValue
     * 
     * @return a vector of Peak objects
     */
    public Vector<Peak> rangeSearch(final Vector sortedH1Vec, double csValue, double h1Err){
	Vector pkVec = new Vector();
	Peak pk = new Peak();
	double cs = 0.0;
	double a = csValue - h1Err;
	double b = csValue + h1Err;
	int  index = Collections.binarySearch(sortedH1Vec, new Peak(a), new Peak.csComparator());
	int i = 0;
//  	if (Math.abs(csValue - 9.358) < 0.00001)
//  	    System.out.println("index= "+index);
	if (index < 0){
	    for (i = -(index+1); i < sortedH1Vec.size(); i++){
		pk = (Peak)sortedH1Vec.elementAt(i);
		cs = pk.getCS();
		if (cs <= b)
		    pkVec.add(pk);
		else
		    break;
	    }
// 	    for (i = -(index+2); i > 0; i--){  //Should be NOT necessary
// 		pk = (Peak)sortedH1Vec.elementAt(i);
// 		cs = pk.getCS();
// 		if (cs >= a){
// 		    pkVec.add(pk);
// 		    System.out.println("BBK  "+pk);
// 		}else 
// 		    break;
// 	    }
	}else {	
	    cs = -999.99;
	    for (i = index; i < sortedH1Vec.size(); i++){
		pk = (Peak)sortedH1Vec.elementAt(i);
		cs = pk.getCS();
		if (cs <= b)
		    pkVec.add(pk);
		else 
		    break;
	    }
	    cs = -999.99;
	    for (i = index; i > 0; i--){
		pk = (Peak)sortedH1Vec.elementAt(i);
		cs = pk.getCS();
		if (cs == a){
		    pkVec.add(pk);
// 		    System.out.println("BBK  "+pk);
		}else 
		    break;
	    }
	}
// 	System.out.println("size= "+pkVec.size());
	return pkVec;
    }

    /**
     * Range Search: search all the protons with in the range [CS-h1Err, CS + h1Err].
     * 
     * @param sortedH1Vec is a sorted resonance assignment vector with
     * monotone increasing sequence number.
     * @param csValue the middle value of cs value
     * @param h1Err error range for the csValue
     * 
     * @return a vector of Peak objects
     */
    public Vector rangeSearchScNoeCS1(final Vector sortedH1Vec, double csValue, double h1Err)
    { 	
    	Vector pkVec = new Vector();
    	ScNoe scNoe = new ScNoe();
    	Collections.sort(sortedH1Vec, new ScNoe.cs1Comparator() );
    	
    	double cs = 0.0;
    	double a = csValue - h1Err;
    	double b = csValue + h1Err;
    	int  index = Collections.binarySearch(sortedH1Vec, new ScNoe(a), new ScNoe.cs1Comparator());
    	int i = 0;
//  	if (Math.abs(csValue - 9.358) < 0.00001)
//  	    System.out.println("index= "+index);
    	if (index < 0)
    	{
    		for (i = -(index+1); i < sortedH1Vec.size(); i++)
    		{
    			scNoe = (ScNoe)sortedH1Vec.elementAt(i);
    			cs = scNoe.getHCS1();
    			if (cs <= b)
    				pkVec.add(scNoe);
    			else
    				break;
    		}

    	}else {	
    		cs = -999.99;
    		for (i = index; i < sortedH1Vec.size(); i++)
    		{
    			scNoe = (ScNoe)sortedH1Vec.elementAt(i);
    			cs = scNoe.getHCS1();
    			if (cs <= b)
    				pkVec.add(scNoe);
    			else 
    				break;
    		}
    		cs = -999.99;
    		for (i = index; i > 0; i--)
    		{
    			scNoe = (ScNoe)sortedH1Vec.elementAt(i);
    			cs = scNoe.getHCS1();
    			if (cs == a){
    				pkVec.add(scNoe);
// 		    System.out.println("BBK  "+pk);
    			}else 
    				break;
    		}
    	}
// 	System.out.println("size= "+pkVec.size());
    	return pkVec;
    }
    
    /**
     * Range Search: search all the protons with in the range [CS-h1Err, CS + h1Err].
     * 
     * @param sortedH1Vec is a sorted resonance assignment vector with
     * monotone increasing sequence number.
     * @param csValue the middle value of cs value
     * @param h1Err error range for the csValue
     * 
     * @return a vector of Peak objects
     */
    public Vector rangeSearchScNoeCS2(final Vector sortedH1Vec, double csValue, double h1Err)
    { 	
    	Vector pkVec = new Vector();
    	ScNoe scNoe = new ScNoe();
    	Collections.sort(sortedH1Vec, new ScNoe.cs2Comparator() );
    	
    	double cs = 0.0;
    	double a = csValue - h1Err;
    	double b = csValue + h1Err;
    	int  index = Collections.binarySearch(sortedH1Vec, new ScNoe(0.0,a), new ScNoe.cs2Comparator());
    	int i = 0;
//  	if (Math.abs(csValue - 9.358) < 0.00001)
//  	    System.out.println("index= "+index);
    	if (index < 0)
    	{
    		for (i = -(index+1); i < sortedH1Vec.size(); i++)
    		{
    			scNoe = (ScNoe)sortedH1Vec.elementAt(i);
    			cs = scNoe.getHCS2();
    			if (cs <= b)
    				pkVec.add(scNoe);
    			else
    				break;
    		}

    	}else {	
    		cs = -999.99;
    		for (i = index; i < sortedH1Vec.size(); i++)
    		{
    			scNoe = (ScNoe)sortedH1Vec.elementAt(i);
    			cs = scNoe.getHCS2();
    			if (cs <= b)
    				pkVec.add(scNoe);
    			else 
    				break;
    		}
    		cs = -999.99;
    		for (i = index; i > 0; i--)
    		{
    			scNoe = (ScNoe)sortedH1Vec.elementAt(i);
    			cs = scNoe.getHCS2();
    			if (cs == a){
    				pkVec.add(scNoe);
// 		    System.out.println("BBK  "+pk);
    			}else 
    				break;
    		}
    	}
// 	System.out.println("size= "+pkVec.size());
    	return pkVec;
    }

    /**
     * This is an earlier version of NOE assignment method, not filtered by Structure.
     * 
     * @param h1Vec a sorted array of all protons
     * @param asgVec an array of Assign object for all the residues
     */
    public void noeAssign1st(final Vector h1Vec, final Vector asgVec){
	int i = 0, j = 0, k = 0;
	Vector oneHnVec = new Vector();
 	Vector oneHaVec = new Vector();
 	Vector oneH1Vec = new Vector();
	Assign asg  = new Assign();
	Peak   pk   = new Peak();
	double h1Err = 0.04;
	double csOfB = 0.0; //the CS of the NOE partner 
	HnNoe hnNoe = new HnNoe();
	int resNo1 = 0,  resNo2 = 0,  resNo3 = 0;
	Vector bVec = new Vector();
	Vector cVec = new Vector();
	String resId = "", aaType ="";
	int index = 0;
	HcchTocsy hcch = new HcchTocsy();
	for(i=0; i<asgVec.size(); i++){
	    asg = (Assign)asgVec.elementAt(i);
	    oneHnVec = asg.getHnNoeVec();
 	    oneHaVec = asg.getHaNoeVec();
// 	    oneH1Vec = asg.getH1NoeVec();
	    resNo1 = asg.getResidueNo();
	    aaType = asg.getResidueType();
	    System.out.println(resNo1+"  "+aaType);
	    //Assign N-15 NOEs
	    bVec = new Vector();
	    for(j=0; j<oneHnVec.size(); j++){
		hnNoe = (HnNoe) oneHnVec.elementAt(j);
		csOfB = hnNoe.getH1();
		bVec = rangeSearch(h1Vec, csOfB, h1Err);
		if (bVec.isEmpty())
		    System.out.println("NO Assign:  "+hnNoe);
// 		System.out.println(hnNoe);
// 		System.out.println(bVec.size());
 		if (bVec.size() < 3){
		    System.out.println(hnNoe);
		    for (k=0; k<bVec.size(); k++){
			pk = (Peak)bVec.elementAt(k);
			resId = pk.getNucleus();
			index = resId.indexOf("-");
			resNo2 = Integer.parseInt(resId.substring(3, index));
			if (resNo2 == resNo1) {
			    System.out.println("Intra NOEs:");
			    System.out.println(pk);
			}else if ( Math.abs(resNo2 - resNo1) == 1 ){
			    System.out.print("Seq NOEs:  ");
			    System.out.println(pk);
			}else if ( Math.abs(resNo2 - resNo1) > 1 &&  Math.abs(resNo2 - resNo1) <= 3 ){
			    System.out.print("Med NOEs:  ");
			    System.out.println(pk);
			}else {
			    // 			    System.out.println(hnNoe);
			    // 			    System.out.println(resNo1+":  "+bVec.size());
			    System.out.print("Long NOEs:  ");
			    System.out.println(pk);
			}
		    }
		}
	    }
	    //Assign C-13 NOEs
	    cVec = new Vector();
	    for(j=0; j<oneHaVec.size(); j++){
		hcch = (HcchTocsy) oneHaVec.elementAt(j);
		csOfB = hcch.getH1();
		cVec = rangeSearch(h1Vec, csOfB, h1Err);
		if (cVec.isEmpty())
		    System.out.println("NO Assign2:  "+hcch);
// 		System.out.println(hcch);
// 		System.out.println(cVec.size());
 		if (cVec.size() < 3){
		    System.out.println(hcch);
		    for (k=0; k<cVec.size(); k++){
			pk = (Peak)cVec.elementAt(k);
			resId = pk.getNucleus();
			index = resId.indexOf("-");
			resNo3 = Integer.parseInt(resId.substring(3, index));
			if (resNo3 == resNo1) 
			    System.out.println("Intra NOEs");
			else if ( Math.abs(resNo3 - resNo1) == 1 ){
			    System.out.print("Seq NOEs:  ");
			    System.out.println(pk);
			}else if ( Math.abs(resNo3 - resNo1) > 1 &&  Math.abs(resNo3 - resNo1) <= 3 ){
			    System.out.print("Med NOEs:  ");
			    System.out.println(pk);
			}else {
			    // 			    System.out.println(hnNoe);
			    // 			    System.out.println(resNo1+":  "+bVec.size());
			    System.out.print("Long NOEs:  ");
			    System.out.println(pk);
			}
			// 		    }
		    }
		}
	    }
	    System.out.println();
	}
    }
    
    /**
     * generate the simulated ca noes from x-ray structure.
     * 
     * @param asgVec an array of Assign object for all the residues
     * @param pdbVecXray the Xray structure of ubiquitin
     * @param distBound the dist bound
     * 
     * @return the vector
     */
    public Vector SimulatedCaNoe(Vector pdbVecXray,  Vector asgVec, double distBound)
    {
    	Vector vecCaNoe=new Vector();
    	int i,j,k,m;
    	Pdb pdbA,pdbB;
    	Vector atomVecA,atomVecB;
    	String atomNameA="";
    	String atomNameB="";
    	Cartesian ccA = new Cartesian();
    	Cartesian ccB = new Cartesian();
    	double [] coordA = {0.0, 0.0, 0.0};
    	double [] coordB = {0.0, 0.0, 0.0};
    	double dist;
    	int firstResNo=0;
    	int secondResNo=0;
    	String firstResName="";
    	String secondResName="";
    	RotaPattern rp=new RotaPattern();
    	boolean found=false;
    	double [] noeXray = new double[1];
    	
    	for (i=0;i<pdbVecXray.size();i++)
    	{
    		pdbA=(Pdb)pdbVecXray.elementAt(i);
    		atomVecA=pdbA.getAtomVec();
    		firstResNo=pdbA.getResidueNo();
    		firstResName=pdbA.getResidue();
    		for (j=0;j<atomVecA.size();j++)
    		{
    			ccA=(Cartesian)atomVecA.elementAt(j);
    			atomNameA=ccA.getAtom();
    			coordA=ccA.getXYZ();
    			if(atomNameA.equalsIgnoreCase("HA"))
    			{
    				for(k=0;k<pdbVecXray.size();k++)
    				{
    					pdbB=(Pdb)pdbVecXray.elementAt(k);
    					atomVecB=pdbB.getAtomVec();
    					for (m=0;m<atomVecB.size();m++)
    					{
    						ccB=(Cartesian)atomVecB.elementAt(m);
    						atomNameB=ccB.getAtom();
    						coordB=ccB.getXYZ();
    						dist= Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
    								+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
    								+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
    						secondResNo=pdbB.getResidueNo();
    						secondResName=pdbB.getResidue();
    						found=false;
    						double noeLimits=4.5;
    						found = checkNoe_old(pdbVecXray, asgVec, firstResNo,"HA", secondResNo, atomNameB, noeLimits, Const.methylCorrection, noeXray); 
    			 			
    						if(atomNameB.substring(0,1).equalsIgnoreCase("H") && found) //dist<distBound)
    						{
    							//need to be careful of the order, 1st atom means the proton like HG21, 2nd atom means the heavy proton such as ha
    							Hdist hdist=new Hdist(ccB,secondResNo,secondResName,atomNameB,ccA,firstResNo,firstResName,atomNameA, dist);
    							BackNoe backNoe=rp.SimulateBackCompNOEPeak(asgVec,hdist);
    							double csH1=backNoe.getCSH1();
    							double csHeavy=backNoe.getCSHeavy();
    							double csH2=backNoe.getCSH2();
    							HcchTocsy hcchTocsy=new HcchTocsy(firstResNo,firstResName,csH1,csHeavy, csH2,0.0);
    							if((csH1!=-999.9) && (csHeavy!=-999.9) && (csH2!=-999.9) )
    								vecCaNoe.add(hcchTocsy);
    						}//if(atomNameB.substring(0,1).equalsIgnoreCase("H"))
    						
    					}//for (m=0;m<atomVecB.size();m++)
    					
    				}//for(k=0;k<pdbVecXray.size();k++)
    				
    			}//if(atomNameA.equalsIgnoreCase("CA"))
    			
    			
    		}//for (j=0;j<atomVecA.size();j++)
    		
    		
    	}//for (i=0;i<pdbVecXray.size();i++)
    	
    	
    	return vecCaNoe;
    }
    
    /**
     * generate the back noes from assignment based on x-ray structure.
     * 
     * @param h1Vec a sorted array of all protons
     * @param asgVec an array of Assign object for all the residues
     * @param allCSVec an array saving all chemical shifts
     * @param pdbVecXray the Xray structure of ubiquitin
     * @param allHnVec returning parameter, saving all Hn NOEs inlucding previous and backNOEs
     * @param allHaVec returning parameter, saving all Ha NOEs inlucding previous and backNOEs
     */
    public void BackNOEGenerate(final Vector h1Vec, final Vector asgVec,  Vector pdbVecXray,final Vector allCSVec,Vector allHnVec, Vector allHaVec)
    {
		int i = 0, j = 0, k = 0;
		//Vector allHnVec = new Vector();
		//Vector allHaVec = new Vector();
		
		Vector HnVec = new Vector<HnNoe>();
		Vector HaVec = new Vector<HcchTocsy>();
		
		Vector oneHnVec = new Vector();
	 	Vector oneHaVec = new Vector();
	 	Vector oneH1Vec = new Vector();
		Assign asg  = new Assign();
		Peak   pk   = new Peak();
		Pdb pp = new Pdb();
		double h1Err = 0.04;
		double csOfB = 0.0; //the CS of the NOE partner 
	
		////added by zeng
		double haErr=0.02;		
	
		HnNoe hnNoe = new HnNoe();
		HcchTocsy haNoe = new HcchTocsy();
		
		int resNo1 = 0,  resNo2 = 0,  resNo3 = 0;
		Vector bVec = new Vector();
		Vector bVecTemp = new Vector();//added by zeng
		Vector bVecTemp2=new Vector(); //added by zeng
	
		
		Vector cVec = new Vector();
		String resId = "", aaType ="", nucleus, res = "";
		int index = 0;
		HcchTocsy hcch = new HcchTocsy();
		double[] dis1 = new double[1]; //for saving the back-computed NOEs
		dis1[0] = 0.0;
		boolean hasNOE = false;
		boolean assigned = false;
		boolean found = false;
		int minIndex = 0;
		double minDis = 0.0;
		Vector pkVec = new Vector();
		System.out.println(" ! The NOEs Assignment from N15 NOESY");
		double noeLimits  = 5.5;
		double [] noeXray = new double[1]; //for saving the NOE distance from the X-ray structure
		double [] noeXray2 = new double[1]; 
		String xplorNoeStr ="";
		String strOutput = "";
		double [] disUpper= new double[1];
	
		Map aMap = new TreeMap();
		double csRes1=0.0;
		double csRes2=0.0;
		boolean isSymm= false;
		double simCSH=0.0;
		boolean isAssg= true;
		String heavyName2="";
		
		double csSigma=0.0;//error deviation for generating back NOE cs
	
		for(i=0; i<asgVec.size(); i++)
		{
		    asg = (Assign)asgVec.elementAt(i);
		    aMap=asg.getMap();
		    csRes1 = ((Double)aMap.get("HN")).doubleValue();
		    
		    oneHnVec = asg.getHnNoeVec();
	 	    oneHaVec = asg.getHaNoeVec();
	 	    oneH1Vec=asg.getH1NoeVec();
	 	    
	 	    allHnVec.addAll(oneHnVec);
	 	    allHaVec.addAll(oneHaVec);
	 	    
	 	    if (!oneH1Vec.isEmpty())
	 	    	allHnVec.addAll(oneH1Vec); //add NH that is not from backbone N
	 	    
		    resNo1 = asg.getResidueNo();
		    aaType = asg.getResidueType();
	
		    bVec = new Vector();
		    bVecTemp = new Vector();//added by zeng		    
		    
		    for(j=0; j<oneHnVec.size(); j++)
		    {
		    	bVec = new Vector();
		    	hnNoe = (HnNoe) oneHnVec.elementAt(j);
		    	csOfB = hnNoe.getH1();
		    	bVecTemp = rangeSearch(h1Vec, csOfB, h1Err); //retrun a set of possible NOE assignment based solely on CS
		    	if (bVecTemp.isEmpty())
		    	{
		    		//System.out.println("NO Assign by CS  "+hnNoe);
		    		break;
		    	}
			
		    	///////added by zeng, for the new test without ring resonance assignments
		    	for (k=0;k<bVecTemp.size(); k++)
		    	{
		    		pk = (Peak)bVecTemp.elementAt(k);
		    		resId = pk.getNucleus();
		    		index = resId.indexOf("-");
		    		resNo2 = Integer.parseInt(resId.substring(3, index)); //"3" see the method rangeSearch
		    		res    = resId.substring(0, 3);
		    		nucleus = resId.substring(index+1);
		    		csOfB=pk.getCS();
		    		
		    		if (!res.equalsIgnoreCase("DMP"))
		    		{
		    			bVec.add(pk);
		    			bVecTemp2 = new Vector();	 
		    			
		    		}
		    		
		    	}//for (k=0;k<bVecTemp.size(); k++)
			
		    	double [] allDis = new double[bVec.size()]; //for saving the NOEs in case no NOE <6.00\AA
		    	assigned = false;
		    	for (k=0; k < bVec.size(); k++)
		    	{
		    		isSymm=false;
		    		
		       		pk = (Peak)bVec.elementAt(k);
		    		resId = pk.getNucleus();
		    		index = resId.indexOf("-");
		    		resNo2 = Integer.parseInt(resId.substring(3, index)); //"3" see the method rangeSearch
		    		res    = resId.substring(0, 3);
		    		nucleus = resId.substring(index+1);
		    		if (nucleus.equalsIgnoreCase("HN"))
		    			nucleus="H";
		    		
		    		csRes2=pk.getCS();
		    		isAssg=pk.getIsAssg();
		    		
		    		
		    		found = checkNoe_old(pdbVecXray, asgVec, resNo1,"H", resNo2, nucleus, noeLimits, Const.methylCorrection, noeXray); 
		 			   		
		    		//hasNOE = pp.measureDis(pdbVec, resNo1, aaType, "H", resNo2, res, nucleus, dis1);
		    		//allDis[k] = dis1[0];
		    		if (found)
		    		{
		    			heavyName2=GetHeavyAtomFromProton(res,nucleus);
		    			if (heavyName2.substring(0,1).equalsIgnoreCase("N"))
		    			{
		    				HnVec=BackCSGenerate(allCSVec, resNo1, aaType, "H", resNo2, res, nucleus,heavyName2,csSigma);
		    				allHnVec.addAll(HnVec);
		    			}
		    			if (heavyName2.substring(0,1).equalsIgnoreCase("C"))
		    			{
		    				HaVec=BackCSGenerate(allCSVec, resNo1, aaType, "H", resNo2, res, nucleus,heavyName2,csSigma);
		    				allHaVec.addAll(HaVec);
		    			}
		    			

		    		}//if (found)
	
		    	}//for (k=0; k < bVec.size(); k++)
		    }//for(j=0; j<oneHnVec.size(); j++)

		    /////////////////////////////////////////
		    //for HaNOE
		    for(j=0; j<oneHaVec.size(); j++)
		    {
		    	cVec = new Vector();
		    	haNoe = (HcchTocsy) oneHaVec.elementAt(j);
		    	csOfB = haNoe.getH1();
		    	bVecTemp = rangeSearch(h1Vec, csOfB, h1Err); //retrun a set of possible NOE assignment based solely on CS
		    	if (bVecTemp.isEmpty())
		    	{
		    		//System.out.println("NO Assign by CS  "+hnNoe);
		    		break;
		    	}
			
		    	///////added by zeng, for the new test without ring resonance assignments
		    	for (k=0;k<bVecTemp.size(); k++)
		    	{
		    		pk = (Peak)bVecTemp.elementAt(k);
		    		resId = pk.getNucleus();
		    		index = resId.indexOf("-");
		    		resNo2 = Integer.parseInt(resId.substring(3, index)); //"3" see the method rangeSearch
		    		res    = resId.substring(0, 3);
		    		nucleus = resId.substring(index+1);
		    		csOfB=pk.getCS();
		    		
		    		if (!res.equalsIgnoreCase("DMP"))
		    		{
		    			cVec.add(pk);
		    			bVecTemp2 = new Vector();	 
		    			
		    		}
		    		
		    	}//for (k=0;k<bVecTemp.size(); k++)
			
		    	double [] allDis = new double[cVec.size()]; //for saving the NOEs in case no NOE <6.00\AA
		    	assigned = false;
		    	for (k=0; k < cVec.size(); k++)
		    	{
		    		isSymm=false;
		    		
		       		pk = (Peak)cVec.elementAt(k);
		    		resId = pk.getNucleus();
		    		index = resId.indexOf("-");
		    		resNo2 = Integer.parseInt(resId.substring(3, index)); //"3" see the method rangeSearch
		    		res    = resId.substring(0, 3);
		    		nucleus = resId.substring(index+1);
		    		if (nucleus.equalsIgnoreCase("HN"))
		    			nucleus="H";
		    		csRes2=pk.getCS();
		    		isAssg=pk.getIsAssg();
		    		
		    		found = checkNoe_old(pdbVecXray, asgVec, resNo1,"HA", resNo2, nucleus, noeLimits, Const.methylCorrection, noeXray); 
		 			   		
		    		//hasNOE = pp.measureDis(pdbVec, resNo1, aaType, "H", resNo2, res, nucleus, dis1);
		    		//allDis[k] = dis1[0];
		    		if (found)
		    		{
		    			heavyName2=GetHeavyAtomFromProton(res,nucleus);
		    			if (heavyName2.substring(0,1).equalsIgnoreCase("N"))
		    			{
		    				HnVec=BackCSGenerate(allCSVec, resNo1, aaType, "HA", resNo2, res, nucleus,heavyName2,csSigma);
		    				allHnVec.addAll(HnVec);
		    			}
		    			else
		    			{
		    				HaVec=BackCSGenerate(allCSVec, resNo1, aaType, "HA", resNo2, res, nucleus,heavyName2,csSigma);
		    				allHaVec.addAll(HaVec);
		    			}
		    			

		    		}//if (found)
	
		    	}//for (k=0; k < bVec.size(); k++)
		    }//for(j=0; j<oneHnVec.size(); j++)

		    
	 	}//for(i=0; i<asgVec.size(); i++)
    }
    
    /**
     * Lw's original + rotamer library
     * an NOE assignment method, filtered by Structure.
     * 
     * @param h1Vec a sorted array of all protons
     * @param asgVec an array of Assign object for all the residues
     * @param pdbVec the backbone structure used to filter the assignment
     * @param pdbVecXray the Xray structure of ubiquitin
     */
    public void noeAssign2ndLW(final Vector h1Vec, final Vector asgVec, Vector pdbVec, Vector pdbVecXray)
    {
    	int crNOEAsg=0;
    	int wrNOEAsg=0;
		int i = 0, j = 0, k = 0;
		//int kk=0;//added by zeng
		
		Vector oneHnVec = new Vector();
	 	Vector oneHaVec = new Vector();
	 	Vector oneH1Vec = new Vector();
		Assign asg  = new Assign();
		Peak   pk   = new Peak();
		Pdb pp = new Pdb();
		double h1Err = 0.04;
		double csOfB = 0.0; //the CS of the NOE partner 
		
		////added by zeng
		double haErr=0.02;
		double chkErr=0.04;
	
		HnNoe hnNoe = new HnNoe();
		int resNo1 = 0,  resNo2 = 0,  resNo3 = 0;
		Vector bVec = new Vector();
		Vector bVecTemp = new Vector();//added by zeng
		Vector bVecTemp2=new Vector(); //added by zeng

		Vector cVec = new Vector();
		String resId = "", aaType ="", nucleus, res = "";
		int index = 0;
		HcchTocsy hcch = new HcchTocsy();
		double[] dis1 = new double[1]; //for saving the back-computed NOEs
		dis1[0] = 0.0;
		boolean hasNOE = false;
		boolean assigned = false;
		boolean assignedFromAsgCS=false;
		boolean found = false;
		int minIndex = 0;
		double minDis = 0.0;
		Vector pkVec = new Vector();
		System.out.println(" ! The NOEs Assignment from N15 NOESY");
		double noeLimits  = 5.5;
		double [] noeXray = new double[1]; //for saving the NOE distance from the X-ray structure
		double [] noeXray2 = new double[1]; 
		String xplorNoeStr ="";
		String strOutput = "";
		double [] disUpper= new double[1];

		Map aMap = new TreeMap();
		double csRes1=0.0;
		double csRes2=0.0;
		boolean isSymm= false;
		double simCSH=0.0;
		boolean isAssg= true;
		double noeCSHN=0.0;
		double noeCSH1=0.0;
		
		String src   = "./inputFiles/rotasamp-small/"; //The directory has the input files
	 	String rotamFile; 
	 	Vector pdbRotamA =new Vector();
	 	Vector pdbRotamB=new Vector();
	 	Vector pdbRotamNewA =new Vector();
	 	Vector pdbRotamNewB =new Vector();
	 	int ind1=0;
	 	Pdb pdbA;
	 	
		for(i=0; i<asgVec.size(); i++)
		{
		    asg = (Assign)asgVec.elementAt(i);
		    aMap=asg.getMap();
		    csRes1 = ((Double)aMap.get("HN")).doubleValue();
		    
		    oneHnVec = asg.getHnNoeVec();
	 	    oneHaVec = asg.getHaNoeVec();
		    // 	    oneH1Vec = asg.getH1NoeVec(); //for NOEs originating from protons other than HA and HN
		    resNo1 = asg.getResidueNo();
		    aaType = asg.getResidueType();
	// 	    System.out.println();
	 	    System.out.println("!  "+aaType+"  "+resNo1);
		    bVec = new Vector();
		    bVecTemp = new Vector();//added by zeng
		    
		    for(j=0; j<oneHnVec.size(); j++)
		    {
		    	bVec = new Vector();
		    	hnNoe = (HnNoe) oneHnVec.elementAt(j);
		    	csOfB = hnNoe.getH1();
		    	noeCSHN=hnNoe.getHN();
		    	noeCSH1=hnNoe.getH1();
		    	bVec = rangeSearch(h1Vec, csOfB, h1Err); //retrun a set of possible NOE assignment based solely on CS
				if (bVec.isEmpty()){
				    System.out.println("NO Assign by CS  "+hnNoe);
				    break;
				}
		    	/*bVecTemp = rangeSearch(h1Vec, csOfB, h1Err); //retrun a set of possible NOE assignment based solely on CS
		    	if (bVecTemp.isEmpty())
		    	{
		    		System.out.println("NO Assign by CS  "+hnNoe);
		    		break;
		    	}
			
		    	
		    	//added by zeng, add possible candidates from assigned resonances
		    	for (k=0;k<bVecTemp.size(); k++)
		    	{
		    		pk = (Peak)bVecTemp.elementAt(k);
		    		resId = pk.getNucleus();
		    		index = resId.indexOf("-");
		    		resNo2 = Integer.parseInt(resId.substring(3, index)); //"3" see the method rangeSearch
		    		res    = resId.substring(0, 3);
		    		nucleus = resId.substring(index+1);
		    		//csOfB=pk.getCS();
		    		
		    		if (!res.equalsIgnoreCase("DMP"))
		    		{
		    			bVec.add(pk);
		    			
		    		}
		    		
		    	}
		    	
		    	//added from unassigned resonances 
		    	bVecTemp2 = new Vector();
   			 
    			bVecTemp2=pk.ringResonanceAsg(csOfB, haErr );
    			bVec.addAll(bVecTemp2);	*/
    			  			
    			double [] allDis = new double[bVec.size()]; //for saving the NOEs in case no NOE <6.00\AA
		    	assigned = false;
		    	assignedFromAsgCS=false;
		    	for (k=0; k < bVec.size(); k++)
		    	{
		    		isSymm=false;
		    		
		       		pk = (Peak)bVec.elementAt(k);
		    		resId = pk.getNucleus();
		    		index = resId.indexOf("-");
		    		resNo2 = Integer.parseInt(resId.substring(3, index)); //"3" see the method rangeSearch
		    		res    = resId.substring(0, 3);
		    		nucleus = resId.substring(index+1);
		    		if(nucleus.equalsIgnoreCase("HN"))
		    			nucleus="H";
		    		csRes2=pk.getCS();
		    		isAssg=pk.getIsAssg();
		    		
	// 		    System.out.println("ID = "+ resNo1+"H <--> "+resNo2+"  "+res+"  "+nucleus);
		    		if (aaType.equalsIgnoreCase("ALA")||aaType.equalsIgnoreCase("GLY"))
		    		{
		    			pdbRotamNewA =new Vector();
		    			ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
		    			pdbA = (Pdb)pdbVec.elementAt(ind1);
		    			pdbRotamNewA.add(pdbA);
		    			
		    		}
		    		else
		    		{
			    		rotamFile=src+ aaType.toLowerCase()+ ".pdb"; 
			    		pdbRotamA=pp.readPdb(rotamFile);
			    		pdbRotamNewA=pp.nameConvert(pdbRotamA);
		    		}
		    		
		    		if(res.equalsIgnoreCase("ALA")|| res.equalsIgnoreCase("GLY"))
		    		{
		    			pdbRotamNewB =new Vector();
		    			ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
		    			pdbA = (Pdb)pdbVec.elementAt(ind1);
		    			pdbRotamNewB.add(pdbA);
		    		}
		    		else
		    		{
			    		rotamFile=src+ res.toLowerCase()+ ".pdb"; 
			    		pdbRotamB=pp.readPdb(rotamFile);
			    		pdbRotamNewB=pp.nameConvert(pdbRotamB);
		    		}
		    		
		    		hasNOE=pp.measureDisFromRotam(pdbVec, pdbRotamNewA, pdbRotamNewB,resNo1, aaType, "H", resNo2, res, nucleus, dis1);
		    		
		    		//hasNOE = pp.measureDis(pdbVec, resNo1, aaType, "H", resNo2, res, nucleus, dis1);
		    		allDis[k] = dis1[0];
		    		if (hasNOE)
		    		{
		    			found = checkNoe_old(pdbVecXray, asgVec, resNo1,"H", resNo2, nucleus, noeLimits, Const.methylCorrection, noeXray); 
	 			
		    			/*if (isAssg)
		    			{
		    				// use symmetry to check whether there is another NOE from side-chain to HN
		    				isSymm=CheckBackNOE(hnNoeVec, haNoeVec,csAllAsg,resNo1,aaType,"H",resNo2,res, nucleus,chkErr);
		    			}*/
		    			
		    			if ((dis1[0] <= 6.00) )
		    			{
		    				//if the NOE has been assigned with pair of labels w/ resoance, and 
		    				//the current H1 is from unassiged resonance, do nothing
		    				/*if (assignedFromAsgCS && (!isAssg))
		    					continue;*/
		    				
		    				//xplor format:
		    				xplorNoeStr = xplorNoeStatement_old(resNo1, "HN", resNo2, res, nucleus, dis1[0],disUpper);
		    				//System.out.println(xplorNoeStr); //for only printing out relative noes
		    				
	 	    				// for comparison:
		    				//CS1 of NOE, CS2 of NOE, atom1, resNo1,  atom2, resNo2, distance.
		    				strOutput=String.valueOf(noeCSHN)+"  "+String.valueOf(noeCSH1)+"  "+ aaType+"-HN"+ " "+ String.valueOf(resNo1)+
		    				"  "+ res+"-"+nucleus + "  "+ String.valueOf(resNo2) + "  "+ disUpper[0]+"  "+ String.valueOf(isAssg)+"  "+ String.valueOf(isSymm)+" "+ String.valueOf(found); 
		    				
		    				/*if (isAssg)//from assigend resonances, then...
		    				{
		    					if (isSymm)
		    					{
		    						System.out.println(strOutput);
		    						assigned = true;
		    						assignedFromAsgCS=true;
		    						if (found)
		    							crNOEAsg=crNOEAsg+1;
		    						else 
		    							wrNOEAsg=wrNOEAsg+1;
		    					}
		    				}*/
		    				//else//from unassiged resonances, don't need to check backNOE
		    				//{
		    					System.out.println(strOutput);
		    					assigned = true;
		    					if (found)
	    							crNOEAsg=crNOEAsg+1;
	    						else 
	    							wrNOEAsg=wrNOEAsg+1;
		    				//}
	 				
	
		    				
		    			}

		    		}//if (hasNOE)
		    		

		    	}//for (k=0; k < bVec.size(); k++)
		    	
		    	if (!assigned)
		    	{
		    		System.out.println("NO Assign by CS  "+hnNoe);
		    	}
	
		    }//for(j=0; j<oneHnVec.size(); j++)
	 	}
		System.out.println("/////////////////////////////////////////////// ");
		System.out.println("The number of correct HN-NOE assignment is:  "+crNOEAsg);
		System.out.println("The number of wrong HN NOE assignment is:  "+wrNOEAsg);
		System.out.println(" ///////////////////////////////////////////////");
    }



    /**
     * an NOE assignment method, filtered by Structure.
     * 
     * @param h1Vec a sorted array of all protons
     * @param asgVec an array of Assign object for all the residues
     * @param pdbVec the backbone structure used to filter the assignment
     * @param pdbVecXray the Xray structure of ubiquitin
     * @param hnNoeVec the hn noe vec
     * @param cNoeVec the c noe vec
     */
    public void noeAssign2nd(final Vector h1Vec, final Vector asgVec, Vector pdbVec, Vector pdbVecXray,Vector hnNoeVec, Vector cNoeVec)
    {
    	int crNOEAsg=0;
    	int wrNOEAsg=0;
    	int nonNOEAsg=0;
		int i = 0, j = 0, k = 0;
		//int kk=0;//added by zeng
		
		Vector oneHnVec = new Vector();
	 	Vector oneHaVec = new Vector();
	 	Vector oneH1Vec = new Vector();
		Assign asg  = new Assign();
		Peak   pk   = new Peak();
		Pdb pp = new Pdb();
		double h1Err = 0.04;
		double csOfB = 0.0; //the CS of the NOE partner 
		
		////added by zeng
		double haErr=0.02;
		double chkErr=0.04;
		/*
		String src0   = "./inputFiles/"; 
		String pdbFile0 = src0+"ubqByRdc1005.pdb";
    	Vector pdbVec0  = pp.readPdb(pdbFile0);
    	String pdbFile2 = src0+"1UBQH.pdb";
    	Vector pdbVec2  = pp.readPdb(pdbFile2);
    	Vector pdbVec3 = pp.residueNameUpdate(pdbVec2, pdbVec0);
//       	pp.print(pdbVec3);
    	Vector pdbVecRef = pp.nameConvertCS(pdbVec3);
    	Collections.sort(pdbVecRef, new Pdb.PdbComparator());
    	*/
    	 //will be used for refining rotamer library
    			
		HnNoe hnNoe = new HnNoe();
		int resNo1 = 0,  resNo2 = 0,  resNo3 = 0;
		Vector bVec = new Vector();
		Vector bVecTemp = new Vector();//added by zeng
		Vector bVecTemp2=new Vector(); //added by zeng

		Vector cVec = new Vector();
		String resId = "", aaType ="", nucleus, res = "";
		int index = 0;
		HcchTocsy hcch = new HcchTocsy();
		double[] dis1 = new double[1]; //for saving the back-computed NOEs
		dis1[0] = 0.0;
		boolean hasNOE = false;
		boolean assigned = false;
		boolean assignedFromAsgCS=false;
		boolean found = false;
		int minIndex = 0;
		double minDis = 0.0;
		Vector pkVec = new Vector();
		System.out.println(" ! The NOEs Assignment from N15 NOESY");
		double noeLimits  = 5.5;
		double [] noeXray = new double[1]; //for saving the NOE distance from the X-ray structure
		double [] noeXray2 = new double[1]; 
		String xplorNoeStr ="";
		String strOutput = "";
		double [] disUpper= new double[1];

		Map aMap = new TreeMap();
		double csRes1=0.0;
		double csRes2=0.0;
		boolean isSymm= false;
		double simCSH=0.0;
		boolean isAssg= true;
		double noeCSHN=0.0;
		double noeCSH1=0.0;
		
		String src   = "../inputFiles/rotasamp-small/"; //The directory has the input files
	 	String rotamFile; 
	 	Vector pdbRotamA =new Vector();
	 	Vector pdbRotamB=new Vector();
	 	Vector pdbRotamNewA =new Vector();
	 	Vector pdbRotamNewB =new Vector();
	 	Vector pdbRotamNewA2 =new Vector();
	 	Vector pdbRotamNewB2 =new Vector();
	 	Vector pdbRotamNewARef =new Vector();
	 	Vector pdbRotamNewBRef =new Vector();
	 	int ind1=0;
	 	Pdb pdbA, pdbARef;
	 	RotaPattern rp=new RotaPattern();
	 	
		for(i=0; i<asgVec.size(); i++)
		{
			//System.out.print("i="+i+"\n");
			asg = (Assign)asgVec.elementAt(i);
		    aMap=asg.getMap();
		    csRes1 = ((Double)aMap.get("HN")).doubleValue();
		    
		    oneHnVec = asg.getHnNoeVec();
	 	    oneHaVec = asg.getHaNoeVec();
		    // 	    oneH1Vec = asg.getH1NoeVec(); //for NOEs originating from protons other than HA and HN
		    resNo1 = asg.getResidueNo();
		    aaType = asg.getResidueType();
	// 	    System.out.println();
	 	   // System.out.println("!  "+aaType+"  "+resNo1);
		    bVec = new Vector();
		    bVecTemp = new Vector();//added by zeng
		    
		    for(j=0; j<oneHnVec.size(); j++)
		    {
		    	bVec = new Vector();
		    	hnNoe = (HnNoe) oneHnVec.elementAt(j);
		    	csOfB = hnNoe.getH1();
		    	noeCSHN=hnNoe.getHN();
		    	noeCSH1=hnNoe.getH1();
		    	bVec = rangeSearch(h1Vec, csOfB, h1Err); //retrun a set of possible NOE assignment based solely on CS
				if (bVec.isEmpty()){
				    //System.out.println("NO Assign by CS  "+hnNoe);
				    //break; //change here from LW's original code
					continue;
				}
		    	/*bVecTemp = rangeSearch(h1Vec, csOfB, h1Err); //retrun a set of possible NOE assignment based solely on CS
		    	if (bVecTemp.isEmpty())
		    	{
		    		System.out.println("NO Assign by CS  "+hnNoe);
		    		break;
		    	}
			
		    	
		    	//added by zeng, add possible candidates from assigned resonances
		    	for (k=0;k<bVecTemp.size(); k++)
		    	{
		    		pk = (Peak)bVecTemp.elementAt(k);
		    		resId = pk.getNucleus();
		    		index = resId.indexOf("-");
		    		resNo2 = Integer.parseInt(resId.substring(3, index)); //"3" see the method rangeSearch
		    		res    = resId.substring(0, 3);
		    		nucleus = resId.substring(index+1);
		    		//csOfB=pk.getCS();
		    		
		    		if (!res.equalsIgnoreCase("DMP"))
		    		{
		    			bVec.add(pk);
		    			
		    		}
		    		
		    	}
		    	
		    	//added from unassigned resonances 
		    	bVecTemp2 = new Vector();
   			 
    			bVecTemp2=pk.ringResonanceAsg(csOfB, haErr );
    			bVec.addAll(bVecTemp2);	*/
    			  			
    			double [] allDis = new double[bVec.size()]; //for saving the NOEs in case no NOE <6.00\AA
		    	assigned = false;
		    	assignedFromAsgCS=false;
		    	for (k=0; k < bVec.size(); k++)
		    	{
		    		isSymm=false;
		    		
		       		pk = (Peak)bVec.elementAt(k);
		    		resId = pk.getNucleus();
		    		index = resId.indexOf("-");
		    		resNo2 = Integer.parseInt(resId.substring(3, index)); //"3" see the method rangeSearch
		    		res    = resId.substring(0, 3);
		    		nucleus = resId.substring(index+1);
		    		if(nucleus.equalsIgnoreCase("HN"))
		    			nucleus="H";
		    		csRes2=pk.getCS();
		    		isAssg=pk.getIsAssg();
		    		
		    		pdbRotamNewA =new Vector();
		    		pdbRotamNewA2=new Vector();
	// 		    System.out.println("ID = "+ resNo1+"H <--> "+resNo2+"  "+res+"  "+nucleus);
		    		if (aaType.equalsIgnoreCase("GLY"))
		    		{
		    			
		    			ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
		    			pdbA = (Pdb)pdbVec.elementAt(ind1);
		    			//pdbARef=(Pdb)pdbVecRef.elementAt(ind1);
		    			pdbRotamNewA.add(pdbA);
		    			//pdbRotamNewA2.add(pdbARef);
		    			
		    		}
		    		else
		    		{
			    		rotamFile=src+ aaType.toLowerCase()+ ".pdb"; 
			    		pdbRotamA=pp.readPdb(rotamFile);
			    		//pdbRotamNewA=pp.nameConvert(pdbRotamA);
			    		pdbRotamNewA=pp.nameConvert4SmallRotLibCS(pdbRotamA);
			    	//pdbRotamNewA=pp.nameConvertCS(pdbRotamA);
			    	//pdbRotamNewA2=pp.nameConvert4SmallRotLibCS(pdbRotamA);//need to change for large rotamer library
		    		}
		    		
		    		pdbRotamNewB =new Vector();
		    		pdbRotamNewB2=new Vector();
		    		if( res.equalsIgnoreCase("GLY"))
		    		{
		    			
		    			ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
		    			pdbA = (Pdb)pdbVec.elementAt(ind1);
		    			pdbARef=(Pdb) pdbVec.elementAt(ind1);
		    			pdbRotamNewB.add(pdbA);
		    			pdbRotamNewB2.add(pdbARef);
		    		}
		    		else
		    		{
			    		rotamFile=src+ res.toLowerCase()+ ".pdb"; 
			    		pdbRotamB=pp.readPdb(rotamFile);
			    		//pdbRotamNewB=pp.nameConvert(pdbRotamB);
			    		pdbRotamNewB=pp.nameConvert4SmallRotLibCS(pdbRotamB);
			    		//pdbRotamNewB=pp.nameConvertCS(pdbRotamB);
			    		//pdbRotamNewB2=pp.nameConvert4SmallRotLibCS(pdbRotamB);//need to change for large rotamer library
		    		}
		    		
		    		///////////////////////////////////////////////
		    		//here we refine the rotamer library using back-computed NOE patterns
		    		int indRef1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
		    		int indRef2 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
		        	int[] index_temp=new int[2];
		    		if (!(indRef1<0))
		        		pdbRotamNewARef=rp.RefineRotLib(pdbRotamNewA,pdbVec,asgVec, hnNoeVec, cNoeVec,resNo1,6.0, 1,index_temp,pdbVecXray);
		    		if (!(indRef2<0))
		    			pdbRotamNewBRef=rp.RefineRotLib(pdbRotamNewB,pdbVec,asgVec, hnNoeVec, cNoeVec,resNo2,6.0,1,index_temp,pdbVecXray);
		    		//we don't need to change nucleus here, since it has been consisitent with resonance list
		    		//if (nucleus.length()>3)
		    			//nucleus=nucleus.substring(0,3);////need to check here...
		    		///////////////////////////////////////////////
		    		
		    		/*
		    		//for debugging
		    		Vector vecTempA=new Vector();
		    		vecTempA.add(pdbRotamNewA.elementAt(Math.min(1,pdbRotamNewA.size()-1)));
		    		Vector vecTempB=new Vector();
		    		vecTempB.add(pdbRotamNewB.elementAt(Math.min(1,pdbRotamNewB.size()-1)));
		    		 	*/
		    		
		    		//hasNOE=pp.measureDisFromRotam(pdbVec, pdbRotamNewARef, pdbRotamNewBRef,resNo1, aaType, "H", resNo2, res, nucleus, dis1);
		    		//hasNOE=pp.measureDisFromRotam(pdbVec, pdbRotamNewA, pdbRotamNewB,resNo1, aaType, "H", resNo2, res, nucleus, dis1);
		    		hasNOE=pp.measureDisFromRotam(pdbVecXray, pdbRotamNewARef, pdbRotamNewBRef,resNo1, aaType, "H", resNo2, res, nucleus, dis1);
		    		
		    		//hasNOE = pp.measureDis(pdbVec, resNo1, aaType, "H", resNo2, res, nucleus, dis1);
		    		allDis[k] = dis1[0];
		    		if (hasNOE)
		    		{
		    			found = checkNoe_old(pdbVecXray, asgVec, resNo1,"H", resNo2, nucleus, noeLimits, Const.methylCorrection, noeXray); 
	 			
		    			/*if (isAssg)
		    			{
		    				// use symmetry to check whether there is another NOE from side-chain to HN
		    				isSymm=CheckBackNOE(hnNoeVec, haNoeVec,csAllAsg,resNo1,aaType,"H",resNo2,res, nucleus,chkErr);
		    			}*/
		    			
		    			if ((dis1[0] <= 6.0) )
		    			{
		    				//if the NOE has been assigned with pair of labels w/ resoance, and 
		    				//the current H1 is from unassiged resonance, do nothing
		    				/*if (assignedFromAsgCS && (!isAssg))
		    					continue;*/
		    				
		    				//xplor format:
		    				xplorNoeStr = xplorNoeStatement_old(resNo1, "HN", resNo2, res, nucleus, dis1[0],disUpper);
		    				//System.out.println(xplorNoeStr); //for only printing out relative noes
		    				
	 	    				// for comparison:
		    				//CS1 of NOE, CS2 of NOE, atom1, resNo1,  atom2, resNo2, distance.
		    				strOutput=String.valueOf(noeCSHN)+"  "+String.valueOf(noeCSH1)+"  "+ aaType+"-HN"+ " "+ String.valueOf(resNo1)+
		    				"  "+ res+"-"+nucleus + "  "+ String.valueOf(resNo2) + "  "+ disUpper[0]+"  "+ String.valueOf(isAssg)+"  "+ String.valueOf(isSymm)+" "+ String.valueOf(found); 
		    				
		    				/*if (isAssg)//from assigend resonances, then...
		    				{
		    					if (isSymm)
		    					{
		    						System.out.println(strOutput);
		    						assigned = true;
		    						assignedFromAsgCS=true;
		    						if (found)
		    							crNOEAsg=crNOEAsg+1;
		    						else 
		    							wrNOEAsg=wrNOEAsg+1;
		    					}
		    				}*/
		    				//else//from unassiged resonances, don't need to check backNOE
		    				//{
		    				System.out.println(xplorNoeStr); //print our noe table for xplor
		    					//System.out.println(strOutput);
		    					assigned = true;
		    					if (found)
	    							crNOEAsg=crNOEAsg+1;
	    						else 
	    							wrNOEAsg=wrNOEAsg+1;
		    				//}
	 				
	
		    				
		    			}

		    		}//if (hasNOE)
		    		

		    	}//for (k=0; k < bVec.size(); k++)
		    	
		    	if (!assigned)
		    	{ 
		    		nonNOEAsg=nonNOEAsg+1;
		    		//System.out.println("NO Assign by CS  "+hnNoe);
		    	}
	
		    }//for(j=0; j<oneHnVec.size(); j++)
	 	}
		System.out.println("/////////////////////////////////////////////// ");
		System.out.println("The number of correct HN-NOE assignment is:  "+crNOEAsg);
		System.out.println("The number of wrong HN NOE assignment is:  "+wrNOEAsg);
		System.out.println("The number of not assigned peaks is:  "+ nonNOEAsg);
		System.out.println(" ///////////////////////////////////////////////");
    }

    /**
     * Lincong's original + rotamer library
     * an NOE assignment method, filtered by Structure.
     * 
     * @param h1Vec a sorted array of all protons
     * @param asgVec an array of Assign object for all the residues
     * @param pdbVec the backbone structure used to filter the assignment
     * @param pdbVecXray the Xray structure of ubiquitin
     * @param hnNoeVec the hn noe vec
     * @param cNoeVec the c noe vec
     */
    public void noeAssign3rdLW(final Vector h1Vec, final Vector asgVec, Vector pdbVec, Vector pdbVecXray,Vector hnNoeVec, Vector cNoeVec)
    {
    	int crNOEAsg=0;
    	int wrNOEAsg=0;
	   	int i = 0, j = 0, k = 0;
	   	Vector oneHnVec = new Vector();
	   	Vector oneHaVec = new Vector();
	 	Vector oneH1Vec = new Vector();
		Assign asg  = new Assign();
		Peak   pk   = new Peak();
		Pdb pp = new Pdb();
		double h1Err = 0.04;
		double csOfB = 0.0; //the CS of the NOE partner 
		HnNoe hnNoe = new HnNoe();
		int resNo1 = 0,  resNo2 = 0,  resNo3 = 0;
		Vector bVec = new Vector();
		Vector cVec = new Vector();
	
		////added by zeng
		double haErr=0.02;
		double chkErr=0.04;
		
		Vector cVecTemp = new Vector();//added by zeng
		Vector cVecTemp2=new Vector(); //added by zeng
		
		double [] disUpper= new double[1];
	
		String resId = "", aaType ="", nucleus, res = "";
		int index = 0;
		HcchTocsy hcch = new HcchTocsy();
		double[] dis1 = new double[1]; //for saving the back-computed NOEs
		dis1[0] = 0.0;
		boolean hasNOE = false;
		boolean assigned = false;
		boolean assignedFromAsgCS=false;
		boolean found = false;
		int minIndex = 0;
		double minDis = 0.0;
		Vector pkVec = new Vector();
		System.out.println(" ! Ha The NOEs Assignment from C13 NOESY");
		double noeLimits  = 5.0;
		double [] noeXray = new double[1];
		String xplorNoeStr ="";
		String strOutput = "";

		Map aMap = new TreeMap();
		double csRes1=0.0;
		double csRes2=0.0;
		boolean isSymm=false;
		boolean isAssg= true;
		
		double noeCSHA=0.0;
		double noeCSH1=0.0;
		
		String src   = "./inputFiles/rotasamp-small/"; //The directory has the input files
	 	String rotamFile; 
	 	Vector pdbRotamA =new Vector();
	 	Vector pdbRotamB=new Vector();
	 	Vector pdbRotamNewA =new Vector();
	 	Vector pdbRotamNewB =new Vector();
	 	int ind1=0;
	 	Pdb pdbA;
	 	
		for(i=0; i<asgVec.size(); i++)
		{
		    asg = (Assign)asgVec.elementAt(i);
		    oneHnVec = asg.getHnNoeVec();
	 	    oneHaVec = asg.getHaNoeVec();
	 	    aMap=asg.getMap();
		    csRes1 = ((Double)aMap.get("HN")).doubleValue();
		    
		    // 	    oneH1Vec = asg.getH1NoeVec();
		    resNo1 = asg.getResidueNo();
		    aaType = asg.getResidueType();
	 	    System.out.println("!  "+aaType+"  "+resNo1);
		    cVec = new Vector();
		    cVecTemp = new Vector();//added by zeng
		    
		    for(j=0; j<oneHaVec.size(); j++)
		    {
		    	cVec = new Vector();
		    	hcch = (HcchTocsy) oneHaVec.elementAt(j);
		    	csOfB = hcch.getH1();
		    	noeCSHA=hcch.getHA();
		    	noeCSH1=hcch.getH1();
		    	cVec = rangeSearch(h1Vec, csOfB, h1Err);
		    	if (cVec.isEmpty())
		    		System.out.println("NO Assign2:  "+hcch);
			/*
		    	///////added by zeng, for the new test without ring resonance assignments
		    	for (k=0;k<cVecTemp.size(); k++)
		    	{
		    		pk = (Peak)cVecTemp.elementAt(k);
		    		resId = pk.getNucleus();
		    		index = resId.indexOf("-");
		    		resNo2 = Integer.parseInt(resId.substring(3, index)); //"3" see the method rangeSearch
		    		res    = resId.substring(0, 3);
		    		nucleus = resId.substring(index+1);
		    		//csOfB=pk.getCS();
	    		
		    		if (!res.equalsIgnoreCase("DMP"))
		    		{
		    			cVec.add(pk);
		    			
		    		}//if (!res.equalsIgnoreCase("DMP"))	    		
		    	}//for (k=0;k<cVecTemp.size(); k++)
		    	
		    	cVecTemp2 = new Vector();
    			cVecTemp2=pk.ringResonanceAsg(csOfB, haErr );
    			cVec.addAll(cVecTemp2);*/
		    	
    			assigned = false;
    			assignedFromAsgCS=false;
    			
			   	for (k=0; k<cVec.size(); k++)
			   	{
					isSymm=false;
				    pk = (Peak)cVec.elementAt(k);
				    resId = pk.getNucleus();
				    index = resId.indexOf("-");
				    resNo3 = Integer.parseInt(resId.substring(3, index));
				    index = resId.indexOf("-");
				    resNo2 = Integer.parseInt(resId.substring(3, index));
				    res = resId.substring(0, 3);
				    nucleus = resId.substring(index+1);
				    csRes2=pk.getCS();
				    isAssg=pk.getIsAssg();
				    
				    
		    		if (aaType.equalsIgnoreCase("ALA")||aaType.equalsIgnoreCase("GLY"))
		    		{
		    			pdbRotamNewA =new Vector();
		    			ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
		    			pdbA = (Pdb)pdbVec.elementAt(ind1);
		    			pdbRotamNewA.add(pdbA);
		    			
		    		}
		    		else
		    		{
			    		rotamFile=src+ aaType.toLowerCase()+ ".pdb"; 
			    		pdbRotamA=pp.readPdb(rotamFile);
			    		pdbRotamNewA=pp.nameConvert(pdbRotamA);
		    		}
		    		
		    		if(res.equalsIgnoreCase("ALA")|| res.equalsIgnoreCase("GLY"))
		    		{
		    			pdbRotamNewB =new Vector();
		    			ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
		    			pdbA = (Pdb)pdbVec.elementAt(ind1);
		    			pdbRotamNewB.add(pdbA);
		    		}
		    		else
		    		{
			    		rotamFile=src+ res.toLowerCase()+ ".pdb"; 
			    		pdbRotamB=pp.readPdb(rotamFile);
			    		pdbRotamNewB=pp.nameConvert(pdbRotamB);
		    		}
		    		
		    		//if(res.equalsIgnoreCase("ALA")|| res.equalsIgnoreCase("GLY"))
		    		//	hasNOE = pp.measureDis(pdbVec, resNo1, aaType, "HA", resNo2, res, nucleus, dis1);
		    		//else
		    			hasNOE=pp.measureDisFromRotam(pdbVec, pdbRotamNewA, pdbRotamNewB,resNo1, aaType, "H", resNo2, res, nucleus, dis1);
		    		
		    		
				   // hasNOE = pp.measureDis(pdbVec, resNo1, aaType, "HA", resNo2, res, nucleus, dis1);
		
				    if(hasNOE)
				    {
	
				    	found = checkNoe_old(pdbVecXray, asgVec, resNo1,"HA", resNo2, nucleus, noeLimits, Const.methylCorrection, noeXray); 
			 			
		    			/*if (isAssg)
		    			{
		    				// use symmetry to check whether there is another NOE from side-chain to HN
		    				isSymm=CheckBackNOE(hnNoeVec, haNoeVec,csAllAsg,resNo1,aaType,"H",resNo2,res, nucleus,chkErr);
		    			}*/
		    			
		    			if ((dis1[0] <= 6.00) )
		    			{
		    				//if (assignedFromAsgCS && (!isAssg))
		    				//	continue;
		    				
		    				 if (!nucleus.equals("HN"))
		    				 {
		    						xplorNoeStr = xplorNoeStatement_old(resNo1, "HA", resNo2, res, nucleus, dis1[0]-0.4,disUpper);
		    		    			
		    					 //xplorNoeStr = xplorNoeStatement(resNo1, "HA", resNo2, res, nucleus, dis1[0] - 0.40);
		    					 //for comparison:
		    					 strOutput=String.valueOf(noeCSHA)+"  "+String.valueOf(noeCSH1)+"  "+ aaType+"-HA"+ " "+ String.valueOf(resNo1)+
		    						"  "+ res+"-"+nucleus + "  "+ String.valueOf(resNo2) + "  "+ disUpper[0]+"  "+ String.valueOf(isAssg)+"  "+ String.valueOf(isSymm)+" "+ String.valueOf(found); 
				    				
		    				 }//if (!nucleus.equals("HN"))
		    				
		    				 //System.out.println(strOutput);
		    				/*if (isAssg)//from assigend resonances, then...
		    				{
		    					if (isSymm)
		    					{
		    						System.out.println(strOutput);
		    						assigned = true;
		    						assignedFromAsgCS=true;
		    						if (found)
		    							crNOEAsg=crNOEAsg+1;
		    						else 
		    							wrNOEAsg=wrNOEAsg+1;
		    					}
		    				}*/
		    				//else//from unassiged resonances, don't need to check backNOE
		    				//{
		    					System.out.println(strOutput);
		    					assigned = true;
		    					if (found)
	    							crNOEAsg=crNOEAsg+1;
	    						else 
	    							wrNOEAsg=wrNOEAsg+1;
		    				//}
		    				
		    				
		    			}//if ((dis1[0] <= 6.00) )
		    			
				    }//if(hasNOE)
				    
			   	}//for (k=0; k<cVec.size(); k++)
			   	if (!assigned)
			   		System.out.println("NO Assign by CS  "+hcch);
		    }// for(j=0; j<oneHaVec.size(); j++)
		    
		}//for(i=0; i<asgVec.size(); i++)
		System.out.println("/////////////////////////////////////////////// ");
		System.out.println("The number of correct Ha NOE assignment is:  "+crNOEAsg);
		System.out.println("The number of wrong Ha NOE assignment is:  "+wrNOEAsg);
		System.out.println(" ///////////////////////////////////////////////");
    }
 
    /**
     * an NOE assignment method, filtered by Structure.
     * 
     * @param h1Vec a sorted array of all protons
     * @param asgVec an array of Assign object for all the residues
     * @param pdbVec the backbone structure used to filter the assignment
     * @param pdbVecXray the Xray structure of ubiquitin
     * @param hnNoeVec the hn noe vec
     * @param cNoeVec the c noe vec
     */
    public void noeAssign3rd(final Vector h1Vec, final Vector asgVec, Vector pdbVec, Vector pdbVecXray,Vector hnNoeVec, Vector cNoeVec)
    {
    	int crNOEAsg=0;
    	int wrNOEAsg=0;
    	int nonNOEAsg=0;
	   	int i = 0, j = 0, k = 0;
	   	Vector oneHnVec = new Vector();
	   	Vector oneHaVec = new Vector();
	 	Vector oneH1Vec = new Vector();
		Assign asg  = new Assign();
		Peak   pk   = new Peak();
		Pdb pp = new Pdb();
		double h1Err = 0.04;
		double csOfB = 0.0; //the CS of the NOE partner 
		HnNoe hnNoe = new HnNoe();
		int resNo1 = 0,  resNo2 = 0,  resNo3 = 0;
		Vector bVec = new Vector();
		Vector cVec = new Vector();
	
		////added by zeng
		double haErr=0.02;
		double chkErr=0.04;
		
		Vector cVecTemp = new Vector();//added by zeng
		Vector cVecTemp2=new Vector(); //added by zeng
		
		double [] disUpper= new double[1];
	
		String resId = "", aaType ="", nucleus, res = "";
		int index = 0;
		HcchTocsy hcch = new HcchTocsy();
		double[] dis1 = new double[1]; //for saving the back-computed NOEs
		dis1[0] = 0.0;
		boolean hasNOE = false;
		boolean assigned = false;
		boolean assignedFromAsgCS=false;
		boolean found = false;
		int minIndex = 0;
		double minDis = 0.0;
		Vector pkVec = new Vector();
		System.out.println(" ! Ha The NOEs Assignment from C13 NOESY");
		double noeLimits  = 5.0;
		double [] noeXray = new double[1];
		String xplorNoeStr ="";
		String strOutput = "";

		Map aMap = new TreeMap();
		double csRes1=0.0;
		double csRes2=0.0;
		boolean isSymm=false;
		boolean isAssg= true;
		
		double noeCSHA=0.0;
		double noeCSH1=0.0;
		
		String src   = "../inputFiles/rotasamp-small/"; //The directory has the input files
	 	String rotamFile; 
	 	Vector pdbRotamA =new Vector();
	 	Vector pdbRotamB=new Vector();
	 	Vector pdbRotamNewA =new Vector();
	 	Vector pdbRotamNewB =new Vector();
	 	int ind1=0;
	 	Pdb pdbA;
	 	RotaPattern rp=new RotaPattern();
	 	Vector pdbRotamNewARef =new Vector();
	 	Vector pdbRotamNewBRef =new Vector();

	 	
		for(i=0; i<asgVec.size(); i++)
		{
		    asg = (Assign)asgVec.elementAt(i);
		    oneHnVec = asg.getHnNoeVec();
	 	    oneHaVec = asg.getHaNoeVec();
	 	    aMap=asg.getMap();
		    csRes1 = ((Double)aMap.get("HN")).doubleValue();
		    
		    // 	    oneH1Vec = asg.getH1NoeVec();
		    resNo1 = asg.getResidueNo();
		    aaType = asg.getResidueType();
	 	  ///  System.out.println("!  "+aaType+"  "+resNo1);
		    cVec = new Vector();
		    cVecTemp = new Vector();//added by zeng
		    
		    for(j=0; j<oneHaVec.size(); j++)
		    {
		    	cVec = new Vector();
		    	hcch = (HcchTocsy) oneHaVec.elementAt(j);
		    	csOfB = hcch.getH1();
		    	noeCSHA=hcch.getHA();
		    	noeCSH1=hcch.getH1();
		    	cVec = rangeSearch(h1Vec, csOfB, h1Err);
		    	//if (cVec.isEmpty())
		    		//System.out.println("NO Assign2:  "+hcch);
			/*
		    	///////added by zeng, for the new test without ring resonance assignments
		    	for (k=0;k<cVecTemp.size(); k++)
		    	{
		    		pk = (Peak)cVecTemp.elementAt(k);
		    		resId = pk.getNucleus();
		    		index = resId.indexOf("-");
		    		resNo2 = Integer.parseInt(resId.substring(3, index)); //"3" see the method rangeSearch
		    		res    = resId.substring(0, 3);
		    		nucleus = resId.substring(index+1);
		    		//csOfB=pk.getCS();
	    		
		    		if (!res.equalsIgnoreCase("DMP"))
		    		{
		    			cVec.add(pk);
		    			
		    		}//if (!res.equalsIgnoreCase("DMP"))	    		
		    	}//for (k=0;k<cVecTemp.size(); k++)
		    	
		    	cVecTemp2 = new Vector();
    			cVecTemp2=pk.ringResonanceAsg(csOfB, haErr );
    			cVec.addAll(cVecTemp2);*/
		    	
    			assigned = false;
    			assignedFromAsgCS=false;
    			
			   	for (k=0; k<cVec.size(); k++)
			   	{
					isSymm=false;
				    pk = (Peak)cVec.elementAt(k);
				    resId = pk.getNucleus();
				    index = resId.indexOf("-");
				    resNo3 = Integer.parseInt(resId.substring(3, index));
				    index = resId.indexOf("-");
				    resNo2 = Integer.parseInt(resId.substring(3, index));
				    res = resId.substring(0, 3);
				    nucleus = resId.substring(index+1);
				    csRes2=pk.getCS();
				    isAssg=pk.getIsAssg();
				    
				    pdbRotamNewA =new Vector();
		    		//pdbRotamNewA2=new Vector();
		    		if (aaType.equalsIgnoreCase("GLY"))
		    		{
		    			pdbRotamNewA =new Vector();
		    			ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
		    			pdbA = (Pdb)pdbVec.elementAt(ind1);
		    			pdbRotamNewA.add(pdbA);
		    		}
		    		else
		    		{
			    		rotamFile=src+ aaType.toLowerCase()+ ".pdb"; 
			    		pdbRotamA=pp.readPdb(rotamFile);
			    		pdbRotamNewA=pp.nameConvert4SmallRotLibCS(pdbRotamA);//changed here...			    		
		    		}
		    		
		    		pdbRotamNewB =new Vector();
		    		if( res.equalsIgnoreCase("GLY"))
		    		{
		    			pdbRotamNewB =new Vector();
		    			ind1 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
		    			pdbA = (Pdb)pdbVec.elementAt(ind1);
		    			pdbRotamNewB.add(pdbA);
		    		}
		    		else
		    		{
			    		rotamFile=src+ res.toLowerCase()+ ".pdb"; 
			    		pdbRotamB=pp.readPdb(rotamFile);
			    		pdbRotamNewB=pp.nameConvert4SmallRotLibCS(pdbRotamB);//changed here...
		    		}
		    		
		    		
		    		///////////////////////////////////////////////
		    		//here we refine the rotamer library using back-computed NOE patterns
		    		int indRef1 = Collections.binarySearch(pdbVec, new Pdb(resNo1), new Pdb.PdbComparator());
		    		int indRef2 = Collections.binarySearch(pdbVec, new Pdb(resNo2), new Pdb.PdbComparator());
		        	int[] index_temp=new int[2];
		    		if (!(indRef1<0))
		        		pdbRotamNewARef=rp.RefineRotLib(pdbRotamNewA,pdbVec,asgVec, hnNoeVec, cNoeVec,resNo1,6.0, 1,index_temp,pdbVecXray);
		    		if (!(indRef2<0))
		    			pdbRotamNewBRef=rp.RefineRotLib(pdbRotamNewB,pdbVec,asgVec, hnNoeVec, cNoeVec,resNo2,6.0,1,index_temp,pdbVecXray);
		    		//we don't need to change nucleus here, since it has been consisitent with resonance list
		    		
		    		///////////////////////////////////////////////
		    		
		    		
		    		/*
		    		//for debugging
		    		Vector vecTempA=new Vector();
		    		vecTempA.add(pdbRotamNewA.elementAt(Math.min(1,pdbRotamNewA.size()-1)));
		    		Vector vecTempB=new Vector();
		    		vecTempB.add(pdbRotamNewB.elementAt(Math.min(1,pdbRotamNewB.size()-1)));
		    		 	*/

		    		
		    		//if(res.equalsIgnoreCase("ALA")|| res.equalsIgnoreCase("GLY"))
		    		//	hasNOE = pp.measureDis(pdbVec, resNo1, aaType, "HA", resNo2, res, nucleus, dis1);
		    		//else
		    			hasNOE=pp.measureDisFromRotam(pdbVec, pdbRotamNewARef, pdbRotamNewBRef,resNo1, aaType, "HA", resNo2, res, nucleus, dis1);
		    	//////be careful of H or HA	
		    		
				   // hasNOE = pp.measureDis(pdbVec, resNo1, aaType, "HA", resNo2, res, nucleus, dis1);
		
				    if(hasNOE)
				    {
	
				    	found = checkNoe_old(pdbVecXray, asgVec, resNo1,"HA", resNo2, nucleus, noeLimits, Const.methylCorrection, noeXray); 
			 			
		    			/*if (isAssg)
		    			{
		    				// use symmetry to check whether there is another NOE from side-chain to HN
		    				isSymm=CheckBackNOE(hnNoeVec, haNoeVec,csAllAsg,resNo1,aaType,"H",resNo2,res, nucleus,chkErr);
		    			}*/
		    			
		    			if ((dis1[0] <= 6.00) )
		    			{
		    				//if (assignedFromAsgCS && (!isAssg))
		    				//	continue;
		    				
		    				 if (!nucleus.equals("HN"))
		    				 {
		    						xplorNoeStr = xplorNoeStatement_old(resNo1, "HA", resNo2, res, nucleus, dis1[0]-0.4,disUpper);
		    		    			
		    					 //xplorNoeStr = xplorNoeStatement(resNo1, "HA", resNo2, res, nucleus, dis1[0] - 0.40);
		    					 //for comparison:
		    					 strOutput=String.valueOf(noeCSHA)+"  "+String.valueOf(noeCSH1)+"  "+ aaType+"-HA"+ " "+ String.valueOf(resNo1)+
		    						"  "+ res+"-"+nucleus + "  "+ String.valueOf(resNo2) + "  "+ disUpper[0]+"  "+ String.valueOf(isAssg)+"  "+ String.valueOf(isSymm)+" "+ String.valueOf(found); 
				    				
		    				 }//if (!nucleus.equals("HN"))
		    				
		    				 //System.out.println(strOutput);
		    				/*if (isAssg)//from assigend resonances, then...
		    				{
		    					if (isSymm)
		    					{
		    						System.out.println(strOutput);
		    						assigned = true;
		    						assignedFromAsgCS=true;
		    						if (found)
		    							crNOEAsg=crNOEAsg+1;
		    						else 
		    							wrNOEAsg=wrNOEAsg+1;
		    					}
		    				}*/
		    				//else//from unassiged resonances, don't need to check backNOE
		    				//{
		    				 System.out.println(xplorNoeStr);
		    					//System.out.println(strOutput);
		    					assigned = true;
		    					if (found)
	    							crNOEAsg=crNOEAsg+1;
	    						else 
	    							wrNOEAsg=wrNOEAsg+1;
		    				//}
		    				
		    				
		    			}//if ((dis1[0] <= 6.00) )
		    			
				    }//if(hasNOE)
				    
			   	}//for (k=0; k<cVec.size(); k++)
			   	if (!assigned)
			   	{
			   		nonNOEAsg=nonNOEAsg+1;
			   		//System.out.println("NO Assign by CS  "+hcch); ///for only printing our noe table for xplor
			   	}
		    }// for(j=0; j<oneHaVec.size(); j++)
		    
		}//for(i=0; i<asgVec.size(); i++)
		System.out.println("/////////////////////////////////////////////// ");
		System.out.println("The number of correct Ha NOE assignment is:  "+crNOEAsg);
		System.out.println("The number of wrong Ha NOE assignment is:  "+wrNOEAsg);
		System.out.println("The number of not assigned peaks is:  "+ nonNOEAsg);
		System.out.println(" ///////////////////////////////////////////////");
    }

    
    /**
     * check whether there exists a symmetric Noe from side-chains to other protons.
     * 
     * @param scNoe the sc noe
     * @param csBbH the cs bb h
     * @param csScH the cs sc h
     * @param winErr the win err
     * 
     * @return  all the Peak objects within the specified range
     */
    public boolean checkSymmetry(final Vector scNoe, double csBbH, double csScH, double winErr)
    {
    	int i,j;
    	ScNoe scNoeTemp=new ScNoe();
    	boolean isSymm=false;
    	
    	for (i=0; i<scNoe.size(); i++)
    	{
    		scNoeTemp=(ScNoe)scNoe.elementAt(i);
    		if ( (scNoeTemp.getHCS1() >= csScH- winErr) && (scNoeTemp.getHCS1()<= csScH+ winErr))
    		{	
    			if((scNoeTemp.getHCS2()>= csBbH-winErr) && (scNoeTemp.getHCS2()<= csBbH+winErr)  )
    				isSymm=true;
    		}
    	}
    	
    	return isSymm;
    }
	
    /**
     * check whether there exists a back Noe from H2 to H1.
     * 
     * @param hnNoeVec the hn noe vec
     * @param haNoeVec the ha noe vec
     * @param csAllAsg the cs all asg
     * @param resNo1 the res no1
     * @param resName1 the res name1
     * @param atomName1 the atom name1
     * @param resNo2 the res no2
     * @param resName2 the res name2
     * @param atomName2 the atom name2
     * @param chkErr the chk err
     * 
     * @return  all the Peak objects within the specified range
     */
    public boolean CheckBackNOE(final Vector hnNoeVec,final Vector haNoeVec,final Vector csAllAsg, 
    		int resNo1, String resName1, String atomName1, 
    		int resNo2, String resName2, String atomName2, double chkErr)
    {
    	boolean isBackNoe=false;
    	int i,j;
    	String heavyName2="";
    	H1CS cs=new H1CS();
    	int res_no;
    	String res_name="";
    	String atom_name="";
    	double db_cs,db_csH1=0.0, db_csH2=0.0,db_csHeavy2=0.0;
    	
    	HnNoe hnNoe=new HnNoe();
    	HcchTocsy hcchTocsy=new HcchTocsy();
    	
    	heavyName2=GetHeavyAtomFromProton(resName2,atomName2);
    	
    	for (i=0; i<csAllAsg.size(); i++)
    	{
    		cs=(H1CS)csAllAsg.elementAt(i);
    		res_no=cs.getResidueNo();
    		res_name=cs.getResidueType();
    		atom_name=cs.getAtomName();
    		db_cs=cs.getH1CS();
    		
    		if (res_no==resNo1 && res_name.equalsIgnoreCase(resName1) && atom_name.equalsIgnoreCase(atomName1))
    			db_csH1=db_cs; 
    		
    		if (res_no==resNo2 && res_name.equalsIgnoreCase(resName2) && atom_name.equalsIgnoreCase(atomName2))
    			db_csH2=db_cs;
    		
    		if (res_no==resNo2 && res_name.equalsIgnoreCase(resName2) && atom_name.equalsIgnoreCase(heavyName2))
    			db_csHeavy2=db_cs;   		
    	}//for (i=0; i<csAllAsg.size(); i++)
    	
    	double dbTempH1,dbTempH2, dbTempHeavy1;
    	if (heavyName2.substring(0,1).equalsIgnoreCase("N"))
		{
			for (i=0;i<hnNoeVec.size();i++)
			{
				hnNoe=(HnNoe)hnNoeVec.elementAt(i);
				dbTempH1=hnNoe.getHN();
				dbTempHeavy1=hnNoe.getN15();
				dbTempH2=hnNoe.getH1();
				
				if (Math.abs(dbTempHeavy1 - db_csHeavy2 ) < chkErr && Math.abs(dbTempH1-db_csH2)<chkErr
						&& Math.abs(dbTempH2-db_csH1)<chkErr)
					isBackNoe=true;				
			}//for (i=0;i<hnNoeVec.size();i++)
		}//if (heavyName2.substring(0,1).equalsIgnoreCase("N"))
    	if (heavyName2.substring(0,1).equalsIgnoreCase("C"))
		{
    		for (i=0;i<haNoeVec.size();i++)
    		{
    			hcchTocsy=(HcchTocsy)haNoeVec.elementAt(i);
    			dbTempH1=hcchTocsy.getHA();
    			dbTempHeavy1=hcchTocsy.getC13();
    			dbTempH2=hcchTocsy.getH1();
    			
    			if (Math.abs(dbTempHeavy1 - db_csHeavy2 ) < chkErr && Math.abs(dbTempH1-db_csH2)<chkErr
						&& Math.abs(dbTempH2-db_csH1)<chkErr)
					isBackNoe=true;	
    			
    		}//for (i=0;i<haNoeVec.size();i++)
		}
    	
    	return isBackNoe;
    	
    	
    }
    
    /**
     * check whether a residue is a hydrophobic amino acid.
     * 
     * @param resName the res name
     * 
     * @return  yes if distance is less than noe limit, otherwise no
     */  	
    public boolean isHydrophobic(String resName)
    {
    	if(resName.equalsIgnoreCase("VAL")|| resName.equalsIgnoreCase("ILE")||resName.equalsIgnoreCase("LEU")||
    			resName.equalsIgnoreCase("MET")||resName.equalsIgnoreCase("PHE")||resName.equalsIgnoreCase("TRP")||
    			resName.equalsIgnoreCase("CYS") || resName.equalsIgnoreCase("ALA")|| resName.equalsIgnoreCase("TYR")||
    			resName.equalsIgnoreCase("HIS"))
    		return true;
    	else 
    		return false;
    	
    }
    
    /**
     * check whether a residue is a charged amino acid.
     * 
     * @param resName the res name
     * 
     * @return  yes if distance is less than noe limit, otherwise no
     */  	
   public boolean isCharged(String resName)
   {
   	if(resName.equalsIgnoreCase("GLU")|| resName.equalsIgnoreCase("ASP")||resName.equalsIgnoreCase("ARG")||
   			resName.equalsIgnoreCase("LYS")||resName.equalsIgnoreCase("HIS"))
   		return true;
   	else 
   		return false;
   	
   }
    
    /**
     * Refined function: for the general case.
     * Compute all the possible NOE peaks from the nucleus with coordA
     * to all other nuclei in a PDB structure, the
     * 
     * @param pdbVec the pdb coordinates
     * @param no the first reside no.
     * @param no2 the second residue no
     * @param noeLimit the upper limit for NOEs
     * @param methylCorrection the methyl correction
     * @param nucleus the nucleus
     * @param nucleus2 the nucleus2
     * @param noe the noe
     * 
     * @return  yes if distance is less than noe limit, otherwise no
     */
    public boolean checkNoe(final Vector pdbVec, int no, String nucleus, int no2, 
			    String nucleus2, double noeLimit, double methylCorrection, double[] noe)
    {
    	double[] coordA = new double[3];
    	double[] coordB = new double[3];
    	Cartesian cc = null;
    	String atomName ="", resid, aName ="";
    	Vector pkVec = new Vector();
    	Assign asg = new Assign();
    	Map aMap = new TreeMap();
    	double distance = 0.0;
    	double cs = -999.99;
    	int i, j;
    	//search the source nucleus
    	int index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
    	if (index < 0)
    	{
    		noe[0]=-999.9;    	
    		return false;
    	}
    	//Pdb pp = (Pdb)pdbVec.elementAt(index);
    	//Vector atomVec = pp.getAtomVec();
    
    	///////////////////////
    	Pdb pp = (Pdb)pdbVec.elementAt(index);
    	Vector atomVec = pp.getAtomVec();
    	resid = pp.getResidue();
    	double distanceUp = 1000.00;
    	boolean found = false;
    	double min = distanceUp;
    	noe[0] = distanceUp;
    	
    	boolean isMethel=false;
    	//there could be more than one H1 to compute the distance
    	Vector vecCartesianA=new Vector();
    	if(resid.equalsIgnoreCase("ALA") && nucleus.length()>1)
    	{
    		if (nucleus.substring(0,2).equalsIgnoreCase("HB"))
    		{
	    		for (j=0; j<atomVec.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec.elementAt(j);
	    			atomName = cc.getAtom();
	    			if (atomName.equalsIgnoreCase("HB1") ||
		    			atomName.equalsIgnoreCase("HB2") ||
		    			atomName.equalsIgnoreCase("HB3"))
	    			{
	    				coordA = cc.getXYZ();
	    				vecCartesianA.add(new Cartesian(atomName,coordA));
	    				isMethel=true;
	    			}
	    		}//for (j=0; j<atomVec2.size(); j++)    		
    		}
    	}
    	else if(resid.equalsIgnoreCase("ILE") &&  nucleus.length()>2)
    	{
    			if(nucleus.substring(0,3).equalsIgnoreCase("HG2"))
    			{
	    		for (j=0; j<atomVec.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec.elementAt(j);
	    			atomName = cc.getAtom();
	    			// 		noe[0] = distanceUp;
	    			if (atomName.equalsIgnoreCase("HG21") ||
		    			atomName.equalsIgnoreCase("HG22") ||
		    			atomName.equalsIgnoreCase("HG23"))
	    			{
	    				coordA = cc.getXYZ();
	    				vecCartesianA.add(new Cartesian(atomName,coordA));
	    				isMethel=true;
	    			}
	    		}    		
    			}
    	}
    	else if(resid.equalsIgnoreCase("ILE") &&   nucleus.length()>2)
    	{
    		if(nucleus.substring(0,3).equalsIgnoreCase("HD1"))    			
	    	{
	    		for (j=0; j<atomVec.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec.elementAt(j);
	    			atomName = cc.getAtom();
	    			//noe[0] = distanceUp;
	    			if (atomName.equalsIgnoreCase("HD11") ||
		    			atomName.equalsIgnoreCase("HD12") ||
		    			atomName.equalsIgnoreCase("HD13"))
	    			{
	    				isMethel=true;
	    				coordA = cc.getXYZ();
	    				vecCartesianA.add(new Cartesian(atomName,coordA));
	    			}
	    		}    		
	    	}
    	}
    	else if(resid.equalsIgnoreCase("LEU") &&   nucleus.length()>2)
    	{
    		if(	nucleus.substring(0,3).equalsIgnoreCase("HD1"))
	    	{
	    		for (j=0; j<atomVec.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec.elementAt(j);
	    			atomName = cc.getAtom();
	    			//noe[0] = distanceUp;
	    			if (atomName.equalsIgnoreCase("HD11") ||
		    			atomName.equalsIgnoreCase("HD12") ||
		    			atomName.equalsIgnoreCase("HD13"))
	    			{
	    				isMethel=true;
	    				coordA = cc.getXYZ();
	    				vecCartesianA.add(new Cartesian(atomName,coordA));
	    			}
	    		}
	    		
	    	}
    	}
    	else if(resid.equalsIgnoreCase("LEU") &&   nucleus.length()>2)
    	{
    		if(nucleus.substring(0,3).equalsIgnoreCase("HD1"))
	    	{
	    		for (j=0; j<atomVec.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec.elementAt(j);
	    			atomName = cc.getAtom();
	    			//	 		noe[0] = distanceUp;
	    			if (atomName.equalsIgnoreCase("HD11") ||
	    					atomName.equalsIgnoreCase("HD12") ||
	    					atomName.equalsIgnoreCase("HD13"))
	    			{
	    				isMethel=true;
	    				coordA = cc.getXYZ();
	    				vecCartesianA.add(new Cartesian(atomName,coordA));
	    			}
	    		}
			    
			}	
    	}
    	else if(resid.equalsIgnoreCase("LEU") &&   nucleus.length()>2)
    	{
    		if (nucleus.substring(0,3).equalsIgnoreCase("HD2"))
	    	{
	    		for (j=0; j<atomVec.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec.elementAt(j);
	    			atomName = cc.getAtom();
	    			// 		noe[0] = distanceUp;
	    			if (atomName.equalsIgnoreCase("HD21") ||
	    					atomName.equalsIgnoreCase("HD22") ||
	    					atomName.equalsIgnoreCase("HD23"))
	    			{
	    				isMethel=true;
	    				coordA = cc.getXYZ();
	    				vecCartesianA.add(new Cartesian(atomName,coordA));
	    			}
	    		}
	    		
	    	}
    	}
    	else if(resid.equalsIgnoreCase("VAL") &&   nucleus.length()>2)
    	{
    		if (nucleus.substring(0,3).equalsIgnoreCase("HG1"))
    		{
	    		for (j=0; j<atomVec.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec.elementAt(j);
	    			atomName = cc.getAtom();
	    			// 		noe[0] = distanceUp;
	    			if (atomName.equalsIgnoreCase("HG11") ||
	    					atomName.equalsIgnoreCase("HG12") ||
	    					atomName.equalsIgnoreCase("HG13"))
	    			{
	    				isMethel=true;
	    				coordA = cc.getXYZ();
	    				vecCartesianA.add(new Cartesian(atomName,coordA));
	    			}
	    		}
	   
    		}
    	}
    	else if(resid.equalsIgnoreCase("VAL") &&   nucleus.length()>2)
    	{
    		if(	nucleus.substring(0,3).equalsIgnoreCase("HG2"))
	    	{
	    		for (j=0; j<atomVec.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec.elementAt(j);
	    			atomName = cc.getAtom();
	    			// 		noe[0] = distanceUp;
	    			// 		System.out.println(" atomName= "+atomName);
	    			if (atomName.equalsIgnoreCase("HG21") ||
	    					atomName.equalsIgnoreCase("HG22") ||
	    					atomName.equalsIgnoreCase("HG23"))
	    			{
	    				isMethel=true;
	    				coordA = cc.getXYZ();
	    				vecCartesianA.add(new Cartesian(atomName,coordA));
	    			}
	    		}
	    
	    	}
    	}
    	else if(resid.equalsIgnoreCase("THR") &&   nucleus.length()>2)
    	{
    		if(nucleus.substring(0,3).equalsIgnoreCase("HG2"))
    	
	    	{
	    		for (j=0; j<atomVec.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec.elementAt(j);
	    			atomName = cc.getAtom();
	    			// 		noe[0] = distanceUp;
	    			if (atomName.equalsIgnoreCase("HG21") ||
		    			atomName.equalsIgnoreCase("HG22") ||
		    			atomName.equalsIgnoreCase("HG23"))
	    			{
	    				isMethel=true;
	    				coordA = cc.getXYZ();
	    				vecCartesianA.add(new Cartesian(atomName,coordA));
	    			}
	    		}
		   
	    	}
    	}
    	else 
    	{ 
    		// 	    noe[0] = distanceUp;  	    		
    		if(nucleus.equalsIgnoreCase("HN"))
    			nucleus = "H";
    		for (j=0; j<atomVec.size(); j++)
    		{
    			cc = (Cartesian) atomVec.elementAt(j);
    			atomName = cc.getAtom();
    			
    			if (atomName.equalsIgnoreCase("HN"))
    				atomName="H";
    			if (atomName.equalsIgnoreCase(nucleus))
    			{
    				coordA = cc.getXYZ();
    				vecCartesianA.add(new Cartesian(atomName,coordA));
    			}
    		}
	   
    	}    	
/////////////////////////////////////////////////////////////
    	int index2 = Collections.binarySearch(pdbVec, new Pdb(no2), new Pdb.PdbComparator());
    	if (index2 < 0)
    	{
    		noe[0]=-999.9;
    		return false;    		
    	}
    	Pdb pp2 = (Pdb)pdbVec.elementAt(index2);
    	Vector atomVec2 = pp2.getAtomVec();
    	resid = pp2.getResidue();
    	distanceUp = 1000.00;
    	found = false;
    	min = distanceUp;
    	noe[0] = distanceUp;
    	if(resid.equalsIgnoreCase("ALA") &&   nucleus2.length()>1)
    	{
    		if(nucleus2.substring(0,2).equalsIgnoreCase("HB"))
    	   	{
	    		for (j=0; j<atomVec2.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec2.elementAt(j);
	    			atomName = cc.getAtom();
	    			if (atomName.equalsIgnoreCase("HB1") ||
		    			atomName.equalsIgnoreCase("HB2") ||
		    			atomName.equalsIgnoreCase("HB3"))
	    			{
	    				coordB = cc.getXYZ();
	    				for (int h=0;h<vecCartesianA.size();h++)
	    				{    					
	    					Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
	    					coordA=cartesianA.getXYZ();
	    					distance = length(internuclearVec(coordB, coordA));
	    					if (distance < noe[0])
	    						noe[0] = distance;
	    				}
	    			}
	    		}//for (j=0; j<atomVec2.size(); j++)
	    		//if (noe[0] <= noeLimit+methylCorrection)//+2.5A
	    		if (noe[0] <= noeLimit)
	    		{
	    			found = true;
	    			noe[1]=methylCorrection;
	    		}
    	   	}
    	}
    	else if(resid.equalsIgnoreCase("ILE") &&   nucleus2.length()>2)
    	{
    		if	(nucleus2.substring(0,3).equalsIgnoreCase("HG2"))
	    	{
	    		for (j=0; j<atomVec2.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec2.elementAt(j);
	    			atomName = cc.getAtom();
	    			
	    			if (atomName.equalsIgnoreCase("HG21") ||
		    			atomName.equalsIgnoreCase("HG22") ||
		    			atomName.equalsIgnoreCase("HG23"))
	    			{
	    				coordB = cc.getXYZ();
	    				for (int h=0;h<vecCartesianA.size();h++)
	    				{    					
	    					Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
	    					coordA=cartesianA.getXYZ();
	    					distance = length(internuclearVec(coordB, coordA));
	    					if (distance < noe[0])
	    						noe[0] = distance;
	    				}
	    			}
	    		}
	    		//if (noe[0] <= noeLimit+methylCorrection)
	    		if (noe[0] <= noeLimit)
	    		{
	    			found = true;
	    			noe[1]=methylCorrection;
	    		}
	    	}
    	}
    	else if(resid.equalsIgnoreCase("ILE") &&   nucleus2.length()>2)
    	{
    		if(nucleus2.substring(0,3).equalsIgnoreCase("HD1"))
	    	{
	    		for (j=0; j<atomVec2.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec2.elementAt(j);
	    			atomName = cc.getAtom();
	    		
	    			if (atomName.equalsIgnoreCase("HD11") ||
		    			atomName.equalsIgnoreCase("HD12") ||
		    			atomName.equalsIgnoreCase("HD13"))
	    			{
	    				coordB = cc.getXYZ();
	    				for (int h=0;h<vecCartesianA.size();h++)
	    				{    					
	    					Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
	    					coordA=cartesianA.getXYZ();
	    					distance = length(internuclearVec(coordB, coordA));
	    					if (distance < noe[0])
	    						noe[0] = distance;
	    				}
	    			}
	    		}
	    		//if (noe[0] <= noeLimit+methylCorrection)
	    		if (noe[0] <= noeLimit)
	    		{
	    			found = true;
	    			noe[1]=methylCorrection;
	    		}
	    	}
    	}
    	else if(resid.equalsIgnoreCase("LEU") &&   nucleus2.length()>2)
    	{
    		if(	nucleus2.substring(0,3).equalsIgnoreCase("HD1"))
	    	{
	    		for (j=0; j<atomVec2.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec2.elementAt(j);
	    			atomName = cc.getAtom();
	    			
	    			if (atomName.equalsIgnoreCase("HD11") ||
		    			atomName.equalsIgnoreCase("HD12") ||
		    			atomName.equalsIgnoreCase("HD13"))
	    			{
	    				coordB = cc.getXYZ();
	    				for (int h=0;h<vecCartesianA.size();h++)
	    				{    					
	    					Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
	    					coordA=cartesianA.getXYZ();
	    					distance = length(internuclearVec(coordB, coordA));
	    					if (distance < noe[0])
	    						noe[0] = distance;
	    				}
	    			}
	    		}
	    		//if (noe[0] <= noeLimit+methylCorrection)//
	    		if (noe[0] <= noeLimit)
	    		{
	    			found = true;
	    			noe[1]=methylCorrection;
	    		}
	    	}
    	}
    	else if(resid.equalsIgnoreCase("LEU") &&   nucleus2.length()>2)
    	{
    		if(nucleus2.substring(0,3).equalsIgnoreCase("HD1"))
	    	{
	    		for (j=0; j<atomVec2.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec2.elementAt(j);
	    			atomName = cc.getAtom();
	    			
	    			if (atomName.equalsIgnoreCase("HD11") ||
	    					atomName.equalsIgnoreCase("HD12") ||
	    					atomName.equalsIgnoreCase("HD13"))
	    			{
	    				coordB = cc.getXYZ();
	    				for (int h=0;h<vecCartesianA.size();h++)
	    				{    					
	    					Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
	    					coordA=cartesianA.getXYZ();
	    					distance = length(internuclearVec(coordB, coordA));
	    					if (distance < noe[0])
	    						noe[0] = distance;
	    				}
	    			}
	    		}
			   // if (noe[0] <= noeLimit+methylCorrection)
	    		if (noe[0] <= noeLimit)
			    {
	    			found = true;
	    			noe[1]=methylCorrection;
	    		}
			}	
    	}
    	else if(resid.equalsIgnoreCase("LEU") &&   nucleus2.length()>2)
    	{
    		if(nucleus2.substring(0,3).equalsIgnoreCase("HD2"))
    		{
	    		for (j=0; j<atomVec2.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec2.elementAt(j);
	    			atomName = cc.getAtom();
	    		
	    			if (atomName.equalsIgnoreCase("HD21") ||
	    					atomName.equalsIgnoreCase("HD22") ||
	    					atomName.equalsIgnoreCase("HD23"))
	    			{
	    				coordB = cc.getXYZ();
	    				for (int h=0;h<vecCartesianA.size();h++)
	    				{    					
	    					Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
	    					coordA=cartesianA.getXYZ();
	    					distance = length(internuclearVec(coordB, coordA));
	    					if (distance < noe[0])
	    						noe[0] = distance;
	    				}
	    			}
	    		}
	    		//if (noe[0] <= noeLimit+methylCorrection)
	    		if (noe[0] <= noeLimit)
	    		{
	    			found = true;
	    			noe[1]=methylCorrection;
	    		}
	    	}
    	}
    	else if(resid.equalsIgnoreCase("VAL") &&   nucleus2.length()>2)
    	{
    		if(nucleus2.substring(0,3).equalsIgnoreCase("HG1"))
	    	{
	    		for (j=0; j<atomVec2.size(); j++)
	    		{
	    			cc = (Cartesian) atomVec2.elementAt(j);
	    			atomName = cc.getAtom();
	    		
	    			if (atomName.equalsIgnoreCase("HG11") ||
	    					atomName.equalsIgnoreCase("HG12") ||
	    					atomName.equalsIgnoreCase("HG13"))
	    			{
	    				coordB = cc.getXYZ();
	    				for (int h=0;h<vecCartesianA.size();h++)
	    				{    					
	    					Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
	    					coordA=cartesianA.getXYZ();
	    					distance = length(internuclearVec(coordB, coordA));
	    					if (distance < noe[0])
	    						noe[0] = distance;
	    				}
	    			}
	    		}
	    
			   // if (noe[0] <= noeLimit+methylCorrection)
	    		if (noe[0] <= noeLimit)
			    {
	    			found = true;
	    			noe[1]=methylCorrection;
	    		}
	    	}
	    	
    	}
    	else if(resid.equalsIgnoreCase("VAL") &&   nucleus2.length()>2)
    	{
    		if(	nucleus2.substring(0,3).equalsIgnoreCase("HG2"))
    		{
			    for (j=0; j<atomVec2.size(); j++)
			    {
			    	cc = (Cartesian) atomVec2.elementAt(j);
			    	atomName = cc.getAtom();
			    
			    	if (atomName.equalsIgnoreCase("HG21") ||
						atomName.equalsIgnoreCase("HG22") ||
						atomName.equalsIgnoreCase("HG23"))
			    	{
			    		coordB = cc.getXYZ();
			    		for (int h=0;h<vecCartesianA.size();h++)
			    		{    					
			    			Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
			    			coordA=cartesianA.getXYZ();
			    			distance = length(internuclearVec(coordB, coordA));
			    			if (distance < noe[0])
			    				noe[0] = distance;
			    		}
			    	}
			    }
			    
		    	//if (noe[0] <= noeLimit+methylCorrection)
		    	if (noe[0] <= noeLimit)
		    	{
	    			found = true;
	    			noe[1]=methylCorrection;
	    		}
    		}
	}else if(resid.equalsIgnoreCase("THR") &&   nucleus2.length()>2)
	{
		if(nucleus2.substring(0,3).equalsIgnoreCase("HG2"))
		{
		    for (j=0; j<atomVec2.size(); j++)
		    {
		    	cc = (Cartesian) atomVec2.elementAt(j);
		    	atomName = cc.getAtom();
		    
		    	if (atomName.equalsIgnoreCase("HG21") ||
		    			atomName.equalsIgnoreCase("HG22") ||
		    			atomName.equalsIgnoreCase("HG23"))
		    	{
		    		coordB = cc.getXYZ();
					for (int h=0;h<vecCartesianA.size();h++)
					{    					
						Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
						coordA=cartesianA.getXYZ();
						distance = length(internuclearVec(coordB, coordA));
						if (distance < noe[0])
							noe[0] = distance;
					}
		    	}
		    }
		    //if (noe[0] <= noeLimit+methylCorrection)
		    if (noe[0] <= noeLimit)
		    {
    			found = true;
    			noe[1]=methylCorrection;
    		}
		}
	}else 
	{ 		
	    if(nucleus2.equalsIgnoreCase("HN"))
		nucleus2 = "H";
	    for (j=0; j<atomVec2.size(); j++)
	    {
	    	cc = (Cartesian) atomVec2.elementAt(j);
	    	atomName = cc.getAtom();
	    	if (atomName.equalsIgnoreCase("HN"))
				atomName="H";
	    	if (atomName.equalsIgnoreCase(nucleus2))
	    	{
	    		coordB = cc.getXYZ();
				for (int h=0;h<vecCartesianA.size();h++)
				{    					
					Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
					coordA=cartesianA.getXYZ();
					distance = length(internuclearVec(coordB, coordA));
					if (distance < noe[0])
						noe[0] = distance;
				}
	    	}
	    }
	    if(isMethel)
	    {
	    	//if (noe[0] <= noeLimit+methylCorrection)
	    	if (noe[0] <= noeLimit)
	    	{
    			found = true;
    			noe[1]=methylCorrection;
    		}
	    }
	    else
	    {
	    	 if (noe[0] <= noeLimit)
	    	 {
	    			found = true;
	    			noe[1]=0.0;
	    		}
	    }
	}
	return found;
  }
    
    /**
     * better version of "checkNoe"
     * Refined function: for the general case.
     * Compute all the possible NOE peaks from the nucleus with coordA
     * to all other nuclei in a PDB structure, the
     * 
     * @param pdbVec the pdb coordinates
     * @param no the first reside no.
     * @param no2 the second residue no
     * @param noeLimit the upper limit for NOEs
     * @param methylCorrection the methyl correction
     * @param nucleus the nucleus
     * @param nucleus2 the nucleus2
     * @param noe the noe
     * 
     * @return  yes if distance is less than noe limit, otherwise no
     * Note: created 08/05/29.
     */
    public boolean checkNoeNew(final Vector pdbVec, int no, String nucleus, int no2, 
			    String nucleus2, double noeLimit, double methylCorrection, double[] noe)
    {
    	boolean isFoundAtomA=false;
    	boolean isFoundAtomB=false;
    	double[] coordA = new double[3];
    	double[] coordB = new double[3];
    	Cartesian cc = null;
    	String atomName ="", resid, aName ="";
    	Vector pkVec = new Vector();
    	Assign asg = new Assign();
    	Map aMap = new TreeMap();
    	double distance = 0.0;
    	double cs = -999.99;
    	int i, j;
    	
    	//search the source nucleus
    	int index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
    	if (index < 0)
    	{
    		noe[0]=-999.9;    	
    		return false;
    	}
    	//Pdb pp = (Pdb)pdbVec.elementAt(index);
    	//Vector atomVec = pp.getAtomVec();
    
    	///////////////////////
    	Pdb pp = (Pdb)pdbVec.elementAt(index);
    	Vector atomVec = pp.getAtomVec();
    	resid = pp.getResidue();
    	double distanceUp = 1000.00;
    	boolean found = false;
    	double min = distanceUp;
    	noe[0] = distanceUp;
    	noe[1]=0.0;    
    	boolean isMethel=false;
    	String atomSub="";
    	if(nucleus.equalsIgnoreCase("H"))
    		nucleus="HN";
    	atomSub=nucleus;
    	//pseudo atom name convert:
    	//extract the previous name without "#"
		if(nucleus.length()>=2)
		{
    		if(nucleus.substring(nucleus.length()-2,nucleus.length()).equalsIgnoreCase("##")  )
    			atomSub=nucleus.substring(0,nucleus.length()-2);
    		else if (nucleus.substring(nucleus.length()-1,nucleus.length()).equalsIgnoreCase("#") )
    			atomSub=nucleus.substring(0,nucleus.length()-1);
		}		
		
    	//there could be more than one H1 to compute the distance
    	Vector vecCartesianA=new Vector();
    	
    	int countA=0;
    	double sumX=0.0, sumY=0.0, sumZ=0.0;
    	for (j=0; j<atomVec.size(); j++)
		{
			cc = (Cartesian) atomVec.elementAt(j);
			String atomPPName = cc.getAtom();
			if(atomPPName.equalsIgnoreCase("H"))
				atomPPName="HN";
			String sub_atomPPName=atomPPName;
			if(atomPPName.length()>=atomSub.length() && !atomSub.equalsIgnoreCase("O") && !atomSub.equalsIgnoreCase("N"))
				sub_atomPPName=atomPPName.substring(0,atomSub.length());
			if(sub_atomPPName.equalsIgnoreCase(atomSub)  )
			{		
				isFoundAtomA=true;
				coordA = cc.getXYZ();
				countA++;
				sumX=sumX+coordA[0];
				sumY=sumY+coordA[1];
				sumZ=sumZ+coordA[2];
				
				if( (atomPPName.length()-atomSub.length() ) == 1 || (atomPPName.length()-atomSub.length() ) == 2)
					isMethel=true; //need to double check for HB# and HB##			
			}
		}//for (int j=0; j<atomVec.size(); j++)    	
    	coordA[0]=sumX/countA;
    	coordA[1]=sumY/countA;
    	coordA[2]=sumZ/countA;
    	vecCartesianA.add(new Cartesian(atomSub,coordA));
    	/////////////////////////////////////////////////////////////
    	int index2 = Collections.binarySearch(pdbVec, new Pdb(no2), new Pdb.PdbComparator());
    	if (index2 < 0)
    	{
    		noe[0]=-999.9;
    		return false;    		
    	}
    	Pdb pp2 = (Pdb)pdbVec.elementAt(index2);
    	Vector atomVec2 = pp2.getAtomVec();
    	resid = pp2.getResidue();
    	distanceUp = 1000.00;
    	found = false;
    	min = distanceUp;
    	noe[0] = distanceUp;
    	if(nucleus2.equalsIgnoreCase("H"))
    		nucleus2="HN";
    	atomSub=nucleus2;
    	if(nucleus2.length()>=2)
		{
    		if(nucleus2.substring(nucleus2.length()-2,nucleus2.length()).equalsIgnoreCase("##")  )
    			atomSub=nucleus2.substring(0,nucleus2.length()-2);
    		else if (nucleus2.substring(nucleus2.length()-1,nucleus2.length()).equalsIgnoreCase("#") )
    			atomSub=nucleus2.substring(0,nucleus2.length()-1);
		}	    	
    	
    	int countB=0;
    	sumX=0.0; sumY=0.0; sumZ=0.0;
    	for (j=0; j<atomVec2.size(); j++)
		{
			cc = (Cartesian) atomVec2.elementAt(j);
			String atomPPName = cc.getAtom();
			if(atomPPName.equalsIgnoreCase("H"))
				atomPPName="HN";
			String sub_atomPPName=atomPPName;
			if(atomPPName.length()>=atomSub.length() && !atomSub.equalsIgnoreCase("O") && !atomSub.equalsIgnoreCase("N"))
				sub_atomPPName=atomPPName.substring(0,atomSub.length());
			if(sub_atomPPName.equalsIgnoreCase(atomSub))
			{
				isFoundAtomB=true;
				if( (atomPPName.length()-atomSub.length() ) == 1 || (atomPPName.length()-atomSub.length() ) == 2)
					isMethel=true; //need to double check for HB# and HB##	
				coordB = cc.getXYZ();
				countB++;
				sumX=sumX+coordB[0];
				sumY=sumY+coordB[1];
				sumZ=sumZ+coordB[2];
				//for (int h=0;h<vecCartesianA.size();h++)
				//{    					
				//	Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
				//	coordA=cartesianA.getXYZ();
				//	distance = length(internuclearVec(coordB, coordA));
				//	if (distance < noe[0])
				//		noe[0] = distance;
				//}//for (int h=0;h<vecCartesianA.size();h++)
			}
		}//for (j=0; j<atomVec2.size(); j++)
    	
    	coordB[0]=sumX/countB;
    	coordB[1]=sumY/countB;
    	coordB[2]=sumZ/countB;
    	distance = length(internuclearVec(coordB, coordA));
    	if (distance < noe[0])
			noe[0] = distance;
    	double dbCorrection=0.0;
    	if (isMethel)
    	{
    		dbCorrection=methylCorrection;
    		noe[1]=0.5; 
    	}
    	if ( (noe[0] <= noeLimit+dbCorrection) && isFoundAtomA && isFoundAtomB )
			found = true;
    	
	return found;
  }   
    
    /**
     * similar to checkNoeNew, with additional0.5 A
     * 
     * @param pdbVec the pdb coordinates
     * @param no the first reside no.
     * @param no2 the second residue no
     * @param noeLimit the upper limit for NOEs
     * @param methylCorrection the methyl correction
     * @param nucleus the nucleus
     * @param nucleus2 the nucleus2
     * @param noe the noe
     * 
     * @return  yes if distance is less than noe limit, otherwise no
     * Note: created 08/05/29.
     */
    public boolean checkNoeNew2(final Vector pdbVec, int no, String nucleus, int no2, 
			    String nucleus2, double noeLimit, double methylCorrection, double[] noe)
    {
    	boolean isFoundAtomA=false;
    	boolean isFoundAtomB=false;
    	double[] coordA = new double[3];
    	double[] coordB = new double[3];
    	Cartesian cc = null;
    	String atomName ="", resid, aName ="";
    	Vector pkVec = new Vector();
    	Assign asg = new Assign();
    	Map aMap = new TreeMap();
    	double distance = 0.0;
    	double cs = -999.99;
    	int i, j;
    	
    	//search the source nucleus
    	int index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
    	if (index < 0)
    	{
    		noe[0]=-999.9;    	
    		return false;
    	}
    	//Pdb pp = (Pdb)pdbVec.elementAt(index);
    	//Vector atomVec = pp.getAtomVec();
    
    	///////////////////////
    	Pdb pp = (Pdb)pdbVec.elementAt(index);
    	Vector atomVec = pp.getAtomVec();
    	resid = pp.getResidue();
    	double distanceUp = 1000.00;
    	boolean found = false;
    	double min = distanceUp;
    	noe[0] = distanceUp;
    	noe[1]=0.0;    
    	boolean isMethel=false;
    	String atomSub="";
    	if(nucleus.equalsIgnoreCase("H"))
    		nucleus="HN";
    	atomSub=nucleus;
    	//pseudo atom name convert:
    	//extract the previous name without "#"
		if(nucleus.length()>=2)
		{
    		if(nucleus.substring(nucleus.length()-2,nucleus.length()).equalsIgnoreCase("##")  )
    			atomSub=nucleus.substring(0,nucleus.length()-2);
    		else if (nucleus.substring(nucleus.length()-1,nucleus.length()).equalsIgnoreCase("#") )
    			atomSub=nucleus.substring(0,nucleus.length()-1);
		}		
		
    	//there could be more than one H1 to compute the distance
    	Vector vecCartesianA=new Vector();
    	
    	int countA=0;
    	double sumX=0.0, sumY=0.0, sumZ=0.0;
    	for (j=0; j<atomVec.size(); j++)
		{
			cc = (Cartesian) atomVec.elementAt(j);
			String atomPPName = cc.getAtom();
			if(atomPPName.equalsIgnoreCase("H"))
				atomPPName="HN";
			String sub_atomPPName=atomPPName;
			if(atomPPName.length()>=atomSub.length() && !atomSub.equalsIgnoreCase("O") && !atomSub.equalsIgnoreCase("N"))
				sub_atomPPName=atomPPName.substring(0,atomSub.length());
			if(sub_atomPPName.equalsIgnoreCase(atomSub)  )
			{		
				isFoundAtomA=true;
				coordA = cc.getXYZ();
				countA++;
				sumX=sumX+coordA[0];
				sumY=sumY+coordA[1];
				sumZ=sumZ+coordA[2];
				
				if( (atomPPName.length()-atomSub.length() ) == 1 || (atomPPName.length()-atomSub.length() ) == 2)
					isMethel=true; //need to double check for HB# and HB##			
			}
		}//for (int j=0; j<atomVec.size(); j++)    	
    	coordA[0]=sumX/countA;
    	coordA[1]=sumY/countA;
    	coordA[2]=sumZ/countA;
    	vecCartesianA.add(new Cartesian(atomSub,coordA));
    	/////////////////////////////////////////////////////////////
    	int index2 = Collections.binarySearch(pdbVec, new Pdb(no2), new Pdb.PdbComparator());
    	if (index2 < 0)
    	{
    		noe[0]=-999.9;
    		return false;    		
    	}
    	Pdb pp2 = (Pdb)pdbVec.elementAt(index2);
    	Vector atomVec2 = pp2.getAtomVec();
    	resid = pp2.getResidue();
    	distanceUp = 1000.00;
    	found = false;
    	min = distanceUp;
    	noe[0] = distanceUp;
    	if(nucleus2.equalsIgnoreCase("H"))
    		nucleus2="HN";
    	atomSub=nucleus2;
    	if(nucleus2.length()>=2)
		{
    		if(nucleus2.substring(nucleus2.length()-2,nucleus2.length()).equalsIgnoreCase("##")  )
    			atomSub=nucleus2.substring(0,nucleus2.length()-2);
    		else if (nucleus2.substring(nucleus2.length()-1,nucleus2.length()).equalsIgnoreCase("#") )
    			atomSub=nucleus2.substring(0,nucleus2.length()-1);
		}	    	
    	
    	int countB=0;
    	sumX=0.0; sumY=0.0; sumZ=0.0;
    	for (j=0; j<atomVec2.size(); j++)
		{
			cc = (Cartesian) atomVec2.elementAt(j);
			String atomPPName = cc.getAtom();
			if(atomPPName.equalsIgnoreCase("H"))
				atomPPName="HN";
			String sub_atomPPName=atomPPName;
			if(atomPPName.length()>=atomSub.length() && !atomSub.equalsIgnoreCase("O") && !atomSub.equalsIgnoreCase("N"))
				sub_atomPPName=atomPPName.substring(0,atomSub.length());
			if(sub_atomPPName.equalsIgnoreCase(atomSub))
			{
				isFoundAtomB=true;
				if( (atomPPName.length()-atomSub.length() ) == 1 || (atomPPName.length()-atomSub.length() ) == 2)
					isMethel=true; //need to double check for HB# and HB##	
				coordB = cc.getXYZ();
				countB++;
				sumX=sumX+coordB[0];
				sumY=sumY+coordB[1];
				sumZ=sumZ+coordB[2];
				//for (int h=0;h<vecCartesianA.size();h++)
				//{    					
				//	Cartesian cartesianA=(Cartesian)vecCartesianA.elementAt(h);
				//	coordA=cartesianA.getXYZ();
				//	distance = length(internuclearVec(coordB, coordA));
				//	if (distance < noe[0])
				//		noe[0] = distance;
				//}//for (int h=0;h<vecCartesianA.size();h++)
			}
		}//for (j=0; j<atomVec2.size(); j++)
    	
    	coordB[0]=sumX/countB;
    	coordB[1]=sumY/countB;
    	coordB[2]=sumZ/countB;
    	distance = length(internuclearVec(coordB, coordA));
    	if (distance < noe[0])
			noe[0] = distance;
    	double dbCorrection=0.5;
    	if (isMethel)
    	{
    		dbCorrection=methylCorrection;
    		noe[1]=0.5; 
    	}
    	if ( (noe[0] <= noeLimit+dbCorrection) && isFoundAtomA && isFoundAtomB )
			found = true;
    	
	return found;
  } 
    
    /**
     * Gets the cS from list.
     * 
     * @param vecAsg the vec asg
     * @param resNo the res no
     * @param atom the atom
     * 
     * @return the cS from list
     */
    public double getCSFromList(Vector vecAsg, int resNo, String atom)
    {    	
    	if(atom.equalsIgnoreCase("HN"))
    		atom="H";
    	for(int i=0;i<vecAsg.size();i++)
    	{
    		H1CS h1cs=(H1CS)vecAsg.elementAt(i);
    		String atomName=h1cs.getAtomName();
    		if(atomName.equalsIgnoreCase("HN"))
    			atomName="H";
    		int no=h1cs.getResidueNo();
    		double cs=h1cs.getH1CS();
    		if(no==resNo && atom.equalsIgnoreCase(atomName))
    			return cs;    		    		
    	}//for(int i=0;i<vecAsg.size();i++)
    	return -999.9;
    }
    
    /**
     * for long-range noes, check whether number of neighboring noes is larger
     * than some bound.
     * 
     * @param vecNoe previous noe assignment
     * @param Threshold threshold number of neighboring noes
     * 
     * @return  refined noe assignments
     */
    public Vector CheckLongRangNOE(final Vector vecNoe, int Threshold)
    {
    	Vector vecNewNoe =new Vector();
    	Noe noe=new Noe();
    	Noe noeCheck=new Noe();
    	int firstResNo,secondResNo;
    	String firstResName,secondResName,firstAtomName,secondAtomName;
    	
    	for (int i=0;i<vecNoe.size();i++)
    	{
    		noe=(Noe)vecNoe.elementAt(i);
    		firstResNo=noe.getResidueNoA();
    		secondResNo=noe.getResidueNoB();
    		firstResName=noe.getResidueA();
    		secondResName=noe.getResidueB();
    		firstAtomName=noe.getAtomA();///
    		secondAtomName=noe.getAtomB();
    		
    		//check the number of neighboring noes
    		int number=0;
    		
    		/*if(Math.abs(firstResNo-secondResNo)<=4)
    		{
    			vecNewNoe.add(noe);
    			continue;
    		}*/
    			
    		
    		for (int j=0; j<vecNoe.size();j++)
    		{
    			if(i==j)
    				continue;
    			noeCheck=(Noe)vecNoe.elementAt(j);
    			int resNo1=noeCheck.getResidueNoA();
    			int resNo2=noeCheck.getResidueNoB();
    			String atomName1=noeCheck.getAtomA();
    			String atomName2=noeCheck.getAtomB();
    			
    			//i-1:j-1;  //i:j
    			if( (Math.abs(firstResNo-resNo1)<=0)  && (Math.abs(secondResNo-resNo2)<=0)  )
    				number=number+1;
    			if( (Math.abs(firstResNo-resNo2)<=0)  && (Math.abs(secondResNo-resNo1)<=0)  )
    				number=number+1;
    		}//for (int j=0; j<vecNoe.size();j++)
    		
    		if (number>=Threshold)
    			vecNewNoe.add(noe);   		
    		
    	}//for (int i=0;i<vecNoe.size();i++)
    	
    	
    	//only output the first two residues.
    	for (int i=0;i<vecNewNoe.size();i++)
    	{
    		noe=(Noe)vecNewNoe.elementAt(i);
    		firstResNo=noe.getResidueNoA();
    		secondResNo=noe.getResidueNoB();
    		firstResName=noe.getResidueA();
    		secondResName=noe.getResidueB();
    		firstAtomName=noe.getAtomA();///
    		secondAtomName=noe.getAtomB();
    		
    		
    		
    	}//for (int i=0;i<vecNewNoe.size();i++)
    	
    	return vecNewNoe;
    }
    
    
    /**
     * refine NOEs and only keep those NOE with symmetry property, for C13 NOESY and sidechain N15 NOESY.
     * 
     * @param vecNoe original NOE assignments.
     * 
     * @return  new NOE assignment table.
     */
    public Vector CheckNoeSym(final Vector vecNoe)
    {
    	Peak pk=new Peak();
    	Vector vecNewNoe =new Vector();
    	Noe noe=new Noe();
    	Noe noeCheck=new Noe();
    	int firstResNo,secondResNo;
    	String firstResName,secondResName,firstAtomName,secondAtomName;
    	double dist_from_inten=0.0;
    	boolean isBack=false;
    	for (int i=0;i<vecNoe.size();i++)
    	{
    		noe=(Noe)vecNoe.elementAt(i);
    		firstResNo=noe.getResidueNoA();
    		secondResNo=noe.getResidueNoB();
    		firstResName=noe.getResidueA();
    		secondResName=noe.getResidueB();
    		firstAtomName=noe.getAtomA();///
    		secondAtomName=noe.getAtomB();
    		dist_from_inten=noe.getUpper();
    	   		
    		//check back NOEs noe sysmetry    		
    		isBack=false;
    		for (int j=0; j<vecNoe.size();j++)
    		{
    			if(i==j)
    				continue;
    			noeCheck=(Noe)vecNoe.elementAt(j);
    			int resNo1=noeCheck.getResidueNoA();
    			int resNo2=noeCheck.getResidueNoB();
    			String atomName1=noeCheck.getAtomA();
    			String atomName2=noeCheck.getAtomB();
    			//if((firstResNo==resNo2) && (secondResNo==resNo1) 
    				//	&&(firstAtomName.equalsIgnoreCase(atomName2))&&(secondAtomName.equalsIgnoreCase(atomName1)) )
    				//isBack=true;
    			if((firstResNo==resNo2) && (secondResNo==resNo1) )        					
    				isBack=true;    			
    		}//for (int j=0; j<vecNoe.size();j++)
    		
    		if (isBack)
    			vecNewNoe.add(noe);   		
    		
    	}//for (int i=0;i<vecNoe.size();i++)
    	
    	return vecNewNoe;
    }
    
    	
    /**
     * Compute all the possible NOE peaks from the nucleus with coordA
     * to all other nuclei in a PDB structure, the.
     * 
     * @param asgVec the sorted resonance assignment
     * @param pdbVec the pdb coordinates
     * @param no the reside no.
     * @param noeLimit the limitation set for NOEs
     * @param nucleus the nucleus
     * @param no2 the no2
     * @param nucleus2 the nucleus2
     * @param methylCorrection the methyl correction
     * @param noe the noe
     * 
     * @return  all the Peak objects within the specified range
     */
    public boolean checkNoe_old(final Vector pdbVec, final Vector asgVec, int no, String nucleus, int no2, 
			    String nucleus2, double noeLimit, double methylCorrection, double[] noe)
    {
    	double[] coordA = new double[3];
    	double[] coordB = new double[3];
    	Cartesian cc = null;
    	String atomName ="", resid, aName ="";
    	Vector pkVec = new Vector();
    	Assign asg = new Assign();
    	Map aMap = new TreeMap();
    	double distance = 0.0;
    	double cs = -999.99;
    	int i, j;
    	//search the source nucleus
    	int index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
    	if (index < 0)
    		return false;
    	Pdb pp = (Pdb)pdbVec.elementAt(index);
    	Vector atomVec = pp.getAtomVec();
    	for (i=0; i<atomVec.size(); i++)
    	{
	    cc = (Cartesian) atomVec.elementAt(i);
	    atomName = cc.getAtom();
	    if (atomName.equalsIgnoreCase(nucleus))
		coordA = cc.getXYZ();
	}

	int index2 = Collections.binarySearch(pdbVec, new Pdb(no2), new Pdb.PdbComparator());
	if (index2 < 0)
	    return false;
	Pdb pp2 = (Pdb)pdbVec.elementAt(index2);
	Vector atomVec2 = pp2.getAtomVec();
	resid = pp2.getResidue();
	double distanceUp = 1000.00;
	boolean found = false;
	double min = distanceUp;
	noe[0] = distanceUp;
	if(resid.equalsIgnoreCase("ALA") && nucleus2.equalsIgnoreCase("HB"))
	{
	    for (j=0; j<atomVec2.size(); j++)
	    {
	    	cc = (Cartesian) atomVec2.elementAt(j);
	    	atomName = cc.getAtom();
	    	if (atomName.equalsIgnoreCase("HB1") ||
	    			atomName.equalsIgnoreCase("HB2") ||
	    			atomName.equalsIgnoreCase("HB3"))
	    	{
	    		coordB = cc.getXYZ();
	    		distance = length(internuclearVec(coordB, coordA));
	    		if (distance < noe[0])
	    			noe[0] = distance;
	    	}
	    }//for (j=0; j<atomVec2.size(); j++)
	    if (noe[0] <= noeLimit+methylCorrection)//+2.5A
	    	found = true;
	}else if(resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HG2"))
	{
	    for (j=0; j<atomVec2.size(); j++)
	    {
	    	cc = (Cartesian) atomVec2.elementAt(j);
	    	atomName = cc.getAtom();
// 		noe[0] = distanceUp;
	    	if (atomName.equalsIgnoreCase("HG21") ||
	    			atomName.equalsIgnoreCase("HG22") ||
	    			atomName.equalsIgnoreCase("HG23"))
	    	{
	    		coordB = cc.getXYZ();
	    		distance = length(internuclearVec(coordB, coordA));
	    		if (distance < noe[0])
	    			noe[0] = distance;
	    	}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HD1"))
	{
	    for (j=0; j<atomVec2.size(); j++)
	    {
	    	cc = (Cartesian) atomVec2.elementAt(j);
	    	atomName = cc.getAtom();
// 		noe[0] = distanceUp;
	    	if (atomName.equalsIgnoreCase("HD11") ||
	    			atomName.equalsIgnoreCase("HD12") ||
	    			atomName.equalsIgnoreCase("HD13"))
	    	{
	    		coordB = cc.getXYZ();
	    		distance = length(internuclearVec(coordB, coordA));
	    		if (distance < noe[0])
	    			noe[0] = distance;
	    	}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD1"))
	{
	    for (j=0; j<atomVec2.size(); j++)
	    {
	    	cc = (Cartesian) atomVec2.elementAt(j);
	    	atomName = cc.getAtom();
	    	//noe[0] = distanceUp;
	    	if (atomName.equalsIgnoreCase("HD11") ||
	    			atomName.equalsIgnoreCase("HD12") ||
	    			atomName.equalsIgnoreCase("HD13"))
	    	{
	    		coordB = cc.getXYZ();
	    		distance = length(internuclearVec(coordB, coordA));
	    		if (distance < noe[0])
	    			noe[0] = distance;
	    	}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD1")){
	    for (j=0; j<atomVec2.size(); j++){
			cc = (Cartesian) atomVec2.elementAt(j);
			atomName = cc.getAtom();
//	 		noe[0] = distanceUp;
			if (atomName.equalsIgnoreCase("HD11") ||
			    atomName.equalsIgnoreCase("HD12") ||
			    atomName.equalsIgnoreCase("HD13")){
			    coordB = cc.getXYZ();
			    distance = length(internuclearVec(coordB, coordA));
			    if (distance < noe[0])
				noe[0] = distance;
			}
		    }
		    if (noe[0] <= noeLimit+methylCorrection)
			found = true;
		}	
	else if(resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD2")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
// 		noe[0] = distanceUp;
		if (atomName.equalsIgnoreCase("HD21") ||
		    atomName.equalsIgnoreCase("HD22") ||
		    atomName.equalsIgnoreCase("HD23")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG1")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
// 		noe[0] = distanceUp;
		if (atomName.equalsIgnoreCase("HG11") ||
		    atomName.equalsIgnoreCase("HG12") ||
		    atomName.equalsIgnoreCase("HG13")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG2")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
// 		noe[0] = distanceUp;
// 		System.out.println(" atomName= "+atomName);
		if (atomName.equalsIgnoreCase("HG21") ||
		    atomName.equalsIgnoreCase("HG22") ||
		    atomName.equalsIgnoreCase("HG23")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
// 	    System.out.println("Val "+noe[0]+" :  "+(noeLimit+methylCorrection) );
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("THR") && nucleus2.equalsIgnoreCase("HG2")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
// 		noe[0] = distanceUp;
		if (atomName.equalsIgnoreCase("HG21") ||
		    atomName.equalsIgnoreCase("HG22") ||
		    atomName.equalsIgnoreCase("HG23")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else { 
// 	    noe[0] = distanceUp;
	    if(nucleus2.equalsIgnoreCase("HN"))
		nucleus2 = "H";
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
		if (atomName.equalsIgnoreCase(nucleus2)){
		    coordB = cc.getXYZ();
		    noe[0] = length(internuclearVec(coordB, coordA));
		}
	    }
	    if (noe[0] <= noeLimit)
		found = true;
	}
	return found;
    }

    /**
     * Compute all the possible NOE peaks from the nucleus with coordA
     * to all other nuclei in a PDB structure, the.
     * 
     * @param pdbVec the pdb coordinates
     * @param no the reside no.
     * @param noeLimit the limitation set for NOEs
     * @param nucleus the nucleus
     * @param no2 the no2
     * @param nucleus2 the nucleus2
     * @param methylCorrection the methyl correction
     * @param noe the noe
     * 
     * @return  all the Peak objects within the specified range
     */
    public boolean checkNoe2(final Vector pdbVec, int no, String nucleus, int no2, 
			    String nucleus2, double noeLimit, double methylCorrection, double[] noe){
	double[] coordA = new double[3];
	double[] coordB = new double[3];
	Cartesian cc = null;
	String atomName ="", resid, aName ="";
	Vector pkVec = new Vector();
	Assign asg = new Assign();
	Map aMap = new TreeMap();
	double distance = 0.0;
	double cs = -999.99;
	int i, j;
	//search the source nucleus
	int index = Collections.binarySearch(pdbVec, new Pdb(no), new Pdb.PdbComparator());
	if (index < 0)
	    return false;
	Pdb pp = (Pdb)pdbVec.elementAt(index);
	Vector atomVec = pp.getAtomVec();
	for (i=0; i<atomVec.size(); i++){
	    cc = (Cartesian) atomVec.elementAt(i);
	    atomName = cc.getAtom();
	    if (atomName.equalsIgnoreCase(nucleus))
		coordA = cc.getXYZ();
	}

	int index2 = Collections.binarySearch(pdbVec, new Pdb(no2), new Pdb.PdbComparator());
	if (index2 < 0)
	    return false;
	Pdb pp2 = (Pdb)pdbVec.elementAt(index2);
	Vector atomVec2 = pp2.getAtomVec();
	resid = pp2.getResidue();
	double distanceUp = 1000.00;
	boolean found = false;
	double min = distanceUp;
	noe[0] = distanceUp;
	if(resid.equalsIgnoreCase("ALA") && nucleus2.equalsIgnoreCase("HB")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
		if (atomName.equalsIgnoreCase("HB1") ||
		    atomName.equalsIgnoreCase("HB2") ||
		    atomName.equalsIgnoreCase("HB3")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HG2")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
// 		noe[0] = distanceUp;
		if (atomName.equalsIgnoreCase("HG21") ||
		    atomName.equalsIgnoreCase("HG22") ||
		    atomName.equalsIgnoreCase("HG23")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("ILE") && nucleus2.equalsIgnoreCase("HD1")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
// 		noe[0] = distanceUp;
		if (atomName.equalsIgnoreCase("HD11") ||
		    atomName.equalsIgnoreCase("HD12") ||
		    atomName.equalsIgnoreCase("HD13")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD1")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
		noe[0] = distanceUp;
		if (atomName.equalsIgnoreCase("HD11") ||
		    atomName.equalsIgnoreCase("HD12") ||
		    atomName.equalsIgnoreCase("HD13")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("LEU") && nucleus2.equalsIgnoreCase("HD2")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
// 		noe[0] = distanceUp;
		if (atomName.equalsIgnoreCase("HD21") ||
		    atomName.equalsIgnoreCase("HD22") ||
		    atomName.equalsIgnoreCase("HD23")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG1")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
// 		noe[0] = distanceUp;
		if (atomName.equalsIgnoreCase("HG11") ||
		    atomName.equalsIgnoreCase("HG12") ||
		    atomName.equalsIgnoreCase("HG13")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("VAL") && nucleus2.equalsIgnoreCase("HG2")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
// 		noe[0] = distanceUp;
// 		System.out.println(" atomName= "+atomName);
		if (atomName.equalsIgnoreCase("HG21") ||
		    atomName.equalsIgnoreCase("HG22") ||
		    atomName.equalsIgnoreCase("HG23")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
// 	    System.out.println("Val "+noe[0]+" :  "+(noeLimit+methylCorrection) );
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else if(resid.equalsIgnoreCase("THR") && nucleus2.equalsIgnoreCase("HG2")){
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
// 		noe[0] = distanceUp;
		if (atomName.equalsIgnoreCase("HG21") ||
		    atomName.equalsIgnoreCase("HG22") ||
		    atomName.equalsIgnoreCase("HG23")){
		    coordB = cc.getXYZ();
		    distance = length(internuclearVec(coordB, coordA));
		    if (distance < noe[0])
			noe[0] = distance;
		}
	    }
	    if (noe[0] <= noeLimit+methylCorrection)
		found = true;
	}else { 
// 	    noe[0] = distanceUp;
	    if(nucleus2.equalsIgnoreCase("HN"))
		nucleus2 = "H";
	    for (j=0; j<atomVec2.size(); j++){
		cc = (Cartesian) atomVec2.elementAt(j);
		atomName = cc.getAtom();
		if (atomName.equalsIgnoreCase(nucleus2)){
		    coordB = cc.getXYZ();
		    noe[0] = length(internuclearVec(coordB, coordA));
		}
	    }
	    if (noe[0] <= noeLimit)
		found = true;
	}
	return found;
    }

    /**
     * Compute all the possible NOE peaks from the nucleus with coordA
     * to all other nuclei in a PDB structure, the.
     * 
     * @param asgVec the sorted resonance assignment
     * @param pdbVec the pdb coordinates
     * @param coordA the position (coordinate) of nuclues
     * @param noeLimit the limitation set for NOEs
     * @param methylCorrection the methyl correction
     * 
     * @return  all the Peak objects within the specified range
     */
    public Vector allNoes(final Vector pdbVec, final Vector asgVec, double[] coordA, double noeLimit, 
			  double methylCorrection){
	Cartesian cc = null;
	String atomName ="", resid, aName ="";
	Vector atomVec = new Vector();
	Vector pkVec = new Vector();
	Assign asg = new Assign();
	Map aMap = new TreeMap();
	int no;
	Pdb pp = new Pdb();
	double[] coordB = {0.0, 0.0, 0.0};
	double distance = 0.0;
	double cs = -999.99;
	int i, j;
	int index = -1;
	for (i=0; i<pdbVec.size(); i++){
	    pp = (Pdb)pdbVec.elementAt(i);
	    no = pp.getResidueNo();
	    index = Collections.binarySearch(asgVec, new Assign(no),  new Assign.assignComparator());
	    if (index > 0){
		asg = (Assign)asgVec.elementAt(index);
		aMap = asg.getMap();
	    }else aMap = new TreeMap();
	    resid = (pp.getResidue()).trim();
	    atomVec = pp.getAtomVec();
	    for (j=0; j<atomVec.size(); j++){
		cc = (Cartesian) atomVec.elementAt(j);
		atomName = cc.getAtom();
		if (atomName.indexOf("H") > - 1){
		    if (aMap.get(atomName) == null){ //No Name, either different nomaclature or NO assignment
			//the following Names does NOT appeared in BMRB
			if(resid.equalsIgnoreCase("ALA") && (atomName.equalsIgnoreCase("HB1") ||
							     atomName.equalsIgnoreCase("HB2") ||
							     atomName.equalsIgnoreCase("HB3"))){
			    aName = "HB";
			    cs = ((Double)aMap.get(aName)).doubleValue();
			    coordB = cc.getXYZ();
			    distance = (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
				+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
				+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
			    distance = Math.sqrt(distance); 
			    if (distance <= (noeLimit + methylCorrection))
				pkVec.add(new Peak(resid+no+"-"+aName, cs, distance));
			}else if(resid.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HG21") ||
								   atomName.equalsIgnoreCase("HG22") ||
								   atomName.equalsIgnoreCase("HG23"))){
			    aName = "HG2";
			    cs = ((Double)aMap.get(aName)).doubleValue();
			    coordB = cc.getXYZ();
			    distance =  (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
				+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
				+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
			    distance =  Math.sqrt(distance); 
			    if (distance <= (noeLimit + methylCorrection))
				pkVec.add(new Peak(resid+no+"-"+aName, cs, distance));

			}else if(resid.equalsIgnoreCase("ILE") && (atomName.equalsIgnoreCase("HD11") ||
								   atomName.equalsIgnoreCase("HD12") ||
								   atomName.equalsIgnoreCase("HD13"))){
			    aName = "HD1";
			    cs = ((Double)aMap.get(aName)).doubleValue();
			    coordB = cc.getXYZ();
			    distance =  (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
				+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
				+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
			    distance =  Math.sqrt(distance); 
			    if (distance <= (noeLimit + methylCorrection))
				pkVec.add(new Peak(resid+no+"-"+aName, cs, distance));

			}else if(resid.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD11") ||
								   atomName.equalsIgnoreCase("HD12") ||
								   atomName.equalsIgnoreCase("HD13"))){
			    aName = "HD1";
			    cs = ((Double)aMap.get(aName)).doubleValue();
			    coordB = cc.getXYZ();
			    distance =  (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
				+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
				+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
			    distance =  Math.sqrt(distance); 
			    if (distance <= (noeLimit + methylCorrection))
				pkVec.add(new Peak(resid+no+"-"+aName, cs, distance));

			}else if(resid.equalsIgnoreCase("LEU") && (atomName.equalsIgnoreCase("HD21") ||
								   atomName.equalsIgnoreCase("HD22") ||
								   atomName.equalsIgnoreCase("HD23"))){
			    aName = "HD2";
			    cs = ((Double)aMap.get(aName)).doubleValue();
			    coordB = cc.getXYZ();
			    distance =  (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
				+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
				+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
			    distance =  Math.sqrt(distance); 
			    if (distance <= (noeLimit + methylCorrection))
				pkVec.add(new Peak(resid+no+"-"+aName, cs, distance));

			}else if(resid.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG11") ||
								   atomName.equalsIgnoreCase("HG12") ||
								   atomName.equalsIgnoreCase("HG13"))){
			    aName = "HG1";
			    cs = ((Double)aMap.get(aName)).doubleValue();
			    coordB = cc.getXYZ();
			    distance =  (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
				+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
				+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
			    distance =  Math.sqrt(distance); 
			    if (distance <= (noeLimit + methylCorrection))
				pkVec.add(new Peak(resid+no+"-"+aName, cs, distance));
			}else if(resid.equalsIgnoreCase("VAL") && (atomName.equalsIgnoreCase("HG21") ||
								   atomName.equalsIgnoreCase("HG22") ||
								   atomName.equalsIgnoreCase("HG23"))){
			    aName = "HG2";
			    cs = ((Double)aMap.get(aName)).doubleValue();
			    coordB = cc.getXYZ();
			    distance =  (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
				+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
				+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
			    distance =  Math.sqrt(distance); 
			    if (distance <= (noeLimit + methylCorrection))
				pkVec.add(new Peak(resid+no+"-"+aName, cs, distance));
			}else if(resid.equalsIgnoreCase("THR") && (atomName.equalsIgnoreCase("HG21") ||
								   atomName.equalsIgnoreCase("HG22") ||
								   atomName.equalsIgnoreCase("HG23"))){
			    aName = "HG2";
			    cs = ((Double)aMap.get(aName)).doubleValue();
			    coordB = cc.getXYZ();
			    distance =  (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
				+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
				+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
			    distance =  Math.sqrt(distance); 
			    if (distance <= (noeLimit + methylCorrection))
				pkVec.add(new Peak(resid+no+"-"+aName, cs, distance));
			}else{  // No CS assignment for this nuclei
			    aName = atomName;
			    cs = -999.99;
			    coordB = cc.getXYZ();
			    distance =  (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
				+ (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
				+ (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
			    distance =  Math.sqrt(distance); 
			    if (distance <= noeLimit)
				pkVec.add(new Peak(resid+no+"-"+aName, cs, distance));
			}
		    }else { //there exists such protons with this name in the assignment table.
			//There are two items for amide protons: H from BMRB and HN assigned by me
			//And the HN one is the correct one for this data set
			if(atomName.equalsIgnoreCase("H"))
			    aName = "HN";
			else aName = atomName;
			cs = ((Double)aMap.get(aName)).doubleValue();
			coordB = cc.getXYZ();
			distance =  (coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
			    + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
			    + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]);
			distance =  Math.sqrt(distance); 
			if (distance <= noeLimit)
			    pkVec.add(new Peak(resid+no+"-"+aName, cs, distance));
		    }
		}
	    }
	}
	return pkVec;
    }

    /**
     * A method for back-computing NOEs, in the current implementation
     * only compute the NOEs from amide protons ("H" in the Pdb file).
     * 
     * @param pdbVec the Pdb structure.
     * @param asgVec the assignment table.
     */
    public void noeBackCompute(Vector pdbVec, Vector asgVec){
	Cartesian cc = null;
	String atomName="", resid;
	String atomName2="";
	Vector atoms = new Vector();
	Vector atomVec = new Vector();
	Vector pkVec = new Vector();
	int no;
	double [] coord = new double[3];
	double [] coordN = new double[3];
	Pdb pp = new Pdb();
	double[] hnCoord = {0.0, 0.0, 0.0};
	int i, j, k;
	double noeLimits = 5.0;
	Collections.sort(asgVec, new Assign.assignComparator());
	for (i=0; i<pdbVec.size(); i++){
	    pp = (Pdb)pdbVec.elementAt(i);
	    no = pp.getResidueNo();
	    System.out.println();
	    resid = (pp.getResidue()).trim();
// 	    if (!resid.equalsIgnoreCase("PRO")){
		atomVec = pp.getAtomVec();
		System.out.println(no+"  "+resid);
		for (j=0; j<atomVec.size(); j++){
		    cc = (Cartesian) atomVec.elementAt(j);
		    atomName = cc.getAtom();
		    if (atomName.equalsIgnoreCase("H")){
			hnCoord = cc.getXYZ();
			pkVec = allNoes(pdbVec, asgVec, hnCoord, noeLimits, Const.methylCorrection);
		    }
		}
		Collections.sort(pkVec, new Peak.csComparator());
		for (k=0; k<pkVec.size(); k++)
		    System.out.println( (Peak)pkVec.elementAt(k));
		System.out.println();
	    }
// 	}
    }

    /**
     * return NOEs between the two nuclei specified in the input if
     * exists.  Always return the larger one of the two possible NOE
     * intensity.  NOTE: We assume that the 1st nucleus is NH,
     * otherwise it is a bug
     * 
     * @param h1Vec  the sorted all proton CSs
     * @param asgVec resonance assignment table and the NOE peak list
     * @param no1 the first residue
     * @param nucleus1 the nuclues of residue no1, assume to be HN.
     * @param no2 the second residue
     * @param nucleus2 the nuclues of residue no2
     * @param noe for returning the find NOE intensity if exist
     * 
     * @return if found, return the intensity, otherwise, return -1.00;
     */
     public boolean noeSearch(final Vector h1Vec, final Vector asgVec, int no1, String nucleus1, 
			      int no2, String nucleus2, double[] noe){
	 double h1Err = 0.04;
	 int i=0, j=0, k = 0;
	 double inten  = -1.00;
	 //find the cs of the first 
	 int index1 = Collections.binarySearch(asgVec, new Assign(no1), new Assign.assignComparator());
	 if (index1 < 0)
	     return false;
	 Assign asg = (Assign)asgVec.elementAt(index1);
	 Map asgMap = asg.getMap();
	 if (asgMap.get(nucleus1) == null){
// 	     System.out.println(no1+" *** "+nucleus1);
	     return false;
	 }
	 double cs1 = ((Double)asgMap.get(nucleus1)).doubleValue();
	 Vector hnNoeVec = asg.getHnNoeVec();
	 HnNoe hnNoe = new HnNoe();
	 //find the cs of the first 
	 Assign asg2 = new Assign();
	 Map asgMap2 = new TreeMap();
	 if(no1 == no2)
	     asgMap2 = asgMap;
	 else {
	     index1 = Collections.binarySearch(asgVec, new Assign(no2), new Assign.assignComparator());
	     if (index1 < 0)
		 return false;
	     asg2 = (Assign)asgVec.elementAt(index1);
	     asgMap2 = asg2.getMap();
	 }
	 if (asgMap2.get(nucleus2) == null){
// 	     System.out.println(no2+"  ***"+nucleus2);
	     return false;
	 }
	 double cs2 = ((Double)asgMap2.get(nucleus2)).doubleValue();
	 if (Math.abs(cs1 - Const.noDataIndicator) < Const.eps || Math.abs(cs2 - Const.noDataIndicator) < Const.eps){
// 	     System.out.println(no1+" *** "+nucleus1+"  "+ no2+" *** "+nucleus2);
	     return false;
	 }
// 	 System.out.println("cs2 = "+cs2);
	 double csOfB = 0.0;
	 Vector bVec = new Vector();
	 String nucleus, resId, res;
	 int resNo2;
	 Peak pk = new Peak();
	 int index = -1;
	 double intenTmp = -1;
	 if (nucleus1.equalsIgnoreCase("HN")){
	     for(j=0; j<hnNoeVec.size(); j++){
		 hnNoe = (HnNoe) hnNoeVec.elementAt(j);
// 		 System.out.println(hnNoe);
		 csOfB = hnNoe.getH1();
		 if (Math.abs(csOfB - cs2) <= h1Err){
		     bVec = rangeSearch(h1Vec, csOfB, h1Err); //we search through CS to 
		     for (k=0; k<bVec.size(); k++){
			 pk = (Peak)bVec.elementAt(k);
			 resId = pk.getNucleus(); //resId = aaType+no+"-"+nucleus;
			 index = resId.indexOf("-");
			 resNo2 = Integer.parseInt(resId.substring(3, index));
			 res = resId.substring(0, 3);
			 nucleus = resId.substring(index+1);
// 			 System.out.println(hnNoe);
//  			 System.out.println("ID = "+ no1+"H <--> "+resNo2+"  "+res+"  "+nucleus);
			 if (resNo2 == no2 && nucleus.equalsIgnoreCase(nucleus2)){
			     intenTmp = hnNoe.getIntensity();
			     if (intenTmp > inten)
				 inten = intenTmp;
			 }
		     }
		 }
// 		 System.out.println("---");
	     }
	 }
// 	 System.out.println();
// 	 System.out.println("Inten "+inten);
// 	 System.out.println("****");
// 	 System.out.println("****");
	 double inten1 = -1.00;
	 if (nucleus2.equalsIgnoreCase("HN")){ //if both are HNs, only return larger intensity
	     hnNoeVec = asg2.getHnNoeVec();
	     for(j=0; j<hnNoeVec.size(); j++){
		 hnNoe = (HnNoe) hnNoeVec.elementAt(j);
// 		 System.out.println(hnNoe);
		 csOfB = hnNoe.getH1();
		 if (Math.abs(csOfB - cs1) <= h1Err){
		     bVec = rangeSearch(h1Vec, csOfB, h1Err);
		     for (k=0; k<bVec.size(); k++){
			 pk = (Peak)bVec.elementAt(k);
			 resId = pk.getNucleus(); //resId = aaType+no+"-"+nucleus;
			 index = resId.indexOf("-");
			 resNo2 = Integer.parseInt(resId.substring(3, index));
			 res = resId.substring(0, 3);
			 nucleus = resId.substring(index+1);
// 			 System.out.println(hnNoe);
//  			 System.out.println("ID = "+ no2+"H <==> "+resNo2+"  "+res+"  "+nucleus);
			 if (resNo2 == no1 && nucleus.equalsIgnoreCase(nucleus1)){
			     intenTmp = hnNoe.getIntensity();
			     if (intenTmp > inten1)
				 inten1 = intenTmp;
			 }
		     }
		 }
	     }
	 }
	 if (inten < inten1)
	     inten = inten1;
	 noe[0] = inten;
	 return true;
     }

    /**
     * A temporary method to relate NOE intensity with distance,.
     * 
     * @param h1Vec a sorted all H1 cs array
     * @param asgVec an assign Vector with assignment tablem and both HN and HA NOEs peak list
     * @param pdbVec the Pdb file
     */
    public void intensityVsDistance(final Vector h1Vec, final Vector asgVec, Vector pdbVec){
	int i = 0, j = 0, k = 0;
	Vector oneHnVec = new Vector();
 	Vector oneHaVec = new Vector();
 	Vector oneH1Vec = new Vector();
	Assign asg  = new Assign();
	Peak   pk   = new Peak();
	Pdb pp = new Pdb();
	double h1Err = 0.04;
	double csOfB = 0.0; //the CS of the NOE partner 
	HnNoe hnNoe = new HnNoe();
	int resNo1 = 0,  resNo2 = 0,  resNo3 = 0;
	Vector bVec = new Vector();
	Vector cVec = new Vector();
	String resId = "", aaType ="", nucleus, res="";
	int index = 0;
	HcchTocsy hcch = new HcchTocsy();
	double [] dis1 = new double[1];
	boolean hasNOE = false;
	double dis2 = 0.0;
	double a1 = -1.10764563682241;  //Those two numbers are fitted (see matlab file)
	double a2 = 1442.04217588463;
	double inten1 = 0.0;
	System.out.println();
	for(i=0; i<asgVec.size(); i++){
	    asg = (Assign)asgVec.elementAt(i);
	    oneHnVec = asg.getHnNoeVec(); //HN peak list
//  	    oneHaVec = asg.getHaNoeVec();
// 	    oneH1Vec = asg.getH1NoeVec();
	    resNo1 = asg.getResidueNo();
	    aaType = asg.getResidueType();
 	    System.out.println(resNo1+"  "+aaType);
	    bVec = new Vector();
	    for(j=0; j<oneHnVec.size(); j++){
		hnNoe = (HnNoe) oneHnVec.elementAt(j);
   		System.out.println(hnNoe);
		csOfB = hnNoe.getH1();
		if (csOfB > 3.00){ //only those backbone protons and a few others
		    bVec = rangeSearch(h1Vec, csOfB, h1Err);
		    if (bVec.isEmpty()){
			System.out.println("NO Assign:  "+hnNoe);
			break;
		    }
		    // 		System.out.println(bVec.size());
		    //  		if (bVec.size() < 3){
		    for (k=0; k<bVec.size(); k++){
			pk = (Peak)bVec.elementAt(k);
			System.out.println(pk);
			resId = pk.getNucleus();
			index = resId.indexOf("-");
			resNo2 = Integer.parseInt(resId.substring(3, index));
			res = resId.substring(0, 3);
			nucleus = resId.substring(index+1);
			//System.out.println("ID = "+ resNo1+"H <--> "+resNo2+"  "+res+"  "+nucleus);
			hasNOE = pp.measureDis(pdbVec, resNo1, aaType, "H", resNo2, res, nucleus, dis1);
			inten1 = hnNoe.getIntensity();
			dis2 = Math.pow(a2 / (inten1 - a1), 0.25);
			System.out.println(dis1[0]+"  "+inten1+"  "+dis2);
			if (Math.abs(dis1[0]) > 0.001 && Math.abs(dis1[0]) < 5.01 && Math.abs(dis1[0] - dis2) < 2.0 ){
			    //  			if (dis1 > 5.0 && bVec.size() == 1){
//   			    System.out.println(hnNoe);
// 			    System.out.println(pk);
// 			    System.out.println(dis1+"  "+dis2);
			    if (resNo2 == resNo1) {
				System.out.println("Intra NOEs:");
// 				System.out.println(pk);
			    }else if ( Math.abs(resNo2 - resNo1) == 1 ){
				System.out.print("Seq NOEs:  ");
// 				System.out.println(pk);
			    }else if (Math.abs(resNo2 - resNo1) > 1 && Math.abs(resNo2 - resNo1) <= 3){
				System.out.print("Med NOEs:  ");
// 				System.out.println(pk);
			    }else {
				// 			    System.out.println(hnNoe);
				// 			    System.out.println(resNo1+":  "+bVec.size());
				System.out.print("Long NOEs:  ");
// 				System.out.println(pk);
				// 			    }
			    }
			}else if ( Math.abs(dis1[0]) <= 0.001){
			    System.out.println("NO such nuclei in PDB file");
			    
			}else if ( Math.abs(dis1[0]) > 5.01 || Math.abs(dis1[0] - dis2) >= 2.0)
			    System.out.println("Filtered by RDCs:  "+ dis1[0]+"   "+Math.abs(dis1[0] - dis2));
			 System.out.println();
		    }
 		    System.out.println();
 		    System.out.println();
		}
	    }
	}
    }

    /**
     * Compute the possbile NOE assignment matrix, an idea not further pursued.
     * 
     * @param h1Vec the h1 vec
     * @param asgVec the asg vec
     * 
     * @return the matrix
     */
    public Matrix noeAssignMat(final Vector h1Vec, final Vector asgVec){
	int i = 0, j = 0, k = 0;
	Vector oneHnVec = new Vector();
 	Vector oneHaVec = new Vector();
 	Vector oneH1Vec = new Vector();
	Assign asg  = new Assign();
	Peak   pk   = new Peak();
	double h1Err = 0.04;
	double csOfB = 0.0; //the CS of the NOE partner 
	HnNoe hnNoe = new HnNoe();
	int resNo1 = 0,  resNo2 = 0,  resNo3 = 0;
	Vector bVec = new Vector();
	Vector cVec = new Vector();
	String resId = "", aaType ="";
	int index = 0;
	HcchTocsy hcch = new HcchTocsy();
	Matrix closeMat = Matrix.identity(73, 73);
	for(i=0; i<asgVec.size(); i++){
	    asg = (Assign)asgVec.elementAt(i);
	    oneHnVec = asg.getHnNoeVec();
 	    oneHaVec = asg.getHaNoeVec();
// 	    oneH1Vec = asg.getH1NoeVec();
	    resNo1 = asg.getResidueNo();
	    aaType = asg.getResidueType();
// 	    System.out.println(resNo1+"  "+aaType);
	    for(j=0; j<oneHnVec.size(); j++){
		hnNoe = (HnNoe) oneHnVec.elementAt(j);
		csOfB = hnNoe.getH1();
		if (csOfB > 3.30){
		    bVec = rangeSearch(h1Vec, csOfB, h1Err);
		    for (k=0; k<bVec.size(); k++){
			pk = (Peak)bVec.elementAt(k);
			resId = pk.getNucleus();
			index = resId.indexOf("-");
			resNo2 = Integer.parseInt(resId.substring(3, index));
			closeMat.set(resNo1, resNo2, 1.0);
		    }
		}
	    }
	    for(j=0; j<oneHaVec.size(); j++){
		hcch = (HcchTocsy) oneHaVec.elementAt(j);
		csOfB = hcch.getH1();
		if (csOfB > 3.30){
		    cVec = rangeSearch(h1Vec, csOfB, h1Err);
		    for (k=0; k<cVec.size(); k++){
			pk = (Peak)cVec.elementAt(k);
			resId = pk.getNucleus();
			index = resId.indexOf("-");
			resNo3 = Integer.parseInt(resId.substring(3, index));
			closeMat.set(resNo1, resNo3, 1.0);
		    }
		}
	    }
	}
	return closeMat;
    }
}
