package Nasca;
/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/
import java.util.Vector;

import rdcPanda.Assign;
import rdcPanda.H1CS;
import rdcPanda.Peak;
import Jampack.JampackException;

public class Evaluation {

	public  static void main (String[] args) throws JampackException
	{
		H1CS h1CS=new H1CS();    	
		Assign asg = new Assign();
		
		//read the NMR data and input parameters:
		
		
		 
		 //ubq data
		String userDir = System.getProperty("user.dir");
		String src=userDir+"/inputFiles/";  //input file directory	
		String strCSRef="ubc_cyana_prot-convert.txt";		
		String strResFormatRef="CYANA";
		String strSeq="UBQ.seq";
		String strCSNameFormat="BMRB-NEW";
		String strCSNasca="resonance_nasca.prot";
		String strSAS="SAS.txt";
		
		
		//hsri data
		/*	String userDir = System.getProperty("user.dir"); 
		String src=userDir+"/inputFiles/";  //input file directory	
		String strCSRef="hsri_bmrb.prot";		
		String strResFormatRef="BMRB";
		String strSeq="hsri.seq";
		String strCSNameFormat="BMRB-NEW";
		String strCSNasca="resonance_nasca.prot";
		String strSAS="SAS.txt";
		*/
		
		//gb1 data
	/*	String userDir = System.getProperty("user.dir");
		String src=userDir+"/inputFiles/";  //input file directory	
		String strCSRef="gb1_cyana.prot";		
		String strResFormatRef="CYANA";
		String strSeq="gb1.seq";
		String strCSNameFormat="BMRB-NEW";
		
		String strCSNasca="resonance_nasca.prot";
		String strSAS="SAS.txt";
		*/
		
		//ff2 data
	/*	String userDir = System.getProperty("user.dir");
		String src=userDir+"/inputFiles/";  //input file directory	
		String strCSRef="ff2.prot";		
		String strResFormatRef="CYANA";
		String strSeq="ff2.seq";
		String strCSNameFormat="BMRB-NEW";
		
		String strCSNasca="resonance_nasca.prot";
		String strSAS="SAS.txt";
		*/
		
	/*	//eta data
			String userDir = System.getProperty("user.dir");
		String src=userDir+"/inputFiles/";  //input file directory	
		String strCSRef="eta_bmrb.prot";		
		String strResFormatRef="BMRB";
		String strSeq="eta.seq";
		String strCSNameFormat="BMRB-NEW";
		
		String strCSNasca="resonance_nasca.prot";
		String strSAS="SAS.txt";
		*/
		
		//////////////////////////////////////
		//read the ref chemical shift table:
		String seqFile = src + strSeq;
    	//this is the vector of residues (protein sequence)
    	Vector<Assign> vecSeq=asg.ReaderSeq(seqFile);    	
		
		Vector<H1CS> vecChemShiftRef=new Vector<H1CS>(); //ref chemical shift list
		String assignFile = src+ strCSRef; //ref cs file name:
		if(strResFormatRef.equalsIgnoreCase("CYANA"))
			vecChemShiftRef=h1CS.h1CSReader(assignFile,vecSeq); 
    	else if(strResFormatRef.equalsIgnoreCase("BMRB"))
    		vecChemShiftRef=h1CS.h1CSReader_BMRB(assignFile);  
    	else 
    	{
    		System.out.println("unknown format of the resonance file...");
    		System.exit(0);
    	}
		if(strCSNameFormat.equalsIgnoreCase("BMRB-NEW")){
			
			Vector<H1CS> vecAsgNew=new Vector<H1CS>();		
			vecAsgNew=h1CS.CSNameConvertFromBMRBNewToPDBNew(vecChemShiftRef);//assume that the default naming scheme of chemical shift is BMRB
			vecChemShiftRef=new Vector<H1CS>();
			vecChemShiftRef.addAll(vecAsgNew);
		}
			
		//////////////////////////////////////
		//read the chemical shift table computed by NASCA
		Vector<H1CS> vecChemShiftNasca=new Vector<H1CS>(); //nasca chemical shift list
		assignFile = src+ strCSNasca; //ref cs file name:
		vecChemShiftNasca=h1CS.h1CSReader(assignFile,vecSeq); //currently nasca cs list is alway in "CYANA" format
		

		///////////////////////////////////////   	
    	//compare with the reference resonance assignment list:
    	//this information is for debugging, and evaluating the performance.
		Evaluation eva=new Evaluation();
		
		System.out.println("=============================================== ");
		System.out.println("Evaluation on different atom types: ");
		System.out.println("=============================================== ");
		eva.EvaluateCSAssignmentDiffAtoms(vecChemShiftNasca,vecChemShiftRef);    	
    	
		System.out.println("=============================================== ");
		System.out.println("Evaluation on different residue types: ");
		System.out.println("=============================================== ");
		eva.EvaluateCSAssignmentDiffResidues(vecChemShiftNasca,vecChemShiftRef);   
		
		System.out.println("=============================================== ");
		System.out.println("Evaluation on residues with different solvent accessible surfaces: ");
		System.out.println("=============================================== ");
		String strSASFile=src+strSAS;
		SAS sas=new SAS();
		Vector<SAS> vecSAS=sas.SASReader(strSASFile);
		eva.EvaluateCSAssignmentDiffSAS(vecChemShiftNasca, vecChemShiftRef, vecSAS);
		
		
	}  // End main()
	
	/**
	 * evaluation different atom types.
	 * 
	 * @param vecSrcAsg original assignment list
	 * @param vecRefAsg reference assignment list
	 * @param 
	 */
	public void EvaluateCSAssignmentDiffAtoms(Vector vecSrcAsg,Vector vecRefAsg)
	{
		double csErrH=0.05;
		double csErrHeavy=0.5;
		
		Peak pk=new Peak();
		int totalScH=0;
		int missing=0;
		double wrong=0.0;
		double correct=0.0;
		double correctI=0.0;
		double correctII=0.0;
		double nTotalClassII=0.0,nTotalClassI=0.0;
		Assign asg=new Assign();		
		double nTotalAsgs=0.0;//all proton resonance assignments, including both bb and sc
		double nTotalHb=0.0, nTotalHg=0.0,nTotalHd=0.0,nTotalHe=0.0,nTotalR=0.0;//total number of resonances for different atom types.
		double correctHb=0.0,correctHg=0.0,correctHd=0.0,correctHe=0.0,correctR=0.0;
		
		for(int k=0;k<vecSrcAsg.size();k++){
			H1CS h1cs=(H1CS)vecSrcAsg.elementAt(k);
			String res=h1cs.getResidueType();
			String atom=h1cs.getAtomName();
			if(atom.length()<2)
				continue;
			if(atom.substring(0, 1).equalsIgnoreCase("H")){
				nTotalAsgs=nTotalAsgs+1;
				if(res.equalsIgnoreCase("VAL")||res.equalsIgnoreCase("ILE")||res.equalsIgnoreCase("LEU")||res.equalsIgnoreCase("MET")
						||res.equalsIgnoreCase("PHE")||res.equalsIgnoreCase("TRP")||res.equalsIgnoreCase("CYS") )
					nTotalClassI=nTotalClassI+1;
				else if( !(res.equalsIgnoreCase("ALA") || res.equalsIgnoreCase("GLY")) )
					nTotalClassII=nTotalClassII+1;
				
				
				//atom=atom.substring(0,2);
				
				if( (res.equalsIgnoreCase("PHE")||res.equalsIgnoreCase("HIS")||res.equalsIgnoreCase("TRP") ||res.equalsIgnoreCase("TYR") ) && !(atom.equalsIgnoreCase("HB")) )
					nTotalR=nTotalR+1;
				else{			
					atom=atom.substring(0,2);
					if(atom.equalsIgnoreCase("HB") )
						nTotalHb=nTotalHb+1;
					if(atom.equalsIgnoreCase("HG") )
						nTotalHg=nTotalHg+1;
					if(atom.equalsIgnoreCase("HD") )
						nTotalHd=nTotalHd+1;
					if(atom.equalsIgnoreCase("HE") )
						nTotalHe=nTotalHe+1;
				}				
			}//if(atom.substring(0, 1).equalsIgnoreCase("H"))
		}//for(int k=0;k<vecSrcAsg.size();k++)
		
		
		for(int j=0;j<vecSrcAsg.size();j++)
		{
			H1CS h1csA=(H1CS)vecSrcAsg.elementAt(j);
			int resNoA=h1csA.getResidueNo();
			String resA=h1csA.getResidueType();
			String atomA=h1csA.getAtomName();
			double cs_hA=h1csA.getH1CS();	
			if(!atomA.substring(0,1).equalsIgnoreCase("H"))
				continue;
			
			boolean isFound=false;
			boolean isCorrect=false;
			
			for(int k=0;k<vecRefAsg.size();k++)
			{
				H1CS h1cs=(H1CS)vecRefAsg.elementAt(k);
				int resRefNo=h1cs.getResidueNo();
				String resRef=h1cs.getResidueType();
				String atomRef=h1cs.getAtomName();
				double csRef=h1cs.getH1CS();
				/////////////
				String subAtomTwo="";
	    		if(atomRef.length()>2)
	    			subAtomTwo=atomRef.substring(0,2);
	    		else
	    			subAtomTwo=atomRef;
	    		String atomRefStereo="";
				if(subAtomTwo.equalsIgnoreCase("HB"))
	    		{
	    			if(resRef.equalsIgnoreCase("CYS")||resRef.equalsIgnoreCase("ASP")||resRef.equalsIgnoreCase("GLU")||
	    					resRef.equalsIgnoreCase("PHE")||resRef.equalsIgnoreCase("HIS")||resRef.equalsIgnoreCase("LYS")||
	    					resRef.equalsIgnoreCase("LEU")||resRef.equalsIgnoreCase("MET")||resRef.equalsIgnoreCase("ASN")||
	    					resRef.equalsIgnoreCase("PRO")||resRef.equalsIgnoreCase("GLN")||resRef.equalsIgnoreCase("ARG")||
	    					resRef.equalsIgnoreCase("SER")||resRef.equalsIgnoreCase("TRP")||resRef.equalsIgnoreCase("TYR"))
	    			{
	    				if(atomRef.equalsIgnoreCase("HB1"))
	    					atomRefStereo="HB2";
	    				else if(atomRef.equalsIgnoreCase("HB2"))
	    					atomRefStereo="HB1";
	    			}   			
	    		}    		
	    		if(subAtomTwo.equalsIgnoreCase("HA")&& resRef.equalsIgnoreCase("GLY") )
	    		{
	    			if(atomRef.equalsIgnoreCase("HA1"))
	    				atomRefStereo="HA2";
					else if(atomRef.equalsIgnoreCase("HA2"))
						atomRefStereo="HA1";
	    		}
	    		if((subAtomTwo.equalsIgnoreCase("HG")||subAtomTwo.equalsIgnoreCase("CG"))  && 
	    				resRef.equalsIgnoreCase("VAL")  )//changed...
	    		{
	    			if(atomRef.equalsIgnoreCase("HG1"))
	    				atomRefStereo="HG2";
					else if(atomRef.equalsIgnoreCase("HG2"))
						atomRefStereo="HG1";
					else if(atomRef.equalsIgnoreCase("CG1"))
						atomRefStereo="CG2";
					else if(atomRef.equalsIgnoreCase("CG2"))
						atomRefStereo="CG1";
	    		}
	    		if((subAtomTwo.equalsIgnoreCase("HD")||subAtomTwo.equalsIgnoreCase("CD"))&& resRef.equalsIgnoreCase("LEU") )
	    		{
	    			if(atomRef.equalsIgnoreCase("HD1"))
	    				atomRefStereo="HD2";
					else if(atomRef.equalsIgnoreCase("HD2"))
						atomRefStereo="HD1";
					else if(atomRef.equalsIgnoreCase("CD1"))
						atomRefStereo="CD2";
					else if(atomRef.equalsIgnoreCase("CD2"))
						atomRefStereo="CD1";
	    		}
				/////////////
	    		if(subAtomTwo.equalsIgnoreCase("HG")  && (resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("GLU")||
	    						resRef.equalsIgnoreCase("LYS")||resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("PRO")||
	    						resRef.equalsIgnoreCase("ARG") ) )//changed...
	    		{
	    			if(atomRef.equalsIgnoreCase("HG1"))
	    				atomRefStereo="HG2";
					else if(atomRef.equalsIgnoreCase("HG2"))
						atomRefStereo="HG1";				
	    		}
	    		if(subAtomTwo.equalsIgnoreCase("HD")  && (resRef.equalsIgnoreCase("PHE") || 
	    				resRef.equalsIgnoreCase("LYS")||resRef.equalsIgnoreCase("PRO")||
	    				resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("TYR")  ) )//changed...
				{
					if(atomRef.equalsIgnoreCase("HD1"))
						atomRefStereo="HD2";
					else if(atomRef.equalsIgnoreCase("HD2"))
						atomRefStereo="HD1";				
				}
	    		if(subAtomTwo.equalsIgnoreCase("HE")  && (resRef.equalsIgnoreCase("PHE") || 
	    				resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("TYR")  ) )//changed...
				{
					if(atomRef.equalsIgnoreCase("HE1"))
						atomRefStereo="HE2";
					else if(atomRef.equalsIgnoreCase("HE2"))
						atomRefStereo="HE1";				
				}
	    		if(atomRef.length()>=3)
	    		{
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HG1") && resRef.equalsIgnoreCase("ILE"))
					{
						if(atomRef.equalsIgnoreCase("HG11"))
							atomRefStereo="HG12";
						else if(atomRef.equalsIgnoreCase("HG12"))
							atomRefStereo="HG11";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HD2") && resRef.equalsIgnoreCase("ASN"))
					{
						if(atomRef.equalsIgnoreCase("HD21"))
							atomRefStereo="HD22";
						else if(atomRef.equalsIgnoreCase("HD22"))
							atomRefStereo="HD21";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HE2") && resRef.equalsIgnoreCase("GLN"))
					{
						if(atomRef.equalsIgnoreCase("HE21"))
							atomRefStereo="HE22";
						else if(atomRef.equalsIgnoreCase("HE22"))
							atomRefStereo="HE21";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HH1") && resRef.equalsIgnoreCase("ARG"))
					{
						if(atomRef.equalsIgnoreCase("HH11"))
							atomRefStereo="HH12";
						else if(atomRef.equalsIgnoreCase("HH12"))
							atomRefStereo="HH11";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HH2") && resRef.equalsIgnoreCase("ARG"))
					{
						if(atomRef.equalsIgnoreCase("HH21"))
							atomRefStereo="HH22";
						else if(atomRef.equalsIgnoreCase("HH22"))
							atomRefStereo="HH21";				
					}
	    		}
	    		if(subAtomTwo.equalsIgnoreCase("HH")  && resRef.equalsIgnoreCase("ARG")  )//changed...
				{
					if(atomRef.equalsIgnoreCase("HH1"))
						atomRefStereo="HH2";
					else if(atomRef.equalsIgnoreCase("HH2"))
						atomRefStereo="HH1";				
				}
	    		
	    		/////////////////
				if( !(atomRef.substring(0,1).equalsIgnoreCase("H") || atomRef.substring(0,1).equalsIgnoreCase("C")||atomRef.substring(0,1).equalsIgnoreCase("N"))   )
					continue;
				
				String subAtom=atomA;
				double csErr=0.0;
				if(atomRef.substring(0,1).equalsIgnoreCase("H"))
					csErr=csErrH;
				else
					csErr=csErrHeavy;
				
				if(atomA.length()>atomRef.length())
					subAtom=atomA.substring(0,atomRef.length());
				
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRef) )
					isFound=true;
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRefStereo) )
					isFound=true;
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRef) && Math.abs(csRef-cs_hA)<csErr)
					isCorrect=true;		
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRefStereo) && Math.abs(csRef-cs_hA)<csErr)
					isCorrect=true;	
			}//for(int k=0;k<vecRefAsg.size();k++)
			
			if(!isFound)
			{
				//System.out.println("Missing resonance assignment: "+ resNoA +" "+ resA+ " - " +atomA);
				missing++;
			}
			else
			{
				if(!isCorrect)			
				{
					//System.out.println("...Wrong resonance assignment: "+ resNoA +" "+ resA+ " - " +atomA);
					wrong=wrong+1;
				}
				else
				{
					correct=correct+1;
					
					//atomA=atomA.substring(0,2);
					if((resA.equalsIgnoreCase("PHE")||resA.equalsIgnoreCase("HIS")||resA.equalsIgnoreCase("TRP") ||resA.equalsIgnoreCase("TYR"))&& !(atomA.equalsIgnoreCase("HB")))
						correctR=correctR+1;
					else{
						atomA=atomA.substring(0,2);
						if(atomA.equalsIgnoreCase("HB") )
							correctHb=correctHb+1;
						if(atomA.equalsIgnoreCase("HG") )
							correctHg=correctHg+1;
						if(atomA.equalsIgnoreCase("HD") )
							correctHd=correctHd+1;
						if(atomA.equalsIgnoreCase("HE") )
							correctHe=correctHe+1;
					}				
					
					
					if(resA.equalsIgnoreCase("VAL")||resA.equalsIgnoreCase("ILE")||resA.equalsIgnoreCase("LEU")||resA.equalsIgnoreCase("MET")
							||resA.equalsIgnoreCase("PHE")||resA.equalsIgnoreCase("TRP")||resA.equalsIgnoreCase("CYS") )
						correctI=correctI+1;
					else if( !(resA.equalsIgnoreCase("ALA") || resA.equalsIgnoreCase("GLY")) )
						correctII=correctII+1;
				}
			}
			
			totalScH++;
		}//for(int j=0;j<vecSrcAsg.size();j++)

		System.out.println("Total number of protons (including both bb and sc protons): "+ totalScH);
		System.out.println("Total number of missing sidechain assignments: "+ missing);
		System.out.println("Total number of wrong sidechain assignments: "+ wrong);		
		System.out.println("Total number of correct resonance assignments: "+correct);
		//System.out.println("Total number of side chain proton resonance assignments: "+ (nTotalAsgs-nTotalBBAsgs));
		System.out.println("Percentage of correct proton resonance assignments (including both bb and sc resonances): "+(double)( correct/nTotalAsgs ));
		System.out.println("Percentage of correct proton resonance assignments for class I residues: "+(double)( correctI/nTotalClassI ));
		System.out.println("Percentage of correct proton resonance assignments for class II residues: "+(double)( correctII/nTotalClassII ));
		
		System.out.println("Percentage of correct resonance assignments for Cb-Hb: "+(double)( correctHb/nTotalHb ));
		System.out.println("Percentage of correct resonance assignments for Cg-Hg: "+(double)( correctHg/nTotalHg ));
		System.out.println("Percentage of correct resonance assignments for Cd-Hd: "+(double)( correctHd/nTotalHd ));
		System.out.println("Percentage of correct resonance assignments for Ce-He: "+(double)( correctHe/nTotalHe ));
		System.out.println("Percentage of correct resonance assignments for aromatic protons: "+(double)( correctR/nTotalR ));
		
	}
	
	/**
	 * evaluation based on different sas values.
	 * 
	 * @param vecSrcAsg original assignment list
	 * @param vecRefAsg reference assignment list
	 * @param 
	 */
	public void EvaluateCSAssignmentDiffSAS(Vector vecSrcAsg,Vector vecRefAsg,Vector<SAS> vecSAS)
	{
		SAS sas=new SAS();
		double csErrH=0.05;
		double csErrHeavy=0.5;
		
		Peak pk=new Peak();
		int totalScH=0;
		int missing=0;
		double wrong=0.0;
		double correct=0.0;
		double correctI=0.0;
		double correctII=0.0;
		double nTotalClassII=0.0,nTotalClassI=0.0;
		Assign asg=new Assign();		
		double nTotalAsgs=0.0;//all proton resonance assignments, including both bb and sc
		double nTotalSas0_10=0.0, nTotalSas30_40=0.0,nTotalSas10_20=0.0,nTotalSas20_30=0.0,nTotalSas40_100=0.0;//total number of resonances for different atom types.
		double correctSas0_10=0.0,correctSas30_40=0.0,correctSas10_20=0.0,correctSas20_30=0.0,correctSas40_100=0.0;
		
		for(int k=0;k<vecSrcAsg.size();k++){
			H1CS h1cs=(H1CS)vecSrcAsg.elementAt(k);
			String res=h1cs.getResidueType();
			String atom=h1cs.getAtomName();
			int no=h1cs.getResidueNo();
			if(atom.length()<2)
				continue;
			if(atom.substring(0, 1).equalsIgnoreCase("H")){
				nTotalAsgs=nTotalAsgs+1;
				if(res.equalsIgnoreCase("VAL")||res.equalsIgnoreCase("ILE")||res.equalsIgnoreCase("LEU")||res.equalsIgnoreCase("MET")
						||res.equalsIgnoreCase("PHE")||res.equalsIgnoreCase("TRP")||res.equalsIgnoreCase("CYS") )
					nTotalClassI=nTotalClassI+1;
				else if( !(res.equalsIgnoreCase("ALA") || res.equalsIgnoreCase("GLY")) )
					nTotalClassII=nTotalClassII+1;
				
				double dbSASValue=sas.findSAS(vecSAS, no, atom);
				if( (dbSASValue>=0) &&  (dbSASValue< 10) )
					nTotalSas0_10=nTotalSas0_10+1;				
				else if((dbSASValue>=10) &&  (dbSASValue< 20) ) 				
					nTotalSas10_20=nTotalSas10_20+1;				
				else if((dbSASValue>=20) &&  (dbSASValue< 30) ) 				
					nTotalSas20_30=nTotalSas20_30+1;
				else if((dbSASValue>=30) &&  (dbSASValue< 40) ) 				
					nTotalSas30_40=nTotalSas30_40+1;
				else if((dbSASValue>=40) &&  (dbSASValue<=100) ) 				
					nTotalSas40_100=nTotalSas40_100+1;
			}//if(atom.substring(0, 1).equalsIgnoreCase("H"))
		}//for(int k=0;k<vecSrcAsg.size();k++)
		
		
		for(int j=0;j<vecSrcAsg.size();j++)
		{
			H1CS h1csA=(H1CS)vecSrcAsg.elementAt(j);
			int resNoA=h1csA.getResidueNo();
			String resA=h1csA.getResidueType();
			String atomA=h1csA.getAtomName();
			double cs_hA=h1csA.getH1CS();	
			if(!atomA.substring(0,1).equalsIgnoreCase("H"))
				continue;
			
			boolean isFound=false;
			boolean isCorrect=false;
			
			for(int k=0;k<vecRefAsg.size();k++)
			{
				H1CS h1cs=(H1CS)vecRefAsg.elementAt(k);
				int resRefNo=h1cs.getResidueNo();
				String resRef=h1cs.getResidueType();
				String atomRef=h1cs.getAtomName();
				double csRef=h1cs.getH1CS();
				/////////////
				String subAtomTwo="";
	    		if(atomRef.length()>2)
	    			subAtomTwo=atomRef.substring(0,2);
	    		else
	    			subAtomTwo=atomRef;
	    		String atomRefStereo="";
				if(subAtomTwo.equalsIgnoreCase("HB"))
	    		{
	    			if(resRef.equalsIgnoreCase("CYS")||resRef.equalsIgnoreCase("ASP")||resRef.equalsIgnoreCase("GLU")||
	    					resRef.equalsIgnoreCase("PHE")||resRef.equalsIgnoreCase("HIS")||resRef.equalsIgnoreCase("LYS")||
	    					resRef.equalsIgnoreCase("LEU")||resRef.equalsIgnoreCase("MET")||resRef.equalsIgnoreCase("ASN")||
	    					resRef.equalsIgnoreCase("PRO")||resRef.equalsIgnoreCase("GLN")||resRef.equalsIgnoreCase("ARG")||
	    					resRef.equalsIgnoreCase("SER")||resRef.equalsIgnoreCase("TRP")||resRef.equalsIgnoreCase("TYR"))
	    			{
	    				if(atomRef.equalsIgnoreCase("HB1"))
	    					atomRefStereo="HB2";
	    				else if(atomRef.equalsIgnoreCase("HB2"))
	    					atomRefStereo="HB1";
	    			}   			
	    		}    		
	    		if(subAtomTwo.equalsIgnoreCase("HA")&& resRef.equalsIgnoreCase("GLY") )
	    		{
	    			if(atomRef.equalsIgnoreCase("HA1"))
	    				atomRefStereo="HA2";
					else if(atomRef.equalsIgnoreCase("HA2"))
						atomRefStereo="HA1";
	    		}
	    		if((subAtomTwo.equalsIgnoreCase("HG")||subAtomTwo.equalsIgnoreCase("CG"))  && 
	    				resRef.equalsIgnoreCase("VAL")  )//changed...
	    		{
	    			if(atomRef.equalsIgnoreCase("HG1"))
	    				atomRefStereo="HG2";
					else if(atomRef.equalsIgnoreCase("HG2"))
						atomRefStereo="HG1";
					else if(atomRef.equalsIgnoreCase("CG1"))
						atomRefStereo="CG2";
					else if(atomRef.equalsIgnoreCase("CG2"))
						atomRefStereo="CG1";
	    		}
	    		if((subAtomTwo.equalsIgnoreCase("HD")||subAtomTwo.equalsIgnoreCase("CD"))&& resRef.equalsIgnoreCase("LEU") )
	    		{
	    			if(atomRef.equalsIgnoreCase("HD1"))
	    				atomRefStereo="HD2";
					else if(atomRef.equalsIgnoreCase("HD2"))
						atomRefStereo="HD1";
					else if(atomRef.equalsIgnoreCase("CD1"))
						atomRefStereo="CD2";
					else if(atomRef.equalsIgnoreCase("CD2"))
						atomRefStereo="CD1";
	    		}
				/////////////
	    		if(subAtomTwo.equalsIgnoreCase("HG")  && (resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("GLU")||
	    						resRef.equalsIgnoreCase("LYS")||resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("PRO")||
	    						resRef.equalsIgnoreCase("ARG") ) )//changed...
	    		{
	    			if(atomRef.equalsIgnoreCase("HG1"))
	    				atomRefStereo="HG2";
					else if(atomRef.equalsIgnoreCase("HG2"))
						atomRefStereo="HG1";				
	    		}
	    		if(subAtomTwo.equalsIgnoreCase("HD")  && (resRef.equalsIgnoreCase("PHE") || 
	    				resRef.equalsIgnoreCase("LYS")||resRef.equalsIgnoreCase("PRO")||
	    				resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("TYR")  ) )//changed...
				{
					if(atomRef.equalsIgnoreCase("HD1"))
						atomRefStereo="HD2";
					else if(atomRef.equalsIgnoreCase("HD2"))
						atomRefStereo="HD1";				
				}
	    		if(subAtomTwo.equalsIgnoreCase("HE")  && (resRef.equalsIgnoreCase("PHE") || 
	    				resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("TYR")  ) )//changed...
				{
					if(atomRef.equalsIgnoreCase("HE1"))
						atomRefStereo="HE2";
					else if(atomRef.equalsIgnoreCase("HE2"))
						atomRefStereo="HE1";				
				}
	    		if(atomRef.length()>=3)
	    		{
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HG1") && resRef.equalsIgnoreCase("ILE"))
					{
						if(atomRef.equalsIgnoreCase("HG11"))
							atomRefStereo="HG12";
						else if(atomRef.equalsIgnoreCase("HG12"))
							atomRefStereo="HG11";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HD2") && resRef.equalsIgnoreCase("ASN"))
					{
						if(atomRef.equalsIgnoreCase("HD21"))
							atomRefStereo="HD22";
						else if(atomRef.equalsIgnoreCase("HD22"))
							atomRefStereo="HD21";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HE2") && resRef.equalsIgnoreCase("GLN"))
					{
						if(atomRef.equalsIgnoreCase("HE21"))
							atomRefStereo="HE22";
						else if(atomRef.equalsIgnoreCase("HE22"))
							atomRefStereo="HE21";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HH1") && resRef.equalsIgnoreCase("ARG"))
					{
						if(atomRef.equalsIgnoreCase("HH11"))
							atomRefStereo="HH12";
						else if(atomRef.equalsIgnoreCase("HH12"))
							atomRefStereo="HH11";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HH2") && resRef.equalsIgnoreCase("ARG"))
					{
						if(atomRef.equalsIgnoreCase("HH21"))
							atomRefStereo="HH22";
						else if(atomRef.equalsIgnoreCase("HH22"))
							atomRefStereo="HH21";				
					}
	    		}
	    		if(subAtomTwo.equalsIgnoreCase("HH")  && resRef.equalsIgnoreCase("ARG")  )//changed...
				{
					if(atomRef.equalsIgnoreCase("HH1"))
						atomRefStereo="HH2";
					else if(atomRef.equalsIgnoreCase("HH2"))
						atomRefStereo="HH1";				
				}
	    		
	    		/////////////////
				if( !(atomRef.substring(0,1).equalsIgnoreCase("H") || atomRef.substring(0,1).equalsIgnoreCase("C")||atomRef.substring(0,1).equalsIgnoreCase("N"))   )
					continue;
				
				String subAtom=atomA;
				double csErr=0.0;
				if(atomRef.substring(0,1).equalsIgnoreCase("H"))
					csErr=csErrH;
				else
					csErr=csErrHeavy;
				
				if(atomA.length()>atomRef.length())
					subAtom=atomA.substring(0,atomRef.length());
				
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRef) )
					isFound=true;
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRefStereo) )
					isFound=true;
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRef) && Math.abs(csRef-cs_hA)<csErr)
					isCorrect=true;		
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRefStereo) && Math.abs(csRef-cs_hA)<csErr)
					isCorrect=true;	
			}//for(int k=0;k<vecRefAsg.size();k++)
			
			if(!isFound)
			{
				//System.out.println("Missing resonance assignment: "+ resNoA +" "+ resA+ " - " +atomA);
				missing++;
			}
			else
			{
				if(!isCorrect)			
				{
					//System.out.println("...Wrong resonance assignment: "+ resNoA +" "+ resA+ " - " +atomA);
					wrong=wrong+1;
				}
				else
				{
					correct=correct+1;
					
					double dbSASValue=sas.findSAS(vecSAS, resNoA, atomA);
					if( (dbSASValue>=0) &&  (dbSASValue< 10) )
						correctSas0_10=correctSas0_10+1;					
					else if((dbSASValue>=10) &&  (dbSASValue< 20) ) 				
						correctSas10_20=correctSas10_20+1;				
					else if((dbSASValue>=20) &&  (dbSASValue< 30) ) 				
						correctSas20_30=correctSas20_30+1;
					else if((dbSASValue>=30) &&  (dbSASValue< 40) ) 				
						correctSas30_40=correctSas30_40+1;
					else if((dbSASValue>=40) &&  (dbSASValue<=100) ) 				
						correctSas40_100=correctSas40_100+1;
					
					
					if(resA.equalsIgnoreCase("VAL")||resA.equalsIgnoreCase("ILE")||resA.equalsIgnoreCase("LEU")||resA.equalsIgnoreCase("MET")
							||resA.equalsIgnoreCase("PHE")||resA.equalsIgnoreCase("TRP")||resA.equalsIgnoreCase("CYS") )
						correctI=correctI+1;
					else if( !(resA.equalsIgnoreCase("ALA") || resA.equalsIgnoreCase("GLY")) )
						correctII=correctII+1;
				}
			}
			
			totalScH++;
		}//for(int j=0;j<vecSrcAsg.size();j++)

		System.out.println("Total number of protons (including both bb and sc protons): "+ totalScH);
		System.out.println("Total number of missing sidechain assignments: "+ missing);
		System.out.println("Total number of wrong sidechain assignments: "+ wrong);		
		System.out.println("Total number of correct resonance assignments: "+correct);
		//System.out.println("Total number of side chain proton resonance assignments: "+ (nTotalAsgs-nTotalBBAsgs));
		System.out.println("Percentage of correct proton resonance assignments (including both bb and sc resonances): "+(double)( correct/nTotalAsgs ));
		System.out.println("Percentage of correct proton resonance assignments for class I residues: "+(double)( correctI/nTotalClassI ));
		System.out.println("Percentage of correct proton resonance assignments for class II residues: "+(double)( correctII/nTotalClassII ));
		
		System.out.println("Percentage of correct resonance assignments for SAS 0-10%: "+(double)( correctSas0_10/nTotalSas0_10 ));		
		System.out.println("Percentage of correct resonance assignments for SAS 10-20%: "+(double)( correctSas10_20/nTotalSas10_20 ));
		System.out.println("Percentage of correct resonance assignments for SAS 20-30%: "+(double)( correctSas20_30/nTotalSas20_30 ));
		System.out.println("Percentage of correct resonance assignments for SAS 30-40%: "+(double)( correctSas30_40/nTotalSas30_40 ));
		System.out.println("Percentage of correct resonance assignments for SAS >40%: "+(double)( correctSas40_100/nTotalSas40_100 ));
		
	}
	
	/**
	 * evaluation different atom types.
	 * 
	 * @param vecSrcAsg original assignment list
	 * @param vecRefAsg reference assignment list
	 * @param 
	 */
	public void EvaluateCSAssignmentDiffResidues(Vector vecSrcAsg,Vector vecRefAsg)
	{
		double csErrH=0.05;
		double csErrHeavy=0.5;
		
		Peak pk=new Peak();
		int totalScH=0;
		int missing=0;
		double wrong=0.0;
		double correct=0.0;
		double correctI=0.0;
		double correctII=0.0;
		double nTotalClassII=0.0,nTotalClassI=0.0;
		Assign asg=new Assign();		
		double nTotalAsgs=0.0;//all proton resonance assignments, including both bb and sc
		double nTotalChi1=0.0, nTotalChi2=0.0,nTotalChi3=0.0,nTotalChi4=0.0;//total number of resonances for different atom types.
		double correctChi1=0.0,correctChi2=0.0,correctChi3=0.0,correctChi4=0.0;
		
		for(int k=0;k<vecSrcAsg.size();k++){
			H1CS h1cs=(H1CS)vecSrcAsg.elementAt(k);
			String res=h1cs.getResidueType();
			String atom=h1cs.getAtomName();
			if(atom.length()<2)
				continue;
			if(atom.substring(0, 1).equalsIgnoreCase("H")){
				nTotalAsgs=nTotalAsgs+1;
				if(res.equalsIgnoreCase("VAL")||res.equalsIgnoreCase("ILE")||res.equalsIgnoreCase("LEU")||res.equalsIgnoreCase("MET")
						||res.equalsIgnoreCase("PHE")||res.equalsIgnoreCase("TRP")||res.equalsIgnoreCase("CYS") )
					nTotalClassI=nTotalClassI+1;
				else if( !(res.equalsIgnoreCase("ALA") || res.equalsIgnoreCase("GLY")) )
					nTotalClassII=nTotalClassII+1;
				
				if(res.equalsIgnoreCase("ARG") ||res.equalsIgnoreCase("LYS") )
					nTotalChi4=nTotalChi4+1;
				else if( res.equalsIgnoreCase("MET") || res.equalsIgnoreCase("GLU") || res.equalsIgnoreCase("GLN"))
					nTotalChi3=nTotalChi3+1;
				else if(res.equalsIgnoreCase("ASP") || res.equalsIgnoreCase("ASN") || res.equalsIgnoreCase("ILE") ||
						res.equalsIgnoreCase("LEU") || res.equalsIgnoreCase("HIS") || res.equalsIgnoreCase("TRP")||
						res.equalsIgnoreCase("TYR") || res.equalsIgnoreCase("PHE") )
					nTotalChi2=nTotalChi2+1;
				else if(res.equalsIgnoreCase("PRO") || res.equalsIgnoreCase("THR") || res.equalsIgnoreCase("VAL")||
						res.equalsIgnoreCase("SER")|| res.equalsIgnoreCase("CYS"))
					nTotalChi1=nTotalChi1+1;
				else if(res.equalsIgnoreCase("GLY") || res.equalsIgnoreCase("ALA"))
					;
				else					
					System.out.println("error: found some unknow residue type...");
					
			
			}//if(atom.substring(0, 1).equalsIgnoreCase("H"))
		}//for(int k=0;k<vecSrcAsg.size();k++)
		
		
		for(int j=0;j<vecSrcAsg.size();j++)
		{
			H1CS h1csA=(H1CS)vecSrcAsg.elementAt(j);
			int resNoA=h1csA.getResidueNo();
			String resA=h1csA.getResidueType();
			String atomA=h1csA.getAtomName();
			double cs_hA=h1csA.getH1CS();	
			if(!atomA.substring(0,1).equalsIgnoreCase("H"))
				continue;
			
			boolean isFound=false;
			boolean isCorrect=false;
			
			for(int k=0;k<vecRefAsg.size();k++)
			{
				H1CS h1cs=(H1CS)vecRefAsg.elementAt(k);
				int resRefNo=h1cs.getResidueNo();
				String resRef=h1cs.getResidueType();
				String atomRef=h1cs.getAtomName();
				double csRef=h1cs.getH1CS();
				/////////////
				String subAtomTwo="";
	    		if(atomRef.length()>2)
	    			subAtomTwo=atomRef.substring(0,2);
	    		else
	    			subAtomTwo=atomRef;
	    		String atomRefStereo="";
				if(subAtomTwo.equalsIgnoreCase("HB"))
	    		{
	    			if(resRef.equalsIgnoreCase("CYS")||resRef.equalsIgnoreCase("ASP")||resRef.equalsIgnoreCase("GLU")||
	    					resRef.equalsIgnoreCase("PHE")||resRef.equalsIgnoreCase("HIS")||resRef.equalsIgnoreCase("LYS")||
	    					resRef.equalsIgnoreCase("LEU")||resRef.equalsIgnoreCase("MET")||resRef.equalsIgnoreCase("ASN")||
	    					resRef.equalsIgnoreCase("PRO")||resRef.equalsIgnoreCase("GLN")||resRef.equalsIgnoreCase("ARG")||
	    					resRef.equalsIgnoreCase("SER")||resRef.equalsIgnoreCase("TRP")||resRef.equalsIgnoreCase("TYR"))
	    			{
	    				if(atomRef.equalsIgnoreCase("HB1"))
	    					atomRefStereo="HB2";
	    				else if(atomRef.equalsIgnoreCase("HB2"))
	    					atomRefStereo="HB1";
	    			}   			
	    		}    		
	    		if(subAtomTwo.equalsIgnoreCase("HA")&& resRef.equalsIgnoreCase("GLY") )
	    		{
	    			if(atomRef.equalsIgnoreCase("HA1"))
	    				atomRefStereo="HA2";
					else if(atomRef.equalsIgnoreCase("HA2"))
						atomRefStereo="HA1";
	    		}
	    		if((subAtomTwo.equalsIgnoreCase("HG")||subAtomTwo.equalsIgnoreCase("CG"))  && 
	    				resRef.equalsIgnoreCase("VAL")  )//changed...
	    		{
	    			if(atomRef.equalsIgnoreCase("HG1"))
	    				atomRefStereo="HG2";
					else if(atomRef.equalsIgnoreCase("HG2"))
						atomRefStereo="HG1";
					else if(atomRef.equalsIgnoreCase("CG1"))
						atomRefStereo="CG2";
					else if(atomRef.equalsIgnoreCase("CG2"))
						atomRefStereo="CG1";
	    		}
	    		if((subAtomTwo.equalsIgnoreCase("HD")||subAtomTwo.equalsIgnoreCase("CD"))&& resRef.equalsIgnoreCase("LEU") )
	    		{
	    			if(atomRef.equalsIgnoreCase("HD1"))
	    				atomRefStereo="HD2";
					else if(atomRef.equalsIgnoreCase("HD2"))
						atomRefStereo="HD1";
					else if(atomRef.equalsIgnoreCase("CD1"))
						atomRefStereo="CD2";
					else if(atomRef.equalsIgnoreCase("CD2"))
						atomRefStereo="CD1";
	    		}
				/////////////
	    		if(subAtomTwo.equalsIgnoreCase("HG")  && (resRef.equalsIgnoreCase("GLN") || resRef.equalsIgnoreCase("GLU")||
	    						resRef.equalsIgnoreCase("LYS")||resRef.equalsIgnoreCase("MET") || resRef.equalsIgnoreCase("PRO")||
	    						resRef.equalsIgnoreCase("ARG") ) )//changed...
	    		{
	    			if(atomRef.equalsIgnoreCase("HG1"))
	    				atomRefStereo="HG2";
					else if(atomRef.equalsIgnoreCase("HG2"))
						atomRefStereo="HG1";				
	    		}
	    		if(subAtomTwo.equalsIgnoreCase("HD")  && (resRef.equalsIgnoreCase("PHE") || 
	    				resRef.equalsIgnoreCase("LYS")||resRef.equalsIgnoreCase("PRO")||
	    				resRef.equalsIgnoreCase("ARG") || resRef.equalsIgnoreCase("TYR")  ) )//changed...
				{
					if(atomRef.equalsIgnoreCase("HD1"))
						atomRefStereo="HD2";
					else if(atomRef.equalsIgnoreCase("HD2"))
						atomRefStereo="HD1";				
				}
	    		if(subAtomTwo.equalsIgnoreCase("HE")  && (resRef.equalsIgnoreCase("PHE") || 
	    				resRef.equalsIgnoreCase("LYS") || resRef.equalsIgnoreCase("TYR")  ) )//changed...
				{
					if(atomRef.equalsIgnoreCase("HE1"))
						atomRefStereo="HE2";
					else if(atomRef.equalsIgnoreCase("HE2"))
						atomRefStereo="HE1";				
				}
	    		if(atomRef.length()>=3)
	    		{
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HG1") && resRef.equalsIgnoreCase("ILE"))
					{
						if(atomRef.equalsIgnoreCase("HG11"))
							atomRefStereo="HG12";
						else if(atomRef.equalsIgnoreCase("HG12"))
							atomRefStereo="HG11";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HD2") && resRef.equalsIgnoreCase("ASN"))
					{
						if(atomRef.equalsIgnoreCase("HD21"))
							atomRefStereo="HD22";
						else if(atomRef.equalsIgnoreCase("HD22"))
							atomRefStereo="HD21";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HE2") && resRef.equalsIgnoreCase("GLN"))
					{
						if(atomRef.equalsIgnoreCase("HE21"))
							atomRefStereo="HE22";
						else if(atomRef.equalsIgnoreCase("HE22"))
							atomRefStereo="HE21";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HH1") && resRef.equalsIgnoreCase("ARG"))
					{
						if(atomRef.equalsIgnoreCase("HH11"))
							atomRefStereo="HH12";
						else if(atomRef.equalsIgnoreCase("HH12"))
							atomRefStereo="HH11";				
					}
	    			if(atomRef.substring(0,3).equalsIgnoreCase("HH2") && resRef.equalsIgnoreCase("ARG"))
					{
						if(atomRef.equalsIgnoreCase("HH21"))
							atomRefStereo="HH22";
						else if(atomRef.equalsIgnoreCase("HH22"))
							atomRefStereo="HH21";				
					}
	    		}
	    		if(subAtomTwo.equalsIgnoreCase("HH")  && resRef.equalsIgnoreCase("ARG")  )//changed...
				{
					if(atomRef.equalsIgnoreCase("HH1"))
						atomRefStereo="HH2";
					else if(atomRef.equalsIgnoreCase("HH2"))
						atomRefStereo="HH1";				
				}
	    		
	    		/////////////////
				if( !(atomRef.substring(0,1).equalsIgnoreCase("H") || atomRef.substring(0,1).equalsIgnoreCase("C")||atomRef.substring(0,1).equalsIgnoreCase("N"))   )
					continue;
				
				String subAtom=atomA;
				double csErr=0.0;
				if(atomRef.substring(0,1).equalsIgnoreCase("H"))
					csErr=csErrH;
				else
					csErr=csErrHeavy;
				
				if(atomA.length()>atomRef.length())
					subAtom=atomA.substring(0,atomRef.length());
				
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRef) )
					isFound=true;
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRefStereo) )
					isFound=true;
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRef) && Math.abs(csRef-cs_hA)<csErr)
					isCorrect=true;		
				if(resNoA==resRefNo && subAtom.equalsIgnoreCase(atomRefStereo) && Math.abs(csRef-cs_hA)<csErr)
					isCorrect=true;	
			}//for(int k=0;k<vecRefAsg.size();k++)
			
			if(!isFound)
			{
				//System.out.println("Missing resonance assignment: "+ resNoA +" "+ resA+ " - " +atomA);
				missing++;
			}
			else
			{
				if(!isCorrect)			
				{
					//System.out.println("...Wrong resonance assignment: "+ resNoA +" "+ resA+ " - " +atomA);
					wrong=wrong+1;
				}
				else
				{
					correct=correct+1;
					
					if(resA.equalsIgnoreCase("ARG") ||resA.equalsIgnoreCase("LYS") )
						correctChi4=correctChi4+1;
					else if( resA.equalsIgnoreCase("MET") || resA.equalsIgnoreCase("GLU") || resA.equalsIgnoreCase("GLN"))
						correctChi3=correctChi3+1;
					else if(resA.equalsIgnoreCase("ASP") || resA.equalsIgnoreCase("ASN") || resA.equalsIgnoreCase("ILE") ||
							resA.equalsIgnoreCase("LEU") || resA.equalsIgnoreCase("HIS") || resA.equalsIgnoreCase("TRP")||
							resA.equalsIgnoreCase("TYR") || resA.equalsIgnoreCase("PHE") )
						correctChi2=correctChi2+1;
					else if(resA.equalsIgnoreCase("PRO") || resA.equalsIgnoreCase("THR") || resA.equalsIgnoreCase("VAL")||
							resA.equalsIgnoreCase("SER")|| resA.equalsIgnoreCase("CYS"))
						correctChi1=correctChi1+1;
					
					
					if(resA.equalsIgnoreCase("VAL")||resA.equalsIgnoreCase("ILE")||resA.equalsIgnoreCase("LEU")||resA.equalsIgnoreCase("MET")
							||resA.equalsIgnoreCase("PHE")||resA.equalsIgnoreCase("TRP")||resA.equalsIgnoreCase("CYS") )
						correctI=correctI+1;
					else if( !(resA.equalsIgnoreCase("ALA") || resA.equalsIgnoreCase("GLY")) )
						correctII=correctII+1;
				}
			}
			
			totalScH++;
		}//for(int j=0;j<vecSrcAsg.size();j++)

		System.out.println("Total number of protons (including both bb and sc protons): "+ totalScH);
		System.out.println("Total number of missing sidechain assignments: "+ missing);
		System.out.println("Total number of wrong sidechain assignments: "+ wrong);		
		System.out.println("Total number of correct resonance assignments: "+correct);
		//System.out.println("Total number of side chain proton resonance assignments: "+ (nTotalAsgs-nTotalBBAsgs));
		System.out.println("Percentage of correct proton resonance assignments (including both bb and sc resonances): "+(double)( correct/nTotalAsgs ));
		System.out.println("Percentage of correct proton resonance assignments for class I residues: "+(double)( correctI/nTotalClassI ));
		System.out.println("Percentage of correct proton resonance assignments for class II residues: "+(double)( correctII/nTotalClassII ));
		
		System.out.println("Percentage of correct resonance assignments for one-chi angle residues : "+(double)( correctChi1/nTotalChi1 ));
		System.out.println("Percentage of correct resonance assignments for two-chi angle residues : "+(double)( correctChi2/nTotalChi2 ));
		System.out.println("Percentage of correct resonance assignments for three-chi angle residues : "+(double)( correctChi3/nTotalChi3 ));
		System.out.println("Percentage of correct resonance assignments for four-chi angle residues : "+(double)( correctChi4/nTotalChi4 ));
		
	}
	
}
