package Nasca;
/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/
import java.util.Vector;

import rdcPanda.Assign;
import rdcPanda.BackNoe;
import rdcPanda.H1CS;
import rdcPanda.Noesy;
import rdcPanda.Peak;


/**
 * This class provides functions for computing the pairwise score matrix
 * 
 *
 */
public class PairwiseScoreMatrix {
	
	/**compute the best score matrix.
	 @param vecResonGraph resonance graph. 
     @param vecLabels proton label set.
     @param vecBMRBNew BMRB information.  
     @param bestScoreMatrix [i][k]: best NOE pattern matching score when resonance node i is mapped to label k.
	 * @return
	 */
	
	public void computBestScoreMatrix(Vector<GraphNode> vecResonGraph,Vector<ProtonLabel> vecLabels,
			Vector<H1CS> vecBMRBNew,double bestScoreMatrix[][]){
		
		Peak pk=new Peak();
		NascaNew nasca=new NascaNew();
		BackNoe bkNoe=new BackNoe();
		Assign asg=new Assign();
		H1CS h1cs=new H1CS();
		double csErrH=0.04; double csErrN=0.3;double csErrCA=0.3;
				
		for(int i=0;i<vecResonGraph.size();i++){
			GraphNode node=(GraphNode)vecResonGraph.elementAt(i);
			if(node.getIsAssigned())
				continue;
			int nodeID=node.getID();
			
			Vector<Noesy> vecNoesy=node.vecAdjNOESY;			
			double cs_proton=node.getCSProton();
			double cs_heavy=node.getCSHeavy();
			Vector<ProtonLabel> vecMapSet=node.getMappingSet();
			Vector<GraphNode> vecAdj=node.getAdjVec();
			
			double maxScore=0.0;
			
			for(int j=0;j<vecMapSet.size();j++){
				ProtonLabel label=(ProtonLabel)vecMapSet.elementAt(j);
				if(label.getIsAssigned())				
					continue;
				int labelID=label.getID();
				
				Vector<H1CS> vecOneSCAsg=new Vector<H1CS>();
				Vector<BackNoe> vecBackNoe=new Vector<BackNoe>();
				String res=label.getResName();
				String atom=label.getAtomName();
				String heavName=pk.GetHeavyAtomFromProton(res,atom);
				int resNo=label.getResNo();		
				
				Vector<Noesy> vecNoesyTwo=new Vector<Noesy>();	
				vecNoesyTwo.addAll(vecNoesy);
				
				vecOneSCAsg.add(new H1CS(resNo,res,atom,cs_proton));			
				vecOneSCAsg.add(new H1CS(resNo,res,heavName,cs_heavy));		
				
				for(int t=0;t<vecAdj.size();t++)
				{
					GraphNode nodeAdj=(GraphNode)vecAdj.elementAt(t);
					if(!(nodeAdj.getIsAssigned() && (nodeAdj.asgedId>=0)  ))
						continue;//need to be further tested...
					
					ProtonLabel nodeAdjLabel=(ProtonLabel)vecLabels.elementAt(nodeAdj.asgedId);
					vecNoesyTwo.addAll(nodeAdj.vecAdjNOESY);
					
					int resNoSec=nodeAdjLabel.getResNo();
					String resSec=nodeAdjLabel.getResName();
					String atomSec=nodeAdjLabel.getAtomName();
					String heavyNameSec=pk.GetHeavyAtomFromProton(resSec,atomSec);
					double cs_protonSec=nodeAdj.getCSProton();
					double cs_heavySec=nodeAdj.getCSHeavy();
					vecOneSCAsg.add(new H1CS(resNoSec,resSec,atomSec,cs_protonSec));
					vecOneSCAsg.add(new H1CS(resNoSec,resSec,heavyNameSec,cs_heavySec));
					double distUp=6.0;
					if(nasca.isInCloseAdj(nodeAdjLabel,label))
						distUp=2.7;
					vecBackNoe.add(new BackNoe(cs_proton,cs_heavy,cs_protonSec,distUp,0.0,resNo,resNoSec,res,resSec,atom,heavName,atomSec ));
					vecBackNoe.add(new BackNoe(cs_protonSec,cs_heavySec,cs_proton,distUp,0.0,resNoSec,resNo,resSec,res,atomSec,heavyNameSec,atom ));
				
				}//for(int t=0;t<vecAdj.size();t++)	
				
				Vector<BackNoe> vecBackNoeNew=bkNoe.DeleteRepeat(vecBackNoe);
				//Vector vecNoesyTwoNew=noesy.DeleteRepeatedNoesy3D(vecNoesyTwo);
				int [] numPeaks=new int[1];
				double dbScore=asg.NoePatternMatchScore(csErrH,csErrN, csErrCA,vecBackNoeNew,vecNoesyTwo, numPeaks,true);
				dbScore=dbScore*vecBackNoeNew.size();//the more number of matched nodes, the better
				Vector<H1CS> vecOneSCAsgNew=h1cs.DeleteRepeatAsg(vecOneSCAsg);
				double asgScore=h1cs.BMRBSatisticsScore(vecOneSCAsgNew,vecBMRBNew);				
				
				double bestScore=dbScore+asgScore;//*0.5*vecBackNoeNew.size();//current score.		
				bestScoreMatrix[nodeID][labelID]=bestScore;
				if(bestScore>maxScore)
					maxScore=bestScore;
			}//for(int j=0;j<vecMapSet.size();j++){
				
			node.bestScore=maxScore;
		}//for(int i=0;i<vecResonGraph.size();i++){
		
	}

}
