package Nasca;
/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

import Jampack.JampackException;

import rdcPanda.Assign;
import rdcPanda.H1CS;
import rdcPanda.Noe;
import rdcPanda.Pdb;

//storing solvent accessible surface for each atom
public class SAS {

	int resNo=-1;
	String resType="";
	String atomName="";
	double dbSAS=0.0;
	
	public SAS(){};
	public SAS(int no,String res, String atom,double sas){
		resNo=no;
		resType=res;
		atomName=atom;
		dbSAS=sas;
	}
	
	int getResNo(){
		return resNo;
	}
	String getResName(){
		return resType;
	}
	String getAtomName(){
		return atomName;
	}
	double getSAS(){
		return dbSAS;
	}
	
	  /**
     * find the sas value for each atom
     * 
     * @param vecSAS storing all sas values
     * @param no residue number
     * @param atom atom name from chemical shift.
     * 
     * @return a vector of resonance list
     */
	double findSAS(Vector<SAS>vecSAS, int no, String atom){
		double value=0.0;
		for(int i=0;i< vecSAS.size();i++){
			SAS sas=vecSAS.elementAt(i);
			int res_no=sas.getResNo();
			String atom_name=sas.getAtomName();
			if(atom_name.length()>atom.length())
				atom_name=atom_name.substring(0,atom.length());
			
			if(res_no==no && atom.equalsIgnoreCase(atom_name)){
				value=sas.getSAS();
				break;
			}		
		}
		return value;
	}
	public boolean isIntNumber(String num){	 
		try{	  
	      Integer.parseInt(num);
	      } catch(NumberFormatException nfe) {	   
	      return false;	   
	      }	   
	      return true;
      }
	
	  /**
     * Read sas values from MOLMOL file.
     * The required file format is:.
     * 
     * @param filename the name of the file
     * @param vecSeq backbone structure to update the residue name
     * 
     * @return a vector of resonance list
     */
    public Vector<SAS> SASReader(String filename)
    {    	
    	StringTokenizer st = new StringTokenizer("");  	
    
    	Pdb pp=new Pdb();
    	String ss ="";   	
    	String strFirst="";
    	int res_no=0;
    	String res="";
    	Vector<SAS> vecSAS=new Vector<SAS>();
    	try
    	{
    		BufferedReader in = new BufferedReader(new FileReader(filename));	
    		ss = in.readLine();    		
    		stop:
    			while(true) 
    			{   			    
    				st = new StringTokenizer(ss);   				
    				if (st.hasMoreTokens()){
    					strFirst=st.nextToken();
    					if(isIntNumber(strFirst) ){
    						if ((ss = in.readLine()) == null )    	    				
    	    					break stop;  
    						res_no= Integer.parseInt(strFirst);
    						
    						if(st.hasMoreTokens())
    							res=st.nextToken().trim();
    						
    						continue;
    					}//if(isIntNumber(strFirst) )
    				}//if (st.hasMoreTokens())
    				
    				strFirst=strFirst.trim();
    				
    				int index=ss.indexOf("%");
    				String strValue=ss.substring(index-5, index).trim();
    				double value_sas= new Double(strValue).doubleValue();
    				String atomNew=pp.NameFromBMRBToPDB(res,strFirst);//convert to PDB-NEW format
    				SAS sas=new SAS(res_no,res,atomNew,value_sas);
    				vecSAS.add(sas);
    				if ((ss = in.readLine()) == null )
    				{
    					break stop;
    				}
    				
    					
    					
    			}
    	}catch (FileNotFoundException e) {
    		System.out.println("File not found: " + filename);
    	}catch (IOException e) 
    	{
    		System.out.println("IOException: the stack trace is:");
    		e.printStackTrace();
    	}
    	return vecSAS;
    }	
    
    //compute the SAS
    public  static void main (String[] args) throws JampackException
	{
		H1CS h1CS=new H1CS();    	
		Assign asg = new Assign();
		Pdb pp=new Pdb();
		
		//read the NMR data and input parameters:
		String userDir = System.getProperty("user.dir");
		String src=userDir+"/inputFiles/";  //input file directory	
		String strRefPdb=src+"2E71_model1_res_no.pdb";
		Vector<Pdb> vecPDB = pp.readPdb(strRefPdb);
		
		Vector<Pdb> vecPdbNew=pp.nameConvert2PDBNew(vecPDB);
		pp.print(vecPdbNew);
		
		
		
	}
	
}
