package NascaGUI;
/*
NASCA NOE Assignment and Side-Chain Assignment  Software Version 1.0
Copyright (C) 2009-2011 Bruce Donald Lab, Duke University

NASCA is free software; you can redistribute it and/or modify it under
the terms of the GNU Lesser General Public License as published by the Free
Software Foundation, either version 3 of the License, or (at your option) any
later version.

NASCA is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
details.

You should have received a copy of the GNU Lesser General Public License
along with this library; if not, see:
    <http://www.gnu.org/licenses/>.

There are additional restrictions imposed on the use and distribution of this
open-source code, including: (A) this header must be included in any
modification or extension of the code; (B) you are required to cite our
papers in any publications that use this code. The citation for the various
different modules of our software, together with a complete list of
requirements and restrictions are found in the document license.pdf enclosed
with this distribution.

Contact Info:
    Bruce R. Donald
    Duke University
    Department of Computer Science
    Levine Science Research Center (LSRC)
    Durham, NC 27708-0129
    USA
    email: www.cs.duke.edu/brd/

<signature of Bruce Donald>, 01 December, 2009
Bruce R. Donald, Professor of Computer Science and Biochemistry
*/
import java.util.Vector;

import rdcPanda.H1CS;
import rdcPanda.Noe;

//a class for storing side-chain resonance assignments and NOE assignments
public class Assignment {
	
	private Vector<H1CS> vecResonAsgs=new  Vector<H1CS>();
	private Vector<Noe> vecNoeAsgs=new Vector<Noe>();
	
	public void setResonAsgs(Vector<H1CS> vecResonAsgsTemp){
		vecResonAsgs=new  Vector<H1CS>();
		vecResonAsgs.addAll(vecResonAsgsTemp);
	}

	public void setNoeAsgs(Vector<Noe> vecNoeAsgsTemp){
		vecNoeAsgs=new Vector<Noe>();
		vecNoeAsgs.addAll(vecNoeAsgsTemp);
	}
	
	public Vector<H1CS> getResonAsgs(){
		return vecResonAsgs;
	}
	public Vector<Noe> getNoeAsgs(){
		return vecNoeAsgs;
	}
}
