package rdcPanda;

///////////////////////////////////////////////////////////////////////////////////////////////
//	Cartesian.java
//
//	  Version:           0.1
//
//
//	  authors:
// 	  initials            name                      organization               email
//	 ---------   -----------------------        ------------------------    ------------------
//	  LW            Lincong Wang                  Dartmouth College       wlincong@cs.dartmouth.edu
//
///////////////////////////////////////////////////////////////////////////////////////////////



/*
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
	USA
	
	Contact Info:
		Bruce Donald
		Duke University
		Department of Computer Science
		Levine Science Research Center (LSRC)
		Durham
		NC 27708-0129 
		USA
		brd@cs.duke.edu
	
	If you use or publish any results derived from the use of this program please cite:
	J. Zeng, J. Boyles, C. Tripathy, L. Wang, A. Yan, P. Zhou and B.R. Donald. 
	"High-Resolution Protein Structure Determination Starting with a Global Fold 
	Calculated from Exact Solutions to the RDC Equations." Submitted For Review.

	Copyright (C) 2009 Jianyang (Michael) Zeng, Lincong Wang and Bruce R. Donald		
	<signature of Bruce Donald>, June 2008 and January 2009
	Bruce Donald, Professor of Computer Science
 */

import java.io. *;
import java.util. *;

// TODO: Auto-generated Javadoc
/** * 
*   This class defines Cartesian coordinates for individual atom in protein structure.
*    Written by Lincong Wang (2001-2005).
*/
public class Cartesian{
    //the atom and its three Cartesian coodinates
    /** The atom name. */
    private String atom;  
    
    /** The x coord. */
    private double xCoord;
    
    /** The y coord. */
    private double yCoord;
    
    /** The z coord. */
    private double zCoord;

    /**
     * Instantiates a new cartesian.
     */
    public Cartesian(){
	atom = null;
	xCoord = 0.0;
	yCoord = 0.0; 
	zCoord = 0.0;
    }
    public Cartesian(Cartesian cart){
    	atom = cart.getAtom();
    	xCoord = cart.getX();
    	yCoord = cart.getY(); 
    	zCoord = cart.getZ();
        }
    
    /**
     * Instantiates a new cartesian.
     * 
     * @param aa the aa
     * @param X the x
     * @param Y the y
     * @param Z the z
     */
    public Cartesian(String aa, double X, double Y, double Z){
	atom = aa;
	xCoord = X;
	yCoord = Y;
	zCoord = Z;
    }

    /**
     * Instantiates a new cartesian.
     * 
     * @param aa the aa
     * @param c the c
     */
    public Cartesian(String aa, double [] c){
	atom = aa;
	xCoord = c[0];
	yCoord = c[1];
	zCoord = c[2];
    }

    //getting the individual values	
    /**
     * Gets the atom name.
     * 
     * @return the atom
     */
    public String getAtom(){
	return atom;
    }	
    
    /**
     * Gets the x.
     * 
     * @return the x
     */
    public double getX(){
	return xCoord;
    }
    
    /**
     * Gets the y.
     * 
     * @return the y
     */
    public double getY(){
	return yCoord;
    }
    
    /**
     * Gets the z.
     * 
     * @return the z
     */
    public double getZ(){
	return zCoord;
    }

    //setting the individual values	
    /**
     * Sets the atom name.
     * 
     * @param aName the new atom
     */
    public void setAtom(String aName){
	atom = aName;
    }	
    // compute the distance between two cartesians	
    /**
     * Measure distance between points in 3D.
     * 
     * @param ccA the cc a
     * @param ccB the cc b
     * 
     * @return the computed distance
     */
    public double measureDist(Cartesian ccA,Cartesian ccB)
    {
    	double [] coordA = {0.0, 0.0, 0.0};
    	double [] coordB = {0.0, 0.0, 0.0};
    	coordA = ccA.getXYZ();
    	coordB = ccB.getXYZ();
    	double distance =  Math.sqrt((coordA[0] - coordB[0]) * (coordA[0] - coordB[0]) 
    		    + (coordA[1] - coordB[1]) * (coordA[1] - coordB[1]) 
    		    + (coordA[2] - coordB[2]) * (coordA[2] - coordB[2]));
    	return distance;
    }	
    //get all three coordinates
    /**
     * Gets the xYZ.
     * 
     * @return the xYZ
     */
    public double[] getXYZ(){
	return (new double[]{xCoord,  yCoord,  zCoord});
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString(){
	String desc = atom +"  " + String.valueOf(xCoord) + "  " + String.valueOf(yCoord)
	    +" " + String.valueOf(zCoord);
	return desc;	
    }
}
