package rdcPanda;

///////////////////////////////////////////////////////////////////////////////////////////////
//	GraphCut.java
//
//	  Version:           0.1
//
//
//	  authors:
// 	  initials            name                      organization               email
//	 ---------   -----------------------        ------------------------    ------------------
//	  JMZ		 Jianyang (Michael) Zeng	       Duke University			zengjy@cs.duke.edu
//
///////////////////////////////////////////////////////////////////////////////////////////////

/**
 * This class implements functions for graph cut algorithm.  
 * This class was initially designed for pruning rotamers using the graph cut algorithms.
 * Currently it is not used yet.
 *  Written by  Jianyang (Michael) Zeng (2005-2009)
* 
*/

/*
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
	USA
	
	Contact Info:
		Bruce Donald
		Duke University
		Department of Computer Science
		Levine Science Research Center (LSRC)
		Durham
		NC 27708-0129 
		USA
		brd@cs.duke.edu
	
	If you use or publish any results derived from the use of this program please cite:
	J. Zeng, J. Boyles, C. Tripathy, L. Wang, A. Yan, P. Zhou and B.R. Donald. 
	"High-Resolution Protein Structure Determination Starting with a Global Fold 
	Calculated from Exact Solutions to the RDC Equations." Submitted For Review.

	Copyright (C) 2009 Jianyang (Michael) Zeng, Lincong Wang and Bruce R. Donald		
	<signature of Bruce Donald>, June 2008 and January 2009
	Bruce Donald, Professor of Computer Science
 */


import java.io. *;
import java.util. *;
import java.text.NumberFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

import Jampack.Inv;
import Jampack.JampackException;
import Jampack.Zmat;

public class GraphCut 
{
	public class RotScore
	{
		Pdb pdbRot=new Pdb();
		double dbMatchSc=0.0;
		int nOrignID=0;
		public RotScore()
		{
			pdbRot=new Pdb();
			dbMatchSc=0.0;
			nOrignID=0;
		}
		public RotScore(int ID,Pdb pdb, double sc)
		{
			nOrignID=ID;
			pdbRot=pdb;
			dbMatchSc=sc;			
		}
		public RotScore(Pdb pdb, double sc)
		{
			nOrignID=0;
			pdbRot=pdb;
			dbMatchSc=sc;			
		}
		public double getRotScore()
		{
			return dbMatchSc;
		}
		public Pdb getRotPdb()
		{
			return pdbRot;
		}
		public int getOriginID()
		{
			return nOrignID;
		}
		
		public void setScore(double sc)
		{
			dbMatchSc=sc;
		}
		public void addScore(double sc)
		{
			dbMatchSc=dbMatchSc+sc;
		}
		public void setOriginID(int id)
		{
			nOrignID=id;
		}
	}
	
	public static class RotScoreComparator implements Comparator{
    	public int compare(Object o1, Object o2){
    		RotScore n1 = (RotScore)o1;
    		RotScore n2 = (RotScore)o2;
    	    double d1 = n1.getRotScore();
    	    double d2 = n2.getRotScore();
    	    if (d1 <d2)
    		return -1;
    	    else if (d1 >d2)
    		return 1;
    	    else return 0;
    	}
        }
	 //A comparator for sorting the PDB object based on residue number
    public static class ResNoComparator implements Comparator{
	public int compare(Object o1, Object o2){
		GraphCut n1 = (GraphCut)o1;
		GraphCut n2 = (GraphCut)o2;
	    int d1 = n1.getResidueNo();
	    int d2 = n2.getResidueNo();
	    if (d1 < d2)
		return -1;
	    else if (d1 > d2)
		return 1;
	    else return 0;
	}
    } 
	
	//parameter for each unit node:
	private int MAX_ROT_NUM=35;//maximum number of rotamers at a residue
	private int MAX_DEGREE=35;//maximum number of neighbor residue nodes
	private String resName="";//residue name
	private int resNo=-1;//residue ID
	private boolean[] isRemained=new boolean[MAX_ROT_NUM];//true if remained, false if pruned...need to be checked here
	private double[] homoScore=new double[MAX_ROT_NUM];//homogeneity score
	private double[][][] pairScore=new double[MAX_ROT_NUM][MAX_DEGREE][MAX_ROT_NUM];//pairwise score
	private int nLabel=-1;//i.e., the rotamer id or label
	private Vector vecAllRot=new Vector();//vector of all rotamers at this residue
	//vector of neighbor pdbs within NOE distance bound, strored in GraphCut format:
	private Vector vecNeighbors=new Vector();
	
	Vector vecRotScore=new Vector();//for storing all rotamers associated with matching score
	
	public GraphCut()
	{
		resName = null;
		resNo = 0;
		nLabel=0;
		vecAllRot = null;
		vecNeighbors=null;
		for(int i=0;i<MAX_ROT_NUM;i++)
			isRemained[i]=true;
	}	
	public GraphCut(int resNO)
	{
		resName = null;
		resNo = resNO;
		nLabel=0;
		vecAllRot = null;
		vecNeighbors=null;
		for(int i=0;i<MAX_ROT_NUM;i++)
			isRemained[i]=true;
	}	
	public GraphCut(String res, int res_no, int label, Vector vecAllRots)
	{
		resName = res;
		resNo = res_no;
		nLabel=label;
		vecAllRot = vecAllRots;
		vecNeighbors=new Vector();
		for(int i=0;i<vecAllRots.size();i++)
			isRemained[i]=true;
	}
	public GraphCut(String res, int res_no, int label, Vector vecAllRots,Vector vecNearPdbs)
	{
		resName = res;
		resNo = res_no;
		nLabel=label;
		vecAllRot=new Vector();
		vecAllRot = vecAllRots;
		vecNeighbors=new Vector ();
		vecNeighbors.addAll(vecNearPdbs);
		for(int i=0;i<vecAllRots.size();i++)
			isRemained[i]=true;
	}
	//	getting the values:	
    public int getResidueNo()
    {
    	return resNo;
    }	   
    public String getResidueName()
    {
    	return resName;
    }	
    public int getRotLabel()
    {
    	return nLabel;
     }	
    public Vector getAllRotVec()
    {
    	return vecAllRot;
     }	
    public Vector getNeighborVec()
    {
    	return vecNeighbors;
     }	
    public double getHomoScore(int nRotLabel)
    {
    	return homoScore[nRotLabel];
    }
    public double getPairScore(int rotID, int neighID, int neighRotID)
    {
    	return pairScore[rotID][neighID][neighRotID];
    }
    public boolean getIsRemainedLabel(int nID)
    {
    	return isRemained[nID];
    }
    public Vector getRotScoreVec()
    {
    	return vecRotScore;
    }
    public Vector getTopScoreRots(int pickNum)
    {
    	Vector vecPdbRots=new Vector();
    	for (int i=0;i<Math.min(pickNum, vecRotScore.size());i++)
    	{
    		RotScore rotSc=(RotScore)vecRotScore.elementAt(i);
    		Pdb pp=rotSc.getRotPdb();
    		vecPdbRots.add(pp);
    	}
    	return vecPdbRots;
    }
    
    //setting parameters:
    public void setRotlabel(int label)
    {
    	nLabel=label;
    }	
    public void setHomoScore(double sc,int nRotID)
    {
    	homoScore[nRotID]=sc;
    }
    public void setPairScore(double sc,int nRotID, int nNeighborID, int nNeighborRotID)
    {
    	pairScore[nRotID][nNeighborID][nNeighborRotID]=sc;
    }
    public void setPrunedLabel(int nRotLabl)
    {
    	isRemained[nRotLabl]=false;
    }
      
    public void setNeighbors(Vector vecNeigh)
    {
    	vecNeighbors.addAll(vecNeigh);
    }	
    
    public void setInitialRotScore()
    {
    	vecRotScore=new Vector();
    	for(int i=0;i<vecAllRot.size();i++)
    	{
    		Pdb pdbRotamer=(Pdb)vecAllRot.elementAt(i);
    		double dbHomoSc=getHomoScore(i);
    		vecRotScore.add(new RotScore(i,pdbRotamer,dbHomoSc));
    	}//for(int i=0;i<vecAllRot.size();i++)
    	//sort the rotamers according to their matching scores:
		Collections.sort(vecRotScore, new GraphCut.RotScoreComparator()); //need to be test here...
		
    }
    public void sortRotScore()
    {
    	Collections.sort(vecRotScore, new GraphCut.RotScoreComparator()); 
    }
    public void addRotScore(int no, double sc)
    {
    	RotScore rtSc=(RotScore)vecRotScore.elementAt(no);
    	rtSc.addScore(sc);
    }
    
    /**
     * randomly select a rotamer proportial to its score   
     @return rotamer id
    * : 
    */    
    public int RandomSelectRot(Vector vecRotScore)
    {
    	long seed=1222;
    	Random r = new Random( seed); // For reproducible testing
    	int pkNo=0;
    	double sumTemp=0.0;
    	for (int i=0; i< vecRotScore.size();i++)
    	{
    		RotScore rotSc=(RotScore)vecRotScore.elementAt(i);
    		sumTemp=sumTemp+rotSc.getRotScore();
    	}//for (int i=0; i< vecRotScore.size();i++)
    	
    	double dbRand=r.nextDouble()*sumTemp;//random double between 0 and sumTemp
    	
    	double tempPre=0.0, tempAfter=0.0;
    	for(int i=0;i<vecRotScore.size();i++)
    	{
    		RotScore rotSc=(RotScore)vecRotScore.elementAt(i);
    		double dbSc=rotSc.getRotScore();
    		tempAfter=tempPre+dbSc;
    		if( (tempPre<dbRand) && (dbRand< tempAfter))
    		{
    			pkNo=i;
    			break;
    		}
    		
    		tempPre=tempAfter;
    		
    	}//for(int i=0;i<vecRotScore.size();i++)
    	
    	//temp: debugging:
    	pkNo= 0;
   
    	return pkNo;
    }
       
    /**
     * Construct the residue interation graph
     @param vecPdbBB: vector of pdb backbone
     @param srcRotFile: location of rotamer library
     @param  noeLimit: noe distance bound 
     @return a vector of GraphCut
    * : 
    */    
    public Vector GraphConstruction(Vector vecPdbBB, String srcRotFile, double noeLimit ) throws JampackException
    {
    	Vector vecResGraph=new Vector();
    	
    	Pdb pp=new Pdb();
    	Model md=new Model();
    	
    	for (int i=0;i<vecPdbBB.size();i++)
    	{
    		Pdb pdb=(Pdb)vecPdbBB.elementAt(i);
    		Vector vecOriginPdb=new Vector();
    		vecOriginPdb.add(pdb);
    		
    		String resName=pdb.getResidue();
    		int resNo=pdb.getResidueNo();
    		Vector pdbRotVec=new Vector();
    		
    		if( resName.equalsIgnoreCase("GLY"))        			
        		pdbRotVec.add(pdb);          	
        	else
        	{
        		Vector pdbRotam=new Vector();
        		Vector pdbRotamNewStr=new Vector();
        		String rotamFile=srcRotFile+ resName.toLowerCase()+ ".pdb"; 
        		pdbRotam=pp.readPdb(rotamFile);
        		
        		pdbRotamNewStr=pp.nameConvert4SmallRotLibStr(pdbRotam);
        		
        		pdbRotVec.addAll(pdbRotamNewStr);        		
        	}   	
    		
    		Vector vecPdbRotNew=md.BackonbeRotation(pdbRotVec,vecOriginPdb) ; 
    	    		
    		vecResGraph.add(new GraphCut(resName,resNo, 0,vecPdbRotNew));   		
    	}//for (int i=0;i<vecPdbBB.size();i++)
    	
    	//search the neighbors within noe distance range
    	Cartesian cc = new Cartesian();
    	Cartesian cc2 = new Cartesian();
    	String atom ="",atom2="";
    	double [] proton = new double[3];
    	double [] proton2 = new double[3];
    	for (int i=0;i<vecResGraph.size();i++)
    	{
    		GraphCut gc=(GraphCut)vecResGraph.elementAt(i);
    		Vector vecPdb=gc.getAllRotVec();
    		Vector vecNeighbors=new Vector();
    		
    		//search other nodes    		    		
		    for(int i2=0;i2<vecResGraph.size();i2++)
		    {		    
		    	boolean isFound=false;
		    	if (i2==i)
		    		continue;
		    	
		    	GraphCut gc2=(GraphCut)vecResGraph.elementAt(i2);
		    	Vector vecPdb2=gc2.getAllRotVec();
		    	
		    	for(int j=0;j<vecPdb.size();j++)
	    		{
	    			Pdb pdb=(Pdb)vecPdb.elementAt(j);
	    			Vector vecAtom=pdb.getAtomVec();
	    			for ( int k=0; k<vecAtom.size(); k++)
	    			{    				
	    			    cc = (Cartesian)vecAtom.elementAt(k);
	    			    atom = cc.getAtom();
	    			    if (atom.substring(0,1).equalsIgnoreCase("H"))
	    			    	proton = cc.getXYZ();
	    			    else 
	    			    	continue;
	    			    
	    			    for(int j2=0;j2<vecPdb2.size();j2++)
    			    	{
    			    		Pdb pdb2=(Pdb)vecPdb2.elementAt(j2);
    			    		Vector vecAtom2=pdb2.getAtomVec();
    			    		for(int k2=0;k2<vecAtom2.size();k2++)
    			    		{
    			    			cc2=(Cartesian)vecAtom2.elementAt(k2);
    			    			atom2=cc2.getAtom();
    			    			if (atom2.substring(0,1).equalsIgnoreCase("H"))
    			    				proton2 = cc2.getXYZ();
    			    			else
    			    				continue;
    			    			double disTemp = Math.sqrt((proton[0] - proton2[0]) * (proton[0] - proton2[0]) 
    									+ (proton[1] - proton2[1]) * (proton[1] - proton2[1]) 
    									+ (proton[2] - proton2[2]) * (proton[2] - proton2[2]));
    			    			if(disTemp<noeLimit)
    			    			{
    			    				isFound=true;
    			    				break;
    			    			}
    			    			
    			    		}//for(int k2=0;k2<vecAtom2.size();k2++)
    			    		if(isFound==true)
    			    			break;
    			    		
    			    	}//for(int j2=0;j2<vecPdb2.size();j2++)
	    			    if(isFound==true)
			    			break;
	    			  
	    			}//for ( int k=0; k<vecAtom.size(); k++)
	    			if(isFound==true)
		    			break;	    			
	    		}//for(int j=0;j<vecPdb.size();j++)
	    		
		    	if(isFound==true)
		    		vecNeighbors.add(gc2);
		    	
		    }//for(int i2=0;i<vecResGraph.size();i2++)
    		gc.setNeighbors(vecNeighbors);
		   
    		
    	}//for (int i=0;i<vecResGraph.size();i++)
    	   	
    	return vecResGraph;
    }

    /** calculate the scoring function based on NOE patterns
     @param vecGraphCut: vector of GraphCut nodes
     @param vecBB: backbone pdb
     @param assignVec: assigned resonance list
     @param NoesyVec: NOESY peak list
     @param csErrH, csErrN, csErrCA: error window at each dimension
     @param  distBound: Noe distance bound
     @return a vector of GraphCut nodes after setting scoring function
    *  
    */    
    public Vector ComputeScoringFunction(Vector vecGraphCut,Vector vecBB, Vector assignVec,Vector NoesyVec,
    		double csErrH, double csErrN, double csErrCA, double distBound )
    {
    	Vector vecGraphCutNew=new Vector();
    	vecGraphCutNew.addAll(vecGraphCut);   	
    	
    	Pdb pp=new Pdb();
    	Assign asg=new Assign();
    	RotaPattern rotPattern=new RotaPattern();    	
    	
    	for (int i=0;i<vecGraphCutNew.size();i++)
    	{
    		System.out.println("i="+i);
    		
    		GraphCut gc=(GraphCut) vecGraphCutNew.elementAt(i);
    		Vector vecRotPdbs=gc.getAllRotVec();
    		int residueNO=gc.getResidueNo();
    		String rotamResName=gc.getResidueName();
    		Vector vecBackNoe=new Vector();
    		Vector vecHdist=new Vector();
    		Pdb pdbRotamer=new Pdb();
    		double dbScore=0.0;
    		
    		//1. compute the homogeneity score:
    		for (int j=0;j<vecRotPdbs.size();j++)
    		{
    			vecHdist=new Vector();
    			vecBackNoe=new Vector();
    			Vector vecRotamer =new Vector();
    			pdbRotamer=(Pdb)vecRotPdbs.elementAt(j);
    			vecRotamer.add(pdbRotamer);
    			vecHdist=pp.compDistPatternForRotam(vecRotamer,residueNO, vecBB,distBound);//vecRotamerRmsd,pdbVecNRmsd);//distance bound
    			vecBackNoe=rotPattern.BackCompNoePattern(assignVec,residueNO,rotamResName,vecHdist);
    			int [] numPeaks=new int[1];//not used here 
        		dbScore=asg.NoePatternMatchScore(csErrH,csErrN, csErrCA,vecBackNoe,NoesyVec, numPeaks,false);//prob score between 0 and 1
    			
        		//put -ln 
        		dbScore=- Math.log(dbScore);
        		
        		gc.setHomoScore(dbScore,j);    			
    			//initially associate each rotamer with homogeneity score:
    			//vecRotScore.add(new RotScore(pdbRotamer,dbScore));
    		}//for (int j=0;j<vecRotPdbs.size();j++)   
    		
    		//sort the rotamers according to their matching scores:
    		//Collections.sort(vecRotScore, new GraphCut.RotScoreComparator());     		
    		
    		
    		//2. compute the pairwise score:
    		dbScore=0.0;
    		Vector vecNeighs=gc.getNeighborVec();
    		
    		System.out.println("here we consider pairwise: i="+i+ " neighbor size="+vecNeighs.size());
    		
    		for (int j=0;j<vecRotPdbs.size();j++)
    		{
    			
    			Pdb pdbA=(Pdb)vecRotPdbs.elementAt(j);
	    		for (int k=0; k<vecNeighs.size();k++)
	    		{
	    			GraphCut gcB=(GraphCut)vecNeighs.elementAt(k);
	    			Vector vecRotPdbsB=gcB.getAllRotVec();
	    			int resNOB=gcB.getResidueNo();
	    			for (int h=0;h<vecRotPdbsB.size();h++)
	    			{
	    				Pdb pdbB=(Pdb)vecRotPdbsB.elementAt(h);
	    				vecHdist=new Vector();
	    				vecBackNoe=new Vector();
	    				//compute distance patterns from pairwise rotamers
	    				vecHdist=pp.compDistPatternFromPairRotams(residueNO,resNOB,pdbA,pdbB,distBound);
	    				vecBackNoe=rotPattern.BackCompNoePattern(assignVec,residueNO,rotamResName,vecHdist);
	        			int [] numPeaks=new int[1];//not used here 
	            		dbScore=asg.NoePatternMatchScore(csErrH,csErrN, csErrCA,vecBackNoe,NoesyVec, numPeaks,false);//prob score between 0 and 1
	        		    //take -ln
	            		dbScore=-Math.log(dbScore);
	            		
	            		gc.setPairScore(dbScore,j,k,h);
	    			}//for (int h=0;h<vecRotPdbsB.size();h++)
	    			
	    		}//for (int k=0; k<vecNeighs.size();k++)
    		}//for (int j=0;j<vecRotPdbs.size();j++)
    		
    	}//for (int i=0;i<vecGraphCutNew.size();i++)
    	
    	return vecGraphCutNew;
    }
    
    /** DEE-Cut step in the graph cut algorithm
    @param vecGraphCutPre: vector of GraphCut nodes before DEE Cut    
    @return a vector of GraphCut nodes after DEE-Cut
   *  
   */    
    public Vector DEECut(final Vector vecGraphCutPre)
    {
    	Vector vecGraphCut=new Vector();
    	vecGraphCut.addAll(vecGraphCutPre);
    	for (int i=0;i<vecGraphCut.size();i++)
    	{
    		GraphCut gc=(GraphCut)vecGraphCut.elementAt(i);
    		Vector vecRots=gc.getAllRotVec();
    		Vector vecNeighs=gc.getNeighborVec();
    		
    		//here we decide whether each rotamer is prunable
    		for (int j=0;j<vecRots.size();j++)
    		{
    			//compute the best possible score for rotamer j
    			double homoSc=gc.getHomoScore(j);
    			double allSc=homoSc;
    			boolean isPruned=false;
    			
    			for (int k=0;k<vecNeighs.size();k++)
    			{
    				GraphCut gcNeigh=(GraphCut)vecNeighs.elementAt(k);
    				Vector vecRotsNeigh=gcNeigh.getAllRotVec();
    				double pairMinSc=1000;
    				int inMinRotID=0;
    				for (int h=0;h<vecRotsNeigh.size();h++)
    				{
    					double pairSc=gc.getPairScore(j,k,h);
    					if (pairSc<pairMinSc)
    					{
    						pairMinSc=pairSc;
    						inMinRotID=h;
    					}
    				}//for (int h=0;h<vecRotsNeigh.size();h++)
    				allSc=allSc+pairMinSc;    				
    			}//for (int k=0;k<vecNeighs.size();k++)
    				
    			
    			//check whether exists another rotamer contrabuting more to energy
    			for(int j2=0;j2<vecRots.size();j2++)
    			{
    				if (j2==j)
    					continue;
    				double allScOther=gc.getHomoScore(j2);
    				for(int k=0;k<vecNeighs.size();k++)
    				{
    					GraphCut gcNeigh=(GraphCut)vecNeighs.elementAt(k);
    					Vector vecRotsNeigh=gcNeigh.getAllRotVec();
    					double pairMaxSc=-1000.0;
    					int inMaxRotID=0;
    					for(int h=0;h<vecRotsNeigh.size();h++)
    					{
    						double pairSc=gc.getPairScore(j2,k,h);
    						if(pairSc> pairMaxSc)
    						{
    							pairMaxSc=pairSc;
    							inMaxRotID=h;
    						}
    					}//for(int h=0;h<vecRotsNeigh.size();h++)
    					allScOther=allScOther+pairMaxSc;
    				}//for(int k=0;k<vecNeighs.size();k++)
    				
    				if(allSc>allScOther)
    				{
    					isPruned=true;
    					break;
    				}
    			}//for(int j2=0;j2<vecRots.size();j2++)
    			if (isPruned==true)
    				gc.setPrunedLabel(j);
    				
    		}//for (int j=0;j<vecRots.size();j++)
    		
    	}//for (int i=0;i<vecGraphCut.size();i++)
    	
    	//new after prunning rotamers
    	Vector vecGraphCutNew=new Vector();
    	for (int i=0;i<vecGraphCut.size();i++)
    	{
    		GraphCut gc=(GraphCut)vecGraphCut.elementAt(i);
    		String residueName=gc.getResidueName();
    		int residueNo=gc.getResidueNo();
    		Vector vecAllRots=gc.getAllRotVec();
    		Vector vecNeighsRots=gc.getNeighborVec();
    		Vector vecAllRotsNew=new Vector();
    		for (int j=0;j<vecAllRots.size();j++)
    		{
    			Pdb pp=(Pdb)vecAllRots.elementAt(j);
    			if(gc.getIsRemainedLabel(j)==true)
    				vecAllRotsNew.add(pp);
    		}
    		vecGraphCutNew.add(new GraphCut(residueName,residueNo,0,vecAllRotsNew,vecNeighsRots));
    		    		
    	}//for (int i=0;i<vecGraphCut.size();i++)
    	
    	
    	return vecGraphCutNew;
    }
    
    /** Shuffling step in the graph cut algorithm
    @param vecGraphCutPre: vector of GraphCut nodes before DEE Cut    
    @return a vector of GraphCut nodes after Shuffling
   *  
   */    
    public Vector ShufflingCut(final Vector vecGraphCutPre)
    {
    	Vector vecGraphCut=new Vector();
    	vecGraphCut.addAll(vecGraphCutPre);
    	
    	//1. starting from a random initial configuration
    	for (int i=0;i<vecGraphCut.size();i++)
    	{
    		GraphCut gc=(GraphCut)vecGraphCut.elementAt(i);
    		Vector vecRots=gc.getAllRotVec();
    		int rotSize=vecRots.size();
    		Random randGen = new Random();
    		int nLabelPk;    		
    		nLabelPk = randGen.nextInt(rotSize);//random int between 0 and rotSize-1
    		while (gc.getIsRemainedLabel(nLabelPk)==false)
    		{
    			nLabelPk = randGen.nextInt(rotSize);
    		}
    		gc.setRotlabel(nLabelPk);    		
    	}//for (int i=0;i<vecGraphCut.size();i++)
    	
    	//2. The Shuflling step:
    	for (int i=0;i<vecGraphCut.size();i++)
    	{
    		GraphCut gc=(GraphCut)vecGraphCut.elementAt(i);
    		Vector vecRots=gc.getAllRotVec();
    		Vector vecNeighs=gc.getNeighborVec();    		
    		int nRotLabl=gc.getRotLabel();    		
    	
    		for (int j=0;j<vecRots.size();j++)
    		{
    			double allScore=gc.getHomoScore(j);
    			
    			//copy the whole graph so that we can change templately
    			Vector vecGCTemp=new Vector();
    			vecGCTemp.addAll(vecGraphCut);
    			
    			
    			
    			for(int k=0;k<vecNeighs.size();k++)
    			{
    				
    			}//for(int k=0;k<vecNeighs.size();k++)
    			
    		}//for (int j=0;j<vecRots.size();j++)
    		
    		
    		//////////////////////////
    		//compute the energy score:
    		/*double allSc=gc.getHomoScore(nRotLabl);
    		
    		//here we decide whether each rotamer is prunable
    		for (int j=0;j<vecRots.size();j++)
    		{
    			//compute the best possible score for rotamer j
    			double homoSc=gc.getHomoScore(j);
    			double allSc=homoSc;
    			boolean isPruned=false;
    			
    			for (int k=0;k<vecNeighs.size();k++)
    			{
    				GraphCut gcNeigh=(GraphCut)vecNeighs.elementAt(k);
    				Vector vecRotsNeigh=gcNeigh.getAllRotVec();
    				double pairMinSc=1000;
    				int inMinRotID=0;
    				for (int h=0;h<vecRotsNeigh.size();h++)
    				{
    					double pairSc=gc.getPairScore(j,k,h);
    					if (pairSc<pairMinSc)
    					{
    						pairMinSc=pairSc;
    						inMinRotID=h;
    					}
    				}//for (int h=0;h<vecRotsNeigh.size();h++)
    				allSc=allSc+pairMinSc;    				
    			}//for (int k=0;k<vecNeighs.size();k++)
    				
    			
    			//check whether exists another rotamer contrabuting more to energy
    			for(int j2=0;j2<vecRots.size();j2++)
    			{
    				if (j2==j)
    					continue;
    				double allScOther=gc.getHomoScore(j2);
    				for(int k=0;k<vecNeighs.size();k++)
    				{
    					GraphCut gcNeigh=(GraphCut)vecNeighs.elementAt(k);
    					Vector vecRotsNeigh=gcNeigh.getAllRotVec();
    					double pairMaxSc=-1000.0;
    					int inMaxRotID=0;
    					for(int h=0;h<vecRotsNeigh.size();h++)
    					{
    						double pairSc=gc.getPairScore(j2,k,h);
    						if(pairSc> pairMaxSc)
    						{
    							pairMaxSc=pairSc;
    							inMaxRotID=h;
    						}
    					}//for(int h=0;h<vecRotsNeigh.size();h++)
    					allScOther=allScOther+pairMaxSc;
    				}//for(int k=0;k<vecNeighs.size();k++)
    				
    				if(allSc>allScOther)
    				{
    					isPruned=true;
    					break;
    				}
    			}//for(int j2=0;j2<vecRots.size();j2++)
    			if (isPruned==true)
    				gc.setPrunedLabel(j);
    				
    		}//for (int j=0;j<vecRots.size();j++)
    		*/
    		////////////////////
    		
    	}//for (int i=0;i<vecGraphCut.size();i++)
    	
    	
    	return vecGraphCut;
    }
    
    /** select top rotamers with highest scores
    @param pdbBBVec: vector of backbone pdb
    @param vecGraphCut: vector of GraphCut nodes 
    @param resNo: residue ID
    @param pickNum: number of rotamers to be chosen in the ensemble   
    @return a vector of structure pdb after putting all rotamers into backbone
   *  
   */    
    public Vector RotamerSelection(Vector pdbBBVec, Vector vecGraphCut,  int pickNum)
    {    	    
    	//////////
    	Pdb pp=new Pdb();
    	Pdb pdb;
    	int residueNo;
    	String residueName;
    	Vector vecGrowPdb=new Vector();
    	vecGrowPdb=pdbBBVec;//initial structure to plug in rotamers
    	Vector pdbRotamNewRef=new Vector();
    	for (int j=0;j<pdbBBVec.size();j++)
    	{ 	
        	pdb=(Pdb)vecGrowPdb.elementAt(j);
        	residueName=pdb.getResidue();
        	residueNo=pdb.getResidueNo();
        	pdbRotamNewRef=new Vector();
        	
        	GraphCut gc=new GraphCut();
        	int ind1 = Collections.binarySearch(vecGraphCut, new GraphCut(residueNo), new GraphCut.ResNoComparator());
        	gc=(GraphCut)vecGraphCut.elementAt(ind1);
        	
        	int indRef = Collections.binarySearch(vecGrowPdb, new Pdb(residueNo), new Pdb.PdbComparator());
        	    	
        	if (!(indRef<0))
        		pdbRotamNewRef=gc.getTopScoreRots(pickNum);
        	
        	Vector vecTemp=pp.CombinRotBB(pdbRotamNewRef,vecGrowPdb,residueNo);
			//pp.print(vecTemp);
        	vecGrowPdb=vecTemp;
        	
    	}//for (int j=0;j<pdbBBVec.size();j++)
    	
    	//pp.print(vecGrowPdb);
    	return vecGrowPdb;
    }
    
    /** update the match score using random voting scheme
    @param vecGraphCut: vector of GraphCut nodes 
    @return a vector of graph cut nodes after updating the matching score
   *  
   */    
    public Vector RandomVotingUpdate(Vector vecGraphCut)
    {    	 
    	Vector vecGraphCutNew=new Vector();
    	vecGraphCutNew.addAll(vecGraphCut);
    	
    	//1. set score to be homogeneity score:
    	for (int i=0; i< vecGraphCutNew.size(); i++)
    	{
    		GraphCut gc=(GraphCut)vecGraphCutNew.elementAt(i);    		
        	gc.setInitialRotScore();
    	}
    	
    	//2. update score based on neighbor's rotamers
    	for (int i=0; i< vecGraphCutNew.size(); i++)
    	{
    		GraphCut gc=(GraphCut)vecGraphCutNew.elementAt(i);
    		  		
        	Vector vecRotScore=gc.getRotScoreVec();        	
        	
    		Vector vecNeighs=gc.getNeighborVec();
    		
    		for (int j=0;j<vecNeighs.size();j++)
    		{
    			GraphCut gcNeigh=(GraphCut)vecNeighs.elementAt(j);
    			Vector vecNeighRotSc=gcNeigh.getRotScoreVec();
    			int pkNo=RandomSelectRot(vecNeighRotSc);
    			
    			RotScore rtScore=(RotScore)vecNeighRotSc.elementAt(pkNo);
    			int pkOrignNo=rtScore.getOriginID();
    			    			
    			for (int k=0;k<vecRotScore.size();k++)
    			{
    				RotScore rtScoreTemp=(RotScore)vecRotScore.elementAt(k);
    				int curRotId=rtScoreTemp.getOriginID();
    				double dbTemp=gc.getPairScore(curRotId,j,pkOrignNo);
    				gc.addRotScore(k,dbTemp);
    			}
    		}//for (int j=0;j<vecNeighs.size();j++)
    		
    		// sort the rot scores:
    		gc.sortRotScore();
    		
    	}//for (int i=0; i< vecGraphCutNew.size(); i++)
    	
    	
    	//note: since the reuslts w/ w/o look the same, probably we don't need refinement here
    	//(based on the test on pol-eta.)
    	
    	//    	3.refine the score based on neighbors
    /*	for (int i=0; i< vecGraphCutNew.size(); i++)
    	{
    		GraphCut gc=(GraphCut)vecGraphCutNew.elementAt(i);
    		gc.setInitialRotScore();
        	Vector vecRotScore=gc.getRotScoreVec();
        	
        	
    		Vector vecNeighs=gc.getNeighborVec();
    		
    		for (int j=0;j<vecNeighs.size();j++)
    		{
    			GraphCut gcNeigh=(GraphCut)vecNeighs.elementAt(j);
    			Vector vecNeighRotSc=gcNeigh.getRotScoreVec();
    			int pkNo=RandomSelectRot(vecNeighRotSc);
    			
    			for (int k=0;k<vecRotScore.size();k++)
    			{
    				double dbTemp=gc.getPairScore(k,j,pkNo);
    				gc.addRotScore(k,dbTemp);
    			}
    		}//for (int j=0;j<vecNeighs.size();j++)
    		
    		// sort the rot scores:
    		gc.sortRotScore();
    		
    	}//for (int i=0; i< vecGraphCutNew.size(); i++)
    	
    	//    	4.refine the score based on neighbors
    	for (int i=0; i< vecGraphCutNew.size(); i++)
    	{
    		GraphCut gc=(GraphCut)vecGraphCutNew.elementAt(i);
    		gc.setInitialRotScore();
        	Vector vecRotScore=gc.getRotScoreVec();
        	
        	
    		Vector vecNeighs=gc.getNeighborVec();
    		
    		for (int j=0;j<vecNeighs.size();j++)
    		{
    			GraphCut gcNeigh=(GraphCut)vecNeighs.elementAt(j);
    			Vector vecNeighRotSc=gcNeigh.getRotScoreVec();
    			int pkNo=RandomSelectRot(vecNeighRotSc);
    			
    			for (int k=0;k<vecRotScore.size();k++)
    			{
    				double dbTemp=gc.getPairScore(k,j,pkNo);
    				gc.addRotScore(k,dbTemp);
    			}
    		}//for (int j=0;j<vecNeighs.size();j++)
    		
    		// sort the rot scores:
    		gc.sortRotScore();
    		
    	}//for (int i=0; i< vecGraphCutNew.size(); i++)
    	*/
    	
    	return vecGraphCutNew;
    	
    }
}
