package rdcPanda;

///////////////////////////////////////////////////////////////////////////////////////////////
//	HnNoe.java
//
//	  Version:           0.1
//
//
//	  authors:
// 	  initials            name                      organization               email
//	 ---------   -----------------------        ------------------------    ------------------
//	  LW            Lincong Wang                  Dartmouth College       wlincong@cs.dartmouth.edu
//
///////////////////////////////////////////////////////////////////////////////////////////////



/*
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
	USA
	
	Contact Info:
		Bruce Donald
		Duke University
		Department of Computer Science
		Levine Science Research Center (LSRC)
		Durham
		NC 27708-0129 
		USA
		brd@cs.duke.edu
	
	If you use or publish any results derived from the use of this program please cite:
	J. Zeng, J. Boyles, C. Tripathy, L. Wang, A. Yan, P. Zhou and B.R. Donald. 
	"High-Resolution Protein Structure Determination Starting with a Global Fold 
	Calculated from Exact Solutions to the RDC Equations." Submitted For Review.

	Copyright (C) 2009 Jianyang (Michael) Zeng, Lincong Wang and Bruce R. Donald		
	<signature of Bruce Donald>, June 2008 and January 2009
	Bruce Donald, Professor of Computer Science
 */



import java.io. *;
import java.util. *;

// TODO: Auto-generated Javadoc
/** * 
 * 
*   This class defines data structures related to N-15 labeled NOEs. 
*   This class is no longer used and replaced by H1CS.   Written by Lincong Wang (2001-2005).
*/
public class HnNoe{
    
    /** The residue no. */
    private int    residueNo; 
    
    /** The residue. */
    private String residue;
    
    /** The cs hn. */
    private double csHN; 
    
    /** The cs n15. */
    private double csN15;
    
    /** The cs h1. */
    private double csH1;
    
    /** The intensity. */
    private double intensity;
    
    /** The uncertainty. */
    private double uncertainty=0.0;
    
    /** The label. */
    private int label;//represent the type of intensi,1-5
    //The real usefulness of the these two items have NOT been determined
    /** The noe map. */
    private Map noeMap = new TreeMap();  //A map with CS as key and assignment as value
    
    /** The assign map. */
    private Map assignMap = new TreeMap(); //the possible assignment for this peak

    /**
     * Instantiates a new hn noe.
     */
    public HnNoe(){
	residueNo = 0;
	residue = null;
	csHN = 0.0; 
        csN15 = 0.0;
        csH1 =0.0;
	intensity = 0.0;
	assignMap = new TreeMap();
	noeMap = new TreeMap();
    }		
    
    /**
     * Instantiates a new hn noe.
     * 
     * @param no the no
     */
    public HnNoe(int no){
	residueNo = no;
	residue = null;
	csHN = 0.0; 
        csN15 = 0.0;
        csH1 = 0.0;
	intensity = 0.0;
	label=0;
	assignMap = new TreeMap();
	noeMap = new TreeMap();
    }		
    
    /**
     * Instantiates a new hn noe.
     * 
     * @param no the no
     * @param resid the resid
     * @param HN the hN
     * @param N15 the n15
     * @param H1 the h1
     * @param inten the inten
     */
    public HnNoe(int no,String resid, double HN, double N15, double H1, double inten){
	residueNo = no;
	residue = resid;
	csHN = HN; 
        csN15 = N15;
        csH1 = H1;
	intensity = inten;
	label=0;
	assignMap = new TreeMap();
	noeMap = new TreeMap();
    }	
    
    /**
     * Instantiates a new hn noe.
     * 
     * @param no the no
     * @param resid the resid
     * @param HN the hN
     * @param N15 the n15
     * @param H1 the h1
     * @param inten the inten
     * @param uncn the uncn
     */
    public HnNoe(int no,String resid, double HN, double N15, double H1, double inten,double uncn){
    	residueNo = no;
    	residue = resid;
    	csHN = HN; 
            csN15 = N15;
            csH1 = H1;
    	intensity = inten;
    	label=0;
    	assignMap = new TreeMap();
    	noeMap = new TreeMap();
    	uncertainty= uncn;
        }	
    
    /**
     * Instantiates a new hn noe.
     * 
     * @param no the no
     * @param resid the resid
     * @param HN the hN
     * @param N15 the n15
     * @param H1 the h1
     * @param labelType the label type
     */
    public HnNoe(int no,String resid, double HN, double N15, double H1, int labelType){
    	residueNo = no;
    	residue = resid;
    	csHN = HN; 
            csN15 = N15;
            csH1 = H1;
    	label = labelType;
    	intensity = 0.0;
    	assignMap = new TreeMap();
    	noeMap = new TreeMap();
        }	
    
    /**
     * Instantiates a new hn noe.
     * 
     * @param no the no
     * @param resid the resid
     * @param HN the hN
     * @param N15 the n15
     * @param H1 the h1
     * @param inten the inten
     * @param aMap the a map
     */
    public HnNoe(int no,String resid, double HN, double N15, double H1, double inten, Map aMap){
	residueNo = no;
	residue = resid;
	csHN = HN; 
        csN15 = N15;
        csH1 = H1;
	intensity = inten;
	label=0;
	assignMap = aMap;
	noeMap = new TreeMap();
    }	
    
    /**
     * Instantiates a new hn noe.
     * 
     * @param HN the hN
     * @param N15 the n15
     * @param H1 the h1
     */
    public HnNoe( double HN, double N15, double H1){
    	residueNo = 0;
    	residue = "";
    	csHN = HN; 
            csN15 = N15;
            csH1 = H1;
    	intensity = 0.0;
    	label=0;
    	assignMap = new TreeMap();
    	noeMap = new TreeMap();
        }	
  //getting the values	
    /**
   * Gets the residue no.
   * 
   * @return the residue no
   */
  public int getResidueNo(){
	return residueNo;
    }	
    
    /**
     * Gets the label.
     * 
     * @return the label
     */
    public int getLabel(){
    	return label;
        }	
    
    /**
     * Gets the residue type.
     * 
     * @return the residue type
     */
    public String getResidueType(){
	return residue;
    }	
    
    /**
     * Gets the hN.
     * 
     * @return the hN
     */
    public double getHN(){
	return csHN;
    }	
    
    /**
     * Gets the n15.
     * 
     * @return the n15
     */
    public double getN15(){
	return csN15;
    }	
    
    /**
     * Gets the h1.
     * 
     * @return the h1
     */
    public double getH1(){
	return csH1;
    }	
    
    /**
     * Gets the intensity.
     * 
     * @return the intensity
     */
    public double getIntensity(){
	return intensity;
    }
    
    /**
     * Gets the assign map.
     * 
     * @return the assign map
     */
    public Map getAssignMap(){
	return assignMap;
    }	

    //set the values	
    /**
     * Sets the residue no.
     * 
     * @param R the new residue no
     */
    public void setResidueNo(int R){
	residueNo = R;
    }	
    
    /**
     * Sets the residue type.
     * 
     * @param R the new residue type
     */
    public void setResidueType(String R){
	residue = R;
    }	
    
    /**
     * Sets the assign map.
     * 
     * @param aMap the new assign map
     */
    public void setAssignMap(Map aMap){
	assignMap = aMap;
    }	

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    public String toString(){
	String desc = "";
	String str = String.valueOf(residueNo) +" "+residue+"\n";
	double csValue = 0.0;
	if (!assignMap.isEmpty()){
	    for (Iterator i = assignMap.entrySet().iterator(); i.hasNext(); ){
		Map.Entry e = (Map.Entry) i.next();
		csValue =  ((Double)e.getValue()).doubleValue();
		if( Math.abs(csValue+999.99) > 0.01)
		    str += (String)e.getKey()+" = "+ (Double)e.getValue()+"\n";
	    }
	    desc +=  str+"\n";
	    desc += String.valueOf(csHN)+"  "+String.valueOf(csN15)
		+"   "+String.valueOf(csH1)+"  "+String.valueOf(intensity);
	}else{
	    desc = String.valueOf(csHN) +"  "+String.valueOf(csN15)
		+"   "+String.valueOf(csH1)+"  "+String.valueOf(intensity);
	}
	return desc;	
    }

    /**
     * The Class resNoComparator.
     */
    public static class resNoComparator implements Comparator{
	
	/* (non-Javadoc)
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object o1, Object o2){
	    HnNoe n1 = (HnNoe)o1;
	    HnNoe n2 = (HnNoe)o2;
	    double d1 = n1.getResidueNo();
	    double d2 = n2.getResidueNo();
	    if (d1 < d2)
		return -1;
	    else if (d1 > d2)
		return 1;
	    else return 0;
	}
    }

    /**
     * The Class hnComparator.
     */
    public static class hnComparator implements Comparator{
	
	/* (non-Javadoc)
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object o1, Object o2){
	    HnNoe n1 = (HnNoe)o1;
	    HnNoe n2 = (HnNoe)o2;
	    double d1 = n1.getHN();
	    double d2 = n2.getHN();
	    if (d1 < d2)
		return -1;
	    else if (d1 > d2)
		return 1;
	    else return 0;
	}
    }

    /**
     * The Class h1Comparator.
     */
    public static class h1Comparator implements Comparator{
	
	/* (non-Javadoc)
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object o1, Object o2){
	    HnNoe n1 = (HnNoe)o1;
	    HnNoe n2 = (HnNoe)o2;
	    double d1 = n1.getH1();
	    double d2 = n2.getH1();
	    if (d1 < d2)
		return -1;
	    else if (d1 > d2)
		return 1;
	    else return 0;
	}
    }

    /**
     * The Class n15Comparator.
     */
    public static class n15Comparator implements Comparator{
	
	/* (non-Javadoc)
	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
	 */
	public int compare(Object o1, Object o2){
	    HnNoe n1 = (HnNoe)o1;
	    HnNoe n2 = (HnNoe)o2;
	    double d1 = n1.getN15();
	    double d2 = n2.getN15();
	    if (d1 < d2)
		return -1;
	    else if (d1 > d2)
		return 1;
	    else return 0;
	}
    }

   /**
    * A method for reading NOE  files
    * The required file format is:.
    * 
    * @param filename the name of the file
    * 
    * @return a vector of HnNOE object
    */
    public Vector hnNoeReader(String filename){
	Vector inputs = new Vector();
	double csHN = 0.0, csN15 = 0.0, csH1 = 0.0, intensity = 0.0;
	Vector csVec = new Vector();
	StringTokenizer st = new StringTokenizer("");
	String str = "";
	int index1=0, index2=0;
	String order="";
	double value=0.0;
	int no =0;
	String aaType = "", ss ="";
	try{
	    BufferedReader in = new BufferedReader(new FileReader(filename));	
	    ss = in.readLine();
	    ss = in.readLine();
	    ss = in.readLine();
	    stop:
	    while(true) {
		st = new StringTokenizer(ss);
		if (st.hasMoreTokens())
		    st.nextToken();
		if (st.hasMoreTokens())
		    st.nextToken();
		if (st.hasMoreTokens())
		    csHN = new Double(st.nextToken()).doubleValue();
		if (st.hasMoreTokens())
		    st.nextToken();
		if (st.hasMoreTokens())
		    csH1 = new Double(st.nextToken()).doubleValue();
		if (st.hasMoreTokens())
		    st.nextToken();
		if (st.hasMoreTokens())
		    csN15 = new Double(st.nextToken()).doubleValue();
		if (st.hasMoreTokens()){
		    str = st.nextToken();
		    index1 = str.indexOf("e");
		    order = str.substring(index1+1);
		    value = new Double(str.substring(0, index1)).doubleValue();

		    if (order.equals("+10"))
			intensity = value*10000;
		    if (order.equals("+09"))
			intensity = value*1000;
		    else if (order.equals("+08"))
			intensity = value*100;
		    else if (order.equals("+07"))
			intensity = value*10;
		    else if (order.equals("+06"))
			intensity = value;
		    else if (order.equals("+05"))
			intensity = value*0.10;
		    else System.out.println("Intensity Error");
		}
		inputs.add(new HnNoe(no, aaType, csHN, csN15, csH1, intensity));
		if ((ss = in.readLine()) == null){

		    break stop;
		}
	    }
	}catch (FileNotFoundException e) {
	    System.out.println("File not found: " + filename);
	}catch (IOException e) {
	    System.out.println("IOException: the stack trace is:");
	    e.printStackTrace();
	}
	return inputs;
    }

   /**
    * Read NOESY peaks in xeasy format
    * The required file format is:.
    * 
    * @param filename the name of the file
    * 
    * @return a vector of HnNOE object
    */
    public Vector NoesyReader(String filename)
    {
	Vector inputs = new Vector();
	double csHN = 0.0, csN15 = 0.0, csH1 = 0.0, intensity = 0.0, uncertainty=0.0;
	Vector csVec = new Vector();
	StringTokenizer st = new StringTokenizer("");
	String str = "";
	String strTemp="";
	double csID=0;
	int index1=0, index2=0;
	String order="";
	double value=0.0;
	int no =0;
	String aaType = "", ss ="";
	int counter=0;
	int    index = -1;
	try
	{
	    BufferedReader in = new BufferedReader(new FileReader(filename));	
	    ss = in.readLine();
	 
	    stop:
	    while(true) 
	    {
	    	index = ss.trim().indexOf("#");
	    	if (index==0)
	    	{
	    		if ((ss = in.readLine()) == null)
		    		break stop;
	    		continue;	    		
	    	}
	    	
	    	st = new StringTokenizer(ss);
	    	if (st.hasMoreTokens())
	    		csID = new Double(st.nextToken()).doubleValue();
	    	if (st.hasMoreTokens())
	    		csN15 = new Double(st.nextToken()).doubleValue();
	    	if (st.hasMoreTokens())
	    		csHN = new Double(st.nextToken()).doubleValue();	    	
	    	if (st.hasMoreTokens())
	    		csH1 = new Double(st.nextToken()).doubleValue();
	    	
	    	if (st.hasMoreTokens())
	    		strTemp = new String(st.nextToken());
	    	if (st.hasMoreTokens())
	    		strTemp = new String(st.nextToken());
	    	
	    	if (st.hasMoreTokens())
	    	{
	    		intensity = new Double(st.nextToken()).doubleValue();
	    		
	    	}
	    	if (st.hasMoreTokens())
	    		uncertainty = new Double(st.nextToken()).doubleValue();
	    	
	    	counter=counter+1;
	    	inputs.add(new HnNoe(0, "", csHN, csN15, csH1, intensity,uncertainty));
	    	if ((ss = in.readLine()) == null)
	    		break stop;
	    	}
	}catch (FileNotFoundException e) {
	    System.out.println("File not found: " + filename);
	}catch (IOException e) {
	    System.out.println("IOException: the stack trace is:");
	    e.printStackTrace();
	}
	 System.out.println("The total number of HN-NOE frequency triples is: " + counter);
	return inputs;
    }
    
    /**
     * Another method for reading NOE  files
     * The required file format is:.
     * 
     * @param filename the name of the file
     * 
     * @return a vector of HnNOE object
     */
    public Vector hnNoeReader2(String filename){
	Vector inputs = new Vector();
	double csHN = 0.0, csN15 = 0.0, csH1 = 0.0, intensity = 0.0;
	Vector csVec = new Vector();
	StringTokenizer st = new StringTokenizer("");
	String str = "";
	int index1=0, index2=0;
	String order="";
	double value=0.0;
	int no =0;
	String aaType = "", ss ="";
	int counter=0;
	try{
	    BufferedReader in = new BufferedReader(new FileReader(filename));	
	    ss = in.readLine();
	    ss = in.readLine();
	    ss = in.readLine();
	    stop:
	    while(true) {
		st = new StringTokenizer(ss);
		if (st.hasMoreTokens())
		    csHN = new Double(st.nextToken()).doubleValue();
		if (st.hasMoreTokens())
		    csN15 = new Double(st.nextToken()).doubleValue();
		if (st.hasMoreTokens())
		    csH1 = new Double(st.nextToken()).doubleValue();
		if (st.hasMoreTokens()){
		    intensity = new Double(st.nextToken()).doubleValue();
		    if (intensity < 1.0)
			intensity *= 10;
		}else intensity = 3.0;
		counter=counter+1;
		inputs.add(new HnNoe(0, "", csHN, csN15, csH1, intensity));
		if ((ss = in.readLine()) == null){
		    break stop;
		}
	    }
	}catch (FileNotFoundException e) {
	    System.out.println("File not found: " + filename);
	}catch (IOException e) {
	    System.out.println("IOException: the stack trace is:");
	    e.printStackTrace();
	}
	 System.out.println("The total number of HN-NOE frequency triples is: " + counter);
	return inputs;
    }

    /**
     * Extract all the HnNoe objects with proton CS or N15 CS in the
     * range of [a, b] from an array of NOE peaks.
     * 
     * @param nucType the type of nucleus: H1 or N15
     * @param a   the lower limit of the range
     * @param b   the up limit of the range
     * @param pkVec an array of NOE peaks.
     * 
     * @return the vector
     */
    public Vector rangeSearch(String nucType, double a, double b, Vector pkVec){
	Vector outVec = new Vector();
	double csValue = 0.0;
	for (int i=0; i< pkVec.size(); i++){
	    if (nucType.equals("H1"))
		csValue = ((HnNoe)pkVec.elementAt(i)).getHN();
	    else if (nucType.equals("N15"))
		csValue = ((HnNoe)pkVec.elementAt(i)).getN15();
	    if (csValue >= a && csValue <= b)
		outVec.add(pkVec.elementAt(i));
	}
	return outVec;
    }

  /**
   * a method to merge NOE peaks since some NOE peaks are picked with
   * a lightly different CS more than once.
   * 
   * @param pkVec the pk vec
   * @param epsH the eps h
   * @param epsN the eps n
   * 
   * @return the vector
   */
    public Vector mergeHnNoe(Vector pkVec, double epsH, double epsN){
	double csHN = 0.0;
	double csN15 = 0.0;
	double csHNTmp = 0.0;
	double csN15Tmp = 0.0;
	Vector outVec = new Vector();
	Vector allVec = new Vector();
	double csValue = 0.0;
	HnNoe hncc = new HnNoe();
	int i = 0, j = 0;
	Collections.sort(pkVec, new HnNoe.n15Comparator());
	int count = 0, cnt1 = 0, cnt2 = 0;
	int N = pkVec.size();
	while (!pkVec.isEmpty()){
	    hncc = (HnNoe)pkVec.elementAt(0);
	    csHN  = hncc.getHN();
	    csN15 = hncc.getN15();
	    outVec.add(hncc);
	    cnt1 = 0;
	    for (i=1; i< pkVec.size(); i++){
		hncc = (HnNoe)pkVec.elementAt(i);
		csHNTmp = hncc.getHN();
		csN15Tmp = hncc.getN15();
		if ( Math.abs(csHNTmp - csHN) < epsH && Math.abs(csN15Tmp - csN15) < epsN){
		    outVec.add(hncc);
		    cnt1++;
		}
	    }
	    allVec.add(outVec);
	    outVec = new Vector();
	    cnt2 = 0;
	    for (j=0; j< pkVec.size();){
		hncc = (HnNoe)pkVec.elementAt(j);
		csHNTmp = hncc.getHN();
		csN15Tmp = hncc.getN15();
		if ( Math.abs(csHNTmp - csHN) < epsH && Math.abs(csN15Tmp - csN15) < epsN){
		    pkVec.removeElementAt(j);
		    cnt2++;
		}else j++;
	    }	   
	    pkVec.trimToSize();
	    N = pkVec.size();

	}


	return allVec;
    }


}
