package rdcPanda;

///////////////////////////////////////////////////////////////////////////////////////////////
//	RdcPanda.java
//
//	  Version:           0.1
//
//
//	  authors:
// 	  initials            name                      organization               email
//	 ---------   -----------------------        ------------------------    ------------------
//	  JMZ		 Jianyang (Michael) Zeng	       Duke University			zengjy@cs.duke.edu
//
///////////////////////////////////////////////////////////////////////////////////////////////



/*
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
	USA
	
	Contact Info:
		Bruce Donald
		Duke University
		Department of Computer Science
		Levine Science Research Center (LSRC)
		Durham
		NC 27708-0129 
		USA
		brd@cs.duke.edu
	
	If you use or publish any results derived from the use of this program please cite:
	J. Zeng, J. Boyles, C. Tripathy, L. Wang, A. Yan, P. Zhou and B.R. Donald. 
	"High-Resolution Protein Structure Determination Starting with a Global Fold 
	Calculated from Exact Solutions to the RDC Equations." Submitted For Review.

	Copyright (C) 2009 Jianyang (Michael) Zeng, Lincong Wang and Bruce R. Donald		
	<signature of Bruce Donald>, June 2008 and January 2009
	Bruce Donald, Professor of Computer Science
 */



import java.io. *;
import java.util. *;

import Jampack.JampackException;

// TODO: Auto-generated Javadoc
/** 
 *  
 *  This class provides functions for packing SSE fragments.
 *  Written by  Jianyang (Michael) Zeng (2005-2009).
* 
*/
public class SSEPacking
{
	
	/** The ran theta. */
	private double ranTheta=0.0;
	
	/** The ran phi. */
	private double ranPhi=0.0;
	
	/** The length r. */
	private double lengthR=0.0;
	
	/** The score. */
	private double score=0.0;
	
	/**
	 * Instantiates a new sSE packing.
	 */
	public SSEPacking() 
	{
		ranTheta=0.0;
		ranPhi=0.0;
		lengthR=0.0;
		score=0.0;
    }
	
	/**
	 * Instantiates a new sSE packing.
	 * 
	 * @param dbT the db t
	 * @param dbP the db p
	 * @param dbR the db r
	 * @param dbS the db s
	 */
	public SSEPacking(double dbT, double dbP, double dbR, double dbS) 
	{
		ranTheta=dbT;
		ranPhi=dbP;
		lengthR=dbR;
		score=dbS;
    }
	

	 /**
 	 * Gets the theta.
 	 * 
 	 * @return the theta
 	 */
 	public double getTheta() 
	 {
			return ranTheta;
	 }	
	 
 	/**
	  * Gets the phi.
	  * 
	  * @return the phi
	  */
 	public double getPhi() 
	 {
			return ranPhi;
	 }
	 
 	/**
	  * Gets the length r.
	  * 
	  * @return the length r
	  */
 	public double getLengthR() 
	 {
			return lengthR;
	 }
	 
 	/**
	  * Gets the score.
	  * 
	  * @return the score
	  */
 	public double getScore() 
	 {
			return score;
	 }
	
	/**
	 * The Class SSEPackingComparator.
	 */
	public static class SSEPackingComparator implements Comparator
	   {
	       
       	/* (non-Javadoc)
       	 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
       	 */
       	public int compare(Object o1, Object o2){
	    	   SSEPacking n1 = (SSEPacking)o1;
	    	   SSEPacking n2 = (SSEPacking)o2;
	           double d1 = n1.getScore(); 
	           double d2 = n2.getScore();
	           if (d1 < d2)
	               return -1;
	           else if (d1 > d2)
	               return 1;
	           else return 0;
	       }
	   }
	

	   /**
   	 * packing two single SSEs using sparse NOE restraints.
   	 * 
   	 * 
   	 * 
   	 * @param argv the argv
   	 * 
   	 * @return ensemble of packed structures
   	 * 
   	 * @throws JampackException the jampack exception
   	 */  	   
	   
	   public static void SSEsOneToOnePacking(String[] argv) throws JampackException
	    {
	    	long startTime = System.currentTimeMillis();
	    	Hsqc hqc = new Hsqc();
	    	Peak pk = new Peak();
	    	
	    	ModelRdc mdc = new ModelRdc();    	
	    	Assign asg = new Assign();
	    	
	    	/////////////////////////////////////////////
	    	/// 1. Read the input files
	    	//
	    	/////////////////////////////////////////////
	    	int i, j;
	    	//String src   = "../inputFiles/"; //The directory has the input files
	    	Pdb  pp = new Pdb();
	    	String userDir = System.getProperty("user.dir");////
	    	String src=userDir+"/inputFiles/";
	    	String paramFile=src+"parameters.input";
	    	Vector<Map<String, String>> paraVec = asg.ParamReader(paramFile);
	    	double haErr  = 0.0;
	    	double h1Err  = 0.0;
	    	double c13Err = 0.0;
	    	double hnErr  = 0.0;
	    	double nErr   = 0.0;
	    	double noeBound=0.0;
	    	String strSeq="", strBB="", strReson="", strNoesy2D="", strHnNoesy3D="", 
	    		strHaNoesy3D="",strManualAsg="", strSSES="";
	    	for (i=0;i<paraVec.size();i++)
	    	{
	    		//get the error torlence for each dimension
	    		Map paraMap = paraVec.elementAt(i);
	    		if(paraMap.containsKey("HAERR"))
	    			 haErr  =  Double.parseDouble((String)paraMap.get("HAERR"));
	    		if(paraMap.containsKey("H1ERR"))
	   			 	h1Err  =  Double.parseDouble((String)paraMap.get("H1ERR"));
	    		if(paraMap.containsKey("C13ERR"))
	    			c13Err  =  Double.parseDouble((String)paraMap.get("C13ERR"));
	    		if(paraMap.containsKey("HNERR"))
	    			hnErr  =  Double.parseDouble((String)paraMap.get("HNERR"));
	    		if(paraMap.containsKey("NERR"))
	    			nErr  =  Double.parseDouble((String)paraMap.get("NERR"));
	    		if(paraMap.containsKey("NOEBOUND"))
	    			noeBound  =  Double.parseDouble((String)paraMap.get("NOEBOUND"));
	    		
	    		//get the input file name
	    		if(paraMap.containsKey("SEQUENCE"))
	    			strSeq  =  (String)paraMap.get("SEQUENCE");
	    		strSeq=strSeq.toLowerCase();
	    		if(paraMap.containsKey("BACKBONE"))
	    			strBB  =  (String)paraMap.get("BACKBONE");
	    		//strBB=strBB.toLowerCase();
	    		if(paraMap.containsKey("RESONANCE"))
	    			strReson  =  (String)paraMap.get("RESONANCE");
	    		strReson=strReson.toLowerCase();
	    		if(paraMap.containsKey("2D-NOESY"))
	    			strNoesy2D  =  (String)paraMap.get("2D-NOESY");
	    		strNoesy2D=strNoesy2D.toLowerCase();
	    		if(paraMap.containsKey("3D-N15-NOESY"))
	    			strHnNoesy3D  =  (String)paraMap.get("3D-N15-NOESY");
	    		strHnNoesy3D=strHnNoesy3D.toLowerCase();
	    		if(paraMap.containsKey("3D-C13-NOESY"))
	    			strHaNoesy3D  =  (String)paraMap.get("3D-C13-NOESY");
	    		strHaNoesy3D=strHaNoesy3D.toLowerCase();
	    		if(paraMap.containsKey("MANUAL-ASSIGNMENT"))
	    			strManualAsg  =  (String)paraMap.get("MANUAL-ASSIGNMENT");
	    		strManualAsg=strManualAsg.toLowerCase();
	    		
	    		if(paraMap.containsKey("SSES"))
	    			strSSES  =  (String)paraMap.get("SSES");
	    		//strSSES=strSSES.toLowerCase();
	    		
	    	}   	
	    	   	   	
	    	//-------------------------------------
	    	// (1.1) Read the protein sequence
	    	// 
	    	//-------------------------------------
	    	//String seqFile = src+"cbf.seq";
	    	String seqFile = src + strSeq;
	    	//this is the vector of residues (protein sequence)
	    	Vector vecSeq=asg.ReaderSeq(seqFile);    	
	    	
	    	//-------------------------------------
	    	// (1.2) Read the backbone structure 
	    	// (input file name: backbone.pdb)
	    	// Note: the backbone must be connected. 
	    	//-------------------------------------	    	
	    	String pdbFile = src+strBB;
	    	
	    	//update backbone atom names according to protein sequence input
	    	//residue name in previous backbone may be all in "ALA".     		
	    	//Vector pdbVec3 = pp.residueNameUpdate(vecSeq, pdbVecBB);
	    	
	    	// this is final backbone pdb used for hosting rotamers
	    	//Vector pdbVecBBN = pp.nameConvert(pdbVec3);
	    	//Collections.sort(pdbVecBBN, new Pdb.PdbComparator());
	    	    	
	    	//-------------------------------------
	    	// (1.3) Read the resonance list 
	    	// 
	    	// in the "resonance.prot" format
	    	//-------------------------------------	    	   	
	    	
	    	//following is for the general case
	    	H1CS h1CS=new H1CS();
	    	  
	    	String assignFile = src+ strReson; //"resonance.prot"; 
	    	//this is the vector that stores resonance assignments;
	    	//each one includes resNo, resName, atomName, csH1(chemical shift value)
	    	Vector assignVec=h1CS.h1CSReader(assignFile,vecSeq);  //different input format
	    		    	
	    	//all sorted proton resonances
	    	Vector allH1Vec = pk.allProtonSorted(assignVec);
	    	Collections.sort(allH1Vec, new Peak.csComparator());
	    	    	
	    	//-------------------------------------
	    	// (1.4) Read the NOESY peak list 
	    	// in the xeasy format
	    	// including 2D NOESY peak list, 3D N15 NOESY and 3D C13 NOESY peak lists
	    	//-------------------------------------
	    	Noesy noesy = new Noesy();
	    	
	    	String strNoeFile = ""; 
	    	Vector hnNoeVec=new Vector();//for storing 3d n15 NOESY peaks
	    	Vector cnoeVec=new Vector();//for storing 3d c13 noesy peaks
	    	if (!strNoesy2D.equalsIgnoreCase("NULL"))
	    	{
	    		//to do: extension to 2d case...
	    	}
	    	if (!strHnNoesy3D.equalsIgnoreCase("NULL"))
	    	{
	    		strNoeFile=src+strHnNoesy3D;
	    		hnNoeVec = noesy.NoesyReaderNMRView(strNoeFile);    		
	    	}//if (!strNoesy3D.equalsIgnoreCase("NULL"))
	    	
	    	if (!strHaNoesy3D.equalsIgnoreCase("NULL"))
	    	{
	    		strNoeFile=src+strHaNoesy3D;
	    		cnoeVec=noesy.NoesyReaderNMRView(strNoeFile);
	    	}
	    	
	    	Vector vecNoesy=new Vector();
	    	vecNoesy.addAll(hnNoeVec);
	    	vecNoesy.addAll(cnoeVec);
	    	
	    	//intensity calibration
	    	Vector vecNewNoesy=noesy.SetCalibration(vecNoesy);    	
	    	
	    	
	    	//-------------------------------------
	    	// (1.4) Read the rotamer library path 
	    	// 
	    	// use the small Xtal' library from Richardson's lab
	    	//-------------------------------------
	    	String rotSrc=  src+ "rotasamp-small/";    	
	    	
	    	//-------------------------------------
	    	// (1.5) Read other input data, including
	    	// x-ray structure, manual noe assignment, 
	    	//full resonance assignment in BMRB, for checking completeness of assigned resoance list.
	    	// all are not used for NOE assignment, but for measuring the assignment performance
	    	//-------------------------------------
	    	String pdbFileXray = src+"1d3z.pdb";//"ff2_complete_43.pdb"; //"one-structure-pei-eta-2I5O.pdb";//"2A7O.pdb";   
	    	Vector vecTempPdbBB=pp.readPdb(pdbFileXray);
	    	Vector vecTempPdbBB2 = pp.nameConvert2PDBNew(vecTempPdbBB);
	    	pp.print(vecTempPdbBB2);
	    	
	    	Vector vecBB=pp.OutputBackbone(vecTempPdbBB);
	    	    	    	
	    	
	    	//debuggging:
	    	double[] vdwValue = new double[1];
	    	boolean hasVDW = false;
	    	double vdwLevel = 0.05;
	    	boolean printVDWViolation = false;
	    	vdw vander = new vdw();
	    	Vector vdwVec = new Vector();
	    	boolean[] resIndex=new boolean[vecTempPdbBB.size()];
	    	for (int kk=0;kk<resIndex.length;kk++)
	    		resIndex[kk]=false;
	    
	    	Vector vecPdbSseRot0=pp.AllRotamersStructure(vecTempPdbBB,rotSrc);	    		
   		
	    	Vector  ppVecTALA=pp.AlaninizeStructure(vecTempPdbBB,resIndex,rotSrc);
	    	Vector  ppVecTALA_all=pp.AlaninizeStructure(vecPdbSseRot0,resIndex,rotSrc);
			  
	    	
	    	System.out.println("jhere is pdb after all rotamers:");
	    	
	    	vdwVec = vander.convert2VDW(vecTempPdbBB2);
	    	boolean [] resClash=new boolean[140];
	    	
       		int numClashes=vander.countStericClash(vdwVec, vdwValue, vdwLevel, printVDWViolation, true,0.5);
       		int firstClash=0;
       		for (i=0;i<resClash.length;i++)
	       	{
	       		if (resClash[i])
	       		{
	       			firstClash=i;
	       			break;
	       		}
	       	}
       
	    	System.out.println("the number of steric clashes: "+ numClashes);
	    	
	    	pp.print(vecBB);
	    	System.out.println("TER"); 
	    	Vector temp1vec = pp.newPdb(vecBB, Const.mat4ThreeDirs[0]);
	    	pp.print(temp1vec);	    	
	    	System.out.println("TER"); 
	    	 temp1vec = pp.newPdb(vecBB, Const.mat4ThreeDirs[1]);
	    	 pp.print(temp1vec);	 
	    	 System.out.println("TER"); 
	    	 temp1vec = pp.newPdb(vecBB, Const.mat4ThreeDirs[2]);
	    	pp.print(temp1vec);	 
	    	 System.out.println("TER"); 
	    	
	    	// read the NOE assignment table from cyana
	    	String manualAsgFile = src+ strManualAsg;//"noe-H123.txt";//strManualAsg; //"resonance.prot";  
	    	Noe noe_temp=new Noe();
	    	
	    	//read from cyana (namely upl) format:
	    	Vector vecManAsg=noe_temp.LongRangeNoeReader(manualAsgFile,-3,"PDB-NEW");
	    	Vector vecManAsgNew=new Vector ();
	    	vecManAsgNew.addAll(vecManAsg);	    	
	    	
	    	// -------------------------------------
	    	// (1.6) get the order of secondary 
	    	//       structure elements
	    	// 
	    	//-------------------------------------
	    	//read the order of sse packing
	    	Vector vecOrderSSES=asg.getOrder(strSSES);
	    	
	    	//read the pdb file of each sse
	    	Vector vecPdbSSE=new Vector();
	    	for(i=0; i< vecOrderSSES.size();i++)
	    	{
	    		String strPdbFile= (String)vecOrderSSES.elementAt(i);
	    		strPdbFile=src+strPdbFile+".pdb";
	    		Vector pdbVecSSE_temp = pp.readPdb(strPdbFile);

	        	//update backbone atom names according to protein sequence input
	        	//residue name in previous backbone may be all in "ALA".     		
	            Vector pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, pdbVecSSE_temp);
	        		        	
	    		
              Collections.sort(pdbVecSSE_temp2, new Pdb.PdbComparator());
	        	
	           vecPdbSSE.add(pdbVecSSE_temp);
	    		
	    	}//for(i=0; i< vecOrderSSES.size();i++)	
	    	
	    	
	    	/////////////////////////////////////////////////
	    	// 2. Rotamer selection at each individual SSE
	    	//
	    	/////////////////////////////////////////////////
	    	
	    	//	-------------------------------------
	    	// Rotamer selection at each idividual sse 
	    	// select optimal rotamer at each residue 
	    	// and place optimal rotamers into backbone
	    	// only based on NOE from rotamer to its corresponding sse
	    	//-------------------------------------
	    	//this structure is in BMRB-NEW format:
	    	Vector vecPdbRotSSE=new Vector();	    
	    	Model md=new Model();
	    	
	    	for(i=0;i<vecPdbSSE.size();i++)
	    	{
	    		Vector vecPdbSseBb=(Vector)vecPdbSSE.elementAt(i);
	    		
	    		//be careful of rotation, we can't change the orientation of each sse
	    		Vector vecPdbSseRot=pp.AllRotamersStructure(vecPdbSseBb,rotSrc);	    		
	    		
	    		//a function to rotate SSE back to the same coordinate system:
	    		Vector vecPdbSseRotNew=md.BackonbeRotation(vecPdbSseRot,vecPdbSseBb); 
	    		
	    		Collections.sort(vecPdbSseRotNew, new Pdb.PdbComparator());
	    		vecPdbRotSSE.add(vecPdbSseRotNew);
	    	}
	
	    	System.out.println("====================================");
	    	
	    	/////////////////////////////////////////////////
	    	// 3. assemble SSEs 
	    	//based on noe table
	    	//
	    	/////////////////////////////////////////////////
	    	Vector vecPdbA=new Vector();
	    	Vector vecPdbB =new Vector();
	    	
	    	vecPdbA.addAll((Vector)vecPdbRotSSE.elementAt(0));
	    	Collections.sort(vecPdbA, new Pdb.PdbComparator());
	    	PdbRmsd pdr=new PdbRmsd();
	    	double [] max_score=new double[4];
	    	Vector[] vecEnsembPack = new Vector[4];
	    	
	    	PdbRmsd psd = new PdbRmsd();
	     	double[] noeRmsd = new double[1];
	     	double[] noeRms  = new double[4];
	     	boolean debugNOE = true;	
	      	Vector[] ubqByRdcVec = new Vector[4];
	      	Vector[] vecNewNOE=new Vector[4];
	      	
	      	//we need to update the pseudo protons of NOEs
	      	Vector vecNoeUpdateOrder=noe_temp.UpdateNOE(vecManAsgNew,vecPdbSSE);
	      		      	
	      	//important: before binary search, the pdb must be sorted...
	      	//debug: check whether all proton names NOEs are in pdb; 
	      	Vector vecTemp=new Vector();
	      	Vector vecPdbTempA=new Vector();
	      	//Vector vecTTemp=(Vector)vecPdbRotSSE.elementAt(0);
	      	vecPdbTempA.addAll((Vector)vecPdbRotSSE.elementAt(0));
	      	for (int k=1;k<vecPdbRotSSE.size();k++)
	    	{
	      		Vector noeVec =new Vector();
		      	noeVec=(Vector)vecNoeUpdateOrder.elementAt(k-1);
		      	
		      	vecPdbB =new Vector();
	    		vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k));
	    	
	    		vecPdbTempA.addAll(vecPdbB);
	    		Collections.sort(vecPdbTempA, new Pdb.PdbComparator());
	    		
	    		boolean isTemp=noe_temp.CheckNoeHInPdb(noeVec,vecPdbTempA);
	    	}
	      	//Collections.sort(vecTemp, new Pdb.PdbComparator());	      	
	      	
	     	for (i = 0; i < 4; i++)
	     	{
	     	    ubqByRdcVec[i] = new Vector<Pdb>();
	     	    vecNewNOE[i]=new Vector<Noe>();
	     	}
	    	Vector vecVecNewNOE=new Vector ();//new noe vectors after fileter bad noes
	    		    	
	    	Vector vecTempBB=new Vector ();	
	       
	     	for (int t=70;t<=90;t++)
	    	{
	       		vecPdbA=new Vector();
	    		
	    		String strEnsemPdb=src+"FF2H1H3Final"+t+".pdb";
	    		String strPass="FF2H13H2New"+t+"00";
	    		System.out.println("**********************input: "+strEnsemPdb);
	    		
	    		Vector vecPdbABB=pp.readPdb(strEnsemPdb);
	    		Vector vecPdbATEmp=pp.AllRotamersStructure(vecPdbABB,rotSrc);	    		
	    		
	    		//a function to rotate SSE back to the same coordinate system:
	    		vecPdbA=md.BackonbeRotation(vecPdbATEmp,vecPdbABB); 
	    	
		    	
	    	
	    	for (int k=1;k<vecPdbRotSSE.size();k++)
	    	{
	    		double[] dbTemp=new double[1];
	    		vecPdbB =new Vector();
	    		vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k));
	    		Vector<Pdb> helixVecN = new Vector<Pdb>();
	    		
	    		Vector noeVec =new Vector();
		      	noeVec.addAll((Vector)vecNoeUpdateOrder.elementAt(k-1));
	    		noe_temp.PrintNOE(noeVec);
		 	
	    		i=2;
	    	 	   helixVecN = pp.newPdb(vecPdbA, Const.mat4ThreeDirs[i - 1]);
	    	 	    ubqByRdcVec[i] = psd.positionByNOEAllRotamers(noeVec, helixVecN, vecPdbB, noeRmsd, debugNOE,vecNewNOE[i],strPass,vecSeq,0.8);
	    	 	    noeRms[i] = noeRmsd[0];
	    	 	  
	    	 	    vecTempBB=pp.OutputBackbone(ubqByRdcVec[i]);
	    	 	    pp.print(vecTempBB);
		         	System.out.println("TER");
		         	System.out.println("END"); 
		       
	    	 
		      
	    	
	    	}//for (i=0;i<vecPdbSSE.size();i++)
	    	
	    	
	    	
	    	 //////////////////////////
	    	}
	       //////////////////////////	
	       	
	       	
	       	
	        long endTime = System.currentTimeMillis() ;
			double totalTime = (double) ((endTime - startTime) / 60000.0); //in minutes
			System.out.println("Time= "+ totalTime +" minutes");	    
	    }
	   
	   
	   //we first place rotamer into each helix backbone based on NOE patterns
	   //then we output all packings that have NOE rmsd less than some threshold
	   /**
   	 * Packing helices based on noe patterns. This function is still under developing.
   	 * 
   	 * @param argv the argv
   	 * 
   	 * @throws JampackException the jampack exception
   	 */
   	public static void PackingHelicesBasedOnNOEPatterns(String[] argv) throws JampackException
	    {
	    	long startTime = System.currentTimeMillis();
	    	Hsqc hqc = new Hsqc();
	    	Peak pk = new Peak();
	    	
	    	ModelRdc mdc = new ModelRdc();    	
	    	Assign asg = new Assign();
	    	
	    	/////////////////////////////////////////////
	    	/// 1. Read the input files
	    	//
	    	/////////////////////////////////////////////
	    	int i, j;
	    	//String src   = "../inputFiles/"; //The directory has the input files
	    	Pdb  pp = new Pdb();
	    	String userDir = System.getProperty("user.dir");////
	    	String src=userDir+"/inputFiles/";
	    	String paramFile=src+"parameters.input";
	    	Vector<Map<String, String>> paraVec = asg.ParamReader(paramFile);
	    	double haErr  = 0.0;
	    	double h1Err  = 0.0;
	    	double c13Err = 0.0;
	    	double hnErr  = 0.0;
	    	double nErr   = 0.0;
	    	double noeBound=0.0;
	    	String strSeq="", strBB="", strReson="", strNoesy2D="", strHnNoesy3D="", 
	    		strHaNoesy3D="",strManualAsg="", strSSES="";
	    	for (i=0;i<paraVec.size();i++)
	    	{
	    		//get the error torlence for each dimension
	    		Map paraMap = paraVec.elementAt(i);
	    		if(paraMap.containsKey("HAERR"))
	    			 haErr  =  Double.parseDouble((String)paraMap.get("HAERR"));
	    		if(paraMap.containsKey("H1ERR"))
	   			 	h1Err  =  Double.parseDouble((String)paraMap.get("H1ERR"));
	    		if(paraMap.containsKey("C13ERR"))
	    			c13Err  =  Double.parseDouble((String)paraMap.get("C13ERR"));
	    		if(paraMap.containsKey("HNERR"))
	    			hnErr  =  Double.parseDouble((String)paraMap.get("HNERR"));
	    		if(paraMap.containsKey("NERR"))
	    			nErr  =  Double.parseDouble((String)paraMap.get("NERR"));
	    		if(paraMap.containsKey("NOEBOUND"))
	    			noeBound  =  Double.parseDouble((String)paraMap.get("NOEBOUND"));
	    		
	    		//get the input file name
	    		if(paraMap.containsKey("SEQUENCE"))
	    			strSeq  =  (String)paraMap.get("SEQUENCE");
	    		strSeq=strSeq.toLowerCase();
	    		if(paraMap.containsKey("BACKBONE"))
	    			strBB  =  (String)paraMap.get("BACKBONE");
	    		//strBB=strBB.toLowerCase();
	    		if(paraMap.containsKey("RESONANCE"))
	    			strReson  =  (String)paraMap.get("RESONANCE");
	    		strReson=strReson.toLowerCase();
	    		if(paraMap.containsKey("2D-NOESY"))
	    			strNoesy2D  =  (String)paraMap.get("2D-NOESY");
	    		strNoesy2D=strNoesy2D.toLowerCase();
	    		if(paraMap.containsKey("3D-N15-NOESY"))
	    			strHnNoesy3D  =  (String)paraMap.get("3D-N15-NOESY");
	    		strHnNoesy3D=strHnNoesy3D.toLowerCase();
	    		if(paraMap.containsKey("3D-C13-NOESY"))
	    			strHaNoesy3D  =  (String)paraMap.get("3D-C13-NOESY");
	    		strHaNoesy3D=strHaNoesy3D.toLowerCase();
	    		if(paraMap.containsKey("MANUAL-ASSIGNMENT"))
	    			strManualAsg  =  (String)paraMap.get("MANUAL-ASSIGNMENT");
	    		strManualAsg=strManualAsg.toLowerCase();
	    		
	    		if(paraMap.containsKey("SSES"))
	    			strSSES  =  (String)paraMap.get("SSES");
	    		//strSSES=strSSES.toLowerCase();
	    		
	    	}   	
	    	   	   	
	    	//-------------------------------------
	    	// (1.1) Read the protein sequence
	    	// 
	    	//-------------------------------------
	    	//String seqFile = src+"cbf.seq";
	    	String seqFile = src + strSeq;
	    	//this is the vector of residues (protein sequence)
	    	Vector vecSeq=asg.ReaderSeq(seqFile);    	
	    	
	    	//-------------------------------------
	    	// (1.2) Read the backbone structure 
	    	// (input file name: backbone.pdb)
	    	// Note: the backbone must be connected. 
	    	//-------------------------------------
	    	//String pdbFile = src+"backbone.pdb"; 
	    	String pdbFile = src+strBB;
	    	//Vector pdbVecBB = pp.readPdb(pdbFile);

	    	//update backbone atom names according to protein sequence input
	    	//residue name in previous backbone may be all in "ALA".     		
	    	//Vector pdbVec3 = pp.residueNameUpdate(vecSeq, pdbVecBB);
	    	
	    	// this is final backbone pdb used for hosting rotamers
	    	//Vector pdbVecBBN = pp.nameConvert(pdbVec3);
	    	//Collections.sort(pdbVecBBN, new Pdb.PdbComparator());
	    	    	
	    	//-------------------------------------
	    	// (1.3) Read the resonance list 
	    	// 
	    	// in the "resonance.prot" format
	    	//-------------------------------------
	    	   	
	    	//**this is for ubq assignment table assigned by Lincong**//
	    	 /*	String assignFileUbq = src+"assignByMe.txt";
	    	Vector assignVecUbq  = asg.asgReader3(assignFileUbq); */
	    	
	    	//following is for the general case
	    	H1CS h1CS=new H1CS();
	    	//String assignFile = src+ "resonance.prot";    
	    	String assignFile = src+ strReson; //"resonance.prot"; 
	    	//this is the vector that stores resonance assignments;
	    	//each one includes resNo, resName, atomName, csH1(chemical shift value)
	    	Vector assignVec=h1CS.h1CSReader(assignFile,vecSeq);  //different input format
	    	//Vector assignVec=h1CS.h1CSReader_BMRB(assignFile);  
	    	
	    	//all sorted proton resonances
	    	Vector allH1Vec = pk.allProtonSorted(assignVec);
	    	Collections.sort(allH1Vec, new Peak.csComparator());
	    	    	
	    	//-------------------------------------
	    	// (1.4) Read the NOESY peak list 
	    	// in the xeasy format
	    	// including 2D NOESY peak list, 3D N15 NOESY and 3D C13 NOESY peak lists
	    	//-------------------------------------
	    	Noesy noesy = new Noesy();
	    	
	    	String strNoeFile = ""; 
	    	Vector hnNoeVec=new Vector();//for storing 3d n15 NOESY peaks
	    	Vector cnoeVec=new Vector();//for storing 3d c13 noesy peaks
	    	if (!strNoesy2D.equalsIgnoreCase("NULL"))
	    	{
	    		//to do: extension to 2d case...
	    	}
	    	if (!strHnNoesy3D.equalsIgnoreCase("NULL"))
	    	{
	    		strNoeFile=src+strHnNoesy3D;
	    		hnNoeVec = noesy.NoesyReader(strNoeFile);    		
	    	}//if (!strNoesy3D.equalsIgnoreCase("NULL"))
	    	
	    	if (!strHaNoesy3D.equalsIgnoreCase("NULL"))
	    	{
	    		strNoeFile=src+strHaNoesy3D;
	    		cnoeVec=noesy.NoesyReader(strNoeFile);
	    	}
	    	
	    	Vector vecNoesy=new Vector();
	    	vecNoesy.addAll(hnNoeVec);
	    	vecNoesy.addAll(cnoeVec);
	    	
	    	//intensity calibration
	    	Vector vecNewNoesy=noesy.SetCalibration(vecNoesy);    	
	    	
	    	/*    	    	
	    	String cnoeFile2 = src+"cnoeManual.txt";   //the C13NOESY peaklist by Lincong
	    	Vector cnoeVec5  =  hcch.hcchReader4(cnoeFile2);
	    	String hnNoeFile = src+"ubqNoeManualPeak.txt"; //edited NOE pk list w/o repeat.
	    	//Vector hnNoeVec = hnNoe.hnNoeReader2(hnNoeFile);*/
	    	/*   	
	    	Collections.sort(hnNoeVec, new HnNoe.n15Comparator());
	     	Vector oneHnVec = new Vector();
	     	Vector oneHaVec = new Vector();
	     	Vector oneH1Vec = new Vector();
	    	Vector assignVec2 = asg.mergeAssignAndNoe(assignVec, hnNoeVec, 
	    						  cnoeVec5, hnErr, nErr, haErr, c13Err);
	    	Collections.sort(assignVec2, new Assign.assignComparator());*/

	    	//-------------------------------------
	    	// (1.4) Read the rotamer library path 
	    	// 
	    	// use the small Xtal' library from Richardson's lab
	    	//-------------------------------------
	    	String rotSrc=  src+ "rotasamp-small/";    	
	    	
	    	//-------------------------------------
	    	// (1.5) Read other input data, including
	    	// x-ray structure, manual noe assignment, 
	    	//full resonance assignment in BMRB, for checking completeness of assigned resoance list.
	    	// all are not used for NOE assignment, but for measuring the assignment performance
	    	//-------------------------------------
	    	String pdbFileXray = src+"H3.pdb"; //"one-structure-pei-eta-2I5O.pdb";//"2A7O.pdb";   
	    	Vector vecTempPdbBB=pp.readPdb(pdbFileXray);
	    	Vector vecTempPdbBB2 = pp.nameConvert(vecTempPdbBB);
	    	Vector vecBB=pp.OutputBackbone(vecTempPdbBB2);
	    	//pp.print(vecBB);    	
	    	
	    	
	    	//Vector pdbVec2  = pp.readPdb(pdbFileXray);
	    	// this is the X-ray backbone structure
	    	//Vector pdbVecXrayBB = pp.nameConvert(pdbVec2);
	    	
	    	// read the NOE assignment table from cyana
	    	String manualAsgFile = src+ strManualAsg;//"noe-H123.txt";//strManualAsg; //"resonance.prot";  
	    	Noe noe_temp=new Noe();
	    	Vector vecManAsg=noe_temp.LongRangeNoeReader(manualAsgFile,0.0,"PDB-NEW");//noe_temp.noeReader(manualAsgFile);
	    	
	    	//Vector vecManAsg=noe_temp.noeReader(manualAsgFile);

	    	// -------------------------------------
	    	// (1.6) get the order of secondary 
	    	//       structure elements
	    	// 
	    	//-------------------------------------
	    	//read the order of sse packing
	    	Vector vecOrderSSES=asg.getOrder(strSSES);
	    	
	    	//read the pdb file of each sse
	    	Vector vecPdbSSE=new Vector();
	    	for(i=0; i< vecOrderSSES.size();i++)
	    	{
	    		String strPdbFile= (String)vecOrderSSES.elementAt(i);
	    		strPdbFile=src+strPdbFile+".pdb";
	    		Vector pdbVecSSE_temp = pp.readPdb(strPdbFile);

	        	//update backbone atom names according to protein sequence input
	        	//residue name in previous backbone may be all in "ALA".     		
	        	Vector pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, pdbVecSSE_temp);
	        	
	        	// this is final backbone pdb used for hosting rotamers
	        	Vector pdbVecSSE = pp.nameConvert(pdbVecSSE_temp2);
	        	Collections.sort(pdbVecSSE, new Pdb.PdbComparator());
	        	
	        	vecPdbSSE.add(pdbVecSSE);
	    		
	    	}//for(i=0; i< vecOrderSSES.size();i++)	
	    	
	    	//String manualAsgFile = src+ strManualAsg; //"resonance.prot";  
	    	//Noe noe_temp=new Noe();
	    	//Vector vecManAsg=noe_temp.noeReader(manualAsgFile);
	    	/////////////////////////////////////////////////
	    	// 2. Rotamer selection at each individual SSE
	    	//
	    	/////////////////////////////////////////////////
	    	
	    	//	-------------------------------------
	    	// Rotamer selection at each idividual sse 
	    	// select optimal rotamer at each residue 
	    	// and place optimal rotamers into backbone
	    	// only based on NOE from rotamer to its corresponding sse
	    	//-------------------------------------
	    	//this structure is in BMRB-NEW format:
	    	Vector vecPdbRotSSE=new Vector();
	    	Model md=new Model();
	    	for(i=0;i<vecPdbSSE.size();i++)
	    	{
	    		Vector vecPdbSseBb=(Vector)vecPdbSSE.elementAt(i);
	    		//pp.print(vecPdbSseBb);
	    		
	    		//be careful of rotation, we can't change the orientation of each sse
	    		Vector vecPdbSseRot=new Vector();
	    		//if (i==0)	   
//	    		note: need to be fixed...
	    		vecPdbSseRot=pp.RotamSelectAndStructure(2*h1Err, 2*nErr, 2*c13Err,vecPdbSseBb,assignVec,rotSrc,vecNewNoesy,noeBound, 1,0.0);
	    		//else
	    		//	vecPdbSseRot=pp.AllRotamersStructure(vecPdbSseBb,rotSrc);
	    		
	    		//pp.print(vecPdbSseRot);
	    		
	    		//a function to rotate SSE back to the same coordinate system:
	    		Vector vecPdbSseRotNew=md.BackonbeRotation(vecPdbSseRot,vecPdbSseBb); 

	        	//debugging:
	        	//pp.print(vecPdbSseRotNew);
	    		Collections.sort(vecPdbSseRotNew, new Pdb.PdbComparator());
	    		vecPdbRotSSE.add(vecPdbSseRotNew);
	    	}
	    	
	    	System.out.println("====================================");
	    	
	    	/////////////////////////////////////////////////
	    	// 3. Use Lincong's algorithm to assemble sse 
	    	//based on noe table
	    	//
	    	/////////////////////////////////////////////////
	    	Vector vecPdbA=new Vector();
	    	Vector vecPdbB =new Vector();
	    	
	    	vecPdbA.addAll((Vector)vecPdbRotSSE.elementAt(0));
	    	Collections.sort(vecPdbA, new Pdb.PdbComparator());
	    	PdbRmsd pdr=new PdbRmsd();
	    	double [] max_score=new double[4];
	    	Vector[] vecEnsembPack = new Vector[4];
	    	
	    	PdbRmsd psd = new PdbRmsd();
	     	double[] noeRmsd = new double[1];
	     	double[] noeRms  = new double[4];
	     	boolean debugNOE = true;	
	      	Vector[] ubqByRdcVec = new Vector[4];
	      	Vector[] vecNewNOE=new Vector[4];
	      	
	      	//we need to update the pseudo protons of NOEs
	      	Vector vecNoeUpdateOrder=noe_temp.UpdateNOE(vecManAsg,vecPdbSSE);
	      	//Vector noeVec =new Vector();
	      	//noeVec.addAll(vecNoeUpdate);
	      	
	      	//important: before binary search, the pdb must be sorted...
	      	//debug: check whether all proton names NOEs are in pdb; 
	      	Vector vecTemp=new Vector();
	      	Vector vecPdbTempA=new Vector();
	      	//Vector vecTTemp=(Vector)vecPdbRotSSE.elementAt(0);
	      	vecPdbTempA.addAll((Vector)vecPdbRotSSE.elementAt(0));
	      	for (int k=1;k<vecPdbRotSSE.size();k++)
	    	{
	      		Vector noeVec =new Vector();
		      	noeVec=(Vector)vecNoeUpdateOrder.elementAt(k-1);
		      	
		      	vecPdbB =new Vector();
	    		vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k));
	    		//vecTemp.addAll(vecPdbB);	
	    		vecPdbTempA.addAll(vecPdbB);
	    		Collections.sort(vecPdbTempA, new Pdb.PdbComparator());
	    		
	    		boolean isTemp=noe_temp.CheckNoeHInPdb(noeVec,vecPdbTempA);
	    	}
	      	//Collections.sort(vecTemp, new Pdb.PdbComparator());
	      	
	      	
	     	for (i = 0; i < 4; i++)
	     	{
	     	    ubqByRdcVec[i] = new Vector<Pdb>();
	     	    vecNewNOE[i]=new Vector<Noe>();
	     	}
	    	Vector vecVecNewNOE=new Vector ();//new noe vectors after fileter bad noes
	    	
	    	//////////////////////////////
	    	/*String pdbFileH1 = src+"hsriH1.pdb"; // 
	    	Vector vecHsriH1=pp.readPdb(pdbFileH1);
	    	Vector vecHsriH1New = pp.nameConvert(vecHsriH1);
	    	String pdbFileH3 = src+"hsriH3.pdb"; // 
	    	Vector vecHsriH3=pp.readPdb(pdbFileH3);
	    	Vector vecHsriH3New = pp.nameConvert(vecHsriH3);
	    	///////////////////////////////*/
	    	Vector vecTempBB=new Vector ();
	    	
	    	
	    	for (int k=1;k<vecPdbRotSSE.size();k++)
	    	{
	    		double[] dbTemp=new double[1];
	    		vecPdbB =new Vector();
	    		vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k));
	    		Vector<Pdb> helixVecN = new Vector<Pdb>();
	    		
	    		Vector noeVec =new Vector();
		      	noeVec.addAll((Vector)vecNoeUpdateOrder.elementAt(k-1));
	    		noe_temp.PrintNOE(noeVec);
		      	
	    	
	    		noeRms[0] = noeRmsd[0];
	    	 	//for (i = 1; i < 4; i++)
	    	 	//{	    	 		
	    		i=1;
	    	 	    helixVecN = pp.newPdb(vecPdbA, Const.mat4ThreeDirs[i - 1]);
	    	 	    ubqByRdcVec[i] = psd.positionByNOE(noeVec, helixVecN, vecPdbB, noeRmsd, debugNOE,vecNewNOE[i]);
	    	 	    noeRms[i] = noeRmsd[0];
	    	 	  
	    	 	    vecTempBB=pp.OutputBackboneNoCB(ubqByRdcVec[i]);
	    	 	    pp.print(vecTempBB);
		         	System.out.println("TER");
		         	System.out.println("END"); 
		  
	    	}//for (i=0;i<vecPdbSSE.size();i++)
	    	
	    	
        
	
			long endTime = System.currentTimeMillis() ;
			double totalTime = (double) ((endTime - startTime) / 60000.0); //in minutes
			System.out.println("Time= "+ totalTime +" minutes");	    
	    }

       // here we consider new packing scheme based on noe table from Jeffrey
	   //we consider all rotamers at each residue
	   /**
        * Main function for testing.
        * 
        * @param argv the argv
        * 
        * @throws JampackException the jampack exception
        */
       public static void main1(String[] argv) throws JampackException
	    {
	    	long startTime = System.currentTimeMillis();
	    	Hsqc hqc = new Hsqc();
	    	Peak pk = new Peak();
	    	
	    	ModelRdc mdc = new ModelRdc();    	
	    	Assign asg = new Assign();
	    	
	    	/////////////////////////////////////////////
	    	/// 1. Read the input files
	    	//
	    	/////////////////////////////////////////////
	    	int i, j;
	    	//String src   = "../inputFiles/"; //The directory has the input files
	    	Pdb  pp = new Pdb();
	    	String userDir = System.getProperty("user.dir");////
	    	String src=userDir+"/inputFiles/";
	    	String paramFile=src+"parameters.input";
	    	Vector<Map<String, String>> paraVec = asg.ParamReader(paramFile);
	    	double haErr  = 0.0;
	    	double h1Err  = 0.0;
	    	double c13Err = 0.0;
	    	double hnErr  = 0.0;
	    	double nErr   = 0.0;
	    	double noeBound=0.0;
	    	String strSeq="", strBB="", strReson="", strNoesy2D="", strHnNoesy3D="", 
	    		strHaNoesy3D="",strManualAsg="", strSSES="";
	    	for (i=0;i<paraVec.size();i++)
	    	{
	    		//get the error torlence for each dimension
	    		Map paraMap = paraVec.elementAt(i);
	    		if(paraMap.containsKey("HAERR"))
	    			 haErr  =  Double.parseDouble((String)paraMap.get("HAERR"));
	    		if(paraMap.containsKey("H1ERR"))
	   			 	h1Err  =  Double.parseDouble((String)paraMap.get("H1ERR"));
	    		if(paraMap.containsKey("C13ERR"))
	    			c13Err  =  Double.parseDouble((String)paraMap.get("C13ERR"));
	    		if(paraMap.containsKey("HNERR"))
	    			hnErr  =  Double.parseDouble((String)paraMap.get("HNERR"));
	    		if(paraMap.containsKey("NERR"))
	    			nErr  =  Double.parseDouble((String)paraMap.get("NERR"));
	    		if(paraMap.containsKey("NOEBOUND"))
	    			noeBound  =  Double.parseDouble((String)paraMap.get("NOEBOUND"));
	    		
	    		//get the input file name
	    		if(paraMap.containsKey("SEQUENCE"))
	    			strSeq  =  (String)paraMap.get("SEQUENCE");
	    		strSeq=strSeq.toLowerCase();
	    		if(paraMap.containsKey("BACKBONE"))
	    			strBB  =  (String)paraMap.get("BACKBONE");
	    		strBB=strBB.toLowerCase();
	    		if(paraMap.containsKey("RESONANCE"))
	    			strReson  =  (String)paraMap.get("RESONANCE");
	    		strReson=strReson.toLowerCase();
	    		if(paraMap.containsKey("2D-NOESY"))
	    			strNoesy2D  =  (String)paraMap.get("2D-NOESY");
	    		strNoesy2D=strNoesy2D.toLowerCase();
	    		if(paraMap.containsKey("3D-N15-NOESY"))
	    			strHnNoesy3D  =  (String)paraMap.get("3D-N15-NOESY");
	    		strHnNoesy3D=strHnNoesy3D.toLowerCase();
	    		if(paraMap.containsKey("3D-C13-NOESY"))
	    			strHaNoesy3D  =  (String)paraMap.get("3D-C13-NOESY");
	    		strHaNoesy3D=strHaNoesy3D.toLowerCase();
	    		if(paraMap.containsKey("MANUAL-ASSIGNMENT"))
	    			strManualAsg  =  (String)paraMap.get("MANUAL-ASSIGNMENT");
	    		strManualAsg=strManualAsg.toLowerCase();
	    		
	    		if(paraMap.containsKey("SSES"))
	    			strSSES  =  (String)paraMap.get("SSES");
	    		
	    	}   	
	    	   	   	
	    	//-------------------------------------
	    	// (1.1) Read the protein sequence
	    	// 
	    	//-------------------------------------
	    	//String seqFile = src+"cbf.seq";
	    	String seqFile = src + strSeq;
	    	//this is the vector of residues (protein sequence)
	    	Vector vecSeq=asg.ReaderSeq(seqFile);    	
	    	
	    	//-------------------------------------
	    	// (1.2) Read the backbone structure 
	    	// (input file name: backbone.pdb)
	    	// Note: the backbone must be connected. 
	    	//-------------------------------------
	    	//String pdbFile = src+"backbone.pdb"; 
	    	String pdbFile = src+strBB;
	    	Vector pdbVecBB = pp.readPdb(pdbFile);

	    	//update backbone atom names according to protein sequence input
	    	//residue name in previous backbone may be all in "ALA".     		
	    	Vector pdbVec3 = pp.residueNameUpdate(vecSeq, pdbVecBB);
	    	
	    	// this is final backbone pdb used for hosting rotamers
	    	Vector pdbVecBBN = pp.nameConvert(pdbVec3);
	    	Collections.sort(pdbVecBBN, new Pdb.PdbComparator());
	    	    	
	    	//-------------------------------------
	    	// (1.3) Read the resonance list 
	    	// 
	    	// in the "resonance.prot" format
	    	//-------------------------------------
	    	   	
	    	//**this is for ubq assignment table assigned by Lincong**//
	    	 /*	String assignFileUbq = src+"assignByMe.txt";
	    	Vector assignVecUbq  = asg.asgReader3(assignFileUbq); */
	    	
	    	//following is for the general case
	    	H1CS h1CS=new H1CS();
	    	//String assignFile = src+ "resonance.prot";    
	    	String assignFile = src+ strReson; //"resonance.prot"; 
	    	//this is the vector that stores resonance assignments;
	    	//each one includes resNo, resName, atomName, csH1(chemical shift value)
	    	Vector assignVec=h1CS.h1CSReader(assignFile,vecSeq);  //different input format
	    	//Vector assignVec=h1CS.h1CSReader_BMRB(assignFile);  
	    	
	    	//all sorted proton resonances
	    	Vector allH1Vec = pk.allProtonSorted(assignVec);
	    	Collections.sort(allH1Vec, new Peak.csComparator());
	    	    	
	    	//-------------------------------------
	    	// (1.4) Read the NOESY peak list 
	    	// in the xeasy format
	    	// including 2D NOESY peak list, 3D N15 NOESY and 3D C13 NOESY peak lists
	    	//-------------------------------------
	    	Noesy noesy = new Noesy();
	    	
	    	String strNoeFile = ""; 
	    	Vector hnNoeVec=new Vector();//for storing 3d n15 NOESY peaks
	    	Vector cnoeVec=new Vector();//for storing 3d c13 noesy peaks
	    	if (!strNoesy2D.equalsIgnoreCase("NULL"))
	    	{
	    		//to do: extension to 2d case...
	    	}
	    	if (!strHnNoesy3D.equalsIgnoreCase("NULL"))
	    	{
	    		strNoeFile=src+strHnNoesy3D;
	    		hnNoeVec = noesy.NoesyReader(strNoeFile);    		
	    	}//if (!strNoesy3D.equalsIgnoreCase("NULL"))
	    	
	    	if (!strHaNoesy3D.equalsIgnoreCase("NULL"))
	    	{
	    		strNoeFile=src+strHaNoesy3D;
	    		cnoeVec=noesy.NoesyReader(strNoeFile);
	    	}
	    	
	    	Vector vecNoesy=new Vector();
	    	vecNoesy.addAll(hnNoeVec);
	    	vecNoesy.addAll(cnoeVec);
	    	
	    	//intensity calibration
	    	Vector vecNewNoesy=noesy.SetCalibration(vecNoesy);    	
	    		    

	    	//-------------------------------------
	    	// (1.4) Read the rotamer library path 
	    	// 
	    	// use the small Xtal' library from Richardson's lab
	    	//-------------------------------------
	    	String rotSrc=  src+ "rotasamp-small/";    	
	    	
	    	//-------------------------------------
	    	// (1.5) Read other input data, including
	    	// x-ray structure, manual noe assignment, 
	    	//full resonance assignment in BMRB, for checking completeness of assigned resoance list.
	    	// all are not used for NOE assignment, but for measuring the assignment performance
	    	//-------------------------------------
	    	String pdbFileXray = src+"2A7O.pdb"; //"one-structure-pei-eta-2I5O.pdb";//"2A7O.pdb";   
	    	Vector vecTempPdbBB=pp.readPdb(pdbFileXray);
	    	Vector vecTempPdbBB2 = pp.nameConvert(vecTempPdbBB);
	    	Vector vecBB=pp.OutputBackbone(vecTempPdbBB2);
	    	//pp.print(vecBB);
	    	
	    	//Vector pdbVec2  = pp.readPdb(pdbFileXray);
	    	// this is the X-ray backbone structure
	    	//Vector pdbVecXrayBB = pp.nameConvert(pdbVec2);
	    	
	    	// read the NOE assignment table from cyana
	    	String manualAsgFile = src+ strManualAsg;//"noe-H123.txt";//strManualAsg; //"resonance.prot";  
	    	Noe noe_temp=new Noe();
	    	Vector vecManAsg=noe_temp.LongRangeNoeReader(manualAsgFile,0.0,"PDB-NEW");//noe_temp.noeReader(manualAsgFile);
	    	

	    	// -------------------------------------
	    	// (1.6) get the order of secondary 
	    	//       structure elements
	    	// 
	    	//-------------------------------------
	    	//read the order of sse packing
	    	Vector vecOrderSSES=asg.getOrder(strSSES);
	    	
	    	//read the pdb file of each sse
	    	Vector vecPdbSSE=new Vector();
	    	for(i=0; i< vecOrderSSES.size();i++)
	    	{
	    		String strPdbFile= (String)vecOrderSSES.elementAt(i);
	    		strPdbFile=src+strPdbFile+".pdb";
	    		Vector pdbVecSSE_temp = pp.readPdb(strPdbFile);

	        	//update backbone atom names according to protein sequence input
	        	//residue name in previous backbone may be all in "ALA".     		
	        	Vector pdbVecSSE_temp2 = pp.residueNameUpdate(vecSeq, pdbVecSSE_temp);
	        	
	        	// this is final backbone pdb used for hosting rotamers
	        	Vector pdbVecSSE = pp.nameConvert(pdbVecSSE_temp2);
	        	Collections.sort(pdbVecSSE, new Pdb.PdbComparator());
	        	
	        	vecPdbSSE.add(pdbVecSSE);
	    		
	    	}//for(i=0; i< vecOrderSSES.size();i++)	
	    	
	    	
	    	/////////////////////////////////////////////////
	    	// 2. place all Rotamers at each residue
	    	//
	    	/////////////////////////////////////////////////
	    	
	    	
	    	//this structure is in BMRB-NEW format:
	    	Vector vecPdbRotSSE=new Vector();
	    	Model md=new Model();
	    	for(i=0;i<vecPdbSSE.size();i++)
	    	{
	    		Vector vecPdbSseBb=(Vector)vecPdbSSE.elementAt(i);
	    		//pp.print(vecPdbSseBb);
	    		
	    		//be careful of rotation, we can't change the orientation of each sse
	    		Vector vecPdbSseRot=pp.AllRotamersStructure(vecPdbSseBb,rotSrc);
	    		//pp.print(vecPdbSseRot);
	    		
	    		//a function to rotate SSE back to the same coordinate system:
	    		Vector vecPdbSseRotNew=md.BackonbeRotation(vecPdbSseRot,vecPdbSseBb); 

	        	//debugging:
	        	//pp.print(vecPdbSseRotNew);
	    		Collections.sort(vecPdbSseRotNew, new Pdb.PdbComparator());
	    		vecPdbRotSSE.add(vecPdbSseRotNew);
	    	}
	    	
	    	System.out.println("====================================");
	    	
	    	/////////////////////////////////////////////////
	    	// 3. Use Lincong's algorithm to assemble sse 
	    	//based on noe table
	    	//
	    	/////////////////////////////////////////////////
	    	Vector vecPdbA=new Vector();
	    	Vector vecPdbB =new Vector();
	    	
	    	vecPdbA.addAll((Vector)vecPdbRotSSE.elementAt(0));
	    	Collections.sort(vecPdbA, new Pdb.PdbComparator());
	    	PdbRmsd pdr=new PdbRmsd();
	    	double [] max_score=new double[4];
	    	Vector[] vecEnsembPack = new Vector[4];
	    	
	    	PdbRmsd psd = new PdbRmsd();
	     	double[] noeRmsd = new double[1];
	     	double[] noeRms  = new double[4];
	     	boolean debugNOE = true;	
	      	Vector[] ubqByRdcVec = new Vector[4];
	      	Vector[] vecNewNOE=new Vector[4];
	      	
	      	//we need to update the pseudo protons of NOEs
	      	Vector vecNoeUpdateOrder=noe_temp.UpdateNOE(vecManAsg,vecPdbSSE);
	      	
	      	
	      	//important: before binary search, the pdb must be sorted...
	      	//debug: check whether all proton names NOEs are in pdb; 
	      	Vector vecTemp=new Vector();
	      	Vector vecPdbTempA=new Vector();
	      	//Vector vecTTemp=(Vector)vecPdbRotSSE.elementAt(0);
	      	vecPdbTempA.addAll((Vector)vecPdbRotSSE.elementAt(0));
	      	for (int k=1;k<vecPdbRotSSE.size();k++)
	    	{
	      		Vector noeVec =new Vector();
		      	noeVec=(Vector)vecNoeUpdateOrder.elementAt(k-1);
		      	
		      	vecPdbB =new Vector();
	    		vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k));
	    		//vecTemp.addAll(vecPdbB);	
	    		vecPdbTempA.addAll(vecPdbB);
	    		Collections.sort(vecPdbTempA, new Pdb.PdbComparator());
	    		
	    		boolean isTemp=noe_temp.CheckNoeHInPdb(noeVec,vecPdbTempA);
	    	}
	      	//Collections.sort(vecTemp, new Pdb.PdbComparator());
	      	
	      	
	     	for (i = 0; i < 4; i++)
	     	{
	     	    ubqByRdcVec[i] = new Vector<Pdb>();
	     	    vecNewNOE[i]=new Vector<Noe>();
	     	}
	    	Vector vecVecNewNOE=new Vector ();//new noe vectors after fileter bad noes
	    	
	    	Vector vecEnsembPackNew=new Vector();
	    	
	    	for (int k=1;k<vecPdbRotSSE.size();k++)
	    	{
	    		double[] dbTemp=new double[1];
	    		vecPdbB =new Vector();
	    		vecPdbB.addAll((Vector)vecPdbRotSSE.elementAt(k));
	    		Vector<Pdb> helixVecN = new Vector<Pdb>();
	    		
	    		Vector noeVec =new Vector();
		      	noeVec.addAll((Vector)vecNoeUpdateOrder.elementAt(k-1));
	    		noe_temp.PrintNOE(noeVec);
		      	
	    		Vector vecTempPackEnsem=new Vector();
	    		vecTempPackEnsem = psd.positionByNOENew(noeVec, vecPdbA, vecPdbB, noeRmsd, debugNOE,vecNewNOE[0]);
	    		vecEnsembPackNew.addAll(vecTempPackEnsem);
	    		
	    		//pp.print(ubqByRdcVec[0]);//debugging
	    		noeRms[0] = noeRmsd[0];
	    	 	for (i = 1; i < 4; i++)
	    	 	{	    	 		
	    	 		vecTempPackEnsem=new Vector();
	    	 	    helixVecN = pp.newPdb(vecPdbA, Const.mat4ThreeDirs[i - 1]);
	    	 	    vecTempPackEnsem = psd.positionByNOENew(noeVec, helixVecN, vecPdbB, noeRmsd, debugNOE,vecNewNOE[i]);
	    	 	    noeRms[i] = noeRmsd[0];
	    	 	    vecEnsembPackNew.addAll(vecTempPackEnsem);	    	 	
	    	 	}	  
	    	 	
	        	///////////////////////////////////
	        	vecTemp=(Vector)vecEnsembPackNew.elementAt(0);//need to change for each packing
	        	
	        	vecPdbA=new Vector();
	        	vecPdbA.addAll(vecTemp);
	        	
	        	Collections.sort(vecPdbA, new Pdb.PdbComparator());
	        	System.out.println("the i-th iteration packing"+ k);
	        	
	        	for (i=0;i<vecEnsembPackNew.size();i++)
	        	{
	        		Vector vecTempOne=(Vector)vecEnsembPackNew.elementAt(i);
	        		System.out.println("the ith structure in the ensemble:"+ i);
	    	    	pp.print(vecTempOne);
	    	    	System.out.println("TER");
	             	System.out.println("END");
	        	} 	
	    	 	 
	    	 	
	    	}//for (k=0;i<vecPdbSSE.size();k++)
	    		    	
	    	System.out.println("Here we have the final stucture...");
	    	for (i=0;i<vecEnsembPackNew.size();i++)
        	{
        		Vector vecTempOne=(Vector)vecEnsembPackNew.elementAt(i);
        		System.out.println("the ith structure in the ensemble:"+ i  );
    	    	pp.print(vecTempOne);
    	    	System.out.println("TER");
             	System.out.println("END");
             	
             	Vector vecFirstBB=pp.OutputBackbone(vecTempOne);
             	System.out.println("here we have the  Backbone:");
    	    	pp.print(vecFirstBB);
    	    	System.out.println("TER");
             	System.out.println("END");          	
             	
        	}
	    	
			long endTime = System.currentTimeMillis() ;
			double totalTime = (double) ((endTime - startTime) / 60000.0); //in minutes
			System.out.println("Time= "+ totalTime +" minutes");	    
	    }


}
