/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.kludge.window;

import cuchaz.kludge.window.GLFWKt;
import cuchaz.kludge.window.Monitor;
import cuchaz.kludge.window.Pos;
import cuchaz.kludge.window.Size;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryStack;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020&H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0015\"\u0004\b\u0018\u0010\u0019R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010\"\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0015\"\u0004\b$\u0010\u0019\u00a8\u0006*"}, d2={"Lcuchaz/kludge/window/Window;", "Ljava/lang/AutoCloseable;", "title", "", "size", "Lcuchaz/kludge/window/Size;", "resizable", "", "(Ljava/lang/String;Lcuchaz/kludge/window/Size;Z)V", "id", "", "getId$kludge", "()J", "value", "Lcuchaz/kludge/window/Pos;", "pos", "getPos", "()Lcuchaz/kludge/window/Pos;", "setPos", "(Lcuchaz/kludge/window/Pos;)V", "getResizable", "()Z", "shouldClose", "getShouldClose", "setShouldClose", "(Z)V", "getSize", "()Lcuchaz/kludge/window/Size;", "setSize", "(Lcuchaz/kludge/window/Size;)V", "getTitle", "()Ljava/lang/String;", "setTitle", "(Ljava/lang/String;)V", "visible", "getVisible", "setVisible", "centerOn", "", "monitor", "Lcuchaz/kludge/window/Monitor;", "close", "kludge"})
public final class Window
implements AutoCloseable {
    private final boolean resizable;
    private final long id;
    @NotNull
    private String title;
    private boolean visible;

    public Window(@NotNull String title, @NotNull Size size, boolean resizable) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        this.resizable = resizable;
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)GLFWKt.toGLFW(this.resizable));
        GLFW.glfwWindowHint((int)139265, (int)0);
        this.id = GLFW.glfwCreateWindow((int)size.getWidth(), (int)size.getHeight(), (CharSequence)title, (long)0L, (long)0L);
        if (this.id == 0L) {
            throw new RuntimeException("failed to create GLFW window");
        }
        this.title = title;
    }

    public /* synthetic */ Window(String string, Size size, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "Window";
        }
        if ((n & 2) != 0) {
            size = new Size(300, 300);
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        this(string, size, bl);
    }

    public final boolean getResizable() {
        return this.resizable;
    }

    public final long getId$kludge() {
        return this.id;
    }

    public final boolean getShouldClose() {
        return GLFW.glfwWindowShouldClose((long)this.id);
    }

    public final void setShouldClose(boolean value) {
        GLFW.glfwSetWindowShouldClose((long)this.id, (boolean)value);
    }

    @Override
    public void close() {
        GLFW.glfwDestroyWindow((long)this.id);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        GLFW.glfwSetWindowTitle((long)this.id, (CharSequence)value);
        this.title = this.title;
    }

    public final boolean getVisible() {
        return this.visible;
    }

    public final void setVisible(boolean value) {
        if (value) {
            GLFW.glfwShowWindow((long)this.id);
        } else {
            GLFW.glfwHideWindow((long)this.id);
        }
        this.visible = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Pos getPos() {
        boolean $i$f$memstack = false;
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            MemoryStack mem$iv = (MemoryStack)autoCloseable;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem$iv, (String)"mem");
            MemoryStack mem = mem$iv;
            boolean bl4 = false;
            IntBuffer x = mem.mallocInt(1);
            IntBuffer y = mem.mallocInt(1);
            GLFW.glfwGetWindowPos((long)this.getId$kludge(), (IntBuffer)x, (IntBuffer)y);
            Pos pos = new Pos(x.get(0), y.get(0));
            return pos;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void setPos(@NotNull Pos value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        GLFW.glfwSetWindowPos((long)this.id, (int)value.getX(), (int)value.getY());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Size getSize() {
        boolean $i$f$memstack = false;
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            MemoryStack mem$iv = (MemoryStack)autoCloseable;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem$iv, (String)"mem");
            MemoryStack mem = mem$iv;
            boolean bl4 = false;
            IntBuffer width = mem.mallocInt(1);
            IntBuffer height = mem.mallocInt(1);
            GLFW.glfwGetWindowSize((long)this.getId$kludge(), (IntBuffer)width, (IntBuffer)height);
            Size size = new Size(width.get(0), height.get(0));
            return size;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final void setSize(@NotNull Size value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        GLFW.glfwSetWindowSize((long)this.id, (int)value.getWidth(), (int)value.getHeight());
    }

    public final void centerOn(@NotNull Monitor monitor) {
        Intrinsics.checkNotNullParameter((Object)monitor, (String)"monitor");
        this.setPos(new Pos(monitor.getPos().getX() + (monitor.getSize().getWidth() - this.getSize().getWidth()) / 2, monitor.getPos().getY() + (monitor.getSize().getHeight() - this.getSize().getHeight()) / 2));
    }

    public Window() {
        this(null, null, false, 7, null);
    }
}

