/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.kludge.vulkan;

import cuchaz.kludge.tools.LangKt;
import cuchaz.kludge.vulkan.Device;
import cuchaz.kludge.vulkan.MemoryType;
import cuchaz.kludge.vulkan.VulkanstuffKt;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkDevice;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0010JN\u0010\u0017\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\b\b\u0002\u0010\u0019\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00102!\u0010\u001b\u001a\u001d\u0012\u0013\u0012\u00110\u0018\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\b\u0010!\u001a\u00020\"H\u0016J\u0006\u0010#\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006$"}, d2={"Lcuchaz/kludge/vulkan/MemoryAllocation;", "Ljava/lang/AutoCloseable;", "device", "Lcuchaz/kludge/vulkan/Device;", "id", "", "size", "type", "Lcuchaz/kludge/vulkan/MemoryType;", "(Lcuchaz/kludge/vulkan/Device;JJLcuchaz/kludge/vulkan/MemoryType;)V", "getDevice", "()Lcuchaz/kludge/vulkan/Device;", "getId$kludge", "()J", "getSize", "sizeAsInt", "", "getSizeAsInt", "()I", "getType", "()Lcuchaz/kludge/vulkan/MemoryType;", "close", "", "map", "Ljava/nio/ByteBuffer;", "offset", "T", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "buf", "(JILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "toString", "", "unmap", "kludge"})
public final class MemoryAllocation
implements AutoCloseable {
    @NotNull
    private final Device device;
    private final long id;
    private final long size;
    @NotNull
    private final MemoryType type;

    public MemoryAllocation(@NotNull Device device, long id, long size, @NotNull MemoryType type) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.device = device;
        this.id = id;
        this.size = size;
        this.type = type;
    }

    @NotNull
    public final Device getDevice() {
        return this.device;
    }

    public final long getId$kludge() {
        return this.id;
    }

    public final long getSize() {
        return this.size;
    }

    @NotNull
    public final MemoryType getType() {
        return this.type;
    }

    @NotNull
    public String toString() {
        String string = "0x%x";
        Object[] objectArray = new Object[]{this.id};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    @Override
    public void close() {
        VK10.vkFreeMemory((VkDevice)this.device.getVkDevice$kludge(), (long)this.id, null);
    }

    public final int getSizeAsInt() {
        Integer n = LangKt.toIntOrNull(this.size);
        if (n == null) {
            throw new IllegalStateException("buffer size (" + this.size + " bytes) too large to map all at once. Try mapping buffer slices up to 2147483647 bytes instead.");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ByteBuffer map(long offset, int size) {
        boolean $i$f$memstack = false;
        AutoCloseable autoCloseable = (AutoCloseable)MemoryStack.stackPush();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            MemoryStack mem$iv = (MemoryStack)autoCloseable;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)mem$iv, (String)"mem");
            MemoryStack mem = mem$iv;
            boolean bl4 = false;
            PointerBuffer ppData = mem.mallocPointer(1);
            int flags = 0;
            VulkanstuffKt.orFail(VK10.vkMapMemory((VkDevice)this.getDevice().getVkDevice$kludge(), (long)this.getId$kludge(), (long)offset, (long)size, (int)flags, (PointerBuffer)ppData), "failed to map device memory");
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer((long)ppData.get(0), (int)size);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"memByteBuffer(ppData.get(0), size)");
            ByteBuffer byteBuffer2 = byteBuffer;
            return byteBuffer2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ ByteBuffer map$default(MemoryAllocation memoryAllocation, long l, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            l = 0L;
        }
        if ((n2 & 2) != 0) {
            n = memoryAllocation.getSizeAsInt();
        }
        return memoryAllocation.map(l, n);
    }

    public final void unmap() {
        VK10.vkUnmapMemory((VkDevice)this.device.getVkDevice$kludge(), (long)this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T map(long offset, int size, @NotNull Function1<? super ByteBuffer, ? extends T> block) {
        Object object;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$map = false;
        try {
            object = block.invoke((Object)this.map(offset, size));
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.unmap();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static /* synthetic */ Object map$default(MemoryAllocation this_, long offset, int size, Function1 block, int n, Object object) {
        if ((n & 1) != 0) {
            offset = 0L;
        }
        if ((n & 2) != 0) {
            size = this_.getSizeAsInt();
        }
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        boolean $i$f$map = false;
        try {
            object = block.invoke((Object)this_.map(offset, size));
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this_.unmap();
            InlineMarker.finallyEnd((int)1);
        }
        return object;
    }
}

