/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.features;

import io.ktor.application.ApplicationCall;
import io.ktor.application.ApplicationCallPipeline;
import io.ktor.application.ApplicationFeature;
import io.ktor.features.Compression;
import io.ktor.features.CompressionEncoder;
import io.ktor.features.CompressionEncoderBuilder;
import io.ktor.features.CompressionEncoderConfig;
import io.ktor.features.CompressionKt;
import io.ktor.features.CompressionOptions;
import io.ktor.features.ConditionsHolderBuilder;
import io.ktor.http.ContentType;
import io.ktor.http.HeaderValue;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaderValueParserKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import io.ktor.request.ApplicationRequestPropertiesKt;
import io.ktor.response.ApplicationSendPipeline;
import io.ktor.util.AttributeKey;
import io.ktor.util.StringValues;
import io.ktor.util.StringValuesBuilder;
import io.ktor.util.StringValuesKt;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.utils.io.ByteChannelCtorKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00162\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00110\u0010H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012Rb\u0010\u0005\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t \n*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00070\u0007 \n**\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t \n*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"Lio/ktor/features/Compression;", "", "compression", "Lio/ktor/features/Compression$Configuration;", "(Lio/ktor/features/Compression$Configuration;)V", "comparator", "Ljava/util/Comparator;", "Lkotlin/Pair;", "Lio/ktor/features/CompressionEncoderConfig;", "Lio/ktor/http/HeaderValue;", "kotlin.jvm.PlatformType", "options", "Lio/ktor/features/CompressionOptions;", "interceptor", "", "context", "Lio/ktor/util/pipeline/PipelineContext;", "Lio/ktor/application/ApplicationCall;", "(Lio/ktor/util/pipeline/PipelineContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "CompressedResponse", "CompressedWriteResponse", "Configuration", "Feature", "ktor-server-core"})
public final class Compression {
    @NotNull
    public static final Feature Feature = new Feature(null);
    @NotNull
    private final CompressionOptions options;
    private final Comparator<Pair<CompressionEncoderConfig, HeaderValue>> comparator;
    @NotNull
    private static final AttributeKey<Boolean> SuppressionAttribute = new AttributeKey("preventCompression");
    @NotNull
    private static final AttributeKey<Compression> key = new AttributeKey("Compression");

    public Compression(@NotNull Configuration compression) {
        Intrinsics.checkNotNullParameter((Object)compression, (String)"compression");
        this.options = compression.buildOptions$ktor_server_core();
        Function1[] function1Array = new Function1[]{comparator.1.INSTANCE, comparator.2.INSTANCE};
        this.comparator = ComparisonsKt.compareBy((Function1[])function1Array).reversed();
    }

    /*
     * WARNING - void declaration
     */
    private final Object interceptor(PipelineContext<Object, ApplicationCall> context, Continuation<? super Unit> $completion) {
        Iterator $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable list$iv$iv;
        void $this$flatMapTo$iv$iv;
        Object $this$flatMap$iv;
        HeaderValue it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        PipelineContext<Object, ApplicationCall> $this$call$iv = context;
        boolean $i$f$getCall = false;
        ApplicationCall call = (ApplicationCall)$this$call$iv.getContext();
        Object message = context.getSubject();
        String acceptEncodingRaw = ApplicationRequestPropertiesKt.acceptEncoding(call.getRequest());
        if (acceptEncodingRaw == null || CompressionKt.access$isCompressionSuppressed(call)) {
            return Unit.INSTANCE;
        }
        Iterable iterable = HttpHeaderValueParserKt.parseHeaderValue((String)acceptEncodingRaw);
        boolean $i$f$filter = false;
        void var9_10 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (HeaderValue)element$iv$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it.getValue(), (Object)"*") || this.options.getEncoders().containsKey(it.getValue());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            HeaderValue header = (HeaderValue)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)header.getValue(), (Object)"*")) {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = this.options.getEncoders().values();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it2;
                    CompressionEncoderConfig compressionEncoderConfig = (CompressionEncoderConfig)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(TuplesKt.to((Object)it2, (Object)header));
                }
                list = (List)destination$iv$iv2;
            } else {
                List list2;
                if (this.options.getEncoders().get(header.getValue()) == null) {
                    list2 = null;
                } else {
                    CompressionEncoderConfig it3;
                    boolean bl4 = false;
                    list2 = CollectionsKt.listOf((Object)TuplesKt.to((Object)it3, (Object)header));
                }
                list = list2;
                if (list2 == null) {
                    list = CollectionsKt.emptyList();
                }
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable iterable3 = (List)destination$iv$iv;
        $this$flatMap$iv = this.comparator;
        Intrinsics.checkNotNullExpressionValue($this$flatMap$iv, (String)"comparator");
        $this$flatMap$iv = CollectionsKt.sortedWith((Iterable)iterable3, $this$flatMap$iv);
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            list$iv$iv = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((CompressionEncoderConfig)it.getFirst());
        }
        List encoders = (List)destination$iv$iv;
        if (encoders.isEmpty()) {
            return Unit.INSTANCE;
        }
        if (message instanceof OutgoingContent && !(message instanceof CompressedResponse)) {
            boolean bl;
            block32: {
                Iterable $this$all$iv = this.options.getConditions();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Function2 it4 = (Function2)element$iv;
                        boolean bl5 = false;
                        if (((Boolean)it4.invoke((Object)call, message)).booleanValue()) continue;
                        bl = false;
                        break block32;
                    }
                    bl = true;
                }
            }
            if (bl && !CompressionKt.access$isCompressionSuppressed(call)) {
                String it5 = ((OutgoingContent)message).getHeaders().get(HttpHeaders.INSTANCE.getContentEncoding());
                boolean bl6 = false;
                boolean bl7 = it5 == null || !Intrinsics.areEqual((Object)it5, (Object)"identity");
                if (bl7) {
                    Function0 function0;
                    Object v7;
                    block34: {
                        Iterable $this$firstOrNull$iv = encoders;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            boolean bl8;
                            block33: {
                                CompressionEncoderConfig encoder2 = (CompressionEncoderConfig)element$iv;
                                boolean bl9 = false;
                                Iterable $this$all$iv = encoder2.getConditions();
                                boolean $i$f$all = false;
                                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                    bl8 = true;
                                } else {
                                    for (Object element$iv2 : $this$all$iv) {
                                        Function2 it6 = (Function2)element$iv2;
                                        boolean bl10 = false;
                                        if (((Boolean)it6.invoke((Object)call, message)).booleanValue()) continue;
                                        bl8 = false;
                                        break block33;
                                    }
                                    bl8 = true;
                                }
                            }
                            if (!bl8) continue;
                            v7 = element$iv;
                            break block34;
                        }
                        v7 = null;
                    }
                    CompressionEncoderConfig encoderOptions = v7;
                    OutgoingContent $i$f$firstOrNull = (OutgoingContent)message;
                    if ($i$f$firstOrNull instanceof OutgoingContent.ReadChannelContent) {
                        function0 = (Function0)new Function0<ByteReadChannel>(message){
                            final /* synthetic */ Object $message;
                            {
                                this.$message = $message;
                                super(0);
                            }

                            @NotNull
                            public final ByteReadChannel invoke() {
                                return ((OutgoingContent.ReadChannelContent)this.$message).readFrom();
                            }
                        };
                    } else {
                        if ($i$f$firstOrNull instanceof OutgoingContent.WriteChannelContent) {
                            if (encoderOptions != null) {
                                CompressedWriteResponse response = new CompressedWriteResponse((OutgoingContent.WriteChannelContent)message, encoderOptions.getName(), encoderOptions.getEncoder());
                                Object object = context.proceedWith((Object)response, $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                            }
                            return Unit.INSTANCE;
                        }
                        if ($i$f$firstOrNull instanceof OutgoingContent.NoContent) {
                            return Unit.INSTANCE;
                        }
                        if ($i$f$firstOrNull instanceof OutgoingContent.ByteArrayContent) {
                            function0 = (Function0)new Function0<ByteReadChannel>(message){
                                final /* synthetic */ Object $message;
                                {
                                    this.$message = $message;
                                    super(0);
                                }

                                @NotNull
                                public final ByteReadChannel invoke() {
                                    return ByteChannelCtorKt.ByteReadChannel((byte[])((OutgoingContent.ByteArrayContent)this.$message).bytes());
                                }
                            };
                        } else {
                            if ($i$f$firstOrNull instanceof OutgoingContent.ProtocolUpgrade) {
                                return Unit.INSTANCE;
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    Function0 channel2 = function0;
                    if (encoderOptions != null) {
                        CompressedResponse response = new CompressedResponse((OutgoingContent)message, (Function0<? extends ByteReadChannel>)channel2, encoderOptions.getName(), encoderOptions.getEncoder());
                        Object object = context.proceedWith((Object)response, $completion);
                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return object;
                        }
                        return Unit.INSTANCE;
                    }
                }
            }
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$interceptor(Compression $this, PipelineContext context, Continuation $completion) {
        return $this.interceptor((PipelineContext<Object, ApplicationCall>)context, (Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ'\u0010&\u001a\u0004\u0018\u0001H'\"\b\b\u0000\u0010'*\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*H\u0016\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020\u0006H\u0016J/\u0010-\u001a\u00020.\"\b\b\u0000\u0010'*\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*2\b\u0010/\u001a\u0004\u0018\u0001H'H\u0016\u00a2\u0006\u0002\u00100R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\u0004\u0018\u00010#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00061"}, d2={"Lio/ktor/features/Compression$CompressedResponse;", "Lio/ktor/http/content/OutgoingContent$ReadChannelContent;", "original", "Lio/ktor/http/content/OutgoingContent;", "delegateChannel", "Lkotlin/Function0;", "Lio/ktor/utils/io/ByteReadChannel;", "encoding", "", "encoder", "Lio/ktor/features/CompressionEncoder;", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/jvm/functions/Function0;Ljava/lang/String;Lio/ktor/features/CompressionEncoder;)V", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "contentType", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "getDelegateChannel", "()Lkotlin/jvm/functions/Function0;", "getEncoder", "()Lio/ktor/features/CompressionEncoder;", "getEncoding", "()Ljava/lang/String;", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "headers$delegate", "Lkotlin/Lazy;", "getOriginal", "()Lio/ktor/http/content/OutgoingContent;", "status", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "getProperty", "T", "", "key", "Lio/ktor/util/AttributeKey;", "(Lio/ktor/util/AttributeKey;)Ljava/lang/Object;", "readFrom", "setProperty", "", "value", "(Lio/ktor/util/AttributeKey;Ljava/lang/Object;)V", "ktor-server-core"})
    private static final class CompressedResponse
    extends OutgoingContent.ReadChannelContent {
        @NotNull
        private final OutgoingContent original;
        @NotNull
        private final Function0<ByteReadChannel> delegateChannel;
        @NotNull
        private final String encoding;
        @NotNull
        private final CompressionEncoder encoder;
        @NotNull
        private final Lazy headers$delegate;

        public CompressedResponse(@NotNull OutgoingContent original, @NotNull Function0<? extends ByteReadChannel> delegateChannel, @NotNull String encoding, @NotNull CompressionEncoder encoder2) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter(delegateChannel, (String)"delegateChannel");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            Intrinsics.checkNotNullParameter((Object)encoder2, (String)"encoder");
            this.original = original;
            this.delegateChannel = delegateChannel;
            this.encoding = encoding;
            this.encoder = encoder2;
            this.headers$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Headers>(this){
                final /* synthetic */ CompressedResponse this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Headers invoke() {
                    HeadersBuilder headersBuilder;
                    Headers.Companion companion = Headers.Companion;
                    CompressedResponse compressedResponse = this.this$0;
                    boolean $i$f$build = false;
                    HeadersBuilder $this$invoke_u24lambda_u2d0 = headersBuilder = new HeadersBuilder(0, 1, null);
                    boolean bl = false;
                    StringValuesKt.appendFiltered$default((StringValuesBuilder)((StringValuesBuilder)$this$invoke_u24lambda_u2d0), (StringValues)((StringValues)compressedResponse.getOriginal().getHeaders()), (boolean)false, (Function2)headers.1.1.INSTANCE, (int)2, null);
                    $this$invoke_u24lambda_u2d0.append(HttpHeaders.INSTANCE.getContentEncoding(), compressedResponse.getEncoding());
                    return headersBuilder.build();
                }
            }));
        }

        @NotNull
        public final OutgoingContent getOriginal() {
            return this.original;
        }

        @NotNull
        public final Function0<ByteReadChannel> getDelegateChannel() {
            return this.delegateChannel;
        }

        @NotNull
        public final String getEncoding() {
            return this.encoding;
        }

        @NotNull
        public final CompressionEncoder getEncoder() {
            return this.encoder;
        }

        @NotNull
        public ByteReadChannel readFrom() {
            return CompressionEncoder.DefaultImpls.compress$default(this.encoder, (ByteReadChannel)this.delegateChannel.invoke(), null, 2, null);
        }

        @NotNull
        public Headers getHeaders() {
            Lazy lazy = this.headers$delegate;
            return (Headers)lazy.getValue();
        }

        @Nullable
        public ContentType getContentType() {
            return this.original.getContentType();
        }

        @Nullable
        public HttpStatusCode getStatus() {
            return this.original.getStatus();
        }

        @Nullable
        public Long getContentLength() {
            Long l;
            Long l2 = this.original.getContentLength();
            if (l2 == null) {
                l = null;
            } else {
                long it = ((Number)l2).longValue();
                boolean bl = false;
                Long l3 = this.getEncoder().predictCompressedLength(it);
                if (l3 == null) {
                    l = null;
                } else {
                    Long l4 = l3;
                    it = ((Number)l4).longValue();
                    boolean bl2 = false;
                    l = it >= 0L ? l4 : null;
                }
            }
            return l;
        }

        @Nullable
        public <T> T getProperty(@NotNull AttributeKey<T> key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return (T)this.original.getProperty(key);
        }

        public <T> void setProperty(@NotNull AttributeKey<T> key, @Nullable T value) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            this.original.setProperty(key, value);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J'\u0010 \u001a\u0004\u0018\u0001H!\"\b\b\u0000\u0010!*\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0$H\u0016\u00a2\u0006\u0002\u0010%J/\u0010&\u001a\u00020'\"\b\b\u0000\u0010!*\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0$2\b\u0010(\u001a\u0004\u0018\u0001H!H\u0016\u00a2\u0006\u0002\u0010)J\u0019\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010-R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006."}, d2={"Lio/ktor/features/Compression$CompressedWriteResponse;", "Lio/ktor/http/content/OutgoingContent$WriteChannelContent;", "original", "encoding", "", "encoder", "Lio/ktor/features/CompressionEncoder;", "(Lio/ktor/http/content/OutgoingContent$WriteChannelContent;Ljava/lang/String;Lio/ktor/features/CompressionEncoder;)V", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "contentType", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "getEncoder", "()Lio/ktor/features/CompressionEncoder;", "getEncoding", "()Ljava/lang/String;", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "headers$delegate", "Lkotlin/Lazy;", "getOriginal", "()Lio/ktor/http/content/OutgoingContent$WriteChannelContent;", "status", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "getProperty", "T", "", "key", "Lio/ktor/util/AttributeKey;", "(Lio/ktor/util/AttributeKey;)Ljava/lang/Object;", "setProperty", "", "value", "(Lio/ktor/util/AttributeKey;Ljava/lang/Object;)V", "writeTo", "channel", "Lio/ktor/utils/io/ByteWriteChannel;", "(Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-server-core"})
    private static final class CompressedWriteResponse
    extends OutgoingContent.WriteChannelContent {
        @NotNull
        private final OutgoingContent.WriteChannelContent original;
        @NotNull
        private final String encoding;
        @NotNull
        private final CompressionEncoder encoder;
        @NotNull
        private final Lazy headers$delegate;

        public CompressedWriteResponse(@NotNull OutgoingContent.WriteChannelContent original, @NotNull String encoding, @NotNull CompressionEncoder encoder2) {
            Intrinsics.checkNotNullParameter((Object)original, (String)"original");
            Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
            Intrinsics.checkNotNullParameter((Object)encoder2, (String)"encoder");
            this.original = original;
            this.encoding = encoding;
            this.encoder = encoder2;
            this.headers$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Headers>(this){
                final /* synthetic */ CompressedWriteResponse this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Headers invoke() {
                    HeadersBuilder headersBuilder;
                    Headers.Companion companion = Headers.Companion;
                    CompressedWriteResponse compressedWriteResponse = this.this$0;
                    boolean $i$f$build = false;
                    HeadersBuilder $this$invoke_u24lambda_u2d0 = headersBuilder = new HeadersBuilder(0, 1, null);
                    boolean bl = false;
                    StringValuesKt.appendFiltered$default((StringValuesBuilder)((StringValuesBuilder)$this$invoke_u24lambda_u2d0), (StringValues)((StringValues)compressedWriteResponse.getOriginal().getHeaders()), (boolean)false, (Function2)headers.1.1.INSTANCE, (int)2, null);
                    $this$invoke_u24lambda_u2d0.append(HttpHeaders.INSTANCE.getContentEncoding(), compressedWriteResponse.getEncoding());
                    return headersBuilder.build();
                }
            }));
        }

        @NotNull
        public final OutgoingContent.WriteChannelContent getOriginal() {
            return this.original;
        }

        @NotNull
        public final String getEncoding() {
            return this.encoding;
        }

        @NotNull
        public final CompressionEncoder getEncoder() {
            return this.encoder;
        }

        @NotNull
        public Headers getHeaders() {
            Lazy lazy = this.headers$delegate;
            return (Headers)lazy.getValue();
        }

        @Nullable
        public ContentType getContentType() {
            return this.original.getContentType();
        }

        @Nullable
        public HttpStatusCode getStatus() {
            return this.original.getStatus();
        }

        @Nullable
        public Long getContentLength() {
            Long l;
            Long l2 = this.original.getContentLength();
            if (l2 == null) {
                l = null;
            } else {
                long it = ((Number)l2).longValue();
                boolean bl = false;
                Long l3 = this.getEncoder().predictCompressedLength(it);
                if (l3 == null) {
                    l = null;
                } else {
                    Long l4 = l3;
                    it = ((Number)l4).longValue();
                    boolean bl2 = false;
                    l = it >= 0L ? l4 : null;
                }
            }
            return l;
        }

        @Nullable
        public <T> T getProperty(@NotNull AttributeKey<T> key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            return (T)this.original.getProperty(key);
        }

        public <T> void setProperty(@NotNull AttributeKey<T> key, @Nullable T value) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            this.original.setProperty(key, value);
        }

        @Nullable
        public Object writeTo(@NotNull ByteWriteChannel channel2, @NotNull Continuation<? super Unit> $completion) {
            Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, channel2, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ CompressedWriteResponse this$0;
                final /* synthetic */ ByteWriteChannel $channel;
                {
                    this.this$0 = $receiver;
                    this.$channel = $channel;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ByteWriteChannel $this$use$iv;
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                            ByteWriteChannel byteWriteChannel = this.this$0.getEncoder().compress(this.$channel, $this$coroutineScope.getCoroutineContext());
                            CompressedWriteResponse compressedWriteResponse = this.this$0;
                            boolean $i$f$use = false;
                            ByteWriteChannel $this$invokeSuspend_u24lambda_u2d0 = $this$use$iv;
                            boolean bl = false;
                            this.L$0 = $this$use$iv;
                            this.label = 1;
                            Object object3 = compressedWriteResponse.getOriginal().writeTo($this$invokeSuspend_u24lambda_u2d0, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            Object object3;
                            boolean $i$f$use = false;
                            boolean bl = false;
                            ByteWriteChannel $this$use$iv = (ByteWriteChannel)this.L$0;
                            try {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (Throwable cause$iv) {
                                $this$use$iv.close(cause$iv);
                                throw cause$iv;
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        {
                            ByteWriteChannel $this$use$iv;
                            finally {
                                ByteWriteChannelKt.close((ByteWriteChannel)$this$use$iv);
                            }
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J)\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00022\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\u0002\b\u0012H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0013"}, d2={"Lio/ktor/features/Compression$Feature;", "Lio/ktor/application/ApplicationFeature;", "Lio/ktor/application/ApplicationCallPipeline;", "Lio/ktor/features/Compression$Configuration;", "Lio/ktor/features/Compression;", "()V", "SuppressionAttribute", "Lio/ktor/util/AttributeKey;", "", "getSuppressionAttribute", "()Lio/ktor/util/AttributeKey;", "key", "getKey", "install", "pipeline", "configure", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "ktor-server-core"})
    public static final class Feature
    implements ApplicationFeature<ApplicationCallPipeline, Configuration, Compression> {
        private Feature() {
        }

        @NotNull
        public final AttributeKey<Boolean> getSuppressionAttribute() {
            return SuppressionAttribute;
        }

        @Override
        @NotNull
        public AttributeKey<Compression> getKey() {
            return key;
        }

        @Override
        @NotNull
        public Compression install(@NotNull ApplicationCallPipeline pipeline, @NotNull Function1<? super Configuration, Unit> configure) {
            Intrinsics.checkNotNullParameter((Object)((Object)pipeline), (String)"pipeline");
            Intrinsics.checkNotNullParameter(configure, (String)"configure");
            Configuration configuration = new Configuration();
            configure.invoke((Object)configuration);
            Configuration config = configuration;
            if (MapsKt.none(config.getEncoders())) {
                config.default();
            }
            Compression feature = new Compression(config);
            pipeline.getSendPipeline().intercept(ApplicationSendPipeline.Phases.getContentEncoding(), (Function3)new Function3<PipelineContext<Object, ApplicationCall>, Object, Continuation<? super Unit>, Object>(feature, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Compression $feature;
                {
                    this.$feature = $feature;
                    super(3, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            this.label = 1;
                            Object object3 = Compression.access$interceptor(this.$feature, $this$intercept, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull PipelineContext<Object, ApplicationCall> p1, @NotNull Object p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<PipelineContext<Object, ApplicationCall>, Object, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    return function3.invokeSuspend((Object)Unit.INSTANCE);
                }
            });
            return feature;
        }

        public /* synthetic */ Feature(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\r\u0010\u0014\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J1\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u001a2\u0019\b\u0002\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00170\u001c\u00a2\u0006\u0002\b\tR1\u0010\u0003\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\b\t0\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lio/ktor/features/Compression$Configuration;", "Lio/ktor/features/ConditionsHolderBuilder;", "()V", "conditions", "", "Lkotlin/Function2;", "Lio/ktor/application/ApplicationCall;", "Lio/ktor/http/content/OutgoingContent;", "", "Lkotlin/ExtensionFunctionType;", "getConditions", "()Ljava/util/List;", "encoders", "", "", "Lio/ktor/features/CompressionEncoderBuilder;", "getEncoders", "()Ljava/util/Map;", "build", "Lio/ktor/features/CompressionOptions;", "buildOptions", "buildOptions$ktor_server_core", "default", "", "encoder", "name", "Lio/ktor/features/CompressionEncoder;", "block", "Lkotlin/Function1;", "ktor-server-core"})
    public static final class Configuration
    implements ConditionsHolderBuilder {
        @NotNull
        private final Map<String, CompressionEncoderBuilder> encoders = new HashMap();
        @NotNull
        private final List<Function2<ApplicationCall, OutgoingContent, Boolean>> conditions = new ArrayList();

        @NotNull
        public final Map<String, CompressionEncoderBuilder> getEncoders() {
            return this.encoders;
        }

        @Override
        @NotNull
        public List<Function2<ApplicationCall, OutgoingContent, Boolean>> getConditions() {
            return this.conditions;
        }

        public final void encoder(@NotNull String name, @NotNull CompressionEncoder encoder2, @NotNull Function1<? super CompressionEncoderBuilder, Unit> block) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)encoder2, (String)"encoder");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            if (!(!StringsKt.isBlank((CharSequence)name))) {
                boolean bl = false;
                String string = "encoder name couldn't be blank";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.encoders.containsKey(name)) {
                throw new IllegalArgumentException("Encoder " + name + " is already registered");
            }
            Map<String, CompressionEncoderBuilder> map = this.encoders;
            CompressionEncoderBuilder compressionEncoderBuilder = new CompressionEncoderBuilder(name, encoder2);
            block.invoke((Object)compressionEncoderBuilder);
            map.put(name, compressionEncoderBuilder);
        }

        public static /* synthetic */ void encoder$default(Configuration configuration, String string, CompressionEncoder compressionEncoder, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = encoder.1.INSTANCE;
            }
            configuration.encoder(string, compressionEncoder, (Function1<? super CompressionEncoderBuilder, Unit>)function1);
        }

        public final void default() {
            CompressionKt.gzip$default(this, null, 1, null);
            CompressionKt.deflate$default(this, null, 1, null);
            CompressionKt.identity$default(this, null, 1, null);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final CompressionOptions buildOptions$ktor_server_core() {
            void $this$mapValuesTo$iv$iv;
            Map<String, CompressionEncoderBuilder> $this$mapValues$iv = this.encoders;
            boolean $i$f$mapValues = false;
            Map<String, CompressionEncoderBuilder> map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void $dstr$_u24__u24$builder;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                CompressionEncoderBuilder builder = (CompressionEncoderBuilder)$dstr$_u24__u24$builder.getValue();
                if (CollectionsKt.none((Iterable)this.getConditions()) && CollectionsKt.none((Iterable)builder.getConditions())) {
                    CompressionKt.access$defaultConditions(builder);
                }
                CompressionEncoderConfig compressionEncoderConfig = builder.buildConfig$ktor_server_core();
                map3.put(k, compressionEncoderConfig);
            }
            List list = CollectionsKt.toList((Iterable)this.getConditions());
            Map map4 = destination$iv$iv;
            return new CompressionOptions(map4, list);
        }

        @Deprecated(message="This is going to become internal. Please stop building it manually or file a ticket with explanation why do you need it.")
        @NotNull
        public final CompressionOptions build() {
            return this.buildOptions$ktor_server_core();
        }
    }
}

