/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.request;

import io.ktor.http.CookieEncoding;
import io.ktor.http.CookieKt;
import io.ktor.request.ApplicationRequest;
import io.ktor.util.collections.ConcurrentMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000bH\u0014J\u001d\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\t2\b\b\u0002\u0010\u0015\u001a\u00020\bH\u0086\u0002R&\u0010\u0005\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lio/ktor/request/RequestCookies;", "", "request", "Lio/ktor/request/ApplicationRequest;", "(Lio/ktor/request/ApplicationRequest;)V", "map", "Lio/ktor/util/collections/ConcurrentMap;", "Lkotlin/Pair;", "Lio/ktor/http/CookieEncoding;", "", "rawCookies", "", "getRawCookies", "()Ljava/util/Map;", "rawCookies$delegate", "Lkotlin/Lazy;", "getRequest", "()Lio/ktor/request/ApplicationRequest;", "fetchCookies", "get", "name", "encoding", "ktor-server-core"})
public class RequestCookies {
    @NotNull
    private final ApplicationRequest request;
    @NotNull
    private final ConcurrentMap<Pair<CookieEncoding, String>, String> map;
    @NotNull
    private final Lazy rawCookies$delegate;

    public RequestCookies(@NotNull ApplicationRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        this.map = new ConcurrentMap(null, 0, 3, null);
        this.rawCookies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends String>>(this){
            final /* synthetic */ RequestCookies this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, String> invoke() {
                return this.this$0.fetchCookies();
            }
        }));
    }

    @NotNull
    protected final ApplicationRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final Map<String, String> getRawCookies() {
        Lazy lazy = this.rawCookies$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final String get(@NotNull String name, @NotNull CookieEncoding encoding) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)encoding, (String)"encoding");
        String string = this.getRawCookies().get(name);
        if (string == null) {
            return null;
        }
        String rawValue = string;
        return (String)this.map.computeIfAbsent((Object)TuplesKt.to((Object)encoding, (Object)name), (Function0)new Function0<String>(rawValue, encoding){
            final /* synthetic */ String $rawValue;
            final /* synthetic */ CookieEncoding $encoding;
            {
                this.$rawValue = $rawValue;
                this.$encoding = $encoding;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return CookieKt.decodeCookieValue((String)this.$rawValue, (CookieEncoding)this.$encoding);
            }
        });
    }

    public static /* synthetic */ String get$default(RequestCookies requestCookies, String string, CookieEncoding cookieEncoding, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
        }
        if ((n & 2) != 0) {
            cookieEncoding = CookieEncoding.URI_ENCODING;
        }
        return requestCookies.get(string, cookieEncoding);
    }

    @NotNull
    protected Map<String, String> fetchCookies() {
        List list = this.request.getHeaders().getAll("Cookie");
        if (list == null) {
            return MapsKt.emptyMap();
        }
        List cookieHeaders = list;
        HashMap map = new HashMap(cookieHeaders.size());
        for (String cookieHeader : cookieHeaders) {
            Map cookies = CookieKt.parseClientCookiesHeader$default((String)cookieHeader, (boolean)false, (int)2, null);
            map.putAll(cookies);
        }
        return map;
    }
}

