/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.algebra;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import com.joptimizer.algebra.MatrixRescaler;
import com.joptimizer.util.ColtUtils;
import com.joptimizer.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;

public class CholeskySparseFactorization {
    private int dim;
    private SparseDoubleMatrix2D Q;
    private MatrixRescaler rescaler = null;
    private DoubleMatrix1D U;
    protected Algebra ALG = Algebra.DEFAULT;
    protected DoubleFactory2D F2 = DoubleFactory2D.dense;
    protected DoubleFactory1D F1 = DoubleFactory1D.dense;
    private double[][] LcolumnsValues = null;
    private double[] Svalues = null;
    private DoubleMatrix2D L;
    private DoubleMatrix2D LT;
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    public long factorizeTime = 0L;
    public long foreachTime = 0L;

    public CholeskySparseFactorization(SparseDoubleMatrix2D Q) {
        this(Q, null);
    }

    public CholeskySparseFactorization(SparseDoubleMatrix2D Q, MatrixRescaler rescaler) {
        this.dim = Q.rows();
        this.Q = Q;
        this.rescaler = rescaler;
    }

    public void factorize() throws Exception {
        long t0 = System.currentTimeMillis();
        this.LcolumnsValues = new double[this.dim][];
        if (this.rescaler != null) {
            boolean checkOK;
            double[] cn_00_original = null;
            double[] cn_2_original = null;
            double[] cn_00_scaled = null;
            double[] cn_2_scaled = null;
            if (this.log.isDebugEnabled()) {
                cn_00_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_original Q before scaling: " + ArrayUtils.toString((Object)cn_00_original)));
                cn_2_original = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), 2);
                this.log.debug((Object)("cn_2_original Q before scaling : " + ArrayUtils.toString((Object)cn_2_original)));
            }
            DoubleMatrix1D Uv = this.rescaler.getMatrixScalingFactorsSymm(this.Q);
            if (this.log.isDebugEnabled() && !(checkOK = this.rescaler.checkScaling(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q), Uv, Uv))) {
                this.log.warn((Object)"Scaling failed (checkScaling = false)");
            }
            this.U = Uv;
            this.Q = (SparseDoubleMatrix2D)ColtUtils.diagonalMatrixMult(Uv, this.Q, Uv);
            if (this.log.isDebugEnabled()) {
                cn_00_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), Integer.MAX_VALUE);
                this.log.debug((Object)("cn_00_scaled Q after scaling : " + ArrayUtils.toString((Object)cn_00_scaled)));
                cn_2_scaled = ColtUtils.getConditionNumberRange((RealMatrix)new Array2DRowRealMatrix(ColtUtils.fillSubdiagonalSymmetricMatrix(this.Q).toArray()), 2);
                this.log.debug((Object)("cn_2_scaled Q after scaling  : " + ArrayUtils.toString((Object)cn_2_scaled)));
                if (cn_00_original[0] < cn_00_scaled[0] || cn_2_original[0] < cn_2_scaled[0]) {
                    this.log.warn((Object)"Problematic scaling");
                }
            }
        }
        final int[] currentColumnIndexHolder = new int[]{-1};
        IntIntDoubleFunction myFunct = new IntIntDoubleFunction(){

            public double apply(int i, int s, double pis) {
                int step = currentColumnIndexHolder[0];
                if (i >= step) {
                    ((CholeskySparseFactorization)CholeskySparseFactorization.this).Svalues[i - step] = pis;
                }
                return pis;
            }
        };
        for (int step = 0; step < this.dim; ++step) {
            this.Svalues = new double[this.dim - step];
            DoubleMatrix2D P = this.Q.viewPart(0, step, this.dim, 1);
            currentColumnIndexHolder[0] = step;
            P.forEachNonZero(myFunct);
            this.doStep(step);
        }
        this.factorizeTime += System.currentTimeMillis() - t0;
    }

    private void doStep(int step) throws Exception {
        for (int k = 0; k < step; ++k) {
            double[] LcolumnsValuesK = this.LcolumnsValues[k];
            int j = step;
            double LJK = LcolumnsValuesK[j - k];
            if (Double.compare(LJK, 0.0) == 0) continue;
            for (int i = j; i < this.dim; ++i) {
                double LIK = LcolumnsValuesK[i - k];
                double LJKLIK = LJK * LIK;
                int n = i - step;
                this.Svalues[n] = this.Svalues[n] - LJKLIK;
            }
        }
        if (!(this.Svalues[0] > Utils.getDoubleMachineEpsilon())) {
            throw new Exception("not positive definite matrix");
        }
        double evStep = Math.sqrt(this.Svalues[0]);
        double[] LcolumnsValuesS = new double[this.dim - step];
        LcolumnsValuesS[0] = evStep;
        for (int i = 1; i < this.Svalues.length; ++i) {
            double SvaluesR = this.Svalues[i];
            if (Double.compare(SvaluesR, 0.0) == 0) continue;
            LcolumnsValuesS[i] = SvaluesR /= evStep;
        }
        this.LcolumnsValues[step] = LcolumnsValuesS;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("step " + step + " situation:"));
            this.log.debug((Object)("LcolumnsValues: " + ArrayUtils.toString((Object)this.LcolumnsValues)));
            this.log.debug((Object)("Svalues:        " + ArrayUtils.toString((Object)this.Svalues)));
        }
    }

    public DoubleMatrix1D solve(DoubleMatrix1D b) {
        if (b.size() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + b.size());
        }
        if (this.rescaler != null) {
            b = ColtUtils.diagonalMatrixMult(this.U, b);
        }
        double[] y = new double[this.dim];
        System.arraycopy(b.toArray(), 0, y, 0, this.dim);
        for (int j = 0; j < this.dim; ++j) {
            double[] LTJ = this.LcolumnsValues[j];
            int n = j;
            y[n] = y[n] / LTJ[0];
            double yJ = y[j];
            for (int i = j + 1; i < this.dim; ++i) {
                int n2 = i;
                y[n2] = y[n2] - yJ * LTJ[i - j];
            }
        }
        DoubleMatrix1D x = this.F1.make(this.dim);
        for (int i = this.dim - 1; i > -1; --i) {
            double[] LTI = this.LcolumnsValues[i];
            double sum = 0.0;
            for (int j = this.dim - 1; j > i; --j) {
                sum += LTI[j - i] * x.getQuick(j);
            }
            x.setQuick(i, (y[i] - sum) / LTI[0]);
        }
        if (this.rescaler != null) {
            return ColtUtils.diagonalMatrixMult(this.U, x);
        }
        return x;
    }

    public DoubleMatrix2D solve(DoubleMatrix2D B) {
        if (B.rows() != this.dim) {
            this.log.error((Object)("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows()));
            throw new RuntimeException("wrong dimension of vector b: expected " + this.dim + ", actual " + B.rows());
        }
        if (this.rescaler != null) {
            B = ColtUtils.diagonalMatrixMult(this.U, B);
        }
        int nOfColumns = B.columns();
        double[][] Y = B.copy().toArray();
        for (int j = 0; j < this.dim; ++j) {
            double[] LTJ = this.LcolumnsValues[j];
            for (int col = 0; col < nOfColumns; ++col) {
                double[] dArray = Y[j];
                int n = col;
                dArray[n] = dArray[n] / LTJ[0];
                double YJCol = Y[j][col];
                if (Double.compare(YJCol, 0.0) == 0) continue;
                for (int i = j + 1; i < this.dim; ++i) {
                    double[] dArray2 = Y[i];
                    int n2 = col;
                    dArray2[n2] = dArray2[n2] - YJCol * LTJ[i - j];
                }
            }
        }
        DoubleMatrix2D X = this.F2.make(this.dim, nOfColumns);
        for (int i = this.dim - 1; i > -1; --i) {
            double[] LTI = this.LcolumnsValues[i];
            double[] sum = new double[nOfColumns];
            for (int col = 0; col < nOfColumns; ++col) {
                for (int j = this.dim - 1; j > i; --j) {
                    int n = col;
                    sum[n] = sum[n] + LTI[j - i] * X.getQuick(j, col);
                }
                X.setQuick(i, col, (Y[i][col] - sum[col]) / LTI[0]);
            }
        }
        if (this.rescaler != null) {
            return ColtUtils.diagonalMatrixMult(this.U, X);
        }
        return X;
    }

    public DoubleMatrix2D getL() {
        if (this.L == null) {
            this.L = this.ALG.transpose(this.getLT());
        }
        return this.L;
    }

    public DoubleMatrix2D getLT() {
        if (this.LT == null) {
            double[][] myLT = new double[this.dim][];
            for (int i = 0; i < this.dim; ++i) {
                double[] LTI = new double[this.dim];
                double[] valuesI = this.LcolumnsValues[i];
                for (int j = i; j < this.dim; ++j) {
                    LTI[j] = valuesI[j - i];
                }
                myLT[i] = LTI;
            }
            if (this.rescaler != null) {
                DoubleMatrix1D UInv = this.F1.make(this.dim);
                for (int i = 0; i < this.dim; ++i) {
                    UInv.setQuick(i, 1.0 / this.U.getQuick(i));
                }
                this.LT = ColtUtils.diagonalMatrixMult(DoubleFactory2D.sparse.make(myLT), UInv);
            } else {
                this.LT = DoubleFactory2D.sparse.make(myLT);
            }
        }
        return this.LT;
    }
}

