/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.algebra;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import com.joptimizer.algebra.MatrixRescaler;
import com.joptimizer.util.ColtUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Matrix1NormRescaler
implements MatrixRescaler {
    private double eps = 0.001;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public Matrix1NormRescaler() {
    }

    public Matrix1NormRescaler(double eps) {
        this.eps = eps;
    }

    public DoubleMatrix1D[] getMatrixScalingFactors(DoubleMatrix2D A) {
        DoubleFactory1D F1 = DoubleFactory1D.dense;
        Algebra ALG = Algebra.DEFAULT;
        int r = A.rows();
        int c = A.columns();
        DoubleMatrix1D D1 = F1.make(r, 1.0);
        DoubleMatrix1D D2 = F1.make(c, 1.0);
        DoubleMatrix2D AK = A.copy();
        DoubleMatrix1D DR = F1.make(r, 1.0);
        DoubleMatrix1D DC = F1.make(c, 1.0);
        DoubleMatrix1D DRInv = F1.make(r);
        DoubleMatrix1D DCInv = F1.make(c);
        this.log.debug((Object)("eps  : " + this.eps));
        int maxIteration = 50;
        for (int k = 0; k <= maxIteration; ++k) {
            int j;
            int i;
            double normR = -1.7976931348623157E308;
            double normC = -1.7976931348623157E308;
            for (i = 0; i < r; ++i) {
                double dri = ALG.normInfinity(AK.viewRow(i));
                DR.setQuick(i, Math.sqrt(dri));
                DRInv.setQuick(i, 1.0 / Math.sqrt(dri));
                normR = Math.max(normR, Math.abs(1.0 - dri));
            }
            for (j = 0; j < c; ++j) {
                double dci = ALG.normInfinity(AK.viewColumn(j));
                DC.setQuick(j, Math.sqrt(dci));
                DCInv.setQuick(j, 1.0 / Math.sqrt(dci));
                normC = Math.max(normC, Math.abs(1.0 - dci));
            }
            this.log.debug((Object)("normR: " + normR));
            this.log.debug((Object)("normC: " + normC));
            if (normR < this.eps && normC < this.eps) break;
            for (i = 0; i < r; ++i) {
                double prevD1I = D1.getQuick(i);
                double newD1I = prevD1I * DRInv.getQuick(i);
                D1.setQuick(i, newD1I);
            }
            for (j = 0; j < c; ++j) {
                double prevD2J = D2.getQuick(j);
                double newD2J = prevD2J * DCInv.getQuick(j);
                D2.setQuick(j, newD2J);
            }
            if (k == maxIteration) {
                this.log.warn((Object)"max iteration reached");
            }
            AK = ColtUtils.diagonalMatrixMult(DRInv, AK, DCInv);
        }
        return new DoubleMatrix1D[]{D1, D2};
    }

    public DoubleMatrix1D getMatrixScalingFactorsSymm(DoubleMatrix2D A) {
        DoubleFactory1D F1 = DoubleFactory1D.dense;
        DoubleFactory2D F2 = DoubleFactory2D.sparse;
        int dim = A.columns();
        DoubleMatrix1D D1 = F1.make(dim, 1.0);
        DoubleMatrix2D AK = A.copy();
        DoubleMatrix2D DR = F2.identity(dim);
        DoubleMatrix1D DRInv = F1.make(dim);
        int maxIteration = 50;
        for (int k = 0; k <= maxIteration; ++k) {
            int i;
            double normR = -1.7976931348623157E308;
            for (i = 0; i < dim; ++i) {
                double dri = this.getRowInfinityNorm(AK, i);
                DR.setQuick(i, i, Math.sqrt(dri));
                DRInv.setQuick(i, 1.0 / Math.sqrt(dri));
                normR = Math.max(normR, Math.abs(1.0 - dri));
                if (!Double.isNaN(normR)) continue;
                throw new IllegalArgumentException("matrix is singular");
            }
            if (normR < this.eps) break;
            for (i = 0; i < dim; ++i) {
                double prevD1I = D1.getQuick(i);
                double newD1I = prevD1I * DRInv.getQuick(i);
                D1.setQuick(i, newD1I);
            }
            if (k == maxIteration) {
                this.log.warn((Object)"max iteration reached");
            }
            AK = ColtUtils.diagonalMatrixMult(DRInv, AK, DRInv);
        }
        return D1;
    }

    public boolean checkScaling(DoubleMatrix2D AOriginal, DoubleMatrix1D U, DoubleMatrix1D V) {
        DoubleMatrix2D P;
        int c = AOriginal.columns();
        int r = AOriginal.rows();
        final double[] maxValueHolder = new double[]{-1.7976931348623157E308};
        IntIntDoubleFunction myFunct = new IntIntDoubleFunction(){

            public double apply(int i, int j, double pij) {
                maxValueHolder[0] = Math.max(maxValueHolder[0], Math.abs(pij));
                return pij;
            }
        };
        DoubleMatrix2D AScaled = ColtUtils.diagonalMatrixMult(U, AOriginal, V);
        boolean isOk = true;
        for (int i = 0; isOk && i < r; ++i) {
            maxValueHolder[0] = -1.7976931348623157E308;
            P = AScaled.viewPart(i, 0, 1, c);
            P.forEachNonZero(myFunct);
            isOk = Math.abs(1.0 - maxValueHolder[0]) < this.eps;
        }
        for (int j = 0; isOk && j < c; ++j) {
            maxValueHolder[0] = -1.7976931348623157E308;
            P = AScaled.viewPart(0, j, r, 1);
            P.forEachNonZero(myFunct);
            isOk = Math.abs(1.0 - maxValueHolder[0]) < this.eps;
        }
        return isOk;
    }

    public double getRowInfinityNorm(DoubleMatrix2D ASymm, int r) {
        final double[] maxValueHolder = new double[]{-1.7976931348623157E308};
        IntIntDoubleFunction myFunct = new IntIntDoubleFunction(){

            public double apply(int i, int j, double pij) {
                maxValueHolder[0] = Math.max(maxValueHolder[0], Math.abs(pij));
                return pij;
            }
        };
        DoubleMatrix2D AR = ASymm.viewPart(r, 0, 1, r + 1);
        AR.forEachNonZero(myFunct);
        DoubleMatrix2D AC = ASymm.viewPart(r, r, ASymm.rows() - r, 1);
        AC.forEachNonZero(myFunct);
        return maxValueHolder[0];
    }
}

