/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import com.joptimizer.functions.ConvexMultivariateRealFunction;
import com.joptimizer.optimizers.OptimizationRequest;
import org.apache.commons.lang3.ArrayUtils;

public class LPOptimizationRequest
extends OptimizationRequest {
    private DoubleMatrix1D c;
    private DoubleMatrix2D G;
    private DoubleMatrix1D h;
    private DoubleMatrix1D lb;
    private DoubleMatrix1D ub;
    private DoubleMatrix1D ylb;
    private DoubleMatrix1D yub;
    private DoubleMatrix1D zlb;
    private DoubleMatrix1D zub;
    private boolean presolvingDisabled = false;
    private boolean avoidPresolvingIncreaseSparsity = false;
    private boolean avoidPresolvingFillIn = false;
    private boolean checkOptimalLagrangianBounds = false;
    private boolean dumpProblem = false;

    public DoubleMatrix1D getC() {
        return this.c;
    }

    public void setC(double[] c) {
        if (c != null) {
            this.setC(DoubleFactory1D.dense.make(c));
        }
    }

    public void setC(DoubleMatrix1D c) {
        this.c = c;
    }

    public DoubleMatrix2D getG() {
        return this.G;
    }

    public void setG(double[][] G) {
        if (G != null) {
            this.setG(DoubleFactory2D.dense.make(G));
        }
    }

    public void setG(DoubleMatrix2D G) {
        this.G = G;
    }

    public DoubleMatrix1D getH() {
        return this.h;
    }

    public void setH(double[] h) {
        if (h != null) {
            this.setH(DoubleFactory1D.dense.make(h));
        }
    }

    public void setH(DoubleMatrix1D h) {
        this.h = h;
    }

    public DoubleMatrix1D getLb() {
        return this.lb;
    }

    public void setLb(double[] lb) {
        if (lb != null) {
            this.setLb(DoubleFactory1D.dense.make(lb));
        }
    }

    public void setLb(DoubleMatrix1D lb) {
        for (int i = 0; i < lb.size(); ++i) {
            double lbi = lb.getQuick(i);
            if (!Double.isNaN(lbi) && !Double.isInfinite(lbi)) continue;
            throw new IllegalArgumentException("The lower bounds can not be set to Double.NaN or Double.INFINITY");
        }
        this.lb = lb;
    }

    public DoubleMatrix1D getUb() {
        return this.ub;
    }

    public void setUb(double[] ub) {
        if (ub != null) {
            this.setUb(DoubleFactory1D.dense.make(ub));
        }
    }

    public void setUb(DoubleMatrix1D ub) {
        for (int i = 0; i < ub.size(); ++i) {
            double ubi = ub.getQuick(i);
            if (!Double.isNaN(ubi) && !Double.isInfinite(ubi)) continue;
            throw new IllegalArgumentException("The upper bounds can not be set to Double.NaN or Double.INFINITY");
        }
        this.ub = ub;
    }

    public DoubleMatrix1D getYlb() {
        return this.ylb;
    }

    public void setYlb(double[] ylb) {
        if (ylb != null) {
            this.setYlb(DoubleFactory1D.dense.make(ylb));
        }
    }

    public void setYlb(DoubleMatrix1D ylb) {
        this.ylb = ylb;
    }

    public DoubleMatrix1D getYub() {
        return this.yub;
    }

    public void setYub(double[] yub) {
        if (yub != null) {
            this.setYub(DoubleFactory1D.dense.make(yub));
        }
    }

    public void setYub(DoubleMatrix1D yub) {
        this.yub = yub;
    }

    public DoubleMatrix1D getZlb() {
        return this.zlb;
    }

    public void setZlb(double[] zlb) {
        if (zlb != null) {
            this.setZlb(DoubleFactory1D.dense.make(zlb));
        }
    }

    public void setZlb(DoubleMatrix1D zlb) {
        this.zlb = zlb;
    }

    public DoubleMatrix1D getZub() {
        return this.zub;
    }

    public void setZub(double[] zub) {
        if (zub != null) {
            this.setZub(DoubleFactory1D.dense.make(zub));
        }
    }

    public void setZub(DoubleMatrix1D zub) {
        this.zub = zub;
    }

    public boolean isAvoidPresolvingIncreaseSparsity() {
        return this.avoidPresolvingIncreaseSparsity;
    }

    public void setAvoidPresolvingIncreaseSparsity(boolean avoidPresolvingIncreaseSparsity) {
        this.avoidPresolvingIncreaseSparsity = avoidPresolvingIncreaseSparsity;
    }

    public boolean isAvoidPresolvingFillIn() {
        return this.avoidPresolvingFillIn;
    }

    public void setAvoidPresolvingFillIn(boolean avoidPresolvingFillIn) {
        this.avoidPresolvingFillIn = avoidPresolvingFillIn;
    }

    public boolean isPresolvingDisabled() {
        return this.presolvingDisabled;
    }

    public void setPresolvingDisabled(boolean presolvingDisabled) {
        this.presolvingDisabled = presolvingDisabled;
    }

    public boolean isCheckOptimalLagrangianBounds() {
        return this.checkOptimalLagrangianBounds;
    }

    public void setCheckOptimalLagrangianBounds(boolean checkOptimalLagrangianBounds) {
        this.checkOptimalLagrangianBounds = checkOptimalLagrangianBounds;
    }

    public boolean isDumpProblem() {
        return this.dumpProblem;
    }

    public void setDumpProblem(boolean dumpProblem) {
        this.dumpProblem = dumpProblem;
    }

    public void setF0(ConvexMultivariateRealFunction f0) {
        throw new UnsupportedOperationException("Use the matrix formulation for this linear problem");
    }

    public void setFi(ConvexMultivariateRealFunction[] fi) {
        throw new UnsupportedOperationException("Use the matrix formulation for this linear problem");
    }

    public String toString() {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getClass().getName() + ": ");
            sb.append("\nmin(c) s.t.");
            if (this.getG() != null && this.getG().rows() > 0) {
                sb.append("\nG.x < h");
            }
            if (this.getA() != null && this.getA().rows() > 0) {
                sb.append("\nA.x = b");
            }
            if (this.getLb() != null && this.getUb() != null) {
                sb.append("\nlb <= x <= ub");
            } else if (this.getLb() != null) {
                sb.append("\nlb <= x");
            } else if (this.getUb() != null) {
                sb.append("\nx <= ub");
            }
            sb.append("\nc: " + ArrayUtils.toString((Object)this.c.toArray()));
            if (this.G != null) {
                sb.append("\nG: " + ArrayUtils.toString((Object)this.G.toArray()));
                sb.append("\nh: " + ArrayUtils.toString((Object)this.h.toArray()));
            }
            if (this.getA() != null) {
                sb.append("\nA: " + ArrayUtils.toString((Object)this.getA().toArray()));
                sb.append("\nb: " + ArrayUtils.toString((Object)this.getB().toArray()));
            }
            if (this.getLb() != null) {
                sb.append("\nlb: " + ArrayUtils.toString((Object)this.getLb().toArray()));
            }
            if (this.getUb() != null) {
                sb.append("\nub: " + ArrayUtils.toString((Object)this.getUb().toArray()));
            }
            if (this.getYlb() != null) {
                sb.append("\nylb: " + ArrayUtils.toString((Object)this.getYlb().toArray()));
            }
            if (this.getYub() != null) {
                sb.append("\nyub: " + ArrayUtils.toString((Object)this.getYub().toArray()));
            }
            if (this.getZlb() != null) {
                sb.append("\nzlb: " + ArrayUtils.toString((Object)this.getZlb().toArray()));
            }
            if (this.getZub() != null) {
                sb.append("\nzub: " + ArrayUtils.toString((Object)this.getZub().toArray()));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public LPOptimizationRequest cloneMe() {
        LPOptimizationRequest clonedLPRequest = new LPOptimizationRequest();
        clonedLPRequest.setToleranceFeas(this.getToleranceFeas());
        clonedLPRequest.setDumpProblem(this.isDumpProblem());
        clonedLPRequest.setPresolvingDisabled(this.isPresolvingDisabled());
        clonedLPRequest.setRescalingDisabled(this.isRescalingDisabled());
        clonedLPRequest.setAvoidPresolvingFillIn(this.isAvoidPresolvingFillIn());
        clonedLPRequest.setAvoidPresolvingIncreaseSparsity(this.isAvoidPresolvingIncreaseSparsity());
        clonedLPRequest.setCheckOptimalLagrangianBounds(this.isCheckOptimalLagrangianBounds());
        clonedLPRequest.setAlpha(this.getAlpha());
        clonedLPRequest.setBeta(this.getBeta());
        clonedLPRequest.setCheckKKTSolutionAccuracy(this.isCheckKKTSolutionAccuracy());
        clonedLPRequest.setToleranceKKT(this.getToleranceKKT());
        clonedLPRequest.setCheckProgressConditions(this.isCheckProgressConditions());
        clonedLPRequest.setMaxIteration(this.getMaxIteration());
        clonedLPRequest.setMu(this.getMu());
        clonedLPRequest.setTolerance(this.getTolerance());
        return clonedLPRequest;
    }
}

