/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.math.Mult;
import com.joptimizer.optimizers.BasicPhaseILPPDM;
import com.joptimizer.optimizers.LPOptimizationRequest;
import com.joptimizer.optimizers.LPOptimizationRequestHandler;
import com.joptimizer.optimizers.LPOptimizationResponse;
import com.joptimizer.optimizers.LPPresolver;
import com.joptimizer.optimizers.LPStandardConverter;
import com.joptimizer.solvers.KKTSolver;
import com.joptimizer.solvers.UpperDiagonalHKKTSolver;
import com.joptimizer.util.ColtUtils;
import com.joptimizer.util.Utils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LPPrimalDualMethod
extends LPOptimizationRequestHandler {
    public static final double DEFAULT_MIN_LOWER_BOUND = -99999.0;
    public static final double DEFAULT_MAX_UPPER_BOUND = 99999.0;
    private double minLBValue = -99999.0;
    private double maxUBValue = 99999.0;
    private DoubleMatrix1D limitedLb;
    private DoubleMatrix1D limitedUb;
    private KKTSolver kktSolver;
    private Log log = LogFactory.getLog((String)this.getClass().getName());

    public LPPrimalDualMethod() {
        this(-99999.0, 99999.0);
    }

    public LPPrimalDualMethod(double minLBValue, double maxUBValue) {
        if (Double.isNaN(minLBValue) || Double.isInfinite(minLBValue)) {
            throw new IllegalArgumentException("The field minLBValue must not be set to Double.NaN or Double.NEGATIVE_INFINITY");
        }
        if (Double.isNaN(maxUBValue) || Double.isInfinite(maxUBValue)) {
            throw new IllegalArgumentException("The field maxUBValue must not be set to Double.NaN or Double.POSITIVE_INFINITY");
        }
        this.minLBValue = minLBValue;
        this.maxUBValue = maxUBValue;
    }

    public int optimize() throws Exception {
        this.log.info((Object)"optimize");
        LPOptimizationRequest lpRequest = this.getLPOptimizationRequest();
        if (this.log.isDebugEnabled() && lpRequest.isDumpProblem()) {
            this.log.debug((Object)("LP problem: " + lpRequest.toString()));
        }
        LPStandardConverter lpConverter = new LPStandardConverter();
        lpConverter.toStandardForm(this.getC(), this.getG(), this.getH(), this.getA(), this.getB(), this.getLb(), this.getUb());
        int nOfSlackVariables = lpConverter.getStandardS();
        this.log.debug((Object)("nOfSlackVariables: " + nOfSlackVariables));
        DoubleMatrix1D standardC = lpConverter.getStandardC();
        DoubleMatrix2D standardA = lpConverter.getStandardA();
        DoubleMatrix1D standardB = lpConverter.getStandardB();
        DoubleMatrix1D standardLb = lpConverter.getStandardLB();
        DoubleMatrix1D standardUb = lpConverter.getStandardUB();
        LPOptimizationRequest standardLPRequest = lpRequest.cloneMe();
        standardLPRequest.setC(standardC);
        standardLPRequest.setA(standardA);
        standardLPRequest.setB(standardB);
        standardLPRequest.setLb(ColtUtils.replaceValues(standardLb, lpConverter.getUnboundedLBValue(), this.minLBValue));
        standardLPRequest.setUb(ColtUtils.replaceValues(standardUb, lpConverter.getUnboundedUBValue(), this.maxUBValue));
        if (this.getInitialPoint() != null) {
            standardLPRequest.setInitialPoint(lpConverter.getStandardComponents(this.getInitialPoint().toArray()));
        }
        if (this.getNotFeasibleInitialPoint() != null) {
            standardLPRequest.setNotFeasibleInitialPoint(lpConverter.getStandardComponents(this.getNotFeasibleInitialPoint().toArray()));
        }
        LPPrimalDualMethod opt = new LPPrimalDualMethod(this.minLBValue, this.maxUBValue);
        opt.setLPOptimizationRequest(standardLPRequest);
        if (opt.optimizeStandardLP(nOfSlackVariables) == 2) {
            return 2;
        }
        LPOptimizationResponse lpResponse = opt.getLPOptimizationResponse();
        double[] standardSolution = lpResponse.getSolution();
        double[] originalSol = lpConverter.postConvert(standardSolution);
        lpResponse.setSolution(originalSol);
        this.setLPOptimizationResponse(lpResponse);
        return lpResponse.getReturnCode();
    }

    protected int optimizeStandardLP(int nOfSlackVariables) throws Exception {
        LPOptimizationResponse lpResponse;
        this.log.info((Object)"optimizeStandardLP");
        LPOptimizationRequest lpRequest = this.getLPOptimizationRequest();
        if (this.log.isDebugEnabled() && lpRequest.isDumpProblem()) {
            this.log.debug((Object)("LP problem: " + lpRequest.toString()));
        }
        if (lpRequest.isPresolvingDisabled()) {
            LPPrimalDualMethod opt = new LPPrimalDualMethod(this.minLBValue, this.maxUBValue);
            opt.setLPOptimizationRequest(lpRequest);
            if (opt.optimizePresolvedStandardLP() == 2) {
                return 2;
            }
            lpResponse = opt.getLPOptimizationResponse();
            this.setLPOptimizationResponse(lpResponse);
        } else {
            LPPresolver lpPresolver = new LPPresolver();
            lpPresolver.setAvoidScaling(lpRequest.isRescalingDisabled());
            lpPresolver.setAvoidFillIn(lpRequest.isAvoidPresolvingFillIn());
            lpPresolver.setAvoidIncreaseSparsity(lpRequest.isAvoidPresolvingIncreaseSparsity());
            lpPresolver.setNOfSlackVariables((short)nOfSlackVariables);
            lpPresolver.presolve(this.getC(), this.getA(), this.getB(), this.getLb(), this.getUb());
            int presolvedDim = lpPresolver.getPresolvedN();
            if (presolvedDim == 0) {
                this.log.debug((Object)("presolvedDim : " + presolvedDim));
                this.log.debug((Object)"deterministic LP problem");
                lpResponse = new LPOptimizationResponse();
                lpResponse.setReturnCode(0);
                lpResponse.setSolution(new double[0]);
            } else {
                DoubleMatrix1D presolvedC = lpPresolver.getPresolvedC();
                DoubleMatrix2D presolvedA = lpPresolver.getPresolvedA();
                DoubleMatrix1D presolvedB = lpPresolver.getPresolvedB();
                if (this.log.isDebugEnabled()) {
                    if (lpPresolver.getPresolvedYlb() != null) {
                        this.log.debug((Object)("Ylb: " + ArrayUtils.toString((Object)lpPresolver.getPresolvedYlb().toArray())));
                        this.log.debug((Object)("Yub: " + ArrayUtils.toString((Object)lpPresolver.getPresolvedYub().toArray())));
                    }
                    if (lpPresolver.getPresolvedZlb() != null) {
                        this.log.debug((Object)("Zlb: " + ArrayUtils.toString((Object)lpPresolver.getPresolvedZlb().toArray())));
                        this.log.debug((Object)("Zub: " + ArrayUtils.toString((Object)lpPresolver.getPresolvedZub().toArray())));
                    }
                }
                LPOptimizationRequest presolvedLPRequest = lpRequest.cloneMe();
                presolvedLPRequest.setC(presolvedC);
                presolvedLPRequest.setA(presolvedA);
                presolvedLPRequest.setB(presolvedB);
                presolvedLPRequest.setLb(lpPresolver.getPresolvedLB());
                presolvedLPRequest.setUb(lpPresolver.getPresolvedUB());
                presolvedLPRequest.setYlb(lpPresolver.getPresolvedYlb());
                presolvedLPRequest.setYub(lpPresolver.getPresolvedYub());
                presolvedLPRequest.setZlb(lpPresolver.getPresolvedZlb());
                presolvedLPRequest.setZub(lpPresolver.getPresolvedZub());
                if (this.getInitialPoint() != null) {
                    presolvedLPRequest.setInitialPoint(lpPresolver.presolve(this.getInitialPoint().toArray()));
                }
                if (this.getNotFeasibleInitialPoint() != null) {
                    presolvedLPRequest.setNotFeasibleInitialPoint(lpPresolver.presolve(this.getNotFeasibleInitialPoint().toArray()));
                }
                double rescaledMinLBValue = Double.isNaN(lpPresolver.getMinRescaledLB()) ? this.minLBValue : lpPresolver.getMinRescaledLB();
                double rescaledMaxUBValue = Double.isNaN(lpPresolver.getMaxRescaledUB()) ? this.maxUBValue : lpPresolver.getMaxRescaledUB();
                LPPrimalDualMethod opt = new LPPrimalDualMethod(rescaledMinLBValue, rescaledMaxUBValue);
                opt.setLPOptimizationRequest(presolvedLPRequest);
                if (opt.optimizePresolvedStandardLP() == 2) {
                    return 2;
                }
                lpResponse = opt.getLPOptimizationResponse();
            }
            double[] postsolvedSolution = lpPresolver.postsolve(lpResponse.getSolution());
            lpResponse.setSolution(postsolvedSolution);
            this.setLPOptimizationResponse(lpResponse);
        }
        return lpResponse.getReturnCode();
    }

    protected int optimizePresolvedStandardLP() throws Exception {
        DoubleMatrix1D L0;
        this.log.info((Object)"optimizePresolvedStandardLP");
        long tStart = System.currentTimeMillis();
        LPOptimizationRequest lpRequest = this.getLPOptimizationRequest();
        if (this.log.isDebugEnabled() && lpRequest.isDumpProblem()) {
            this.log.debug((Object)("LP problem: " + lpRequest.toString()));
        }
        if (this.dim <= -1) {
            if (this.getLb().size() != this.getUb().size()) {
                this.log.error((Object)"Lower and upper bounds must have the same dimension");
                throw new IllegalArgumentException("Lower and upper bounds must have the same dimension");
            }
            this.dim = this.getLb().size();
            double minDeltaBoundsValue = Double.MAX_VALUE;
            int minDeltaBoundsIndex = -1;
            for (int i = 0; i < this.getDim(); ++i) {
                double deltai = this.getUb().getQuick(i) - this.getLb().getQuick(i);
                if (!(deltai < minDeltaBoundsValue)) continue;
                minDeltaBoundsValue = deltai;
                minDeltaBoundsIndex = i;
            }
            this.log.info((Object)("min delta bounds index: " + minDeltaBoundsIndex));
            this.log.info((Object)("min delta bounds value: " + minDeltaBoundsValue));
        }
        this.meq = this.meq > -1 ? this.meq : (this.getA() != null ? this.getA().rows() : 0);
        int n = this.mieq = this.mieq > -1 ? this.mieq : 2 * this.getDim();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("dim : " + this.getDim()));
            this.log.debug((Object)("meq : " + this.getMeq()));
            this.log.debug((Object)("mieq: " + this.getMieq()));
        }
        LPOptimizationResponse lpResponse = new LPOptimizationResponse();
        DoubleMatrix1D X0 = this.getInitialPoint();
        if (X0 == null) {
            DoubleMatrix1D X0NF = this.getNotFeasibleInitialPoint();
            if (X0NF != null) {
                double rPriX0NFNorm = Math.sqrt(this.ALG.norm2(this.rPri(X0NF)));
                DoubleMatrix1D fiX0NF = this.getFi(X0NF);
                int maxIndex = Utils.getMaxIndex(fiX0NF);
                double maxValue = fiX0NF.get(maxIndex);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("rPriX0NFNorm :  " + rPriX0NFNorm));
                    this.log.debug((Object)("X0NF         :  " + ArrayUtils.toString((Object)X0NF.toArray())));
                    this.log.debug((Object)("fiX0NF       :  " + ArrayUtils.toString((Object)fiX0NF.toArray())));
                }
                if (maxValue < 0.0 && rPriX0NFNorm <= this.getToleranceFeas()) {
                    this.log.debug((Object)"the provided initial point is already feasible");
                    X0 = X0NF;
                }
            }
            if (X0 == null) {
                BasicPhaseILPPDM bf1 = new BasicPhaseILPPDM(this);
                X0 = bf1.findFeasibleInitialPoint();
            }
        }
        DoubleMatrix1D fiX0 = this.getFi(X0);
        int maxIndex = Utils.getMaxIndex(fiX0);
        double maxValue = fiX0.get(maxIndex);
        double rPriX0Norm = Math.sqrt(this.ALG.norm2(this.rPri(X0)));
        if (maxValue >= 0.0 || rPriX0Norm > this.getToleranceFeas()) {
            this.log.warn((Object)("rPriX0Norm  : " + rPriX0Norm));
            this.log.warn((Object)("ineqX0      : " + ArrayUtils.toString((Object)fiX0.toArray())));
            this.log.warn((Object)("max ineq index: " + maxIndex));
            this.log.warn((Object)("max ineq value: " + maxValue));
            throw new Exception("initial point must be strictly feasible");
        }
        DoubleMatrix1D V0 = this.F1.make(this.getMeq());
        if (this.getYlb() != null && this.getYub() != null) {
            for (int i = 0; i < this.getMeq(); ++i) {
                double v0i = 0.0;
                v0i = !this.isLbUnbounded(this.getYlb().getQuick(i)) ? (!this.isUbUnbounded(this.getYub().getQuick(i)) ? -(this.getYub().getQuick(i) + this.getYlb().getQuick(i)) / 2.0 : -this.getYlb().getQuick(i)) : (!this.isUbUnbounded(this.getYub().getQuick(i)) ? -this.getYub().getQuick(i) : 0.0);
                V0.setQuick(i, v0i);
            }
        }
        if ((L0 = this.getInitialLagrangian()) != null) {
            for (int j = 0; j < L0.size(); ++j) {
                if (!(L0.get(j) <= 0.0)) continue;
                throw new IllegalArgumentException("initial lagrangian must be strictly > 0");
            }
        } else {
            L0 = this.F1.make(this.getMieq(), 1.0);
            if (this.getZlb() != null && this.getZub() != null) {
                int cntLB = 0;
                int cntUB = 0;
                for (int i = 0; i < this.getDim(); ++i) {
                    double zlbi = this.isLbUnbounded(this.getZlb().getQuick(i)) ? 0.0 : this.getZlb().getQuick(i);
                    double zubi = this.isUbUnbounded(this.getZub().getQuick(i)) ? 1.0 : this.getZub().getQuick(i);
                    L0.setQuick(cntLB, (zubi - zlbi) / 2.0);
                    ++cntLB;
                    L0.setQuick(this.getDim() + cntUB, (zubi - zlbi) / 2.0);
                    ++cntUB;
                }
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("X0:  " + ArrayUtils.toString((Object)X0.toArray())));
            this.log.debug((Object)("V0:  " + ArrayUtils.toString((Object)V0.toArray())));
            this.log.debug((Object)("L0:  " + ArrayUtils.toString((Object)L0.toArray())));
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("toleranceFeas:  " + this.getToleranceFeas()));
            this.log.info((Object)("tolerance    :  " + this.getTolerance()));
        }
        DoubleMatrix1D X = X0;
        DoubleMatrix1D V = V0;
        DoubleMatrix1D L = L0;
        double previousF0X = Double.NaN;
        double previousRPriXNorm = Double.NaN;
        double previousRDualXLVNorm = Double.NaN;
        double previousSurrDG = Double.NaN;
        int iteration = 0;
        while (true) {
            DoubleMatrix1D stepV;
            if (++iteration == this.getMaxIteration() + 1) {
                lpResponse.setReturnCode(2);
                this.log.error((Object)"Max iterations limit reached");
                throw new Exception("Max iterations limit reached");
            }
            double F0X = this.getF0(X);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("iteration: " + iteration));
                this.log.info((Object)("f0(X)=" + F0X));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("X=" + ArrayUtils.toString((Object)X.toArray())));
                this.log.debug((Object)("L=" + ArrayUtils.toString((Object)L.toArray())));
                this.log.debug((Object)("V=" + ArrayUtils.toString((Object)V.toArray())));
            }
            DoubleMatrix1D gradF0X = this.getGradF0(X);
            DoubleMatrix1D fiX = this.getFi(X);
            this.log.debug((Object)("fiX=" + ArrayUtils.toString((Object)fiX.toArray())));
            double surrDG = this.getSurrogateDualityGap(fiX, L);
            double t = this.getMu() * (double)this.getMieq() / surrDG;
            this.log.debug((Object)("t:  " + t));
            DoubleMatrix1D rPriX = this.rPri(X);
            DoubleMatrix1D rCentXLt = this.rCent(fiX, L, t);
            DoubleMatrix1D rDualXLV = this.rDual(gradF0X, L, V);
            double rPriXNorm = Math.sqrt(this.ALG.norm2(rPriX));
            double rCentXLtNorm = Math.sqrt(this.ALG.norm2(rCentXLt));
            double rDualXLVNorm = Math.sqrt(this.ALG.norm2(rDualXLV));
            double normRXLVt = Math.sqrt(Math.pow(rPriXNorm, 2.0) + Math.pow(rCentXLtNorm, 2.0) + Math.pow(rDualXLVNorm, 2.0));
            this.log.info((Object)("rPri  norm: " + rPriXNorm));
            this.log.info((Object)("rCent norm: " + rCentXLtNorm));
            this.log.info((Object)("rDual norm: " + rDualXLVNorm));
            this.log.info((Object)("surrDG    : " + surrDG));
            if (this.checkCustomExitConditions(X)) {
                lpResponse.setReturnCode(0);
                break;
            }
            if (rPriXNorm <= this.getToleranceFeas() && rDualXLVNorm <= this.getToleranceFeas() && surrDG <= this.getTolerance()) {
                lpResponse.setReturnCode(0);
                break;
            }
            if (this.isCheckProgressConditions()) {
                if (!Double.isNaN(previousRPriXNorm) && !Double.isNaN(previousRDualXLVNorm) && !Double.isNaN(previousSurrDG) && (previousRPriXNorm <= rPriXNorm && rPriXNorm >= this.getToleranceFeas() || previousRDualXLVNorm <= rDualXLVNorm && rDualXLVNorm >= this.getToleranceFeas())) {
                    this.log.error((Object)"No progress achieved, exit iterations loop without desired accuracy");
                    lpResponse.setReturnCode(2);
                    throw new Exception("No progress achieved, exit iterations loop without desired accuracy");
                }
                previousRPriXNorm = rPriXNorm;
                previousRDualXLVNorm = rDualXLVNorm;
                previousSurrDG = surrDG;
            }
            DoubleMatrix2D Hpd = this.GradLSum(L, fiX);
            DoubleMatrix1D gradSum = this.gradSum(t, fiX);
            DoubleMatrix1D g = null;
            g = this.getA() == null ? ColtUtils.add(gradF0X, gradSum) : ColtUtils.add(ColtUtils.add(gradF0X, gradSum), ColtUtils.zMultTranspose(this.getA(), V, this.F1.make(this.getDim()), 0.0));
            if (this.kktSolver == null) {
                this.kktSolver = new UpperDiagonalHKKTSolver(this.getDim(), lpRequest.isRescalingDisabled());
            }
            if (this.isCheckKKTSolutionAccuracy()) {
                this.kktSolver.setCheckKKTSolutionAccuracy(true);
                this.kktSolver.setToleranceKKT(this.getToleranceKKT());
            }
            this.kktSolver.setHMatrix(Hpd);
            this.kktSolver.setGVector(g);
            if (this.getA() != null) {
                this.kktSolver.setAMatrix(this.getA());
                this.kktSolver.setHVector(rPriX);
            }
            DoubleMatrix1D[] sol = this.kktSolver.solve();
            DoubleMatrix1D stepX = sol[0];
            DoubleMatrix1D doubleMatrix1D = stepV = sol[1] != null ? sol[1] : this.F1.make(0);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("stepX: " + ArrayUtils.toString((Object)stepX.toArray())));
                this.log.debug((Object)("stepV: " + ArrayUtils.toString((Object)stepV.toArray())));
            }
            DoubleMatrix1D stepL = this.F1.make(this.getMieq());
            DoubleMatrix1D gradFiStepX = this.gradFiStepX(stepX);
            for (int i = 0; i < this.getMieq(); ++i) {
                stepL.setQuick(i, (-L.getQuick(i) * gradFiStepX.getQuick(i) + rCentXLt.getQuick(i)) / fiX.getQuick(i));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("stepL: " + ArrayUtils.toString((Object)stepL.toArray())));
            }
            double sMax = Double.MAX_VALUE;
            for (int j = 0; j < this.getMieq(); ++j) {
                if (!(stepL.get(j) < 0.0)) continue;
                sMax = Math.min(-L.get(j) / stepL.get(j), sMax);
            }
            sMax = Math.min(1.0, sMax);
            double s = 0.99 * sMax;
            DoubleMatrix1D X1 = this.F1.make(X.size());
            DoubleMatrix1D L1 = this.F1.make(L.size());
            DoubleMatrix1D V1 = this.F1.make(V.size());
            DoubleMatrix1D fiX1 = null;
            DoubleMatrix1D gradF0X1 = null;
            DoubleMatrix1D rPriX1 = null;
            DoubleMatrix1D rCentX1L1t = null;
            DoubleMatrix1D rDualX1L1V1 = null;
            int cnt = 0;
            boolean areAllNegative = true;
            while (cnt < 500) {
                ++cnt;
                X1 = stepX.copy().assign(Mult.mult(s)).assign(X, Functions.plus);
                DoubleMatrix1D ineqValueX1 = this.getFi(X1);
                areAllNegative = true;
                for (int j = 0; areAllNegative && j < this.getMieq(); ++j) {
                    areAllNegative = Double.compare(ineqValueX1.get(j), 0.0) < 0;
                }
                if (areAllNegative) break;
                s = this.getBeta() * s;
            }
            if (!areAllNegative) {
                throw new Exception("Optimization failed: impossible to remain within the faesible region");
            }
            this.log.debug((Object)("s: " + s));
            double previousNormRX1L1V1t = Double.NaN;
            cnt = 0;
            while (cnt < 500) {
                ++cnt;
                X1 = ColtUtils.add(X, stepX, s);
                L1 = ColtUtils.add(L, stepL, s);
                V1 = ColtUtils.add(V, stepV, s);
                if (this.isInDomainF0(X1)) {
                    fiX1 = this.getFi(X1);
                    gradF0X1 = this.getGradF0(X1);
                    rPriX1 = this.rPri(X1);
                    rCentX1L1t = this.rCent(fiX1, L1, t);
                    rDualX1L1V1 = this.rDual(gradF0X1, L1, V1);
                    double normRX1L1V1t = Math.sqrt(this.ALG.norm2(rPriX1) + this.ALG.norm2(rCentX1L1t) + this.ALG.norm2(rDualX1L1V1));
                    if (normRX1L1V1t <= (1.0 - this.getAlpha() * s) * normRXLVt) break;
                    if (!Double.isNaN(previousNormRX1L1V1t) && previousNormRX1L1V1t <= normRX1L1V1t) {
                        this.log.warn((Object)"No progress achieved in backtracking with norm");
                        break;
                    }
                    previousNormRX1L1V1t = normRX1L1V1t;
                }
                s = this.getBeta() * s;
            }
            X = X1;
            V = V1;
            L = L1;
        }
        if (lpRequest.isCheckOptimalLagrangianBounds()) {
            // empty if block
        }
        long tStop = System.currentTimeMillis();
        this.log.debug((Object)("time: " + (tStop - tStart)));
        this.log.debug((Object)("sol : " + ArrayUtils.toString((Object)X.toArray())));
        this.log.debug((Object)("ret code: " + lpResponse.getReturnCode()));
        lpResponse.setSolution(X.toArray());
        this.setLPOptimizationResponse(lpResponse);
        return lpResponse.getReturnCode();
    }

    protected DoubleMatrix1D gradSum(double t, DoubleMatrix1D fiX) {
        DoubleMatrix1D gradSum = this.F1.make(this.getDim());
        for (int i = 0; i < this.dim; ++i) {
            double d = 0.0;
            d += 1.0 / (t * fiX.getQuick(i));
            gradSum.setQuick(i, d += -1.0 / (t * fiX.getQuick(this.getDim() + i)));
        }
        return gradSum;
    }

    protected DoubleMatrix2D GradLSum(DoubleMatrix1D L, DoubleMatrix1D fiX) {
        SparseDoubleMatrix2D GradLSum = new SparseDoubleMatrix2D(this.getDim(), this.getDim(), this.getDim(), 0.001, 0.01);
        for (int i = 0; i < this.getDim(); ++i) {
            double d = 0.0;
            d -= L.getQuick(i) / fiX.getQuick(i);
            GradLSum.setQuick(i, i, d -= L.getQuick(this.getDim() + i) / fiX.getQuick(this.getDim() + i));
        }
        return GradLSum;
    }

    protected DoubleMatrix1D gradFiStepX(DoubleMatrix1D stepX) {
        DoubleMatrix1D ret = this.F1.make(this.getMieq());
        for (int i = 0; i < this.getDim(); ++i) {
            ret.setQuick(i, -stepX.getQuick(i));
            ret.setQuick(this.getDim() + i, stepX.getQuick(i));
        }
        return ret;
    }

    private double getSurrogateDualityGap(DoubleMatrix1D fiX, DoubleMatrix1D L) {
        return -this.ALG.mult(fiX, L);
    }

    protected DoubleMatrix1D rDual(DoubleMatrix1D gradF0X, DoubleMatrix1D L, DoubleMatrix1D V) {
        DoubleMatrix1D m1 = this.F1.make(this.getDim());
        for (int i = 0; i < this.getDim(); ++i) {
            double m = 0.0;
            m += -L.getQuick(i);
            m1.setQuick(i, (m += L.getQuick(this.getDim() + i)) + gradF0X.get(i));
        }
        if (this.getMeq() == 0) {
            return m1;
        }
        return ColtUtils.zMultTranspose(this.getA(), V, m1, 1.0);
    }

    private DoubleMatrix1D rCent(DoubleMatrix1D fiX, DoubleMatrix1D L, double t) {
        DoubleMatrix1D ret = this.F1.make(L.size());
        for (int i = 0; i < ret.size(); ++i) {
            ret.setQuick(i, -L.getQuick(i) * fiX.getQuick(i) - 1.0 / t);
        }
        return ret;
    }

    public void setKKTSolver(KKTSolver kktSolver) {
        this.kktSolver = kktSolver;
    }

    protected double getF0(DoubleMatrix1D X) {
        return this.getC().zDotProduct(X);
    }

    protected DoubleMatrix1D getGradF0(DoubleMatrix1D X) {
        return this.getC();
    }

    protected DoubleMatrix2D getHessF0(DoubleMatrix1D X) {
        throw new RuntimeException("Hessians are null for LP");
    }

    protected DoubleMatrix1D getFi(DoubleMatrix1D X) {
        double[] ret = new double[this.getMieq()];
        for (int i = 0; i < this.getDim(); ++i) {
            ret[i] = -X.getQuick(i) + this.getLb().getQuick(i);
            ret[this.getDim() + i] = X.getQuick(i) - this.getUb().getQuick(i);
        }
        return this.F1.make(ret);
    }

    protected DoubleMatrix2D getGradFi(DoubleMatrix1D X) {
        throw new RuntimeException("GradFi are not used for LP");
    }

    protected DoubleMatrix2D[] getHessFi(DoubleMatrix1D X) {
        throw new RuntimeException("Hessians are null for LP");
    }

    protected DoubleMatrix1D rPri(DoubleMatrix1D X) {
        if (this.getMeq() == 0) {
            return this.F1.make(0);
        }
        return ColtUtils.zMult(this.getA(), X, this.getB(), -1.0);
    }

    protected boolean isInDomainF0(DoubleMatrix1D X) {
        return true;
    }

    protected DoubleMatrix1D getLb() {
        if (this.limitedLb == null) {
            if (super.getLb() == null) {
                this.limitedLb = this.F1.make(this.getC().size(), this.minLBValue);
            } else {
                this.limitedLb = this.F1.make(super.getLb().size());
                for (int i = 0; i < super.getLb().size(); ++i) {
                    double lbi = super.getLb().getQuick(i);
                    if (lbi < this.minLBValue) {
                        this.log.warn((Object)("the " + i + "-th lower bound was limited from " + lbi + " to the value of minLBValue: " + this.minLBValue));
                        this.limitedLb.setQuick(i, this.minLBValue);
                        continue;
                    }
                    this.limitedLb.setQuick(i, lbi);
                }
            }
        }
        return this.limitedLb;
    }

    protected DoubleMatrix1D getUb() {
        if (this.limitedUb == null) {
            if (super.getUb() == null) {
                this.limitedUb = this.F1.make(this.getC().size(), this.maxUBValue);
            } else {
                this.limitedUb = this.F1.make(super.getUb().size());
                for (int i = 0; i < super.getUb().size(); ++i) {
                    double ubi = super.getUb().getQuick(i);
                    if (this.maxUBValue < ubi) {
                        this.log.warn((Object)("the " + i + "-th upper bound was limited form " + ubi + " to the value of maxUBValue: " + this.maxUBValue));
                        this.limitedUb.setQuick(i, this.maxUBValue);
                        continue;
                    }
                    this.limitedUb.setQuick(i, ubi);
                }
            }
        }
        return this.limitedUb;
    }

    protected boolean isLbUnbounded(Double lb) {
        return Double.isNaN(lb);
    }

    protected boolean isUbUnbounded(Double ub) {
        return Double.isNaN(ub);
    }
}

