/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.optimizers;

import cern.colt.function.IntIntDoubleFunction;
import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import com.joptimizer.util.ColtUtils;
import java.util.ArrayList;
import java.util.List;

public class LPStandardConverter {
    public static final double DEFAULT_UNBOUNDED_LOWER_BOUND = Double.NaN;
    public static final double DEFAULT_UNBOUNDED_UPPER_BOUND = Double.NaN;
    private boolean useSparsity = true;
    private int originalN;
    private int standardN;
    private int standardS;
    private DoubleMatrix1D standardC;
    private DoubleMatrix2D standardA;
    private DoubleMatrix1D standardB;
    private DoubleMatrix1D standardLB;
    private DoubleMatrix1D standardUB;
    private List<Integer> splittedVariablesList = new ArrayList<Integer>();
    private boolean[] lbSlack;
    private boolean[] ubSlack;
    private double unboundedLBValue = Double.NaN;
    private double unboundedUBValue = Double.NaN;
    private boolean strictlyStandardForm = false;
    private Algebra ALG = Algebra.DEFAULT;
    private DoubleFactory1D F1 = null;
    private DoubleFactory2D F2 = null;

    public LPStandardConverter() {
        this(false);
    }

    public LPStandardConverter(boolean strictlyStandardForm) {
        this(strictlyStandardForm, Double.NaN, Double.NaN);
    }

    public LPStandardConverter(double unboundedLBValue, double unboundedUBValue) {
        this(false, unboundedLBValue, unboundedUBValue);
    }

    public LPStandardConverter(boolean strictlyStandardForm, double unboundedLBValue, double unboundedUBValue) {
        if (!Double.isNaN(unboundedLBValue) && !Double.isInfinite(unboundedLBValue)) {
            throw new IllegalArgumentException("The field unboundedLBValue must be set to Double.NaN or Double.NEGATIVE_INFINITY");
        }
        if (!Double.isNaN(unboundedUBValue) && !Double.isInfinite(unboundedUBValue)) {
            throw new IllegalArgumentException("The field unboundedUBValue must be set to Double.NaN or Double.POSITIVE_INFINITY");
        }
        this.strictlyStandardForm = strictlyStandardForm;
        this.unboundedLBValue = unboundedLBValue;
        this.unboundedUBValue = unboundedUBValue;
    }

    public boolean isUseSparsity() {
        return this.useSparsity;
    }

    public void setUseSparsity(boolean useSparsity) {
        this.useSparsity = useSparsity;
    }

    public void toStandardForm(double[] originalC, double[][] originalG, double[] originalH, double[][] originalA, double[] originalB, double[] originalLB, double[] originalUB) {
        this.F1 = this.useSparsity ? DoubleFactory1D.sparse : DoubleFactory1D.dense;
        this.F2 = this.useSparsity ? DoubleFactory2D.sparse : DoubleFactory2D.dense;
        DoubleMatrix1D cVector = this.F1.make(originalC);
        DoubleMatrix2D GMatrix = null;
        DoubleMatrix1D hVector = null;
        if (originalG != null) {
            GMatrix = this.F2.make(originalG);
            hVector = this.F1.make(originalH);
        }
        DoubleMatrix2D AMatrix = null;
        DoubleMatrix1D bVector = null;
        if (originalA != null) {
            AMatrix = this.F2.make(originalA);
            bVector = this.F1.make(originalB);
        }
        if (originalLB != null && originalUB != null && originalLB.length != originalUB.length) {
            throw new IllegalArgumentException("lower and upper bounds have different lenght");
        }
        DoubleMatrix1D lbVector = originalLB != null ? this.F1.make(originalLB) : null;
        DoubleMatrix1D ubVector = originalUB != null ? this.F1.make(originalUB) : null;
        this.toStandardForm(cVector, GMatrix, hVector, AMatrix, bVector, lbVector, ubVector);
    }

    public void toStandardForm(DoubleMatrix1D originalC, DoubleMatrix2D originalG, DoubleMatrix1D originalH, DoubleMatrix2D originalA, DoubleMatrix1D originalB, DoubleMatrix1D originalLB, DoubleMatrix1D originalUB) {
        int i;
        this.F1 = this.useSparsity ? DoubleFactory1D.sparse : DoubleFactory1D.dense;
        this.F2 = this.useSparsity ? DoubleFactory2D.sparse : DoubleFactory2D.dense;
        this.originalN = originalC.size();
        if (originalLB != null && originalUB != null && originalLB.size() != originalUB.size()) {
            throw new IllegalArgumentException("lower and upper bounds have different size");
        }
        if (originalLB == null) {
            originalLB = this.F1.make(this.originalN, this.unboundedLBValue);
        }
        if (originalUB == null) {
            originalUB = this.F1.make(this.originalN, this.unboundedUBValue);
        }
        if (originalG == null && !this.strictlyStandardForm) {
            this.standardN = this.originalN;
            this.standardA = originalA;
            this.standardB = originalB;
            this.standardC = originalC;
            this.standardLB = originalLB;
            this.standardUB = originalUB;
            return;
        }
        int nOfSlackG = originalG != null ? originalG.rows() : 0;
        int nOfSlackUB = 0;
        int nOfSplittedVariables = 0;
        int nOfSlackLB = 0;
        this.lbSlack = new boolean[this.originalN];
        this.ubSlack = new boolean[this.originalN];
        if (this.strictlyStandardForm) {
            for (i = 0; i < this.originalN; ++i) {
                double lbi = originalLB.getQuick(i);
                double ubi = originalUB.getQuick(i);
                if (this.isLbUnbounded(lbi)) {
                    this.splittedVariablesList.add(this.splittedVariablesList.size(), i);
                } else {
                    int lbCompare = Double.compare(lbi, 0.0);
                    if (lbCompare < 0) {
                        ++nOfSlackLB;
                        this.lbSlack[i] = true;
                        this.splittedVariablesList.add(this.splittedVariablesList.size(), i);
                    } else if (lbCompare > 0) {
                        ++nOfSlackLB;
                        this.lbSlack[i] = true;
                    }
                }
                if (this.isUbUnbounded(ubi)) continue;
                ++nOfSlackUB;
                this.ubSlack[i] = true;
            }
            nOfSplittedVariables = this.splittedVariablesList.size();
        }
        this.standardS = nOfSlackG + nOfSlackUB + nOfSlackLB;
        this.standardN = this.standardS + this.originalN + nOfSplittedVariables;
        if (this.standardS == 0 && nOfSplittedVariables == 0) {
            this.standardA = originalA;
            this.standardB = originalB;
            this.standardC = originalC;
            this.standardLB = originalLB;
            this.standardUB = originalUB;
        } else {
            int i2;
            int i3;
            if (originalA != null) {
                this.standardA = this.F2.make(this.standardS + originalA.rows(), this.standardN);
                this.standardB = this.F1.make(this.standardS + originalB.size());
            } else {
                this.standardA = this.F2.make(this.standardS, this.standardN);
                this.standardB = this.F1.make(this.standardS);
            }
            for (i = 0; i < nOfSlackG; ++i) {
                this.standardA.set(i, i, 1.0);
                this.standardB.setQuick(i, originalH.getQuick(i));
            }
            if (originalG instanceof SparseDoubleMatrix2D) {
                originalG.forEachNonZero(new IntIntDoubleFunction(){

                    public double apply(int i, int j, double gij) {
                        LPStandardConverter.this.standardA.set(i, LPStandardConverter.this.standardS + j, gij);
                        return gij;
                    }
                });
            } else {
                for (i = 0; i < nOfSlackG; ++i) {
                    for (int j = 0; j < this.originalN; ++j) {
                        this.standardA.set(i, this.standardS + j, originalG.getQuick(i, j));
                    }
                }
            }
            int cntSlackLB = 0;
            int cntSlackUB = 0;
            for (i3 = 0; i3 < this.originalN; ++i3) {
                if (this.lbSlack[i3]) {
                    this.standardA.set(nOfSlackG + cntSlackLB, nOfSlackG + cntSlackLB, 1.0);
                    this.standardA.set(nOfSlackG + cntSlackLB, this.standardS + i3, -1.0);
                    this.standardB.setQuick(nOfSlackG + cntSlackLB, -originalLB.getQuick(i3));
                    ++cntSlackLB;
                }
                if (!this.ubSlack[i3]) continue;
                this.standardA.set(nOfSlackG + nOfSlackLB + cntSlackUB, nOfSlackG + nOfSlackLB + cntSlackUB, 1.0);
                this.standardA.set(nOfSlackG + nOfSlackLB + cntSlackUB, this.standardS + i3, 1.0);
                this.standardB.setQuick(nOfSlackG + nOfSlackLB + cntSlackUB, originalUB.getQuick(i3));
                ++cntSlackUB;
            }
            for (i3 = 0; originalA != null && i3 < originalA.rows(); ++i3) {
                for (int j = 0; j < this.originalN; ++j) {
                    this.standardA.set(this.standardS + i3, this.standardS + j, originalA.get(i3, j));
                }
                this.standardB.setQuick(this.standardS + i3, originalB.getQuick(i3));
            }
            cntSlackLB = 0;
            cntSlackUB = 0;
            int previousSplittedVariables = 0;
            for (int sv = 0; sv < nOfSplittedVariables; ++sv) {
                int k;
                int r;
                int i4 = this.splittedVariablesList.get(sv);
                for (r = 0; r < nOfSlackG; ++r) {
                    this.standardA.set(r, this.standardS + this.originalN + sv, -originalG.getQuick(r, i4));
                }
                if (this.lbSlack[i4]) {
                    for (k = previousSplittedVariables; k < i4; ++k) {
                        if (!this.lbSlack[k]) continue;
                        ++cntSlackLB;
                    }
                    this.standardA.set(nOfSlackG + cntSlackLB, this.standardS + this.originalN + sv, 1.0);
                }
                if (this.ubSlack[i4]) {
                    for (k = previousSplittedVariables; k < i4; ++k) {
                        if (!this.ubSlack[k]) continue;
                        ++cntSlackUB;
                    }
                    this.standardA.set(nOfSlackG + nOfSlackLB + cntSlackUB, this.standardS + this.originalN + sv, -1.0);
                }
                previousSplittedVariables = i4;
                for (r = 0; originalA != null && r < originalA.rows(); ++r) {
                    this.standardA.set(this.standardS + r, this.standardS + this.originalN + sv, -originalA.get(r, i4));
                }
            }
            this.standardC = this.F1.make(this.standardN);
            this.standardLB = this.F1.make(this.standardN);
            this.standardUB = this.F1.make(this.standardN, this.unboundedUBValue);
            for (i2 = 0; i2 < this.originalN; ++i2) {
                this.standardC.setQuick(this.standardS + i2, originalC.getQuick(i2));
            }
            for (i2 = 0; i2 < this.standardS; ++i2) {
                this.standardLB.setQuick(i2, 0.0);
            }
            for (i2 = 0; i2 < this.originalN; ++i2) {
                this.standardLB.setQuick(this.standardS + i2, originalLB.getQuick(i2));
            }
            for (i2 = 0; i2 < this.originalN; ++i2) {
                this.standardUB.setQuick(this.standardS + i2, originalUB.getQuick(i2));
            }
        }
        if (this.strictlyStandardForm) {
            this.standardLB = this.F1.make(this.standardN, 0.0);
            this.standardUB = null;
        }
    }

    public double[] postConvert(double[] X) {
        if (X.length != this.standardN) {
            throw new IllegalArgumentException("wrong array dimension: " + X.length);
        }
        double[] ret = new double[this.originalN];
        int cntSplitted = 0;
        for (int i = this.standardS; i < this.standardN; ++i) {
            if (this.splittedVariablesList.contains(i - this.standardS)) {
                ret[i - this.standardS] = X[i] - X[this.standardN + cntSplitted];
                ++cntSplitted;
                continue;
            }
            ret[i - this.standardS] = X[i];
        }
        return ret;
    }

    public double[] getStandardComponents(double[] x) {
        if (x.length != this.originalN) {
            throw new IllegalArgumentException("wrong array dimension: " + x.length);
        }
        double[] ret = new double[this.standardN];
        for (int i = 0; i < x.length; ++i) {
            if (this.splittedVariablesList.contains(i)) {
                if (x[i] >= 0.0) {
                    ret[this.standardS + i] = x[i];
                    continue;
                }
                int pos = -1;
                for (int k = 0; k < this.splittedVariablesList.size(); ++k) {
                    if (this.splittedVariablesList.get(k) != i) continue;
                    pos = k;
                    break;
                }
                ret[this.standardS + x.length + pos] = -x[i];
                continue;
            }
            ret[this.standardS + i] = x[i];
        }
        if (this.standardS > 0) {
            DoubleMatrix1D residuals = ColtUtils.zMult(this.standardA, this.F1.make(ret), this.standardB, -1.0);
            for (int i = 0; i < this.standardS; ++i) {
                ret[i] = -residuals.get(i) + ret[i];
            }
        }
        return ret;
    }

    public int getOriginalN() {
        return this.originalN;
    }

    public int getStandardN() {
        return this.standardN;
    }

    public int getStandardS() {
        return this.standardS;
    }

    public DoubleMatrix1D getStandardC() {
        return this.standardC;
    }

    public DoubleMatrix2D getStandardA() {
        return this.standardA;
    }

    public DoubleMatrix1D getStandardB() {
        return this.standardB;
    }

    public DoubleMatrix1D getStandardLB() {
        return this.standardLB;
    }

    public DoubleMatrix1D getStandardUB() {
        return this.standardUB;
    }

    public boolean isLbUnbounded(Double lb) {
        return Double.compare(this.unboundedLBValue, lb) == 0;
    }

    public boolean isUbUnbounded(Double ub) {
        return Double.compare(this.unboundedUBValue, ub) == 0;
    }

    public double getUnboundedLBValue() {
        return this.unboundedLBValue;
    }

    public double getUnboundedUBValue() {
        return this.unboundedUBValue;
    }
}

