/*
 * Decompiled with CFR 0.152.
 */
package com.joptimizer.util;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MPSParser {
    private Log log = LogFactory.getLog((String)this.getClass().getName());
    private boolean useSparsity = true;
    private int section;
    private String name;
    private static final String NAME = "NAME";
    private static final String ROWS = "ROWS";
    private static final String QSECTION = "QSECTION";
    private static final String COLUMNS = "COLUMNS";
    private static final String RHS = "RHS";
    private static final String RANGES = "RANGES";
    private static final String BOUNDS = "BOUNDS";
    private static final String ENDATA = "ENDATA";
    private static final int SECTION_NAME = 0;
    private static final int SECTION_ROWS = 1;
    private static final int SECTION_COLUMNS = 2;
    private static final int SECTION_RHS = 3;
    private static final int SECTION_RANGES = 4;
    private static final int SECTION_BOUNDS = 5;
    public static final double DEFAULT_UNBOUNDED_LOWER_BOUND = Double.NaN;
    public static final double DEFAULT_UNBOUNDED_UPPER_BOUND = Double.NaN;
    public static final double DEFAULT_UNSPECIFIED_LOWER_BOUND = 0.0;
    public static final double DEFAULT_UNSPECIFIED_UPPER_BOUND = Double.NaN;
    private final String OBJECTIVE = "N";
    private final String LESS_THEN = "L";
    private final String GREATER_THEN = "G";
    private final String EQUAL = "E";
    private final String LOWER_BOUND = "LO";
    private final String UPPER_BOUND = "UP";
    private final String FX_BOUND = "FX";
    private final String FR_BOUND = "FR";
    private final String PL_BOUND = "PL";
    private final String MI_BOUND = "MI";
    private double unspecifiedLBValue = 0.0;
    private double unspecifiedUBValue = Double.NaN;
    private double unboundedLBValue = Double.NaN;
    private double unboundedUBValue = Double.NaN;
    private Map<String, Integer> columnsIndexMap;
    private int n;
    private int mieq;
    private int meq;
    private int nzG;
    private int nzA;
    private DoubleMatrix1D c;
    private DoubleMatrix2D G;
    private DoubleMatrix1D h;
    private DoubleMatrix2D A;
    private DoubleMatrix1D b;
    private DoubleMatrix1D lb;
    private DoubleMatrix1D ub;
    protected Algebra ALG = Algebra.DEFAULT;
    protected DoubleFactory1D F1 = DoubleFactory1D.dense;
    protected DoubleFactory2D F2 = DoubleFactory2D.dense;

    public MPSParser() {
        this(0.0, Double.NaN, Double.NaN, Double.NaN);
    }

    public MPSParser(double unspecifiedLBValue, double unspecifiedUBValue, double unboundedLBValue, double unboundedUBValue) {
        if (!Double.isNaN(unboundedLBValue) && !Double.isInfinite(unboundedLBValue)) {
            throw new IllegalArgumentException("The field unboundedLBValue must be set to Double.NaN or Double.NEGATIVE_INFINITY");
        }
        if (!Double.isNaN(unboundedUBValue) && !Double.isInfinite(unboundedUBValue)) {
            throw new IllegalArgumentException("The field unboundedUBValue must be set to Double.NaN or Double.POSITIVE_INFINITY");
        }
        this.unspecifiedLBValue = unspecifiedLBValue;
        this.unspecifiedUBValue = unspecifiedUBValue;
        this.unboundedLBValue = unboundedLBValue;
        this.unboundedUBValue = unboundedUBValue;
    }

    public boolean isUseSparsity() {
        return this.useSparsity;
    }

    public void setUseSparsity(boolean useSparsity) {
        this.useSparsity = useSparsity;
    }

    public void parse(String classpathFileName) throws Exception {
        this.parse(new File(new URI(Thread.currentThread().getContextClassLoader().getResource(classpathFileName).toString())));
    }

    public void parse(File file) throws Exception {
        BufferedReader in = new BufferedReader(new FileReader(file));
        this.parse(in);
    }

    public void parse(BufferedReader in) throws Exception {
        long t0 = System.currentTimeMillis();
        HashMap<String, Integer> rowsIndexMap = new HashMap<String, Integer>();
        HashMap<String, String> rowsTypeMap = new HashMap<String, String>();
        ArrayList<String> columnList = new ArrayList<String>();
        ArrayList<String> rhsList = new ArrayList<String>();
        ArrayList<String> boundsList = new ArrayList<String>();
        String previousColumnName = "NOT_YET_SET";
        this.columnsIndexMap = new LinkedHashMap<String, Integer>();
        try {
            String myline;
            int i;
            String line = new String();
            int lineNumber = 0;
            while ((line = in.readLine()) != null) {
                ++lineNumber;
                line = line.trim();
                if (this.log.isDebugEnabled()) {
                    // empty if block
                }
                if (line.startsWith("#") || line.startsWith("*") || "".equals(line.trim())) continue;
                if (line.startsWith(NAME)) {
                    this.section = 0;
                } else {
                    if (line.startsWith(QSECTION)) {
                        this.log.error((Object)"Quadratic problems parsing not supported");
                        throw new RuntimeException("Quadratic problems parsing not supported");
                    }
                    if (line.startsWith(ROWS)) {
                        this.section = 1;
                        continue;
                    }
                    if (line.startsWith(COLUMNS)) {
                        this.section = 2;
                        continue;
                    }
                    if (line.startsWith(RHS)) {
                        if (this.section != 3) {
                            this.section = 3;
                            continue;
                        }
                    } else {
                        if (line.startsWith(RANGES)) {
                            this.log.error((Object)"Ranges are not supported");
                            throw new RuntimeException("Ranges are not supported");
                        }
                        if (line.startsWith(BOUNDS)) {
                            this.section = 5;
                            continue;
                        }
                        if (line.startsWith(ENDATA)) break;
                    }
                }
                switch (this.section) {
                    case 0: {
                        this.name = line.substring(4).trim();
                        this.log.info((Object)("name: " + this.name));
                        break;
                    }
                    case 1: {
                        String rowType = line.substring(0, 1);
                        String rowName = line.substring(1).trim();
                        if (rowType.equalsIgnoreCase("E")) {
                            ++this.meq;
                            rowsIndexMap.put(rowName, -this.meq);
                            rowsTypeMap.put(rowName, "E");
                            break;
                        }
                        if (rowType.equalsIgnoreCase("L")) {
                            ++this.mieq;
                            rowsIndexMap.put(rowName, this.mieq);
                            rowsTypeMap.put(rowName, "L");
                            break;
                        }
                        if (rowType.equalsIgnoreCase("G")) {
                            ++this.mieq;
                            rowsIndexMap.put(rowName, this.mieq);
                            rowsTypeMap.put(rowName, "G");
                            break;
                        }
                        if (!rowType.equalsIgnoreCase("N")) break;
                        rowsTypeMap.put(rowName, "N");
                        break;
                    }
                    case 2: {
                        String columnName = line.substring(0, line.indexOf(" "));
                        if (!previousColumnName.equalsIgnoreCase(columnName)) {
                            ++this.n;
                            previousColumnName = columnName;
                        }
                        columnList.add(columnList.size(), line);
                        break;
                    }
                    case 3: {
                        rhsList.add(rhsList.size(), line);
                        break;
                    }
                    case 5: {
                        boundsList.add(boundsList.size(), line);
                    }
                }
            }
            in.close();
            this.c = this.F1.make(this.n);
            this.A = this.useSparsity ? new SparseDoubleMatrix2D(this.meq, this.n) : this.F2.make(this.meq, this.n);
            this.b = this.F1.make(this.meq);
            this.G = this.useSparsity ? new SparseDoubleMatrix2D(this.mieq, this.n) : this.F2.make(this.mieq, this.n);
            this.h = this.F1.make(this.mieq);
            this.lb = this.F1.make(this.n, this.unspecifiedLBValue);
            this.ub = this.F1.make(this.n, this.unspecifiedUBValue);
            previousColumnName = "NOT_YET_SET";
            int colIndex = -1;
            for (i = 0; i < columnList.size(); ++i) {
                myline = (String)columnList.get(i);
                StringTokenizer cst = new StringTokenizer(myline, " ");
                int cmax = cst.countTokens();
                String rowType = null;
                block20: for (int j = 0; j < cmax; ++j) {
                    String v = cst.nextToken().trim();
                    switch (j) {
                        case 0: {
                            if (previousColumnName.equalsIgnoreCase(v)) continue block20;
                            this.columnsIndexMap.put(v, ++colIndex);
                            previousColumnName = v;
                            continue block20;
                        }
                        case 1: {
                            rowType = (String)rowsTypeMap.get(v);
                            double d1 = new Double(cst.nextToken());
                            if (rowType.equalsIgnoreCase("E")) {
                                int rowIndex = -((Integer)rowsIndexMap.get(v)).intValue();
                                this.A.setQuick(rowIndex - 1, colIndex, d1);
                                ++this.nzA;
                            } else if (rowType.equalsIgnoreCase("L")) {
                                int rowIndex = (Integer)rowsIndexMap.get(v);
                                this.G.setQuick(rowIndex - 1, colIndex, d1);
                                ++this.nzG;
                            } else if (rowType.equalsIgnoreCase("G")) {
                                int rowIndex = (Integer)rowsIndexMap.get(v);
                                this.G.setQuick(rowIndex - 1, colIndex, -d1);
                                ++this.nzG;
                            } else if (rowType.equalsIgnoreCase("N")) {
                                this.c.setQuick(colIndex, d1);
                            }
                            ++j;
                            continue block20;
                        }
                        case 3: {
                            int rowIndex;
                            rowType = (String)rowsTypeMap.get(v);
                            double d2 = new Double(cst.nextToken());
                            if (rowType.equalsIgnoreCase("E")) {
                                rowIndex = -((Integer)rowsIndexMap.get(v)).intValue();
                                this.A.setQuick(rowIndex - 1, colIndex, d2);
                                ++this.nzA;
                            } else if (rowType.equalsIgnoreCase("L")) {
                                rowIndex = (Integer)rowsIndexMap.get(v);
                                this.G.setQuick(rowIndex - 1, colIndex, d2);
                                ++this.nzG;
                            } else if (rowType.equalsIgnoreCase("G")) {
                                rowIndex = (Integer)rowsIndexMap.get(v);
                                this.G.setQuick(rowIndex - 1, colIndex, -d2);
                                ++this.nzG;
                            } else if (rowType.equalsIgnoreCase("N")) {
                                this.c.setQuick(colIndex, d2);
                            }
                            ++j;
                        }
                    }
                }
            }
            for (i = 0; i < rhsList.size(); ++i) {
                myline = (String)rhsList.get(i);
                StringTokenizer rst = new StringTokenizer(myline, " ");
                int rmax = rst.countTokens();
                if (rmax == 5 || rmax == 3) {
                    rst.nextToken();
                    --rmax;
                }
                block22: for (int j = 0; j < rmax; ++j) {
                    String v = rst.nextToken().trim();
                    switch (j) {
                        case 0: {
                            Double d1 = new Double(rst.nextToken());
                            Integer indexObj = (Integer)rowsIndexMap.get(v);
                            if (indexObj == null) {
                                this.log.warn((Object)("unknown constraint " + v));
                                j = rmax;
                                continue block22;
                            }
                            int rowIndex = indexObj;
                            String rowType = (String)rowsTypeMap.get(v);
                            if (rowIndex < 0) {
                                this.b.setQuick(-rowIndex - 1, d1);
                            } else if ("L".equals(rowType)) {
                                this.h.setQuick(rowIndex - 1, d1);
                            } else if ("G".equals(rowType)) {
                                this.h.setQuick(rowIndex - 1, -d1.doubleValue());
                            }
                            ++j;
                            continue block22;
                        }
                        case 2: {
                            double d2 = new Double(rst.nextToken());
                            int rowIndex2 = (Integer)rowsIndexMap.get(v);
                            String rowType2 = (String)rowsTypeMap.get(v);
                            if (rowIndex2 < 0) {
                                this.b.setQuick(-rowIndex2 - 1, d2);
                            } else if ("L".equals(rowType2)) {
                                this.h.setQuick(rowIndex2 - 1, d2);
                            } else if ("G".equals(rowType2)) {
                                this.h.setQuick(rowIndex2 - 1, -d2);
                            }
                            ++j;
                        }
                    }
                }
            }
            for (i = 0; i < boundsList.size(); ++i) {
                int columnIndex;
                String columnName;
                myline = (String)boundsList.get(i);
                StringTokenizer bst = new StringTokenizer(myline, " ");
                int nOfTokens = bst.countTokens();
                String[] tokens = new String[nOfTokens];
                for (int j = 0; j < nOfTokens; ++j) {
                    tokens[j] = bst.nextToken().trim();
                }
                String type = tokens[0];
                if ("LO".equals(type)) {
                    columnName = nOfTokens > 3 ? tokens[2] : tokens[1];
                    columnIndex = this.columnsIndexMap.get(columnName);
                    this.lb.setQuick(columnIndex, new Double(tokens[nOfTokens - 1]));
                    continue;
                }
                if ("UP".equals(type)) {
                    columnName = nOfTokens > 3 ? tokens[2] : tokens[1];
                    columnIndex = this.columnsIndexMap.get(columnName);
                    this.ub.setQuick(columnIndex, new Double(tokens[nOfTokens - 1]));
                    continue;
                }
                if ("FX".equals(type)) {
                    columnName = nOfTokens > 3 ? tokens[2] : tokens[1];
                    columnIndex = this.columnsIndexMap.get(columnName);
                    this.lb.setQuick(columnIndex, new Double(tokens[nOfTokens - 1]));
                    this.ub.setQuick(columnIndex, new Double(tokens[nOfTokens - 1]));
                    continue;
                }
                if ("FR".equals(type)) {
                    columnName = tokens[2];
                    columnIndex = this.columnsIndexMap.get(columnName);
                    this.lb.setQuick(columnIndex, this.unboundedLBValue);
                    this.ub.setQuick(columnIndex, this.unboundedUBValue);
                    continue;
                }
                if ("MI".equals(type)) {
                    columnName = tokens[2];
                    columnIndex = this.columnsIndexMap.get(columnName);
                    this.lb.setQuick(columnIndex, this.unboundedLBValue);
                    this.ub.setQuick(columnIndex, 0.0);
                    continue;
                }
                if ("PL".equals(type)) {
                    columnName = tokens[2];
                    columnIndex = this.columnsIndexMap.get(columnName);
                    this.lb.setQuick(columnIndex, 0.0);
                    this.ub.setQuick(columnIndex, this.unboundedUBValue);
                    continue;
                }
                this.log.warn((Object)("unknown bound type: " + type));
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Exception", (Throwable)e);
            throw e;
        }
        this.log.info((Object)("parsing time: " + (System.currentTimeMillis() - t0) + " ms"));
    }

    public String getName() {
        return this.name;
    }

    public int getN() {
        return this.n;
    }

    public List<String> getVariablesNames() {
        return new ArrayList<String>(this.columnsIndexMap.keySet());
    }

    public int getMieq() {
        return this.mieq;
    }

    public int getMeq() {
        return this.meq;
    }

    public int getNzG() {
        return this.nzG;
    }

    public int getNzA() {
        return this.nzA;
    }

    public DoubleMatrix1D getC() {
        return this.c;
    }

    public DoubleMatrix2D getG() {
        return this.G;
    }

    public DoubleMatrix1D getH() {
        return this.h;
    }

    public DoubleMatrix2D getA() {
        return this.A;
    }

    public DoubleMatrix1D getB() {
        return this.b;
    }

    public DoubleMatrix1D getLb() {
        return this.lb;
    }

    public DoubleMatrix1D getUb() {
        return this.ub;
    }

    protected boolean isLbUnbounded(Double lb) {
        return Double.compare(this.unboundedLBValue, lb) == 0;
    }

    protected boolean isUbUnbounded(Double ub) {
        return Double.compare(this.unboundedUBValue, ub) == 0;
    }
}

