/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.statistics;

import de.lmu.ifi.dbs.elki.algorithm.AbstractDistanceBasedAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.result.CollectionResult;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleMaxHeap;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.Flag;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class DistanceQuantileSampler<O>
extends AbstractDistanceBasedAlgorithm<O, CollectionResult<Vector>> {
    private static final Logging LOG = Logging.getLogger(DistanceQuantileSampler.class);
    private static final String PREFIX = DistanceQuantileSampler.class.getName();
    private double quantile;
    private double sampling;
    private boolean nozeros;
    private RandomFactory rand;

    public DistanceQuantileSampler(DistanceFunction<? super O> distanceFunction, double d, double d2, boolean bl, RandomFactory randomFactory) {
        super(distanceFunction);
        this.quantile = d;
        this.sampling = d2;
        this.nozeros = bl;
        this.rand = randomFactory;
    }

    public Result run(Database database, Relation<O> relation) {
        long l;
        DistanceQuery<O> distanceQuery = relation.getDistanceQuery(this.getDistanceFunction(), new Object[0]);
        int n = relation.size();
        long l2 = (long)n * (long)n >> 1;
        long l3 = l = this.sampling <= 1.0 ? (long)Math.ceil(this.sampling * (double)l2) : (long)this.sampling;
        if (l > Integer.MAX_VALUE) {
            throw new AbortException("Sampling size too large.");
        }
        int n2 = this.quantile <= 0.0 ? 1 : (int)Math.ceil(this.quantile * (double)l);
        DoubleMaxHeap doubleMaxHeap = new DoubleMaxHeap(n2);
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(relation.getDBIDs());
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        DBIDArrayIter dBIDArrayIter2 = arrayDBIDs.iter();
        Random random = this.rand.getSingleThreadedRandom();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress("Sampling", (int)l, LOG) : null;
        for (long i = 0L; i < l; ++i) {
            int n3 = random.nextInt(n - 1) + 1;
            int n4 = random.nextInt(n3);
            double d = distanceQuery.distance((DBIDRef)dBIDArrayIter.seek(n3), (DBIDRef)dBIDArrayIter2.seek(n4));
            if (d != d || this.nozeros && d < Double.MIN_NORMAL) continue;
            doubleMaxHeap.add(d, n2);
            LOG.incrementProcessed(finiteProgress);
        }
        LOG.statistics(new DoubleStatistic(PREFIX + ".quantile", this.quantile));
        LOG.statistics(new LongStatistic(PREFIX + ".samplesize", l));
        LOG.statistics(new DoubleStatistic(PREFIX + ".distance", doubleMaxHeap.peek()));
        LOG.ensureCompleted(finiteProgress);
        List<String> list = Arrays.asList("Distance");
        List<Vector> list2 = Arrays.asList(new Vector(doubleMaxHeap.peek()));
        return new CollectionResult<Vector>("Distances sample", "distance-sample", list2, list);
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(this.getDistanceFunction().getInputTypeRestriction());
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer<O>
    extends AbstractDistanceBasedAlgorithm.Parameterizer<O> {
        public static final OptionID QUANTILE_ID = new OptionID("distsample.quantile", "Quantile to compute.");
        public static final OptionID SAMPLING_ID = new OptionID("distsample.sample", "Number of distances to compute, either relative (values less than 1), or absolute.");
        public static final OptionID NOZEROS_ID = new OptionID("distsample.nozeros", "Ignore zero distances, beneficial for data sets with many duplicates.");
        public static final OptionID SEED_ID = new OptionID("distsample.seed", "Random generator seed.");
        private double quantile;
        private double sampling;
        private boolean nozeros;
        private RandomFactory rand;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            RandomParameter randomParameter;
            Flag flag;
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = (DoubleParameter)((DoubleParameter)new DoubleParameter(QUANTILE_ID, 0.1).addConstraint(CommonConstraints.GREATER_EQUAL_ZERO_DOUBLE)).addConstraint(CommonConstraints.LESS_EQUAL_ONE_DOUBLE);
            if (parameterization.grab(doubleParameter2)) {
                this.quantile = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = (DoubleParameter)new DoubleParameter(SAMPLING_ID).addConstraint(CommonConstraints.GREATER_THAN_ZERO_DOUBLE))) {
                this.sampling = doubleParameter.doubleValue();
            }
            if (parameterization.grab(flag = new Flag(NOZEROS_ID))) {
                this.nozeros = flag.isTrue();
            }
            if (parameterization.grab(randomParameter = new RandomParameter(SEED_ID))) {
                this.rand = (RandomFactory)randomParameter.getValue();
            }
        }

        @Override
        protected DistanceQuantileSampler<O> makeInstance() {
            return new DistanceQuantileSampler(this.distanceFunction, this.quantile, this.sampling, this.nozeros, this.rand);
        }
    }
}

