/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;

public class MapIntegerDBIDIntegerStore
implements WritableIntegerDataStore {
    private TIntIntMap map;

    public MapIntegerDBIDIntegerStore(int n) {
        this(n, 0);
    }

    public MapIntegerDBIDIntegerStore(int n, int n2) {
        this.map = new TIntIntHashMap(n, 0.5f, Integer.MIN_VALUE, n2);
    }

    @Override
    @Deprecated
    public Integer get(DBIDRef dBIDRef) {
        return this.map.get(DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public int intValue(DBIDRef dBIDRef) {
        return this.map.get(DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public String getLongName() {
        return "raw";
    }

    @Override
    public String getShortName() {
        return "raw";
    }

    @Override
    @Deprecated
    public Integer put(DBIDRef dBIDRef, Integer n) {
        return this.map.put(DBIDUtil.asInteger(dBIDRef), n.intValue());
    }

    @Override
    public void destroy() {
        this.map.clear();
        this.map = null;
    }

    @Override
    public void delete(DBIDRef dBIDRef) {
        this.map.remove(DBIDUtil.asInteger(dBIDRef));
    }

    @Override
    public int putInt(DBIDRef dBIDRef, int n) {
        return this.map.put(DBIDUtil.asInteger(dBIDRef), n);
    }

    @Override
    public int put(DBIDRef dBIDRef, int n) {
        return this.map.put(DBIDUtil.asInteger(dBIDRef), n);
    }

    @Override
    public void increment(DBIDRef dBIDRef, int n) {
        this.map.adjustOrPutValue(DBIDUtil.asInteger(dBIDRef), n, n);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

