/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.EmptyDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.StaticDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.generic.KNNSubList;
import de.lmu.ifi.dbs.elki.database.ids.generic.UnmodifiableArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.generic.UnmodifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDKNNList;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDKNNSubList;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.UnmodifiableIntegerArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.UnmodifiableIntegerDBIDs;
import de.lmu.ifi.dbs.elki.math.random.FastNonThreadsafeRandom;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.util.Random;

public final class DBIDUtil {
    public static final EmptyDBIDs EMPTYDBIDS = new EmptyDBIDs();

    private DBIDUtil() {
    }

    public static DBIDRef invalid() {
        return DBIDFactory.FACTORY.invalid();
    }

    public static DBID importInteger(int n) {
        return DBIDFactory.FACTORY.importInteger(n);
    }

    public static int asInteger(DBIDRef dBIDRef) {
        return dBIDRef.internalGetIndex();
    }

    public static int compare(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        return DBIDFactory.FACTORY.compare(dBIDRef, dBIDRef2);
    }

    public static boolean equal(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        return DBIDFactory.FACTORY.equal(dBIDRef, dBIDRef2);
    }

    public static DBID deref(DBIDRef dBIDRef) {
        if (dBIDRef instanceof DBID) {
            return (DBID)dBIDRef;
        }
        return DBIDUtil.importInteger(dBIDRef.internalGetIndex());
    }

    public static String toString(DBIDRef dBIDRef) {
        return DBIDFactory.FACTORY.toString(dBIDRef);
    }

    public static String toString(DBIDs dBIDs) {
        if (dBIDs instanceof DBID) {
            return DBIDFactory.FACTORY.toString((DBID)dBIDs);
        }
        StringBuilder stringBuilder = new StringBuilder();
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(DBIDFactory.FACTORY.toString(dBIDIter));
            dBIDIter.advance();
        }
        return stringBuilder.toString();
    }

    public static ByteBufferSerializer<DBID> getDBIDSerializer() {
        return DBIDFactory.FACTORY.getDBIDSerializer();
    }

    public static ByteBufferSerializer<DBID> getDBIDSerializerStatic() {
        return DBIDFactory.FACTORY.getDBIDSerializerStatic();
    }

    public static DBID generateSingleDBID() {
        return DBIDFactory.FACTORY.generateSingleDBID();
    }

    public static void deallocateSingleDBID(DBID dBID) {
        DBIDFactory.FACTORY.deallocateSingleDBID(dBID);
    }

    public static DBIDRange generateStaticDBIDRange(int n) {
        return DBIDFactory.FACTORY.generateStaticDBIDRange(n);
    }

    public static void deallocateDBIDRange(DBIDRange dBIDRange) {
        DBIDFactory.FACTORY.deallocateDBIDRange(dBIDRange);
    }

    public static DBIDVar newVar(DBIDRef dBIDRef) {
        return DBIDFactory.FACTORY.newVar(dBIDRef);
    }

    public static DBIDVar newVar() {
        return DBIDFactory.FACTORY.newVar(DBIDFactory.FACTORY.invalid());
    }

    public static ArrayModifiableDBIDs newArray() {
        return DBIDFactory.FACTORY.newArray();
    }

    public static HashSetModifiableDBIDs newHashSet() {
        return DBIDFactory.FACTORY.newHashSet();
    }

    public static ArrayModifiableDBIDs newArray(int n) {
        return DBIDFactory.FACTORY.newArray(n);
    }

    public static HashSetModifiableDBIDs newHashSet(int n) {
        return DBIDFactory.FACTORY.newHashSet(n);
    }

    public static ArrayModifiableDBIDs newArray(DBIDs dBIDs) {
        return DBIDFactory.FACTORY.newArray(dBIDs);
    }

    public static HashSetModifiableDBIDs newHashSet(DBIDs dBIDs) {
        return DBIDFactory.FACTORY.newHashSet(dBIDs);
    }

    public static ModifiableDBIDs intersection(DBIDs dBIDs, DBIDs dBIDs2) {
        if (dBIDs.size() > dBIDs2.size()) {
            return DBIDUtil.intersection(dBIDs2, dBIDs);
        }
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(dBIDs.size());
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            if (dBIDs2.contains(dBIDIter)) {
                hashSetModifiableDBIDs.add(dBIDIter);
            }
            dBIDIter.advance();
        }
        return hashSetModifiableDBIDs;
    }

    public static int intersectionSize(DBIDs dBIDs, DBIDs dBIDs2) {
        if (dBIDs2 instanceof SetDBIDs) {
            if (!(dBIDs instanceof SetDBIDs)) {
                return DBIDUtil.internalIntersectionSize(dBIDs, dBIDs2);
            }
        } else if (dBIDs instanceof SetDBIDs) {
            return DBIDUtil.internalIntersectionSize(dBIDs2, dBIDs);
        }
        if (dBIDs.size() <= dBIDs2.size()) {
            return DBIDUtil.internalIntersectionSize(dBIDs, dBIDs2);
        }
        return DBIDUtil.internalIntersectionSize(dBIDs2, dBIDs);
    }

    private static int internalIntersectionSize(DBIDs dBIDs, DBIDs dBIDs2) {
        int n = 0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            if (dBIDs2.contains(dBIDIter)) {
                ++n;
            }
            dBIDIter.advance();
        }
        return n;
    }

    public static void symmetricIntersection(DBIDs dBIDs, DBIDs dBIDs2, HashSetModifiableDBIDs hashSetModifiableDBIDs, HashSetModifiableDBIDs hashSetModifiableDBIDs2, HashSetModifiableDBIDs hashSetModifiableDBIDs3) {
        if (dBIDs.size() > dBIDs2.size()) {
            DBIDUtil.symmetricIntersection(dBIDs2, dBIDs, hashSetModifiableDBIDs3, hashSetModifiableDBIDs2, hashSetModifiableDBIDs);
            return;
        }
        assert (hashSetModifiableDBIDs.size() == 0) : "OUTPUT set should be empty!";
        assert (hashSetModifiableDBIDs2.size() == 0) : "OUTPUT set should be empty!";
        assert (hashSetModifiableDBIDs3.size() == 0) : "OUTPUT set should be empty!";
        hashSetModifiableDBIDs3.addDBIDs(dBIDs2);
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            if (hashSetModifiableDBIDs3.remove(dBIDIter)) {
                hashSetModifiableDBIDs2.add(dBIDIter);
            } else {
                hashSetModifiableDBIDs.add(dBIDIter);
            }
            dBIDIter.advance();
        }
    }

    public static ModifiableDBIDs union(DBIDs dBIDs, DBIDs dBIDs2) {
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(Math.max(dBIDs.size(), dBIDs2.size()));
        hashSetModifiableDBIDs.addDBIDs(dBIDs);
        hashSetModifiableDBIDs.addDBIDs(dBIDs2);
        return hashSetModifiableDBIDs;
    }

    public static ModifiableDBIDs difference(DBIDs dBIDs, DBIDs dBIDs2) {
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(dBIDs);
        hashSetModifiableDBIDs.removeDBIDs(dBIDs2);
        return hashSetModifiableDBIDs;
    }

    public static StaticDBIDs makeUnmodifiable(DBIDs dBIDs) {
        if (dBIDs instanceof StaticDBIDs) {
            return (StaticDBIDs)dBIDs;
        }
        if (dBIDs instanceof IntegerArrayDBIDs) {
            return new UnmodifiableIntegerArrayDBIDs((IntegerArrayDBIDs)dBIDs);
        }
        if (dBIDs instanceof IntegerDBIDs) {
            return new UnmodifiableIntegerDBIDs((IntegerDBIDs)dBIDs);
        }
        if (dBIDs instanceof ArrayDBIDs) {
            return new UnmodifiableArrayDBIDs((ArrayDBIDs)dBIDs);
        }
        return new UnmodifiableDBIDs(dBIDs);
    }

    public static ArrayDBIDs ensureArray(DBIDs dBIDs) {
        if (dBIDs instanceof ArrayDBIDs) {
            return (ArrayDBIDs)dBIDs;
        }
        return DBIDUtil.newArray(dBIDs);
    }

    public static SetDBIDs ensureSet(DBIDs dBIDs) {
        if (dBIDs instanceof SetDBIDs) {
            return (SetDBIDs)dBIDs;
        }
        return DBIDUtil.newHashSet(dBIDs);
    }

    public static ModifiableDBIDs ensureModifiable(DBIDs dBIDs) {
        if (dBIDs instanceof ModifiableDBIDs) {
            return (ModifiableDBIDs)dBIDs;
        }
        if (dBIDs instanceof ArrayDBIDs) {
            return DBIDUtil.newArray(dBIDs);
        }
        if (dBIDs instanceof HashSetDBIDs) {
            return DBIDUtil.newHashSet(dBIDs);
        }
        return DBIDUtil.newArray(dBIDs);
    }

    public static DBIDPair newPair(DBIDRef dBIDRef, DBIDRef dBIDRef2) {
        return DBIDFactory.FACTORY.newPair(dBIDRef, dBIDRef2);
    }

    public static DoubleDBIDPair newPair(double d, DBIDRef dBIDRef) {
        return DBIDFactory.FACTORY.newPair(d, dBIDRef);
    }

    public static KNNHeap newHeap(int n) {
        return DBIDFactory.FACTORY.newHeap(n);
    }

    public static KNNHeap newHeap(KNNList kNNList) {
        return DBIDFactory.FACTORY.newHeap(kNNList);
    }

    public static void randomShuffle(ArrayModifiableDBIDs arrayModifiableDBIDs, RandomFactory randomFactory) {
        DBIDUtil.randomShuffle(arrayModifiableDBIDs, randomFactory.getSingleThreadedRandom(), arrayModifiableDBIDs.size());
    }

    public static void randomShuffle(ArrayModifiableDBIDs arrayModifiableDBIDs, Random random) {
        DBIDUtil.randomShuffle(arrayModifiableDBIDs, random, arrayModifiableDBIDs.size());
    }

    public static void randomShuffle(ArrayModifiableDBIDs arrayModifiableDBIDs, Random random, int n) {
        int n2 = arrayModifiableDBIDs.size();
        for (int i = 1; i < n; ++i) {
            arrayModifiableDBIDs.swap(i - 1, i + random.nextInt(n2 - i));
        }
    }

    public static ModifiableDBIDs randomSample(DBIDs dBIDs, int n, int n2) {
        return DBIDUtil.randomSample(dBIDs, n, new Random(n2));
    }

    public static ModifiableDBIDs randomSample(DBIDs dBIDs, int n, Long l) {
        if (l != null) {
            return DBIDUtil.randomSample(dBIDs, n, new Random(l));
        }
        return DBIDUtil.randomSample(dBIDs, n, new Random());
    }

    public static ModifiableDBIDs randomSample(DBIDs dBIDs, int n, RandomFactory randomFactory) {
        return DBIDUtil.randomSample(dBIDs, n, randomFactory.getSingleThreadedRandom());
    }

    public static ModifiableDBIDs randomSample(DBIDs dBIDs, int n, Random random) {
        if (n < 0 || n > dBIDs.size()) {
            throw new IllegalArgumentException("Illegal value for size of random sample: " + n + " > " + dBIDs.size() + " or < 0");
        }
        if (random == null) {
            random = new FastNonThreadsafeRandom();
        }
        if (n < dBIDs.size() >> 1) {
            ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(dBIDs);
            DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(n);
            while (hashSetModifiableDBIDs.size() < n) {
                dBIDArrayIter.seek(random.nextInt(arrayDBIDs.size()));
                hashSetModifiableDBIDs.add(dBIDArrayIter);
            }
            return hashSetModifiableDBIDs;
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs);
        DBIDUtil.randomShuffle(arrayModifiableDBIDs, random, n);
        for (int i = arrayModifiableDBIDs.size() - 1; i >= n; --i) {
            arrayModifiableDBIDs.remove(i);
        }
        return arrayModifiableDBIDs;
    }

    public static DBIDs randomSample(DBIDs dBIDs, double d, RandomFactory randomFactory) {
        return DBIDUtil.randomSample(dBIDs, d, randomFactory.getSingleThreadedRandom());
    }

    public static DBIDs randomSample(DBIDs dBIDs, double d, Random random) {
        if (d <= 0.0) {
            return dBIDs;
        }
        if (d < 1.1) {
            int n = Math.min((int)(d * (double)dBIDs.size()), dBIDs.size());
            return DBIDUtil.randomSample(dBIDs, n, random);
        }
        int n = Math.min((int)d, dBIDs.size());
        return DBIDUtil.randomSample(dBIDs, n, random);
    }

    public static DBIDVar randomSample(DBIDs dBIDs, Random random) {
        ArrayDBIDs arrayDBIDs = DBIDUtil.ensureArray(dBIDs);
        DBIDVar dBIDVar = DBIDUtil.newVar();
        arrayDBIDs.assignVar(random.nextInt(arrayDBIDs.size()), dBIDVar);
        return dBIDVar;
    }

    public static DBIDVar randomSample(DBIDs dBIDs, RandomFactory randomFactory) {
        return DBIDUtil.randomSample(dBIDs, randomFactory.getSingleThreadedRandom());
    }

    public static ArrayDBIDs[] randomSplit(DBIDs dBIDs, int n, RandomFactory randomFactory) {
        return DBIDUtil.randomSplit(dBIDs, n, randomFactory.getSingleThreadedRandom());
    }

    public static ArrayDBIDs[] randomSplit(DBIDs dBIDs, int n, Random random) {
        int n2;
        if (random == null) {
            random = new FastNonThreadsafeRandom();
        }
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs);
        int n3 = arrayModifiableDBIDs.size();
        ArrayDBIDs[] arrayDBIDsArray = new ArrayDBIDs[n];
        for (n2 = 1; n2 < n3; ++n2) {
            arrayModifiableDBIDs.swap(n2 - 1, n2 + random.nextInt(n3 - n2));
        }
        n2 = n3 / n;
        int n4 = n3 % n;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6 = n2 + (i < n4 ? 1 : 0);
            arrayDBIDsArray[i] = arrayModifiableDBIDs.slice(n5, n5 + n6);
            n5 += n6;
        }
        return arrayDBIDsArray;
    }

    public static KNNList subList(KNNList kNNList, int n) {
        if (n >= kNNList.size()) {
            return kNNList;
        }
        if (kNNList instanceof IntegerDBIDKNNList) {
            return new IntegerDBIDKNNSubList((IntegerDBIDKNNList)kNNList, n);
        }
        return new KNNSubList(kNNList, n);
    }

    public static ModifiableDoubleDBIDList newDistanceDBIDList(int n) {
        return DBIDFactory.FACTORY.newDistanceDBIDList(n);
    }

    public static ModifiableDoubleDBIDList newDistanceDBIDList() {
        return DBIDFactory.FACTORY.newDistanceDBIDList();
    }

    public static DBIDRange assertRange(DBIDs dBIDs) {
        if (!(dBIDs instanceof DBIDRange)) {
            throw new AbortException("This class may currently only be used with static databases and DBID ranges.");
        }
        return (DBIDRange)dBIDs;
    }
}

