/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.preprocessed.knn;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.index.tree.spatial.SpatialPair;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.AbstractSpatialSorter;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.SpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

@Reference(authors="E. Schubert, A. Zimek, H.-P. Kriegel", title="Fast and Scalable Outlier Detection with Approximate Nearest Neighbor Ensembles", booktitle="Proc. 20th International Conference on Database Systems for Advanced Applications (DASFAA)", url="http://dx.doi.org/10.1007/978-3-319-18123-3_2")
public class SpacefillingMaterializeKNNPreprocessor<O extends NumberVector>
extends AbstractMaterializeKNNPreprocessor<O> {
    private static final Logging LOG = Logging.getLogger(SpacefillingMaterializeKNNPreprocessor.class);
    final List<SpatialSorter> curvegen;
    final double window;
    final int variants;
    Mean mean = new Mean();
    Random random;

    public SpacefillingMaterializeKNNPreprocessor(Relation<O> relation, DistanceFunction<? super O> distanceFunction, int n, List<SpatialSorter> list, double d, int n2, Random random) {
        super(relation, distanceFunction, n);
        this.curvegen = list;
        this.window = d;
        this.variants = n2;
        this.random = random;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void preprocess() {
        Object object;
        int n;
        void writableDataStore;
        Object object2;
        long l = System.currentTimeMillis();
        int n3 = this.relation.size();
        int n4 = this.curvegen.size();
        int n5 = n4 * this.variants;
        ArrayList arrayList = new ArrayList(n5);
        for (int i = 0; i < n5; ++i) {
            arrayList.add(new ArrayList(n3));
        }
        Object object3 = this.relation.iterDBIDs();
        while (object3.valid()) {
            object2 = (NumberVector)this.relation.get((DBIDRef)object3);
            SpatialPair<DBID, Object> spatialPair = new SpatialPair<DBID, Object>(DBIDUtil.deref((DBIDRef)object3), object2);
            for (List list : arrayList) {
                list.add(spatialPair);
            }
            object3.advance();
        }
        object3 = AbstractSpatialSorter.computeMinMax((List)arrayList.get(0));
        object2 = new double[((Object)object3).length];
        int n6 = ((Object)object3).length >>> 1;
        Object object4 = new int[n6];
        boolean i = false;
        while (writableDataStore < this.variants) {
            for (n = 0; n < ((Object)object3).length; n += 2) {
                reference n7 = object3[n + 1] - object3[n];
                object2[n] = object3[n] - n7 * this.random.nextDouble();
                object2[n + 1] = object3[n + 1] + n7 * this.random.nextDouble();
            }
            for (n = 0; n < n6; ++n) {
                object4[n] = n;
            }
            for (n = n6 - 1; n > 0; --n) {
                int iterator = this.random.nextInt(n + 1);
                Object dBIDIter = object4[iterator];
                object4[iterator] = object4[n];
                object4[n] = dBIDIter;
            }
            for (n = 0; n < n4; ++n) {
                this.curvegen.get(n).sort((List)arrayList.get(n + n4 * writableDataStore), 0, n3, (double[])object2, (int[])object4);
            }
            ++writableDataStore;
        }
        WritableDataStore<int[]> writableDataStore2 = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 3, int[].class);
        for (n = 0; n < n5; ++n) {
            Iterator hashSetModifiableDBIDs = ((List)arrayList.get(n)).iterator();
            int l2 = 0;
            while (hashSetModifiableDBIDs.hasNext()) {
                int[] n8;
                object = (SpatialPair)hashSetModifiableDBIDs.next();
                if (n == 0) {
                    n8 = new int[n5];
                    writableDataStore2.put((DBIDRef)((SpatialPair)object).first, n8);
                } else {
                    n8 = (int[])writableDataStore2.get((DBIDRef)((SpatialPair)object).first);
                }
                n8[n] = l2++;
            }
        }
        n = (int)Math.ceil(this.window * (double)this.k);
        this.storage = DataStoreUtil.makeStorage(this.relation.getDBIDs(), 4, KNNList.class);
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(2 * n * n5);
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            Object object5;
            int n2;
            hashSetModifiableDBIDs.clear();
            object = (int[])writableDataStore2.get(dBIDIter);
            for (n2 = 0; n2 < ((Object)object).length; ++n2) {
                object5 = (List)arrayList.get(n2);
                int n7 = Math.max(0, (int)(object[n2] - n));
                int n8 = Math.min((int)(object[n2] + n + true), object5.size());
                for (int j = n7; j < n8; ++j) {
                    hashSetModifiableDBIDs.add((DBIDRef)((SpatialPair)object5.get((int)j)).first);
                }
            }
            n2 = 0;
            object5 = DBIDUtil.newHeap(this.k);
            NumberVector numberVector = (NumberVector)this.relation.get(dBIDIter);
            DBIDMIter dBIDMIter = hashSetModifiableDBIDs.iter();
            while (dBIDMIter.valid()) {
                object5.insert(this.distanceQuery.distance(numberVector, dBIDMIter), dBIDMIter);
                ++n2;
                dBIDMIter.advance();
            }
            this.storage.put(dBIDIter, object5.toKNNList());
            this.mean.put((double)n2 / (double)this.k);
            dBIDIter.advance();
        }
        long l2 = System.currentTimeMillis();
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.getClass().getCanonicalName() + ".construction-time.ms", l2 - l));
        }
    }

    @Override
    public String getLongName() {
        return "Space Filling Curve KNN preprocessor";
    }

    @Override
    public String getShortName() {
        return "spacefilling-knn";
    }

    @Override
    public void logStatistics() {
        LOG.statistics(new DoubleStatistic(this.getClass().getCanonicalName() + ".distance-computations-per-k", this.mean.getMean()));
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        for (Object object : objectArray) {
            if (!"exact".equals(object)) continue;
            return null;
        }
        return super.getKNNQuery(distanceQuery, objectArray);
    }

    public static class Factory<V extends NumberVector>
    extends AbstractMaterializeKNNPreprocessor.Factory<V> {
        List<SpatialSorter> curvegen;
        double window;
        int variants;
        RandomFactory random;

        public Factory(int n, DistanceFunction<? super V> distanceFunction, List<SpatialSorter> list, double d, int n2, RandomFactory randomFactory) {
            super(n, distanceFunction);
            this.curvegen = list;
            this.window = d;
            this.variants = n2;
            this.random = randomFactory;
        }

        @Override
        public SpacefillingMaterializeKNNPreprocessor<V> instantiate(Relation<V> relation) {
            return new SpacefillingMaterializeKNNPreprocessor<V>(relation, this.distanceFunction, this.k, this.curvegen, this.window, this.variants, this.random.getRandom());
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return TypeUtil.NUMBER_VECTOR_FIELD;
        }

        public static class Parameterizer<V extends NumberVector>
        extends AbstractMaterializeKNNPreprocessor.Factory.Parameterizer<V> {
            public static final OptionID CURVES_ID = new OptionID("sfcknn.curves", "Space filling curve generators to use for kNN approximation.");
            public static final OptionID WINDOW_ID = new OptionID("sfcknn.windowmult", "Window size multiplicator.");
            public static final OptionID VARIANTS_ID = new OptionID("sfcknn.variants", "Number of curve variants to generate.");
            public static final OptionID RANDOM_ID = new OptionID("sfcknn.seed", "Random generator.");
            List<SpatialSorter> curvegen;
            double window;
            int variants;
            RandomFactory random;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                RandomParameter randomParameter;
                DoubleParameter doubleParameter;
                super.makeOptions(parameterization);
                ObjectListParameter objectListParameter = new ObjectListParameter(CURVES_ID, SpatialSorter.class);
                if (parameterization.grab(objectListParameter)) {
                    this.curvegen = objectListParameter.instantiateClasses(parameterization);
                }
                if (parameterization.grab(doubleParameter = new DoubleParameter(WINDOW_ID, 10.0))) {
                    this.window = (Double)doubleParameter.getValue();
                }
                IntParameter intParameter = new IntParameter(VARIANTS_ID, 1);
                intParameter.addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT);
                if (parameterization.grab(intParameter)) {
                    this.variants = (Integer)intParameter.getValue();
                }
                if (parameterization.grab(randomParameter = new RandomParameter(RANDOM_ID))) {
                    this.random = (RandomFactory)randomParameter.getValue();
                }
            }

            @Override
            protected Factory<V> makeInstance() {
                return new Factory(this.k, this.distanceFunction, this.curvegen, this.window, this.variants, this.random);
            }
        }
    }
}

