/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging;

import de.lmu.ifi.dbs.elki.logging.OutputStreamLogger;
import de.lmu.ifi.dbs.elki.logging.progress.ProgressLogRecord;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ErrorFormatter
extends Formatter {
    public static final String[] PRUNE = new String[]{"de.lmu.ifi.dbs.elki.gui.minigui.MiniGUI", "de.lmu.ifi.dbs.elki.KDDTask", "java.awt.event.", "java.awt.EventDispatchThread", "java.awt.EventQueue", "java.security.", "java.lang.Thread", "java.util.concurrent.", "javax.swing.SwingWorker", "java.util.concurrent.FutureTask", "org.apache.batik."};

    @Override
    public String format(LogRecord logRecord) {
        if (logRecord instanceof ProgressLogRecord) {
            return logRecord.getMessage();
        }
        String string = logRecord.getMessage();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
            if (!string.endsWith(OutputStreamLogger.NEWLINE)) {
                stringBuilder.append(OutputStreamLogger.NEWLINE);
            }
        } else {
            stringBuilder.append("null" + OutputStreamLogger.NEWLINE);
        }
        if (logRecord.getThrown() != null) {
            this.appendCauses(stringBuilder, logRecord.getThrown());
        }
        return stringBuilder.toString();
    }

    private void appendCauses(StringBuilder stringBuilder, Throwable throwable) {
        int n;
        stringBuilder.append(throwable.toString()).append(OutputStreamLogger.NEWLINE);
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        block0: for (n = stackTraceElementArray.length - 1; n >= 0; --n) {
            String string = stackTraceElementArray[n].getClassName();
            for (String string2 : PRUNE) {
                if (string.startsWith(string2)) continue block0;
            }
        }
        if (n <= 0) {
            n = stackTraceElementArray.length - 1;
        }
        for (int i = 0; i <= n; ++i) {
            stringBuilder.append("\tat ").append(stackTraceElementArray[i]).append(OutputStreamLogger.NEWLINE);
        }
        if (n < stackTraceElementArray.length - 1) {
            stringBuilder.append("\tat [...]").append(OutputStreamLogger.NEWLINE);
        }
        if (throwable.getCause() != null) {
            stringBuilder.append("Caused by: ");
            this.appendCauses(stringBuilder, throwable.getCause());
        }
    }
}

