/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.ExponentialDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.exceptions.NotImplementedException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

@Alias(value={"exgaussian"})
public class ExponentiallyModifiedGaussianDistribution
extends AbstractDistribution {
    private double mean;
    private double stddev;
    private double lambda;

    public ExponentiallyModifiedGaussianDistribution(double d, double d2, double d3, Random random) {
        super(random);
        this.mean = d;
        this.stddev = d2;
        this.lambda = d3;
    }

    public ExponentiallyModifiedGaussianDistribution(double d, double d2, double d3, RandomFactory randomFactory) {
        super(randomFactory);
        this.mean = d;
        this.stddev = d2;
        this.lambda = d3;
    }

    public ExponentiallyModifiedGaussianDistribution(double d, double d2, double d3) {
        this(d, d2, d3, (Random)null);
    }

    @Override
    public double pdf(double d) {
        return ExponentiallyModifiedGaussianDistribution.pdf(d, this.mean, this.stddev, this.lambda);
    }

    @Override
    public double cdf(double d) {
        return ExponentiallyModifiedGaussianDistribution.cdf(d, this.mean, this.stddev, this.lambda);
    }

    @Override
    @Deprecated
    public double quantile(double d) {
        return ExponentiallyModifiedGaussianDistribution.quantile(d, this.mean, this.stddev, this.lambda);
    }

    @Override
    public double nextRandom() {
        double d = this.mean + this.random.nextGaussian() * this.stddev;
        double d2 = -Math.log(this.random.nextDouble()) / this.lambda;
        return d + d2;
    }

    @Override
    public String toString() {
        return "ExGaussianDistribution(mean=" + this.mean + ", stddev=" + this.stddev + ", lambda=" + this.lambda + ")";
    }

    public double getMean() {
        return this.mean;
    }

    public double getStddev() {
        return this.stddev;
    }

    public double getLambda() {
        return this.lambda;
    }

    public static double pdf(double d, double d2, double d3, double d4) {
        double d5 = d - d2;
        double d6 = d4 * d3 * d3;
        double d7 = NormalDistribution.erfc((d6 - d5) / (d3 * MathUtil.SQRT2));
        return 0.5 * d4 * Math.exp(d4 * (d6 * 0.5 - d5)) * d7;
    }

    public static double cdf(double d, double d2, double d3, double d4) {
        double d5 = d4 * (d - d2);
        double d6 = d4 * d3;
        double d7 = d6 * d6;
        double d8 = Math.log(NormalDistribution.cdf(d5, d7, d6));
        return NormalDistribution.cdf(d5, 0.0, d6) - Math.exp(-d5 + d7 * 0.5 + d8);
    }

    @Deprecated
    public static double quantile(double d, double d2, double d3, double d4) {
        throw new NotImplementedException("Not yet supported.");
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        double mean;
        double stddev;
        double lambda;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            DoubleParameter doubleParameter2;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter3 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter3)) {
                this.mean = doubleParameter3.doubleValue();
            }
            if (parameterization.grab(doubleParameter2 = new DoubleParameter(SCALE_ID))) {
                this.stddev = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(ExponentialDistribution.Parameterizer.RATE_ID))) {
                this.lambda = doubleParameter.doubleValue();
            }
        }

        @Override
        protected ExponentiallyModifiedGaussianDistribution makeInstance() {
            return new ExponentiallyModifiedGaussianDistribution(this.mean, this.stddev, this.lambda, this.rnd);
        }
    }
}

