/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.persistent.PageHeader;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DefaultPageHeader
implements PageHeader {
    private static final int SIZE = 8;
    private static final int FILE_VERSION = 841150978;
    private int pageSize = -1;

    public DefaultPageHeader() {
    }

    public DefaultPageHeader(int n) {
        this.pageSize = n;
    }

    @Override
    public int size() {
        return 8;
    }

    @Override
    public void readHeader(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        if (randomAccessFile.readInt() != 841150978) {
            throw new RuntimeException("File " + randomAccessFile + " is not a PersistentPageFile or wrong version!");
        }
        this.pageSize = randomAccessFile.readInt();
    }

    @Override
    public void readHeader(byte[] byArray) {
        if (ByteArrayUtil.readInt(byArray, 0) != 841150978) {
            throw new RuntimeException("PersistentPageFile version does not match!");
        }
        this.pageSize = ByteArrayUtil.readInt(byArray, 4);
    }

    @Override
    public void writeHeader(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(0L);
        randomAccessFile.writeInt(841150978);
        randomAccessFile.writeInt(this.pageSize);
    }

    @Override
    public byte[] asByteArray() {
        byte[] byArray = new byte[8];
        ByteArrayUtil.writeInt(byArray, 0, 841150978);
        ByteArrayUtil.writeInt(byArray, 4, this.pageSize);
        return byArray;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getReservedPages() {
        return this.size() / this.getPageSize() + 1;
    }
}

