/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities;

import gnu.trove.strategy.HashingStrategy;
import java.util.Arrays;

public final class BitsUtil {
    private static final int LONG_LOG2_SIZE = 6;
    private static final int LONG_LOG2_MASK = 63;
    private static final long LONG_ALL_BITS = -1L;
    private static final long LONG_63_BITS = Long.MAX_VALUE;
    private static final long LONG_32_BITS = 0xFFFFFFFFL;
    private static final int[] POW5_INT = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
    public static final HashingStrategy<long[]> TROVE_HASH_STRATEGY = new HashingStrategy<long[]>(){
        private static final long serialVersionUID = 1L;

        public int computeHashCode(long[] lArray) {
            return BitsUtil.hashCode(lArray);
        }

        public boolean equals(long[] lArray, long[] lArray2) {
            return BitsUtil.equal(lArray, lArray2);
        }
    };

    public static long[] zero(int n) {
        return new long[n > 0 ? (n - 1 >>> 6) + 1 : 1];
    }

    public static long[] make(int n, long l) {
        long[] lArray = new long[(n - 1 >>> 6) + 1];
        lArray[0] = l;
        return lArray;
    }

    public static long[] ones(int n) {
        long[] lArray = new long[(n - 1 >>> 6) + 1];
        int n2 = n >>> 6;
        int n3 = n & 0x3F;
        Arrays.fill(lArray, 0, n2, -1L);
        lArray[lArray.length - 1] = (1L << n3) - 1L;
        return lArray;
    }

    public static long[] copy(long[] lArray) {
        return Arrays.copyOf(lArray, lArray.length);
    }

    public static long[] copy(long[] lArray, int n) {
        int n2 = (n - 1 >>> 6) + 1;
        if (lArray.length == n2) {
            return Arrays.copyOf(lArray, lArray.length);
        }
        long[] lArray2 = new long[n2];
        System.arraycopy(lArray, 0, lArray2, 0, Math.min(lArray.length, n2));
        return lArray2;
    }

    public static long[] copy(long[] lArray, int n, int n2) {
        int n3;
        int n4 = (n - 1 >>> 6) + 1;
        if (lArray.length == n4 && n2 == 0) {
            return Arrays.copyOf(lArray, lArray.length);
        }
        long[] lArray2 = new long[n4];
        int n5 = n2 >>> 6;
        int n6 = n2 & 0x3F;
        if (n6 == 0) {
            for (int i = n5; i < lArray2.length; ++i) {
                int n7 = i;
                lArray2[n7] = lArray2[n7] | lArray[i - n5];
            }
            return lArray2;
        }
        int n8 = 64 - n6;
        int n9 = n3 = Math.min(lArray2.length, lArray.length + n5) - 1;
        while (n9 > n5) {
            int n10 = n9 - n5;
            int n11 = n9--;
            lArray2[n11] = lArray2[n11] | (lArray[n10] << n6 | lArray[n10 - 1] >>> n8);
        }
        int n12 = n5;
        lArray2[n12] = lArray2[n12] | lArray[0] << n6;
        return lArray2;
    }

    public static long grayC(long l) {
        return l ^ l >>> 1;
    }

    public static long[] grayI(long[] lArray) {
        long[] lArray2 = BitsUtil.copy(lArray);
        BitsUtil.shiftRightI(lArray2, 1);
        BitsUtil.xorI(lArray, lArray2);
        return lArray;
    }

    public static long invgrayC(long l) {
        l ^= l >>> 1;
        l ^= l >>> 2;
        l ^= l >>> 4;
        l ^= l >>> 8;
        l ^= l >>> 16;
        l ^= l >>> 32;
        return l;
    }

    public static long[] invgrayI(long[] lArray) {
        int n;
        int n2;
        int n3 = lArray.length - 1;
        for (n2 = 1; n2 < 64; n2 <<= 1) {
            for (n = 0; n < n3; ++n) {
                int n4 = n;
                lArray[n4] = lArray[n4] ^ (lArray[n] >>> n2 ^ lArray[n + 1] << 64 - n2);
            }
            int n5 = n3;
            lArray[n5] = lArray[n5] ^ lArray[n3] >>> n2;
        }
        for (n2 = 1; n2 <= n3; n2 <<= 1) {
            for (n = n2; n <= n3; ++n) {
                int n6 = n - n2;
                lArray[n6] = lArray[n6] ^ lArray[n];
            }
        }
        return lArray;
    }

    public static boolean isZero(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public static int cardinality(long l) {
        return Long.bitCount(l);
    }

    public static int cardinality(long[] lArray) {
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            n += Long.bitCount(lArray[i]);
        }
        return n;
    }

    public static long flipC(long l, int n) {
        return l ^= 1L << n;
    }

    public static long[] flipI(long[] lArray, int n) {
        int n2;
        int n3 = n2 = n >>> 6;
        lArray[n3] = lArray[n3] ^ 1L << n;
        return lArray;
    }

    public static long setC(long l, int n) {
        return l |= 1L << n;
    }

    public static long[] setI(long[] lArray, int n) {
        int n2;
        int n3 = n2 = n >>> 6;
        lArray[n3] = lArray[n3] | 1L << n;
        return lArray;
    }

    public static long[] setI(long[] lArray, long[] lArray2) {
        assert (lArray2.length <= lArray.length) : "Bit set sizes do not agree.";
        int n = Math.min(lArray.length, lArray2.length);
        for (int i = 0; i < n; ++i) {
            lArray[i] = lArray2[i];
        }
        return lArray;
    }

    public static long clearC(long l, int n) {
        return l &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long[] clearI(long[] lArray, int n) {
        int n2;
        int n3 = n2 = n >>> 6;
        lArray[n3] = lArray[n3] & (1L << n ^ 0xFFFFFFFFFFFFFFFFL);
        return lArray;
    }

    public static boolean get(long l, int n) {
        return (l & 1L << n) != 0L;
    }

    public static boolean get(long[] lArray, int n) {
        int n2 = n >>> 6;
        return n2 < lArray.length && (lArray[n2] & 1L << n) != 0L;
    }

    public static void onesI(long[] lArray, int n) {
        int n2 = n >>> 6;
        int n3 = n & 0x3F;
        Arrays.fill(lArray, 0, n2, -1L);
        lArray[n2] = (1L << n3) - 1L;
        Arrays.fill(lArray, n2 + 1, lArray.length, 0L);
    }

    public static long[] zeroI(long[] lArray) {
        Arrays.fill(lArray, 0L);
        return lArray;
    }

    public static long[] xorI(long[] lArray, long[] lArray2) {
        assert (lArray2.length <= lArray.length) : "Bit set sizes do not agree.";
        for (int i = 0; i < lArray2.length; ++i) {
            int n = i;
            lArray[n] = lArray[n] ^ lArray2[i];
        }
        return lArray;
    }

    public static long[] xorI(long[] lArray, long[] lArray2, int n) {
        int n2;
        if (n == 0) {
            return BitsUtil.xorI(lArray, lArray2);
        }
        if (n < 0) {
            throw new UnsupportedOperationException("Negative shifts are not supported.");
        }
        int n3 = n >>> 6;
        int n4 = n & 0x3F;
        if (n3 >= lArray.length) {
            return lArray;
        }
        if (n4 == 0) {
            int n5 = Math.min(lArray.length, lArray2.length + n3);
            for (int i = n3; i < n5; ++i) {
                int n6 = i;
                lArray[n6] = lArray[n6] ^ lArray2[i - n3];
            }
            return lArray;
        }
        int n7 = 64 - n4;
        int n8 = n2 = Math.min(lArray.length, lArray2.length + n3) - 1;
        while (n8 > n3) {
            int n9 = n8 - n3;
            int n10 = n8--;
            lArray[n10] = lArray[n10] ^ (lArray2[n9] << n4 | lArray2[n9 - 1] >>> n7);
        }
        int n11 = n3;
        lArray[n11] = lArray[n11] ^ lArray2[0] << n4;
        return lArray;
    }

    public static long[] orI(long[] lArray, long[] lArray2) {
        assert (lArray2.length <= lArray.length) : "Bit set sizes do not agree.";
        int n = Math.min(lArray.length, lArray2.length);
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            lArray[n2] = lArray[n2] | lArray2[i];
        }
        return lArray;
    }

    public static long[] orI(long[] lArray, long[] lArray2, int n) {
        int n2;
        if (n == 0) {
            return BitsUtil.orI(lArray, lArray2);
        }
        if (n < 0) {
            throw new UnsupportedOperationException("Negative shifts are not supported.");
        }
        int n3 = n >>> 6;
        int n4 = n & 0x3F;
        if (n3 >= lArray.length) {
            return lArray;
        }
        if (n4 == 0) {
            int n5 = Math.min(lArray.length, lArray2.length + n3);
            for (int i = n3; i < n5; ++i) {
                int n6 = i;
                lArray[n6] = lArray[n6] | lArray2[i - n3];
            }
            return lArray;
        }
        int n7 = 64 - n4;
        int n8 = n2 = Math.min(lArray.length, lArray2.length + n3) - 1;
        while (n8 > n3) {
            int n9 = n8 - n3;
            int n10 = n8--;
            lArray[n10] = lArray[n10] | (lArray2[n9] << n4 | lArray2[n9 - 1] >>> n7);
        }
        int n11 = n3;
        lArray[n11] = lArray[n11] | lArray2[0] << n4;
        return lArray;
    }

    public static long[] andI(long[] lArray, long[] lArray2) {
        int n;
        for (n = 0; n < lArray2.length; ++n) {
            int n2 = n;
            lArray[n2] = lArray[n2] & lArray2[n];
        }
        Arrays.fill(lArray, n, lArray.length, 0L);
        return lArray;
    }

    public static long[] andI(long[] lArray, long[] lArray2, int n) {
        if (n == 0) {
            return BitsUtil.andI(lArray, lArray2);
        }
        if (n < 0) {
            throw new UnsupportedOperationException("Negative shifts are not supported.");
        }
        int n2 = n >>> 6;
        int n3 = n & 0x3F;
        if (n2 >= lArray.length) {
            return lArray;
        }
        if (n3 == 0) {
            int n4 = Math.min(lArray.length, lArray2.length + n2);
            for (int i = n2; i < n4; ++i) {
                int n5 = i;
                lArray[n5] = lArray[n5] & lArray2[i - n2];
            }
            Arrays.fill(lArray, 0, n2, 0L);
            return lArray;
        }
        int n6 = 64 - n3;
        int n7 = Math.min(lArray.length, lArray2.length + n2) - 1;
        Arrays.fill(lArray, n7 + 1, lArray.length, 0L);
        int n8 = n7;
        while (n8 > n2) {
            int n9 = n8 - n2;
            int n10 = n8--;
            lArray[n10] = lArray[n10] & (lArray2[n9] << n3 | lArray2[n9 - 1] >>> n6);
        }
        int n11 = n2;
        lArray[n11] = lArray[n11] & lArray2[0] << n3;
        Arrays.fill(lArray, 0, n2, 0L);
        return lArray;
    }

    public static long[] andCMin(long[] lArray, long[] lArray2) {
        int n = Math.min(lArray.length, lArray2.length);
        long[] lArray3 = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray3[i] = lArray[i] & lArray2[i];
        }
        return lArray3;
    }

    public static long[] andCMax(long[] lArray, long[] lArray2) {
        int n;
        int n2;
        if (lArray.length < lArray2.length) {
            n2 = lArray.length;
            n = lArray2.length;
        } else {
            n2 = lArray2.length;
            n = lArray.length;
        }
        long[] lArray3 = new long[n];
        for (int i = 0; i < n2; ++i) {
            lArray3[i] = lArray[i] & lArray2[i];
        }
        return lArray3;
    }

    public static long[] nandI(long[] lArray, long[] lArray2) {
        for (int i = 0; i < lArray2.length; ++i) {
            int n = i;
            lArray[n] = lArray[n] & (lArray2[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return lArray;
    }

    public static long[] invertI(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = lArray[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return lArray;
    }

    public static long[] shiftRightI(long[] lArray, int n) {
        if (n == 0) {
            return lArray;
        }
        if (n < 0) {
            return BitsUtil.shiftLeftI(lArray, -n);
        }
        int n2 = n >>> 6;
        int n3 = n & 0x3F;
        if (n2 >= lArray.length) {
            return BitsUtil.zeroI(lArray);
        }
        if (n3 == 0) {
            System.arraycopy(lArray, n2, lArray, 0, lArray.length - n2);
            Arrays.fill(lArray, lArray.length - n2, lArray.length, 0L);
            return lArray;
        }
        int n4 = 64 - n3;
        for (int i = 0; i < lArray.length - n2 - 1; ++i) {
            int n5 = i + n2;
            lArray[i] = lArray[n5 + 1] << n4 | lArray[n5] >>> n3;
        }
        lArray[lArray.length - n2 - 1] = lArray[lArray.length - 1] >>> n3;
        Arrays.fill(lArray, lArray.length - n2, lArray.length, 0L);
        return lArray;
    }

    public static long[] shiftLeftI(long[] lArray, int n) {
        if (n == 0) {
            return lArray;
        }
        if (n < 0) {
            return BitsUtil.shiftRightI(lArray, -n);
        }
        int n2 = n >>> 6;
        int n3 = n & 0x3F;
        if (n2 >= lArray.length) {
            return BitsUtil.zeroI(lArray);
        }
        if (n3 == 0) {
            System.arraycopy(lArray, 0, lArray, n2, lArray.length - n2);
            Arrays.fill(lArray, 0, n2, 0L);
            return lArray;
        }
        int n4 = 64 - n3;
        for (int i = lArray.length - 1; i > n2; --i) {
            int n5 = i - n2;
            lArray[i] = lArray[n5] << n3 | lArray[n5 - 1] >>> n4;
        }
        lArray[n2] = lArray[0] << n3;
        Arrays.fill(lArray, 0, n2, 0L);
        return lArray;
    }

    public static long cycleRightC(long l, int n, int n2) {
        if (n == 0) {
            return l;
        }
        if (n < 0) {
            return BitsUtil.cycleLeftC(l, -n, n2);
        }
        long l2 = (1 << n2) - 1;
        return (l >>> n | l << n2 - n) & l2;
    }

    public static long[] cycleRightI(long[] lArray, int n, int n2) {
        long[] lArray2 = BitsUtil.copy(lArray, n2, n2 - n);
        BitsUtil.truncateI(lArray2, n2);
        BitsUtil.shiftRightI(lArray, n);
        BitsUtil.orI(lArray, lArray2);
        return lArray;
    }

    public static long[] truncateI(long[] lArray, int n) {
        int n2 = lArray.length * 64 - n;
        int n3 = n2 >>> 6;
        int n4 = n2 & 0x3F;
        Arrays.fill(lArray, lArray.length - n3, lArray.length, 0L);
        if (n4 > 0) {
            int n5 = lArray.length - n3 - 1;
            lArray[n5] = lArray[n5] & -1L >>> n4;
        }
        return lArray;
    }

    public static long cycleLeftC(long l, int n, int n2) {
        if (n == 0) {
            return l;
        }
        if (n < 0) {
            return BitsUtil.cycleRightC(l, -n, n2);
        }
        long l2 = (1 << n2) - 1;
        return (l << n | l >>> n2 - n) & l2;
    }

    public static long[] cycleLeftI(long[] lArray, int n, int n2) {
        long[] lArray2 = BitsUtil.copy(lArray, n2, n);
        BitsUtil.truncateI(lArray2, n2);
        BitsUtil.shiftRightI(lArray, n2 - n);
        BitsUtil.orI(lArray, lArray2);
        return lArray;
    }

    public static String toString(long[] lArray) {
        if (lArray == null) {
            return "null";
        }
        int n = BitsUtil.magnitude(lArray);
        if (n == 0) {
            return "0";
        }
        char[] cArray = new char[n];
        int n2 = n - 1;
        block0: for (int i = 0; i < lArray.length; ++i) {
            long l = 1L;
            for (int j = 0; j < 64; ++j) {
                cArray[n2] = (lArray[i] & l) == 0L ? 48 : 49;
                l <<= 1;
                if (--n2 < 0) break block0;
            }
        }
        while (n2 >= 0) {
            cArray[n2] = 48;
            --n2;
        }
        return new String(cArray);
    }

    public static String toString(long[] lArray, int n) {
        if (lArray == null) {
            return "null";
        }
        int n2 = BitsUtil.magnitude(lArray);
        int n3 = n2 = n2 >= n ? n2 : n;
        if (n2 == 0) {
            return "0";
        }
        char[] cArray = new char[n2];
        int n4 = n2 - 1;
        block0: for (int i = 0; i < lArray.length; ++i) {
            long l = 1L;
            for (int j = 0; j < 64; ++j) {
                cArray[n4] = (lArray[i] & l) == 0L ? 48 : 49;
                l <<= 1;
                if (--n4 < 0) break block0;
            }
        }
        while (n4 >= 0) {
            cArray[n4] = 48;
            --n4;
        }
        return new String(cArray);
    }

    public static String toString(long l) {
        int n = BitsUtil.magnitude(l);
        if (n == 0) {
            return "0";
        }
        char[] cArray = new char[n];
        long l2 = 1L;
        int n2 = n - 1;
        while (n2 >= 0) {
            cArray[n2] = (l & l2) == 0L ? 48 : 49;
            --n2;
            l2 <<= 1;
        }
        return new String(cArray);
    }

    public static String toStringLow(long[] lArray) {
        if (lArray == null) {
            return "null";
        }
        int n = BitsUtil.magnitude(lArray);
        if (n == 0) {
            return "0";
        }
        char[] cArray = new char[n];
        int n2 = 0;
        block0: for (int i = 0; i < lArray.length; ++i) {
            long l = 1L;
            for (int j = 0; j < 64; ++j) {
                cArray[n2] = (lArray[i] & l) == 0L ? 48 : 49;
                l <<= 1;
                if (++n2 >= n) break block0;
            }
        }
        while (n2 < n) {
            cArray[n2] = 48;
            ++n2;
        }
        return new String(cArray);
    }

    public static String toStringLow(long[] lArray, int n) {
        if (lArray == null) {
            return "null";
        }
        int n2 = BitsUtil.magnitude(lArray);
        int n3 = n2 = n2 >= n ? n2 : n;
        if (n2 == 0) {
            return "0";
        }
        char[] cArray = new char[n2];
        int n4 = 0;
        block0: for (int i = 0; i < lArray.length; ++i) {
            long l = 1L;
            for (int j = 0; j < 64; ++j) {
                cArray[n4] = (lArray[i] & l) == 0L ? 48 : 49;
                l <<= 1;
                if (++n4 >= n2) break block0;
            }
        }
        while (n4 < n2) {
            cArray[n4] = 48;
            ++n4;
        }
        return new String(cArray);
    }

    public static String toStringLow(long l) {
        int n = BitsUtil.magnitude(l);
        if (n == 0) {
            return "0";
        }
        char[] cArray = new char[n];
        long l2 = 1L;
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (l & l2) == 0L ? 48 : 49;
            ++n2;
            l2 <<= 1;
        }
        return new String(cArray);
    }

    public static String toString(long[] lArray, String string, int n) {
        int n2 = BitsUtil.nextSetBit(lArray, 0);
        if (n2 < 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n2 + n);
        n2 = BitsUtil.nextSetBit(lArray, n2 + 1);
        while (n2 >= 0) {
            stringBuilder.append(string).append(n2 + n);
            n2 = BitsUtil.nextSetBit(lArray, n2 + 1);
        }
        return stringBuilder.toString();
    }

    public static int numberOfTrailingZerosSigned(long[] lArray) {
        int n = 0;
        while (n != lArray.length) {
            if (lArray[n] != 0L) {
                return Long.numberOfTrailingZeros(lArray[n]) + n * 64;
            }
            ++n;
        }
        return -1;
    }

    public static int numberOfTrailingZeros(long[] lArray) {
        int n = 0;
        while (n != lArray.length) {
            if (lArray[n] != 0L) {
                return Long.numberOfTrailingZeros(lArray[n]) + n * 64;
            }
            ++n;
        }
        return n * 64;
    }

    public static int numberOfTrailingZerosSigned(long l) {
        return Long.numberOfTrailingZeros(l);
    }

    public static int numberOfTrailingZeros(long l) {
        return Long.numberOfTrailingZeros(l);
    }

    public static int numberOfTrailingZeros(int n) {
        return Integer.numberOfTrailingZeros(n);
    }

    public static int numberOfLeadingZerosSigned(long[] lArray) {
        int n = 0;
        int n2 = lArray.length - 1;
        while (n != lArray.length) {
            if (lArray[n2] != 0L) {
                return Long.numberOfLeadingZeros(lArray[n2]) + n * 64;
            }
            ++n;
            --n2;
        }
        return -1;
    }

    public static int numberOfLeadingZeros(long[] lArray) {
        int n = 0;
        int n2 = lArray.length - 1;
        while (n != lArray.length) {
            if (lArray[n2] != 0L) {
                return Long.numberOfLeadingZeros(lArray[n2]) + n * 64;
            }
            ++n;
            --n2;
        }
        return n * 64;
    }

    public static int numberOfLeadingZerosSigned(long l) {
        if (l == 0L) {
            return -1;
        }
        return Long.numberOfLeadingZeros(l);
    }

    public static int numberOfLeadingZerosSigned(int n) {
        if (n == 0) {
            return -1;
        }
        return Integer.numberOfLeadingZeros(n);
    }

    public static int numberOfLeadingZeros(long l) {
        return Long.numberOfLeadingZeros(l);
    }

    public static int numberOfLeadingZeros(int n) {
        return Integer.numberOfLeadingZeros(n);
    }

    public static int previousSetBit(long l, int n) {
        if (n == -1 || n >= 64) {
            return -1;
        }
        long l2 = l & -1L >>> n;
        if (l2 == 0L) {
            return -1;
        }
        return 63 - Long.numberOfLeadingZeros(l2);
    }

    public static int previousSetBit(long[] lArray, int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >>> 6;
        if (n2 >= lArray.length) {
            return BitsUtil.magnitude(lArray) - 1;
        }
        int n3 = 63 - (n & 0x3F);
        long l = lArray[n2] & -1L >>> n3;
        while (l == 0L) {
            if (n2 == 0) {
                return -1;
            }
            l = lArray[--n2];
        }
        return (n2 + 1) * 64 - 1 - Long.numberOfLeadingZeros(l);
    }

    public static int previousClearBit(long l, int n) {
        if (n < 0 || n >= 64) {
            return -1;
        }
        long l2 = (l ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> n;
        if (l2 == 0L) {
            return -1;
        }
        return 63 - Long.numberOfTrailingZeros(l2);
    }

    public static int previousClearBit(long[] lArray, int n) {
        if (n == -1) {
            return -1;
        }
        int n2 = n >>> 6;
        if (n2 >= lArray.length) {
            return BitsUtil.magnitude(lArray);
        }
        int n3 = 65 - (n & 0x3F);
        long l = (lArray[n2] ^ 0xFFFFFFFFFFFFFFFFL) & -1L >>> n3;
        while (l == 0L) {
            if (n2 == 0) {
                return -1;
            }
            l = lArray[--n2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return (n2 + 1) * 64 - 1 - Long.numberOfTrailingZeros(l);
    }

    public static int nextSetBit(long l, int n) {
        if (n >= 64) {
            return -1;
        }
        long l2 = l & -1L << n;
        if (l2 == 0L) {
            return -1;
        }
        return Long.numberOfTrailingZeros(l2);
    }

    public static int nextSetBit(long[] lArray, int n) {
        int n2 = n >>> 6;
        if (n2 >= lArray.length) {
            return -1;
        }
        long l = lArray[n2] & -1L << n;
        while (l == 0L) {
            if (++n2 == lArray.length) {
                return -1;
            }
            l = lArray[n2];
        }
        return n2 * 64 + Long.numberOfTrailingZeros(l);
    }

    public static int nextClearBit(long l, int n) {
        if (n >= 64) {
            return -1;
        }
        long l2 = (l ^ 0xFFFFFFFFFFFFFFFFL) & -1L << n;
        if (l2 == 0L) {
            return -1;
        }
        return Long.numberOfTrailingZeros(l2);
    }

    public static int nextClearBit(long[] lArray, int n) {
        int n2 = n >>> 6;
        if (n2 >= lArray.length) {
            return -1;
        }
        long l = (lArray[n2] ^ 0xFFFFFFFFFFFFFFFFL) & -1L << n;
        while (n2 < lArray.length) {
            if (l != 0L) {
                return n2 * 64 + Long.numberOfTrailingZeros(l);
            }
            l = lArray[++n2] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return -1;
    }

    public static int magnitude(long[] lArray) {
        int n = BitsUtil.numberOfLeadingZeros(lArray);
        return BitsUtil.capacity(lArray) - n;
    }

    public static int magnitude(long l) {
        return 64 - Long.numberOfLeadingZeros(l);
    }

    public static int magnitude(int n) {
        return 32 - Integer.numberOfLeadingZeros(n);
    }

    public static boolean intersect(long l, long l2) {
        return (l & l2) != 0L;
    }

    public static boolean intersect(long[] lArray, long[] lArray2) {
        int n = lArray.length < lArray2.length ? lArray.length : lArray2.length;
        for (int i = 0; i < n; ++i) {
            if ((lArray[i] & lArray2[i]) == 0L) continue;
            return true;
        }
        return false;
    }

    public static int intersectionSize(long l, long l2) {
        return Long.bitCount(l & l2);
    }

    public static int intersectionSize(long[] lArray, long[] lArray2) {
        int n = lArray.length;
        int n2 = lArray2.length;
        int n3 = n < n2 ? n : n2;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            n4 += Long.bitCount(lArray[i] & lArray2[i]);
        }
        return n4;
    }

    public static int unionSize(long l, long l2) {
        return Long.bitCount(l | l2);
    }

    public static int unionSize(long[] lArray, long[] lArray2) {
        int n;
        int n2 = lArray.length;
        int n3 = lArray2.length;
        int n4 = n2 < n3 ? n2 : n3;
        int n5 = 0;
        for (n = 0; n < n4; ++n) {
            n5 += Long.bitCount(lArray[n] | lArray2[n]);
        }
        while (n < n2) {
            n5 += Long.bitCount(lArray[n]);
            ++n;
        }
        while (n < n3) {
            n5 += Long.bitCount(lArray2[n]);
            ++n;
        }
        return n5;
    }

    public static int hammingDistance(long l, long l2) {
        return Long.bitCount(l ^ l2);
    }

    public static int hammingDistance(long[] lArray, long[] lArray2) {
        int n;
        int n2 = lArray.length;
        int n3 = lArray2.length;
        int n4 = n2 < n3 ? n2 : n3;
        int n5 = 0;
        for (n = 0; n < n4; ++n) {
            n5 += Long.bitCount(lArray[n] ^ lArray2[n]);
        }
        while (n < n2) {
            n5 += Long.bitCount(lArray[n]);
            ++n;
        }
        while (n < n3) {
            n5 += Long.bitCount(lArray2[n]);
            ++n;
        }
        return n5;
    }

    public static int capacity(long[] lArray) {
        return lArray.length * 64;
    }

    public static boolean equal(long[] lArray, long[] lArray2) {
        int n;
        if (lArray == null || lArray2 == null) {
            return lArray == null && lArray2 == null;
        }
        int n2 = Math.min(lArray.length, lArray2.length) - 1;
        for (n = lArray.length - 1; n > n2; --n) {
            if (lArray[n] == 0L) continue;
            return false;
        }
        for (n = lArray2.length - 1; n > n2; --n) {
            if (lArray2[n] == 0L) continue;
            return false;
        }
        while (n2 >= 0) {
            if (lArray[n2] != lArray2[n2]) {
                return false;
            }
            --n2;
        }
        return true;
    }

    public static int compare(long[] lArray, long[] lArray2) {
        int n;
        if (lArray == null) {
            return lArray2 == null ? 0 : -1;
        }
        if (lArray2 == null) {
            return 1;
        }
        int n2 = Math.min(lArray.length, lArray2.length) - 1;
        for (n = lArray.length - 1; n > n2; --n) {
            if (lArray[n] == 0L) continue;
            return 1;
        }
        for (n = lArray2.length - 1; n > n2; --n) {
            if (lArray2[n] == 0L) continue;
            return -1;
        }
        while (n2 >= 0) {
            long l = lArray[n2];
            long l2 = lArray2[n2];
            if (l != l2) {
                if (l < 0L) {
                    if (l2 < 0L) {
                        return l2 < l ? -1 : (l2 == l ? 0 : 1);
                    }
                    return 1;
                }
                if (l2 < 0L) {
                    return -1;
                }
                return l < l2 ? -1 : (l == l2 ? 0 : 1);
            }
            --n2;
        }
        return 0;
    }

    public static int hashCode(long l) {
        long l2 = 0x76543210L ^ l;
        return (int)(l2 >> 32 ^ l2);
    }

    public static int hashCode(long[] lArray) {
        long l = 1985229328L;
        int n = 0;
        while (n < lArray.length) {
            l ^= lArray[n] * (long)(++n);
        }
        return (int)(l >> 32 ^ l);
    }

    public static double lpow2(long l, int n) {
        long l2;
        if (l == 0L) {
            return 0.0;
        }
        if (l == Long.MIN_VALUE) {
            return BitsUtil.lpow2(-4611686018427387904L, n + 1);
        }
        if (l < 0L) {
            return -BitsUtil.lpow2(-l, n);
        }
        assert (l >= 0L);
        int n2 = BitsUtil.magnitude(l);
        int n3 = n2 - 53;
        long l3 = 1075L + (long)n + (long)n3;
        if (l3 >= 2047L) {
            return Double.POSITIVE_INFINITY;
        }
        if (l3 <= 0L) {
            if (l3 <= -54L) {
                return 0.0;
            }
            return BitsUtil.lpow2(l, n + 54) / 1.8014398509481984E16;
        }
        long l4 = l2 = n3 > 0 ? (l >> n3) + (l >> n3 - 1 & 1L) : l << -n3;
        if (l2 >> 52 != 1L && ++l3 >= 2047L) {
            return Double.POSITIVE_INFINITY;
        }
        l2 &= 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(l2 |= l3 << 52);
    }

    public static double lpow10(long l, int n) {
        if (l == 0L) {
            return 0.0;
        }
        if (l == Long.MIN_VALUE) {
            return BitsUtil.lpow10(-922337203685477580L, n + 1);
        }
        if (l < 0L) {
            return -BitsUtil.lpow10(-l, n);
        }
        if (n >= 0) {
            int n2;
            if (n > 308) {
                return Double.POSITIVE_INFINITY;
            }
            long l2 = 0L;
            long l3 = 0L;
            long l4 = l & 0xFFFFFFFFL;
            long l5 = l >>> 32;
            int n3 = 0;
            while (n != 0) {
                n2 = n >= POW5_INT.length ? POW5_INT.length - 1 : n;
                int n4 = POW5_INT[n2];
                if ((int)l2 != 0) {
                    l2 *= (long)n4;
                }
                if ((int)l3 != 0) {
                    l3 *= (long)n4;
                }
                l4 *= (long)n4;
                l5 *= (long)n4;
                l3 &= 0xFFFFFFFFL;
                l4 &= 0xFFFFFFFFL;
                n3 += n2;
                n -= n2;
                long l6 = (l5 += (l4 += (l3 += (l2 &= 0xFFFFFFFFL) >>> 32) >>> 32) >>> 32) >>> 32;
                if (l6 == 0L) continue;
                l2 = l3;
                l3 = l4;
                l4 = l5 & 0xFFFFFFFFL;
                l5 = l6;
                n3 += 32;
            }
            assert (l5 >= 0L);
            n2 = 31 - BitsUtil.magnitude(l5);
            long l7 = n2 < 0 ? l5 << 31 | l4 >>> 1 : (l5 << 32 | l4) << n2 | l3 >>> 32 - n2;
            return BitsUtil.lpow2(l7, n3 -= n2);
        }
        if (n < -344) {
            return 0.0;
        }
        long l8 = l;
        long l9 = 0L;
        int n5 = 0;
        while (true) {
            assert (l8 >= 0L);
            int n6 = 63 - BitsUtil.magnitude(l8);
            l8 <<= n6;
            l8 |= l9 >>> 63 - n6;
            l9 = l9 << n6 & Long.MAX_VALUE;
            n5 -= n6;
            if (n == 0) break;
            int n7 = -n >= POW5_INT.length ? POW5_INT.length - 1 : -n;
            int n8 = POW5_INT[n7];
            long l10 = l8 >>> 32;
            long l11 = l10 / (long)n8;
            long l12 = l10 - l11 * (long)n8;
            long l13 = l12 << 32 | l8 & 0xFFFFFFFFL;
            long l14 = l13 / (long)n8;
            l12 = l13 - l14 * (long)n8;
            l8 = l11 << 32 | l14;
            l10 = l12 << 31 | l9 >>> 32;
            l11 = l10 / (long)n8;
            l12 = l10 - l11 * (long)n8;
            l13 = l12 << 32 | l9 & 0xFFFFFFFFL;
            l14 = l13 / (long)n8;
            l9 = l11 << 32 | l14;
            n += n7;
            n5 -= n7;
        }
        return BitsUtil.lpow2(l8, n5);
    }
}

